/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.factory;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Supplier;
import com.facebook.common.internal.Suppliers;
import com.facebook.common.time.MonotonicClock;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.fresco.animation.backend.AnimationBackendDelegateWithInactivityCheck;
import com.facebook.fresco.animation.backend.AnimationInformation;
import com.facebook.fresco.animation.bitmap.BitmapAnimationBackend;
import com.facebook.fresco.animation.bitmap.BitmapFrameCache;
import com.facebook.fresco.animation.bitmap.BitmapFrameRenderer;
import com.facebook.fresco.animation.bitmap.cache.AnimationFrameCacheKey;
import com.facebook.fresco.animation.bitmap.cache.FrescoFrameCache;
import com.facebook.fresco.animation.bitmap.cache.KeepLastFrameCache;
import com.facebook.fresco.animation.bitmap.cache.NoOpCache;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparationStrategy;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparer;
import com.facebook.fresco.animation.bitmap.preparation.DefaultBitmapFramePreparer;
import com.facebook.fresco.animation.bitmap.preparation.FixedNumberBitmapFramePreparationStrategy;
import com.facebook.fresco.animation.bitmap.preparation.FrameLoaderStrategy;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.FrameLoaderFactory;
import com.facebook.fresco.animation.bitmap.wrapper.AnimatedDrawableBackendAnimationInformation;
import com.facebook.fresco.animation.bitmap.wrapper.AnimatedDrawableBackendFrameRenderer;
import com.facebook.fresco.animation.drawable.AnimatedDrawable2;
import com.facebook.fresco.animation.drawable.KAnimatedDrawable2;
import com.facebook.fresco.vito.options.ImageOptions;
import com.facebook.fresco.vito.options.ImageOptionsDrawableFactory;
import com.facebook.fresco.vito.options.RoundingOptions;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableBackend;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.base.AnimatedImageResult;
import com.facebook.imagepipeline.animated.impl.AnimatedDrawableBackendProvider;
import com.facebook.imagepipeline.animated.impl.AnimatedFrameCache;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.cache.CountingMemoryCache;
import com.facebook.imagepipeline.drawable.DrawableFactory;
import com.facebook.imagepipeline.image.CloseableAnimatedImage;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.infer.annotation.Nullsafe;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class DefaultBitmapAnimationDrawableFactory
implements DrawableFactory,
ImageOptionsDrawableFactory {
    public static final int CACHING_STRATEGY_NO_CACHE = 0;
    public static final int CACHING_STRATEGY_FRESCO_CACHE = 1;
    public static final int CACHING_STRATEGY_FRESCO_CACHE_NO_REUSING = 2;
    public static final int CACHING_STRATEGY_KEEP_LAST_CACHE = 3;
    private final AnimatedDrawableBackendProvider mAnimatedDrawableBackendProvider;
    private final ScheduledExecutorService mScheduledExecutorServiceForUiThread;
    private final ExecutorService mExecutorServiceForFramePreparing;
    private final MonotonicClock mMonotonicClock;
    private final PlatformBitmapFactory mPlatformBitmapFactory;
    private final CountingMemoryCache<CacheKey, CloseableImage> mBackingCache;
    private final Supplier<Integer> mCachingStrategySupplier;
    private final Supplier<Integer> mNumberOfFramesToPrepareSupplier;
    private final Supplier<Boolean> mUseDeepEqualsForCacheKey;
    private final Supplier<Boolean> mUseNewBitmapRender;
    private final Supplier<Boolean> mDownscaleFrameToDrawableDimensions;
    private final Supplier<Integer> mAnimationFpsLimit;
    private final Supplier<Integer> mBufferLengthMilliseconds;
    private final Supplier<Boolean> useRendererAnimatedDrawable = Suppliers.BOOLEAN_FALSE;

    public DefaultBitmapAnimationDrawableFactory(AnimatedDrawableBackendProvider animatedDrawableBackendProvider, ScheduledExecutorService scheduledExecutorServiceForUiThread, ExecutorService executorServiceForFramePreparing, MonotonicClock monotonicClock, PlatformBitmapFactory platformBitmapFactory, CountingMemoryCache<CacheKey, CloseableImage> backingCache, Supplier<Integer> cachingStrategySupplier, Supplier<Integer> numberOfFramesToPrepareSupplier, Supplier<Boolean> useDeepEqualsForCacheKey, Supplier<Boolean> useNewBitmapRender, Supplier<Boolean> downscaleFrameToDrawableDimensions, Supplier<Integer> animationFpsLimit, Supplier<Integer> bufferLengthMilliseconds) {
        this.mAnimatedDrawableBackendProvider = animatedDrawableBackendProvider;
        this.mScheduledExecutorServiceForUiThread = scheduledExecutorServiceForUiThread;
        this.mExecutorServiceForFramePreparing = executorServiceForFramePreparing;
        this.mMonotonicClock = monotonicClock;
        this.mPlatformBitmapFactory = platformBitmapFactory;
        this.mBackingCache = backingCache;
        this.mCachingStrategySupplier = cachingStrategySupplier;
        this.mNumberOfFramesToPrepareSupplier = numberOfFramesToPrepareSupplier;
        this.mUseDeepEqualsForCacheKey = useDeepEqualsForCacheKey;
        this.mUseNewBitmapRender = useNewBitmapRender;
        this.mAnimationFpsLimit = animationFpsLimit;
        this.mDownscaleFrameToDrawableDimensions = downscaleFrameToDrawableDimensions;
        this.mBufferLengthMilliseconds = bufferLengthMilliseconds;
    }

    public boolean supportsImageType(CloseableImage image) {
        return image instanceof CloseableAnimatedImage;
    }

    @Nullable
    public Drawable createDrawable(CloseableImage image) {
        if (!this.supportsImageType(image)) {
            return null;
        }
        CloseableAnimatedImage closeable = (CloseableAnimatedImage)image;
        AnimatedImage animatedImage = closeable.getImage();
        AnimationBackend animationBackend = this.createAnimationBackend((AnimatedImageResult)Preconditions.checkNotNull((Object)closeable.getImageResult()), animatedImage != null ? animatedImage.getAnimatedBitmapConfig() : null, null);
        if (((Boolean)this.useRendererAnimatedDrawable.get()).booleanValue()) {
            return new KAnimatedDrawable2(animationBackend);
        }
        return new AnimatedDrawable2(animationBackend);
    }

    @Nullable
    public Drawable createDrawable(Resources resources, CloseableImage closeableImage, ImageOptions imageOptions) {
        if (!this.supportsImageType(closeableImage)) {
            return null;
        }
        CloseableAnimatedImage closeable = (CloseableAnimatedImage)closeableImage;
        AnimatedImage animatedImage = closeable.getImage();
        AnimationBackend animationBackend = null;
        try {
            animationBackend = this.createAnimationBackend((AnimatedImageResult)Preconditions.checkNotNull((Object)closeable.getImageResult()), animatedImage != null ? animatedImage.getAnimatedBitmapConfig() : null, imageOptions);
        }
        catch (NullPointerException e) {
            Object uri = closeableImage.getExtra("uri_source");
            if (uri != null) {
                throw new NullPointerException(e.getMessage() + " uri=" + uri.toString());
            }
            throw e;
        }
        if (((Boolean)this.useRendererAnimatedDrawable.get()).booleanValue()) {
            return new KAnimatedDrawable2(animationBackend);
        }
        return new AnimatedDrawable2(animationBackend);
    }

    private AnimationBackend createAnimationBackend(AnimatedImageResult animatedImageResult, @Nullable Bitmap.Config animatedBitmapConfig, @Nullable ImageOptions imageOptions) {
        AnimatedDrawableBackend animatedDrawableBackend = this.createAnimatedDrawableBackend(animatedImageResult);
        AnimatedDrawableBackendAnimationInformation animationInfo = new AnimatedDrawableBackendAnimationInformation(animatedDrawableBackend);
        BitmapFrameCache bitmapFrameCache = this.createBitmapFrameCache(animatedImageResult);
        AnimatedDrawableBackendFrameRenderer bitmapFrameRenderer = new AnimatedDrawableBackendFrameRenderer(bitmapFrameCache, animatedDrawableBackend, (Boolean)this.mUseNewBitmapRender.get());
        int numberOfFramesToPrefetch = (Integer)this.mNumberOfFramesToPrepareSupplier.get();
        FixedNumberBitmapFramePreparationStrategy bitmapFramePreparationStrategy = null;
        BitmapFramePreparer bitmapFramePreparer = null;
        if (numberOfFramesToPrefetch > 0) {
            bitmapFramePreparationStrategy = new FixedNumberBitmapFramePreparationStrategy(numberOfFramesToPrefetch);
            bitmapFramePreparer = this.createBitmapFramePreparer(bitmapFrameRenderer, animatedBitmapConfig);
        }
        RoundingOptions roundingOptions = null;
        if (imageOptions != null) {
            roundingOptions = imageOptions.getRoundingOptions();
        }
        if (((Boolean)this.mUseNewBitmapRender.get()).booleanValue()) {
            bitmapFramePreparationStrategy = new FrameLoaderStrategy(animatedImageResult.getSource(), (AnimationInformation)animationInfo, (BitmapFrameRenderer)bitmapFrameRenderer, new FrameLoaderFactory(this.mPlatformBitmapFactory, ((Integer)this.mAnimationFpsLimit.get()).intValue(), ((Integer)this.mBufferLengthMilliseconds.get()).intValue()), ((Boolean)this.mDownscaleFrameToDrawableDimensions.get()).booleanValue());
        }
        BitmapAnimationBackend bitmapAnimationBackend = new BitmapAnimationBackend(this.mPlatformBitmapFactory, bitmapFrameCache, (AnimationInformation)animationInfo, (BitmapFrameRenderer)bitmapFrameRenderer, ((Boolean)this.mUseNewBitmapRender.get()).booleanValue(), (BitmapFramePreparationStrategy)bitmapFramePreparationStrategy, bitmapFramePreparer, roundingOptions);
        return AnimationBackendDelegateWithInactivityCheck.createForBackend((AnimationBackend)bitmapAnimationBackend, (MonotonicClock)this.mMonotonicClock, (ScheduledExecutorService)this.mScheduledExecutorServiceForUiThread);
    }

    private BitmapFramePreparer createBitmapFramePreparer(BitmapFrameRenderer bitmapFrameRenderer, @Nullable Bitmap.Config animatedBitmapConig) {
        return new DefaultBitmapFramePreparer(this.mPlatformBitmapFactory, bitmapFrameRenderer, animatedBitmapConig != null ? animatedBitmapConig : Bitmap.Config.ARGB_8888, this.mExecutorServiceForFramePreparing);
    }

    private AnimatedDrawableBackend createAnimatedDrawableBackend(AnimatedImageResult animatedImageResult) {
        AnimatedImage animatedImage = animatedImageResult.getImage();
        Rect initialBounds = new Rect(0, 0, animatedImage.getWidth(), animatedImage.getHeight());
        return this.mAnimatedDrawableBackendProvider.get(animatedImageResult, initialBounds);
    }

    private BitmapFrameCache createBitmapFrameCache(AnimatedImageResult animatedImageResult) {
        switch ((Integer)this.mCachingStrategySupplier.get()) {
            case 1: {
                return new FrescoFrameCache(this.createAnimatedFrameCache(animatedImageResult), true);
            }
            case 2: {
                return new FrescoFrameCache(this.createAnimatedFrameCache(animatedImageResult), false);
            }
            case 3: {
                return new KeepLastFrameCache();
            }
        }
        return new NoOpCache();
    }

    private AnimatedFrameCache createAnimatedFrameCache(AnimatedImageResult animatedImageResult) {
        return new AnimatedFrameCache(new AnimationFrameCacheKey(animatedImageResult.hashCode(), (Boolean)this.mUseDeepEqualsForCacheKey.get()), this.mBackingCache);
    }
}

