/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.factory;

import android.graphics.Bitmap;
import android.graphics.Rect;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.Supplier;
import com.facebook.common.time.MonotonicClock;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.fresco.animation.backend.AnimationBackendDelegateWithInactivityCheck;
import com.facebook.fresco.animation.backend.AnimationInformation;
import com.facebook.fresco.animation.bitmap.BitmapAnimationBackend;
import com.facebook.fresco.animation.bitmap.BitmapFrameCache;
import com.facebook.fresco.animation.bitmap.BitmapFrameRenderer;
import com.facebook.fresco.animation.bitmap.cache.AnimationFrameCacheKey;
import com.facebook.fresco.animation.bitmap.cache.FrescoFrameCache;
import com.facebook.fresco.animation.bitmap.cache.KeepLastFrameCache;
import com.facebook.fresco.animation.bitmap.cache.NoOpCache;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparationStrategy;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparer;
import com.facebook.fresco.animation.bitmap.preparation.DefaultBitmapFramePreparer;
import com.facebook.fresco.animation.bitmap.preparation.FixedNumberBitmapFramePreparationStrategy;
import com.facebook.fresco.animation.bitmap.wrapper.AnimatedDrawableBackendAnimationInformation;
import com.facebook.fresco.animation.bitmap.wrapper.AnimatedDrawableBackendFrameRenderer;
import com.facebook.fresco.animation.drawable.AnimatedDrawable2;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableBackend;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.base.AnimatedImageResult;
import com.facebook.imagepipeline.animated.impl.AnimatedDrawableBackendProvider;
import com.facebook.imagepipeline.animated.impl.AnimatedFrameCache;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.cache.CountingMemoryCache;
import com.facebook.imagepipeline.drawable.DrawableFactory;
import com.facebook.imagepipeline.image.CloseableAnimatedImage;
import com.facebook.imagepipeline.image.CloseableImage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class ExperimentalBitmapAnimationDrawableFactory
implements DrawableFactory {
    public static final int CACHING_STRATEGY_NO_CACHE = 0;
    public static final int CACHING_STRATEGY_FRESCO_CACHE = 1;
    public static final int CACHING_STRATEGY_FRESCO_CACHE_NO_REUSING = 2;
    public static final int CACHING_STRATEGY_KEEP_LAST_CACHE = 3;
    private final AnimatedDrawableBackendProvider mAnimatedDrawableBackendProvider;
    private final ScheduledExecutorService mScheduledExecutorServiceForUiThread;
    private final ExecutorService mExecutorServiceForFramePreparing;
    private final MonotonicClock mMonotonicClock;
    private final PlatformBitmapFactory mPlatformBitmapFactory;
    private final CountingMemoryCache<CacheKey, CloseableImage> mBackingCache;
    private final Supplier<Integer> mCachingStrategySupplier;
    private final Supplier<Integer> mNumberOfFramesToPrepareSupplier;

    public ExperimentalBitmapAnimationDrawableFactory(AnimatedDrawableBackendProvider animatedDrawableBackendProvider, ScheduledExecutorService scheduledExecutorServiceForUiThread, ExecutorService executorServiceForFramePreparing, MonotonicClock monotonicClock, PlatformBitmapFactory platformBitmapFactory, CountingMemoryCache<CacheKey, CloseableImage> backingCache, Supplier<Integer> cachingStrategySupplier, Supplier<Integer> numberOfFramesToPrepareSupplier) {
        this.mAnimatedDrawableBackendProvider = animatedDrawableBackendProvider;
        this.mScheduledExecutorServiceForUiThread = scheduledExecutorServiceForUiThread;
        this.mExecutorServiceForFramePreparing = executorServiceForFramePreparing;
        this.mMonotonicClock = monotonicClock;
        this.mPlatformBitmapFactory = platformBitmapFactory;
        this.mBackingCache = backingCache;
        this.mCachingStrategySupplier = cachingStrategySupplier;
        this.mNumberOfFramesToPrepareSupplier = numberOfFramesToPrepareSupplier;
    }

    public boolean supportsImageType(CloseableImage image) {
        return image instanceof CloseableAnimatedImage;
    }

    public AnimatedDrawable2 createDrawable(CloseableImage image) {
        return new AnimatedDrawable2(this.createAnimationBackend(((CloseableAnimatedImage)image).getImageResult()));
    }

    private AnimationBackend createAnimationBackend(AnimatedImageResult animatedImageResult) {
        AnimatedDrawableBackend animatedDrawableBackend = this.createAnimatedDrawableBackend(animatedImageResult);
        BitmapFrameCache bitmapFrameCache = this.createBitmapFrameCache(animatedImageResult);
        AnimatedDrawableBackendFrameRenderer bitmapFrameRenderer = new AnimatedDrawableBackendFrameRenderer(bitmapFrameCache, animatedDrawableBackend);
        int numberOfFramesToPrefetch = (Integer)this.mNumberOfFramesToPrepareSupplier.get();
        FixedNumberBitmapFramePreparationStrategy bitmapFramePreparationStrategy = null;
        BitmapFramePreparer bitmapFramePreparer = null;
        if (numberOfFramesToPrefetch > 0) {
            bitmapFramePreparationStrategy = new FixedNumberBitmapFramePreparationStrategy(numberOfFramesToPrefetch);
            bitmapFramePreparer = this.createBitmapFramePreparer(bitmapFrameRenderer);
        }
        BitmapAnimationBackend bitmapAnimationBackend = new BitmapAnimationBackend(this.mPlatformBitmapFactory, bitmapFrameCache, (AnimationInformation)new AnimatedDrawableBackendAnimationInformation(animatedDrawableBackend), (BitmapFrameRenderer)bitmapFrameRenderer, (BitmapFramePreparationStrategy)bitmapFramePreparationStrategy, bitmapFramePreparer);
        return AnimationBackendDelegateWithInactivityCheck.createForBackend((AnimationBackend)bitmapAnimationBackend, (MonotonicClock)this.mMonotonicClock, (ScheduledExecutorService)this.mScheduledExecutorServiceForUiThread);
    }

    private BitmapFramePreparer createBitmapFramePreparer(BitmapFrameRenderer bitmapFrameRenderer) {
        return new DefaultBitmapFramePreparer(this.mPlatformBitmapFactory, bitmapFrameRenderer, Bitmap.Config.ARGB_8888, this.mExecutorServiceForFramePreparing);
    }

    private AnimatedDrawableBackend createAnimatedDrawableBackend(AnimatedImageResult animatedImageResult) {
        AnimatedImage animatedImage = animatedImageResult.getImage();
        Rect initialBounds = new Rect(0, 0, animatedImage.getWidth(), animatedImage.getHeight());
        return this.mAnimatedDrawableBackendProvider.get(animatedImageResult, initialBounds);
    }

    private BitmapFrameCache createBitmapFrameCache(AnimatedImageResult animatedImageResult) {
        switch ((Integer)this.mCachingStrategySupplier.get()) {
            case 1: {
                return new FrescoFrameCache(this.createAnimatedFrameCache(animatedImageResult), true);
            }
            case 2: {
                return new FrescoFrameCache(this.createAnimatedFrameCache(animatedImageResult), false);
            }
            case 3: {
                return new KeepLastFrameCache();
            }
        }
        return new NoOpCache();
    }

    private AnimatedFrameCache createAnimatedFrameCache(AnimatedImageResult animatedImageResult) {
        return new AnimatedFrameCache(new AnimationFrameCacheKey(animatedImageResult.hashCode()), this.mBackingCache);
    }
}

