/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.image;

import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.image.CloseableBitmap;
import com.facebook.imageutils.BitmapUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CloseableAnimatedBitmap
extends CloseableBitmap {
    @GuardedBy(value="this")
    private List<CloseableReference<Bitmap>> mBitmapReferences;
    private volatile List<Bitmap> mBitmaps;
    private volatile List<Integer> mDurations;

    public CloseableAnimatedBitmap(List<CloseableReference<Bitmap>> bitmapReferences, List<Integer> durations) {
        Preconditions.checkNotNull(bitmapReferences);
        Preconditions.checkState((bitmapReferences.size() >= 1 ? 1 : 0) != 0, (Object)"Need at least 1 frame!");
        this.mBitmapReferences = new ArrayList<CloseableReference<Bitmap>>(bitmapReferences.size());
        this.mBitmaps = new ArrayList<Bitmap>(bitmapReferences.size());
        for (CloseableReference<Bitmap> bitmapReference : bitmapReferences) {
            this.mBitmapReferences.add((CloseableReference<Bitmap>)bitmapReference.clone());
            this.mBitmaps.add((Bitmap)bitmapReference.get());
        }
        this.mDurations = (List)Preconditions.checkNotNull(durations);
        Preconditions.checkState((this.mDurations.size() == this.mBitmaps.size() ? 1 : 0) != 0, (Object)"Arrays length mismatch!");
    }

    public CloseableAnimatedBitmap(List<Bitmap> bitmaps, List<Integer> durations, ResourceReleaser<Bitmap> resourceReleaser) {
        Preconditions.checkNotNull(bitmaps);
        Preconditions.checkState((bitmaps.size() >= 1 ? 1 : 0) != 0, (Object)"Need at least 1 frame!");
        this.mBitmaps = new ArrayList<Bitmap>(bitmaps.size());
        this.mBitmapReferences = new ArrayList<CloseableReference<Bitmap>>(bitmaps.size());
        for (Bitmap bitmap : bitmaps) {
            this.mBitmapReferences.add((CloseableReference<Bitmap>)CloseableReference.of((Object)bitmap, resourceReleaser));
            this.mBitmaps.add(bitmap);
        }
        this.mDurations = (List)Preconditions.checkNotNull(durations);
        Preconditions.checkState((this.mDurations.size() == this.mBitmaps.size() ? 1 : 0) != 0, (Object)"Arrays length mismatch!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<CloseableReference<Bitmap>> bitmapReferences;
        CloseableAnimatedBitmap closeableAnimatedBitmap = this;
        synchronized (closeableAnimatedBitmap) {
            if (this.mBitmapReferences == null) {
                return;
            }
            bitmapReferences = this.mBitmapReferences;
            this.mBitmapReferences = null;
            this.mBitmaps = null;
            this.mDurations = null;
        }
        CloseableReference.closeSafely(bitmapReferences);
    }

    public synchronized boolean isClosed() {
        return this.mBitmaps == null;
    }

    public List<Bitmap> getBitmaps() {
        return this.mBitmaps;
    }

    public List<Integer> getDurations() {
        return this.mDurations;
    }

    public Bitmap getUnderlyingBitmap() {
        List<Bitmap> bitmaps = this.mBitmaps;
        return bitmaps != null ? bitmaps.get(0) : null;
    }

    public int getSizeInBytes() {
        List<Bitmap> bitmaps = this.mBitmaps;
        if (bitmaps == null || bitmaps.size() == 0) {
            return 0;
        }
        return BitmapUtil.getSizeInBytes((Bitmap)bitmaps.get(0)) * bitmaps.size();
    }

    public int getWidth() {
        List<Bitmap> bitmaps = this.mBitmaps;
        return bitmaps == null ? 0 : bitmaps.get(0).getWidth();
    }

    public int getHeight() {
        List<Bitmap> bitmaps = this.mBitmaps;
        return bitmaps == null ? 0 : bitmaps.get(0).getHeight();
    }
}

