/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.cache;

import android.graphics.Bitmap;
import android.util.SparseArray;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.bitmap.BitmapFrameCache;
import com.facebook.imagepipeline.animated.impl.AnimatedFrameCache;
import com.facebook.imagepipeline.image.CloseableBitmap;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imageutils.BitmapUtil;
import java.io.Closeable;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class FrescoFrameCache
implements BitmapFrameCache {
    private static final Class<?> TAG = FrescoFrameCache.class;
    private final AnimatedFrameCache mAnimatedFrameCache;
    private final boolean mEnableBitmapReusing;
    @GuardedBy(value="this")
    private final SparseArray<CloseableReference<CloseableImage>> mPreparedPendingFrames;
    @Nullable
    @GuardedBy(value="this")
    private CloseableReference<CloseableImage> mLastRenderedItem;

    public FrescoFrameCache(AnimatedFrameCache animatedFrameCache, boolean enableBitmapReusing) {
        this.mAnimatedFrameCache = animatedFrameCache;
        this.mEnableBitmapReusing = enableBitmapReusing;
        this.mPreparedPendingFrames = new SparseArray();
    }

    @Nullable
    public synchronized CloseableReference<Bitmap> getCachedFrame(int frameNumber) {
        return FrescoFrameCache.convertToBitmapReferenceAndClose(this.mAnimatedFrameCache.get(frameNumber));
    }

    @Nullable
    public synchronized CloseableReference<Bitmap> getFallbackFrame(int frameNumber) {
        return FrescoFrameCache.convertToBitmapReferenceAndClose((CloseableReference<CloseableImage>)CloseableReference.cloneOrNull(this.mLastRenderedItem));
    }

    @Nullable
    public synchronized CloseableReference<Bitmap> getBitmapToReuseForFrame(int frameNumber, int width, int height) {
        if (!this.mEnableBitmapReusing) {
            return null;
        }
        return FrescoFrameCache.convertToBitmapReferenceAndClose(this.mAnimatedFrameCache.getForReuse());
    }

    public synchronized boolean contains(int frameNumber) {
        return this.mAnimatedFrameCache.contains(frameNumber);
    }

    public synchronized int getSizeInBytes() {
        return FrescoFrameCache.getBitmapSizeBytes(this.mLastRenderedItem) + this.getPreparedPendingFramesSizeBytes();
    }

    public synchronized void clear() {
        CloseableReference.closeSafely(this.mLastRenderedItem);
        this.mLastRenderedItem = null;
        for (int i = 0; i < this.mPreparedPendingFrames.size(); ++i) {
            CloseableReference.closeSafely((CloseableReference)((CloseableReference)this.mPreparedPendingFrames.valueAt(i)));
        }
        this.mPreparedPendingFrames.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onFrameRendered(int frameNumber, CloseableReference<Bitmap> bitmapReference, int frameType) {
        Preconditions.checkNotNull(bitmapReference);
        this.removePreparedReference(frameNumber);
        CloseableReference<CloseableImage> closableReference = null;
        try {
            closableReference = FrescoFrameCache.createImageReference(bitmapReference);
            if (closableReference != null) {
                CloseableReference.closeSafely(this.mLastRenderedItem);
                this.mLastRenderedItem = this.mAnimatedFrameCache.cache(frameNumber, closableReference);
            }
        }
        finally {
            CloseableReference.closeSafely(closableReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onFramePrepared(int frameNumber, CloseableReference<Bitmap> bitmapReference, int frameType) {
        Preconditions.checkNotNull(bitmapReference);
        CloseableReference<CloseableImage> closableReference = null;
        try {
            closableReference = FrescoFrameCache.createImageReference(bitmapReference);
            if (closableReference == null) {
                return;
            }
            CloseableReference<CloseableImage> newReference = this.mAnimatedFrameCache.cache(frameNumber, closableReference);
            if (CloseableReference.isValid(newReference)) {
                CloseableReference oldReference = (CloseableReference)this.mPreparedPendingFrames.get(frameNumber);
                CloseableReference.closeSafely((CloseableReference)oldReference);
                this.mPreparedPendingFrames.put(frameNumber, newReference);
                FLog.v(TAG, (String)"cachePreparedFrame(%d) cached. Pending frames: %s", (Object)frameNumber, this.mPreparedPendingFrames);
            }
        }
        finally {
            CloseableReference.closeSafely(closableReference);
        }
    }

    public void setFrameCacheListener(BitmapFrameCache.FrameCacheListener frameCacheListener) {
    }

    private synchronized int getPreparedPendingFramesSizeBytes() {
        int size = 0;
        for (int i = 0; i < this.mPreparedPendingFrames.size(); ++i) {
            size += FrescoFrameCache.getBitmapSizeBytes((CloseableReference<CloseableImage>)((CloseableReference)this.mPreparedPendingFrames.valueAt(i)));
        }
        return size;
    }

    private synchronized void removePreparedReference(int frameNumber) {
        CloseableReference existingPendingReference = (CloseableReference)this.mPreparedPendingFrames.get(frameNumber);
        if (existingPendingReference != null) {
            this.mPreparedPendingFrames.delete(frameNumber);
            CloseableReference.closeSafely((CloseableReference)existingPendingReference);
            FLog.v(TAG, (String)"removePreparedReference(%d) removed. Pending frames: %s", (Object)frameNumber, this.mPreparedPendingFrames);
        }
    }

    @Nullable
    @VisibleForTesting
    static CloseableReference<Bitmap> convertToBitmapReferenceAndClose(@Nullable CloseableReference<CloseableImage> closeableImage) {
        try {
            CloseableStaticBitmap closeableStaticBitmap;
            if (CloseableReference.isValid(closeableImage) && closeableImage.get() instanceof CloseableStaticBitmap && (closeableStaticBitmap = (CloseableStaticBitmap)closeableImage.get()) != null) {
                CloseableReference closeableReference = closeableStaticBitmap.cloneUnderlyingBitmapReference();
                return closeableReference;
            }
            CloseableReference<Bitmap> closeableReference = null;
            return closeableReference;
        }
        finally {
            CloseableReference.closeSafely(closeableImage);
        }
    }

    private static int getBitmapSizeBytes(@Nullable CloseableReference<CloseableImage> imageReference) {
        if (!CloseableReference.isValid(imageReference)) {
            return 0;
        }
        return FrescoFrameCache.getBitmapSizeBytes((CloseableImage)imageReference.get());
    }

    private static int getBitmapSizeBytes(@Nullable CloseableImage image) {
        if (!(image instanceof CloseableBitmap)) {
            return 0;
        }
        return BitmapUtil.getSizeInBytes((Bitmap)((CloseableBitmap)image).getUnderlyingBitmap());
    }

    @Nullable
    private static CloseableReference<CloseableImage> createImageReference(CloseableReference<Bitmap> bitmapReference) {
        CloseableStaticBitmap closeableImage = new CloseableStaticBitmap(bitmapReference, ImmutableQualityInfo.FULL_QUALITY, 0);
        return CloseableReference.of((Closeable)closeableImage);
    }
}

