/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.animated.impl;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableBackend;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableFrameInfo;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.base.AnimatedImageFrame;
import com.facebook.imagepipeline.animated.base.AnimatedImageResult;
import com.facebook.imagepipeline.animated.util.AnimatedDrawableUtil;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class AnimatedDrawableBackendImpl
implements AnimatedDrawableBackend {
    private final AnimatedDrawableUtil mAnimatedDrawableUtil;
    private final AnimatedImageResult mAnimatedImageResult;
    private final AnimatedImage mAnimatedImage;
    private final Rect mRenderedBounds;
    private final int[] mFrameDurationsMs;
    private final int[] mFrameTimestampsMs;
    private final int mDurationMs;
    private final AnimatedDrawableFrameInfo[] mFrameInfos;
    private final Rect mRenderSrcRect = new Rect();
    private final Rect mRenderDstRect = new Rect();
    @Nullable
    @GuardedBy(value="this")
    private Bitmap mTempBitmap;

    public AnimatedDrawableBackendImpl(AnimatedDrawableUtil animatedDrawableUtil, AnimatedImageResult animatedImageResult, Rect bounds) {
        this.mAnimatedDrawableUtil = animatedDrawableUtil;
        this.mAnimatedImageResult = animatedImageResult;
        this.mAnimatedImage = animatedImageResult.getImage();
        this.mFrameDurationsMs = this.mAnimatedImage.getFrameDurations();
        this.mAnimatedDrawableUtil.fixFrameDurations(this.mFrameDurationsMs);
        this.mDurationMs = this.mAnimatedDrawableUtil.getTotalDurationFromFrameDurations(this.mFrameDurationsMs);
        this.mFrameTimestampsMs = this.mAnimatedDrawableUtil.getFrameTimeStampsFromDurations(this.mFrameDurationsMs);
        this.mRenderedBounds = AnimatedDrawableBackendImpl.getBoundsToUse(this.mAnimatedImage, bounds);
        this.mFrameInfos = new AnimatedDrawableFrameInfo[this.mAnimatedImage.getFrameCount()];
        for (int i = 0; i < this.mAnimatedImage.getFrameCount(); ++i) {
            this.mFrameInfos[i] = this.mAnimatedImage.getFrameInfo(i);
        }
    }

    private static Rect getBoundsToUse(AnimatedImage image, Rect targetBounds) {
        if (targetBounds == null) {
            return new Rect(0, 0, image.getWidth(), image.getHeight());
        }
        return new Rect(0, 0, Math.min(targetBounds.width(), image.getWidth()), Math.min(targetBounds.height(), image.getHeight()));
    }

    @Override
    public AnimatedImageResult getAnimatedImageResult() {
        return this.mAnimatedImageResult;
    }

    @Override
    public int getDurationMs() {
        return this.mDurationMs;
    }

    @Override
    public int getFrameCount() {
        return this.mAnimatedImage.getFrameCount();
    }

    @Override
    public int getLoopCount() {
        return this.mAnimatedImage.getLoopCount();
    }

    @Override
    public int getWidth() {
        return this.mAnimatedImage.getWidth();
    }

    @Override
    public int getHeight() {
        return this.mAnimatedImage.getHeight();
    }

    @Override
    public int getRenderedWidth() {
        return this.mRenderedBounds.width();
    }

    @Override
    public int getRenderedHeight() {
        return this.mRenderedBounds.height();
    }

    @Override
    public AnimatedDrawableFrameInfo getFrameInfo(int frameNumber) {
        return this.mFrameInfos[frameNumber];
    }

    @Override
    public int getFrameForTimestampMs(int timestampMs) {
        return this.mAnimatedDrawableUtil.getFrameForTimestampMs(this.mFrameTimestampsMs, timestampMs);
    }

    @Override
    public int getTimestampMsForFrame(int frameNumber) {
        Preconditions.checkElementIndex((int)frameNumber, (int)this.mFrameTimestampsMs.length);
        return this.mFrameTimestampsMs[frameNumber];
    }

    @Override
    public int getDurationMsForFrame(int frameNumber) {
        return this.mFrameDurationsMs[frameNumber];
    }

    @Override
    public int getFrameForPreview() {
        return this.mAnimatedImageResult.getFrameForPreview();
    }

    @Override
    public AnimatedDrawableBackend forNewBounds(Rect bounds) {
        Rect boundsToUse = AnimatedDrawableBackendImpl.getBoundsToUse(this.mAnimatedImage, bounds);
        if (boundsToUse.equals((Object)this.mRenderedBounds)) {
            return this;
        }
        return new AnimatedDrawableBackendImpl(this.mAnimatedDrawableUtil, this.mAnimatedImageResult, bounds);
    }

    @Override
    public synchronized int getMemoryUsage() {
        int bytes = 0;
        if (this.mTempBitmap != null) {
            bytes += this.mAnimatedDrawableUtil.getSizeOfBitmap(this.mTempBitmap);
        }
        return bytes += this.mAnimatedImage.getSizeInBytes();
    }

    @Override
    public CloseableReference<Bitmap> getPreDecodedFrame(int frameNumber) {
        return this.mAnimatedImageResult.getDecodedFrame(frameNumber);
    }

    @Override
    public boolean hasPreDecodedFrame(int index) {
        return this.mAnimatedImageResult.hasDecodedFrame(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderFrame(int frameNumber, Canvas canvas) {
        AnimatedImageFrame frame = this.mAnimatedImage.getFrame(frameNumber);
        try {
            if (this.mAnimatedImage.doesRenderSupportScaling()) {
                this.renderImageSupportsScaling(canvas, frame);
            } else {
                this.renderImageDoesNotSupportScaling(canvas, frame);
            }
        }
        finally {
            frame.dispose();
        }
    }

    private synchronized void prepareTempBitmapForThisSize(int width, int height) {
        if (this.mTempBitmap != null && (this.mTempBitmap.getWidth() < width || this.mTempBitmap.getHeight() < height)) {
            this.clearTempBitmap();
        }
        if (this.mTempBitmap == null) {
            this.mTempBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        this.mTempBitmap.eraseColor(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderImageSupportsScaling(Canvas canvas, AnimatedImageFrame frame) {
        double xScale = (double)this.mRenderedBounds.width() / (double)this.mAnimatedImage.getWidth();
        double yScale = (double)this.mRenderedBounds.height() / (double)this.mAnimatedImage.getHeight();
        int frameWidth = (int)Math.round((double)frame.getWidth() * xScale);
        int frameHeight = (int)Math.round((double)frame.getHeight() * yScale);
        int xOffset = (int)((double)frame.getXOffset() * xScale);
        int yOffset = (int)((double)frame.getYOffset() * yScale);
        AnimatedDrawableBackendImpl animatedDrawableBackendImpl = this;
        synchronized (animatedDrawableBackendImpl) {
            int renderedWidth = this.mRenderedBounds.width();
            int renderedHeight = this.mRenderedBounds.height();
            this.prepareTempBitmapForThisSize(renderedWidth, renderedHeight);
            frame.renderFrame(frameWidth, frameHeight, this.mTempBitmap);
            this.mRenderSrcRect.set(0, 0, renderedWidth, renderedHeight);
            this.mRenderDstRect.set(xOffset, yOffset, xOffset + renderedWidth, yOffset + renderedHeight);
            canvas.drawBitmap(this.mTempBitmap, this.mRenderSrcRect, this.mRenderDstRect, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderImageDoesNotSupportScaling(Canvas canvas, AnimatedImageFrame frame) {
        int frameWidth = frame.getWidth();
        int frameHeight = frame.getHeight();
        int xOffset = frame.getXOffset();
        int yOffset = frame.getYOffset();
        AnimatedDrawableBackendImpl animatedDrawableBackendImpl = this;
        synchronized (animatedDrawableBackendImpl) {
            this.prepareTempBitmapForThisSize(frameWidth, frameHeight);
            frame.renderFrame(frameWidth, frameHeight, this.mTempBitmap);
            this.mRenderSrcRect.set(0, 0, frameWidth, frameHeight);
            this.mRenderDstRect.set(0, 0, frameWidth, frameHeight);
            canvas.save();
            canvas.translate((float)xOffset, (float)yOffset);
            canvas.drawBitmap(this.mTempBitmap, this.mRenderSrcRect, this.mRenderDstRect, null);
            canvas.restore();
        }
    }

    @Override
    public synchronized void dropCaches() {
        this.clearTempBitmap();
    }

    private synchronized void clearTempBitmap() {
        if (this.mTempBitmap != null) {
            this.mTempBitmap.recycle();
            this.mTempBitmap = null;
        }
    }
}

