/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.animated.impl;

import android.app.ActivityManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.support.v4.util.SparseArrayCompat;
import bolts.Continuation;
import bolts.Task;
import com.facebook.common.executors.SerialExecutorService;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.common.time.MonotonicClock;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableBackend;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableCachingBackend;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableFrameInfo;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableOptions;
import com.facebook.imagepipeline.animated.base.DelegatingAnimatedDrawableBackend;
import com.facebook.imagepipeline.animated.impl.AnimatedImageCompositor;
import com.facebook.imagepipeline.animated.impl.WhatToKeepCachedArray;
import com.facebook.imagepipeline.animated.util.AnimatedDrawableUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

public class AnimatedDrawableCachingBackendImpl
extends DelegatingAnimatedDrawableBackend
implements AnimatedDrawableCachingBackend {
    private static final Class<?> TAG = AnimatedDrawableCachingBackendImpl.class;
    private static final AtomicInteger sTotalBitmaps = new AtomicInteger();
    private static final int PREFETCH_FRAMES = 3;
    private final SerialExecutorService mExecutorService;
    private final AnimatedDrawableUtil mAnimatedDrawableUtil;
    private final ActivityManager mActivityManager;
    private final MonotonicClock mMonotonicClock;
    private final AnimatedDrawableBackend mAnimatedDrawableBackend;
    private final AnimatedDrawableOptions mAnimatedDrawableOptions;
    private final AnimatedImageCompositor mAnimatedImageCompositor;
    private final ResourceReleaser<Bitmap> mResourceReleaserForBitmaps;
    private final double mMaximumKiloBytes;
    private final double mApproxKiloBytesToHoldAllFrames;
    @GuardedBy(value="this")
    private final List<Bitmap> mFreeBitmaps;
    @GuardedBy(value="this")
    private final SparseArrayCompat<Task<Object>> mDecodesInFlight;
    @GuardedBy(value="this")
    private final SparseArrayCompat<CloseableReference<Bitmap>> mCachedBitmaps;
    @GuardedBy(value="this")
    private final WhatToKeepCachedArray mBitmapsToKeepCached;
    @GuardedBy(value="ui-thread")
    private int mCurrentFrameIndex;

    public AnimatedDrawableCachingBackendImpl(SerialExecutorService executorService, ActivityManager activityManager, AnimatedDrawableUtil animatedDrawableUtil, MonotonicClock monotonicClock, AnimatedDrawableBackend animatedDrawableBackend, AnimatedDrawableOptions options) {
        super(animatedDrawableBackend);
        this.mExecutorService = executorService;
        this.mActivityManager = activityManager;
        this.mAnimatedDrawableUtil = animatedDrawableUtil;
        this.mMonotonicClock = monotonicClock;
        this.mAnimatedDrawableBackend = animatedDrawableBackend;
        this.mAnimatedDrawableOptions = options;
        this.mMaximumKiloBytes = options.maximumBytes >= 0 ? (double)(options.maximumBytes / 1024) : (double)(AnimatedDrawableCachingBackendImpl.getDefaultMaxBytes(activityManager) / 1024);
        this.mAnimatedImageCompositor = new AnimatedImageCompositor(animatedDrawableBackend, new AnimatedImageCompositor.Callback(){

            @Override
            public void onIntermediateResult(int frameNumber, Bitmap bitmap) {
                AnimatedDrawableCachingBackendImpl.this.maybeCacheBitmapDuringRender(frameNumber, bitmap);
            }

            @Override
            public CloseableReference<Bitmap> getCachedBitmap(int frameNumber) {
                return AnimatedDrawableCachingBackendImpl.this.getCachedOrPredecodedFrame(frameNumber);
            }
        });
        this.mResourceReleaserForBitmaps = new ResourceReleaser<Bitmap>(){

            public void release(Bitmap value) {
                AnimatedDrawableCachingBackendImpl.this.releaseBitmapInternal(value);
            }
        };
        this.mFreeBitmaps = new ArrayList<Bitmap>();
        this.mDecodesInFlight = new SparseArrayCompat(10);
        this.mCachedBitmaps = new SparseArrayCompat(10);
        this.mBitmapsToKeepCached = new WhatToKeepCachedArray(this.mAnimatedDrawableBackend.getFrameCount());
        this.mApproxKiloBytesToHoldAllFrames = this.mAnimatedDrawableBackend.getRenderedWidth() * this.mAnimatedDrawableBackend.getRenderedHeight() / 1024 * this.mAnimatedDrawableBackend.getFrameCount() * 4;
    }

    protected synchronized void finalize() throws Throwable {
        super.finalize();
        if (this.mCachedBitmaps.size() > 0) {
            FLog.d(TAG, (String)"Finalizing with rendered bitmaps");
        }
        sTotalBitmaps.addAndGet(-this.mFreeBitmaps.size());
        this.mFreeBitmaps.clear();
    }

    private Bitmap createNewBitmap() {
        FLog.v(TAG, (String)"Creating new bitmap");
        sTotalBitmaps.incrementAndGet();
        FLog.v(TAG, (String)"Total bitmaps: %d", (Object)sTotalBitmaps.get());
        return Bitmap.createBitmap((int)this.mAnimatedDrawableBackend.getRenderedWidth(), (int)this.mAnimatedDrawableBackend.getRenderedHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    @Override
    public void renderFrame(int frameNumber, Canvas canvas) {
        throw new IllegalStateException();
    }

    @Override
    public CloseableReference<Bitmap> getBitmapForFrame(int frameNumber) {
        this.mCurrentFrameIndex = frameNumber;
        CloseableReference<Bitmap> result = this.getBitmapForFrameInternal(frameNumber, false);
        this.schedulePrefetches();
        return result;
    }

    @Override
    public CloseableReference<Bitmap> getPreviewBitmap() {
        return this.getAnimatedImageResult().getPreviewBitmap();
    }

    @VisibleForTesting
    CloseableReference<Bitmap> getBitmapForFrameBlocking(int frameNumber) {
        this.mCurrentFrameIndex = frameNumber;
        CloseableReference<Bitmap> result = this.getBitmapForFrameInternal(frameNumber, true);
        this.schedulePrefetches();
        return result;
    }

    @Override
    public AnimatedDrawableCachingBackend forNewBounds(Rect bounds) {
        AnimatedDrawableBackend newBackend = this.mAnimatedDrawableBackend.forNewBounds(bounds);
        if (newBackend == this.mAnimatedDrawableBackend) {
            return this;
        }
        return new AnimatedDrawableCachingBackendImpl(this.mExecutorService, this.mActivityManager, this.mAnimatedDrawableUtil, this.mMonotonicClock, newBackend, this.mAnimatedDrawableOptions);
    }

    @Override
    public synchronized void dropCaches() {
        this.mBitmapsToKeepCached.setAll(false);
        this.dropBitmapsThatShouldNotBeCached();
        for (Bitmap freeBitmap : this.mFreeBitmaps) {
            freeBitmap.recycle();
            sTotalBitmaps.decrementAndGet();
        }
        this.mFreeBitmaps.clear();
        this.mAnimatedDrawableBackend.dropCaches();
        FLog.v(TAG, (String)"Total bitmaps: %d", (Object)sTotalBitmaps.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMemoryUsage() {
        int bytes = 0;
        AnimatedDrawableCachingBackendImpl animatedDrawableCachingBackendImpl = this;
        synchronized (animatedDrawableCachingBackendImpl) {
            for (Bitmap bitmap : this.mFreeBitmaps) {
                bytes += this.mAnimatedDrawableUtil.getSizeOfBitmap(bitmap);
            }
            for (int i = 0; i < this.mCachedBitmaps.size(); ++i) {
                CloseableReference bitmapReference = (CloseableReference)this.mCachedBitmaps.valueAt(i);
                bytes += this.mAnimatedDrawableUtil.getSizeOfBitmap((Bitmap)bitmapReference.get());
            }
        }
        return bytes += this.mAnimatedDrawableBackend.getMemoryUsage();
    }

    @Override
    public void appendDebugOptionString(StringBuilder sb) {
        if (this.mAnimatedDrawableOptions.forceKeepAllFramesInMemory) {
            sb.append("Pinned To Memory");
        } else {
            if (this.mApproxKiloBytesToHoldAllFrames < this.mMaximumKiloBytes) {
                sb.append("within ");
            } else {
                sb.append("exceeds ");
            }
            this.mAnimatedDrawableUtil.appendMemoryString(sb, (int)this.mMaximumKiloBytes);
        }
        if (this.shouldKeepAllFramesInMemory() && this.mAnimatedDrawableOptions.allowPrefetching) {
            sb.append(" MT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private CloseableReference<Bitmap> getBitmapForFrameInternal(int frameNumber, boolean forceImmediate) {
        boolean renderedOnCallingThread = false;
        boolean deferred = false;
        long startMs = this.mMonotonicClock.now();
        try {
            AnimatedDrawableCachingBackendImpl animatedDrawableCachingBackendImpl = this;
            // MONITORENTER : animatedDrawableCachingBackendImpl
            this.mBitmapsToKeepCached.set(frameNumber, true);
            CloseableReference bitmapReference = this.getCachedOrPredecodedFrame(frameNumber);
            if (bitmapReference != null) {
                CloseableReference closeableReference = bitmapReference;
                // MONITOREXIT : animatedDrawableCachingBackendImpl
                return closeableReference;
            }
            // MONITOREXIT : animatedDrawableCachingBackendImpl
            if (forceImmediate) {
                renderedOnCallingThread = true;
                try (CloseableReference<Bitmap> bitmapReference2 = this.obtainBitmapInternal();){
                    this.mAnimatedImageCompositor.renderFrame(frameNumber, (Bitmap)bitmapReference2.get());
                    this.maybeCacheRenderedBitmap(frameNumber, bitmapReference2);
                    bitmapReference = bitmapReference2.clone();
                    return bitmapReference;
                }
            }
            deferred = true;
            animatedDrawableCachingBackendImpl = null;
            return animatedDrawableCachingBackendImpl;
        }
        finally {
            long elapsedMs = this.mMonotonicClock.now() - startMs;
            if (elapsedMs > 10L) {
                String comment = "";
                comment = renderedOnCallingThread ? "renderedOnCallingThread" : (deferred ? "deferred" : "ok");
                FLog.v(TAG, (String)"obtainBitmap for frame %d took %d ms (%s)", (Object)frameNumber, (Object)elapsedMs, (Object)comment);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeCacheBitmapDuringRender(int frameNumber, Bitmap bitmap) {
        boolean cacheBitmap = false;
        AnimatedDrawableCachingBackendImpl animatedDrawableCachingBackendImpl = this;
        synchronized (animatedDrawableCachingBackendImpl) {
            boolean shouldCache = this.mBitmapsToKeepCached.get(frameNumber);
            if (shouldCache) {
                cacheBitmap = this.mCachedBitmaps.get(frameNumber) == null;
            }
        }
        if (cacheBitmap) {
            this.copyAndCacheBitmapDuringRendering(frameNumber, bitmap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAndCacheBitmapDuringRendering(int frameNumber, Bitmap sourceBitmap) {
        try (CloseableReference<Bitmap> destBitmapReference = this.obtainBitmapInternal();){
            Canvas copyCanvas = new Canvas((Bitmap)destBitmapReference.get());
            copyCanvas.drawColor(0, PorterDuff.Mode.SRC);
            copyCanvas.drawBitmap(sourceBitmap, 0.0f, 0.0f, null);
            this.maybeCacheRenderedBitmap(frameNumber, destBitmapReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableReference<Bitmap> obtainBitmapInternal() {
        Bitmap bitmap;
        AnimatedDrawableCachingBackendImpl animatedDrawableCachingBackendImpl = this;
        synchronized (animatedDrawableCachingBackendImpl) {
            long nowNanos = System.nanoTime();
            long waitUntilNanos = nowNanos + TimeUnit.NANOSECONDS.convert(20L, TimeUnit.MILLISECONDS);
            while (this.mFreeBitmaps.isEmpty() && nowNanos < waitUntilNanos) {
                try {
                    TimeUnit.NANOSECONDS.timedWait(this, waitUntilNanos - nowNanos);
                    nowNanos = System.nanoTime();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            bitmap = this.mFreeBitmaps.isEmpty() ? this.createNewBitmap() : this.mFreeBitmaps.remove(this.mFreeBitmaps.size() - 1);
        }
        return CloseableReference.of((Object)bitmap, this.mResourceReleaserForBitmaps);
    }

    synchronized void releaseBitmapInternal(Bitmap bitmap) {
        this.mFreeBitmaps.add(bitmap);
    }

    private synchronized void schedulePrefetches() {
        AnimatedDrawableFrameInfo frameInfo = this.mAnimatedDrawableBackend.getFrameInfo(this.mCurrentFrameIndex);
        boolean keepOnePreceding = frameInfo.disposalMethod == AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_PREVIOUS;
        int startFrame = Math.max(0, this.mCurrentFrameIndex - (keepOnePreceding ? 1 : 0));
        int numToPrefetch = this.mAnimatedDrawableOptions.allowPrefetching ? 3 : 0;
        numToPrefetch = Math.max(numToPrefetch, keepOnePreceding ? 1 : 0);
        int endFrame = (startFrame + numToPrefetch) % this.mAnimatedDrawableBackend.getFrameCount();
        this.cancelFuturesOutsideOfRange(startFrame, endFrame);
        if (!this.shouldKeepAllFramesInMemory()) {
            this.mBitmapsToKeepCached.setAll(true);
            this.mBitmapsToKeepCached.removeOutsideRange(startFrame, endFrame);
            for (int frameNumber = startFrame; frameNumber >= 0; --frameNumber) {
                if (this.mCachedBitmaps.get(frameNumber) == null) continue;
                this.mBitmapsToKeepCached.set(frameNumber, true);
                break;
            }
            this.dropBitmapsThatShouldNotBeCached();
        }
        if (this.mAnimatedDrawableOptions.allowPrefetching) {
            this.doPrefetch(startFrame, numToPrefetch);
        } else {
            this.cancelFuturesOutsideOfRange(this.mCurrentFrameIndex, this.mCurrentFrameIndex);
        }
    }

    private static int getDefaultMaxBytes(ActivityManager activityManager) {
        int memory = activityManager.getMemoryClass();
        if (memory > 32) {
            return 0x500000;
        }
        return 0x300000;
    }

    private boolean shouldKeepAllFramesInMemory() {
        if (this.mAnimatedDrawableOptions.forceKeepAllFramesInMemory) {
            return true;
        }
        return this.mApproxKiloBytesToHoldAllFrames < this.mMaximumKiloBytes;
    }

    private synchronized void doPrefetch(int startFrame, int count) {
        for (int i = 0; i < count; ++i) {
            final int frameNumber = (startFrame + i) % this.mAnimatedDrawableBackend.getFrameCount();
            boolean hasCached = this.hasCachedOrPredecodedFrame(frameNumber);
            Task future = (Task)this.mDecodesInFlight.get(frameNumber);
            if (hasCached || future != null) continue;
            final Task newFuture = Task.call((Callable)new Callable<Object>(){

                @Override
                public Object call() {
                    AnimatedDrawableCachingBackendImpl.this.runPrefetch(frameNumber);
                    return null;
                }
            }, (Executor)this.mExecutorService);
            this.mDecodesInFlight.put(frameNumber, (Object)newFuture);
            newFuture.continueWith((Continuation)new Continuation<Object, Object>(){

                public Object then(Task<Object> task) throws Exception {
                    AnimatedDrawableCachingBackendImpl.this.onFutureFinished(newFuture, frameNumber);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPrefetch(int frameNumber) {
        block12: {
            AnimatedDrawableCachingBackendImpl animatedDrawableCachingBackendImpl = this;
            synchronized (animatedDrawableCachingBackendImpl) {
                if (!this.mBitmapsToKeepCached.get(frameNumber)) {
                    return;
                }
                if (this.hasCachedOrPredecodedFrame(frameNumber)) {
                    return;
                }
            }
            CloseableReference<Bitmap> preDecodedFrame = this.mAnimatedDrawableBackend.getPreDecodedFrame(frameNumber);
            try {
                if (preDecodedFrame != null) {
                    this.maybeCacheRenderedBitmap(frameNumber, preDecodedFrame);
                    break block12;
                }
                try (CloseableReference<Bitmap> bitmapReference = this.obtainBitmapInternal();){
                    this.mAnimatedImageCompositor.renderFrame(frameNumber, (Bitmap)bitmapReference.get());
                    this.maybeCacheRenderedBitmap(frameNumber, bitmapReference);
                    FLog.v(TAG, (String)"Prefetch rendered frame %d", (Object)frameNumber);
                }
            }
            finally {
                CloseableReference.closeSafely(preDecodedFrame);
            }
        }
    }

    private synchronized void onFutureFinished(Task<?> future, int frameNumber) {
        Task futureAtIndex;
        int index = this.mDecodesInFlight.indexOfKey(frameNumber);
        if (index >= 0 && (futureAtIndex = (Task)this.mDecodesInFlight.valueAt(index)) == future) {
            this.mDecodesInFlight.removeAt(index);
            if (future.getError() != null) {
                FLog.v(TAG, (Throwable)future.getError(), (String)"Failed to render frame %d", (Object[])new Object[]{frameNumber});
            }
        }
    }

    private synchronized void cancelFuturesOutsideOfRange(int startFrame, int endFrame) {
        int index = 0;
        while (index < this.mDecodesInFlight.size()) {
            int frameNumber = this.mDecodesInFlight.keyAt(index);
            boolean outsideRange = AnimatedDrawableUtil.isOutsideRange(startFrame, endFrame, frameNumber);
            if (outsideRange) {
                Task future = (Task)this.mDecodesInFlight.valueAt(index);
                this.mDecodesInFlight.removeAt(index);
                continue;
            }
            ++index;
        }
    }

    private synchronized void dropBitmapsThatShouldNotBeCached() {
        int index = 0;
        while (index < this.mCachedBitmaps.size()) {
            int frameNumber = this.mCachedBitmaps.keyAt(index);
            boolean keepCached = this.mBitmapsToKeepCached.get(frameNumber);
            if (!keepCached) {
                CloseableReference bitmapReference = (CloseableReference)this.mCachedBitmaps.valueAt(index);
                this.mCachedBitmaps.removeAt(index);
                bitmapReference.close();
                continue;
            }
            ++index;
        }
    }

    private synchronized void maybeCacheRenderedBitmap(int frameNumber, CloseableReference<Bitmap> bitmapReference) {
        if (!this.mBitmapsToKeepCached.get(frameNumber)) {
            return;
        }
        int existingIndex = this.mCachedBitmaps.indexOfKey(frameNumber);
        if (existingIndex >= 0) {
            CloseableReference oldReference = (CloseableReference)this.mCachedBitmaps.valueAt(existingIndex);
            oldReference.close();
            this.mCachedBitmaps.removeAt(existingIndex);
        }
        this.mCachedBitmaps.put(frameNumber, (Object)bitmapReference.clone());
    }

    private synchronized CloseableReference<Bitmap> getCachedOrPredecodedFrame(int frameNumber) {
        CloseableReference<Bitmap> ret = CloseableReference.cloneOrNull((CloseableReference)((CloseableReference)this.mCachedBitmaps.get(frameNumber)));
        if (ret == null) {
            ret = this.mAnimatedDrawableBackend.getPreDecodedFrame(frameNumber);
        }
        return ret;
    }

    private synchronized boolean hasCachedOrPredecodedFrame(int frameNumber) {
        return this.mCachedBitmaps.get(frameNumber) != null || this.mAnimatedDrawableBackend.hasPreDecodedFrame(frameNumber);
    }

    @VisibleForTesting
    synchronized Map<Integer, Task<?>> getDecodesInFlight() {
        HashMap map = new HashMap();
        for (int i = 0; i < this.mDecodesInFlight.size(); ++i) {
            map.put(this.mDecodesInFlight.keyAt(i), (Task<?>)this.mDecodesInFlight.valueAt(i));
        }
        return map;
    }

    @VisibleForTesting
    synchronized Set<Integer> getFramesCached() {
        HashSet<Integer> set = new HashSet<Integer>(this.mCachedBitmaps.size());
        for (int i = 0; i < this.mCachedBitmaps.size(); ++i) {
            set.add(this.mCachedBitmaps.keyAt(i));
        }
        return set;
    }
}

