/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.InstantArticle;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URL
extends APINode {
    @SerializedName(value="development_instant_article")
    private InstantArticle mDevelopmentInstantArticle = null;
    @SerializedName(value="engagement")
    private Object mEngagement = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="instant_article")
    private InstantArticle mInstantArticle = null;
    @SerializedName(value="og_object")
    private Object mOgObject = null;
    @SerializedName(value="ownership_permissions")
    private Object mOwnershipPermissions = null;
    @SerializedName(value="scopes")
    private Object mScopes = null;
    protected static Gson gson = null;

    URL() {
    }

    public URL(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public URL(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public URL fetch() throws APIException {
        URL newInstance = URL.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static URL fetchById(Long id, APIContext context) throws APIException {
        return URL.fetchById(id.toString(), context);
    }

    public static ListenableFuture<URL> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return URL.fetchByIdAsync(id.toString(), context);
    }

    public static URL fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<URL> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<URL> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<URL>(context, "", "/", "GET", URL.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<URL>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<URL>(context, "", "/", "GET", URL.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static URL loadJSON(String json, APIContext context, String header) {
        URL url = (URL)URL.getGson().fromJson(json, URL.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(url.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        url.context = context;
        url.rawValue = json;
        url.header = header;
        return url;
    }

    public static APINodeList<URL> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<URL> urls = new APINodeList<URL>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        urls.add(URL.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return urls;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            urls.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        urls.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            urls.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            urls.add(URL.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                urls.add(URL.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            urls.add(URL.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return urls;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        urls.add(URL.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return urls;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        urls.add(URL.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return urls;
                }
                urls.clear();
                urls.add(URL.loadJSON(json, context, header));
                return urls;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return URL.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public InstantArticle getFieldDevelopmentInstantArticle() {
        if (this.mDevelopmentInstantArticle != null) {
            this.mDevelopmentInstantArticle.context = this.getContext();
        }
        return this.mDevelopmentInstantArticle;
    }

    public Object getFieldEngagement() {
        return this.mEngagement;
    }

    public String getFieldId() {
        return this.mId;
    }

    public InstantArticle getFieldInstantArticle() {
        if (this.mInstantArticle != null) {
            this.mInstantArticle.context = this.getContext();
        }
        return this.mInstantArticle;
    }

    public Object getFieldOgObject() {
        return this.mOgObject;
    }

    public Object getFieldOwnershipPermissions() {
        return this.mOwnershipPermissions;
    }

    public Object getFieldScopes() {
        return this.mScopes;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public URL copyFrom(URL instance) {
        this.mDevelopmentInstantArticle = instance.mDevelopmentInstantArticle;
        this.mEngagement = instance.mEngagement;
        this.mId = instance.mId;
        this.mInstantArticle = instance.mInstantArticle;
        this.mOgObject = instance.mOgObject;
        this.mOwnershipPermissions = instance.mOwnershipPermissions;
        this.mScopes = instance.mScopes;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<URL> getParser() {
        return new APIRequest.ResponseParser<URL>(){

            @Override
            public APINodeList<URL> parseResponse(String response, APIContext context, APIRequest<URL> request, String header) throws APIException.MalformedResponseException {
                return URL.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumScopes {
        VALUE_NEWS_TAB("NEWS_TAB"),
        VALUE_NEWS_TAB_DEV_ENV("NEWS_TAB_DEV_ENV");

        private String value;

        private EnumScopes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<URL> {
        URL lastResponse = null;
        public static final String[] PARAMS = new String[]{"blacklist", "denylist", "hmac", "locale", "scopes", "ts"};
        public static final String[] FIELDS = new String[0];

        @Override
        public URL getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public URL parseResponse(String response, String header) throws APIException {
            return URL.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public URL execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public URL execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<URL> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<URL> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, URL>(){

                public URL apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setBlacklist(Boolean blacklist) {
            this.setParam("blacklist", blacklist);
            return this;
        }

        public APIRequestUpdate setBlacklist(String blacklist) {
            this.setParam("blacklist", blacklist);
            return this;
        }

        public APIRequestUpdate setDenylist(Boolean denylist) {
            this.setParam("denylist", denylist);
            return this;
        }

        public APIRequestUpdate setDenylist(String denylist) {
            this.setParam("denylist", denylist);
            return this;
        }

        public APIRequestUpdate setHmac(String hmac) {
            this.setParam("hmac", hmac);
            return this;
        }

        public APIRequestUpdate setLocale(List<Object> locale) {
            this.setParam("locale", locale);
            return this;
        }

        public APIRequestUpdate setLocale(String locale) {
            this.setParam("locale", locale);
            return this;
        }

        public APIRequestUpdate setScopes(List<EnumScopes> scopes) {
            this.setParam("scopes", scopes);
            return this;
        }

        public APIRequestUpdate setScopes(String scopes) {
            this.setParam("scopes", scopes);
            return this;
        }

        public APIRequestUpdate setTs(String ts) {
            this.setParam("ts", ts);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<URL> {
        URL lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"development_instant_article", "engagement", "id", "instant_article", "og_object", "ownership_permissions", "scopes"};

        @Override
        public URL getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public URL parseResponse(String response, String header) throws APIException {
            return URL.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public URL execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public URL execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<URL> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<URL> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, URL>(){

                public URL apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDevelopmentInstantArticleField() {
            return this.requestDevelopmentInstantArticleField(true);
        }

        public APIRequestGet requestDevelopmentInstantArticleField(boolean value) {
            this.requestField("development_instant_article", value);
            return this;
        }

        public APIRequestGet requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGet requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInstantArticleField() {
            return this.requestInstantArticleField(true);
        }

        public APIRequestGet requestInstantArticleField(boolean value) {
            this.requestField("instant_article", value);
            return this;
        }

        public APIRequestGet requestOgObjectField() {
            return this.requestOgObjectField(true);
        }

        public APIRequestGet requestOgObjectField(boolean value) {
            this.requestField("og_object", value);
            return this;
        }

        public APIRequestGet requestOwnershipPermissionsField() {
            return this.requestOwnershipPermissionsField(true);
        }

        public APIRequestGet requestOwnershipPermissionsField(boolean value) {
            this.requestField("ownership_permissions", value);
            return this;
        }

        public APIRequestGet requestScopesField() {
            return this.requestScopesField(true);
        }

        public APIRequestGet requestScopesField(boolean value) {
            this.requestField("scopes", value);
            return this;
        }
    }
}

