/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Comment;
import com.facebook.ads.sdk.Post;
import com.facebook.ads.sdk.Privacy;
import com.facebook.ads.sdk.Profile;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Link
extends APINode {
    @SerializedName(value="caption")
    private String mCaption = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="from")
    private Object mFrom = null;
    @SerializedName(value="icon")
    private String mIcon = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="multi_share_optimized")
    private Boolean mMultiShareOptimized = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="privacy")
    private Privacy mPrivacy = null;
    @SerializedName(value="via")
    private Object mVia = null;
    protected static Gson gson = null;

    Link() {
    }

    public Link(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Link(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Link fetch() throws APIException {
        Link newInstance = Link.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Link fetchById(Long id, APIContext context) throws APIException {
        return Link.fetchById(id.toString(), context);
    }

    public static ListenableFuture<Link> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return Link.fetchByIdAsync(id.toString(), context);
    }

    public static Link fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<Link> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<Link> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Link>(context, "", "/", "GET", Link.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<Link>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<Link>(context, "", "/", "GET", Link.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Link loadJSON(String json, APIContext context, String header) {
        Link link = (Link)Link.getGson().fromJson(json, Link.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(link.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        link.context = context;
        link.rawValue = json;
        link.header = header;
        return link;
    }

    public static APINodeList<Link> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Link> links = new APINodeList<Link>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        links.add(Link.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return links;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            links.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        links.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            links.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            links.add(Link.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                links.add(Link.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            links.add(Link.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return links;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        links.add(Link.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return links;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        links.add(Link.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return links;
                }
                links.clear();
                links.add(Link.loadJSON(json, context, header));
                return links;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Link.getGson().toJson((Object)this);
    }

    public APIRequestCreateComment createComment() {
        return new APIRequestCreateComment(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetLikes getLikes() {
        return new APIRequestGetLikes(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetReactions getReactions() {
        return new APIRequestGetReactions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetSharedPosts getSharedPosts() {
        return new APIRequestGetSharedPosts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCaption() {
        return this.mCaption;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public Object getFieldFrom() {
        return this.mFrom;
    }

    public String getFieldIcon() {
        return this.mIcon;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public Boolean getFieldMultiShareOptimized() {
        return this.mMultiShareOptimized;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Privacy getFieldPrivacy() {
        return this.mPrivacy;
    }

    public Object getFieldVia() {
        return this.mVia;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Link copyFrom(Link instance) {
        this.mCaption = instance.mCaption;
        this.mCreatedTime = instance.mCreatedTime;
        this.mDescription = instance.mDescription;
        this.mFrom = instance.mFrom;
        this.mIcon = instance.mIcon;
        this.mId = instance.mId;
        this.mLink = instance.mLink;
        this.mMessage = instance.mMessage;
        this.mMultiShareOptimized = instance.mMultiShareOptimized;
        this.mName = instance.mName;
        this.mPrivacy = instance.mPrivacy;
        this.mVia = instance.mVia;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Link> getParser() {
        return new APIRequest.ResponseParser<Link>(){

            @Override
            public APINodeList<Link> parseResponse(String response, APIContext context, APIRequest<Link> request, String header) throws APIException.MalformedResponseException {
                return Link.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<Link> {
        Link lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"caption", "created_time", "description", "from", "icon", "id", "link", "message", "multi_share_optimized", "name", "privacy", "via"};

        @Override
        public Link getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Link parseResponse(String response, String header) throws APIException {
            return Link.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Link execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Link execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Link> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Link> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Link>(){

                public Link apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCaptionField() {
            return this.requestCaptionField(true);
        }

        public APIRequestGet requestCaptionField(boolean value) {
            this.requestField("caption", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGet requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGet requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGet requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGet requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGet requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGet requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGet requestMultiShareOptimizedField() {
            return this.requestMultiShareOptimizedField(true);
        }

        public APIRequestGet requestMultiShareOptimizedField(boolean value) {
            this.requestField("multi_share_optimized", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPrivacyField() {
            return this.requestPrivacyField(true);
        }

        public APIRequestGet requestPrivacyField(boolean value) {
            this.requestField("privacy", value);
            return this;
        }

        public APIRequestGet requestViaField() {
            return this.requestViaField(true);
        }

        public APIRequestGet requestViaField(boolean value) {
            this.requestField("via", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetSharedPosts
    extends APIRequest<Post> {
        APINodeList<Post> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"actions", "admin_creator", "allowed_advertising_objectives", "application", "backdated_time", "call_to_action", "can_reply_privately", "caption", "child_attachments", "comments_mirroring_domain", "coordinates", "created_time", "description", "event", "expanded_height", "expanded_width", "feed_targeting", "from", "full_picture", "height", "icon", "id", "instagram_eligibility", "is_app_share", "is_eligible_for_promotion", "is_expired", "is_hidden", "is_inline_created", "is_instagram_eligible", "is_popular", "is_published", "is_spherical", "link", "message", "message_tags", "multi_share_end_card", "multi_share_optimized", "name", "object_id", "parent_id", "permalink_url", "picture", "place", "privacy", "promotable_id", "promotion_status", "properties", "scheduled_publish_time", "shares", "source", "status_type", "story", "story_tags", "subscribed", "target", "targeting", "timeline_visibility", "type", "updated_time", "via", "video_buying_eligibility", "width"};

        @Override
        public APINodeList<Post> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Post> parseResponse(String response, String header) throws APIException {
            return Post.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Post> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Post> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Post>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Post>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Post>>(){

                public APINodeList<Post> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetSharedPosts.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetSharedPosts(String nodeId, APIContext context) {
            super(context, nodeId, "/sharedposts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetSharedPosts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetSharedPosts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetSharedPosts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetSharedPosts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSharedPosts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetSharedPosts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSharedPosts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetSharedPosts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetSharedPosts requestActionsField() {
            return this.requestActionsField(true);
        }

        public APIRequestGetSharedPosts requestActionsField(boolean value) {
            this.requestField("actions", value);
            return this;
        }

        public APIRequestGetSharedPosts requestAdminCreatorField() {
            return this.requestAdminCreatorField(true);
        }

        public APIRequestGetSharedPosts requestAdminCreatorField(boolean value) {
            this.requestField("admin_creator", value);
            return this;
        }

        public APIRequestGetSharedPosts requestAllowedAdvertisingObjectivesField() {
            return this.requestAllowedAdvertisingObjectivesField(true);
        }

        public APIRequestGetSharedPosts requestAllowedAdvertisingObjectivesField(boolean value) {
            this.requestField("allowed_advertising_objectives", value);
            return this;
        }

        public APIRequestGetSharedPosts requestApplicationField() {
            return this.requestApplicationField(true);
        }

        public APIRequestGetSharedPosts requestApplicationField(boolean value) {
            this.requestField("application", value);
            return this;
        }

        public APIRequestGetSharedPosts requestBackdatedTimeField() {
            return this.requestBackdatedTimeField(true);
        }

        public APIRequestGetSharedPosts requestBackdatedTimeField(boolean value) {
            this.requestField("backdated_time", value);
            return this;
        }

        public APIRequestGetSharedPosts requestCallToActionField() {
            return this.requestCallToActionField(true);
        }

        public APIRequestGetSharedPosts requestCallToActionField(boolean value) {
            this.requestField("call_to_action", value);
            return this;
        }

        public APIRequestGetSharedPosts requestCanReplyPrivatelyField() {
            return this.requestCanReplyPrivatelyField(true);
        }

        public APIRequestGetSharedPosts requestCanReplyPrivatelyField(boolean value) {
            this.requestField("can_reply_privately", value);
            return this;
        }

        public APIRequestGetSharedPosts requestCaptionField() {
            return this.requestCaptionField(true);
        }

        public APIRequestGetSharedPosts requestCaptionField(boolean value) {
            this.requestField("caption", value);
            return this;
        }

        public APIRequestGetSharedPosts requestChildAttachmentsField() {
            return this.requestChildAttachmentsField(true);
        }

        public APIRequestGetSharedPosts requestChildAttachmentsField(boolean value) {
            this.requestField("child_attachments", value);
            return this;
        }

        public APIRequestGetSharedPosts requestCommentsMirroringDomainField() {
            return this.requestCommentsMirroringDomainField(true);
        }

        public APIRequestGetSharedPosts requestCommentsMirroringDomainField(boolean value) {
            this.requestField("comments_mirroring_domain", value);
            return this;
        }

        public APIRequestGetSharedPosts requestCoordinatesField() {
            return this.requestCoordinatesField(true);
        }

        public APIRequestGetSharedPosts requestCoordinatesField(boolean value) {
            this.requestField("coordinates", value);
            return this;
        }

        public APIRequestGetSharedPosts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetSharedPosts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetSharedPosts requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetSharedPosts requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetSharedPosts requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGetSharedPosts requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGetSharedPosts requestExpandedHeightField() {
            return this.requestExpandedHeightField(true);
        }

        public APIRequestGetSharedPosts requestExpandedHeightField(boolean value) {
            this.requestField("expanded_height", value);
            return this;
        }

        public APIRequestGetSharedPosts requestExpandedWidthField() {
            return this.requestExpandedWidthField(true);
        }

        public APIRequestGetSharedPosts requestExpandedWidthField(boolean value) {
            this.requestField("expanded_width", value);
            return this;
        }

        public APIRequestGetSharedPosts requestFeedTargetingField() {
            return this.requestFeedTargetingField(true);
        }

        public APIRequestGetSharedPosts requestFeedTargetingField(boolean value) {
            this.requestField("feed_targeting", value);
            return this;
        }

        public APIRequestGetSharedPosts requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetSharedPosts requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetSharedPosts requestFullPictureField() {
            return this.requestFullPictureField(true);
        }

        public APIRequestGetSharedPosts requestFullPictureField(boolean value) {
            this.requestField("full_picture", value);
            return this;
        }

        public APIRequestGetSharedPosts requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGetSharedPosts requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGetSharedPosts requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetSharedPosts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetSharedPosts requestInstagramEligibilityField() {
            return this.requestInstagramEligibilityField(true);
        }

        public APIRequestGetSharedPosts requestInstagramEligibilityField(boolean value) {
            this.requestField("instagram_eligibility", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsAppShareField() {
            return this.requestIsAppShareField(true);
        }

        public APIRequestGetSharedPosts requestIsAppShareField(boolean value) {
            this.requestField("is_app_share", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsEligibleForPromotionField() {
            return this.requestIsEligibleForPromotionField(true);
        }

        public APIRequestGetSharedPosts requestIsEligibleForPromotionField(boolean value) {
            this.requestField("is_eligible_for_promotion", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsExpiredField() {
            return this.requestIsExpiredField(true);
        }

        public APIRequestGetSharedPosts requestIsExpiredField(boolean value) {
            this.requestField("is_expired", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetSharedPosts requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsInlineCreatedField() {
            return this.requestIsInlineCreatedField(true);
        }

        public APIRequestGetSharedPosts requestIsInlineCreatedField(boolean value) {
            this.requestField("is_inline_created", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsInstagramEligibleField() {
            return this.requestIsInstagramEligibleField(true);
        }

        public APIRequestGetSharedPosts requestIsInstagramEligibleField(boolean value) {
            this.requestField("is_instagram_eligible", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsPopularField() {
            return this.requestIsPopularField(true);
        }

        public APIRequestGetSharedPosts requestIsPopularField(boolean value) {
            this.requestField("is_popular", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetSharedPosts requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsSphericalField() {
            return this.requestIsSphericalField(true);
        }

        public APIRequestGetSharedPosts requestIsSphericalField(boolean value) {
            this.requestField("is_spherical", value);
            return this;
        }

        public APIRequestGetSharedPosts requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetSharedPosts requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetSharedPosts requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGetSharedPosts requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGetSharedPosts requestMessageTagsField() {
            return this.requestMessageTagsField(true);
        }

        public APIRequestGetSharedPosts requestMessageTagsField(boolean value) {
            this.requestField("message_tags", value);
            return this;
        }

        public APIRequestGetSharedPosts requestMultiShareEndCardField() {
            return this.requestMultiShareEndCardField(true);
        }

        public APIRequestGetSharedPosts requestMultiShareEndCardField(boolean value) {
            this.requestField("multi_share_end_card", value);
            return this;
        }

        public APIRequestGetSharedPosts requestMultiShareOptimizedField() {
            return this.requestMultiShareOptimizedField(true);
        }

        public APIRequestGetSharedPosts requestMultiShareOptimizedField(boolean value) {
            this.requestField("multi_share_optimized", value);
            return this;
        }

        public APIRequestGetSharedPosts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetSharedPosts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetSharedPosts requestObjectIdField() {
            return this.requestObjectIdField(true);
        }

        public APIRequestGetSharedPosts requestObjectIdField(boolean value) {
            this.requestField("object_id", value);
            return this;
        }

        public APIRequestGetSharedPosts requestParentIdField() {
            return this.requestParentIdField(true);
        }

        public APIRequestGetSharedPosts requestParentIdField(boolean value) {
            this.requestField("parent_id", value);
            return this;
        }

        public APIRequestGetSharedPosts requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGetSharedPosts requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGetSharedPosts requestPictureField() {
            return this.requestPictureField(true);
        }

        public APIRequestGetSharedPosts requestPictureField(boolean value) {
            this.requestField("picture", value);
            return this;
        }

        public APIRequestGetSharedPosts requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGetSharedPosts requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGetSharedPosts requestPrivacyField() {
            return this.requestPrivacyField(true);
        }

        public APIRequestGetSharedPosts requestPrivacyField(boolean value) {
            this.requestField("privacy", value);
            return this;
        }

        public APIRequestGetSharedPosts requestPromotableIdField() {
            return this.requestPromotableIdField(true);
        }

        public APIRequestGetSharedPosts requestPromotableIdField(boolean value) {
            this.requestField("promotable_id", value);
            return this;
        }

        public APIRequestGetSharedPosts requestPromotionStatusField() {
            return this.requestPromotionStatusField(true);
        }

        public APIRequestGetSharedPosts requestPromotionStatusField(boolean value) {
            this.requestField("promotion_status", value);
            return this;
        }

        public APIRequestGetSharedPosts requestPropertiesField() {
            return this.requestPropertiesField(true);
        }

        public APIRequestGetSharedPosts requestPropertiesField(boolean value) {
            this.requestField("properties", value);
            return this;
        }

        public APIRequestGetSharedPosts requestScheduledPublishTimeField() {
            return this.requestScheduledPublishTimeField(true);
        }

        public APIRequestGetSharedPosts requestScheduledPublishTimeField(boolean value) {
            this.requestField("scheduled_publish_time", value);
            return this;
        }

        public APIRequestGetSharedPosts requestSharesField() {
            return this.requestSharesField(true);
        }

        public APIRequestGetSharedPosts requestSharesField(boolean value) {
            this.requestField("shares", value);
            return this;
        }

        public APIRequestGetSharedPosts requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGetSharedPosts requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGetSharedPosts requestStatusTypeField() {
            return this.requestStatusTypeField(true);
        }

        public APIRequestGetSharedPosts requestStatusTypeField(boolean value) {
            this.requestField("status_type", value);
            return this;
        }

        public APIRequestGetSharedPosts requestStoryField() {
            return this.requestStoryField(true);
        }

        public APIRequestGetSharedPosts requestStoryField(boolean value) {
            this.requestField("story", value);
            return this;
        }

        public APIRequestGetSharedPosts requestStoryTagsField() {
            return this.requestStoryTagsField(true);
        }

        public APIRequestGetSharedPosts requestStoryTagsField(boolean value) {
            this.requestField("story_tags", value);
            return this;
        }

        public APIRequestGetSharedPosts requestSubscribedField() {
            return this.requestSubscribedField(true);
        }

        public APIRequestGetSharedPosts requestSubscribedField(boolean value) {
            this.requestField("subscribed", value);
            return this;
        }

        public APIRequestGetSharedPosts requestTargetField() {
            return this.requestTargetField(true);
        }

        public APIRequestGetSharedPosts requestTargetField(boolean value) {
            this.requestField("target", value);
            return this;
        }

        public APIRequestGetSharedPosts requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGetSharedPosts requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGetSharedPosts requestTimelineVisibilityField() {
            return this.requestTimelineVisibilityField(true);
        }

        public APIRequestGetSharedPosts requestTimelineVisibilityField(boolean value) {
            this.requestField("timeline_visibility", value);
            return this;
        }

        public APIRequestGetSharedPosts requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetSharedPosts requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetSharedPosts requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetSharedPosts requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetSharedPosts requestViaField() {
            return this.requestViaField(true);
        }

        public APIRequestGetSharedPosts requestViaField(boolean value) {
            this.requestField("via", value);
            return this;
        }

        public APIRequestGetSharedPosts requestVideoBuyingEligibilityField() {
            return this.requestVideoBuyingEligibilityField(true);
        }

        public APIRequestGetSharedPosts requestVideoBuyingEligibilityField(boolean value) {
            this.requestField("video_buying_eligibility", value);
            return this;
        }

        public APIRequestGetSharedPosts requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGetSharedPosts requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetReactions
    extends APIRequest<Profile> {
        APINodeList<Profile> lastResponse = null;
        public static final String[] PARAMS = new String[]{"type"};
        public static final String[] FIELDS = new String[]{"can_post", "id", "link", "name", "pic", "pic_crop", "pic_large", "pic_small", "pic_square", "profile_type", "username"};

        @Override
        public APINodeList<Profile> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Profile> parseResponse(String response, String header) throws APIException {
            return Profile.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Profile> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Profile> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Profile>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Profile>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Profile>>(){

                public APINodeList<Profile> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetReactions.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetReactions(String nodeId, APIContext context) {
            super(context, nodeId, "/reactions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetReactions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetReactions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetReactions setType(Profile.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetReactions setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetReactions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetReactions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetReactions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetReactions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetReactions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetReactions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetReactions requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetReactions requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetReactions requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetReactions requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetReactions requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetReactions requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetReactions requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetReactions requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetReactions requestPicField() {
            return this.requestPicField(true);
        }

        public APIRequestGetReactions requestPicField(boolean value) {
            this.requestField("pic", value);
            return this;
        }

        public APIRequestGetReactions requestPicCropField() {
            return this.requestPicCropField(true);
        }

        public APIRequestGetReactions requestPicCropField(boolean value) {
            this.requestField("pic_crop", value);
            return this;
        }

        public APIRequestGetReactions requestPicLargeField() {
            return this.requestPicLargeField(true);
        }

        public APIRequestGetReactions requestPicLargeField(boolean value) {
            this.requestField("pic_large", value);
            return this;
        }

        public APIRequestGetReactions requestPicSmallField() {
            return this.requestPicSmallField(true);
        }

        public APIRequestGetReactions requestPicSmallField(boolean value) {
            this.requestField("pic_small", value);
            return this;
        }

        public APIRequestGetReactions requestPicSquareField() {
            return this.requestPicSquareField(true);
        }

        public APIRequestGetReactions requestPicSquareField(boolean value) {
            this.requestField("pic_square", value);
            return this;
        }

        public APIRequestGetReactions requestProfileTypeField() {
            return this.requestProfileTypeField(true);
        }

        public APIRequestGetReactions requestProfileTypeField(boolean value) {
            this.requestField("profile_type", value);
            return this;
        }

        public APIRequestGetReactions requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetReactions requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetLikes
    extends APIRequest<Profile> {
        APINodeList<Profile> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"can_post", "id", "link", "name", "pic", "pic_crop", "pic_large", "pic_small", "pic_square", "profile_type", "username"};

        @Override
        public APINodeList<Profile> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Profile> parseResponse(String response, String header) throws APIException {
            return Profile.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Profile> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Profile> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Profile>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Profile>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Profile>>(){

                public APINodeList<Profile> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetLikes.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetLikes(String nodeId, APIContext context) {
            super(context, nodeId, "/likes", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetLikes setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetLikes setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetLikes requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetLikes requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLikes requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetLikes requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLikes requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetLikes requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetLikes requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetLikes requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetLikes requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetLikes requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetLikes requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetLikes requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetLikes requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetLikes requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetLikes requestPicField() {
            return this.requestPicField(true);
        }

        public APIRequestGetLikes requestPicField(boolean value) {
            this.requestField("pic", value);
            return this;
        }

        public APIRequestGetLikes requestPicCropField() {
            return this.requestPicCropField(true);
        }

        public APIRequestGetLikes requestPicCropField(boolean value) {
            this.requestField("pic_crop", value);
            return this;
        }

        public APIRequestGetLikes requestPicLargeField() {
            return this.requestPicLargeField(true);
        }

        public APIRequestGetLikes requestPicLargeField(boolean value) {
            this.requestField("pic_large", value);
            return this;
        }

        public APIRequestGetLikes requestPicSmallField() {
            return this.requestPicSmallField(true);
        }

        public APIRequestGetLikes requestPicSmallField(boolean value) {
            this.requestField("pic_small", value);
            return this;
        }

        public APIRequestGetLikes requestPicSquareField() {
            return this.requestPicSquareField(true);
        }

        public APIRequestGetLikes requestPicSquareField(boolean value) {
            this.requestField("pic_square", value);
            return this;
        }

        public APIRequestGetLikes requestProfileTypeField() {
            return this.requestProfileTypeField(true);
        }

        public APIRequestGetLikes requestProfileTypeField(boolean value) {
            this.requestField("profile_type", value);
            return this;
        }

        public APIRequestGetLikes requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetLikes requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateComment
    extends APIRequest<Comment> {
        Comment lastResponse = null;
        public static final String[] PARAMS = new String[]{"attachment_id", "attachment_share_url", "attachment_url", "comment_privacy_value", "facepile_mentioned_ids", "feedback_source", "is_offline", "message", "nectar_module", "object_id", "parent_comment_id", "text", "tracking"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Comment getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Comment parseResponse(String response, String header) throws APIException {
            return Comment.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Comment execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Comment execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Comment> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Comment> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Comment>(){

                public Comment apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateComment.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateComment(String nodeId, APIContext context) {
            super(context, nodeId, "/comments", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateComment setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateComment setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateComment setAttachmentId(String attachmentId) {
            this.setParam("attachment_id", attachmentId);
            return this;
        }

        public APIRequestCreateComment setAttachmentShareUrl(String attachmentShareUrl) {
            this.setParam("attachment_share_url", attachmentShareUrl);
            return this;
        }

        public APIRequestCreateComment setAttachmentUrl(String attachmentUrl) {
            this.setParam("attachment_url", attachmentUrl);
            return this;
        }

        public APIRequestCreateComment setCommentPrivacyValue(Comment.EnumCommentPrivacyValue commentPrivacyValue) {
            this.setParam("comment_privacy_value", (Object)commentPrivacyValue);
            return this;
        }

        public APIRequestCreateComment setCommentPrivacyValue(String commentPrivacyValue) {
            this.setParam("comment_privacy_value", commentPrivacyValue);
            return this;
        }

        public APIRequestCreateComment setFacepileMentionedIds(List<String> facepileMentionedIds) {
            this.setParam("facepile_mentioned_ids", facepileMentionedIds);
            return this;
        }

        public APIRequestCreateComment setFacepileMentionedIds(String facepileMentionedIds) {
            this.setParam("facepile_mentioned_ids", facepileMentionedIds);
            return this;
        }

        public APIRequestCreateComment setFeedbackSource(String feedbackSource) {
            this.setParam("feedback_source", feedbackSource);
            return this;
        }

        public APIRequestCreateComment setIsOffline(Boolean isOffline) {
            this.setParam("is_offline", isOffline);
            return this;
        }

        public APIRequestCreateComment setIsOffline(String isOffline) {
            this.setParam("is_offline", isOffline);
            return this;
        }

        public APIRequestCreateComment setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateComment setNectarModule(String nectarModule) {
            this.setParam("nectar_module", nectarModule);
            return this;
        }

        public APIRequestCreateComment setObjectId(String objectId) {
            this.setParam("object_id", objectId);
            return this;
        }

        public APIRequestCreateComment setParentCommentId(Object parentCommentId) {
            this.setParam("parent_comment_id", parentCommentId);
            return this;
        }

        public APIRequestCreateComment setParentCommentId(String parentCommentId) {
            this.setParam("parent_comment_id", parentCommentId);
            return this;
        }

        public APIRequestCreateComment setText(String text) {
            this.setParam("text", text);
            return this;
        }

        public APIRequestCreateComment setTracking(String tracking) {
            this.setParam("tracking", tracking);
            return this;
        }

        public APIRequestCreateComment requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateComment requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateComment requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateComment requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateComment requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateComment requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

