/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdVideo;
import com.facebook.ads.sdk.Comment;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoList
extends APINode {
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="last_modified")
    private String mLastModified = null;
    @SerializedName(value="owner")
    private Object mOwner = null;
    @SerializedName(value="season_number")
    private Long mSeasonNumber = null;
    @SerializedName(value="thumbnail")
    private String mThumbnail = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="videos_count")
    private Long mVideosCount = null;
    protected static Gson gson = null;

    VideoList() {
    }

    public VideoList(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public VideoList(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public VideoList fetch() throws APIException {
        VideoList newInstance = VideoList.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static VideoList fetchById(Long id, APIContext context) throws APIException {
        return VideoList.fetchById(id.toString(), context);
    }

    public static ListenableFuture<VideoList> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return VideoList.fetchByIdAsync(id.toString(), context);
    }

    public static VideoList fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<VideoList> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<VideoList> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<VideoList>(context, "", "/", "GET", VideoList.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<VideoList>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<VideoList>(context, "", "/", "GET", VideoList.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static VideoList loadJSON(String json, APIContext context, String header) {
        VideoList videoList = (VideoList)VideoList.getGson().fromJson(json, VideoList.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(videoList.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        videoList.context = context;
        videoList.rawValue = json;
        videoList.header = header;
        return videoList;
    }

    public static APINodeList<VideoList> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<VideoList> videoLists = new APINodeList<VideoList>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        videoLists.add(VideoList.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return videoLists;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            videoLists.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        videoLists.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            videoLists.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            videoLists.add(VideoList.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                videoLists.add(VideoList.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            videoLists.add(VideoList.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return videoLists;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        videoLists.add(VideoList.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return videoLists;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        videoLists.add(VideoList.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return videoLists;
                }
                videoLists.clear();
                videoLists.add(VideoList.loadJSON(json, context, header));
                return videoLists;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return VideoList.getGson().toJson((Object)this);
    }

    public APIRequestCreateComment createComment() {
        return new APIRequestCreateComment(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteVideos deleteVideos() {
        return new APIRequestDeleteVideos(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetVideos getVideos() {
        return new APIRequestGetVideos(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateVideo createVideo() {
        return new APIRequestCreateVideo(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldLastModified() {
        return this.mLastModified;
    }

    public Object getFieldOwner() {
        return this.mOwner;
    }

    public Long getFieldSeasonNumber() {
        return this.mSeasonNumber;
    }

    public String getFieldThumbnail() {
        return this.mThumbnail;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public Long getFieldVideosCount() {
        return this.mVideosCount;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public VideoList copyFrom(VideoList instance) {
        this.mCreationTime = instance.mCreationTime;
        this.mDescription = instance.mDescription;
        this.mId = instance.mId;
        this.mLastModified = instance.mLastModified;
        this.mOwner = instance.mOwner;
        this.mSeasonNumber = instance.mSeasonNumber;
        this.mThumbnail = instance.mThumbnail;
        this.mTitle = instance.mTitle;
        this.mVideosCount = instance.mVideosCount;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<VideoList> getParser() {
        return new APIRequest.ResponseParser<VideoList>(){

            @Override
            public APINodeList<VideoList> parseResponse(String response, APIContext context, APIRequest<VideoList> request, String header) throws APIException.MalformedResponseException {
                return VideoList.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<VideoList> {
        VideoList lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"creation_time", "description", "id", "last_modified", "owner", "season_number", "thumbnail", "title", "videos_count"};

        @Override
        public VideoList getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public VideoList parseResponse(String response, String header) throws APIException {
            return VideoList.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public VideoList execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public VideoList execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<VideoList> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<VideoList> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, VideoList>(){

                public VideoList apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLastModifiedField() {
            return this.requestLastModifiedField(true);
        }

        public APIRequestGet requestLastModifiedField(boolean value) {
            this.requestField("last_modified", value);
            return this;
        }

        public APIRequestGet requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGet requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGet requestSeasonNumberField() {
            return this.requestSeasonNumberField(true);
        }

        public APIRequestGet requestSeasonNumberField(boolean value) {
            this.requestField("season_number", value);
            return this;
        }

        public APIRequestGet requestThumbnailField() {
            return this.requestThumbnailField(true);
        }

        public APIRequestGet requestThumbnailField(boolean value) {
            this.requestField("thumbnail", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGet requestVideosCountField() {
            return this.requestVideosCountField(true);
        }

        public APIRequestGet requestVideosCountField(boolean value) {
            this.requestField("videos_count", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateVideo
    extends APIRequest<VideoList> {
        VideoList lastResponse = null;
        public static final String[] PARAMS = new String[]{"video_ids"};
        public static final String[] FIELDS = new String[0];

        @Override
        public VideoList getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public VideoList parseResponse(String response, String header) throws APIException {
            return VideoList.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public VideoList execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public VideoList execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<VideoList> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<VideoList> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, VideoList>(){

                public VideoList apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateVideo.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateVideo(String nodeId, APIContext context) {
            super(context, nodeId, "/videos", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateVideo setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateVideo setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateVideo setVideoIds(List<String> videoIds) {
            this.setParam("video_ids", videoIds);
            return this;
        }

        public APIRequestCreateVideo setVideoIds(String videoIds) {
            this.setParam("video_ids", videoIds);
            return this;
        }

        public APIRequestCreateVideo requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateVideo requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateVideo requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateVideo requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateVideo requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateVideo requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetVideos
    extends APIRequest<AdVideo> {
        APINodeList<AdVideo> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_breaks", "backdated_time", "backdated_time_granularity", "content_category", "content_tags", "copyright", "copyright_monitoring_status", "created_time", "custom_labels", "description", "embed_html", "embeddable", "event", "expiration", "format", "from", "icon", "id", "is_crosspost_video", "is_crossposting_eligible", "is_episode", "is_instagram_eligible", "is_reference_only", "length", "live_audience_count", "live_status", "music_video_copyright", "permalink_url", "picture", "place", "premiere_living_room_status", "privacy", "published", "scheduled_publish_time", "source", "spherical", "status", "title", "universal_video_id", "updated_time"};

        @Override
        public APINodeList<AdVideo> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdVideo> parseResponse(String response, String header) throws APIException {
            return AdVideo.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdVideo> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdVideo> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdVideo>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdVideo>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdVideo>>(){

                public APINodeList<AdVideo> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetVideos.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetVideos(String nodeId, APIContext context) {
            super(context, nodeId, "/videos", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetVideos setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetVideos setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetVideos requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetVideos requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideos requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetVideos requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideos requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetVideos requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetVideos requestAdBreaksField() {
            return this.requestAdBreaksField(true);
        }

        public APIRequestGetVideos requestAdBreaksField(boolean value) {
            this.requestField("ad_breaks", value);
            return this;
        }

        public APIRequestGetVideos requestBackdatedTimeField() {
            return this.requestBackdatedTimeField(true);
        }

        public APIRequestGetVideos requestBackdatedTimeField(boolean value) {
            this.requestField("backdated_time", value);
            return this;
        }

        public APIRequestGetVideos requestBackdatedTimeGranularityField() {
            return this.requestBackdatedTimeGranularityField(true);
        }

        public APIRequestGetVideos requestBackdatedTimeGranularityField(boolean value) {
            this.requestField("backdated_time_granularity", value);
            return this;
        }

        public APIRequestGetVideos requestContentCategoryField() {
            return this.requestContentCategoryField(true);
        }

        public APIRequestGetVideos requestContentCategoryField(boolean value) {
            this.requestField("content_category", value);
            return this;
        }

        public APIRequestGetVideos requestContentTagsField() {
            return this.requestContentTagsField(true);
        }

        public APIRequestGetVideos requestContentTagsField(boolean value) {
            this.requestField("content_tags", value);
            return this;
        }

        public APIRequestGetVideos requestCopyrightField() {
            return this.requestCopyrightField(true);
        }

        public APIRequestGetVideos requestCopyrightField(boolean value) {
            this.requestField("copyright", value);
            return this;
        }

        public APIRequestGetVideos requestCopyrightMonitoringStatusField() {
            return this.requestCopyrightMonitoringStatusField(true);
        }

        public APIRequestGetVideos requestCopyrightMonitoringStatusField(boolean value) {
            this.requestField("copyright_monitoring_status", value);
            return this;
        }

        public APIRequestGetVideos requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetVideos requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetVideos requestCustomLabelsField() {
            return this.requestCustomLabelsField(true);
        }

        public APIRequestGetVideos requestCustomLabelsField(boolean value) {
            this.requestField("custom_labels", value);
            return this;
        }

        public APIRequestGetVideos requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetVideos requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetVideos requestEmbedHtmlField() {
            return this.requestEmbedHtmlField(true);
        }

        public APIRequestGetVideos requestEmbedHtmlField(boolean value) {
            this.requestField("embed_html", value);
            return this;
        }

        public APIRequestGetVideos requestEmbeddableField() {
            return this.requestEmbeddableField(true);
        }

        public APIRequestGetVideos requestEmbeddableField(boolean value) {
            this.requestField("embeddable", value);
            return this;
        }

        public APIRequestGetVideos requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGetVideos requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGetVideos requestExpirationField() {
            return this.requestExpirationField(true);
        }

        public APIRequestGetVideos requestExpirationField(boolean value) {
            this.requestField("expiration", value);
            return this;
        }

        public APIRequestGetVideos requestFormatField() {
            return this.requestFormatField(true);
        }

        public APIRequestGetVideos requestFormatField(boolean value) {
            this.requestField("format", value);
            return this;
        }

        public APIRequestGetVideos requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetVideos requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetVideos requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGetVideos requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGetVideos requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetVideos requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetVideos requestIsCrosspostVideoField() {
            return this.requestIsCrosspostVideoField(true);
        }

        public APIRequestGetVideos requestIsCrosspostVideoField(boolean value) {
            this.requestField("is_crosspost_video", value);
            return this;
        }

        public APIRequestGetVideos requestIsCrosspostingEligibleField() {
            return this.requestIsCrosspostingEligibleField(true);
        }

        public APIRequestGetVideos requestIsCrosspostingEligibleField(boolean value) {
            this.requestField("is_crossposting_eligible", value);
            return this;
        }

        public APIRequestGetVideos requestIsEpisodeField() {
            return this.requestIsEpisodeField(true);
        }

        public APIRequestGetVideos requestIsEpisodeField(boolean value) {
            this.requestField("is_episode", value);
            return this;
        }

        public APIRequestGetVideos requestIsInstagramEligibleField() {
            return this.requestIsInstagramEligibleField(true);
        }

        public APIRequestGetVideos requestIsInstagramEligibleField(boolean value) {
            this.requestField("is_instagram_eligible", value);
            return this;
        }

        public APIRequestGetVideos requestIsReferenceOnlyField() {
            return this.requestIsReferenceOnlyField(true);
        }

        public APIRequestGetVideos requestIsReferenceOnlyField(boolean value) {
            this.requestField("is_reference_only", value);
            return this;
        }

        public APIRequestGetVideos requestLengthField() {
            return this.requestLengthField(true);
        }

        public APIRequestGetVideos requestLengthField(boolean value) {
            this.requestField("length", value);
            return this;
        }

        public APIRequestGetVideos requestLiveAudienceCountField() {
            return this.requestLiveAudienceCountField(true);
        }

        public APIRequestGetVideos requestLiveAudienceCountField(boolean value) {
            this.requestField("live_audience_count", value);
            return this;
        }

        public APIRequestGetVideos requestLiveStatusField() {
            return this.requestLiveStatusField(true);
        }

        public APIRequestGetVideos requestLiveStatusField(boolean value) {
            this.requestField("live_status", value);
            return this;
        }

        public APIRequestGetVideos requestMusicVideoCopyrightField() {
            return this.requestMusicVideoCopyrightField(true);
        }

        public APIRequestGetVideos requestMusicVideoCopyrightField(boolean value) {
            this.requestField("music_video_copyright", value);
            return this;
        }

        public APIRequestGetVideos requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGetVideos requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGetVideos requestPictureField() {
            return this.requestPictureField(true);
        }

        public APIRequestGetVideos requestPictureField(boolean value) {
            this.requestField("picture", value);
            return this;
        }

        public APIRequestGetVideos requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGetVideos requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGetVideos requestPremiereLivingRoomStatusField() {
            return this.requestPremiereLivingRoomStatusField(true);
        }

        public APIRequestGetVideos requestPremiereLivingRoomStatusField(boolean value) {
            this.requestField("premiere_living_room_status", value);
            return this;
        }

        public APIRequestGetVideos requestPrivacyField() {
            return this.requestPrivacyField(true);
        }

        public APIRequestGetVideos requestPrivacyField(boolean value) {
            this.requestField("privacy", value);
            return this;
        }

        public APIRequestGetVideos requestPublishedField() {
            return this.requestPublishedField(true);
        }

        public APIRequestGetVideos requestPublishedField(boolean value) {
            this.requestField("published", value);
            return this;
        }

        public APIRequestGetVideos requestScheduledPublishTimeField() {
            return this.requestScheduledPublishTimeField(true);
        }

        public APIRequestGetVideos requestScheduledPublishTimeField(boolean value) {
            this.requestField("scheduled_publish_time", value);
            return this;
        }

        public APIRequestGetVideos requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGetVideos requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGetVideos requestSphericalField() {
            return this.requestSphericalField(true);
        }

        public APIRequestGetVideos requestSphericalField(boolean value) {
            this.requestField("spherical", value);
            return this;
        }

        public APIRequestGetVideos requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetVideos requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetVideos requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetVideos requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetVideos requestUniversalVideoIdField() {
            return this.requestUniversalVideoIdField(true);
        }

        public APIRequestGetVideos requestUniversalVideoIdField(boolean value) {
            this.requestField("universal_video_id", value);
            return this;
        }

        public APIRequestGetVideos requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetVideos requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteVideos
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"video_ids"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDeleteVideos.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteVideos(String nodeId, APIContext context) {
            super(context, nodeId, "/videos", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteVideos setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteVideos setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteVideos setVideoIds(List<String> videoIds) {
            this.setParam("video_ids", videoIds);
            return this;
        }

        public APIRequestDeleteVideos setVideoIds(String videoIds) {
            this.setParam("video_ids", videoIds);
            return this;
        }

        public APIRequestDeleteVideos requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteVideos requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteVideos requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteVideos requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteVideos requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteVideos requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateComment
    extends APIRequest<Comment> {
        Comment lastResponse = null;
        public static final String[] PARAMS = new String[]{"attachment_id", "attachment_share_url", "attachment_url", "comment_privacy_value", "facepile_mentioned_ids", "feedback_source", "is_offline", "message", "nectar_module", "object_id", "parent_comment_id", "text", "tracking"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Comment getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Comment parseResponse(String response, String header) throws APIException {
            return Comment.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Comment execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Comment execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Comment> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Comment> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Comment>(){

                public Comment apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateComment.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateComment(String nodeId, APIContext context) {
            super(context, nodeId, "/comments", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateComment setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateComment setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateComment setAttachmentId(String attachmentId) {
            this.setParam("attachment_id", attachmentId);
            return this;
        }

        public APIRequestCreateComment setAttachmentShareUrl(String attachmentShareUrl) {
            this.setParam("attachment_share_url", attachmentShareUrl);
            return this;
        }

        public APIRequestCreateComment setAttachmentUrl(String attachmentUrl) {
            this.setParam("attachment_url", attachmentUrl);
            return this;
        }

        public APIRequestCreateComment setCommentPrivacyValue(Comment.EnumCommentPrivacyValue commentPrivacyValue) {
            this.setParam("comment_privacy_value", (Object)commentPrivacyValue);
            return this;
        }

        public APIRequestCreateComment setCommentPrivacyValue(String commentPrivacyValue) {
            this.setParam("comment_privacy_value", commentPrivacyValue);
            return this;
        }

        public APIRequestCreateComment setFacepileMentionedIds(List<String> facepileMentionedIds) {
            this.setParam("facepile_mentioned_ids", facepileMentionedIds);
            return this;
        }

        public APIRequestCreateComment setFacepileMentionedIds(String facepileMentionedIds) {
            this.setParam("facepile_mentioned_ids", facepileMentionedIds);
            return this;
        }

        public APIRequestCreateComment setFeedbackSource(String feedbackSource) {
            this.setParam("feedback_source", feedbackSource);
            return this;
        }

        public APIRequestCreateComment setIsOffline(Boolean isOffline) {
            this.setParam("is_offline", isOffline);
            return this;
        }

        public APIRequestCreateComment setIsOffline(String isOffline) {
            this.setParam("is_offline", isOffline);
            return this;
        }

        public APIRequestCreateComment setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateComment setNectarModule(String nectarModule) {
            this.setParam("nectar_module", nectarModule);
            return this;
        }

        public APIRequestCreateComment setObjectId(String objectId) {
            this.setParam("object_id", objectId);
            return this;
        }

        public APIRequestCreateComment setParentCommentId(Object parentCommentId) {
            this.setParam("parent_comment_id", parentCommentId);
            return this;
        }

        public APIRequestCreateComment setParentCommentId(String parentCommentId) {
            this.setParam("parent_comment_id", parentCommentId);
            return this;
        }

        public APIRequestCreateComment setText(String text) {
            this.setParam("text", text);
            return this;
        }

        public APIRequestCreateComment setTracking(String tracking) {
            this.setParam("tracking", tracking);
            return this;
        }

        public APIRequestCreateComment requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateComment requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateComment requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateComment requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateComment requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateComment requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

