/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessSettingLogsData
extends APINode {
    @SerializedName(value="actor")
    private Object mActor = null;
    @SerializedName(value="event_object")
    private Object mEventObject = null;
    @SerializedName(value="event_time")
    private String mEventTime = null;
    @SerializedName(value="event_type")
    private String mEventType = null;
    @SerializedName(value="extra_data")
    private Object mExtraData = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static BusinessSettingLogsData loadJSON(String json, APIContext context, String header) {
        BusinessSettingLogsData businessSettingLogsData = (BusinessSettingLogsData)BusinessSettingLogsData.getGson().fromJson(json, BusinessSettingLogsData.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessSettingLogsData.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessSettingLogsData.context = context;
        businessSettingLogsData.rawValue = json;
        businessSettingLogsData.header = header;
        return businessSettingLogsData;
    }

    public static APINodeList<BusinessSettingLogsData> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BusinessSettingLogsData> businessSettingLogsDatas = new APINodeList<BusinessSettingLogsData>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessSettingLogsDatas.add(BusinessSettingLogsData.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return businessSettingLogsDatas;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessSettingLogsDatas.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessSettingLogsDatas.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            businessSettingLogsDatas.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessSettingLogsDatas.add(BusinessSettingLogsData.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessSettingLogsDatas.add(BusinessSettingLogsData.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessSettingLogsDatas.add(BusinessSettingLogsData.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return businessSettingLogsDatas;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessSettingLogsDatas.add(BusinessSettingLogsData.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return businessSettingLogsDatas;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessSettingLogsDatas.add(BusinessSettingLogsData.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessSettingLogsDatas;
                }
                businessSettingLogsDatas.clear();
                businessSettingLogsDatas.add(BusinessSettingLogsData.loadJSON(json, context, header));
                return businessSettingLogsDatas;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessSettingLogsData.getGson().toJson((Object)this);
    }

    public Object getFieldActor() {
        return this.mActor;
    }

    public BusinessSettingLogsData setFieldActor(Object value) {
        this.mActor = value;
        return this;
    }

    public Object getFieldEventObject() {
        return this.mEventObject;
    }

    public BusinessSettingLogsData setFieldEventObject(Object value) {
        this.mEventObject = value;
        return this;
    }

    public String getFieldEventTime() {
        return this.mEventTime;
    }

    public BusinessSettingLogsData setFieldEventTime(String value) {
        this.mEventTime = value;
        return this;
    }

    public String getFieldEventType() {
        return this.mEventType;
    }

    public BusinessSettingLogsData setFieldEventType(String value) {
        this.mEventType = value;
        return this;
    }

    public Object getFieldExtraData() {
        return this.mExtraData;
    }

    public BusinessSettingLogsData setFieldExtraData(Object value) {
        this.mExtraData = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessSettingLogsData copyFrom(BusinessSettingLogsData instance) {
        this.mActor = instance.mActor;
        this.mEventObject = instance.mEventObject;
        this.mEventTime = instance.mEventTime;
        this.mEventType = instance.mEventType;
        this.mExtraData = instance.mExtraData;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessSettingLogsData> getParser() {
        return new APIRequest.ResponseParser<BusinessSettingLogsData>(){

            @Override
            public APINodeList<BusinessSettingLogsData> parseResponse(String response, APIContext context, APIRequest<BusinessSettingLogsData> request, String header) throws APIException.MalformedResponseException {
                return BusinessSettingLogsData.parseResponse(response, context, request, header);
            }
        };
    }
}

