/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Application;
import com.facebook.ads.sdk.Page;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageCallToAction
extends APINode {
    @SerializedName(value="android_app")
    private Application mAndroidApp = null;
    @SerializedName(value="android_deeplink")
    private String mAndroidDeeplink = null;
    @SerializedName(value="android_destination_type")
    private String mAndroidDestinationType = null;
    @SerializedName(value="android_package_name")
    private String mAndroidPackageName = null;
    @SerializedName(value="android_url")
    private String mAndroidUrl = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="email_address")
    private String mEmailAddress = null;
    @SerializedName(value="from")
    private Page mFrom = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="intl_number_with_plus")
    private String mIntlNumberWithPlus = null;
    @SerializedName(value="iphone_app")
    private Application mIphoneApp = null;
    @SerializedName(value="iphone_deeplink")
    private String mIphoneDeeplink = null;
    @SerializedName(value="iphone_destination_type")
    private String mIphoneDestinationType = null;
    @SerializedName(value="iphone_url")
    private String mIphoneUrl = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="type")
    private String mType = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="web_destination_type")
    private String mWebDestinationType = null;
    @SerializedName(value="web_url")
    private String mWebUrl = null;
    protected static Gson gson = null;

    PageCallToAction() {
    }

    public PageCallToAction(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PageCallToAction(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PageCallToAction fetch() throws APIException {
        PageCallToAction newInstance = PageCallToAction.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PageCallToAction fetchById(Long id, APIContext context) throws APIException {
        return PageCallToAction.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PageCallToAction> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PageCallToAction.fetchByIdAsync(id.toString(), context);
    }

    public static PageCallToAction fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PageCallToAction> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PageCallToAction> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PageCallToAction>(context, "", "/", "GET", PageCallToAction.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PageCallToAction>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PageCallToAction>(context, "", "/", "GET", PageCallToAction.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PageCallToAction loadJSON(String json, APIContext context, String header) {
        PageCallToAction pageCallToAction = (PageCallToAction)PageCallToAction.getGson().fromJson(json, PageCallToAction.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pageCallToAction.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pageCallToAction.context = context;
        pageCallToAction.rawValue = json;
        pageCallToAction.header = header;
        return pageCallToAction;
    }

    public static APINodeList<PageCallToAction> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PageCallToAction> pageCallToActions = new APINodeList<PageCallToAction>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pageCallToActions.add(PageCallToAction.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return pageCallToActions;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pageCallToActions.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pageCallToActions.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            pageCallToActions.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pageCallToActions.add(PageCallToAction.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pageCallToActions.add(PageCallToAction.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pageCallToActions.add(PageCallToAction.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return pageCallToActions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pageCallToActions.add(PageCallToAction.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return pageCallToActions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pageCallToActions.add(PageCallToAction.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pageCallToActions;
                }
                pageCallToActions.clear();
                pageCallToActions.add(PageCallToAction.loadJSON(json, context, header));
                return pageCallToActions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PageCallToAction.getGson().toJson((Object)this);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public Application getFieldAndroidApp() {
        if (this.mAndroidApp != null) {
            this.mAndroidApp.context = this.getContext();
        }
        return this.mAndroidApp;
    }

    public String getFieldAndroidDeeplink() {
        return this.mAndroidDeeplink;
    }

    public String getFieldAndroidDestinationType() {
        return this.mAndroidDestinationType;
    }

    public String getFieldAndroidPackageName() {
        return this.mAndroidPackageName;
    }

    public String getFieldAndroidUrl() {
        return this.mAndroidUrl;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldEmailAddress() {
        return this.mEmailAddress;
    }

    public Page getFieldFrom() {
        if (this.mFrom != null) {
            this.mFrom.context = this.getContext();
        }
        return this.mFrom;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldIntlNumberWithPlus() {
        return this.mIntlNumberWithPlus;
    }

    public Application getFieldIphoneApp() {
        if (this.mIphoneApp != null) {
            this.mIphoneApp.context = this.getContext();
        }
        return this.mIphoneApp;
    }

    public String getFieldIphoneDeeplink() {
        return this.mIphoneDeeplink;
    }

    public String getFieldIphoneDestinationType() {
        return this.mIphoneDestinationType;
    }

    public String getFieldIphoneUrl() {
        return this.mIphoneUrl;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldType() {
        return this.mType;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public String getFieldWebDestinationType() {
        return this.mWebDestinationType;
    }

    public String getFieldWebUrl() {
        return this.mWebUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PageCallToAction copyFrom(PageCallToAction instance) {
        this.mAndroidApp = instance.mAndroidApp;
        this.mAndroidDeeplink = instance.mAndroidDeeplink;
        this.mAndroidDestinationType = instance.mAndroidDestinationType;
        this.mAndroidPackageName = instance.mAndroidPackageName;
        this.mAndroidUrl = instance.mAndroidUrl;
        this.mCreatedTime = instance.mCreatedTime;
        this.mEmailAddress = instance.mEmailAddress;
        this.mFrom = instance.mFrom;
        this.mId = instance.mId;
        this.mIntlNumberWithPlus = instance.mIntlNumberWithPlus;
        this.mIphoneApp = instance.mIphoneApp;
        this.mIphoneDeeplink = instance.mIphoneDeeplink;
        this.mIphoneDestinationType = instance.mIphoneDestinationType;
        this.mIphoneUrl = instance.mIphoneUrl;
        this.mStatus = instance.mStatus;
        this.mType = instance.mType;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mWebDestinationType = instance.mWebDestinationType;
        this.mWebUrl = instance.mWebUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PageCallToAction> getParser() {
        return new APIRequest.ResponseParser<PageCallToAction>(){

            @Override
            public APINodeList<PageCallToAction> parseResponse(String response, APIContext context, APIRequest<PageCallToAction> request, String header) throws APIException.MalformedResponseException {
                return PageCallToAction.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumWebDestinationType {
        VALUE_BECOME_SUPPORTER("BECOME_SUPPORTER"),
        VALUE_EMAIL("EMAIL"),
        VALUE_MESSENGER("MESSENGER"),
        VALUE_NONE("NONE"),
        VALUE_SHOP_ON_FACEBOOK("SHOP_ON_FACEBOOK"),
        VALUE_WEBSITE("WEBSITE");

        private String value;

        private EnumWebDestinationType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_BOOK_APPOINTMENT("BOOK_APPOINTMENT"),
        VALUE_BOOK_NOW("BOOK_NOW"),
        VALUE_BUY_TICKETS("BUY_TICKETS"),
        VALUE_CALL_NOW("CALL_NOW"),
        VALUE_CHARITY_DONATE("CHARITY_DONATE"),
        VALUE_CONTACT_US("CONTACT_US"),
        VALUE_DONATE_NOW("DONATE_NOW"),
        VALUE_EMAIL("EMAIL"),
        VALUE_GET_DIRECTIONS("GET_DIRECTIONS"),
        VALUE_GET_OFFER("GET_OFFER"),
        VALUE_GET_OFFER_VIEW("GET_OFFER_VIEW"),
        VALUE_INTERESTED("INTERESTED"),
        VALUE_LEARN_MORE("LEARN_MORE"),
        VALUE_LISTEN("LISTEN"),
        VALUE_LOCAL_DEV_PLATFORM("LOCAL_DEV_PLATFORM"),
        VALUE_MESSAGE("MESSAGE"),
        VALUE_OPEN_APP("OPEN_APP"),
        VALUE_PLAY_MUSIC("PLAY_MUSIC"),
        VALUE_PLAY_NOW("PLAY_NOW"),
        VALUE_REQUEST_APPOINTMENT("REQUEST_APPOINTMENT"),
        VALUE_REQUEST_QUOTE("REQUEST_QUOTE"),
        VALUE_SHOP_NOW("SHOP_NOW"),
        VALUE_SHOP_ON_FACEBOOK("SHOP_ON_FACEBOOK"),
        VALUE_SIGN_UP("SIGN_UP"),
        VALUE_VISIT_GROUP("VISIT_GROUP"),
        VALUE_WATCH_NOW("WATCH_NOW"),
        VALUE_WOODHENGE_SUPPORT("WOODHENGE_SUPPORT");

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumIphoneDestinationType {
        VALUE_APP_DEEPLINK("APP_DEEPLINK"),
        VALUE_EMAIL("EMAIL"),
        VALUE_FACEBOOK_APP("FACEBOOK_APP"),
        VALUE_MESSENGER("MESSENGER"),
        VALUE_NONE("NONE"),
        VALUE_PHONE_CALL("PHONE_CALL"),
        VALUE_SHOP_ON_FACEBOOK("SHOP_ON_FACEBOOK"),
        VALUE_WEBSITE("WEBSITE");

        private String value;

        private EnumIphoneDestinationType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumAndroidDestinationType {
        VALUE_APP_DEEPLINK("APP_DEEPLINK"),
        VALUE_EMAIL("EMAIL"),
        VALUE_FACEBOOK_APP("FACEBOOK_APP"),
        VALUE_MESSENGER("MESSENGER"),
        VALUE_NONE("NONE"),
        VALUE_PHONE_CALL("PHONE_CALL"),
        VALUE_SHOP_ON_FACEBOOK("SHOP_ON_FACEBOOK"),
        VALUE_WEBSITE("WEBSITE");

        private String value;

        private EnumAndroidDestinationType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<PageCallToAction> {
        PageCallToAction lastResponse = null;
        public static final String[] PARAMS = new String[]{"android_app_id", "android_deeplink", "android_destination_type", "android_package_name", "android_url", "email_address", "intl_number_with_plus", "iphone_app_id", "iphone_deeplink", "iphone_destination_type", "iphone_url", "type", "web_destination_type", "web_url"};
        public static final String[] FIELDS = new String[0];

        @Override
        public PageCallToAction getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PageCallToAction parseResponse(String response, String header) throws APIException {
            return PageCallToAction.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PageCallToAction execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PageCallToAction execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PageCallToAction> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PageCallToAction> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, PageCallToAction>(){

                public PageCallToAction apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAndroidAppId(Long androidAppId) {
            this.setParam("android_app_id", androidAppId);
            return this;
        }

        public APIRequestUpdate setAndroidAppId(String androidAppId) {
            this.setParam("android_app_id", androidAppId);
            return this;
        }

        public APIRequestUpdate setAndroidDeeplink(String androidDeeplink) {
            this.setParam("android_deeplink", androidDeeplink);
            return this;
        }

        public APIRequestUpdate setAndroidDestinationType(EnumAndroidDestinationType androidDestinationType) {
            this.setParam("android_destination_type", (Object)androidDestinationType);
            return this;
        }

        public APIRequestUpdate setAndroidDestinationType(String androidDestinationType) {
            this.setParam("android_destination_type", androidDestinationType);
            return this;
        }

        public APIRequestUpdate setAndroidPackageName(String androidPackageName) {
            this.setParam("android_package_name", androidPackageName);
            return this;
        }

        public APIRequestUpdate setAndroidUrl(String androidUrl) {
            this.setParam("android_url", androidUrl);
            return this;
        }

        public APIRequestUpdate setEmailAddress(String emailAddress) {
            this.setParam("email_address", emailAddress);
            return this;
        }

        public APIRequestUpdate setIntlNumberWithPlus(String intlNumberWithPlus) {
            this.setParam("intl_number_with_plus", intlNumberWithPlus);
            return this;
        }

        public APIRequestUpdate setIphoneAppId(Long iphoneAppId) {
            this.setParam("iphone_app_id", iphoneAppId);
            return this;
        }

        public APIRequestUpdate setIphoneAppId(String iphoneAppId) {
            this.setParam("iphone_app_id", iphoneAppId);
            return this;
        }

        public APIRequestUpdate setIphoneDeeplink(String iphoneDeeplink) {
            this.setParam("iphone_deeplink", iphoneDeeplink);
            return this;
        }

        public APIRequestUpdate setIphoneDestinationType(EnumIphoneDestinationType iphoneDestinationType) {
            this.setParam("iphone_destination_type", (Object)iphoneDestinationType);
            return this;
        }

        public APIRequestUpdate setIphoneDestinationType(String iphoneDestinationType) {
            this.setParam("iphone_destination_type", iphoneDestinationType);
            return this;
        }

        public APIRequestUpdate setIphoneUrl(String iphoneUrl) {
            this.setParam("iphone_url", iphoneUrl);
            return this;
        }

        public APIRequestUpdate setType(EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestUpdate setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestUpdate setWebDestinationType(EnumWebDestinationType webDestinationType) {
            this.setParam("web_destination_type", (Object)webDestinationType);
            return this;
        }

        public APIRequestUpdate setWebDestinationType(String webDestinationType) {
            this.setParam("web_destination_type", webDestinationType);
            return this;
        }

        public APIRequestUpdate setWebUrl(String webUrl) {
            this.setParam("web_url", webUrl);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<PageCallToAction> {
        PageCallToAction lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"android_app", "android_deeplink", "android_destination_type", "android_package_name", "android_url", "created_time", "email_address", "from", "id", "intl_number_with_plus", "iphone_app", "iphone_deeplink", "iphone_destination_type", "iphone_url", "status", "type", "updated_time", "web_destination_type", "web_url"};

        @Override
        public PageCallToAction getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PageCallToAction parseResponse(String response, String header) throws APIException {
            return PageCallToAction.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PageCallToAction execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PageCallToAction execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PageCallToAction> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PageCallToAction> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, PageCallToAction>(){

                public PageCallToAction apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAndroidAppField() {
            return this.requestAndroidAppField(true);
        }

        public APIRequestGet requestAndroidAppField(boolean value) {
            this.requestField("android_app", value);
            return this;
        }

        public APIRequestGet requestAndroidDeeplinkField() {
            return this.requestAndroidDeeplinkField(true);
        }

        public APIRequestGet requestAndroidDeeplinkField(boolean value) {
            this.requestField("android_deeplink", value);
            return this;
        }

        public APIRequestGet requestAndroidDestinationTypeField() {
            return this.requestAndroidDestinationTypeField(true);
        }

        public APIRequestGet requestAndroidDestinationTypeField(boolean value) {
            this.requestField("android_destination_type", value);
            return this;
        }

        public APIRequestGet requestAndroidPackageNameField() {
            return this.requestAndroidPackageNameField(true);
        }

        public APIRequestGet requestAndroidPackageNameField(boolean value) {
            this.requestField("android_package_name", value);
            return this;
        }

        public APIRequestGet requestAndroidUrlField() {
            return this.requestAndroidUrlField(true);
        }

        public APIRequestGet requestAndroidUrlField(boolean value) {
            this.requestField("android_url", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestEmailAddressField() {
            return this.requestEmailAddressField(true);
        }

        public APIRequestGet requestEmailAddressField(boolean value) {
            this.requestField("email_address", value);
            return this;
        }

        public APIRequestGet requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGet requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIntlNumberWithPlusField() {
            return this.requestIntlNumberWithPlusField(true);
        }

        public APIRequestGet requestIntlNumberWithPlusField(boolean value) {
            this.requestField("intl_number_with_plus", value);
            return this;
        }

        public APIRequestGet requestIphoneAppField() {
            return this.requestIphoneAppField(true);
        }

        public APIRequestGet requestIphoneAppField(boolean value) {
            this.requestField("iphone_app", value);
            return this;
        }

        public APIRequestGet requestIphoneDeeplinkField() {
            return this.requestIphoneDeeplinkField(true);
        }

        public APIRequestGet requestIphoneDeeplinkField(boolean value) {
            this.requestField("iphone_deeplink", value);
            return this;
        }

        public APIRequestGet requestIphoneDestinationTypeField() {
            return this.requestIphoneDestinationTypeField(true);
        }

        public APIRequestGet requestIphoneDestinationTypeField(boolean value) {
            this.requestField("iphone_destination_type", value);
            return this;
        }

        public APIRequestGet requestIphoneUrlField() {
            return this.requestIphoneUrlField(true);
        }

        public APIRequestGet requestIphoneUrlField(boolean value) {
            this.requestField("iphone_url", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGet requestWebDestinationTypeField() {
            return this.requestWebDestinationTypeField(true);
        }

        public APIRequestGet requestWebDestinationTypeField(boolean value) {
            this.requestField("web_destination_type", value);
            return this;
        }

        public APIRequestGet requestWebUrlField() {
            return this.requestWebUrlField(true);
        }

        public APIRequestGet requestWebUrlField(boolean value) {
            this.requestField("web_url", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

