/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessUnit
extends APINode {
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="excluded_sources")
    private Object mExcludedSources = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_enabled_for_measurement")
    private Boolean mIsEnabledForMeasurement = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="time_zone")
    private String mTimeZone = null;
    @SerializedName(value="visits_available_date")
    private Long mVisitsAvailableDate = null;
    protected static Gson gson = null;

    BusinessUnit() {
    }

    public BusinessUnit(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BusinessUnit(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BusinessUnit fetch() throws APIException {
        BusinessUnit newInstance = BusinessUnit.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BusinessUnit fetchById(Long id, APIContext context) throws APIException {
        return BusinessUnit.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BusinessUnit> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BusinessUnit.fetchByIdAsync(id.toString(), context);
    }

    public static BusinessUnit fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<BusinessUnit> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<BusinessUnit> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BusinessUnit>(context, "", "/", "GET", BusinessUnit.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BusinessUnit>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<BusinessUnit>(context, "", "/", "GET", BusinessUnit.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BusinessUnit loadJSON(String json, APIContext context, String header) {
        BusinessUnit businessUnit = (BusinessUnit)BusinessUnit.getGson().fromJson(json, BusinessUnit.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessUnit.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessUnit.context = context;
        businessUnit.rawValue = json;
        businessUnit.header = header;
        return businessUnit;
    }

    public static APINodeList<BusinessUnit> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BusinessUnit> businessUnits = new APINodeList<BusinessUnit>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessUnits.add(BusinessUnit.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return businessUnits;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessUnits.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessUnits.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            businessUnits.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessUnits.add(BusinessUnit.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessUnits.add(BusinessUnit.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessUnits.add(BusinessUnit.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return businessUnits;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessUnits.add(BusinessUnit.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return businessUnits;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessUnits.add(BusinessUnit.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessUnits;
                }
                businessUnits.clear();
                businessUnits.add(BusinessUnit.loadJSON(json, context, header));
                return businessUnits;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessUnit.getGson().toJson((Object)this);
    }

    public APIRequestGetAtlasSalesAccesses getAtlasSalesAccesses() {
        return new APIRequestGetAtlasSalesAccesses(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAtlasSalesAccess createAtlasSalesAccess() {
        return new APIRequestCreateAtlasSalesAccess(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public Object getFieldExcludedSources() {
        return this.mExcludedSources;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsEnabledForMeasurement() {
        return this.mIsEnabledForMeasurement;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldTimeZone() {
        return this.mTimeZone;
    }

    public Long getFieldVisitsAvailableDate() {
        return this.mVisitsAvailableDate;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessUnit copyFrom(BusinessUnit instance) {
        this.mBusiness = instance.mBusiness;
        this.mCreationTime = instance.mCreationTime;
        this.mCurrency = instance.mCurrency;
        this.mExcludedSources = instance.mExcludedSources;
        this.mId = instance.mId;
        this.mIsEnabledForMeasurement = instance.mIsEnabledForMeasurement;
        this.mName = instance.mName;
        this.mTimeZone = instance.mTimeZone;
        this.mVisitsAvailableDate = instance.mVisitsAvailableDate;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessUnit> getParser() {
        return new APIRequest.ResponseParser<BusinessUnit>(){

            @Override
            public APINodeList<BusinessUnit> parseResponse(String response, APIContext context, APIRequest<BusinessUnit> request, String header) throws APIException.MalformedResponseException {
                return BusinessUnit.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<BusinessUnit> {
        BusinessUnit lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "creation_time", "currency", "excluded_sources", "id", "is_enabled_for_measurement", "name", "time_zone", "visits_available_date"};

        @Override
        public BusinessUnit getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessUnit parseResponse(String response, String header) throws APIException {
            return BusinessUnit.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessUnit execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessUnit execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessUnit> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessUnit> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessUnit>(){

                public BusinessUnit apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestExcludedSourcesField() {
            return this.requestExcludedSourcesField(true);
        }

        public APIRequestGet requestExcludedSourcesField(boolean value) {
            this.requestField("excluded_sources", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsEnabledForMeasurementField() {
            return this.requestIsEnabledForMeasurementField(true);
        }

        public APIRequestGet requestIsEnabledForMeasurementField(boolean value) {
            this.requestField("is_enabled_for_measurement", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestTimeZoneField() {
            return this.requestTimeZoneField(true);
        }

        public APIRequestGet requestTimeZoneField(boolean value) {
            this.requestField("time_zone", value);
            return this;
        }

        public APIRequestGet requestVisitsAvailableDateField() {
            return this.requestVisitsAvailableDateField(true);
        }

        public APIRequestGet requestVisitsAvailableDateField(boolean value) {
            this.requestField("visits_available_date", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAtlasSalesAccess
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"access_request_id", "status"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateAtlasSalesAccess.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAtlasSalesAccess(String nodeId, APIContext context) {
            super(context, nodeId, "/atlas_sales_accesses", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAtlasSalesAccess setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAtlasSalesAccess setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAtlasSalesAccess setAccessRequestId(String accessRequestId) {
            this.setParam("access_request_id", accessRequestId);
            return this;
        }

        public APIRequestCreateAtlasSalesAccess setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestCreateAtlasSalesAccess requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAtlasSalesAccess requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAtlasSalesAccess requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAtlasSalesAccess requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAtlasSalesAccess requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAtlasSalesAccess requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAtlasSalesAccesses
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetAtlasSalesAccesses.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAtlasSalesAccesses(String nodeId, APIContext context) {
            super(context, nodeId, "/atlas_sales_accesses", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAtlasSalesAccesses setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAtlasSalesAccesses setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAtlasSalesAccesses requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAtlasSalesAccesses requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAtlasSalesAccesses requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAtlasSalesAccesses requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAtlasSalesAccesses requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAtlasSalesAccesses requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

