/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.TargetingGeoLocationCity;
import com.facebook.ads.sdk.TargetingGeoLocationCustomLocation;
import com.facebook.ads.sdk.TargetingGeoLocationElectoralDistrict;
import com.facebook.ads.sdk.TargetingGeoLocationGeoEntities;
import com.facebook.ads.sdk.TargetingGeoLocationLocationCluster;
import com.facebook.ads.sdk.TargetingGeoLocationLocationExpansion;
import com.facebook.ads.sdk.TargetingGeoLocationMarket;
import com.facebook.ads.sdk.TargetingGeoLocationPlace;
import com.facebook.ads.sdk.TargetingGeoLocationPoliticalDistrict;
import com.facebook.ads.sdk.TargetingGeoLocationRegion;
import com.facebook.ads.sdk.TargetingGeoLocationZip;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetingGeoLocation
extends APINode {
    @SerializedName(value="cities")
    private List<TargetingGeoLocationCity> mCities = null;
    @SerializedName(value="countries")
    private List<String> mCountries = null;
    @SerializedName(value="country_groups")
    private List<String> mCountryGroups = null;
    @SerializedName(value="custom_locations")
    private List<TargetingGeoLocationCustomLocation> mCustomLocations = null;
    @SerializedName(value="electoral_districts")
    private List<TargetingGeoLocationElectoralDistrict> mElectoralDistricts = null;
    @SerializedName(value="geo_markets")
    private List<TargetingGeoLocationMarket> mGeoMarkets = null;
    @SerializedName(value="large_geo_areas")
    private List<TargetingGeoLocationGeoEntities> mLargeGeoAreas = null;
    @SerializedName(value="location_cluster_ids")
    private List<TargetingGeoLocationLocationCluster> mLocationClusterIds = null;
    @SerializedName(value="location_expansion")
    private TargetingGeoLocationLocationExpansion mLocationExpansion = null;
    @SerializedName(value="location_set_ids")
    private List<String> mLocationSetIds = null;
    @SerializedName(value="location_types")
    private List<String> mLocationTypes = null;
    @SerializedName(value="medium_geo_areas")
    private List<TargetingGeoLocationGeoEntities> mMediumGeoAreas = null;
    @SerializedName(value="metro_areas")
    private List<TargetingGeoLocationGeoEntities> mMetroAreas = null;
    @SerializedName(value="neighborhoods")
    private List<TargetingGeoLocationGeoEntities> mNeighborhoods = null;
    @SerializedName(value="places")
    private List<TargetingGeoLocationPlace> mPlaces = null;
    @SerializedName(value="political_districts")
    private List<TargetingGeoLocationPoliticalDistrict> mPoliticalDistricts = null;
    @SerializedName(value="regions")
    private List<TargetingGeoLocationRegion> mRegions = null;
    @SerializedName(value="small_geo_areas")
    private List<TargetingGeoLocationGeoEntities> mSmallGeoAreas = null;
    @SerializedName(value="subcities")
    private List<TargetingGeoLocationGeoEntities> mSubcities = null;
    @SerializedName(value="subneighborhoods")
    private List<TargetingGeoLocationGeoEntities> mSubneighborhoods = null;
    @SerializedName(value="zips")
    private List<TargetingGeoLocationZip> mZips = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static TargetingGeoLocation loadJSON(String json, APIContext context, String header) {
        TargetingGeoLocation targetingGeoLocation = (TargetingGeoLocation)TargetingGeoLocation.getGson().fromJson(json, TargetingGeoLocation.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(targetingGeoLocation.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        targetingGeoLocation.context = context;
        targetingGeoLocation.rawValue = json;
        targetingGeoLocation.header = header;
        return targetingGeoLocation;
    }

    public static APINodeList<TargetingGeoLocation> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<TargetingGeoLocation> targetingGeoLocations = new APINodeList<TargetingGeoLocation>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        targetingGeoLocations.add(TargetingGeoLocation.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return targetingGeoLocations;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            targetingGeoLocations.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        targetingGeoLocations.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            targetingGeoLocations.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            targetingGeoLocations.add(TargetingGeoLocation.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                targetingGeoLocations.add(TargetingGeoLocation.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            targetingGeoLocations.add(TargetingGeoLocation.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return targetingGeoLocations;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        targetingGeoLocations.add(TargetingGeoLocation.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return targetingGeoLocations;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        targetingGeoLocations.add(TargetingGeoLocation.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return targetingGeoLocations;
                }
                targetingGeoLocations.clear();
                targetingGeoLocations.add(TargetingGeoLocation.loadJSON(json, context, header));
                return targetingGeoLocations;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return TargetingGeoLocation.getGson().toJson((Object)this);
    }

    public List<TargetingGeoLocationCity> getFieldCities() {
        return this.mCities;
    }

    public TargetingGeoLocation setFieldCities(List<TargetingGeoLocationCity> value) {
        this.mCities = value;
        return this;
    }

    public TargetingGeoLocation setFieldCities(String value) {
        Type type = new TypeToken<List<TargetingGeoLocationCity>>(){}.getType();
        this.mCities = (List)TargetingGeoLocationCity.getGson().fromJson(value, type);
        return this;
    }

    public List<String> getFieldCountries() {
        return this.mCountries;
    }

    public TargetingGeoLocation setFieldCountries(List<String> value) {
        this.mCountries = value;
        return this;
    }

    public List<String> getFieldCountryGroups() {
        return this.mCountryGroups;
    }

    public TargetingGeoLocation setFieldCountryGroups(List<String> value) {
        this.mCountryGroups = value;
        return this;
    }

    public List<TargetingGeoLocationCustomLocation> getFieldCustomLocations() {
        return this.mCustomLocations;
    }

    public TargetingGeoLocation setFieldCustomLocations(List<TargetingGeoLocationCustomLocation> value) {
        this.mCustomLocations = value;
        return this;
    }

    public TargetingGeoLocation setFieldCustomLocations(String value) {
        Type type = new TypeToken<List<TargetingGeoLocationCustomLocation>>(){}.getType();
        this.mCustomLocations = (List)TargetingGeoLocationCustomLocation.getGson().fromJson(value, type);
        return this;
    }

    public List<TargetingGeoLocationElectoralDistrict> getFieldElectoralDistricts() {
        return this.mElectoralDistricts;
    }

    public TargetingGeoLocation setFieldElectoralDistricts(List<TargetingGeoLocationElectoralDistrict> value) {
        this.mElectoralDistricts = value;
        return this;
    }

    public TargetingGeoLocation setFieldElectoralDistricts(String value) {
        Type type = new TypeToken<List<TargetingGeoLocationElectoralDistrict>>(){}.getType();
        this.mElectoralDistricts = (List)TargetingGeoLocationElectoralDistrict.getGson().fromJson(value, type);
        return this;
    }

    public List<TargetingGeoLocationMarket> getFieldGeoMarkets() {
        return this.mGeoMarkets;
    }

    public TargetingGeoLocation setFieldGeoMarkets(List<TargetingGeoLocationMarket> value) {
        this.mGeoMarkets = value;
        return this;
    }

    public TargetingGeoLocation setFieldGeoMarkets(String value) {
        Type type = new TypeToken<List<TargetingGeoLocationMarket>>(){}.getType();
        this.mGeoMarkets = (List)TargetingGeoLocationMarket.getGson().fromJson(value, type);
        return this;
    }

    public List<TargetingGeoLocationGeoEntities> getFieldLargeGeoAreas() {
        return this.mLargeGeoAreas;
    }

    public TargetingGeoLocation setFieldLargeGeoAreas(List<TargetingGeoLocationGeoEntities> value) {
        this.mLargeGeoAreas = value;
        return this;
    }

    public TargetingGeoLocation setFieldLargeGeoAreas(String value) {
        Type type = new TypeToken<List<TargetingGeoLocationGeoEntities>>(){}.getType();
        this.mLargeGeoAreas = (List)TargetingGeoLocationGeoEntities.getGson().fromJson(value, type);
        return this;
    }

    public List<TargetingGeoLocationLocationCluster> getFieldLocationClusterIds() {
        return this.mLocationClusterIds;
    }

    public TargetingGeoLocation setFieldLocationClusterIds(List<TargetingGeoLocationLocationCluster> value) {
        this.mLocationClusterIds = value;
        return this;
    }

    public TargetingGeoLocation setFieldLocationClusterIds(String value) {
        Type type = new TypeToken<List<TargetingGeoLocationLocationCluster>>(){}.getType();
        this.mLocationClusterIds = (List)TargetingGeoLocationLocationCluster.getGson().fromJson(value, type);
        return this;
    }

    public TargetingGeoLocationLocationExpansion getFieldLocationExpansion() {
        return this.mLocationExpansion;
    }

    public TargetingGeoLocation setFieldLocationExpansion(TargetingGeoLocationLocationExpansion value) {
        this.mLocationExpansion = value;
        return this;
    }

    public TargetingGeoLocation setFieldLocationExpansion(String value) {
        Type type = new TypeToken<TargetingGeoLocationLocationExpansion>(){}.getType();
        this.mLocationExpansion = (TargetingGeoLocationLocationExpansion)TargetingGeoLocationLocationExpansion.getGson().fromJson(value, type);
        return this;
    }

    public List<String> getFieldLocationSetIds() {
        return this.mLocationSetIds;
    }

    public TargetingGeoLocation setFieldLocationSetIds(List<String> value) {
        this.mLocationSetIds = value;
        return this;
    }

    public List<String> getFieldLocationTypes() {
        return this.mLocationTypes;
    }

    public TargetingGeoLocation setFieldLocationTypes(List<String> value) {
        this.mLocationTypes = value;
        return this;
    }

    public List<TargetingGeoLocationGeoEntities> getFieldMediumGeoAreas() {
        return this.mMediumGeoAreas;
    }

    public TargetingGeoLocation setFieldMediumGeoAreas(List<TargetingGeoLocationGeoEntities> value) {
        this.mMediumGeoAreas = value;
        return this;
    }

    public TargetingGeoLocation setFieldMediumGeoAreas(String value) {
        Type type = new TypeToken<List<TargetingGeoLocationGeoEntities>>(){}.getType();
        this.mMediumGeoAreas = (List)TargetingGeoLocationGeoEntities.getGson().fromJson(value, type);
        return this;
    }

    public List<TargetingGeoLocationGeoEntities> getFieldMetroAreas() {
        return this.mMetroAreas;
    }

    public TargetingGeoLocation setFieldMetroAreas(List<TargetingGeoLocationGeoEntities> value) {
        this.mMetroAreas = value;
        return this;
    }

    public TargetingGeoLocation setFieldMetroAreas(String value) {
        Type type = new TypeToken<List<TargetingGeoLocationGeoEntities>>(){}.getType();
        this.mMetroAreas = (List)TargetingGeoLocationGeoEntities.getGson().fromJson(value, type);
        return this;
    }

    public List<TargetingGeoLocationGeoEntities> getFieldNeighborhoods() {
        return this.mNeighborhoods;
    }

    public TargetingGeoLocation setFieldNeighborhoods(List<TargetingGeoLocationGeoEntities> value) {
        this.mNeighborhoods = value;
        return this;
    }

    public TargetingGeoLocation setFieldNeighborhoods(String value) {
        Type type = new TypeToken<List<TargetingGeoLocationGeoEntities>>(){}.getType();
        this.mNeighborhoods = (List)TargetingGeoLocationGeoEntities.getGson().fromJson(value, type);
        return this;
    }

    public List<TargetingGeoLocationPlace> getFieldPlaces() {
        return this.mPlaces;
    }

    public TargetingGeoLocation setFieldPlaces(List<TargetingGeoLocationPlace> value) {
        this.mPlaces = value;
        return this;
    }

    public TargetingGeoLocation setFieldPlaces(String value) {
        Type type = new TypeToken<List<TargetingGeoLocationPlace>>(){}.getType();
        this.mPlaces = (List)TargetingGeoLocationPlace.getGson().fromJson(value, type);
        return this;
    }

    public List<TargetingGeoLocationPoliticalDistrict> getFieldPoliticalDistricts() {
        return this.mPoliticalDistricts;
    }

    public TargetingGeoLocation setFieldPoliticalDistricts(List<TargetingGeoLocationPoliticalDistrict> value) {
        this.mPoliticalDistricts = value;
        return this;
    }

    public TargetingGeoLocation setFieldPoliticalDistricts(String value) {
        Type type = new TypeToken<List<TargetingGeoLocationPoliticalDistrict>>(){}.getType();
        this.mPoliticalDistricts = (List)TargetingGeoLocationPoliticalDistrict.getGson().fromJson(value, type);
        return this;
    }

    public List<TargetingGeoLocationRegion> getFieldRegions() {
        return this.mRegions;
    }

    public TargetingGeoLocation setFieldRegions(List<TargetingGeoLocationRegion> value) {
        this.mRegions = value;
        return this;
    }

    public TargetingGeoLocation setFieldRegions(String value) {
        Type type = new TypeToken<List<TargetingGeoLocationRegion>>(){}.getType();
        this.mRegions = (List)TargetingGeoLocationRegion.getGson().fromJson(value, type);
        return this;
    }

    public List<TargetingGeoLocationGeoEntities> getFieldSmallGeoAreas() {
        return this.mSmallGeoAreas;
    }

    public TargetingGeoLocation setFieldSmallGeoAreas(List<TargetingGeoLocationGeoEntities> value) {
        this.mSmallGeoAreas = value;
        return this;
    }

    public TargetingGeoLocation setFieldSmallGeoAreas(String value) {
        Type type = new TypeToken<List<TargetingGeoLocationGeoEntities>>(){}.getType();
        this.mSmallGeoAreas = (List)TargetingGeoLocationGeoEntities.getGson().fromJson(value, type);
        return this;
    }

    public List<TargetingGeoLocationGeoEntities> getFieldSubcities() {
        return this.mSubcities;
    }

    public TargetingGeoLocation setFieldSubcities(List<TargetingGeoLocationGeoEntities> value) {
        this.mSubcities = value;
        return this;
    }

    public TargetingGeoLocation setFieldSubcities(String value) {
        Type type = new TypeToken<List<TargetingGeoLocationGeoEntities>>(){}.getType();
        this.mSubcities = (List)TargetingGeoLocationGeoEntities.getGson().fromJson(value, type);
        return this;
    }

    public List<TargetingGeoLocationGeoEntities> getFieldSubneighborhoods() {
        return this.mSubneighborhoods;
    }

    public TargetingGeoLocation setFieldSubneighborhoods(List<TargetingGeoLocationGeoEntities> value) {
        this.mSubneighborhoods = value;
        return this;
    }

    public TargetingGeoLocation setFieldSubneighborhoods(String value) {
        Type type = new TypeToken<List<TargetingGeoLocationGeoEntities>>(){}.getType();
        this.mSubneighborhoods = (List)TargetingGeoLocationGeoEntities.getGson().fromJson(value, type);
        return this;
    }

    public List<TargetingGeoLocationZip> getFieldZips() {
        return this.mZips;
    }

    public TargetingGeoLocation setFieldZips(List<TargetingGeoLocationZip> value) {
        this.mZips = value;
        return this;
    }

    public TargetingGeoLocation setFieldZips(String value) {
        Type type = new TypeToken<List<TargetingGeoLocationZip>>(){}.getType();
        this.mZips = (List)TargetingGeoLocationZip.getGson().fromJson(value, type);
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public TargetingGeoLocation copyFrom(TargetingGeoLocation instance) {
        this.mCities = instance.mCities;
        this.mCountries = instance.mCountries;
        this.mCountryGroups = instance.mCountryGroups;
        this.mCustomLocations = instance.mCustomLocations;
        this.mElectoralDistricts = instance.mElectoralDistricts;
        this.mGeoMarkets = instance.mGeoMarkets;
        this.mLargeGeoAreas = instance.mLargeGeoAreas;
        this.mLocationClusterIds = instance.mLocationClusterIds;
        this.mLocationExpansion = instance.mLocationExpansion;
        this.mLocationSetIds = instance.mLocationSetIds;
        this.mLocationTypes = instance.mLocationTypes;
        this.mMediumGeoAreas = instance.mMediumGeoAreas;
        this.mMetroAreas = instance.mMetroAreas;
        this.mNeighborhoods = instance.mNeighborhoods;
        this.mPlaces = instance.mPlaces;
        this.mPoliticalDistricts = instance.mPoliticalDistricts;
        this.mRegions = instance.mRegions;
        this.mSmallGeoAreas = instance.mSmallGeoAreas;
        this.mSubcities = instance.mSubcities;
        this.mSubneighborhoods = instance.mSubneighborhoods;
        this.mZips = instance.mZips;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<TargetingGeoLocation> getParser() {
        return new APIRequest.ResponseParser<TargetingGeoLocation>(){

            @Override
            public APINodeList<TargetingGeoLocation> parseResponse(String response, APIContext context, APIRequest<TargetingGeoLocation> request, String header) throws APIException.MalformedResponseException {
                return TargetingGeoLocation.parseResponse(response, context, request, header);
            }
        };
    }
}

