/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.InstagramUser;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstagramComment
extends APINode {
    @SerializedName(value="comment_type")
    private String mCommentType = null;
    @SerializedName(value="created_at")
    private String mCreatedAt = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="instagram_comment_id")
    private String mInstagramCommentId = null;
    @SerializedName(value="instagram_user")
    private InstagramUser mInstagramUser = null;
    @SerializedName(value="mentioned_instagram_users")
    private List<InstagramUser> mMentionedInstagramUsers = null;
    @SerializedName(value="message")
    private String mMessage = null;
    protected static Gson gson = null;

    InstagramComment() {
    }

    public InstagramComment(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public InstagramComment(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public InstagramComment fetch() throws APIException {
        InstagramComment newInstance = InstagramComment.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static InstagramComment fetchById(Long id, APIContext context) throws APIException {
        return InstagramComment.fetchById(id.toString(), context);
    }

    public static ListenableFuture<InstagramComment> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return InstagramComment.fetchByIdAsync(id.toString(), context);
    }

    public static InstagramComment fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<InstagramComment> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<InstagramComment> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<InstagramComment>(context, "", "/", "GET", InstagramComment.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<InstagramComment>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<InstagramComment>(context, "", "/", "GET", InstagramComment.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static InstagramComment loadJSON(String json, APIContext context, String header) {
        InstagramComment instagramComment = (InstagramComment)InstagramComment.getGson().fromJson(json, InstagramComment.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(instagramComment.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        instagramComment.context = context;
        instagramComment.rawValue = json;
        instagramComment.header = header;
        return instagramComment;
    }

    public static APINodeList<InstagramComment> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<InstagramComment> instagramComments = new APINodeList<InstagramComment>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        instagramComments.add(InstagramComment.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return instagramComments;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            instagramComments.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        instagramComments.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            instagramComments.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            instagramComments.add(InstagramComment.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                instagramComments.add(InstagramComment.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            instagramComments.add(InstagramComment.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return instagramComments;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        instagramComments.add(InstagramComment.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return instagramComments;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        instagramComments.add(InstagramComment.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return instagramComments;
                }
                instagramComments.clear();
                instagramComments.add(InstagramComment.loadJSON(json, context, header));
                return instagramComments;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return InstagramComment.getGson().toJson((Object)this);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCommentType() {
        return this.mCommentType;
    }

    public String getFieldCreatedAt() {
        return this.mCreatedAt;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldInstagramCommentId() {
        return this.mInstagramCommentId;
    }

    public InstagramUser getFieldInstagramUser() {
        if (this.mInstagramUser != null) {
            this.mInstagramUser.context = this.getContext();
        }
        return this.mInstagramUser;
    }

    public List<InstagramUser> getFieldMentionedInstagramUsers() {
        return this.mMentionedInstagramUsers;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public InstagramComment copyFrom(InstagramComment instance) {
        this.mCommentType = instance.mCommentType;
        this.mCreatedAt = instance.mCreatedAt;
        this.mId = instance.mId;
        this.mInstagramCommentId = instance.mInstagramCommentId;
        this.mInstagramUser = instance.mInstagramUser;
        this.mMentionedInstagramUsers = instance.mMentionedInstagramUsers;
        this.mMessage = instance.mMessage;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<InstagramComment> getParser() {
        return new APIRequest.ResponseParser<InstagramComment>(){

            @Override
            public APINodeList<InstagramComment> parseResponse(String response, APIContext context, APIRequest<InstagramComment> request, String header) throws APIException.MalformedResponseException {
                return InstagramComment.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<InstagramComment> {
        InstagramComment lastResponse = null;
        public static final String[] PARAMS = new String[]{"ad_id", "hide"};
        public static final String[] FIELDS = new String[0];

        @Override
        public InstagramComment getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public InstagramComment parseResponse(String response, String header) throws APIException {
            return InstagramComment.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public InstagramComment execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public InstagramComment execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<InstagramComment> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<InstagramComment> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, InstagramComment>(){

                public InstagramComment apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAdId(Object adId) {
            this.setParam("ad_id", adId);
            return this;
        }

        public APIRequestUpdate setAdId(String adId) {
            this.setParam("ad_id", adId);
            return this;
        }

        public APIRequestUpdate setHide(Boolean hide) {
            this.setParam("hide", hide);
            return this;
        }

        public APIRequestUpdate setHide(String hide) {
            this.setParam("hide", hide);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<InstagramComment> {
        InstagramComment lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"comment_type", "created_at", "id", "instagram_comment_id", "instagram_user", "mentioned_instagram_users", "message"};

        @Override
        public InstagramComment getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public InstagramComment parseResponse(String response, String header) throws APIException {
            return InstagramComment.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public InstagramComment execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public InstagramComment execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<InstagramComment> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<InstagramComment> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, InstagramComment>(){

                public InstagramComment apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCommentTypeField() {
            return this.requestCommentTypeField(true);
        }

        public APIRequestGet requestCommentTypeField(boolean value) {
            this.requestField("comment_type", value);
            return this;
        }

        public APIRequestGet requestCreatedAtField() {
            return this.requestCreatedAtField(true);
        }

        public APIRequestGet requestCreatedAtField(boolean value) {
            this.requestField("created_at", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInstagramCommentIdField() {
            return this.requestInstagramCommentIdField(true);
        }

        public APIRequestGet requestInstagramCommentIdField(boolean value) {
            this.requestField("instagram_comment_id", value);
            return this;
        }

        public APIRequestGet requestInstagramUserField() {
            return this.requestInstagramUserField(true);
        }

        public APIRequestGet requestInstagramUserField(boolean value) {
            this.requestField("instagram_user", value);
            return this;
        }

        public APIRequestGet requestMentionedInstagramUsersField() {
            return this.requestMentionedInstagramUsersField(true);
        }

        public APIRequestGet requestMentionedInstagramUsersField(boolean value) {
            this.requestField("mentioned_instagram_users", value);
            return this;
        }

        public APIRequestGet requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGet requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"ad_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete setAdId(Object adId) {
            this.setParam("ad_id", adId);
            return this;
        }

        public APIRequestDelete setAdId(String adId) {
            this.setParam("ad_id", adId);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

