/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdsActionStats;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdKeywordStats
extends APINode {
    @SerializedName(value="actions")
    private List<AdsActionStats> mActions = null;
    @SerializedName(value="clicks")
    private Long mClicks = null;
    @SerializedName(value="cost_per_total_action")
    private Double mCostPerTotalAction = null;
    @SerializedName(value="cost_per_unique_click")
    private Double mCostPerUniqueClick = null;
    @SerializedName(value="cpc")
    private Double mCpc = null;
    @SerializedName(value="cpm")
    private Double mCpm = null;
    @SerializedName(value="cpp")
    private Double mCpp = null;
    @SerializedName(value="ctr")
    private Double mCtr = null;
    @SerializedName(value="frequency")
    private Double mFrequency = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="impressions")
    private Long mImpressions = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="reach")
    private Long mReach = null;
    @SerializedName(value="spend")
    private Double mSpend = null;
    @SerializedName(value="total_actions")
    private Long mTotalActions = null;
    @SerializedName(value="total_unique_actions")
    private Long mTotalUniqueActions = null;
    @SerializedName(value="unique_actions")
    private List<AdsActionStats> mUniqueActions = null;
    @SerializedName(value="unique_clicks")
    private Long mUniqueClicks = null;
    @SerializedName(value="unique_ctr")
    private Double mUniqueCtr = null;
    @SerializedName(value="unique_impressions")
    private Long mUniqueImpressions = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdKeywordStats loadJSON(String json, APIContext context, String header) {
        AdKeywordStats adKeywordStats = (AdKeywordStats)AdKeywordStats.getGson().fromJson(json, AdKeywordStats.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adKeywordStats.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adKeywordStats.context = context;
        adKeywordStats.rawValue = json;
        adKeywordStats.header = header;
        return adKeywordStats;
    }

    public static APINodeList<AdKeywordStats> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdKeywordStats> adKeywordStatss = new APINodeList<AdKeywordStats>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adKeywordStatss.add(AdKeywordStats.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adKeywordStatss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adKeywordStatss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adKeywordStatss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adKeywordStatss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adKeywordStatss.add(AdKeywordStats.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adKeywordStatss.add(AdKeywordStats.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adKeywordStatss.add(AdKeywordStats.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adKeywordStatss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adKeywordStatss.add(AdKeywordStats.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adKeywordStatss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adKeywordStatss.add(AdKeywordStats.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adKeywordStatss;
                }
                adKeywordStatss.clear();
                adKeywordStatss.add(AdKeywordStats.loadJSON(json, context, header));
                return adKeywordStatss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdKeywordStats.getGson().toJson((Object)this);
    }

    public List<AdsActionStats> getFieldActions() {
        return this.mActions;
    }

    public AdKeywordStats setFieldActions(List<AdsActionStats> value) {
        this.mActions = value;
        return this;
    }

    public AdKeywordStats setFieldActions(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mActions = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public Long getFieldClicks() {
        return this.mClicks;
    }

    public AdKeywordStats setFieldClicks(Long value) {
        this.mClicks = value;
        return this;
    }

    public Double getFieldCostPerTotalAction() {
        return this.mCostPerTotalAction;
    }

    public AdKeywordStats setFieldCostPerTotalAction(Double value) {
        this.mCostPerTotalAction = value;
        return this;
    }

    public Double getFieldCostPerUniqueClick() {
        return this.mCostPerUniqueClick;
    }

    public AdKeywordStats setFieldCostPerUniqueClick(Double value) {
        this.mCostPerUniqueClick = value;
        return this;
    }

    public Double getFieldCpc() {
        return this.mCpc;
    }

    public AdKeywordStats setFieldCpc(Double value) {
        this.mCpc = value;
        return this;
    }

    public Double getFieldCpm() {
        return this.mCpm;
    }

    public AdKeywordStats setFieldCpm(Double value) {
        this.mCpm = value;
        return this;
    }

    public Double getFieldCpp() {
        return this.mCpp;
    }

    public AdKeywordStats setFieldCpp(Double value) {
        this.mCpp = value;
        return this;
    }

    public Double getFieldCtr() {
        return this.mCtr;
    }

    public AdKeywordStats setFieldCtr(Double value) {
        this.mCtr = value;
        return this;
    }

    public Double getFieldFrequency() {
        return this.mFrequency;
    }

    public AdKeywordStats setFieldFrequency(Double value) {
        this.mFrequency = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdKeywordStats setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public Long getFieldImpressions() {
        return this.mImpressions;
    }

    public AdKeywordStats setFieldImpressions(Long value) {
        this.mImpressions = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public AdKeywordStats setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public Long getFieldReach() {
        return this.mReach;
    }

    public AdKeywordStats setFieldReach(Long value) {
        this.mReach = value;
        return this;
    }

    public Double getFieldSpend() {
        return this.mSpend;
    }

    public AdKeywordStats setFieldSpend(Double value) {
        this.mSpend = value;
        return this;
    }

    public Long getFieldTotalActions() {
        return this.mTotalActions;
    }

    public AdKeywordStats setFieldTotalActions(Long value) {
        this.mTotalActions = value;
        return this;
    }

    public Long getFieldTotalUniqueActions() {
        return this.mTotalUniqueActions;
    }

    public AdKeywordStats setFieldTotalUniqueActions(Long value) {
        this.mTotalUniqueActions = value;
        return this;
    }

    public List<AdsActionStats> getFieldUniqueActions() {
        return this.mUniqueActions;
    }

    public AdKeywordStats setFieldUniqueActions(List<AdsActionStats> value) {
        this.mUniqueActions = value;
        return this;
    }

    public AdKeywordStats setFieldUniqueActions(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mUniqueActions = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public Long getFieldUniqueClicks() {
        return this.mUniqueClicks;
    }

    public AdKeywordStats setFieldUniqueClicks(Long value) {
        this.mUniqueClicks = value;
        return this;
    }

    public Double getFieldUniqueCtr() {
        return this.mUniqueCtr;
    }

    public AdKeywordStats setFieldUniqueCtr(Double value) {
        this.mUniqueCtr = value;
        return this;
    }

    public Long getFieldUniqueImpressions() {
        return this.mUniqueImpressions;
    }

    public AdKeywordStats setFieldUniqueImpressions(Long value) {
        this.mUniqueImpressions = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdKeywordStats copyFrom(AdKeywordStats instance) {
        this.mActions = instance.mActions;
        this.mClicks = instance.mClicks;
        this.mCostPerTotalAction = instance.mCostPerTotalAction;
        this.mCostPerUniqueClick = instance.mCostPerUniqueClick;
        this.mCpc = instance.mCpc;
        this.mCpm = instance.mCpm;
        this.mCpp = instance.mCpp;
        this.mCtr = instance.mCtr;
        this.mFrequency = instance.mFrequency;
        this.mId = instance.mId;
        this.mImpressions = instance.mImpressions;
        this.mName = instance.mName;
        this.mReach = instance.mReach;
        this.mSpend = instance.mSpend;
        this.mTotalActions = instance.mTotalActions;
        this.mTotalUniqueActions = instance.mTotalUniqueActions;
        this.mUniqueActions = instance.mUniqueActions;
        this.mUniqueClicks = instance.mUniqueClicks;
        this.mUniqueCtr = instance.mUniqueCtr;
        this.mUniqueImpressions = instance.mUniqueImpressions;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdKeywordStats> getParser() {
        return new APIRequest.ResponseParser<AdKeywordStats>(){

            @Override
            public APINodeList<AdKeywordStats> parseResponse(String response, APIContext context, APIRequest<AdKeywordStats> request, String header) throws APIException.MalformedResponseException {
                return AdKeywordStats.parseResponse(response, context, request, header);
            }
        };
    }
}

