/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.Application;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.Page;
import com.facebook.ads.sdk.ProductCatalog;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessProject
extends APINode {
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="creator")
    private Object mCreator = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    protected static Gson gson = null;

    BusinessProject() {
    }

    public BusinessProject(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BusinessProject(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BusinessProject fetch() throws APIException {
        BusinessProject newInstance = BusinessProject.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BusinessProject fetchById(Long id, APIContext context) throws APIException {
        return BusinessProject.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BusinessProject> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BusinessProject.fetchByIdAsync(id.toString(), context);
    }

    public static BusinessProject fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<BusinessProject> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<BusinessProject> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BusinessProject>(context, "", "/", "GET", BusinessProject.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BusinessProject>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<BusinessProject>(context, "", "/", "GET", BusinessProject.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BusinessProject loadJSON(String json, APIContext context, String header) {
        BusinessProject businessProject = (BusinessProject)BusinessProject.getGson().fromJson(json, BusinessProject.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessProject.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessProject.context = context;
        businessProject.rawValue = json;
        businessProject.header = header;
        return businessProject;
    }

    public static APINodeList<BusinessProject> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BusinessProject> businessProjects = new APINodeList<BusinessProject>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessProjects.add(BusinessProject.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return businessProjects;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessProjects.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessProjects.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            businessProjects.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessProjects.add(BusinessProject.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessProjects.add(BusinessProject.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessProjects.add(BusinessProject.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return businessProjects;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessProjects.add(BusinessProject.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return businessProjects;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessProjects.add(BusinessProject.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessProjects;
                }
                businessProjects.clear();
                businessProjects.add(BusinessProject.loadJSON(json, context, header));
                return businessProjects;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessProject.getGson().toJson((Object)this);
    }

    public APIRequestDeleteAdAccounts deleteAdAccounts() {
        return new APIRequestDeleteAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdAccounts getAdAccounts() {
        return new APIRequestGetAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdAccount createAdAccount() {
        return new APIRequestCreateAdAccount(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteApps deleteApps() {
        return new APIRequestDeleteApps(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetApps getApps() {
        return new APIRequestGetApps(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateApp createApp() {
        return new APIRequestCreateApp(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteAssets deleteAssets() {
        return new APIRequestDeleteAssets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAsset createAsset() {
        return new APIRequestCreateAsset(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeletePages deletePages() {
        return new APIRequestDeletePages(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPages getPages() {
        return new APIRequestGetPages(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreatePage createPage() {
        return new APIRequestCreatePage(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteProductCatalogs deleteProductCatalogs() {
        return new APIRequestDeleteProductCatalogs(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetProductCatalogs getProductCatalogs() {
        return new APIRequestGetProductCatalogs(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateProductCatalog createProductCatalog() {
        return new APIRequestCreateProductCatalog(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public Object getFieldCreator() {
        return this.mCreator;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessProject copyFrom(BusinessProject instance) {
        this.mBusiness = instance.mBusiness;
        this.mCreatedTime = instance.mCreatedTime;
        this.mCreator = instance.mCreator;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessProject> getParser() {
        return new APIRequest.ResponseParser<BusinessProject>(){

            @Override
            public APINodeList<BusinessProject> parseResponse(String response, APIContext context, APIRequest<BusinessProject> request, String header) throws APIException.MalformedResponseException {
                return BusinessProject.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<BusinessProject> {
        BusinessProject lastResponse = null;
        public static final String[] PARAMS = new String[]{"name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public BusinessProject getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessProject parseResponse(String response, String header) throws APIException {
            return BusinessProject.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessProject execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessProject execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessProject> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessProject> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessProject>(){

                public BusinessProject apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<BusinessProject> {
        BusinessProject lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "created_time", "creator", "id", "name"};

        @Override
        public BusinessProject getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessProject parseResponse(String response, String header) throws APIException {
            return BusinessProject.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessProject execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessProject execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessProject> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessProject> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessProject>(){

                public BusinessProject apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGet requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateProductCatalog
    extends APIRequest<BusinessProject> {
        BusinessProject lastResponse = null;
        public static final String[] PARAMS = new String[]{"product_catalog_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public BusinessProject getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessProject parseResponse(String response, String header) throws APIException {
            return BusinessProject.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessProject execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessProject execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessProject> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessProject> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessProject>(){

                public BusinessProject apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateProductCatalog.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateProductCatalog(String nodeId, APIContext context) {
            super(context, nodeId, "/product_catalogs", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateProductCatalog setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateProductCatalog setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateProductCatalog setProductCatalogId(String productCatalogId) {
            this.setParam("product_catalog_id", productCatalogId);
            return this;
        }

        public APIRequestCreateProductCatalog requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateProductCatalog requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateProductCatalog requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateProductCatalog requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateProductCatalog requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateProductCatalog requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetProductCatalogs
    extends APIRequest<ProductCatalog> {
        APINodeList<ProductCatalog> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "cpas_parent_catalog_settings", "da_display_settings", "default_image_url", "fallback_image_url", "feed_count", "flight_catalog_settings", "id", "name", "product_count", "qualified_product_count", "vertical"};

        @Override
        public APINodeList<ProductCatalog> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ProductCatalog> parseResponse(String response, String header) throws APIException {
            return ProductCatalog.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<ProductCatalog> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ProductCatalog> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ProductCatalog>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ProductCatalog>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<ProductCatalog>>(){

                public APINodeList<ProductCatalog> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetProductCatalogs.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetProductCatalogs(String nodeId, APIContext context) {
            super(context, nodeId, "/product_catalogs", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetProductCatalogs setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetProductCatalogs setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetProductCatalogs requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetProductCatalogs requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetProductCatalogs requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetProductCatalogs requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetProductCatalogs requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetProductCatalogs requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetProductCatalogs requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetProductCatalogs requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestCpasParentCatalogSettingsField() {
            return this.requestCpasParentCatalogSettingsField(true);
        }

        public APIRequestGetProductCatalogs requestCpasParentCatalogSettingsField(boolean value) {
            this.requestField("cpas_parent_catalog_settings", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestDaDisplaySettingsField() {
            return this.requestDaDisplaySettingsField(true);
        }

        public APIRequestGetProductCatalogs requestDaDisplaySettingsField(boolean value) {
            this.requestField("da_display_settings", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestDefaultImageUrlField() {
            return this.requestDefaultImageUrlField(true);
        }

        public APIRequestGetProductCatalogs requestDefaultImageUrlField(boolean value) {
            this.requestField("default_image_url", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestFallbackImageUrlField() {
            return this.requestFallbackImageUrlField(true);
        }

        public APIRequestGetProductCatalogs requestFallbackImageUrlField(boolean value) {
            this.requestField("fallback_image_url", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestFeedCountField() {
            return this.requestFeedCountField(true);
        }

        public APIRequestGetProductCatalogs requestFeedCountField(boolean value) {
            this.requestField("feed_count", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestFlightCatalogSettingsField() {
            return this.requestFlightCatalogSettingsField(true);
        }

        public APIRequestGetProductCatalogs requestFlightCatalogSettingsField(boolean value) {
            this.requestField("flight_catalog_settings", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetProductCatalogs requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetProductCatalogs requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestProductCountField() {
            return this.requestProductCountField(true);
        }

        public APIRequestGetProductCatalogs requestProductCountField(boolean value) {
            this.requestField("product_count", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestQualifiedProductCountField() {
            return this.requestQualifiedProductCountField(true);
        }

        public APIRequestGetProductCatalogs requestQualifiedProductCountField(boolean value) {
            this.requestField("qualified_product_count", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestVerticalField() {
            return this.requestVerticalField(true);
        }

        public APIRequestGetProductCatalogs requestVerticalField(boolean value) {
            this.requestField("vertical", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteProductCatalogs
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"product_catalog_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDeleteProductCatalogs.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteProductCatalogs(String nodeId, APIContext context) {
            super(context, nodeId, "/product_catalogs", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteProductCatalogs setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteProductCatalogs setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteProductCatalogs setProductCatalogId(String productCatalogId) {
            this.setParam("product_catalog_id", productCatalogId);
            return this;
        }

        public APIRequestDeleteProductCatalogs requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteProductCatalogs requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteProductCatalogs requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteProductCatalogs requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteProductCatalogs requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteProductCatalogs requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreatePage
    extends APIRequest<BusinessProject> {
        BusinessProject lastResponse = null;
        public static final String[] PARAMS = new String[]{"page_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public BusinessProject getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessProject parseResponse(String response, String header) throws APIException {
            return BusinessProject.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessProject execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessProject execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessProject> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessProject> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessProject>(){

                public BusinessProject apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreatePage.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreatePage(String nodeId, APIContext context) {
            super(context, nodeId, "/pages", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreatePage setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreatePage setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreatePage setPageId(Long pageId) {
            this.setParam("page_id", pageId);
            return this;
        }

        public APIRequestCreatePage setPageId(String pageId) {
            this.setParam("page_id", pageId);
            return this;
        }

        public APIRequestCreatePage requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreatePage requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePage requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreatePage requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePage requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreatePage requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPages
    extends APIRequest<Page> {
        APINodeList<Page> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"about", "access_token", "ad_campaign", "affiliation", "app_id", "app_links", "artists_we_like", "attire", "awards", "band_interests", "band_members", "best_page", "bio", "birthday", "booking_agent", "built", "business", "can_checkin", "can_post", "category", "category_list", "checkins", "company_overview", "connected_instagram_account", "contact_address", "context", "copyright_attribution_insights", "copyright_whitelisted_ig_partners", "country_page_likes", "cover", "culinary_team", "current_location", "description", "description_html", "directed_by", "display_subtext", "displayed_message_response_time", "emails", "engagement", "fan_count", "featured_video", "features", "food_styles", "founded", "general_info", "general_manager", "genre", "global_brand_page_name", "global_brand_root_id", "has_added_app", "has_whatsapp_business_number", "has_whatsapp_number", "hometown", "hours", "id", "impressum", "influences", "instagram_business_account", "instant_articles_review_status", "is_always_open", "is_chain", "is_community_page", "is_eligible_for_branded_content", "is_messenger_bot_get_started_enabled", "is_messenger_platform_bot", "is_owned", "is_permanently_closed", "is_published", "is_unclaimed", "is_verified", "is_webhooks_subscribed", "keywords", "leadgen_form_preview_details", "leadgen_has_crm_integration", "leadgen_has_fat_ping_crm_integration", "leadgen_tos_acceptance_time", "leadgen_tos_accepted", "leadgen_tos_accepting_user", "link", "location", "members", "merchant_id", "merchant_review_status", "messenger_ads_default_icebreakers", "messenger_ads_default_page_welcome_message", "messenger_ads_default_quick_replies", "messenger_ads_quick_replies_type", "mission", "mpg", "name", "name_with_location_descriptor", "network", "new_like_count", "offer_eligible", "overall_star_rating", "page_about_story", "page_token", "parent_page", "parking", "payment_options", "personal_info", "personal_interests", "pharma_safety_info", "phone", "place_type", "plot_outline", "preferred_audience", "press_contact", "price_range", "privacy_info_url", "produced_by", "products", "promotion_eligible", "promotion_ineligible_reason", "public_transit", "rating_count", "recipient", "record_label", "release_date", "restaurant_services", "restaurant_specialties", "schedule", "screenplay_by", "season", "single_line_address", "starring", "start_info", "store_code", "store_location_descriptor", "store_number", "studio", "supports_instant_articles", "talking_about_count", "unread_message_count", "unread_notif_count", "unseen_message_count", "username", "verification_status", "voip_info", "website", "were_here_count", "whatsapp_number", "written_by"};

        @Override
        public APINodeList<Page> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Page> parseResponse(String response, String header) throws APIException {
            return Page.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Page> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Page>>(){

                public APINodeList<Page> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetPages.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPages(String nodeId, APIContext context) {
            super(context, nodeId, "/pages", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPages setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPages setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPages requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPages requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPages requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPages requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPages requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPages requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPages requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetPages requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetPages requestAccessTokenField() {
            return this.requestAccessTokenField(true);
        }

        public APIRequestGetPages requestAccessTokenField(boolean value) {
            this.requestField("access_token", value);
            return this;
        }

        public APIRequestGetPages requestAdCampaignField() {
            return this.requestAdCampaignField(true);
        }

        public APIRequestGetPages requestAdCampaignField(boolean value) {
            this.requestField("ad_campaign", value);
            return this;
        }

        public APIRequestGetPages requestAffiliationField() {
            return this.requestAffiliationField(true);
        }

        public APIRequestGetPages requestAffiliationField(boolean value) {
            this.requestField("affiliation", value);
            return this;
        }

        public APIRequestGetPages requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGetPages requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGetPages requestAppLinksField() {
            return this.requestAppLinksField(true);
        }

        public APIRequestGetPages requestAppLinksField(boolean value) {
            this.requestField("app_links", value);
            return this;
        }

        public APIRequestGetPages requestArtistsWeLikeField() {
            return this.requestArtistsWeLikeField(true);
        }

        public APIRequestGetPages requestArtistsWeLikeField(boolean value) {
            this.requestField("artists_we_like", value);
            return this;
        }

        public APIRequestGetPages requestAttireField() {
            return this.requestAttireField(true);
        }

        public APIRequestGetPages requestAttireField(boolean value) {
            this.requestField("attire", value);
            return this;
        }

        public APIRequestGetPages requestAwardsField() {
            return this.requestAwardsField(true);
        }

        public APIRequestGetPages requestAwardsField(boolean value) {
            this.requestField("awards", value);
            return this;
        }

        public APIRequestGetPages requestBandInterestsField() {
            return this.requestBandInterestsField(true);
        }

        public APIRequestGetPages requestBandInterestsField(boolean value) {
            this.requestField("band_interests", value);
            return this;
        }

        public APIRequestGetPages requestBandMembersField() {
            return this.requestBandMembersField(true);
        }

        public APIRequestGetPages requestBandMembersField(boolean value) {
            this.requestField("band_members", value);
            return this;
        }

        public APIRequestGetPages requestBestPageField() {
            return this.requestBestPageField(true);
        }

        public APIRequestGetPages requestBestPageField(boolean value) {
            this.requestField("best_page", value);
            return this;
        }

        public APIRequestGetPages requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGetPages requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGetPages requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetPages requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetPages requestBookingAgentField() {
            return this.requestBookingAgentField(true);
        }

        public APIRequestGetPages requestBookingAgentField(boolean value) {
            this.requestField("booking_agent", value);
            return this;
        }

        public APIRequestGetPages requestBuiltField() {
            return this.requestBuiltField(true);
        }

        public APIRequestGetPages requestBuiltField(boolean value) {
            this.requestField("built", value);
            return this;
        }

        public APIRequestGetPages requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetPages requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetPages requestCanCheckinField() {
            return this.requestCanCheckinField(true);
        }

        public APIRequestGetPages requestCanCheckinField(boolean value) {
            this.requestField("can_checkin", value);
            return this;
        }

        public APIRequestGetPages requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetPages requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetPages requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetPages requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetPages requestCategoryListField() {
            return this.requestCategoryListField(true);
        }

        public APIRequestGetPages requestCategoryListField(boolean value) {
            this.requestField("category_list", value);
            return this;
        }

        public APIRequestGetPages requestCheckinsField() {
            return this.requestCheckinsField(true);
        }

        public APIRequestGetPages requestCheckinsField(boolean value) {
            this.requestField("checkins", value);
            return this;
        }

        public APIRequestGetPages requestCompanyOverviewField() {
            return this.requestCompanyOverviewField(true);
        }

        public APIRequestGetPages requestCompanyOverviewField(boolean value) {
            this.requestField("company_overview", value);
            return this;
        }

        public APIRequestGetPages requestConnectedInstagramAccountField() {
            return this.requestConnectedInstagramAccountField(true);
        }

        public APIRequestGetPages requestConnectedInstagramAccountField(boolean value) {
            this.requestField("connected_instagram_account", value);
            return this;
        }

        public APIRequestGetPages requestContactAddressField() {
            return this.requestContactAddressField(true);
        }

        public APIRequestGetPages requestContactAddressField(boolean value) {
            this.requestField("contact_address", value);
            return this;
        }

        public APIRequestGetPages requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetPages requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetPages requestCopyrightAttributionInsightsField() {
            return this.requestCopyrightAttributionInsightsField(true);
        }

        public APIRequestGetPages requestCopyrightAttributionInsightsField(boolean value) {
            this.requestField("copyright_attribution_insights", value);
            return this;
        }

        public APIRequestGetPages requestCopyrightWhitelistedIgPartnersField() {
            return this.requestCopyrightWhitelistedIgPartnersField(true);
        }

        public APIRequestGetPages requestCopyrightWhitelistedIgPartnersField(boolean value) {
            this.requestField("copyright_whitelisted_ig_partners", value);
            return this;
        }

        public APIRequestGetPages requestCountryPageLikesField() {
            return this.requestCountryPageLikesField(true);
        }

        public APIRequestGetPages requestCountryPageLikesField(boolean value) {
            this.requestField("country_page_likes", value);
            return this;
        }

        public APIRequestGetPages requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetPages requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetPages requestCulinaryTeamField() {
            return this.requestCulinaryTeamField(true);
        }

        public APIRequestGetPages requestCulinaryTeamField(boolean value) {
            this.requestField("culinary_team", value);
            return this;
        }

        public APIRequestGetPages requestCurrentLocationField() {
            return this.requestCurrentLocationField(true);
        }

        public APIRequestGetPages requestCurrentLocationField(boolean value) {
            this.requestField("current_location", value);
            return this;
        }

        public APIRequestGetPages requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetPages requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetPages requestDescriptionHtmlField() {
            return this.requestDescriptionHtmlField(true);
        }

        public APIRequestGetPages requestDescriptionHtmlField(boolean value) {
            this.requestField("description_html", value);
            return this;
        }

        public APIRequestGetPages requestDirectedByField() {
            return this.requestDirectedByField(true);
        }

        public APIRequestGetPages requestDirectedByField(boolean value) {
            this.requestField("directed_by", value);
            return this;
        }

        public APIRequestGetPages requestDisplaySubtextField() {
            return this.requestDisplaySubtextField(true);
        }

        public APIRequestGetPages requestDisplaySubtextField(boolean value) {
            this.requestField("display_subtext", value);
            return this;
        }

        public APIRequestGetPages requestDisplayedMessageResponseTimeField() {
            return this.requestDisplayedMessageResponseTimeField(true);
        }

        public APIRequestGetPages requestDisplayedMessageResponseTimeField(boolean value) {
            this.requestField("displayed_message_response_time", value);
            return this;
        }

        public APIRequestGetPages requestEmailsField() {
            return this.requestEmailsField(true);
        }

        public APIRequestGetPages requestEmailsField(boolean value) {
            this.requestField("emails", value);
            return this;
        }

        public APIRequestGetPages requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGetPages requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGetPages requestFanCountField() {
            return this.requestFanCountField(true);
        }

        public APIRequestGetPages requestFanCountField(boolean value) {
            this.requestField("fan_count", value);
            return this;
        }

        public APIRequestGetPages requestFeaturedVideoField() {
            return this.requestFeaturedVideoField(true);
        }

        public APIRequestGetPages requestFeaturedVideoField(boolean value) {
            this.requestField("featured_video", value);
            return this;
        }

        public APIRequestGetPages requestFeaturesField() {
            return this.requestFeaturesField(true);
        }

        public APIRequestGetPages requestFeaturesField(boolean value) {
            this.requestField("features", value);
            return this;
        }

        public APIRequestGetPages requestFoodStylesField() {
            return this.requestFoodStylesField(true);
        }

        public APIRequestGetPages requestFoodStylesField(boolean value) {
            this.requestField("food_styles", value);
            return this;
        }

        public APIRequestGetPages requestFoundedField() {
            return this.requestFoundedField(true);
        }

        public APIRequestGetPages requestFoundedField(boolean value) {
            this.requestField("founded", value);
            return this;
        }

        public APIRequestGetPages requestGeneralInfoField() {
            return this.requestGeneralInfoField(true);
        }

        public APIRequestGetPages requestGeneralInfoField(boolean value) {
            this.requestField("general_info", value);
            return this;
        }

        public APIRequestGetPages requestGeneralManagerField() {
            return this.requestGeneralManagerField(true);
        }

        public APIRequestGetPages requestGeneralManagerField(boolean value) {
            this.requestField("general_manager", value);
            return this;
        }

        public APIRequestGetPages requestGenreField() {
            return this.requestGenreField(true);
        }

        public APIRequestGetPages requestGenreField(boolean value) {
            this.requestField("genre", value);
            return this;
        }

        public APIRequestGetPages requestGlobalBrandPageNameField() {
            return this.requestGlobalBrandPageNameField(true);
        }

        public APIRequestGetPages requestGlobalBrandPageNameField(boolean value) {
            this.requestField("global_brand_page_name", value);
            return this;
        }

        public APIRequestGetPages requestGlobalBrandRootIdField() {
            return this.requestGlobalBrandRootIdField(true);
        }

        public APIRequestGetPages requestGlobalBrandRootIdField(boolean value) {
            this.requestField("global_brand_root_id", value);
            return this;
        }

        public APIRequestGetPages requestHasAddedAppField() {
            return this.requestHasAddedAppField(true);
        }

        public APIRequestGetPages requestHasAddedAppField(boolean value) {
            this.requestField("has_added_app", value);
            return this;
        }

        public APIRequestGetPages requestHasWhatsappBusinessNumberField() {
            return this.requestHasWhatsappBusinessNumberField(true);
        }

        public APIRequestGetPages requestHasWhatsappBusinessNumberField(boolean value) {
            this.requestField("has_whatsapp_business_number", value);
            return this;
        }

        public APIRequestGetPages requestHasWhatsappNumberField() {
            return this.requestHasWhatsappNumberField(true);
        }

        public APIRequestGetPages requestHasWhatsappNumberField(boolean value) {
            this.requestField("has_whatsapp_number", value);
            return this;
        }

        public APIRequestGetPages requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetPages requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetPages requestHoursField() {
            return this.requestHoursField(true);
        }

        public APIRequestGetPages requestHoursField(boolean value) {
            this.requestField("hours", value);
            return this;
        }

        public APIRequestGetPages requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPages requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetPages requestImpressumField() {
            return this.requestImpressumField(true);
        }

        public APIRequestGetPages requestImpressumField(boolean value) {
            this.requestField("impressum", value);
            return this;
        }

        public APIRequestGetPages requestInfluencesField() {
            return this.requestInfluencesField(true);
        }

        public APIRequestGetPages requestInfluencesField(boolean value) {
            this.requestField("influences", value);
            return this;
        }

        public APIRequestGetPages requestInstagramBusinessAccountField() {
            return this.requestInstagramBusinessAccountField(true);
        }

        public APIRequestGetPages requestInstagramBusinessAccountField(boolean value) {
            this.requestField("instagram_business_account", value);
            return this;
        }

        public APIRequestGetPages requestInstantArticlesReviewStatusField() {
            return this.requestInstantArticlesReviewStatusField(true);
        }

        public APIRequestGetPages requestInstantArticlesReviewStatusField(boolean value) {
            this.requestField("instant_articles_review_status", value);
            return this;
        }

        public APIRequestGetPages requestIsAlwaysOpenField() {
            return this.requestIsAlwaysOpenField(true);
        }

        public APIRequestGetPages requestIsAlwaysOpenField(boolean value) {
            this.requestField("is_always_open", value);
            return this;
        }

        public APIRequestGetPages requestIsChainField() {
            return this.requestIsChainField(true);
        }

        public APIRequestGetPages requestIsChainField(boolean value) {
            this.requestField("is_chain", value);
            return this;
        }

        public APIRequestGetPages requestIsCommunityPageField() {
            return this.requestIsCommunityPageField(true);
        }

        public APIRequestGetPages requestIsCommunityPageField(boolean value) {
            this.requestField("is_community_page", value);
            return this;
        }

        public APIRequestGetPages requestIsEligibleForBrandedContentField() {
            return this.requestIsEligibleForBrandedContentField(true);
        }

        public APIRequestGetPages requestIsEligibleForBrandedContentField(boolean value) {
            this.requestField("is_eligible_for_branded_content", value);
            return this;
        }

        public APIRequestGetPages requestIsMessengerBotGetStartedEnabledField() {
            return this.requestIsMessengerBotGetStartedEnabledField(true);
        }

        public APIRequestGetPages requestIsMessengerBotGetStartedEnabledField(boolean value) {
            this.requestField("is_messenger_bot_get_started_enabled", value);
            return this;
        }

        public APIRequestGetPages requestIsMessengerPlatformBotField() {
            return this.requestIsMessengerPlatformBotField(true);
        }

        public APIRequestGetPages requestIsMessengerPlatformBotField(boolean value) {
            this.requestField("is_messenger_platform_bot", value);
            return this;
        }

        public APIRequestGetPages requestIsOwnedField() {
            return this.requestIsOwnedField(true);
        }

        public APIRequestGetPages requestIsOwnedField(boolean value) {
            this.requestField("is_owned", value);
            return this;
        }

        public APIRequestGetPages requestIsPermanentlyClosedField() {
            return this.requestIsPermanentlyClosedField(true);
        }

        public APIRequestGetPages requestIsPermanentlyClosedField(boolean value) {
            this.requestField("is_permanently_closed", value);
            return this;
        }

        public APIRequestGetPages requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetPages requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetPages requestIsUnclaimedField() {
            return this.requestIsUnclaimedField(true);
        }

        public APIRequestGetPages requestIsUnclaimedField(boolean value) {
            this.requestField("is_unclaimed", value);
            return this;
        }

        public APIRequestGetPages requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGetPages requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGetPages requestIsWebhooksSubscribedField() {
            return this.requestIsWebhooksSubscribedField(true);
        }

        public APIRequestGetPages requestIsWebhooksSubscribedField(boolean value) {
            this.requestField("is_webhooks_subscribed", value);
            return this;
        }

        public APIRequestGetPages requestKeywordsField() {
            return this.requestKeywordsField(true);
        }

        public APIRequestGetPages requestKeywordsField(boolean value) {
            this.requestField("keywords", value);
            return this;
        }

        public APIRequestGetPages requestLeadgenFormPreviewDetailsField() {
            return this.requestLeadgenFormPreviewDetailsField(true);
        }

        public APIRequestGetPages requestLeadgenFormPreviewDetailsField(boolean value) {
            this.requestField("leadgen_form_preview_details", value);
            return this;
        }

        public APIRequestGetPages requestLeadgenHasCrmIntegrationField() {
            return this.requestLeadgenHasCrmIntegrationField(true);
        }

        public APIRequestGetPages requestLeadgenHasCrmIntegrationField(boolean value) {
            this.requestField("leadgen_has_crm_integration", value);
            return this;
        }

        public APIRequestGetPages requestLeadgenHasFatPingCrmIntegrationField() {
            return this.requestLeadgenHasFatPingCrmIntegrationField(true);
        }

        public APIRequestGetPages requestLeadgenHasFatPingCrmIntegrationField(boolean value) {
            this.requestField("leadgen_has_fat_ping_crm_integration", value);
            return this;
        }

        public APIRequestGetPages requestLeadgenTosAcceptanceTimeField() {
            return this.requestLeadgenTosAcceptanceTimeField(true);
        }

        public APIRequestGetPages requestLeadgenTosAcceptanceTimeField(boolean value) {
            this.requestField("leadgen_tos_acceptance_time", value);
            return this;
        }

        public APIRequestGetPages requestLeadgenTosAcceptedField() {
            return this.requestLeadgenTosAcceptedField(true);
        }

        public APIRequestGetPages requestLeadgenTosAcceptedField(boolean value) {
            this.requestField("leadgen_tos_accepted", value);
            return this;
        }

        public APIRequestGetPages requestLeadgenTosAcceptingUserField() {
            return this.requestLeadgenTosAcceptingUserField(true);
        }

        public APIRequestGetPages requestLeadgenTosAcceptingUserField(boolean value) {
            this.requestField("leadgen_tos_accepting_user", value);
            return this;
        }

        public APIRequestGetPages requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetPages requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetPages requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetPages requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetPages requestMembersField() {
            return this.requestMembersField(true);
        }

        public APIRequestGetPages requestMembersField(boolean value) {
            this.requestField("members", value);
            return this;
        }

        public APIRequestGetPages requestMerchantIdField() {
            return this.requestMerchantIdField(true);
        }

        public APIRequestGetPages requestMerchantIdField(boolean value) {
            this.requestField("merchant_id", value);
            return this;
        }

        public APIRequestGetPages requestMerchantReviewStatusField() {
            return this.requestMerchantReviewStatusField(true);
        }

        public APIRequestGetPages requestMerchantReviewStatusField(boolean value) {
            this.requestField("merchant_review_status", value);
            return this;
        }

        public APIRequestGetPages requestMessengerAdsDefaultIcebreakersField() {
            return this.requestMessengerAdsDefaultIcebreakersField(true);
        }

        public APIRequestGetPages requestMessengerAdsDefaultIcebreakersField(boolean value) {
            this.requestField("messenger_ads_default_icebreakers", value);
            return this;
        }

        public APIRequestGetPages requestMessengerAdsDefaultPageWelcomeMessageField() {
            return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
        }

        public APIRequestGetPages requestMessengerAdsDefaultPageWelcomeMessageField(boolean value) {
            this.requestField("messenger_ads_default_page_welcome_message", value);
            return this;
        }

        public APIRequestGetPages requestMessengerAdsDefaultQuickRepliesField() {
            return this.requestMessengerAdsDefaultQuickRepliesField(true);
        }

        public APIRequestGetPages requestMessengerAdsDefaultQuickRepliesField(boolean value) {
            this.requestField("messenger_ads_default_quick_replies", value);
            return this;
        }

        public APIRequestGetPages requestMessengerAdsQuickRepliesTypeField() {
            return this.requestMessengerAdsQuickRepliesTypeField(true);
        }

        public APIRequestGetPages requestMessengerAdsQuickRepliesTypeField(boolean value) {
            this.requestField("messenger_ads_quick_replies_type", value);
            return this;
        }

        public APIRequestGetPages requestMissionField() {
            return this.requestMissionField(true);
        }

        public APIRequestGetPages requestMissionField(boolean value) {
            this.requestField("mission", value);
            return this;
        }

        public APIRequestGetPages requestMpgField() {
            return this.requestMpgField(true);
        }

        public APIRequestGetPages requestMpgField(boolean value) {
            this.requestField("mpg", value);
            return this;
        }

        public APIRequestGetPages requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetPages requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetPages requestNameWithLocationDescriptorField() {
            return this.requestNameWithLocationDescriptorField(true);
        }

        public APIRequestGetPages requestNameWithLocationDescriptorField(boolean value) {
            this.requestField("name_with_location_descriptor", value);
            return this;
        }

        public APIRequestGetPages requestNetworkField() {
            return this.requestNetworkField(true);
        }

        public APIRequestGetPages requestNetworkField(boolean value) {
            this.requestField("network", value);
            return this;
        }

        public APIRequestGetPages requestNewLikeCountField() {
            return this.requestNewLikeCountField(true);
        }

        public APIRequestGetPages requestNewLikeCountField(boolean value) {
            this.requestField("new_like_count", value);
            return this;
        }

        public APIRequestGetPages requestOfferEligibleField() {
            return this.requestOfferEligibleField(true);
        }

        public APIRequestGetPages requestOfferEligibleField(boolean value) {
            this.requestField("offer_eligible", value);
            return this;
        }

        public APIRequestGetPages requestOverallStarRatingField() {
            return this.requestOverallStarRatingField(true);
        }

        public APIRequestGetPages requestOverallStarRatingField(boolean value) {
            this.requestField("overall_star_rating", value);
            return this;
        }

        public APIRequestGetPages requestPageAboutStoryField() {
            return this.requestPageAboutStoryField(true);
        }

        public APIRequestGetPages requestPageAboutStoryField(boolean value) {
            this.requestField("page_about_story", value);
            return this;
        }

        public APIRequestGetPages requestPageTokenField() {
            return this.requestPageTokenField(true);
        }

        public APIRequestGetPages requestPageTokenField(boolean value) {
            this.requestField("page_token", value);
            return this;
        }

        public APIRequestGetPages requestParentPageField() {
            return this.requestParentPageField(true);
        }

        public APIRequestGetPages requestParentPageField(boolean value) {
            this.requestField("parent_page", value);
            return this;
        }

        public APIRequestGetPages requestParkingField() {
            return this.requestParkingField(true);
        }

        public APIRequestGetPages requestParkingField(boolean value) {
            this.requestField("parking", value);
            return this;
        }

        public APIRequestGetPages requestPaymentOptionsField() {
            return this.requestPaymentOptionsField(true);
        }

        public APIRequestGetPages requestPaymentOptionsField(boolean value) {
            this.requestField("payment_options", value);
            return this;
        }

        public APIRequestGetPages requestPersonalInfoField() {
            return this.requestPersonalInfoField(true);
        }

        public APIRequestGetPages requestPersonalInfoField(boolean value) {
            this.requestField("personal_info", value);
            return this;
        }

        public APIRequestGetPages requestPersonalInterestsField() {
            return this.requestPersonalInterestsField(true);
        }

        public APIRequestGetPages requestPersonalInterestsField(boolean value) {
            this.requestField("personal_interests", value);
            return this;
        }

        public APIRequestGetPages requestPharmaSafetyInfoField() {
            return this.requestPharmaSafetyInfoField(true);
        }

        public APIRequestGetPages requestPharmaSafetyInfoField(boolean value) {
            this.requestField("pharma_safety_info", value);
            return this;
        }

        public APIRequestGetPages requestPhoneField() {
            return this.requestPhoneField(true);
        }

        public APIRequestGetPages requestPhoneField(boolean value) {
            this.requestField("phone", value);
            return this;
        }

        public APIRequestGetPages requestPlaceTypeField() {
            return this.requestPlaceTypeField(true);
        }

        public APIRequestGetPages requestPlaceTypeField(boolean value) {
            this.requestField("place_type", value);
            return this;
        }

        public APIRequestGetPages requestPlotOutlineField() {
            return this.requestPlotOutlineField(true);
        }

        public APIRequestGetPages requestPlotOutlineField(boolean value) {
            this.requestField("plot_outline", value);
            return this;
        }

        public APIRequestGetPages requestPreferredAudienceField() {
            return this.requestPreferredAudienceField(true);
        }

        public APIRequestGetPages requestPreferredAudienceField(boolean value) {
            this.requestField("preferred_audience", value);
            return this;
        }

        public APIRequestGetPages requestPressContactField() {
            return this.requestPressContactField(true);
        }

        public APIRequestGetPages requestPressContactField(boolean value) {
            this.requestField("press_contact", value);
            return this;
        }

        public APIRequestGetPages requestPriceRangeField() {
            return this.requestPriceRangeField(true);
        }

        public APIRequestGetPages requestPriceRangeField(boolean value) {
            this.requestField("price_range", value);
            return this;
        }

        public APIRequestGetPages requestPrivacyInfoUrlField() {
            return this.requestPrivacyInfoUrlField(true);
        }

        public APIRequestGetPages requestPrivacyInfoUrlField(boolean value) {
            this.requestField("privacy_info_url", value);
            return this;
        }

        public APIRequestGetPages requestProducedByField() {
            return this.requestProducedByField(true);
        }

        public APIRequestGetPages requestProducedByField(boolean value) {
            this.requestField("produced_by", value);
            return this;
        }

        public APIRequestGetPages requestProductsField() {
            return this.requestProductsField(true);
        }

        public APIRequestGetPages requestProductsField(boolean value) {
            this.requestField("products", value);
            return this;
        }

        public APIRequestGetPages requestPromotionEligibleField() {
            return this.requestPromotionEligibleField(true);
        }

        public APIRequestGetPages requestPromotionEligibleField(boolean value) {
            this.requestField("promotion_eligible", value);
            return this;
        }

        public APIRequestGetPages requestPromotionIneligibleReasonField() {
            return this.requestPromotionIneligibleReasonField(true);
        }

        public APIRequestGetPages requestPromotionIneligibleReasonField(boolean value) {
            this.requestField("promotion_ineligible_reason", value);
            return this;
        }

        public APIRequestGetPages requestPublicTransitField() {
            return this.requestPublicTransitField(true);
        }

        public APIRequestGetPages requestPublicTransitField(boolean value) {
            this.requestField("public_transit", value);
            return this;
        }

        public APIRequestGetPages requestRatingCountField() {
            return this.requestRatingCountField(true);
        }

        public APIRequestGetPages requestRatingCountField(boolean value) {
            this.requestField("rating_count", value);
            return this;
        }

        public APIRequestGetPages requestRecipientField() {
            return this.requestRecipientField(true);
        }

        public APIRequestGetPages requestRecipientField(boolean value) {
            this.requestField("recipient", value);
            return this;
        }

        public APIRequestGetPages requestRecordLabelField() {
            return this.requestRecordLabelField(true);
        }

        public APIRequestGetPages requestRecordLabelField(boolean value) {
            this.requestField("record_label", value);
            return this;
        }

        public APIRequestGetPages requestReleaseDateField() {
            return this.requestReleaseDateField(true);
        }

        public APIRequestGetPages requestReleaseDateField(boolean value) {
            this.requestField("release_date", value);
            return this;
        }

        public APIRequestGetPages requestRestaurantServicesField() {
            return this.requestRestaurantServicesField(true);
        }

        public APIRequestGetPages requestRestaurantServicesField(boolean value) {
            this.requestField("restaurant_services", value);
            return this;
        }

        public APIRequestGetPages requestRestaurantSpecialtiesField() {
            return this.requestRestaurantSpecialtiesField(true);
        }

        public APIRequestGetPages requestRestaurantSpecialtiesField(boolean value) {
            this.requestField("restaurant_specialties", value);
            return this;
        }

        public APIRequestGetPages requestScheduleField() {
            return this.requestScheduleField(true);
        }

        public APIRequestGetPages requestScheduleField(boolean value) {
            this.requestField("schedule", value);
            return this;
        }

        public APIRequestGetPages requestScreenplayByField() {
            return this.requestScreenplayByField(true);
        }

        public APIRequestGetPages requestScreenplayByField(boolean value) {
            this.requestField("screenplay_by", value);
            return this;
        }

        public APIRequestGetPages requestSeasonField() {
            return this.requestSeasonField(true);
        }

        public APIRequestGetPages requestSeasonField(boolean value) {
            this.requestField("season", value);
            return this;
        }

        public APIRequestGetPages requestSingleLineAddressField() {
            return this.requestSingleLineAddressField(true);
        }

        public APIRequestGetPages requestSingleLineAddressField(boolean value) {
            this.requestField("single_line_address", value);
            return this;
        }

        public APIRequestGetPages requestStarringField() {
            return this.requestStarringField(true);
        }

        public APIRequestGetPages requestStarringField(boolean value) {
            this.requestField("starring", value);
            return this;
        }

        public APIRequestGetPages requestStartInfoField() {
            return this.requestStartInfoField(true);
        }

        public APIRequestGetPages requestStartInfoField(boolean value) {
            this.requestField("start_info", value);
            return this;
        }

        public APIRequestGetPages requestStoreCodeField() {
            return this.requestStoreCodeField(true);
        }

        public APIRequestGetPages requestStoreCodeField(boolean value) {
            this.requestField("store_code", value);
            return this;
        }

        public APIRequestGetPages requestStoreLocationDescriptorField() {
            return this.requestStoreLocationDescriptorField(true);
        }

        public APIRequestGetPages requestStoreLocationDescriptorField(boolean value) {
            this.requestField("store_location_descriptor", value);
            return this;
        }

        public APIRequestGetPages requestStoreNumberField() {
            return this.requestStoreNumberField(true);
        }

        public APIRequestGetPages requestStoreNumberField(boolean value) {
            this.requestField("store_number", value);
            return this;
        }

        public APIRequestGetPages requestStudioField() {
            return this.requestStudioField(true);
        }

        public APIRequestGetPages requestStudioField(boolean value) {
            this.requestField("studio", value);
            return this;
        }

        public APIRequestGetPages requestSupportsInstantArticlesField() {
            return this.requestSupportsInstantArticlesField(true);
        }

        public APIRequestGetPages requestSupportsInstantArticlesField(boolean value) {
            this.requestField("supports_instant_articles", value);
            return this;
        }

        public APIRequestGetPages requestTalkingAboutCountField() {
            return this.requestTalkingAboutCountField(true);
        }

        public APIRequestGetPages requestTalkingAboutCountField(boolean value) {
            this.requestField("talking_about_count", value);
            return this;
        }

        public APIRequestGetPages requestUnreadMessageCountField() {
            return this.requestUnreadMessageCountField(true);
        }

        public APIRequestGetPages requestUnreadMessageCountField(boolean value) {
            this.requestField("unread_message_count", value);
            return this;
        }

        public APIRequestGetPages requestUnreadNotifCountField() {
            return this.requestUnreadNotifCountField(true);
        }

        public APIRequestGetPages requestUnreadNotifCountField(boolean value) {
            this.requestField("unread_notif_count", value);
            return this;
        }

        public APIRequestGetPages requestUnseenMessageCountField() {
            return this.requestUnseenMessageCountField(true);
        }

        public APIRequestGetPages requestUnseenMessageCountField(boolean value) {
            this.requestField("unseen_message_count", value);
            return this;
        }

        public APIRequestGetPages requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetPages requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGetPages requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetPages requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetPages requestVoipInfoField() {
            return this.requestVoipInfoField(true);
        }

        public APIRequestGetPages requestVoipInfoField(boolean value) {
            this.requestField("voip_info", value);
            return this;
        }

        public APIRequestGetPages requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetPages requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGetPages requestWereHereCountField() {
            return this.requestWereHereCountField(true);
        }

        public APIRequestGetPages requestWereHereCountField(boolean value) {
            this.requestField("were_here_count", value);
            return this;
        }

        public APIRequestGetPages requestWhatsappNumberField() {
            return this.requestWhatsappNumberField(true);
        }

        public APIRequestGetPages requestWhatsappNumberField(boolean value) {
            this.requestField("whatsapp_number", value);
            return this;
        }

        public APIRequestGetPages requestWrittenByField() {
            return this.requestWrittenByField(true);
        }

        public APIRequestGetPages requestWrittenByField(boolean value) {
            this.requestField("written_by", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeletePages
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"page_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDeletePages.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeletePages(String nodeId, APIContext context) {
            super(context, nodeId, "/pages", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeletePages setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeletePages setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeletePages setPageId(Long pageId) {
            this.setParam("page_id", pageId);
            return this;
        }

        public APIRequestDeletePages setPageId(String pageId) {
            this.setParam("page_id", pageId);
            return this;
        }

        public APIRequestDeletePages requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeletePages requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeletePages requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeletePages requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeletePages requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeletePages requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAsset
    extends APIRequest<BusinessProject> {
        BusinessProject lastResponse = null;
        public static final String[] PARAMS = new String[]{"asset_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public BusinessProject getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessProject parseResponse(String response, String header) throws APIException {
            return BusinessProject.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessProject execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessProject execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessProject> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessProject> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessProject>(){

                public BusinessProject apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateAsset.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAsset(String nodeId, APIContext context) {
            super(context, nodeId, "/assets", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAsset setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAsset setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAsset setAssetId(String assetId) {
            this.setParam("asset_id", assetId);
            return this;
        }

        public APIRequestCreateAsset requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAsset requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAsset requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAsset requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAsset requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAsset requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteAssets
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"asset_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDeleteAssets.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteAssets(String nodeId, APIContext context) {
            super(context, nodeId, "/assets", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteAssets setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteAssets setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteAssets setAssetId(String assetId) {
            this.setParam("asset_id", assetId);
            return this;
        }

        public APIRequestDeleteAssets requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteAssets requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAssets requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteAssets requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAssets requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteAssets requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateApp
    extends APIRequest<BusinessProject> {
        BusinessProject lastResponse = null;
        public static final String[] PARAMS = new String[]{"app_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public BusinessProject getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessProject parseResponse(String response, String header) throws APIException {
            return BusinessProject.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessProject execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessProject execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessProject> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessProject> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessProject>(){

                public BusinessProject apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateApp.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateApp(String nodeId, APIContext context) {
            super(context, nodeId, "/apps", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateApp setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateApp setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateApp setAppId(String appId) {
            this.setParam("app_id", appId);
            return this;
        }

        public APIRequestCreateApp requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateApp requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateApp requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateApp requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateApp requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateApp requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetApps
    extends APIRequest<Application> {
        APINodeList<Application> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"an_ad_space_limit", "an_platforms", "android_key_hash", "android_sdk_error_categories", "app_domains", "app_events_feature_bitmask", "app_events_session_timeout", "app_install_tracked", "app_name", "app_signals_binding_ios", "app_type", "auth_dialog_data_help_url", "auth_dialog_headline", "auth_dialog_perms_explanation", "auth_referral_default_activity_privacy", "auth_referral_enabled", "auth_referral_extended_perms", "auth_referral_friend_perms", "auth_referral_response_type", "auth_referral_user_perms", "auto_event_mapping_android", "auto_event_mapping_ios", "auto_event_setup_enabled", "canvas_fluid_height", "canvas_fluid_width", "canvas_url", "category", "client_config", "company", "configured_ios_sso", "contact_email", "context", "created_time", "creator_uid", "daily_active_users", "daily_active_users_rank", "deauth_callback_url", "default_share_mode", "description", "financial_id", "gdpv4_chrome_custom_tabs_enabled", "gdpv4_enabled", "gdpv4_nux_content", "gdpv4_nux_enabled", "has_messenger_product", "hosting_url", "icon_url", "id", "ios_bundle_id", "ios_sdk_dialog_flows", "ios_sdk_error_categories", "ios_sfvc_attr", "ios_supports_native_proxy_auth_flow", "ios_supports_system_auth", "ipad_app_store_id", "iphone_app_store_id", "is_viewer_admin", "latest_sdk_version", "link", "logging_token", "login_secret", "logo_url", "migrations", "mobile_profile_section_url", "mobile_web_url", "monthly_active_users", "monthly_active_users_rank", "name", "namespace", "object_store_urls", "page_tab_default_name", "page_tab_url", "photo_url", "privacy_policy_url", "profile_section_url", "property_id", "real_time_mode_devices", "restrictions", "sdk_update_message", "seamless_login", "secure_canvas_url", "secure_page_tab_url", "server_ip_whitelist", "smart_login_bookmark_icon_url", "smart_login_menu_icon_url", "social_discovery", "subcategory", "supported_platforms", "supports_apprequests_fast_app_switch", "supports_attribution", "supports_implicit_sdk_logging", "suppress_native_ios_gdp", "terms_of_service_url", "url_scheme_suffix", "user_support_email", "user_support_url", "website_url", "weekly_active_users"};

        @Override
        public APINodeList<Application> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Application> parseResponse(String response, String header) throws APIException {
            return Application.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Application> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Application> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Application>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Application>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Application>>(){

                public APINodeList<Application> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetApps.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetApps(String nodeId, APIContext context) {
            super(context, nodeId, "/apps", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetApps setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetApps setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetApps requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetApps requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetApps requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetApps requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetApps requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetApps requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetApps requestAnAdSpaceLimitField() {
            return this.requestAnAdSpaceLimitField(true);
        }

        public APIRequestGetApps requestAnAdSpaceLimitField(boolean value) {
            this.requestField("an_ad_space_limit", value);
            return this;
        }

        public APIRequestGetApps requestAnPlatformsField() {
            return this.requestAnPlatformsField(true);
        }

        public APIRequestGetApps requestAnPlatformsField(boolean value) {
            this.requestField("an_platforms", value);
            return this;
        }

        public APIRequestGetApps requestAndroidKeyHashField() {
            return this.requestAndroidKeyHashField(true);
        }

        public APIRequestGetApps requestAndroidKeyHashField(boolean value) {
            this.requestField("android_key_hash", value);
            return this;
        }

        public APIRequestGetApps requestAndroidSdkErrorCategoriesField() {
            return this.requestAndroidSdkErrorCategoriesField(true);
        }

        public APIRequestGetApps requestAndroidSdkErrorCategoriesField(boolean value) {
            this.requestField("android_sdk_error_categories", value);
            return this;
        }

        public APIRequestGetApps requestAppDomainsField() {
            return this.requestAppDomainsField(true);
        }

        public APIRequestGetApps requestAppDomainsField(boolean value) {
            this.requestField("app_domains", value);
            return this;
        }

        public APIRequestGetApps requestAppEventsFeatureBitmaskField() {
            return this.requestAppEventsFeatureBitmaskField(true);
        }

        public APIRequestGetApps requestAppEventsFeatureBitmaskField(boolean value) {
            this.requestField("app_events_feature_bitmask", value);
            return this;
        }

        public APIRequestGetApps requestAppEventsSessionTimeoutField() {
            return this.requestAppEventsSessionTimeoutField(true);
        }

        public APIRequestGetApps requestAppEventsSessionTimeoutField(boolean value) {
            this.requestField("app_events_session_timeout", value);
            return this;
        }

        public APIRequestGetApps requestAppInstallTrackedField() {
            return this.requestAppInstallTrackedField(true);
        }

        public APIRequestGetApps requestAppInstallTrackedField(boolean value) {
            this.requestField("app_install_tracked", value);
            return this;
        }

        public APIRequestGetApps requestAppNameField() {
            return this.requestAppNameField(true);
        }

        public APIRequestGetApps requestAppNameField(boolean value) {
            this.requestField("app_name", value);
            return this;
        }

        public APIRequestGetApps requestAppSignalsBindingIosField() {
            return this.requestAppSignalsBindingIosField(true);
        }

        public APIRequestGetApps requestAppSignalsBindingIosField(boolean value) {
            this.requestField("app_signals_binding_ios", value);
            return this;
        }

        public APIRequestGetApps requestAppTypeField() {
            return this.requestAppTypeField(true);
        }

        public APIRequestGetApps requestAppTypeField(boolean value) {
            this.requestField("app_type", value);
            return this;
        }

        public APIRequestGetApps requestAuthDialogDataHelpUrlField() {
            return this.requestAuthDialogDataHelpUrlField(true);
        }

        public APIRequestGetApps requestAuthDialogDataHelpUrlField(boolean value) {
            this.requestField("auth_dialog_data_help_url", value);
            return this;
        }

        public APIRequestGetApps requestAuthDialogHeadlineField() {
            return this.requestAuthDialogHeadlineField(true);
        }

        public APIRequestGetApps requestAuthDialogHeadlineField(boolean value) {
            this.requestField("auth_dialog_headline", value);
            return this;
        }

        public APIRequestGetApps requestAuthDialogPermsExplanationField() {
            return this.requestAuthDialogPermsExplanationField(true);
        }

        public APIRequestGetApps requestAuthDialogPermsExplanationField(boolean value) {
            this.requestField("auth_dialog_perms_explanation", value);
            return this;
        }

        public APIRequestGetApps requestAuthReferralDefaultActivityPrivacyField() {
            return this.requestAuthReferralDefaultActivityPrivacyField(true);
        }

        public APIRequestGetApps requestAuthReferralDefaultActivityPrivacyField(boolean value) {
            this.requestField("auth_referral_default_activity_privacy", value);
            return this;
        }

        public APIRequestGetApps requestAuthReferralEnabledField() {
            return this.requestAuthReferralEnabledField(true);
        }

        public APIRequestGetApps requestAuthReferralEnabledField(boolean value) {
            this.requestField("auth_referral_enabled", value);
            return this;
        }

        public APIRequestGetApps requestAuthReferralExtendedPermsField() {
            return this.requestAuthReferralExtendedPermsField(true);
        }

        public APIRequestGetApps requestAuthReferralExtendedPermsField(boolean value) {
            this.requestField("auth_referral_extended_perms", value);
            return this;
        }

        public APIRequestGetApps requestAuthReferralFriendPermsField() {
            return this.requestAuthReferralFriendPermsField(true);
        }

        public APIRequestGetApps requestAuthReferralFriendPermsField(boolean value) {
            this.requestField("auth_referral_friend_perms", value);
            return this;
        }

        public APIRequestGetApps requestAuthReferralResponseTypeField() {
            return this.requestAuthReferralResponseTypeField(true);
        }

        public APIRequestGetApps requestAuthReferralResponseTypeField(boolean value) {
            this.requestField("auth_referral_response_type", value);
            return this;
        }

        public APIRequestGetApps requestAuthReferralUserPermsField() {
            return this.requestAuthReferralUserPermsField(true);
        }

        public APIRequestGetApps requestAuthReferralUserPermsField(boolean value) {
            this.requestField("auth_referral_user_perms", value);
            return this;
        }

        public APIRequestGetApps requestAutoEventMappingAndroidField() {
            return this.requestAutoEventMappingAndroidField(true);
        }

        public APIRequestGetApps requestAutoEventMappingAndroidField(boolean value) {
            this.requestField("auto_event_mapping_android", value);
            return this;
        }

        public APIRequestGetApps requestAutoEventMappingIosField() {
            return this.requestAutoEventMappingIosField(true);
        }

        public APIRequestGetApps requestAutoEventMappingIosField(boolean value) {
            this.requestField("auto_event_mapping_ios", value);
            return this;
        }

        public APIRequestGetApps requestAutoEventSetupEnabledField() {
            return this.requestAutoEventSetupEnabledField(true);
        }

        public APIRequestGetApps requestAutoEventSetupEnabledField(boolean value) {
            this.requestField("auto_event_setup_enabled", value);
            return this;
        }

        public APIRequestGetApps requestCanvasFluidHeightField() {
            return this.requestCanvasFluidHeightField(true);
        }

        public APIRequestGetApps requestCanvasFluidHeightField(boolean value) {
            this.requestField("canvas_fluid_height", value);
            return this;
        }

        public APIRequestGetApps requestCanvasFluidWidthField() {
            return this.requestCanvasFluidWidthField(true);
        }

        public APIRequestGetApps requestCanvasFluidWidthField(boolean value) {
            this.requestField("canvas_fluid_width", value);
            return this;
        }

        public APIRequestGetApps requestCanvasUrlField() {
            return this.requestCanvasUrlField(true);
        }

        public APIRequestGetApps requestCanvasUrlField(boolean value) {
            this.requestField("canvas_url", value);
            return this;
        }

        public APIRequestGetApps requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetApps requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetApps requestClientConfigField() {
            return this.requestClientConfigField(true);
        }

        public APIRequestGetApps requestClientConfigField(boolean value) {
            this.requestField("client_config", value);
            return this;
        }

        public APIRequestGetApps requestCompanyField() {
            return this.requestCompanyField(true);
        }

        public APIRequestGetApps requestCompanyField(boolean value) {
            this.requestField("company", value);
            return this;
        }

        public APIRequestGetApps requestConfiguredIosSsoField() {
            return this.requestConfiguredIosSsoField(true);
        }

        public APIRequestGetApps requestConfiguredIosSsoField(boolean value) {
            this.requestField("configured_ios_sso", value);
            return this;
        }

        public APIRequestGetApps requestContactEmailField() {
            return this.requestContactEmailField(true);
        }

        public APIRequestGetApps requestContactEmailField(boolean value) {
            this.requestField("contact_email", value);
            return this;
        }

        public APIRequestGetApps requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetApps requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetApps requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetApps requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetApps requestCreatorUidField() {
            return this.requestCreatorUidField(true);
        }

        public APIRequestGetApps requestCreatorUidField(boolean value) {
            this.requestField("creator_uid", value);
            return this;
        }

        public APIRequestGetApps requestDailyActiveUsersField() {
            return this.requestDailyActiveUsersField(true);
        }

        public APIRequestGetApps requestDailyActiveUsersField(boolean value) {
            this.requestField("daily_active_users", value);
            return this;
        }

        public APIRequestGetApps requestDailyActiveUsersRankField() {
            return this.requestDailyActiveUsersRankField(true);
        }

        public APIRequestGetApps requestDailyActiveUsersRankField(boolean value) {
            this.requestField("daily_active_users_rank", value);
            return this;
        }

        public APIRequestGetApps requestDeauthCallbackUrlField() {
            return this.requestDeauthCallbackUrlField(true);
        }

        public APIRequestGetApps requestDeauthCallbackUrlField(boolean value) {
            this.requestField("deauth_callback_url", value);
            return this;
        }

        public APIRequestGetApps requestDefaultShareModeField() {
            return this.requestDefaultShareModeField(true);
        }

        public APIRequestGetApps requestDefaultShareModeField(boolean value) {
            this.requestField("default_share_mode", value);
            return this;
        }

        public APIRequestGetApps requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetApps requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetApps requestFinancialIdField() {
            return this.requestFinancialIdField(true);
        }

        public APIRequestGetApps requestFinancialIdField(boolean value) {
            this.requestField("financial_id", value);
            return this;
        }

        public APIRequestGetApps requestGdpv4ChromeCustomTabsEnabledField() {
            return this.requestGdpv4ChromeCustomTabsEnabledField(true);
        }

        public APIRequestGetApps requestGdpv4ChromeCustomTabsEnabledField(boolean value) {
            this.requestField("gdpv4_chrome_custom_tabs_enabled", value);
            return this;
        }

        public APIRequestGetApps requestGdpv4EnabledField() {
            return this.requestGdpv4EnabledField(true);
        }

        public APIRequestGetApps requestGdpv4EnabledField(boolean value) {
            this.requestField("gdpv4_enabled", value);
            return this;
        }

        public APIRequestGetApps requestGdpv4NuxContentField() {
            return this.requestGdpv4NuxContentField(true);
        }

        public APIRequestGetApps requestGdpv4NuxContentField(boolean value) {
            this.requestField("gdpv4_nux_content", value);
            return this;
        }

        public APIRequestGetApps requestGdpv4NuxEnabledField() {
            return this.requestGdpv4NuxEnabledField(true);
        }

        public APIRequestGetApps requestGdpv4NuxEnabledField(boolean value) {
            this.requestField("gdpv4_nux_enabled", value);
            return this;
        }

        public APIRequestGetApps requestHasMessengerProductField() {
            return this.requestHasMessengerProductField(true);
        }

        public APIRequestGetApps requestHasMessengerProductField(boolean value) {
            this.requestField("has_messenger_product", value);
            return this;
        }

        public APIRequestGetApps requestHostingUrlField() {
            return this.requestHostingUrlField(true);
        }

        public APIRequestGetApps requestHostingUrlField(boolean value) {
            this.requestField("hosting_url", value);
            return this;
        }

        public APIRequestGetApps requestIconUrlField() {
            return this.requestIconUrlField(true);
        }

        public APIRequestGetApps requestIconUrlField(boolean value) {
            this.requestField("icon_url", value);
            return this;
        }

        public APIRequestGetApps requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetApps requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetApps requestIosBundleIdField() {
            return this.requestIosBundleIdField(true);
        }

        public APIRequestGetApps requestIosBundleIdField(boolean value) {
            this.requestField("ios_bundle_id", value);
            return this;
        }

        public APIRequestGetApps requestIosSdkDialogFlowsField() {
            return this.requestIosSdkDialogFlowsField(true);
        }

        public APIRequestGetApps requestIosSdkDialogFlowsField(boolean value) {
            this.requestField("ios_sdk_dialog_flows", value);
            return this;
        }

        public APIRequestGetApps requestIosSdkErrorCategoriesField() {
            return this.requestIosSdkErrorCategoriesField(true);
        }

        public APIRequestGetApps requestIosSdkErrorCategoriesField(boolean value) {
            this.requestField("ios_sdk_error_categories", value);
            return this;
        }

        public APIRequestGetApps requestIosSfvcAttrField() {
            return this.requestIosSfvcAttrField(true);
        }

        public APIRequestGetApps requestIosSfvcAttrField(boolean value) {
            this.requestField("ios_sfvc_attr", value);
            return this;
        }

        public APIRequestGetApps requestIosSupportsNativeProxyAuthFlowField() {
            return this.requestIosSupportsNativeProxyAuthFlowField(true);
        }

        public APIRequestGetApps requestIosSupportsNativeProxyAuthFlowField(boolean value) {
            this.requestField("ios_supports_native_proxy_auth_flow", value);
            return this;
        }

        public APIRequestGetApps requestIosSupportsSystemAuthField() {
            return this.requestIosSupportsSystemAuthField(true);
        }

        public APIRequestGetApps requestIosSupportsSystemAuthField(boolean value) {
            this.requestField("ios_supports_system_auth", value);
            return this;
        }

        public APIRequestGetApps requestIpadAppStoreIdField() {
            return this.requestIpadAppStoreIdField(true);
        }

        public APIRequestGetApps requestIpadAppStoreIdField(boolean value) {
            this.requestField("ipad_app_store_id", value);
            return this;
        }

        public APIRequestGetApps requestIphoneAppStoreIdField() {
            return this.requestIphoneAppStoreIdField(true);
        }

        public APIRequestGetApps requestIphoneAppStoreIdField(boolean value) {
            this.requestField("iphone_app_store_id", value);
            return this;
        }

        public APIRequestGetApps requestIsViewerAdminField() {
            return this.requestIsViewerAdminField(true);
        }

        public APIRequestGetApps requestIsViewerAdminField(boolean value) {
            this.requestField("is_viewer_admin", value);
            return this;
        }

        public APIRequestGetApps requestLatestSdkVersionField() {
            return this.requestLatestSdkVersionField(true);
        }

        public APIRequestGetApps requestLatestSdkVersionField(boolean value) {
            this.requestField("latest_sdk_version", value);
            return this;
        }

        public APIRequestGetApps requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetApps requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetApps requestLoggingTokenField() {
            return this.requestLoggingTokenField(true);
        }

        public APIRequestGetApps requestLoggingTokenField(boolean value) {
            this.requestField("logging_token", value);
            return this;
        }

        public APIRequestGetApps requestLoginSecretField() {
            return this.requestLoginSecretField(true);
        }

        public APIRequestGetApps requestLoginSecretField(boolean value) {
            this.requestField("login_secret", value);
            return this;
        }

        public APIRequestGetApps requestLogoUrlField() {
            return this.requestLogoUrlField(true);
        }

        public APIRequestGetApps requestLogoUrlField(boolean value) {
            this.requestField("logo_url", value);
            return this;
        }

        public APIRequestGetApps requestMigrationsField() {
            return this.requestMigrationsField(true);
        }

        public APIRequestGetApps requestMigrationsField(boolean value) {
            this.requestField("migrations", value);
            return this;
        }

        public APIRequestGetApps requestMobileProfileSectionUrlField() {
            return this.requestMobileProfileSectionUrlField(true);
        }

        public APIRequestGetApps requestMobileProfileSectionUrlField(boolean value) {
            this.requestField("mobile_profile_section_url", value);
            return this;
        }

        public APIRequestGetApps requestMobileWebUrlField() {
            return this.requestMobileWebUrlField(true);
        }

        public APIRequestGetApps requestMobileWebUrlField(boolean value) {
            this.requestField("mobile_web_url", value);
            return this;
        }

        public APIRequestGetApps requestMonthlyActiveUsersField() {
            return this.requestMonthlyActiveUsersField(true);
        }

        public APIRequestGetApps requestMonthlyActiveUsersField(boolean value) {
            this.requestField("monthly_active_users", value);
            return this;
        }

        public APIRequestGetApps requestMonthlyActiveUsersRankField() {
            return this.requestMonthlyActiveUsersRankField(true);
        }

        public APIRequestGetApps requestMonthlyActiveUsersRankField(boolean value) {
            this.requestField("monthly_active_users_rank", value);
            return this;
        }

        public APIRequestGetApps requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetApps requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetApps requestNamespaceField() {
            return this.requestNamespaceField(true);
        }

        public APIRequestGetApps requestNamespaceField(boolean value) {
            this.requestField("namespace", value);
            return this;
        }

        public APIRequestGetApps requestObjectStoreUrlsField() {
            return this.requestObjectStoreUrlsField(true);
        }

        public APIRequestGetApps requestObjectStoreUrlsField(boolean value) {
            this.requestField("object_store_urls", value);
            return this;
        }

        public APIRequestGetApps requestPageTabDefaultNameField() {
            return this.requestPageTabDefaultNameField(true);
        }

        public APIRequestGetApps requestPageTabDefaultNameField(boolean value) {
            this.requestField("page_tab_default_name", value);
            return this;
        }

        public APIRequestGetApps requestPageTabUrlField() {
            return this.requestPageTabUrlField(true);
        }

        public APIRequestGetApps requestPageTabUrlField(boolean value) {
            this.requestField("page_tab_url", value);
            return this;
        }

        public APIRequestGetApps requestPhotoUrlField() {
            return this.requestPhotoUrlField(true);
        }

        public APIRequestGetApps requestPhotoUrlField(boolean value) {
            this.requestField("photo_url", value);
            return this;
        }

        public APIRequestGetApps requestPrivacyPolicyUrlField() {
            return this.requestPrivacyPolicyUrlField(true);
        }

        public APIRequestGetApps requestPrivacyPolicyUrlField(boolean value) {
            this.requestField("privacy_policy_url", value);
            return this;
        }

        public APIRequestGetApps requestProfileSectionUrlField() {
            return this.requestProfileSectionUrlField(true);
        }

        public APIRequestGetApps requestProfileSectionUrlField(boolean value) {
            this.requestField("profile_section_url", value);
            return this;
        }

        public APIRequestGetApps requestPropertyIdField() {
            return this.requestPropertyIdField(true);
        }

        public APIRequestGetApps requestPropertyIdField(boolean value) {
            this.requestField("property_id", value);
            return this;
        }

        public APIRequestGetApps requestRealTimeModeDevicesField() {
            return this.requestRealTimeModeDevicesField(true);
        }

        public APIRequestGetApps requestRealTimeModeDevicesField(boolean value) {
            this.requestField("real_time_mode_devices", value);
            return this;
        }

        public APIRequestGetApps requestRestrictionsField() {
            return this.requestRestrictionsField(true);
        }

        public APIRequestGetApps requestRestrictionsField(boolean value) {
            this.requestField("restrictions", value);
            return this;
        }

        public APIRequestGetApps requestSdkUpdateMessageField() {
            return this.requestSdkUpdateMessageField(true);
        }

        public APIRequestGetApps requestSdkUpdateMessageField(boolean value) {
            this.requestField("sdk_update_message", value);
            return this;
        }

        public APIRequestGetApps requestSeamlessLoginField() {
            return this.requestSeamlessLoginField(true);
        }

        public APIRequestGetApps requestSeamlessLoginField(boolean value) {
            this.requestField("seamless_login", value);
            return this;
        }

        public APIRequestGetApps requestSecureCanvasUrlField() {
            return this.requestSecureCanvasUrlField(true);
        }

        public APIRequestGetApps requestSecureCanvasUrlField(boolean value) {
            this.requestField("secure_canvas_url", value);
            return this;
        }

        public APIRequestGetApps requestSecurePageTabUrlField() {
            return this.requestSecurePageTabUrlField(true);
        }

        public APIRequestGetApps requestSecurePageTabUrlField(boolean value) {
            this.requestField("secure_page_tab_url", value);
            return this;
        }

        public APIRequestGetApps requestServerIpWhitelistField() {
            return this.requestServerIpWhitelistField(true);
        }

        public APIRequestGetApps requestServerIpWhitelistField(boolean value) {
            this.requestField("server_ip_whitelist", value);
            return this;
        }

        public APIRequestGetApps requestSmartLoginBookmarkIconUrlField() {
            return this.requestSmartLoginBookmarkIconUrlField(true);
        }

        public APIRequestGetApps requestSmartLoginBookmarkIconUrlField(boolean value) {
            this.requestField("smart_login_bookmark_icon_url", value);
            return this;
        }

        public APIRequestGetApps requestSmartLoginMenuIconUrlField() {
            return this.requestSmartLoginMenuIconUrlField(true);
        }

        public APIRequestGetApps requestSmartLoginMenuIconUrlField(boolean value) {
            this.requestField("smart_login_menu_icon_url", value);
            return this;
        }

        public APIRequestGetApps requestSocialDiscoveryField() {
            return this.requestSocialDiscoveryField(true);
        }

        public APIRequestGetApps requestSocialDiscoveryField(boolean value) {
            this.requestField("social_discovery", value);
            return this;
        }

        public APIRequestGetApps requestSubcategoryField() {
            return this.requestSubcategoryField(true);
        }

        public APIRequestGetApps requestSubcategoryField(boolean value) {
            this.requestField("subcategory", value);
            return this;
        }

        public APIRequestGetApps requestSupportedPlatformsField() {
            return this.requestSupportedPlatformsField(true);
        }

        public APIRequestGetApps requestSupportedPlatformsField(boolean value) {
            this.requestField("supported_platforms", value);
            return this;
        }

        public APIRequestGetApps requestSupportsApprequestsFastAppSwitchField() {
            return this.requestSupportsApprequestsFastAppSwitchField(true);
        }

        public APIRequestGetApps requestSupportsApprequestsFastAppSwitchField(boolean value) {
            this.requestField("supports_apprequests_fast_app_switch", value);
            return this;
        }

        public APIRequestGetApps requestSupportsAttributionField() {
            return this.requestSupportsAttributionField(true);
        }

        public APIRequestGetApps requestSupportsAttributionField(boolean value) {
            this.requestField("supports_attribution", value);
            return this;
        }

        public APIRequestGetApps requestSupportsImplicitSdkLoggingField() {
            return this.requestSupportsImplicitSdkLoggingField(true);
        }

        public APIRequestGetApps requestSupportsImplicitSdkLoggingField(boolean value) {
            this.requestField("supports_implicit_sdk_logging", value);
            return this;
        }

        public APIRequestGetApps requestSuppressNativeIosGdpField() {
            return this.requestSuppressNativeIosGdpField(true);
        }

        public APIRequestGetApps requestSuppressNativeIosGdpField(boolean value) {
            this.requestField("suppress_native_ios_gdp", value);
            return this;
        }

        public APIRequestGetApps requestTermsOfServiceUrlField() {
            return this.requestTermsOfServiceUrlField(true);
        }

        public APIRequestGetApps requestTermsOfServiceUrlField(boolean value) {
            this.requestField("terms_of_service_url", value);
            return this;
        }

        public APIRequestGetApps requestUrlSchemeSuffixField() {
            return this.requestUrlSchemeSuffixField(true);
        }

        public APIRequestGetApps requestUrlSchemeSuffixField(boolean value) {
            this.requestField("url_scheme_suffix", value);
            return this;
        }

        public APIRequestGetApps requestUserSupportEmailField() {
            return this.requestUserSupportEmailField(true);
        }

        public APIRequestGetApps requestUserSupportEmailField(boolean value) {
            this.requestField("user_support_email", value);
            return this;
        }

        public APIRequestGetApps requestUserSupportUrlField() {
            return this.requestUserSupportUrlField(true);
        }

        public APIRequestGetApps requestUserSupportUrlField(boolean value) {
            this.requestField("user_support_url", value);
            return this;
        }

        public APIRequestGetApps requestWebsiteUrlField() {
            return this.requestWebsiteUrlField(true);
        }

        public APIRequestGetApps requestWebsiteUrlField(boolean value) {
            this.requestField("website_url", value);
            return this;
        }

        public APIRequestGetApps requestWeeklyActiveUsersField() {
            return this.requestWeeklyActiveUsersField(true);
        }

        public APIRequestGetApps requestWeeklyActiveUsersField(boolean value) {
            this.requestField("weekly_active_users", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteApps
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"app_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDeleteApps.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteApps(String nodeId, APIContext context) {
            super(context, nodeId, "/apps", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteApps setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteApps setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteApps setAppId(String appId) {
            this.setParam("app_id", appId);
            return this;
        }

        public APIRequestDeleteApps requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteApps requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteApps requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteApps requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteApps requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteApps requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAdAccount
    extends APIRequest<BusinessProject> {
        BusinessProject lastResponse = null;
        public static final String[] PARAMS = new String[]{"adaccount_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public BusinessProject getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessProject parseResponse(String response, String header) throws APIException {
            return BusinessProject.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessProject execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessProject execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessProject> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessProject> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessProject>(){

                public BusinessProject apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateAdAccount.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAdAccount(String nodeId, APIContext context) {
            super(context, nodeId, "/adaccounts", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAdAccount setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAdAccount setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAdAccount setAdaccountId(String adaccountId) {
            this.setParam("adaccount_id", adaccountId);
            return this;
        }

        public APIRequestCreateAdAccount requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAdAccount requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdAccount requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAdAccount requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdAccount requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAdAccount requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdAccounts
    extends APIRequest<AdAccount> {
        APINodeList<AdAccount> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "account_status", "ad_account_creation_request", "ad_account_promotable_objects", "age", "agency_client_declaration", "amount_spent", "attribution_spec", "balance", "business", "business_city", "business_country_code", "business_name", "business_state", "business_street", "business_street2", "business_zip", "capabilities", "created_time", "currency", "disable_reason", "end_advertiser", "end_advertiser_name", "failed_delivery_checks", "fb_entity", "funding_source", "funding_source_details", "has_migrated_permissions", "has_page_authorized_adaccount", "id", "io_number", "is_attribution_spec_system_default", "is_direct_deals_enabled", "is_in_3ds_authorization_enabled_market", "is_in_middle_of_local_entity_migration", "is_notifications_enabled", "is_personal", "is_prepay_account", "is_tax_id_required", "line_numbers", "media_agency", "min_campaign_group_spend_cap", "min_daily_budget", "name", "offsite_pixels_tos_accepted", "owner", "partner", "rf_spec", "show_checkout_experience", "spend_cap", "tax_id", "tax_id_status", "tax_id_type", "timezone_id", "timezone_name", "timezone_offset_hours_utc", "tos_accepted", "user_role", "user_tos_accepted"};

        @Override
        public APINodeList<AdAccount> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccount> parseResponse(String response, String header) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdAccount> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccount> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdAccount>>(){

                public APINodeList<AdAccount> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetAdAccounts.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/adaccounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdAccounts requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAdAccounts requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAccountStatusField() {
            return this.requestAccountStatusField(true);
        }

        public APIRequestGetAdAccounts requestAccountStatusField(boolean value) {
            this.requestField("account_status", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAdAccountCreationRequestField() {
            return this.requestAdAccountCreationRequestField(true);
        }

        public APIRequestGetAdAccounts requestAdAccountCreationRequestField(boolean value) {
            this.requestField("ad_account_creation_request", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAdAccountPromotableObjectsField() {
            return this.requestAdAccountPromotableObjectsField(true);
        }

        public APIRequestGetAdAccounts requestAdAccountPromotableObjectsField(boolean value) {
            this.requestField("ad_account_promotable_objects", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAgeField() {
            return this.requestAgeField(true);
        }

        public APIRequestGetAdAccounts requestAgeField(boolean value) {
            this.requestField("age", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAgencyClientDeclarationField() {
            return this.requestAgencyClientDeclarationField(true);
        }

        public APIRequestGetAdAccounts requestAgencyClientDeclarationField(boolean value) {
            this.requestField("agency_client_declaration", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAmountSpentField() {
            return this.requestAmountSpentField(true);
        }

        public APIRequestGetAdAccounts requestAmountSpentField(boolean value) {
            this.requestField("amount_spent", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetAdAccounts requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBalanceField() {
            return this.requestBalanceField(true);
        }

        public APIRequestGetAdAccounts requestBalanceField(boolean value) {
            this.requestField("balance", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAdAccounts requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessCityField() {
            return this.requestBusinessCityField(true);
        }

        public APIRequestGetAdAccounts requestBusinessCityField(boolean value) {
            this.requestField("business_city", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessCountryCodeField() {
            return this.requestBusinessCountryCodeField(true);
        }

        public APIRequestGetAdAccounts requestBusinessCountryCodeField(boolean value) {
            this.requestField("business_country_code", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessNameField() {
            return this.requestBusinessNameField(true);
        }

        public APIRequestGetAdAccounts requestBusinessNameField(boolean value) {
            this.requestField("business_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStateField() {
            return this.requestBusinessStateField(true);
        }

        public APIRequestGetAdAccounts requestBusinessStateField(boolean value) {
            this.requestField("business_state", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStreetField() {
            return this.requestBusinessStreetField(true);
        }

        public APIRequestGetAdAccounts requestBusinessStreetField(boolean value) {
            this.requestField("business_street", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStreet2Field() {
            return this.requestBusinessStreet2Field(true);
        }

        public APIRequestGetAdAccounts requestBusinessStreet2Field(boolean value) {
            this.requestField("business_street2", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessZipField() {
            return this.requestBusinessZipField(true);
        }

        public APIRequestGetAdAccounts requestBusinessZipField(boolean value) {
            this.requestField("business_zip", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCapabilitiesField() {
            return this.requestCapabilitiesField(true);
        }

        public APIRequestGetAdAccounts requestCapabilitiesField(boolean value) {
            this.requestField("capabilities", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAdAccounts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetAdAccounts requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetAdAccounts requestDisableReasonField() {
            return this.requestDisableReasonField(true);
        }

        public APIRequestGetAdAccounts requestDisableReasonField(boolean value) {
            this.requestField("disable_reason", value);
            return this;
        }

        public APIRequestGetAdAccounts requestEndAdvertiserField() {
            return this.requestEndAdvertiserField(true);
        }

        public APIRequestGetAdAccounts requestEndAdvertiserField(boolean value) {
            this.requestField("end_advertiser", value);
            return this;
        }

        public APIRequestGetAdAccounts requestEndAdvertiserNameField() {
            return this.requestEndAdvertiserNameField(true);
        }

        public APIRequestGetAdAccounts requestEndAdvertiserNameField(boolean value) {
            this.requestField("end_advertiser_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFailedDeliveryChecksField() {
            return this.requestFailedDeliveryChecksField(true);
        }

        public APIRequestGetAdAccounts requestFailedDeliveryChecksField(boolean value) {
            this.requestField("failed_delivery_checks", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFbEntityField() {
            return this.requestFbEntityField(true);
        }

        public APIRequestGetAdAccounts requestFbEntityField(boolean value) {
            this.requestField("fb_entity", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFundingSourceField() {
            return this.requestFundingSourceField(true);
        }

        public APIRequestGetAdAccounts requestFundingSourceField(boolean value) {
            this.requestField("funding_source", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFundingSourceDetailsField() {
            return this.requestFundingSourceDetailsField(true);
        }

        public APIRequestGetAdAccounts requestFundingSourceDetailsField(boolean value) {
            this.requestField("funding_source_details", value);
            return this;
        }

        public APIRequestGetAdAccounts requestHasMigratedPermissionsField() {
            return this.requestHasMigratedPermissionsField(true);
        }

        public APIRequestGetAdAccounts requestHasMigratedPermissionsField(boolean value) {
            this.requestField("has_migrated_permissions", value);
            return this;
        }

        public APIRequestGetAdAccounts requestHasPageAuthorizedAdaccountField() {
            return this.requestHasPageAuthorizedAdaccountField(true);
        }

        public APIRequestGetAdAccounts requestHasPageAuthorizedAdaccountField(boolean value) {
            this.requestField("has_page_authorized_adaccount", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGetAdAccounts requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsAttributionSpecSystemDefaultField() {
            return this.requestIsAttributionSpecSystemDefaultField(true);
        }

        public APIRequestGetAdAccounts requestIsAttributionSpecSystemDefaultField(boolean value) {
            this.requestField("is_attribution_spec_system_default", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsDirectDealsEnabledField() {
            return this.requestIsDirectDealsEnabledField(true);
        }

        public APIRequestGetAdAccounts requestIsDirectDealsEnabledField(boolean value) {
            this.requestField("is_direct_deals_enabled", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsIn3dsAuthorizationEnabledMarketField() {
            return this.requestIsIn3dsAuthorizationEnabledMarketField(true);
        }

        public APIRequestGetAdAccounts requestIsIn3dsAuthorizationEnabledMarketField(boolean value) {
            this.requestField("is_in_3ds_authorization_enabled_market", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsInMiddleOfLocalEntityMigrationField() {
            return this.requestIsInMiddleOfLocalEntityMigrationField(true);
        }

        public APIRequestGetAdAccounts requestIsInMiddleOfLocalEntityMigrationField(boolean value) {
            this.requestField("is_in_middle_of_local_entity_migration", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsNotificationsEnabledField() {
            return this.requestIsNotificationsEnabledField(true);
        }

        public APIRequestGetAdAccounts requestIsNotificationsEnabledField(boolean value) {
            this.requestField("is_notifications_enabled", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsPersonalField() {
            return this.requestIsPersonalField(true);
        }

        public APIRequestGetAdAccounts requestIsPersonalField(boolean value) {
            this.requestField("is_personal", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsPrepayAccountField() {
            return this.requestIsPrepayAccountField(true);
        }

        public APIRequestGetAdAccounts requestIsPrepayAccountField(boolean value) {
            this.requestField("is_prepay_account", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsTaxIdRequiredField() {
            return this.requestIsTaxIdRequiredField(true);
        }

        public APIRequestGetAdAccounts requestIsTaxIdRequiredField(boolean value) {
            this.requestField("is_tax_id_required", value);
            return this;
        }

        public APIRequestGetAdAccounts requestLineNumbersField() {
            return this.requestLineNumbersField(true);
        }

        public APIRequestGetAdAccounts requestLineNumbersField(boolean value) {
            this.requestField("line_numbers", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMediaAgencyField() {
            return this.requestMediaAgencyField(true);
        }

        public APIRequestGetAdAccounts requestMediaAgencyField(boolean value) {
            this.requestField("media_agency", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMinCampaignGroupSpendCapField() {
            return this.requestMinCampaignGroupSpendCapField(true);
        }

        public APIRequestGetAdAccounts requestMinCampaignGroupSpendCapField(boolean value) {
            this.requestField("min_campaign_group_spend_cap", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMinDailyBudgetField() {
            return this.requestMinDailyBudgetField(true);
        }

        public APIRequestGetAdAccounts requestMinDailyBudgetField(boolean value) {
            this.requestField("min_daily_budget", value);
            return this;
        }

        public APIRequestGetAdAccounts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdAccounts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOffsitePixelsTosAcceptedField() {
            return this.requestOffsitePixelsTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestOffsitePixelsTosAcceptedField(boolean value) {
            this.requestField("offsite_pixels_tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetAdAccounts requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetAdAccounts requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetAdAccounts requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetAdAccounts requestRfSpecField() {
            return this.requestRfSpecField(true);
        }

        public APIRequestGetAdAccounts requestRfSpecField(boolean value) {
            this.requestField("rf_spec", value);
            return this;
        }

        public APIRequestGetAdAccounts requestShowCheckoutExperienceField() {
            return this.requestShowCheckoutExperienceField(true);
        }

        public APIRequestGetAdAccounts requestShowCheckoutExperienceField(boolean value) {
            this.requestField("show_checkout_experience", value);
            return this;
        }

        public APIRequestGetAdAccounts requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetAdAccounts requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdField() {
            return this.requestTaxIdField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdField(boolean value) {
            this.requestField("tax_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdStatusField() {
            return this.requestTaxIdStatusField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdStatusField(boolean value) {
            this.requestField("tax_id_status", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdTypeField() {
            return this.requestTaxIdTypeField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdTypeField(boolean value) {
            this.requestField("tax_id_type", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneOffsetHoursUtcField() {
            return this.requestTimezoneOffsetHoursUtcField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneOffsetHoursUtcField(boolean value) {
            this.requestField("timezone_offset_hours_utc", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTosAcceptedField() {
            return this.requestTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestTosAcceptedField(boolean value) {
            this.requestField("tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestUserRoleField() {
            return this.requestUserRoleField(true);
        }

        public APIRequestGetAdAccounts requestUserRoleField(boolean value) {
            this.requestField("user_role", value);
            return this;
        }

        public APIRequestGetAdAccounts requestUserTosAcceptedField() {
            return this.requestUserTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestUserTosAcceptedField(boolean value) {
            this.requestField("user_tos_accepted", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteAdAccounts
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"adaccount_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDeleteAdAccounts.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/adaccounts", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteAdAccounts setAdaccountId(String adaccountId) {
            this.setParam("adaccount_id", adaccountId);
            return this;
        }

        public APIRequestDeleteAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

