/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingReaction
extends APINode {
    @SerializedName(value="count")
    private Long mCount = null;
    @SerializedName(value="reaction_type")
    private EnumReactionType mReactionType = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static StreamingReaction loadJSON(String json, APIContext context, String header) {
        StreamingReaction streamingReaction = (StreamingReaction)StreamingReaction.getGson().fromJson(json, StreamingReaction.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(streamingReaction.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        streamingReaction.context = context;
        streamingReaction.rawValue = json;
        streamingReaction.header = header;
        return streamingReaction;
    }

    public static APINodeList<StreamingReaction> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<StreamingReaction> streamingReactions = new APINodeList<StreamingReaction>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        streamingReactions.add(StreamingReaction.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return streamingReactions;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            streamingReactions.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        streamingReactions.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            streamingReactions.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            streamingReactions.add(StreamingReaction.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                streamingReactions.add(StreamingReaction.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            streamingReactions.add(StreamingReaction.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return streamingReactions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        streamingReactions.add(StreamingReaction.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return streamingReactions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        streamingReactions.add(StreamingReaction.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return streamingReactions;
                }
                streamingReactions.clear();
                streamingReactions.add(StreamingReaction.loadJSON(json, context, header));
                return streamingReactions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return StreamingReaction.getGson().toJson((Object)this);
    }

    public Long getFieldCount() {
        return this.mCount;
    }

    public StreamingReaction setFieldCount(Long value) {
        this.mCount = value;
        return this;
    }

    public EnumReactionType getFieldReactionType() {
        return this.mReactionType;
    }

    public StreamingReaction setFieldReactionType(EnumReactionType value) {
        this.mReactionType = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public StreamingReaction setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public StreamingReaction copyFrom(StreamingReaction instance) {
        this.mCount = instance.mCount;
        this.mReactionType = instance.mReactionType;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<StreamingReaction> getParser() {
        return new APIRequest.ResponseParser<StreamingReaction>(){

            @Override
            public APINodeList<StreamingReaction> parseResponse(String response, APIContext context, APIRequest<StreamingReaction> request, String header) throws APIException.MalformedResponseException {
                return StreamingReaction.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumReactionType {
        VALUE_ANGRY("ANGRY"),
        VALUE_HAHA("HAHA"),
        VALUE_LIKE("LIKE"),
        VALUE_LOVE("LOVE"),
        VALUE_NONE("NONE"),
        VALUE_PRIDE("PRIDE"),
        VALUE_SAD("SAD"),
        VALUE_THANKFUL("THANKFUL"),
        VALUE_WOW("WOW"),
        NULL(null);

        private String value;

        private EnumReactionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

