/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.IDName;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexibleTargeting
extends APINode {
    @SerializedName(value="behaviors")
    private List<IDName> mBehaviors = null;
    @SerializedName(value="college_years")
    private List<Long> mCollegeYears = null;
    @SerializedName(value="connections")
    private List<IDName> mConnections = null;
    @SerializedName(value="custom_audiences")
    private List<IDName> mCustomAudiences = null;
    @SerializedName(value="education_majors")
    private List<IDName> mEducationMajors = null;
    @SerializedName(value="education_schools")
    private List<IDName> mEducationSchools = null;
    @SerializedName(value="education_statuses")
    private List<Long> mEducationStatuses = null;
    @SerializedName(value="ethnic_affinity")
    private List<IDName> mEthnicAffinity = null;
    @SerializedName(value="family_statuses")
    private List<IDName> mFamilyStatuses = null;
    @SerializedName(value="friends_of_connections")
    private List<IDName> mFriendsOfConnections = null;
    @SerializedName(value="generation")
    private List<IDName> mGeneration = null;
    @SerializedName(value="home_ownership")
    private List<IDName> mHomeOwnership = null;
    @SerializedName(value="home_type")
    private List<IDName> mHomeType = null;
    @SerializedName(value="home_value")
    private List<IDName> mHomeValue = null;
    @SerializedName(value="household_composition")
    private List<IDName> mHouseholdComposition = null;
    @SerializedName(value="income")
    private List<IDName> mIncome = null;
    @SerializedName(value="industries")
    private List<IDName> mIndustries = null;
    @SerializedName(value="interested_in")
    private List<Long> mInterestedIn = null;
    @SerializedName(value="interests")
    private List<IDName> mInterests = null;
    @SerializedName(value="life_events")
    private List<IDName> mLifeEvents = null;
    @SerializedName(value="moms")
    private List<IDName> mMoms = null;
    @SerializedName(value="net_worth")
    private List<IDName> mNetWorth = null;
    @SerializedName(value="office_type")
    private List<IDName> mOfficeType = null;
    @SerializedName(value="politics")
    private List<IDName> mPolitics = null;
    @SerializedName(value="relationship_statuses")
    private List<Long> mRelationshipStatuses = null;
    @SerializedName(value="user_adclusters")
    private List<IDName> mUserAdclusters = null;
    @SerializedName(value="work_employers")
    private List<IDName> mWorkEmployers = null;
    @SerializedName(value="work_positions")
    private List<IDName> mWorkPositions = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static FlexibleTargeting loadJSON(String json, APIContext context, String header) {
        FlexibleTargeting flexibleTargeting = (FlexibleTargeting)FlexibleTargeting.getGson().fromJson(json, FlexibleTargeting.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(flexibleTargeting.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        flexibleTargeting.context = context;
        flexibleTargeting.rawValue = json;
        flexibleTargeting.header = header;
        return flexibleTargeting;
    }

    public static APINodeList<FlexibleTargeting> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<FlexibleTargeting> flexibleTargetings = new APINodeList<FlexibleTargeting>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        flexibleTargetings.add(FlexibleTargeting.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return flexibleTargetings;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            flexibleTargetings.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        flexibleTargetings.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            flexibleTargetings.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            flexibleTargetings.add(FlexibleTargeting.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                flexibleTargetings.add(FlexibleTargeting.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            flexibleTargetings.add(FlexibleTargeting.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return flexibleTargetings;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        flexibleTargetings.add(FlexibleTargeting.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return flexibleTargetings;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        flexibleTargetings.add(FlexibleTargeting.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return flexibleTargetings;
                }
                flexibleTargetings.clear();
                flexibleTargetings.add(FlexibleTargeting.loadJSON(json, context, header));
                return flexibleTargetings;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return FlexibleTargeting.getGson().toJson((Object)this);
    }

    public List<IDName> getFieldBehaviors() {
        return this.mBehaviors;
    }

    public FlexibleTargeting setFieldBehaviors(List<IDName> value) {
        this.mBehaviors = value;
        return this;
    }

    public FlexibleTargeting setFieldBehaviors(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mBehaviors = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<Long> getFieldCollegeYears() {
        return this.mCollegeYears;
    }

    public FlexibleTargeting setFieldCollegeYears(List<Long> value) {
        this.mCollegeYears = value;
        return this;
    }

    public List<IDName> getFieldConnections() {
        return this.mConnections;
    }

    public FlexibleTargeting setFieldConnections(List<IDName> value) {
        this.mConnections = value;
        return this;
    }

    public FlexibleTargeting setFieldConnections(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mConnections = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldCustomAudiences() {
        return this.mCustomAudiences;
    }

    public FlexibleTargeting setFieldCustomAudiences(List<IDName> value) {
        this.mCustomAudiences = value;
        return this;
    }

    public FlexibleTargeting setFieldCustomAudiences(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mCustomAudiences = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldEducationMajors() {
        return this.mEducationMajors;
    }

    public FlexibleTargeting setFieldEducationMajors(List<IDName> value) {
        this.mEducationMajors = value;
        return this;
    }

    public FlexibleTargeting setFieldEducationMajors(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mEducationMajors = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldEducationSchools() {
        return this.mEducationSchools;
    }

    public FlexibleTargeting setFieldEducationSchools(List<IDName> value) {
        this.mEducationSchools = value;
        return this;
    }

    public FlexibleTargeting setFieldEducationSchools(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mEducationSchools = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<Long> getFieldEducationStatuses() {
        return this.mEducationStatuses;
    }

    public FlexibleTargeting setFieldEducationStatuses(List<Long> value) {
        this.mEducationStatuses = value;
        return this;
    }

    public List<IDName> getFieldEthnicAffinity() {
        return this.mEthnicAffinity;
    }

    public FlexibleTargeting setFieldEthnicAffinity(List<IDName> value) {
        this.mEthnicAffinity = value;
        return this;
    }

    public FlexibleTargeting setFieldEthnicAffinity(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mEthnicAffinity = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldFamilyStatuses() {
        return this.mFamilyStatuses;
    }

    public FlexibleTargeting setFieldFamilyStatuses(List<IDName> value) {
        this.mFamilyStatuses = value;
        return this;
    }

    public FlexibleTargeting setFieldFamilyStatuses(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mFamilyStatuses = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldFriendsOfConnections() {
        return this.mFriendsOfConnections;
    }

    public FlexibleTargeting setFieldFriendsOfConnections(List<IDName> value) {
        this.mFriendsOfConnections = value;
        return this;
    }

    public FlexibleTargeting setFieldFriendsOfConnections(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mFriendsOfConnections = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldGeneration() {
        return this.mGeneration;
    }

    public FlexibleTargeting setFieldGeneration(List<IDName> value) {
        this.mGeneration = value;
        return this;
    }

    public FlexibleTargeting setFieldGeneration(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mGeneration = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldHomeOwnership() {
        return this.mHomeOwnership;
    }

    public FlexibleTargeting setFieldHomeOwnership(List<IDName> value) {
        this.mHomeOwnership = value;
        return this;
    }

    public FlexibleTargeting setFieldHomeOwnership(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mHomeOwnership = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldHomeType() {
        return this.mHomeType;
    }

    public FlexibleTargeting setFieldHomeType(List<IDName> value) {
        this.mHomeType = value;
        return this;
    }

    public FlexibleTargeting setFieldHomeType(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mHomeType = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldHomeValue() {
        return this.mHomeValue;
    }

    public FlexibleTargeting setFieldHomeValue(List<IDName> value) {
        this.mHomeValue = value;
        return this;
    }

    public FlexibleTargeting setFieldHomeValue(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mHomeValue = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldHouseholdComposition() {
        return this.mHouseholdComposition;
    }

    public FlexibleTargeting setFieldHouseholdComposition(List<IDName> value) {
        this.mHouseholdComposition = value;
        return this;
    }

    public FlexibleTargeting setFieldHouseholdComposition(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mHouseholdComposition = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldIncome() {
        return this.mIncome;
    }

    public FlexibleTargeting setFieldIncome(List<IDName> value) {
        this.mIncome = value;
        return this;
    }

    public FlexibleTargeting setFieldIncome(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mIncome = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldIndustries() {
        return this.mIndustries;
    }

    public FlexibleTargeting setFieldIndustries(List<IDName> value) {
        this.mIndustries = value;
        return this;
    }

    public FlexibleTargeting setFieldIndustries(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mIndustries = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<Long> getFieldInterestedIn() {
        return this.mInterestedIn;
    }

    public FlexibleTargeting setFieldInterestedIn(List<Long> value) {
        this.mInterestedIn = value;
        return this;
    }

    public List<IDName> getFieldInterests() {
        return this.mInterests;
    }

    public FlexibleTargeting setFieldInterests(List<IDName> value) {
        this.mInterests = value;
        return this;
    }

    public FlexibleTargeting setFieldInterests(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mInterests = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldLifeEvents() {
        return this.mLifeEvents;
    }

    public FlexibleTargeting setFieldLifeEvents(List<IDName> value) {
        this.mLifeEvents = value;
        return this;
    }

    public FlexibleTargeting setFieldLifeEvents(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mLifeEvents = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldMoms() {
        return this.mMoms;
    }

    public FlexibleTargeting setFieldMoms(List<IDName> value) {
        this.mMoms = value;
        return this;
    }

    public FlexibleTargeting setFieldMoms(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mMoms = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldNetWorth() {
        return this.mNetWorth;
    }

    public FlexibleTargeting setFieldNetWorth(List<IDName> value) {
        this.mNetWorth = value;
        return this;
    }

    public FlexibleTargeting setFieldNetWorth(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mNetWorth = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldOfficeType() {
        return this.mOfficeType;
    }

    public FlexibleTargeting setFieldOfficeType(List<IDName> value) {
        this.mOfficeType = value;
        return this;
    }

    public FlexibleTargeting setFieldOfficeType(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mOfficeType = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldPolitics() {
        return this.mPolitics;
    }

    public FlexibleTargeting setFieldPolitics(List<IDName> value) {
        this.mPolitics = value;
        return this;
    }

    public FlexibleTargeting setFieldPolitics(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mPolitics = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<Long> getFieldRelationshipStatuses() {
        return this.mRelationshipStatuses;
    }

    public FlexibleTargeting setFieldRelationshipStatuses(List<Long> value) {
        this.mRelationshipStatuses = value;
        return this;
    }

    public List<IDName> getFieldUserAdclusters() {
        return this.mUserAdclusters;
    }

    public FlexibleTargeting setFieldUserAdclusters(List<IDName> value) {
        this.mUserAdclusters = value;
        return this;
    }

    public FlexibleTargeting setFieldUserAdclusters(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mUserAdclusters = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldWorkEmployers() {
        return this.mWorkEmployers;
    }

    public FlexibleTargeting setFieldWorkEmployers(List<IDName> value) {
        this.mWorkEmployers = value;
        return this;
    }

    public FlexibleTargeting setFieldWorkEmployers(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mWorkEmployers = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public List<IDName> getFieldWorkPositions() {
        return this.mWorkPositions;
    }

    public FlexibleTargeting setFieldWorkPositions(List<IDName> value) {
        this.mWorkPositions = value;
        return this;
    }

    public FlexibleTargeting setFieldWorkPositions(String value) {
        Type type = new TypeToken<List<IDName>>(){}.getType();
        this.mWorkPositions = (List)IDName.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public FlexibleTargeting setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public FlexibleTargeting copyFrom(FlexibleTargeting instance) {
        this.mBehaviors = instance.mBehaviors;
        this.mCollegeYears = instance.mCollegeYears;
        this.mConnections = instance.mConnections;
        this.mCustomAudiences = instance.mCustomAudiences;
        this.mEducationMajors = instance.mEducationMajors;
        this.mEducationSchools = instance.mEducationSchools;
        this.mEducationStatuses = instance.mEducationStatuses;
        this.mEthnicAffinity = instance.mEthnicAffinity;
        this.mFamilyStatuses = instance.mFamilyStatuses;
        this.mFriendsOfConnections = instance.mFriendsOfConnections;
        this.mGeneration = instance.mGeneration;
        this.mHomeOwnership = instance.mHomeOwnership;
        this.mHomeType = instance.mHomeType;
        this.mHomeValue = instance.mHomeValue;
        this.mHouseholdComposition = instance.mHouseholdComposition;
        this.mIncome = instance.mIncome;
        this.mIndustries = instance.mIndustries;
        this.mInterestedIn = instance.mInterestedIn;
        this.mInterests = instance.mInterests;
        this.mLifeEvents = instance.mLifeEvents;
        this.mMoms = instance.mMoms;
        this.mNetWorth = instance.mNetWorth;
        this.mOfficeType = instance.mOfficeType;
        this.mPolitics = instance.mPolitics;
        this.mRelationshipStatuses = instance.mRelationshipStatuses;
        this.mUserAdclusters = instance.mUserAdclusters;
        this.mWorkEmployers = instance.mWorkEmployers;
        this.mWorkPositions = instance.mWorkPositions;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<FlexibleTargeting> getParser() {
        return new APIRequest.ResponseParser<FlexibleTargeting>(){

            @Override
            public APINodeList<FlexibleTargeting> parseResponse(String response, APIContext context, APIRequest<FlexibleTargeting> request, String header) throws APIException.MalformedResponseException {
                return FlexibleTargeting.parseResponse(response, context, request, header);
            }
        };
    }
}

