/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetingGeoLocationPlace
extends APINode {
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="distance_unit")
    private String mDistanceUnit = null;
    @SerializedName(value="key")
    private String mKey = null;
    @SerializedName(value="latitude")
    private Double mLatitude = null;
    @SerializedName(value="longitude")
    private Double mLongitude = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="primary_city_id")
    private Long mPrimaryCityId = null;
    @SerializedName(value="radius")
    private Double mRadius = null;
    @SerializedName(value="region_id")
    private Long mRegionId = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static TargetingGeoLocationPlace loadJSON(String json, APIContext context, String header) {
        TargetingGeoLocationPlace targetingGeoLocationPlace = (TargetingGeoLocationPlace)TargetingGeoLocationPlace.getGson().fromJson(json, TargetingGeoLocationPlace.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(targetingGeoLocationPlace.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        targetingGeoLocationPlace.context = context;
        targetingGeoLocationPlace.rawValue = json;
        targetingGeoLocationPlace.header = header;
        return targetingGeoLocationPlace;
    }

    public static APINodeList<TargetingGeoLocationPlace> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<TargetingGeoLocationPlace> targetingGeoLocationPlaces = new APINodeList<TargetingGeoLocationPlace>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        targetingGeoLocationPlaces.add(TargetingGeoLocationPlace.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return targetingGeoLocationPlaces;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            targetingGeoLocationPlaces.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        targetingGeoLocationPlaces.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            targetingGeoLocationPlaces.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            targetingGeoLocationPlaces.add(TargetingGeoLocationPlace.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                targetingGeoLocationPlaces.add(TargetingGeoLocationPlace.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            targetingGeoLocationPlaces.add(TargetingGeoLocationPlace.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return targetingGeoLocationPlaces;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        targetingGeoLocationPlaces.add(TargetingGeoLocationPlace.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return targetingGeoLocationPlaces;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        targetingGeoLocationPlaces.add(TargetingGeoLocationPlace.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return targetingGeoLocationPlaces;
                }
                targetingGeoLocationPlaces.clear();
                targetingGeoLocationPlaces.add(TargetingGeoLocationPlace.loadJSON(json, context, header));
                return targetingGeoLocationPlaces;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return TargetingGeoLocationPlace.getGson().toJson((Object)this);
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public TargetingGeoLocationPlace setFieldCountry(String value) {
        this.mCountry = value;
        return this;
    }

    public String getFieldDistanceUnit() {
        return this.mDistanceUnit;
    }

    public TargetingGeoLocationPlace setFieldDistanceUnit(String value) {
        this.mDistanceUnit = value;
        return this;
    }

    public String getFieldKey() {
        return this.mKey;
    }

    public TargetingGeoLocationPlace setFieldKey(String value) {
        this.mKey = value;
        return this;
    }

    public Double getFieldLatitude() {
        return this.mLatitude;
    }

    public TargetingGeoLocationPlace setFieldLatitude(Double value) {
        this.mLatitude = value;
        return this;
    }

    public Double getFieldLongitude() {
        return this.mLongitude;
    }

    public TargetingGeoLocationPlace setFieldLongitude(Double value) {
        this.mLongitude = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public TargetingGeoLocationPlace setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public Long getFieldPrimaryCityId() {
        return this.mPrimaryCityId;
    }

    public TargetingGeoLocationPlace setFieldPrimaryCityId(Long value) {
        this.mPrimaryCityId = value;
        return this;
    }

    public Double getFieldRadius() {
        return this.mRadius;
    }

    public TargetingGeoLocationPlace setFieldRadius(Double value) {
        this.mRadius = value;
        return this;
    }

    public Long getFieldRegionId() {
        return this.mRegionId;
    }

    public TargetingGeoLocationPlace setFieldRegionId(Long value) {
        this.mRegionId = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public TargetingGeoLocationPlace setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public TargetingGeoLocationPlace copyFrom(TargetingGeoLocationPlace instance) {
        this.mCountry = instance.mCountry;
        this.mDistanceUnit = instance.mDistanceUnit;
        this.mKey = instance.mKey;
        this.mLatitude = instance.mLatitude;
        this.mLongitude = instance.mLongitude;
        this.mName = instance.mName;
        this.mPrimaryCityId = instance.mPrimaryCityId;
        this.mRadius = instance.mRadius;
        this.mRegionId = instance.mRegionId;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<TargetingGeoLocationPlace> getParser() {
        return new APIRequest.ResponseParser<TargetingGeoLocationPlace>(){

            @Override
            public APINodeList<TargetingGeoLocationPlace> parseResponse(String response, APIContext context, APIRequest<TargetingGeoLocationPlace> request, String header) throws APIException.MalformedResponseException {
                return TargetingGeoLocationPlace.parseResponse(response, context, request, header);
            }
        };
    }
}

