/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Currency
extends APINode {
    @SerializedName(value="currency_offset")
    private Long mCurrencyOffset = null;
    @SerializedName(value="usd_exchange")
    private Double mUsdExchange = null;
    @SerializedName(value="usd_exchange_inverse")
    private Double mUsdExchangeInverse = null;
    @SerializedName(value="user_currency")
    private String mUserCurrency = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Currency loadJSON(String json, APIContext context, String header) {
        Currency currency = (Currency)Currency.getGson().fromJson(json, Currency.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(currency.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        currency.context = context;
        currency.rawValue = json;
        currency.header = header;
        return currency;
    }

    public static APINodeList<Currency> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Currency> currencys = new APINodeList<Currency>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        currencys.add(Currency.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return currencys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            currencys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        currencys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            currencys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            currencys.add(Currency.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                currencys.add(Currency.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            currencys.add(Currency.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return currencys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        currencys.add(Currency.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return currencys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        currencys.add(Currency.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return currencys;
                }
                currencys.clear();
                currencys.add(Currency.loadJSON(json, context, header));
                return currencys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Currency.getGson().toJson((Object)this);
    }

    public Long getFieldCurrencyOffset() {
        return this.mCurrencyOffset;
    }

    public Currency setFieldCurrencyOffset(Long value) {
        this.mCurrencyOffset = value;
        return this;
    }

    public Double getFieldUsdExchange() {
        return this.mUsdExchange;
    }

    public Currency setFieldUsdExchange(Double value) {
        this.mUsdExchange = value;
        return this;
    }

    public Double getFieldUsdExchangeInverse() {
        return this.mUsdExchangeInverse;
    }

    public Currency setFieldUsdExchangeInverse(Double value) {
        this.mUsdExchangeInverse = value;
        return this;
    }

    public String getFieldUserCurrency() {
        return this.mUserCurrency;
    }

    public Currency setFieldUserCurrency(String value) {
        this.mUserCurrency = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Currency setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Currency copyFrom(Currency instance) {
        this.mCurrencyOffset = instance.mCurrencyOffset;
        this.mUsdExchange = instance.mUsdExchange;
        this.mUsdExchangeInverse = instance.mUsdExchangeInverse;
        this.mUserCurrency = instance.mUserCurrency;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Currency> getParser() {
        return new APIRequest.ResponseParser<Currency>(){

            @Override
            public APINodeList<Currency> parseResponse(String response, APIContext context, APIRequest<Currency> request, String header) throws APIException.MalformedResponseException {
                return Currency.parseResponse(response, context, request, header);
            }
        };
    }
}

