/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.AdSet;
import com.facebook.ads.sdk.AudiencePermissionForActions;
import com.facebook.ads.sdk.Targeting;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SavedAudience
extends APINode {
    @SerializedName(value="account")
    private AdAccount mAccount = null;
    @SerializedName(value="approximate_count")
    private Long mApproximateCount = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="expiry_time")
    private String mExpiryTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="permission_for_actions")
    private AudiencePermissionForActions mPermissionForActions = null;
    @SerializedName(value="run_status")
    private String mRunStatus = null;
    @SerializedName(value="sentence_lines")
    private JsonArray mSentenceLines = null;
    @SerializedName(value="targeting")
    private Targeting mTargeting = null;
    @SerializedName(value="time_created")
    private String mTimeCreated = null;
    @SerializedName(value="time_updated")
    private String mTimeUpdated = null;
    protected static Gson gson = null;

    SavedAudience() {
    }

    public SavedAudience(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public SavedAudience(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public SavedAudience fetch() throws APIException {
        SavedAudience newInstance = SavedAudience.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static SavedAudience fetchById(Long id, APIContext context) throws APIException {
        return SavedAudience.fetchById(id.toString(), context);
    }

    public static ListenableFuture<SavedAudience> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return SavedAudience.fetchByIdAsync(id.toString(), context);
    }

    public static SavedAudience fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<SavedAudience> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<SavedAudience> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<SavedAudience>(context, "", "/", "GET", SavedAudience.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<SavedAudience>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<SavedAudience>(context, "", "/", "GET", SavedAudience.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static SavedAudience loadJSON(String json, APIContext context, String header) {
        SavedAudience savedAudience = (SavedAudience)SavedAudience.getGson().fromJson(json, SavedAudience.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(savedAudience.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        savedAudience.context = context;
        savedAudience.rawValue = json;
        savedAudience.header = header;
        return savedAudience;
    }

    public static APINodeList<SavedAudience> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<SavedAudience> savedAudiences = new APINodeList<SavedAudience>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        savedAudiences.add(SavedAudience.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return savedAudiences;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            savedAudiences.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        savedAudiences.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            savedAudiences.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            savedAudiences.add(SavedAudience.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                savedAudiences.add(SavedAudience.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            savedAudiences.add(SavedAudience.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return savedAudiences;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        savedAudiences.add(SavedAudience.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return savedAudiences;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        savedAudiences.add(SavedAudience.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return savedAudiences;
                }
                savedAudiences.clear();
                savedAudiences.add(SavedAudience.loadJSON(json, context, header));
                return savedAudiences;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return SavedAudience.getGson().toJson((Object)this);
    }

    public APIRequestGetAdSets getAdSets() {
        return new APIRequestGetAdSets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public AdAccount getFieldAccount() {
        if (this.mAccount != null) {
            this.mAccount.context = this.getContext();
        }
        return this.mAccount;
    }

    public Long getFieldApproximateCount() {
        return this.mApproximateCount;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldExpiryTime() {
        return this.mExpiryTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public AudiencePermissionForActions getFieldPermissionForActions() {
        return this.mPermissionForActions;
    }

    public String getFieldRunStatus() {
        return this.mRunStatus;
    }

    public JsonArray getFieldSentenceLines() {
        return this.mSentenceLines;
    }

    public Targeting getFieldTargeting() {
        return this.mTargeting;
    }

    public String getFieldTimeCreated() {
        return this.mTimeCreated;
    }

    public String getFieldTimeUpdated() {
        return this.mTimeUpdated;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public SavedAudience copyFrom(SavedAudience instance) {
        this.mAccount = instance.mAccount;
        this.mApproximateCount = instance.mApproximateCount;
        this.mDescription = instance.mDescription;
        this.mExpiryTime = instance.mExpiryTime;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mPermissionForActions = instance.mPermissionForActions;
        this.mRunStatus = instance.mRunStatus;
        this.mSentenceLines = instance.mSentenceLines;
        this.mTargeting = instance.mTargeting;
        this.mTimeCreated = instance.mTimeCreated;
        this.mTimeUpdated = instance.mTimeUpdated;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<SavedAudience> getParser() {
        return new APIRequest.ResponseParser<SavedAudience>(){

            @Override
            public APINodeList<SavedAudience> parseResponse(String response, APIContext context, APIRequest<SavedAudience> request, String header) throws APIException.MalformedResponseException {
                return SavedAudience.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<SavedAudience> {
        SavedAudience lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account", "approximate_count", "description", "expiry_time", "id", "name", "permission_for_actions", "run_status", "sentence_lines", "targeting", "time_created", "time_updated"};

        @Override
        public SavedAudience getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public SavedAudience parseResponse(String response, String header) throws APIException {
            return SavedAudience.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public SavedAudience execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public SavedAudience execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<SavedAudience> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<SavedAudience> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, SavedAudience>(){

                public SavedAudience apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountField() {
            return this.requestAccountField(true);
        }

        public APIRequestGet requestAccountField(boolean value) {
            this.requestField("account", value);
            return this;
        }

        public APIRequestGet requestApproximateCountField() {
            return this.requestApproximateCountField(true);
        }

        public APIRequestGet requestApproximateCountField(boolean value) {
            this.requestField("approximate_count", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestExpiryTimeField() {
            return this.requestExpiryTimeField(true);
        }

        public APIRequestGet requestExpiryTimeField(boolean value) {
            this.requestField("expiry_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPermissionForActionsField() {
            return this.requestPermissionForActionsField(true);
        }

        public APIRequestGet requestPermissionForActionsField(boolean value) {
            this.requestField("permission_for_actions", value);
            return this;
        }

        public APIRequestGet requestRunStatusField() {
            return this.requestRunStatusField(true);
        }

        public APIRequestGet requestRunStatusField(boolean value) {
            this.requestField("run_status", value);
            return this;
        }

        public APIRequestGet requestSentenceLinesField() {
            return this.requestSentenceLinesField(true);
        }

        public APIRequestGet requestSentenceLinesField(boolean value) {
            this.requestField("sentence_lines", value);
            return this;
        }

        public APIRequestGet requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGet requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGet requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGet requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGet requestTimeUpdatedField() {
            return this.requestTimeUpdatedField(true);
        }

        public APIRequestGet requestTimeUpdatedField(boolean value) {
            this.requestField("time_updated", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdSets
    extends APIRequest<AdSet> {
        APINodeList<AdSet> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "ad_keywords", "adlabels", "adset_schedule", "asset_feed_id", "attribution_spec", "best_creative", "bid_adjustments", "bid_amount", "bid_constraints", "bid_info", "bid_strategy", "billing_event", "budget_remaining", "campaign", "campaign_id", "configured_status", "created_time", "creative_sequence", "daily_budget", "daily_min_spend_target", "daily_spend_cap", "destination_type", "effective_status", "end_time", "frequency_control_specs", "full_funnel_exploration_mode", "id", "instagram_actor_id", "is_dynamic_creative", "issues_info", "lifetime_budget", "lifetime_imps", "lifetime_min_spend_target", "lifetime_spend_cap", "name", "optimization_goal", "pacing_type", "promoted_object", "recommendations", "recurring_budget_semantics", "review_feedback", "rf_prediction_id", "source_adset", "source_adset_id", "start_time", "status", "targeting", "time_based_ad_rotation_id_blocks", "time_based_ad_rotation_intervals", "updated_time", "use_new_app_click"};

        @Override
        public APINodeList<AdSet> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdSet> parseResponse(String response, String header) throws APIException {
            return AdSet.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdSet> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdSet> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdSet>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdSet>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdSet>>(){

                public APINodeList<AdSet> apply(String result) {
                    try {
                        return APIRequestGetAdSets.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdSets(String nodeId, APIContext context) {
            super(context, nodeId, "/adsets", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdSets setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdSets setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdSets requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdSets requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdSets requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdSets requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdSets requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdSets requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdSets requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAdSets requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAdSets requestAdKeywordsField() {
            return this.requestAdKeywordsField(true);
        }

        public APIRequestGetAdSets requestAdKeywordsField(boolean value) {
            this.requestField("ad_keywords", value);
            return this;
        }

        public APIRequestGetAdSets requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGetAdSets requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGetAdSets requestAdsetScheduleField() {
            return this.requestAdsetScheduleField(true);
        }

        public APIRequestGetAdSets requestAdsetScheduleField(boolean value) {
            this.requestField("adset_schedule", value);
            return this;
        }

        public APIRequestGetAdSets requestAssetFeedIdField() {
            return this.requestAssetFeedIdField(true);
        }

        public APIRequestGetAdSets requestAssetFeedIdField(boolean value) {
            this.requestField("asset_feed_id", value);
            return this;
        }

        public APIRequestGetAdSets requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetAdSets requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetAdSets requestBestCreativeField() {
            return this.requestBestCreativeField(true);
        }

        public APIRequestGetAdSets requestBestCreativeField(boolean value) {
            this.requestField("best_creative", value);
            return this;
        }

        public APIRequestGetAdSets requestBidAdjustmentsField() {
            return this.requestBidAdjustmentsField(true);
        }

        public APIRequestGetAdSets requestBidAdjustmentsField(boolean value) {
            this.requestField("bid_adjustments", value);
            return this;
        }

        public APIRequestGetAdSets requestBidAmountField() {
            return this.requestBidAmountField(true);
        }

        public APIRequestGetAdSets requestBidAmountField(boolean value) {
            this.requestField("bid_amount", value);
            return this;
        }

        public APIRequestGetAdSets requestBidConstraintsField() {
            return this.requestBidConstraintsField(true);
        }

        public APIRequestGetAdSets requestBidConstraintsField(boolean value) {
            this.requestField("bid_constraints", value);
            return this;
        }

        public APIRequestGetAdSets requestBidInfoField() {
            return this.requestBidInfoField(true);
        }

        public APIRequestGetAdSets requestBidInfoField(boolean value) {
            this.requestField("bid_info", value);
            return this;
        }

        public APIRequestGetAdSets requestBidStrategyField() {
            return this.requestBidStrategyField(true);
        }

        public APIRequestGetAdSets requestBidStrategyField(boolean value) {
            this.requestField("bid_strategy", value);
            return this;
        }

        public APIRequestGetAdSets requestBillingEventField() {
            return this.requestBillingEventField(true);
        }

        public APIRequestGetAdSets requestBillingEventField(boolean value) {
            this.requestField("billing_event", value);
            return this;
        }

        public APIRequestGetAdSets requestBudgetRemainingField() {
            return this.requestBudgetRemainingField(true);
        }

        public APIRequestGetAdSets requestBudgetRemainingField(boolean value) {
            this.requestField("budget_remaining", value);
            return this;
        }

        public APIRequestGetAdSets requestCampaignField() {
            return this.requestCampaignField(true);
        }

        public APIRequestGetAdSets requestCampaignField(boolean value) {
            this.requestField("campaign", value);
            return this;
        }

        public APIRequestGetAdSets requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGetAdSets requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGetAdSets requestConfiguredStatusField() {
            return this.requestConfiguredStatusField(true);
        }

        public APIRequestGetAdSets requestConfiguredStatusField(boolean value) {
            this.requestField("configured_status", value);
            return this;
        }

        public APIRequestGetAdSets requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAdSets requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAdSets requestCreativeSequenceField() {
            return this.requestCreativeSequenceField(true);
        }

        public APIRequestGetAdSets requestCreativeSequenceField(boolean value) {
            this.requestField("creative_sequence", value);
            return this;
        }

        public APIRequestGetAdSets requestDailyBudgetField() {
            return this.requestDailyBudgetField(true);
        }

        public APIRequestGetAdSets requestDailyBudgetField(boolean value) {
            this.requestField("daily_budget", value);
            return this;
        }

        public APIRequestGetAdSets requestDailyMinSpendTargetField() {
            return this.requestDailyMinSpendTargetField(true);
        }

        public APIRequestGetAdSets requestDailyMinSpendTargetField(boolean value) {
            this.requestField("daily_min_spend_target", value);
            return this;
        }

        public APIRequestGetAdSets requestDailySpendCapField() {
            return this.requestDailySpendCapField(true);
        }

        public APIRequestGetAdSets requestDailySpendCapField(boolean value) {
            this.requestField("daily_spend_cap", value);
            return this;
        }

        public APIRequestGetAdSets requestDestinationTypeField() {
            return this.requestDestinationTypeField(true);
        }

        public APIRequestGetAdSets requestDestinationTypeField(boolean value) {
            this.requestField("destination_type", value);
            return this;
        }

        public APIRequestGetAdSets requestEffectiveStatusField() {
            return this.requestEffectiveStatusField(true);
        }

        public APIRequestGetAdSets requestEffectiveStatusField(boolean value) {
            this.requestField("effective_status", value);
            return this;
        }

        public APIRequestGetAdSets requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGetAdSets requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGetAdSets requestFrequencyControlSpecsField() {
            return this.requestFrequencyControlSpecsField(true);
        }

        public APIRequestGetAdSets requestFrequencyControlSpecsField(boolean value) {
            this.requestField("frequency_control_specs", value);
            return this;
        }

        public APIRequestGetAdSets requestFullFunnelExplorationModeField() {
            return this.requestFullFunnelExplorationModeField(true);
        }

        public APIRequestGetAdSets requestFullFunnelExplorationModeField(boolean value) {
            this.requestField("full_funnel_exploration_mode", value);
            return this;
        }

        public APIRequestGetAdSets requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdSets requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdSets requestInstagramActorIdField() {
            return this.requestInstagramActorIdField(true);
        }

        public APIRequestGetAdSets requestInstagramActorIdField(boolean value) {
            this.requestField("instagram_actor_id", value);
            return this;
        }

        public APIRequestGetAdSets requestIsDynamicCreativeField() {
            return this.requestIsDynamicCreativeField(true);
        }

        public APIRequestGetAdSets requestIsDynamicCreativeField(boolean value) {
            this.requestField("is_dynamic_creative", value);
            return this;
        }

        public APIRequestGetAdSets requestIssuesInfoField() {
            return this.requestIssuesInfoField(true);
        }

        public APIRequestGetAdSets requestIssuesInfoField(boolean value) {
            this.requestField("issues_info", value);
            return this;
        }

        public APIRequestGetAdSets requestLifetimeBudgetField() {
            return this.requestLifetimeBudgetField(true);
        }

        public APIRequestGetAdSets requestLifetimeBudgetField(boolean value) {
            this.requestField("lifetime_budget", value);
            return this;
        }

        public APIRequestGetAdSets requestLifetimeImpsField() {
            return this.requestLifetimeImpsField(true);
        }

        public APIRequestGetAdSets requestLifetimeImpsField(boolean value) {
            this.requestField("lifetime_imps", value);
            return this;
        }

        public APIRequestGetAdSets requestLifetimeMinSpendTargetField() {
            return this.requestLifetimeMinSpendTargetField(true);
        }

        public APIRequestGetAdSets requestLifetimeMinSpendTargetField(boolean value) {
            this.requestField("lifetime_min_spend_target", value);
            return this;
        }

        public APIRequestGetAdSets requestLifetimeSpendCapField() {
            return this.requestLifetimeSpendCapField(true);
        }

        public APIRequestGetAdSets requestLifetimeSpendCapField(boolean value) {
            this.requestField("lifetime_spend_cap", value);
            return this;
        }

        public APIRequestGetAdSets requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdSets requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdSets requestOptimizationGoalField() {
            return this.requestOptimizationGoalField(true);
        }

        public APIRequestGetAdSets requestOptimizationGoalField(boolean value) {
            this.requestField("optimization_goal", value);
            return this;
        }

        public APIRequestGetAdSets requestPacingTypeField() {
            return this.requestPacingTypeField(true);
        }

        public APIRequestGetAdSets requestPacingTypeField(boolean value) {
            this.requestField("pacing_type", value);
            return this;
        }

        public APIRequestGetAdSets requestPromotedObjectField() {
            return this.requestPromotedObjectField(true);
        }

        public APIRequestGetAdSets requestPromotedObjectField(boolean value) {
            this.requestField("promoted_object", value);
            return this;
        }

        public APIRequestGetAdSets requestRecommendationsField() {
            return this.requestRecommendationsField(true);
        }

        public APIRequestGetAdSets requestRecommendationsField(boolean value) {
            this.requestField("recommendations", value);
            return this;
        }

        public APIRequestGetAdSets requestRecurringBudgetSemanticsField() {
            return this.requestRecurringBudgetSemanticsField(true);
        }

        public APIRequestGetAdSets requestRecurringBudgetSemanticsField(boolean value) {
            this.requestField("recurring_budget_semantics", value);
            return this;
        }

        public APIRequestGetAdSets requestReviewFeedbackField() {
            return this.requestReviewFeedbackField(true);
        }

        public APIRequestGetAdSets requestReviewFeedbackField(boolean value) {
            this.requestField("review_feedback", value);
            return this;
        }

        public APIRequestGetAdSets requestRfPredictionIdField() {
            return this.requestRfPredictionIdField(true);
        }

        public APIRequestGetAdSets requestRfPredictionIdField(boolean value) {
            this.requestField("rf_prediction_id", value);
            return this;
        }

        public APIRequestGetAdSets requestSourceAdsetField() {
            return this.requestSourceAdsetField(true);
        }

        public APIRequestGetAdSets requestSourceAdsetField(boolean value) {
            this.requestField("source_adset", value);
            return this;
        }

        public APIRequestGetAdSets requestSourceAdsetIdField() {
            return this.requestSourceAdsetIdField(true);
        }

        public APIRequestGetAdSets requestSourceAdsetIdField(boolean value) {
            this.requestField("source_adset_id", value);
            return this;
        }

        public APIRequestGetAdSets requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetAdSets requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetAdSets requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetAdSets requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetAdSets requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGetAdSets requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGetAdSets requestTimeBasedAdRotationIdBlocksField() {
            return this.requestTimeBasedAdRotationIdBlocksField(true);
        }

        public APIRequestGetAdSets requestTimeBasedAdRotationIdBlocksField(boolean value) {
            this.requestField("time_based_ad_rotation_id_blocks", value);
            return this;
        }

        public APIRequestGetAdSets requestTimeBasedAdRotationIntervalsField() {
            return this.requestTimeBasedAdRotationIntervalsField(true);
        }

        public APIRequestGetAdSets requestTimeBasedAdRotationIntervalsField(boolean value) {
            this.requestField("time_based_ad_rotation_intervals", value);
            return this;
        }

        public APIRequestGetAdSets requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAdSets requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetAdSets requestUseNewAppClickField() {
            return this.requestUseNewAppClickField(true);
        }

        public APIRequestGetAdSets requestUseNewAppClickField(boolean value) {
            this.requestField("use_new_app_click", value);
            return this;
        }
    }
}

