/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReachFrequencyEstimatesPlacementBreakdown
extends APINode {
    @SerializedName(value="android")
    private List<Double> mAndroid = null;
    @SerializedName(value="audience_network")
    private List<Double> mAudienceNetwork = null;
    @SerializedName(value="desktop")
    private List<Double> mDesktop = null;
    @SerializedName(value="ig_android")
    private List<Double> mIgAndroid = null;
    @SerializedName(value="ig_ios")
    private List<Double> mIgIos = null;
    @SerializedName(value="ig_other")
    private List<Double> mIgOther = null;
    @SerializedName(value="ig_story")
    private List<Double> mIgStory = null;
    @SerializedName(value="instant_articles")
    private List<Double> mInstantArticles = null;
    @SerializedName(value="instream_videos")
    private List<Double> mInstreamVideos = null;
    @SerializedName(value="ios")
    private List<Double> mIos = null;
    @SerializedName(value="msite")
    private List<Double> mMsite = null;
    @SerializedName(value="suggested_videos")
    private List<Double> mSuggestedVideos = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ReachFrequencyEstimatesPlacementBreakdown loadJSON(String json, APIContext context, String header) {
        ReachFrequencyEstimatesPlacementBreakdown reachFrequencyEstimatesPlacementBreakdown = (ReachFrequencyEstimatesPlacementBreakdown)ReachFrequencyEstimatesPlacementBreakdown.getGson().fromJson(json, ReachFrequencyEstimatesPlacementBreakdown.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(reachFrequencyEstimatesPlacementBreakdown.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        reachFrequencyEstimatesPlacementBreakdown.context = context;
        reachFrequencyEstimatesPlacementBreakdown.rawValue = json;
        reachFrequencyEstimatesPlacementBreakdown.header = header;
        return reachFrequencyEstimatesPlacementBreakdown;
    }

    public static APINodeList<ReachFrequencyEstimatesPlacementBreakdown> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ReachFrequencyEstimatesPlacementBreakdown> reachFrequencyEstimatesPlacementBreakdowns = new APINodeList<ReachFrequencyEstimatesPlacementBreakdown>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        reachFrequencyEstimatesPlacementBreakdowns.add(ReachFrequencyEstimatesPlacementBreakdown.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return reachFrequencyEstimatesPlacementBreakdowns;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            reachFrequencyEstimatesPlacementBreakdowns.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        reachFrequencyEstimatesPlacementBreakdowns.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            reachFrequencyEstimatesPlacementBreakdowns.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            reachFrequencyEstimatesPlacementBreakdowns.add(ReachFrequencyEstimatesPlacementBreakdown.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                reachFrequencyEstimatesPlacementBreakdowns.add(ReachFrequencyEstimatesPlacementBreakdown.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            reachFrequencyEstimatesPlacementBreakdowns.add(ReachFrequencyEstimatesPlacementBreakdown.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return reachFrequencyEstimatesPlacementBreakdowns;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        reachFrequencyEstimatesPlacementBreakdowns.add(ReachFrequencyEstimatesPlacementBreakdown.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return reachFrequencyEstimatesPlacementBreakdowns;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        reachFrequencyEstimatesPlacementBreakdowns.add(ReachFrequencyEstimatesPlacementBreakdown.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return reachFrequencyEstimatesPlacementBreakdowns;
                }
                reachFrequencyEstimatesPlacementBreakdowns.clear();
                reachFrequencyEstimatesPlacementBreakdowns.add(ReachFrequencyEstimatesPlacementBreakdown.loadJSON(json, context, header));
                return reachFrequencyEstimatesPlacementBreakdowns;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ReachFrequencyEstimatesPlacementBreakdown.getGson().toJson((Object)this);
    }

    public List<Double> getFieldAndroid() {
        return this.mAndroid;
    }

    public ReachFrequencyEstimatesPlacementBreakdown setFieldAndroid(List<Double> value) {
        this.mAndroid = value;
        return this;
    }

    public List<Double> getFieldAudienceNetwork() {
        return this.mAudienceNetwork;
    }

    public ReachFrequencyEstimatesPlacementBreakdown setFieldAudienceNetwork(List<Double> value) {
        this.mAudienceNetwork = value;
        return this;
    }

    public List<Double> getFieldDesktop() {
        return this.mDesktop;
    }

    public ReachFrequencyEstimatesPlacementBreakdown setFieldDesktop(List<Double> value) {
        this.mDesktop = value;
        return this;
    }

    public List<Double> getFieldIgAndroid() {
        return this.mIgAndroid;
    }

    public ReachFrequencyEstimatesPlacementBreakdown setFieldIgAndroid(List<Double> value) {
        this.mIgAndroid = value;
        return this;
    }

    public List<Double> getFieldIgIos() {
        return this.mIgIos;
    }

    public ReachFrequencyEstimatesPlacementBreakdown setFieldIgIos(List<Double> value) {
        this.mIgIos = value;
        return this;
    }

    public List<Double> getFieldIgOther() {
        return this.mIgOther;
    }

    public ReachFrequencyEstimatesPlacementBreakdown setFieldIgOther(List<Double> value) {
        this.mIgOther = value;
        return this;
    }

    public List<Double> getFieldIgStory() {
        return this.mIgStory;
    }

    public ReachFrequencyEstimatesPlacementBreakdown setFieldIgStory(List<Double> value) {
        this.mIgStory = value;
        return this;
    }

    public List<Double> getFieldInstantArticles() {
        return this.mInstantArticles;
    }

    public ReachFrequencyEstimatesPlacementBreakdown setFieldInstantArticles(List<Double> value) {
        this.mInstantArticles = value;
        return this;
    }

    public List<Double> getFieldInstreamVideos() {
        return this.mInstreamVideos;
    }

    public ReachFrequencyEstimatesPlacementBreakdown setFieldInstreamVideos(List<Double> value) {
        this.mInstreamVideos = value;
        return this;
    }

    public List<Double> getFieldIos() {
        return this.mIos;
    }

    public ReachFrequencyEstimatesPlacementBreakdown setFieldIos(List<Double> value) {
        this.mIos = value;
        return this;
    }

    public List<Double> getFieldMsite() {
        return this.mMsite;
    }

    public ReachFrequencyEstimatesPlacementBreakdown setFieldMsite(List<Double> value) {
        this.mMsite = value;
        return this;
    }

    public List<Double> getFieldSuggestedVideos() {
        return this.mSuggestedVideos;
    }

    public ReachFrequencyEstimatesPlacementBreakdown setFieldSuggestedVideos(List<Double> value) {
        this.mSuggestedVideos = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public ReachFrequencyEstimatesPlacementBreakdown setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ReachFrequencyEstimatesPlacementBreakdown copyFrom(ReachFrequencyEstimatesPlacementBreakdown instance) {
        this.mAndroid = instance.mAndroid;
        this.mAudienceNetwork = instance.mAudienceNetwork;
        this.mDesktop = instance.mDesktop;
        this.mIgAndroid = instance.mIgAndroid;
        this.mIgIos = instance.mIgIos;
        this.mIgOther = instance.mIgOther;
        this.mIgStory = instance.mIgStory;
        this.mInstantArticles = instance.mInstantArticles;
        this.mInstreamVideos = instance.mInstreamVideos;
        this.mIos = instance.mIos;
        this.mMsite = instance.mMsite;
        this.mSuggestedVideos = instance.mSuggestedVideos;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ReachFrequencyEstimatesPlacementBreakdown> getParser() {
        return new APIRequest.ResponseParser<ReachFrequencyEstimatesPlacementBreakdown>(){

            @Override
            public APINodeList<ReachFrequencyEstimatesPlacementBreakdown> parseResponse(String response, APIContext context, APIRequest<ReachFrequencyEstimatesPlacementBreakdown> request, String header) throws APIException.MalformedResponseException {
                return ReachFrequencyEstimatesPlacementBreakdown.parseResponse(response, context, request, header);
            }
        };
    }
}

