/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.ProfilePictureSource;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profile
extends APINode {
    @SerializedName(value="can_post")
    private Boolean mCanPost = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="pic")
    private String mPic = null;
    @SerializedName(value="pic_crop")
    private ProfilePictureSource mPicCrop = null;
    @SerializedName(value="pic_large")
    private String mPicLarge = null;
    @SerializedName(value="pic_small")
    private String mPicSmall = null;
    @SerializedName(value="pic_square")
    private String mPicSquare = null;
    @SerializedName(value="profile_type")
    private EnumProfileType mProfileType = null;
    @SerializedName(value="username")
    private String mUsername = null;
    protected static Gson gson = null;

    Profile() {
    }

    public Profile(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Profile(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Profile fetch() throws APIException {
        Profile newInstance = Profile.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Profile fetchById(Long id, APIContext context) throws APIException {
        return Profile.fetchById(id.toString(), context);
    }

    public static ListenableFuture<Profile> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return Profile.fetchByIdAsync(id.toString(), context);
    }

    public static Profile fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<Profile> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<Profile> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Profile>(context, "", "/", "GET", Profile.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<Profile>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<Profile>(context, "", "/", "GET", Profile.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Profile loadJSON(String json, APIContext context, String header) {
        Profile profile = (Profile)Profile.getGson().fromJson(json, Profile.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(profile.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        profile.context = context;
        profile.rawValue = json;
        profile.header = header;
        return profile;
    }

    public static APINodeList<Profile> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Profile> profiles = new APINodeList<Profile>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        profiles.add(Profile.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return profiles;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            profiles.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        profiles.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            profiles.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            profiles.add(Profile.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                profiles.add(Profile.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            profiles.add(Profile.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return profiles;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        profiles.add(Profile.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return profiles;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        profiles.add(Profile.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return profiles;
                }
                profiles.clear();
                profiles.add(Profile.loadJSON(json, context, header));
                return profiles;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Profile.getGson().toJson((Object)this);
    }

    public APIRequestGetPicture getPicture() {
        return new APIRequestGetPicture(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Boolean getFieldCanPost() {
        return this.mCanPost;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldPic() {
        return this.mPic;
    }

    public ProfilePictureSource getFieldPicCrop() {
        return this.mPicCrop;
    }

    public String getFieldPicLarge() {
        return this.mPicLarge;
    }

    public String getFieldPicSmall() {
        return this.mPicSmall;
    }

    public String getFieldPicSquare() {
        return this.mPicSquare;
    }

    public EnumProfileType getFieldProfileType() {
        return this.mProfileType;
    }

    public String getFieldUsername() {
        return this.mUsername;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Profile copyFrom(Profile instance) {
        this.mCanPost = instance.mCanPost;
        this.mId = instance.mId;
        this.mLink = instance.mLink;
        this.mName = instance.mName;
        this.mPic = instance.mPic;
        this.mPicCrop = instance.mPicCrop;
        this.mPicLarge = instance.mPicLarge;
        this.mPicSmall = instance.mPicSmall;
        this.mPicSquare = instance.mPicSquare;
        this.mProfileType = instance.mProfileType;
        this.mUsername = instance.mUsername;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Profile> getParser() {
        return new APIRequest.ResponseParser<Profile>(){

            @Override
            public APINodeList<Profile> parseResponse(String response, APIContext context, APIRequest<Profile> request, String header) throws APIException.MalformedResponseException {
                return Profile.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_NONE("NONE"),
        VALUE_LIKE("LIKE"),
        VALUE_LOVE("LOVE"),
        VALUE_WOW("WOW"),
        VALUE_HAHA("HAHA"),
        VALUE_SAD("SAD"),
        VALUE_ANGRY("ANGRY"),
        VALUE_THANKFUL("THANKFUL"),
        VALUE_PRIDE("PRIDE"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumProfileType {
        VALUE_USER("user"),
        VALUE_PAGE("page"),
        VALUE_EVENT("event"),
        VALUE_GROUP("group"),
        VALUE_APPLICATION("application"),
        NULL(null);

        private String value;

        private EnumProfileType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<Profile> {
        Profile lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"can_post", "id", "link", "name", "pic", "pic_crop", "pic_large", "pic_small", "pic_square", "profile_type", "username"};

        @Override
        public Profile getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Profile parseResponse(String response, String header) throws APIException {
            return Profile.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Profile execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Profile execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Profile> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Profile> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Profile>(){

                public Profile apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGet requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGet requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPicField() {
            return this.requestPicField(true);
        }

        public APIRequestGet requestPicField(boolean value) {
            this.requestField("pic", value);
            return this;
        }

        public APIRequestGet requestPicCropField() {
            return this.requestPicCropField(true);
        }

        public APIRequestGet requestPicCropField(boolean value) {
            this.requestField("pic_crop", value);
            return this;
        }

        public APIRequestGet requestPicLargeField() {
            return this.requestPicLargeField(true);
        }

        public APIRequestGet requestPicLargeField(boolean value) {
            this.requestField("pic_large", value);
            return this;
        }

        public APIRequestGet requestPicSmallField() {
            return this.requestPicSmallField(true);
        }

        public APIRequestGet requestPicSmallField(boolean value) {
            this.requestField("pic_small", value);
            return this;
        }

        public APIRequestGet requestPicSquareField() {
            return this.requestPicSquareField(true);
        }

        public APIRequestGet requestPicSquareField(boolean value) {
            this.requestField("pic_square", value);
            return this;
        }

        public APIRequestGet requestProfileTypeField() {
            return this.requestProfileTypeField(true);
        }

        public APIRequestGet requestProfileTypeField(boolean value) {
            this.requestField("profile_type", value);
            return this;
        }

        public APIRequestGet requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGet requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPicture
    extends APIRequest<ProfilePictureSource> {
        APINodeList<ProfilePictureSource> lastResponse = null;
        public static final String[] PARAMS = new String[]{"height", "width", "type", "redirect"};
        public static final String[] FIELDS = new String[]{"bottom", "cache_key", "height", "is_silhouette", "left", "right", "top", "url", "width", "id"};

        @Override
        public APINodeList<ProfilePictureSource> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ProfilePictureSource> parseResponse(String response, String header) throws APIException {
            return ProfilePictureSource.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<ProfilePictureSource> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ProfilePictureSource> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ProfilePictureSource>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ProfilePictureSource>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<ProfilePictureSource>>(){

                public APINodeList<ProfilePictureSource> apply(String result) {
                    try {
                        return APIRequestGetPicture.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPicture(String nodeId, APIContext context) {
            super(context, nodeId, "/picture", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPicture setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPicture setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPicture setHeight(Long height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestGetPicture setHeight(String height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestGetPicture setWidth(Long width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestGetPicture setWidth(String width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestGetPicture setType(ProfilePictureSource.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetPicture setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetPicture setRedirect(Boolean redirect) {
            this.setParam("redirect", redirect);
            return this;
        }

        public APIRequestGetPicture setRedirect(String redirect) {
            this.setParam("redirect", redirect);
            return this;
        }

        public APIRequestGetPicture requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPicture requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPicture requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPicture requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPicture requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPicture requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPicture requestBottomField() {
            return this.requestBottomField(true);
        }

        public APIRequestGetPicture requestBottomField(boolean value) {
            this.requestField("bottom", value);
            return this;
        }

        public APIRequestGetPicture requestCacheKeyField() {
            return this.requestCacheKeyField(true);
        }

        public APIRequestGetPicture requestCacheKeyField(boolean value) {
            this.requestField("cache_key", value);
            return this;
        }

        public APIRequestGetPicture requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGetPicture requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGetPicture requestIsSilhouetteField() {
            return this.requestIsSilhouetteField(true);
        }

        public APIRequestGetPicture requestIsSilhouetteField(boolean value) {
            this.requestField("is_silhouette", value);
            return this;
        }

        public APIRequestGetPicture requestLeftField() {
            return this.requestLeftField(true);
        }

        public APIRequestGetPicture requestLeftField(boolean value) {
            this.requestField("left", value);
            return this;
        }

        public APIRequestGetPicture requestRightField() {
            return this.requestRightField(true);
        }

        public APIRequestGetPicture requestRightField(boolean value) {
            this.requestField("right", value);
            return this;
        }

        public APIRequestGetPicture requestTopField() {
            return this.requestTopField(true);
        }

        public APIRequestGetPicture requestTopField(boolean value) {
            this.requestField("top", value);
            return this;
        }

        public APIRequestGetPicture requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGetPicture requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGetPicture requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGetPicture requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }

        public APIRequestGetPicture requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPicture requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

