/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductItemInsights
extends APINode {
    @SerializedName(value="ad_click_count")
    private Long mAdClickCount = null;
    @SerializedName(value="ad_impression_count")
    private Long mAdImpressionCount = null;
    @SerializedName(value="add_to_cart_count")
    private Long mAddToCartCount = null;
    @SerializedName(value="purchase_count")
    private Long mPurchaseCount = null;
    @SerializedName(value="view_content_count")
    private Long mViewContentCount = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProductItemInsights loadJSON(String json, APIContext context, String header) {
        ProductItemInsights productItemInsights = (ProductItemInsights)ProductItemInsights.getGson().fromJson(json, ProductItemInsights.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productItemInsights.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productItemInsights.context = context;
        productItemInsights.rawValue = json;
        productItemInsights.header = header;
        return productItemInsights;
    }

    public static APINodeList<ProductItemInsights> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductItemInsights> productItemInsightss = new APINodeList<ProductItemInsights>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productItemInsightss.add(ProductItemInsights.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return productItemInsightss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productItemInsightss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productItemInsightss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productItemInsightss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productItemInsightss.add(ProductItemInsights.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productItemInsightss.add(ProductItemInsights.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productItemInsightss.add(ProductItemInsights.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return productItemInsightss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productItemInsightss.add(ProductItemInsights.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return productItemInsightss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productItemInsightss.add(ProductItemInsights.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productItemInsightss;
                }
                productItemInsightss.clear();
                productItemInsightss.add(ProductItemInsights.loadJSON(json, context, header));
                return productItemInsightss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductItemInsights.getGson().toJson((Object)this);
    }

    public Long getFieldAdClickCount() {
        return this.mAdClickCount;
    }

    public ProductItemInsights setFieldAdClickCount(Long value) {
        this.mAdClickCount = value;
        return this;
    }

    public Long getFieldAdImpressionCount() {
        return this.mAdImpressionCount;
    }

    public ProductItemInsights setFieldAdImpressionCount(Long value) {
        this.mAdImpressionCount = value;
        return this;
    }

    public Long getFieldAddToCartCount() {
        return this.mAddToCartCount;
    }

    public ProductItemInsights setFieldAddToCartCount(Long value) {
        this.mAddToCartCount = value;
        return this;
    }

    public Long getFieldPurchaseCount() {
        return this.mPurchaseCount;
    }

    public ProductItemInsights setFieldPurchaseCount(Long value) {
        this.mPurchaseCount = value;
        return this;
    }

    public Long getFieldViewContentCount() {
        return this.mViewContentCount;
    }

    public ProductItemInsights setFieldViewContentCount(Long value) {
        this.mViewContentCount = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public ProductItemInsights setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductItemInsights copyFrom(ProductItemInsights instance) {
        this.mAdClickCount = instance.mAdClickCount;
        this.mAdImpressionCount = instance.mAdImpressionCount;
        this.mAddToCartCount = instance.mAddToCartCount;
        this.mPurchaseCount = instance.mPurchaseCount;
        this.mViewContentCount = instance.mViewContentCount;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductItemInsights> getParser() {
        return new APIRequest.ResponseParser<ProductItemInsights>(){

            @Override
            public APINodeList<ProductItemInsights> parseResponse(String response, APIContext context, APIRequest<ProductItemInsights> request, String header) throws APIException.MalformedResponseException {
                return ProductItemInsights.parseResponse(response, context, request, header);
            }
        };
    }
}

