/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessengerDestinationPageWelcomeMessage
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="page_welcome_message_body")
    private String mPageWelcomeMessageBody = null;
    @SerializedName(value="page_welcome_message_type")
    private String mPageWelcomeMessageType = null;
    @SerializedName(value="template_name")
    private String mTemplateName = null;
    @SerializedName(value="time_created")
    private String mTimeCreated = null;
    @SerializedName(value="time_last_used")
    private String mTimeLastUsed = null;
    protected static Gson gson = null;

    MessengerDestinationPageWelcomeMessage() {
    }

    public MessengerDestinationPageWelcomeMessage(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public MessengerDestinationPageWelcomeMessage(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public MessengerDestinationPageWelcomeMessage fetch() throws APIException {
        MessengerDestinationPageWelcomeMessage newInstance = MessengerDestinationPageWelcomeMessage.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static MessengerDestinationPageWelcomeMessage fetchById(Long id, APIContext context) throws APIException {
        return MessengerDestinationPageWelcomeMessage.fetchById(id.toString(), context);
    }

    public static ListenableFuture<MessengerDestinationPageWelcomeMessage> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return MessengerDestinationPageWelcomeMessage.fetchByIdAsync(id.toString(), context);
    }

    public static MessengerDestinationPageWelcomeMessage fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<MessengerDestinationPageWelcomeMessage> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<MessengerDestinationPageWelcomeMessage> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<MessengerDestinationPageWelcomeMessage>(context, "", "/", "GET", MessengerDestinationPageWelcomeMessage.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<MessengerDestinationPageWelcomeMessage>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<MessengerDestinationPageWelcomeMessage>(context, "", "/", "GET", MessengerDestinationPageWelcomeMessage.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static MessengerDestinationPageWelcomeMessage loadJSON(String json, APIContext context, String header) {
        MessengerDestinationPageWelcomeMessage messengerDestinationPageWelcomeMessage = (MessengerDestinationPageWelcomeMessage)MessengerDestinationPageWelcomeMessage.getGson().fromJson(json, MessengerDestinationPageWelcomeMessage.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(messengerDestinationPageWelcomeMessage.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        messengerDestinationPageWelcomeMessage.context = context;
        messengerDestinationPageWelcomeMessage.rawValue = json;
        messengerDestinationPageWelcomeMessage.header = header;
        return messengerDestinationPageWelcomeMessage;
    }

    public static APINodeList<MessengerDestinationPageWelcomeMessage> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<MessengerDestinationPageWelcomeMessage> messengerDestinationPageWelcomeMessages = new APINodeList<MessengerDestinationPageWelcomeMessage>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        messengerDestinationPageWelcomeMessages.add(MessengerDestinationPageWelcomeMessage.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return messengerDestinationPageWelcomeMessages;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            messengerDestinationPageWelcomeMessages.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        messengerDestinationPageWelcomeMessages.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            messengerDestinationPageWelcomeMessages.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            messengerDestinationPageWelcomeMessages.add(MessengerDestinationPageWelcomeMessage.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                messengerDestinationPageWelcomeMessages.add(MessengerDestinationPageWelcomeMessage.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            messengerDestinationPageWelcomeMessages.add(MessengerDestinationPageWelcomeMessage.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return messengerDestinationPageWelcomeMessages;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        messengerDestinationPageWelcomeMessages.add(MessengerDestinationPageWelcomeMessage.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return messengerDestinationPageWelcomeMessages;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        messengerDestinationPageWelcomeMessages.add(MessengerDestinationPageWelcomeMessage.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return messengerDestinationPageWelcomeMessages;
                }
                messengerDestinationPageWelcomeMessages.clear();
                messengerDestinationPageWelcomeMessages.add(MessengerDestinationPageWelcomeMessage.loadJSON(json, context, header));
                return messengerDestinationPageWelcomeMessages;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MessengerDestinationPageWelcomeMessage.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldPageWelcomeMessageBody() {
        return this.mPageWelcomeMessageBody;
    }

    public String getFieldPageWelcomeMessageType() {
        return this.mPageWelcomeMessageType;
    }

    public String getFieldTemplateName() {
        return this.mTemplateName;
    }

    public String getFieldTimeCreated() {
        return this.mTimeCreated;
    }

    public String getFieldTimeLastUsed() {
        return this.mTimeLastUsed;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MessengerDestinationPageWelcomeMessage copyFrom(MessengerDestinationPageWelcomeMessage instance) {
        this.mId = instance.mId;
        this.mPageWelcomeMessageBody = instance.mPageWelcomeMessageBody;
        this.mPageWelcomeMessageType = instance.mPageWelcomeMessageType;
        this.mTemplateName = instance.mTemplateName;
        this.mTimeCreated = instance.mTimeCreated;
        this.mTimeLastUsed = instance.mTimeLastUsed;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MessengerDestinationPageWelcomeMessage> getParser() {
        return new APIRequest.ResponseParser<MessengerDestinationPageWelcomeMessage>(){

            @Override
            public APINodeList<MessengerDestinationPageWelcomeMessage> parseResponse(String response, APIContext context, APIRequest<MessengerDestinationPageWelcomeMessage> request, String header) throws APIException.MalformedResponseException {
                return MessengerDestinationPageWelcomeMessage.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<MessengerDestinationPageWelcomeMessage> {
        MessengerDestinationPageWelcomeMessage lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "page_welcome_message_body", "page_welcome_message_type", "template_name", "time_created", "time_last_used"};

        @Override
        public MessengerDestinationPageWelcomeMessage getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public MessengerDestinationPageWelcomeMessage parseResponse(String response, String header) throws APIException {
            return MessengerDestinationPageWelcomeMessage.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public MessengerDestinationPageWelcomeMessage execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public MessengerDestinationPageWelcomeMessage execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<MessengerDestinationPageWelcomeMessage> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<MessengerDestinationPageWelcomeMessage> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, MessengerDestinationPageWelcomeMessage>(){

                public MessengerDestinationPageWelcomeMessage apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestPageWelcomeMessageBodyField() {
            return this.requestPageWelcomeMessageBodyField(true);
        }

        public APIRequestGet requestPageWelcomeMessageBodyField(boolean value) {
            this.requestField("page_welcome_message_body", value);
            return this;
        }

        public APIRequestGet requestPageWelcomeMessageTypeField() {
            return this.requestPageWelcomeMessageTypeField(true);
        }

        public APIRequestGet requestPageWelcomeMessageTypeField(boolean value) {
            this.requestField("page_welcome_message_type", value);
            return this;
        }

        public APIRequestGet requestTemplateNameField() {
            return this.requestTemplateNameField(true);
        }

        public APIRequestGet requestTemplateNameField(boolean value) {
            this.requestField("template_name", value);
            return this;
        }

        public APIRequestGet requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGet requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGet requestTimeLastUsedField() {
            return this.requestTimeLastUsedField(true);
        }

        public APIRequestGet requestTimeLastUsedField(boolean value) {
            this.requestField("time_last_used", value);
            return this;
        }
    }
}

