/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Page;
import com.facebook.ads.sdk.ProductCatalog;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MerchantReport
extends APINode {
    @SerializedName(value="add_to_cart")
    private Long mAddToCart = null;
    @SerializedName(value="brand")
    private String mBrand = null;
    @SerializedName(value="catalog_segment")
    private ProductCatalog mCatalogSegment = null;
    @SerializedName(value="catalog_segment_id")
    private String mCatalogSegmentId = null;
    @SerializedName(value="catalog_segment_purchase_value")
    private Double mCatalogSegmentPurchaseValue = null;
    @SerializedName(value="category")
    private String mCategory = null;
    @SerializedName(value="date")
    private String mDate = null;
    @SerializedName(value="link_clicks")
    private Long mLinkClicks = null;
    @SerializedName(value="merchant_currency")
    private String mMerchantCurrency = null;
    @SerializedName(value="page")
    private Page mPage = null;
    @SerializedName(value="page_id")
    private String mPageId = null;
    @SerializedName(value="product_id")
    private String mProductId = null;
    @SerializedName(value="product_quantity")
    private Long mProductQuantity = null;
    @SerializedName(value="product_total_value")
    private Double mProductTotalValue = null;
    @SerializedName(value="purchase")
    private Long mPurchase = null;
    @SerializedName(value="purchase_value")
    private Double mPurchaseValue = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static MerchantReport loadJSON(String json, APIContext context, String header) {
        MerchantReport merchantReport = (MerchantReport)MerchantReport.getGson().fromJson(json, MerchantReport.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(merchantReport.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        merchantReport.context = context;
        merchantReport.rawValue = json;
        merchantReport.header = header;
        return merchantReport;
    }

    public static APINodeList<MerchantReport> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<MerchantReport> merchantReports = new APINodeList<MerchantReport>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        merchantReports.add(MerchantReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return merchantReports;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            merchantReports.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        merchantReports.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            merchantReports.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            merchantReports.add(MerchantReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                merchantReports.add(MerchantReport.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            merchantReports.add(MerchantReport.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return merchantReports;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        merchantReports.add(MerchantReport.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return merchantReports;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        merchantReports.add(MerchantReport.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return merchantReports;
                }
                merchantReports.clear();
                merchantReports.add(MerchantReport.loadJSON(json, context, header));
                return merchantReports;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MerchantReport.getGson().toJson((Object)this);
    }

    public Long getFieldAddToCart() {
        return this.mAddToCart;
    }

    public MerchantReport setFieldAddToCart(Long value) {
        this.mAddToCart = value;
        return this;
    }

    public String getFieldBrand() {
        return this.mBrand;
    }

    public MerchantReport setFieldBrand(String value) {
        this.mBrand = value;
        return this;
    }

    public ProductCatalog getFieldCatalogSegment() {
        if (this.mCatalogSegment != null) {
            this.mCatalogSegment.context = this.getContext();
        }
        return this.mCatalogSegment;
    }

    public MerchantReport setFieldCatalogSegment(ProductCatalog value) {
        this.mCatalogSegment = value;
        return this;
    }

    public MerchantReport setFieldCatalogSegment(String value) {
        Type type = new TypeToken<ProductCatalog>(){}.getType();
        this.mCatalogSegment = (ProductCatalog)ProductCatalog.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldCatalogSegmentId() {
        return this.mCatalogSegmentId;
    }

    public MerchantReport setFieldCatalogSegmentId(String value) {
        this.mCatalogSegmentId = value;
        return this;
    }

    public Double getFieldCatalogSegmentPurchaseValue() {
        return this.mCatalogSegmentPurchaseValue;
    }

    public MerchantReport setFieldCatalogSegmentPurchaseValue(Double value) {
        this.mCatalogSegmentPurchaseValue = value;
        return this;
    }

    public String getFieldCategory() {
        return this.mCategory;
    }

    public MerchantReport setFieldCategory(String value) {
        this.mCategory = value;
        return this;
    }

    public String getFieldDate() {
        return this.mDate;
    }

    public MerchantReport setFieldDate(String value) {
        this.mDate = value;
        return this;
    }

    public Long getFieldLinkClicks() {
        return this.mLinkClicks;
    }

    public MerchantReport setFieldLinkClicks(Long value) {
        this.mLinkClicks = value;
        return this;
    }

    public String getFieldMerchantCurrency() {
        return this.mMerchantCurrency;
    }

    public MerchantReport setFieldMerchantCurrency(String value) {
        this.mMerchantCurrency = value;
        return this;
    }

    public Page getFieldPage() {
        if (this.mPage != null) {
            this.mPage.context = this.getContext();
        }
        return this.mPage;
    }

    public MerchantReport setFieldPage(Page value) {
        this.mPage = value;
        return this;
    }

    public MerchantReport setFieldPage(String value) {
        Type type = new TypeToken<Page>(){}.getType();
        this.mPage = (Page)Page.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldPageId() {
        return this.mPageId;
    }

    public MerchantReport setFieldPageId(String value) {
        this.mPageId = value;
        return this;
    }

    public String getFieldProductId() {
        return this.mProductId;
    }

    public MerchantReport setFieldProductId(String value) {
        this.mProductId = value;
        return this;
    }

    public Long getFieldProductQuantity() {
        return this.mProductQuantity;
    }

    public MerchantReport setFieldProductQuantity(Long value) {
        this.mProductQuantity = value;
        return this;
    }

    public Double getFieldProductTotalValue() {
        return this.mProductTotalValue;
    }

    public MerchantReport setFieldProductTotalValue(Double value) {
        this.mProductTotalValue = value;
        return this;
    }

    public Long getFieldPurchase() {
        return this.mPurchase;
    }

    public MerchantReport setFieldPurchase(Long value) {
        this.mPurchase = value;
        return this;
    }

    public Double getFieldPurchaseValue() {
        return this.mPurchaseValue;
    }

    public MerchantReport setFieldPurchaseValue(Double value) {
        this.mPurchaseValue = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public MerchantReport setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MerchantReport copyFrom(MerchantReport instance) {
        this.mAddToCart = instance.mAddToCart;
        this.mBrand = instance.mBrand;
        this.mCatalogSegment = instance.mCatalogSegment;
        this.mCatalogSegmentId = instance.mCatalogSegmentId;
        this.mCatalogSegmentPurchaseValue = instance.mCatalogSegmentPurchaseValue;
        this.mCategory = instance.mCategory;
        this.mDate = instance.mDate;
        this.mLinkClicks = instance.mLinkClicks;
        this.mMerchantCurrency = instance.mMerchantCurrency;
        this.mPage = instance.mPage;
        this.mPageId = instance.mPageId;
        this.mProductId = instance.mProductId;
        this.mProductQuantity = instance.mProductQuantity;
        this.mProductTotalValue = instance.mProductTotalValue;
        this.mPurchase = instance.mPurchase;
        this.mPurchaseValue = instance.mPurchaseValue;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MerchantReport> getParser() {
        return new APIRequest.ResponseParser<MerchantReport>(){

            @Override
            public APINodeList<MerchantReport> parseResponse(String response, APIContext context, APIRequest<MerchantReport> request, String header) throws APIException.MalformedResponseException {
                return MerchantReport.parseResponse(response, context, request, header);
            }
        };
    }
}

