/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MerchantCompliance
extends APINode {
    @SerializedName(value="a2c_p_disc")
    private Double mA2cPDisc = null;
    @SerializedName(value="base_compliance_status")
    private Boolean mBaseComplianceStatus = null;
    @SerializedName(value="non_null_id")
    private Double mNonNullId = null;
    @SerializedName(value="non_null_quantity")
    private Double mNonNullQuantity = null;
    @SerializedName(value="vc_a2c_disc")
    private Double mVcA2cDisc = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static MerchantCompliance loadJSON(String json, APIContext context, String header) {
        MerchantCompliance merchantCompliance = (MerchantCompliance)MerchantCompliance.getGson().fromJson(json, MerchantCompliance.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(merchantCompliance.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        merchantCompliance.context = context;
        merchantCompliance.rawValue = json;
        merchantCompliance.header = header;
        return merchantCompliance;
    }

    public static APINodeList<MerchantCompliance> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<MerchantCompliance> merchantCompliances = new APINodeList<MerchantCompliance>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        merchantCompliances.add(MerchantCompliance.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return merchantCompliances;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            merchantCompliances.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        merchantCompliances.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            merchantCompliances.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            merchantCompliances.add(MerchantCompliance.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                merchantCompliances.add(MerchantCompliance.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            merchantCompliances.add(MerchantCompliance.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return merchantCompliances;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        merchantCompliances.add(MerchantCompliance.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return merchantCompliances;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        merchantCompliances.add(MerchantCompliance.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return merchantCompliances;
                }
                merchantCompliances.clear();
                merchantCompliances.add(MerchantCompliance.loadJSON(json, context, header));
                return merchantCompliances;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MerchantCompliance.getGson().toJson((Object)this);
    }

    public Double getFieldA2cPDisc() {
        return this.mA2cPDisc;
    }

    public MerchantCompliance setFieldA2cPDisc(Double value) {
        this.mA2cPDisc = value;
        return this;
    }

    public Boolean getFieldBaseComplianceStatus() {
        return this.mBaseComplianceStatus;
    }

    public MerchantCompliance setFieldBaseComplianceStatus(Boolean value) {
        this.mBaseComplianceStatus = value;
        return this;
    }

    public Double getFieldNonNullId() {
        return this.mNonNullId;
    }

    public MerchantCompliance setFieldNonNullId(Double value) {
        this.mNonNullId = value;
        return this;
    }

    public Double getFieldNonNullQuantity() {
        return this.mNonNullQuantity;
    }

    public MerchantCompliance setFieldNonNullQuantity(Double value) {
        this.mNonNullQuantity = value;
        return this;
    }

    public Double getFieldVcA2cDisc() {
        return this.mVcA2cDisc;
    }

    public MerchantCompliance setFieldVcA2cDisc(Double value) {
        this.mVcA2cDisc = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public MerchantCompliance setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MerchantCompliance copyFrom(MerchantCompliance instance) {
        this.mA2cPDisc = instance.mA2cPDisc;
        this.mBaseComplianceStatus = instance.mBaseComplianceStatus;
        this.mNonNullId = instance.mNonNullId;
        this.mNonNullQuantity = instance.mNonNullQuantity;
        this.mVcA2cDisc = instance.mVcA2cDisc;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MerchantCompliance> getParser() {
        return new APIRequest.ResponseParser<MerchantCompliance>(){

            @Override
            public APINodeList<MerchantCompliance> parseResponse(String response, APIContext context, APIRequest<MerchantCompliance> request, String header) throws APIException.MalformedResponseException {
                return MerchantCompliance.parseResponse(response, context, request, header);
            }
        };
    }
}

