/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomConversionActivities
extends APINode {
    @SerializedName(value="app_id")
    private Object mAppId = null;
    @SerializedName(value="data")
    private String mData = null;
    @SerializedName(value="event_type")
    private String mEventType = null;
    @SerializedName(value="timestamp")
    private String mTimestamp = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CustomConversionActivities loadJSON(String json, APIContext context, String header) {
        CustomConversionActivities customConversionActivities = (CustomConversionActivities)CustomConversionActivities.getGson().fromJson(json, CustomConversionActivities.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(customConversionActivities.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        customConversionActivities.context = context;
        customConversionActivities.rawValue = json;
        customConversionActivities.header = header;
        return customConversionActivities;
    }

    public static APINodeList<CustomConversionActivities> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CustomConversionActivities> customConversionActivitiess = new APINodeList<CustomConversionActivities>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        customConversionActivitiess.add(CustomConversionActivities.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return customConversionActivitiess;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            customConversionActivitiess.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        customConversionActivitiess.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            customConversionActivitiess.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            customConversionActivitiess.add(CustomConversionActivities.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                customConversionActivitiess.add(CustomConversionActivities.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            customConversionActivitiess.add(CustomConversionActivities.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return customConversionActivitiess;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        customConversionActivitiess.add(CustomConversionActivities.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return customConversionActivitiess;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        customConversionActivitiess.add(CustomConversionActivities.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return customConversionActivitiess;
                }
                customConversionActivitiess.clear();
                customConversionActivitiess.add(CustomConversionActivities.loadJSON(json, context, header));
                return customConversionActivitiess;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CustomConversionActivities.getGson().toJson((Object)this);
    }

    public Object getFieldAppId() {
        return this.mAppId;
    }

    public CustomConversionActivities setFieldAppId(Object value) {
        this.mAppId = value;
        return this;
    }

    public String getFieldData() {
        return this.mData;
    }

    public CustomConversionActivities setFieldData(String value) {
        this.mData = value;
        return this;
    }

    public String getFieldEventType() {
        return this.mEventType;
    }

    public CustomConversionActivities setFieldEventType(String value) {
        this.mEventType = value;
        return this;
    }

    public String getFieldTimestamp() {
        return this.mTimestamp;
    }

    public CustomConversionActivities setFieldTimestamp(String value) {
        this.mTimestamp = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public CustomConversionActivities setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CustomConversionActivities copyFrom(CustomConversionActivities instance) {
        this.mAppId = instance.mAppId;
        this.mData = instance.mData;
        this.mEventType = instance.mEventType;
        this.mTimestamp = instance.mTimestamp;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CustomConversionActivities> getParser() {
        return new APIRequest.ResponseParser<CustomConversionActivities>(){

            @Override
            public APINodeList<CustomConversionActivities> parseResponse(String response, APIContext context, APIRequest<CustomConversionActivities> request, String header) throws APIException.MalformedResponseException {
                return CustomConversionActivities.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumEventType {
        VALUE_CONVERSION_CREATE("conversion_create"),
        VALUE_CONVERSION_DELETE("conversion_delete"),
        VALUE_CONVERSION_UPDATE("conversion_update"),
        NULL(null);

        private String value;

        private EnumEventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

