/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.AdsPixel;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.CustomConversionActivities;
import com.facebook.ads.sdk.CustomConversionStatsResult;
import com.facebook.ads.sdk.ExternalEventSource;
import com.facebook.ads.sdk.OfflineConversionDataSet;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomConversion
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="aggregation_rule")
    private String mAggregationRule = null;
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="custom_event_type")
    private EnumCustomEventType mCustomEventType = null;
    @SerializedName(value="data_sources")
    private List<ExternalEventSource> mDataSources = null;
    @SerializedName(value="default_conversion_value")
    private Long mDefaultConversionValue = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="event_source_type")
    private String mEventSourceType = null;
    @SerializedName(value="first_fired_time")
    private String mFirstFiredTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_archived")
    private Boolean mIsArchived = null;
    @SerializedName(value="last_fired_time")
    private String mLastFiredTime = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="offline_conversion_data_set")
    private OfflineConversionDataSet mOfflineConversionDataSet = null;
    @SerializedName(value="pixel")
    private AdsPixel mPixel = null;
    @SerializedName(value="retention_days")
    private Long mRetentionDays = null;
    @SerializedName(value="rule")
    private String mRule = null;
    protected static Gson gson = null;

    CustomConversion() {
    }

    public CustomConversion(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CustomConversion(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CustomConversion fetch() throws APIException {
        CustomConversion newInstance = CustomConversion.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CustomConversion fetchById(Long id, APIContext context) throws APIException {
        return CustomConversion.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CustomConversion> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CustomConversion.fetchByIdAsync(id.toString(), context);
    }

    public static CustomConversion fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CustomConversion> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CustomConversion> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CustomConversion>(context, "", "/", "GET", CustomConversion.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CustomConversion>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CustomConversion>(context, "", "/", "GET", CustomConversion.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CustomConversion loadJSON(String json, APIContext context, String header) {
        CustomConversion customConversion = (CustomConversion)CustomConversion.getGson().fromJson(json, CustomConversion.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(customConversion.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        customConversion.context = context;
        customConversion.rawValue = json;
        customConversion.header = header;
        return customConversion;
    }

    public static APINodeList<CustomConversion> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CustomConversion> customConversions = new APINodeList<CustomConversion>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        customConversions.add(CustomConversion.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return customConversions;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            customConversions.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        customConversions.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            customConversions.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            customConversions.add(CustomConversion.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                customConversions.add(CustomConversion.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            customConversions.add(CustomConversion.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return customConversions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        customConversions.add(CustomConversion.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return customConversions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        customConversions.add(CustomConversion.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return customConversions;
                }
                customConversions.clear();
                customConversions.add(CustomConversion.loadJSON(json, context, header));
                return customConversions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CustomConversion.getGson().toJson((Object)this);
    }

    public APIRequestGetActivities getActivities() {
        return new APIRequestGetActivities(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteAdAccounts deleteAdAccounts() {
        return new APIRequestDeleteAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdAccounts getAdAccounts() {
        return new APIRequestGetAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdAccount createAdAccount() {
        return new APIRequestCreateAdAccount(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetStats getStats() {
        return new APIRequestGetStats(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public String getFieldAggregationRule() {
        return this.mAggregationRule;
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public EnumCustomEventType getFieldCustomEventType() {
        return this.mCustomEventType;
    }

    public List<ExternalEventSource> getFieldDataSources() {
        return this.mDataSources;
    }

    public Long getFieldDefaultConversionValue() {
        return this.mDefaultConversionValue;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldEventSourceType() {
        return this.mEventSourceType;
    }

    public String getFieldFirstFiredTime() {
        return this.mFirstFiredTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsArchived() {
        return this.mIsArchived;
    }

    public String getFieldLastFiredTime() {
        return this.mLastFiredTime;
    }

    public String getFieldName() {
        return this.mName;
    }

    public OfflineConversionDataSet getFieldOfflineConversionDataSet() {
        if (this.mOfflineConversionDataSet != null) {
            this.mOfflineConversionDataSet.context = this.getContext();
        }
        return this.mOfflineConversionDataSet;
    }

    public AdsPixel getFieldPixel() {
        if (this.mPixel != null) {
            this.mPixel.context = this.getContext();
        }
        return this.mPixel;
    }

    public Long getFieldRetentionDays() {
        return this.mRetentionDays;
    }

    public String getFieldRule() {
        return this.mRule;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CustomConversion copyFrom(CustomConversion instance) {
        this.mAccountId = instance.mAccountId;
        this.mAggregationRule = instance.mAggregationRule;
        this.mBusiness = instance.mBusiness;
        this.mCreationTime = instance.mCreationTime;
        this.mCustomEventType = instance.mCustomEventType;
        this.mDataSources = instance.mDataSources;
        this.mDefaultConversionValue = instance.mDefaultConversionValue;
        this.mDescription = instance.mDescription;
        this.mEventSourceType = instance.mEventSourceType;
        this.mFirstFiredTime = instance.mFirstFiredTime;
        this.mId = instance.mId;
        this.mIsArchived = instance.mIsArchived;
        this.mLastFiredTime = instance.mLastFiredTime;
        this.mName = instance.mName;
        this.mOfflineConversionDataSet = instance.mOfflineConversionDataSet;
        this.mPixel = instance.mPixel;
        this.mRetentionDays = instance.mRetentionDays;
        this.mRule = instance.mRule;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CustomConversion> getParser() {
        return new APIRequest.ResponseParser<CustomConversion>(){

            @Override
            public APINodeList<CustomConversion> parseResponse(String response, APIContext context, APIRequest<CustomConversion> request, String header) throws APIException.MalformedResponseException {
                return CustomConversion.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCustomEventType {
        VALUE_ADD_PAYMENT_INFO("ADD_PAYMENT_INFO"),
        VALUE_ADD_TO_CART("ADD_TO_CART"),
        VALUE_ADD_TO_WISHLIST("ADD_TO_WISHLIST"),
        VALUE_COMPLETE_REGISTRATION("COMPLETE_REGISTRATION"),
        VALUE_CONTENT_VIEW("CONTENT_VIEW"),
        VALUE_INITIATED_CHECKOUT("INITIATED_CHECKOUT"),
        VALUE_LEAD("LEAD"),
        VALUE_PURCHASE("PURCHASE"),
        VALUE_SEARCH("SEARCH"),
        VALUE_CONTACT("CONTACT"),
        VALUE_CUSTOMIZE_PRODUCT("CUSTOMIZE_PRODUCT"),
        VALUE_DONATE("DONATE"),
        VALUE_FIND_LOCATION("FIND_LOCATION"),
        VALUE_SCHEDULE("SCHEDULE"),
        VALUE_START_TRIAL("START_TRIAL"),
        VALUE_SUBMIT_APPLICATION("SUBMIT_APPLICATION"),
        VALUE_SUBSCRIBE("SUBSCRIBE"),
        VALUE_OTHER("OTHER"),
        NULL(null);

        private String value;

        private EnumCustomEventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<CustomConversion> {
        CustomConversion lastResponse = null;
        public static final String[] PARAMS = new String[]{"name", "default_conversion_value", "description"};
        public static final String[] FIELDS = new String[0];

        @Override
        public CustomConversion getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CustomConversion parseResponse(String response, String header) throws APIException {
            return CustomConversion.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CustomConversion execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CustomConversion execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CustomConversion> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CustomConversion> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CustomConversion>(){

                public CustomConversion apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setDefaultConversionValue(Double defaultConversionValue) {
            this.setParam("default_conversion_value", defaultConversionValue);
            return this;
        }

        public APIRequestUpdate setDefaultConversionValue(String defaultConversionValue) {
            this.setParam("default_conversion_value", defaultConversionValue);
            return this;
        }

        public APIRequestUpdate setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<CustomConversion> {
        CustomConversion lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "aggregation_rule", "business", "creation_time", "custom_event_type", "data_sources", "default_conversion_value", "description", "event_source_type", "first_fired_time", "id", "is_archived", "last_fired_time", "name", "offline_conversion_data_set", "pixel", "retention_days", "rule"};

        @Override
        public CustomConversion getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CustomConversion parseResponse(String response, String header) throws APIException {
            return CustomConversion.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CustomConversion execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CustomConversion execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CustomConversion> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CustomConversion> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CustomConversion>(){

                public CustomConversion apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestAggregationRuleField() {
            return this.requestAggregationRuleField(true);
        }

        public APIRequestGet requestAggregationRuleField(boolean value) {
            this.requestField("aggregation_rule", value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCustomEventTypeField() {
            return this.requestCustomEventTypeField(true);
        }

        public APIRequestGet requestCustomEventTypeField(boolean value) {
            this.requestField("custom_event_type", value);
            return this;
        }

        public APIRequestGet requestDataSourcesField() {
            return this.requestDataSourcesField(true);
        }

        public APIRequestGet requestDataSourcesField(boolean value) {
            this.requestField("data_sources", value);
            return this;
        }

        public APIRequestGet requestDefaultConversionValueField() {
            return this.requestDefaultConversionValueField(true);
        }

        public APIRequestGet requestDefaultConversionValueField(boolean value) {
            this.requestField("default_conversion_value", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestEventSourceTypeField() {
            return this.requestEventSourceTypeField(true);
        }

        public APIRequestGet requestEventSourceTypeField(boolean value) {
            this.requestField("event_source_type", value);
            return this;
        }

        public APIRequestGet requestFirstFiredTimeField() {
            return this.requestFirstFiredTimeField(true);
        }

        public APIRequestGet requestFirstFiredTimeField(boolean value) {
            this.requestField("first_fired_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsArchivedField() {
            return this.requestIsArchivedField(true);
        }

        public APIRequestGet requestIsArchivedField(boolean value) {
            this.requestField("is_archived", value);
            return this;
        }

        public APIRequestGet requestLastFiredTimeField() {
            return this.requestLastFiredTimeField(true);
        }

        public APIRequestGet requestLastFiredTimeField(boolean value) {
            this.requestField("last_fired_time", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOfflineConversionDataSetField() {
            return this.requestOfflineConversionDataSetField(true);
        }

        public APIRequestGet requestOfflineConversionDataSetField(boolean value) {
            this.requestField("offline_conversion_data_set", value);
            return this;
        }

        public APIRequestGet requestPixelField() {
            return this.requestPixelField(true);
        }

        public APIRequestGet requestPixelField(boolean value) {
            this.requestField("pixel", value);
            return this;
        }

        public APIRequestGet requestRetentionDaysField() {
            return this.requestRetentionDaysField(true);
        }

        public APIRequestGet requestRetentionDaysField(boolean value) {
            this.requestField("retention_days", value);
            return this;
        }

        public APIRequestGet requestRuleField() {
            return this.requestRuleField(true);
        }

        public APIRequestGet requestRuleField(boolean value) {
            this.requestField("rule", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetStats
    extends APIRequest<CustomConversionStatsResult> {
        APINodeList<CustomConversionStatsResult> lastResponse = null;
        public static final String[] PARAMS = new String[]{"start_time", "end_time", "aggregation"};
        public static final String[] FIELDS = new String[]{"aggregation", "data", "timestamp", "id"};

        @Override
        public APINodeList<CustomConversionStatsResult> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CustomConversionStatsResult> parseResponse(String response, String header) throws APIException {
            return CustomConversionStatsResult.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<CustomConversionStatsResult> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CustomConversionStatsResult> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CustomConversionStatsResult>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CustomConversionStatsResult>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<CustomConversionStatsResult>>(){

                public APINodeList<CustomConversionStatsResult> apply(String result) {
                    try {
                        return APIRequestGetStats.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetStats(String nodeId, APIContext context) {
            super(context, nodeId, "/stats", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetStats setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetStats setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetStats setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestGetStats setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestGetStats setAggregation(CustomConversionStatsResult.EnumAggregation aggregation) {
            this.setParam("aggregation", (Object)aggregation);
            return this;
        }

        public APIRequestGetStats setAggregation(String aggregation) {
            this.setParam("aggregation", aggregation);
            return this;
        }

        public APIRequestGetStats requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetStats requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetStats requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetStats requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetStats requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetStats requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetStats requestAggregationField() {
            return this.requestAggregationField(true);
        }

        public APIRequestGetStats requestAggregationField(boolean value) {
            this.requestField("aggregation", value);
            return this;
        }

        public APIRequestGetStats requestDataField() {
            return this.requestDataField(true);
        }

        public APIRequestGetStats requestDataField(boolean value) {
            this.requestField("data", value);
            return this;
        }

        public APIRequestGetStats requestTimestampField() {
            return this.requestTimestampField(true);
        }

        public APIRequestGetStats requestTimestampField(boolean value) {
            this.requestField("timestamp", value);
            return this;
        }

        public APIRequestGetStats requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetStats requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAdAccount
    extends APIRequest<CustomConversion> {
        CustomConversion lastResponse = null;
        public static final String[] PARAMS = new String[]{"account_id", "business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public CustomConversion getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CustomConversion parseResponse(String response, String header) throws APIException {
            return CustomConversion.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CustomConversion execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CustomConversion execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CustomConversion> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CustomConversion> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CustomConversion>(){

                public CustomConversion apply(String result) {
                    try {
                        return APIRequestCreateAdAccount.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAdAccount(String nodeId, APIContext context) {
            super(context, nodeId, "/adaccounts", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAdAccount setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAdAccount setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAdAccount setAccountId(String accountId) {
            this.setParam("account_id", accountId);
            return this;
        }

        public APIRequestCreateAdAccount setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestCreateAdAccount requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAdAccount requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdAccount requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAdAccount requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdAccount requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAdAccount requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdAccounts
    extends APIRequest<AdAccount> {
        APINodeList<AdAccount> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[]{"account_id", "account_status", "ad_account_creation_request", "ad_account_promotable_objects", "age", "agency_client_declaration", "amount_spent", "attribution_spec", "balance", "business", "business_city", "business_country_code", "business_name", "business_state", "business_street", "business_street2", "business_zip", "capabilities", "created_time", "currency", "direct_deals_tos_accepted", "disable_reason", "end_advertiser", "end_advertiser_name", "extended_credit_invoice_group", "failed_delivery_checks", "funding_source", "funding_source_details", "has_migrated_permissions", "has_page_authorized_adaccount", "id", "io_number", "is_attribution_spec_system_default", "is_direct_deals_enabled", "is_in_3ds_authorization_enabled_market", "is_in_middle_of_local_entity_migration", "is_notifications_enabled", "is_personal", "is_prepay_account", "is_tax_id_required", "line_numbers", "media_agency", "min_campaign_group_spend_cap", "min_daily_budget", "name", "offsite_pixels_tos_accepted", "owner", "partner", "rf_spec", "show_checkout_experience", "spend_cap", "tax_id", "tax_id_status", "tax_id_type", "timezone_id", "timezone_name", "timezone_offset_hours_utc", "tos_accepted", "user_role", "user_tos_accepted"};

        @Override
        public APINodeList<AdAccount> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccount> parseResponse(String response, String header) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdAccount> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccount> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAccount>>(){

                public APINodeList<AdAccount> apply(String result) {
                    try {
                        return APIRequestGetAdAccounts.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/adaccounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdAccounts setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestGetAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdAccounts requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAdAccounts requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAccountStatusField() {
            return this.requestAccountStatusField(true);
        }

        public APIRequestGetAdAccounts requestAccountStatusField(boolean value) {
            this.requestField("account_status", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAdAccountCreationRequestField() {
            return this.requestAdAccountCreationRequestField(true);
        }

        public APIRequestGetAdAccounts requestAdAccountCreationRequestField(boolean value) {
            this.requestField("ad_account_creation_request", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAdAccountPromotableObjectsField() {
            return this.requestAdAccountPromotableObjectsField(true);
        }

        public APIRequestGetAdAccounts requestAdAccountPromotableObjectsField(boolean value) {
            this.requestField("ad_account_promotable_objects", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAgeField() {
            return this.requestAgeField(true);
        }

        public APIRequestGetAdAccounts requestAgeField(boolean value) {
            this.requestField("age", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAgencyClientDeclarationField() {
            return this.requestAgencyClientDeclarationField(true);
        }

        public APIRequestGetAdAccounts requestAgencyClientDeclarationField(boolean value) {
            this.requestField("agency_client_declaration", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAmountSpentField() {
            return this.requestAmountSpentField(true);
        }

        public APIRequestGetAdAccounts requestAmountSpentField(boolean value) {
            this.requestField("amount_spent", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetAdAccounts requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBalanceField() {
            return this.requestBalanceField(true);
        }

        public APIRequestGetAdAccounts requestBalanceField(boolean value) {
            this.requestField("balance", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAdAccounts requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessCityField() {
            return this.requestBusinessCityField(true);
        }

        public APIRequestGetAdAccounts requestBusinessCityField(boolean value) {
            this.requestField("business_city", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessCountryCodeField() {
            return this.requestBusinessCountryCodeField(true);
        }

        public APIRequestGetAdAccounts requestBusinessCountryCodeField(boolean value) {
            this.requestField("business_country_code", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessNameField() {
            return this.requestBusinessNameField(true);
        }

        public APIRequestGetAdAccounts requestBusinessNameField(boolean value) {
            this.requestField("business_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStateField() {
            return this.requestBusinessStateField(true);
        }

        public APIRequestGetAdAccounts requestBusinessStateField(boolean value) {
            this.requestField("business_state", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStreetField() {
            return this.requestBusinessStreetField(true);
        }

        public APIRequestGetAdAccounts requestBusinessStreetField(boolean value) {
            this.requestField("business_street", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStreet2Field() {
            return this.requestBusinessStreet2Field(true);
        }

        public APIRequestGetAdAccounts requestBusinessStreet2Field(boolean value) {
            this.requestField("business_street2", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessZipField() {
            return this.requestBusinessZipField(true);
        }

        public APIRequestGetAdAccounts requestBusinessZipField(boolean value) {
            this.requestField("business_zip", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCapabilitiesField() {
            return this.requestCapabilitiesField(true);
        }

        public APIRequestGetAdAccounts requestCapabilitiesField(boolean value) {
            this.requestField("capabilities", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAdAccounts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetAdAccounts requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetAdAccounts requestDirectDealsTosAcceptedField() {
            return this.requestDirectDealsTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestDirectDealsTosAcceptedField(boolean value) {
            this.requestField("direct_deals_tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestDisableReasonField() {
            return this.requestDisableReasonField(true);
        }

        public APIRequestGetAdAccounts requestDisableReasonField(boolean value) {
            this.requestField("disable_reason", value);
            return this;
        }

        public APIRequestGetAdAccounts requestEndAdvertiserField() {
            return this.requestEndAdvertiserField(true);
        }

        public APIRequestGetAdAccounts requestEndAdvertiserField(boolean value) {
            this.requestField("end_advertiser", value);
            return this;
        }

        public APIRequestGetAdAccounts requestEndAdvertiserNameField() {
            return this.requestEndAdvertiserNameField(true);
        }

        public APIRequestGetAdAccounts requestEndAdvertiserNameField(boolean value) {
            this.requestField("end_advertiser_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestExtendedCreditInvoiceGroupField() {
            return this.requestExtendedCreditInvoiceGroupField(true);
        }

        public APIRequestGetAdAccounts requestExtendedCreditInvoiceGroupField(boolean value) {
            this.requestField("extended_credit_invoice_group", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFailedDeliveryChecksField() {
            return this.requestFailedDeliveryChecksField(true);
        }

        public APIRequestGetAdAccounts requestFailedDeliveryChecksField(boolean value) {
            this.requestField("failed_delivery_checks", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFundingSourceField() {
            return this.requestFundingSourceField(true);
        }

        public APIRequestGetAdAccounts requestFundingSourceField(boolean value) {
            this.requestField("funding_source", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFundingSourceDetailsField() {
            return this.requestFundingSourceDetailsField(true);
        }

        public APIRequestGetAdAccounts requestFundingSourceDetailsField(boolean value) {
            this.requestField("funding_source_details", value);
            return this;
        }

        public APIRequestGetAdAccounts requestHasMigratedPermissionsField() {
            return this.requestHasMigratedPermissionsField(true);
        }

        public APIRequestGetAdAccounts requestHasMigratedPermissionsField(boolean value) {
            this.requestField("has_migrated_permissions", value);
            return this;
        }

        public APIRequestGetAdAccounts requestHasPageAuthorizedAdaccountField() {
            return this.requestHasPageAuthorizedAdaccountField(true);
        }

        public APIRequestGetAdAccounts requestHasPageAuthorizedAdaccountField(boolean value) {
            this.requestField("has_page_authorized_adaccount", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGetAdAccounts requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsAttributionSpecSystemDefaultField() {
            return this.requestIsAttributionSpecSystemDefaultField(true);
        }

        public APIRequestGetAdAccounts requestIsAttributionSpecSystemDefaultField(boolean value) {
            this.requestField("is_attribution_spec_system_default", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsDirectDealsEnabledField() {
            return this.requestIsDirectDealsEnabledField(true);
        }

        public APIRequestGetAdAccounts requestIsDirectDealsEnabledField(boolean value) {
            this.requestField("is_direct_deals_enabled", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsIn3dsAuthorizationEnabledMarketField() {
            return this.requestIsIn3dsAuthorizationEnabledMarketField(true);
        }

        public APIRequestGetAdAccounts requestIsIn3dsAuthorizationEnabledMarketField(boolean value) {
            this.requestField("is_in_3ds_authorization_enabled_market", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsInMiddleOfLocalEntityMigrationField() {
            return this.requestIsInMiddleOfLocalEntityMigrationField(true);
        }

        public APIRequestGetAdAccounts requestIsInMiddleOfLocalEntityMigrationField(boolean value) {
            this.requestField("is_in_middle_of_local_entity_migration", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsNotificationsEnabledField() {
            return this.requestIsNotificationsEnabledField(true);
        }

        public APIRequestGetAdAccounts requestIsNotificationsEnabledField(boolean value) {
            this.requestField("is_notifications_enabled", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsPersonalField() {
            return this.requestIsPersonalField(true);
        }

        public APIRequestGetAdAccounts requestIsPersonalField(boolean value) {
            this.requestField("is_personal", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsPrepayAccountField() {
            return this.requestIsPrepayAccountField(true);
        }

        public APIRequestGetAdAccounts requestIsPrepayAccountField(boolean value) {
            this.requestField("is_prepay_account", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsTaxIdRequiredField() {
            return this.requestIsTaxIdRequiredField(true);
        }

        public APIRequestGetAdAccounts requestIsTaxIdRequiredField(boolean value) {
            this.requestField("is_tax_id_required", value);
            return this;
        }

        public APIRequestGetAdAccounts requestLineNumbersField() {
            return this.requestLineNumbersField(true);
        }

        public APIRequestGetAdAccounts requestLineNumbersField(boolean value) {
            this.requestField("line_numbers", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMediaAgencyField() {
            return this.requestMediaAgencyField(true);
        }

        public APIRequestGetAdAccounts requestMediaAgencyField(boolean value) {
            this.requestField("media_agency", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMinCampaignGroupSpendCapField() {
            return this.requestMinCampaignGroupSpendCapField(true);
        }

        public APIRequestGetAdAccounts requestMinCampaignGroupSpendCapField(boolean value) {
            this.requestField("min_campaign_group_spend_cap", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMinDailyBudgetField() {
            return this.requestMinDailyBudgetField(true);
        }

        public APIRequestGetAdAccounts requestMinDailyBudgetField(boolean value) {
            this.requestField("min_daily_budget", value);
            return this;
        }

        public APIRequestGetAdAccounts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdAccounts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOffsitePixelsTosAcceptedField() {
            return this.requestOffsitePixelsTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestOffsitePixelsTosAcceptedField(boolean value) {
            this.requestField("offsite_pixels_tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetAdAccounts requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetAdAccounts requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetAdAccounts requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetAdAccounts requestRfSpecField() {
            return this.requestRfSpecField(true);
        }

        public APIRequestGetAdAccounts requestRfSpecField(boolean value) {
            this.requestField("rf_spec", value);
            return this;
        }

        public APIRequestGetAdAccounts requestShowCheckoutExperienceField() {
            return this.requestShowCheckoutExperienceField(true);
        }

        public APIRequestGetAdAccounts requestShowCheckoutExperienceField(boolean value) {
            this.requestField("show_checkout_experience", value);
            return this;
        }

        public APIRequestGetAdAccounts requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetAdAccounts requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdField() {
            return this.requestTaxIdField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdField(boolean value) {
            this.requestField("tax_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdStatusField() {
            return this.requestTaxIdStatusField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdStatusField(boolean value) {
            this.requestField("tax_id_status", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdTypeField() {
            return this.requestTaxIdTypeField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdTypeField(boolean value) {
            this.requestField("tax_id_type", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneOffsetHoursUtcField() {
            return this.requestTimezoneOffsetHoursUtcField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneOffsetHoursUtcField(boolean value) {
            this.requestField("timezone_offset_hours_utc", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTosAcceptedField() {
            return this.requestTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestTosAcceptedField(boolean value) {
            this.requestField("tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestUserRoleField() {
            return this.requestUserRoleField(true);
        }

        public APIRequestGetAdAccounts requestUserRoleField(boolean value) {
            this.requestField("user_role", value);
            return this;
        }

        public APIRequestGetAdAccounts requestUserTosAcceptedField() {
            return this.requestUserTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestUserTosAcceptedField(boolean value) {
            this.requestField("user_tos_accepted", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteAdAccounts
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"account_id", "business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteAdAccounts.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/adaccounts", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteAdAccounts setAccountId(String accountId) {
            this.setParam("account_id", accountId);
            return this;
        }

        public APIRequestDeleteAdAccounts setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestDeleteAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetActivities
    extends APIRequest<CustomConversionActivities> {
        APINodeList<CustomConversionActivities> lastResponse = null;
        public static final String[] PARAMS = new String[]{"start_time", "end_time", "event_type"};
        public static final String[] FIELDS = new String[]{"app_id", "data", "event_type", "timestamp", "id"};

        @Override
        public APINodeList<CustomConversionActivities> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CustomConversionActivities> parseResponse(String response, String header) throws APIException {
            return CustomConversionActivities.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<CustomConversionActivities> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CustomConversionActivities> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CustomConversionActivities>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CustomConversionActivities>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<CustomConversionActivities>>(){

                public APINodeList<CustomConversionActivities> apply(String result) {
                    try {
                        return APIRequestGetActivities.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetActivities(String nodeId, APIContext context) {
            super(context, nodeId, "/activities", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetActivities setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetActivities setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetActivities setStartTime(Object startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestGetActivities setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestGetActivities setEndTime(Object endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestGetActivities setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestGetActivities setEventType(CustomConversionActivities.EnumEventType eventType) {
            this.setParam("event_type", (Object)eventType);
            return this;
        }

        public APIRequestGetActivities setEventType(String eventType) {
            this.setParam("event_type", eventType);
            return this;
        }

        public APIRequestGetActivities requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetActivities requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetActivities requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetActivities requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetActivities requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetActivities requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetActivities requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGetActivities requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGetActivities requestDataField() {
            return this.requestDataField(true);
        }

        public APIRequestGetActivities requestDataField(boolean value) {
            this.requestField("data", value);
            return this;
        }

        public APIRequestGetActivities requestEventTypeField() {
            return this.requestEventTypeField(true);
        }

        public APIRequestGetActivities requestEventTypeField(boolean value) {
            this.requestField("event_type", value);
            return this;
        }

        public APIRequestGetActivities requestTimestampField() {
            return this.requestTimestampField(true);
        }

        public APIRequestGetActivities requestTimestampField(boolean value) {
            this.requestField("timestamp", value);
            return this;
        }

        public APIRequestGetActivities requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetActivities requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

