/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserNotificationSeenStateData
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="seen_state")
    private String mSeenState = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static UserNotificationSeenStateData loadJSON(String json, APIContext context) {
        UserNotificationSeenStateData userNotificationSeenStateData = (UserNotificationSeenStateData)UserNotificationSeenStateData.getGson().fromJson(json, UserNotificationSeenStateData.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(userNotificationSeenStateData.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        userNotificationSeenStateData.context = context;
        userNotificationSeenStateData.rawValue = json;
        return userNotificationSeenStateData;
    }

    public static APINodeList<UserNotificationSeenStateData> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<UserNotificationSeenStateData> userNotificationSeenStateDatas = new APINodeList<UserNotificationSeenStateData>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        userNotificationSeenStateDatas.add(UserNotificationSeenStateData.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return userNotificationSeenStateDatas;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            userNotificationSeenStateDatas.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        userNotificationSeenStateDatas.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            userNotificationSeenStateDatas.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            userNotificationSeenStateDatas.add(UserNotificationSeenStateData.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                userNotificationSeenStateDatas.add(UserNotificationSeenStateData.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            userNotificationSeenStateDatas.add(UserNotificationSeenStateData.loadJSON(obj.toString(), context));
                        }
                    }
                    return userNotificationSeenStateDatas;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        userNotificationSeenStateDatas.add(UserNotificationSeenStateData.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return userNotificationSeenStateDatas;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        userNotificationSeenStateDatas.add(UserNotificationSeenStateData.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return userNotificationSeenStateDatas;
                }
                userNotificationSeenStateDatas.clear();
                userNotificationSeenStateDatas.add(UserNotificationSeenStateData.loadJSON(json, context));
                return userNotificationSeenStateDatas;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return UserNotificationSeenStateData.getGson().toJson((Object)this);
    }

    public String getFieldId() {
        return this.mId;
    }

    public UserNotificationSeenStateData setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldSeenState() {
        return this.mSeenState;
    }

    public UserNotificationSeenStateData setFieldSeenState(String value) {
        this.mSeenState = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public UserNotificationSeenStateData copyFrom(UserNotificationSeenStateData instance) {
        this.mId = instance.mId;
        this.mSeenState = instance.mSeenState;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<UserNotificationSeenStateData> getParser() {
        return new APIRequest.ResponseParser<UserNotificationSeenStateData>(){

            @Override
            public APINodeList<UserNotificationSeenStateData> parseResponse(String response, APIContext context, APIRequest<UserNotificationSeenStateData> request) throws APIException.MalformedResponseException {
                return UserNotificationSeenStateData.parseResponse(response, context, request);
            }
        };
    }
}

