/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveVideoAdBreakConfig
extends APINode {
    @SerializedName(value="default_ad_break_duration")
    private Long mDefaultAdBreakDuration = null;
    @SerializedName(value="failure_reason_polling_interval")
    private Long mFailureReasonPollingInterval = null;
    @SerializedName(value="first_break_eligible_secs")
    private Long mFirstBreakEligibleSecs = null;
    @SerializedName(value="guide_url")
    private String mGuideUrl = null;
    @SerializedName(value="is_eligible_to_onboard")
    private Boolean mIsEligibleToOnboard = null;
    @SerializedName(value="is_enabled")
    private Boolean mIsEnabled = null;
    @SerializedName(value="onboarding_url")
    private String mOnboardingUrl = null;
    @SerializedName(value="preparing_duration")
    private Long mPreparingDuration = null;
    @SerializedName(value="time_between_ad_breaks_secs")
    private Long mTimeBetweenAdBreaksSecs = null;
    @SerializedName(value="viewer_count_threshold")
    private Long mViewerCountThreshold = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static LiveVideoAdBreakConfig loadJSON(String json, APIContext context) {
        LiveVideoAdBreakConfig liveVideoAdBreakConfig = (LiveVideoAdBreakConfig)LiveVideoAdBreakConfig.getGson().fromJson(json, LiveVideoAdBreakConfig.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(liveVideoAdBreakConfig.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        liveVideoAdBreakConfig.context = context;
        liveVideoAdBreakConfig.rawValue = json;
        return liveVideoAdBreakConfig;
    }

    public static APINodeList<LiveVideoAdBreakConfig> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<LiveVideoAdBreakConfig> liveVideoAdBreakConfigs = new APINodeList<LiveVideoAdBreakConfig>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        liveVideoAdBreakConfigs.add(LiveVideoAdBreakConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return liveVideoAdBreakConfigs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            liveVideoAdBreakConfigs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        liveVideoAdBreakConfigs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            liveVideoAdBreakConfigs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            liveVideoAdBreakConfigs.add(LiveVideoAdBreakConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                liveVideoAdBreakConfigs.add(LiveVideoAdBreakConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            liveVideoAdBreakConfigs.add(LiveVideoAdBreakConfig.loadJSON(obj.toString(), context));
                        }
                    }
                    return liveVideoAdBreakConfigs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        liveVideoAdBreakConfigs.add(LiveVideoAdBreakConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return liveVideoAdBreakConfigs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        liveVideoAdBreakConfigs.add(LiveVideoAdBreakConfig.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return liveVideoAdBreakConfigs;
                }
                liveVideoAdBreakConfigs.clear();
                liveVideoAdBreakConfigs.add(LiveVideoAdBreakConfig.loadJSON(json, context));
                return liveVideoAdBreakConfigs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LiveVideoAdBreakConfig.getGson().toJson((Object)this);
    }

    public Long getFieldDefaultAdBreakDuration() {
        return this.mDefaultAdBreakDuration;
    }

    public LiveVideoAdBreakConfig setFieldDefaultAdBreakDuration(Long value) {
        this.mDefaultAdBreakDuration = value;
        return this;
    }

    public Long getFieldFailureReasonPollingInterval() {
        return this.mFailureReasonPollingInterval;
    }

    public LiveVideoAdBreakConfig setFieldFailureReasonPollingInterval(Long value) {
        this.mFailureReasonPollingInterval = value;
        return this;
    }

    public Long getFieldFirstBreakEligibleSecs() {
        return this.mFirstBreakEligibleSecs;
    }

    public LiveVideoAdBreakConfig setFieldFirstBreakEligibleSecs(Long value) {
        this.mFirstBreakEligibleSecs = value;
        return this;
    }

    public String getFieldGuideUrl() {
        return this.mGuideUrl;
    }

    public LiveVideoAdBreakConfig setFieldGuideUrl(String value) {
        this.mGuideUrl = value;
        return this;
    }

    public Boolean getFieldIsEligibleToOnboard() {
        return this.mIsEligibleToOnboard;
    }

    public LiveVideoAdBreakConfig setFieldIsEligibleToOnboard(Boolean value) {
        this.mIsEligibleToOnboard = value;
        return this;
    }

    public Boolean getFieldIsEnabled() {
        return this.mIsEnabled;
    }

    public LiveVideoAdBreakConfig setFieldIsEnabled(Boolean value) {
        this.mIsEnabled = value;
        return this;
    }

    public String getFieldOnboardingUrl() {
        return this.mOnboardingUrl;
    }

    public LiveVideoAdBreakConfig setFieldOnboardingUrl(String value) {
        this.mOnboardingUrl = value;
        return this;
    }

    public Long getFieldPreparingDuration() {
        return this.mPreparingDuration;
    }

    public LiveVideoAdBreakConfig setFieldPreparingDuration(Long value) {
        this.mPreparingDuration = value;
        return this;
    }

    public Long getFieldTimeBetweenAdBreaksSecs() {
        return this.mTimeBetweenAdBreaksSecs;
    }

    public LiveVideoAdBreakConfig setFieldTimeBetweenAdBreaksSecs(Long value) {
        this.mTimeBetweenAdBreaksSecs = value;
        return this;
    }

    public Long getFieldViewerCountThreshold() {
        return this.mViewerCountThreshold;
    }

    public LiveVideoAdBreakConfig setFieldViewerCountThreshold(Long value) {
        this.mViewerCountThreshold = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public LiveVideoAdBreakConfig setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LiveVideoAdBreakConfig copyFrom(LiveVideoAdBreakConfig instance) {
        this.mDefaultAdBreakDuration = instance.mDefaultAdBreakDuration;
        this.mFailureReasonPollingInterval = instance.mFailureReasonPollingInterval;
        this.mFirstBreakEligibleSecs = instance.mFirstBreakEligibleSecs;
        this.mGuideUrl = instance.mGuideUrl;
        this.mIsEligibleToOnboard = instance.mIsEligibleToOnboard;
        this.mIsEnabled = instance.mIsEnabled;
        this.mOnboardingUrl = instance.mOnboardingUrl;
        this.mPreparingDuration = instance.mPreparingDuration;
        this.mTimeBetweenAdBreaksSecs = instance.mTimeBetweenAdBreaksSecs;
        this.mViewerCountThreshold = instance.mViewerCountThreshold;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LiveVideoAdBreakConfig> getParser() {
        return new APIRequest.ResponseParser<LiveVideoAdBreakConfig>(){

            @Override
            public APINodeList<LiveVideoAdBreakConfig> parseResponse(String response, APIContext context, APIRequest<LiveVideoAdBreakConfig> request) throws APIException.MalformedResponseException {
                return LiveVideoAdBreakConfig.parseResponse(response, context, request);
            }
        };
    }
}

