/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalEventSourceDAStatsResult
extends APINode {
    @SerializedName(value="count_content_ids")
    private Long mCountContentIds = null;
    @SerializedName(value="count_content_ids_match_any_catalog")
    private Long mCountContentIdsMatchAnyCatalog = null;
    @SerializedName(value="count_fires")
    private Long mCountFires = null;
    @SerializedName(value="count_fires_match_any_catalog")
    private Long mCountFiresMatchAnyCatalog = null;
    @SerializedName(value="date")
    private String mDate = null;
    @SerializedName(value="percentage_missed_users")
    private Double mPercentageMissedUsers = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ExternalEventSourceDAStatsResult loadJSON(String json, APIContext context) {
        ExternalEventSourceDAStatsResult externalEventSourceDAStatsResult = (ExternalEventSourceDAStatsResult)ExternalEventSourceDAStatsResult.getGson().fromJson(json, ExternalEventSourceDAStatsResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(externalEventSourceDAStatsResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        externalEventSourceDAStatsResult.context = context;
        externalEventSourceDAStatsResult.rawValue = json;
        return externalEventSourceDAStatsResult;
    }

    public static APINodeList<ExternalEventSourceDAStatsResult> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ExternalEventSourceDAStatsResult> externalEventSourceDAStatsResults = new APINodeList<ExternalEventSourceDAStatsResult>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        externalEventSourceDAStatsResults.add(ExternalEventSourceDAStatsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return externalEventSourceDAStatsResults;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            externalEventSourceDAStatsResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        externalEventSourceDAStatsResults.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            externalEventSourceDAStatsResults.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            externalEventSourceDAStatsResults.add(ExternalEventSourceDAStatsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                externalEventSourceDAStatsResults.add(ExternalEventSourceDAStatsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            externalEventSourceDAStatsResults.add(ExternalEventSourceDAStatsResult.loadJSON(obj.toString(), context));
                        }
                    }
                    return externalEventSourceDAStatsResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        externalEventSourceDAStatsResults.add(ExternalEventSourceDAStatsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return externalEventSourceDAStatsResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        externalEventSourceDAStatsResults.add(ExternalEventSourceDAStatsResult.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return externalEventSourceDAStatsResults;
                }
                externalEventSourceDAStatsResults.clear();
                externalEventSourceDAStatsResults.add(ExternalEventSourceDAStatsResult.loadJSON(json, context));
                return externalEventSourceDAStatsResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ExternalEventSourceDAStatsResult.getGson().toJson((Object)this);
    }

    public Long getFieldCountContentIds() {
        return this.mCountContentIds;
    }

    public ExternalEventSourceDAStatsResult setFieldCountContentIds(Long value) {
        this.mCountContentIds = value;
        return this;
    }

    public Long getFieldCountContentIdsMatchAnyCatalog() {
        return this.mCountContentIdsMatchAnyCatalog;
    }

    public ExternalEventSourceDAStatsResult setFieldCountContentIdsMatchAnyCatalog(Long value) {
        this.mCountContentIdsMatchAnyCatalog = value;
        return this;
    }

    public Long getFieldCountFires() {
        return this.mCountFires;
    }

    public ExternalEventSourceDAStatsResult setFieldCountFires(Long value) {
        this.mCountFires = value;
        return this;
    }

    public Long getFieldCountFiresMatchAnyCatalog() {
        return this.mCountFiresMatchAnyCatalog;
    }

    public ExternalEventSourceDAStatsResult setFieldCountFiresMatchAnyCatalog(Long value) {
        this.mCountFiresMatchAnyCatalog = value;
        return this;
    }

    public String getFieldDate() {
        return this.mDate;
    }

    public ExternalEventSourceDAStatsResult setFieldDate(String value) {
        this.mDate = value;
        return this;
    }

    public Double getFieldPercentageMissedUsers() {
        return this.mPercentageMissedUsers;
    }

    public ExternalEventSourceDAStatsResult setFieldPercentageMissedUsers(Double value) {
        this.mPercentageMissedUsers = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public ExternalEventSourceDAStatsResult setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ExternalEventSourceDAStatsResult copyFrom(ExternalEventSourceDAStatsResult instance) {
        this.mCountContentIds = instance.mCountContentIds;
        this.mCountContentIdsMatchAnyCatalog = instance.mCountContentIdsMatchAnyCatalog;
        this.mCountFires = instance.mCountFires;
        this.mCountFiresMatchAnyCatalog = instance.mCountFiresMatchAnyCatalog;
        this.mDate = instance.mDate;
        this.mPercentageMissedUsers = instance.mPercentageMissedUsers;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ExternalEventSourceDAStatsResult> getParser() {
        return new APIRequest.ResponseParser<ExternalEventSourceDAStatsResult>(){

            @Override
            public APINodeList<ExternalEventSourceDAStatsResult> parseResponse(String response, APIContext context, APIRequest<ExternalEventSourceDAStatsResult> request) throws APIException.MalformedResponseException {
                return ExternalEventSourceDAStatsResult.parseResponse(response, context, request);
            }
        };
    }
}

