/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicPostChildAttachment
extends APINode {
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="image_url")
    private String mImageUrl = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="place_id")
    private String mPlaceId = null;
    @SerializedName(value="product_id")
    private String mProductId = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static DynamicPostChildAttachment loadJSON(String json, APIContext context) {
        DynamicPostChildAttachment dynamicPostChildAttachment = (DynamicPostChildAttachment)DynamicPostChildAttachment.getGson().fromJson(json, DynamicPostChildAttachment.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(dynamicPostChildAttachment.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        dynamicPostChildAttachment.context = context;
        dynamicPostChildAttachment.rawValue = json;
        return dynamicPostChildAttachment;
    }

    public static APINodeList<DynamicPostChildAttachment> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<DynamicPostChildAttachment> dynamicPostChildAttachments = new APINodeList<DynamicPostChildAttachment>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        dynamicPostChildAttachments.add(DynamicPostChildAttachment.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return dynamicPostChildAttachments;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            dynamicPostChildAttachments.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        dynamicPostChildAttachments.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            dynamicPostChildAttachments.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            dynamicPostChildAttachments.add(DynamicPostChildAttachment.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                dynamicPostChildAttachments.add(DynamicPostChildAttachment.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            dynamicPostChildAttachments.add(DynamicPostChildAttachment.loadJSON(obj.toString(), context));
                        }
                    }
                    return dynamicPostChildAttachments;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        dynamicPostChildAttachments.add(DynamicPostChildAttachment.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return dynamicPostChildAttachments;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        dynamicPostChildAttachments.add(DynamicPostChildAttachment.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return dynamicPostChildAttachments;
                }
                dynamicPostChildAttachments.clear();
                dynamicPostChildAttachments.add(DynamicPostChildAttachment.loadJSON(json, context));
                return dynamicPostChildAttachments;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return DynamicPostChildAttachment.getGson().toJson((Object)this);
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public DynamicPostChildAttachment setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public String getFieldImageUrl() {
        return this.mImageUrl;
    }

    public DynamicPostChildAttachment setFieldImageUrl(String value) {
        this.mImageUrl = value;
        return this;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public DynamicPostChildAttachment setFieldLink(String value) {
        this.mLink = value;
        return this;
    }

    public String getFieldPlaceId() {
        return this.mPlaceId;
    }

    public DynamicPostChildAttachment setFieldPlaceId(String value) {
        this.mPlaceId = value;
        return this;
    }

    public String getFieldProductId() {
        return this.mProductId;
    }

    public DynamicPostChildAttachment setFieldProductId(String value) {
        this.mProductId = value;
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public DynamicPostChildAttachment setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public DynamicPostChildAttachment setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public DynamicPostChildAttachment copyFrom(DynamicPostChildAttachment instance) {
        this.mDescription = instance.mDescription;
        this.mImageUrl = instance.mImageUrl;
        this.mLink = instance.mLink;
        this.mPlaceId = instance.mPlaceId;
        this.mProductId = instance.mProductId;
        this.mTitle = instance.mTitle;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<DynamicPostChildAttachment> getParser() {
        return new APIRequest.ResponseParser<DynamicPostChildAttachment>(){

            @Override
            public APINodeList<DynamicPostChildAttachment> parseResponse(String response, APIContext context, APIRequest<DynamicPostChildAttachment> request) throws APIException.MalformedResponseException {
                return DynamicPostChildAttachment.parseResponse(response, context, request);
            }
        };
    }
}

