/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessCreditCardLegacy
extends APINode {
    @SerializedName(value="address")
    private Object mAddress = null;
    @SerializedName(value="business_id")
    private String mBusinessId = null;
    @SerializedName(value="credit_card_suffix")
    private String mCreditCardSuffix = null;
    @SerializedName(value="credit_card_type")
    private String mCreditCardType = null;
    @SerializedName(value="expiration_month")
    private Long mExpirationMonth = null;
    @SerializedName(value="expiration_year")
    private Long mExpirationYear = null;
    @SerializedName(value="first_name")
    private String mFirstName = null;
    @SerializedName(value="fraud_status")
    private String mFraudStatus = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="last_name")
    private String mLastName = null;
    @SerializedName(value="middle_name")
    private String mMiddleName = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BusinessCreditCardLegacy loadJSON(String json, APIContext context, String header) {
        BusinessCreditCardLegacy businessCreditCardLegacy = (BusinessCreditCardLegacy)BusinessCreditCardLegacy.getGson().fromJson(json, BusinessCreditCardLegacy.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessCreditCardLegacy.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessCreditCardLegacy.context = context;
        businessCreditCardLegacy.rawValue = json;
        businessCreditCardLegacy.header = header;
        return businessCreditCardLegacy;
    }

    public static APINodeList<BusinessCreditCardLegacy> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BusinessCreditCardLegacy> businessCreditCardLegacys = new APINodeList<BusinessCreditCardLegacy>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessCreditCardLegacys.add(BusinessCreditCardLegacy.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return businessCreditCardLegacys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessCreditCardLegacys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessCreditCardLegacys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            businessCreditCardLegacys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessCreditCardLegacys.add(BusinessCreditCardLegacy.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessCreditCardLegacys.add(BusinessCreditCardLegacy.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessCreditCardLegacys.add(BusinessCreditCardLegacy.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return businessCreditCardLegacys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessCreditCardLegacys.add(BusinessCreditCardLegacy.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return businessCreditCardLegacys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessCreditCardLegacys.add(BusinessCreditCardLegacy.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessCreditCardLegacys;
                }
                businessCreditCardLegacys.clear();
                businessCreditCardLegacys.add(BusinessCreditCardLegacy.loadJSON(json, context, header));
                return businessCreditCardLegacys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessCreditCardLegacy.getGson().toJson((Object)this);
    }

    public Object getFieldAddress() {
        return this.mAddress;
    }

    public BusinessCreditCardLegacy setFieldAddress(Object value) {
        this.mAddress = value;
        return this;
    }

    public String getFieldBusinessId() {
        return this.mBusinessId;
    }

    public BusinessCreditCardLegacy setFieldBusinessId(String value) {
        this.mBusinessId = value;
        return this;
    }

    public String getFieldCreditCardSuffix() {
        return this.mCreditCardSuffix;
    }

    public BusinessCreditCardLegacy setFieldCreditCardSuffix(String value) {
        this.mCreditCardSuffix = value;
        return this;
    }

    public String getFieldCreditCardType() {
        return this.mCreditCardType;
    }

    public BusinessCreditCardLegacy setFieldCreditCardType(String value) {
        this.mCreditCardType = value;
        return this;
    }

    public Long getFieldExpirationMonth() {
        return this.mExpirationMonth;
    }

    public BusinessCreditCardLegacy setFieldExpirationMonth(Long value) {
        this.mExpirationMonth = value;
        return this;
    }

    public Long getFieldExpirationYear() {
        return this.mExpirationYear;
    }

    public BusinessCreditCardLegacy setFieldExpirationYear(Long value) {
        this.mExpirationYear = value;
        return this;
    }

    public String getFieldFirstName() {
        return this.mFirstName;
    }

    public BusinessCreditCardLegacy setFieldFirstName(String value) {
        this.mFirstName = value;
        return this;
    }

    public String getFieldFraudStatus() {
        return this.mFraudStatus;
    }

    public BusinessCreditCardLegacy setFieldFraudStatus(String value) {
        this.mFraudStatus = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public BusinessCreditCardLegacy setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldLastName() {
        return this.mLastName;
    }

    public BusinessCreditCardLegacy setFieldLastName(String value) {
        this.mLastName = value;
        return this;
    }

    public String getFieldMiddleName() {
        return this.mMiddleName;
    }

    public BusinessCreditCardLegacy setFieldMiddleName(String value) {
        this.mMiddleName = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessCreditCardLegacy copyFrom(BusinessCreditCardLegacy instance) {
        this.mAddress = instance.mAddress;
        this.mBusinessId = instance.mBusinessId;
        this.mCreditCardSuffix = instance.mCreditCardSuffix;
        this.mCreditCardType = instance.mCreditCardType;
        this.mExpirationMonth = instance.mExpirationMonth;
        this.mExpirationYear = instance.mExpirationYear;
        this.mFirstName = instance.mFirstName;
        this.mFraudStatus = instance.mFraudStatus;
        this.mId = instance.mId;
        this.mLastName = instance.mLastName;
        this.mMiddleName = instance.mMiddleName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessCreditCardLegacy> getParser() {
        return new APIRequest.ResponseParser<BusinessCreditCardLegacy>(){

            @Override
            public APINodeList<BusinessCreditCardLegacy> parseResponse(String response, APIContext context, APIRequest<BusinessCreditCardLegacy> request, String header) throws APIException.MalformedResponseException {
                return BusinessCreditCardLegacy.parseResponse(response, context, request, header);
            }
        };
    }
}

