/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.ProfilePictureSource;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInvitableFriend
extends APINode {
    @SerializedName(value="first_name")
    private String mFirstName = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="last_name")
    private String mLastName = null;
    @SerializedName(value="middle_name")
    private String mMiddleName = null;
    @SerializedName(value="name")
    private String mName = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static UserInvitableFriend loadJSON(String json, APIContext context, String header) {
        UserInvitableFriend userInvitableFriend = (UserInvitableFriend)UserInvitableFriend.getGson().fromJson(json, UserInvitableFriend.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(userInvitableFriend.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        userInvitableFriend.context = context;
        userInvitableFriend.rawValue = json;
        userInvitableFriend.header = header;
        return userInvitableFriend;
    }

    public static APINodeList<UserInvitableFriend> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<UserInvitableFriend> userInvitableFriends = new APINodeList<UserInvitableFriend>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        userInvitableFriends.add(UserInvitableFriend.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return userInvitableFriends;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            userInvitableFriends.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        userInvitableFriends.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            userInvitableFriends.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            userInvitableFriends.add(UserInvitableFriend.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                userInvitableFriends.add(UserInvitableFriend.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            userInvitableFriends.add(UserInvitableFriend.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return userInvitableFriends;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        userInvitableFriends.add(UserInvitableFriend.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return userInvitableFriends;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        userInvitableFriends.add(UserInvitableFriend.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return userInvitableFriends;
                }
                userInvitableFriends.clear();
                userInvitableFriends.add(UserInvitableFriend.loadJSON(json, context, header));
                return userInvitableFriends;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return UserInvitableFriend.getGson().toJson((Object)this);
    }

    public APIRequestGetPicture getPicture() {
        return new APIRequestGetPicture(this.getId(), this.context);
    }

    public String getFieldFirstName() {
        return this.mFirstName;
    }

    public UserInvitableFriend setFieldFirstName(String value) {
        this.mFirstName = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public UserInvitableFriend setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldLastName() {
        return this.mLastName;
    }

    public UserInvitableFriend setFieldLastName(String value) {
        this.mLastName = value;
        return this;
    }

    public String getFieldMiddleName() {
        return this.mMiddleName;
    }

    public UserInvitableFriend setFieldMiddleName(String value) {
        this.mMiddleName = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public UserInvitableFriend setFieldName(String value) {
        this.mName = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public UserInvitableFriend copyFrom(UserInvitableFriend instance) {
        this.mFirstName = instance.mFirstName;
        this.mId = instance.mId;
        this.mLastName = instance.mLastName;
        this.mMiddleName = instance.mMiddleName;
        this.mName = instance.mName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<UserInvitableFriend> getParser() {
        return new APIRequest.ResponseParser<UserInvitableFriend>(){

            @Override
            public APINodeList<UserInvitableFriend> parseResponse(String response, APIContext context, APIRequest<UserInvitableFriend> request, String header) throws APIException.MalformedResponseException {
                return UserInvitableFriend.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPicture
    extends APIRequest<ProfilePictureSource> {
        APINodeList<ProfilePictureSource> lastResponse = null;
        public static final String[] PARAMS = new String[]{"height", "width", "type", "redirect"};
        public static final String[] FIELDS = new String[]{"bottom", "cache_key", "height", "is_silhouette", "left", "right", "top", "url", "width"};

        @Override
        public APINodeList<ProfilePictureSource> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ProfilePictureSource> parseResponse(String response, String header) throws APIException {
            return ProfilePictureSource.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<ProfilePictureSource> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ProfilePictureSource> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ProfilePictureSource>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ProfilePictureSource>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<ProfilePictureSource>>(){

                public APINodeList<ProfilePictureSource> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetPicture.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPicture(String nodeId, APIContext context) {
            super(context, nodeId, "/picture", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPicture setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPicture setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPicture setHeight(Long height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestGetPicture setHeight(String height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestGetPicture setWidth(Long width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestGetPicture setWidth(String width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestGetPicture setType(ProfilePictureSource.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetPicture setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetPicture setRedirect(Boolean redirect) {
            this.setParam("redirect", redirect);
            return this;
        }

        public APIRequestGetPicture setRedirect(String redirect) {
            this.setParam("redirect", redirect);
            return this;
        }

        public APIRequestGetPicture requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPicture requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPicture requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPicture requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPicture requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPicture requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPicture requestBottomField() {
            return this.requestBottomField(true);
        }

        public APIRequestGetPicture requestBottomField(boolean value) {
            this.requestField("bottom", value);
            return this;
        }

        public APIRequestGetPicture requestCacheKeyField() {
            return this.requestCacheKeyField(true);
        }

        public APIRequestGetPicture requestCacheKeyField(boolean value) {
            this.requestField("cache_key", value);
            return this;
        }

        public APIRequestGetPicture requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGetPicture requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGetPicture requestIsSilhouetteField() {
            return this.requestIsSilhouetteField(true);
        }

        public APIRequestGetPicture requestIsSilhouetteField(boolean value) {
            this.requestField("is_silhouette", value);
            return this;
        }

        public APIRequestGetPicture requestLeftField() {
            return this.requestLeftField(true);
        }

        public APIRequestGetPicture requestLeftField(boolean value) {
            this.requestField("left", value);
            return this;
        }

        public APIRequestGetPicture requestRightField() {
            return this.requestRightField(true);
        }

        public APIRequestGetPicture requestRightField(boolean value) {
            this.requestField("right", value);
            return this;
        }

        public APIRequestGetPicture requestTopField() {
            return this.requestTopField(true);
        }

        public APIRequestGetPicture requestTopField(boolean value) {
            this.requestField("top", value);
            return this;
        }

        public APIRequestGetPicture requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGetPicture requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGetPicture requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGetPicture requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }
    }
}

