/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.InstantArticleInsightsQueryResult;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantArticle
extends APINode {
    @SerializedName(value="canonical_url")
    private String mCanonicalUrl = null;
    @SerializedName(value="development_mode")
    private Boolean mDevelopmentMode = null;
    @SerializedName(value="html_source")
    private String mHtmlSource = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="most_recent_import_status")
    private Object mMostRecentImportStatus = null;
    @SerializedName(value="photos")
    private List<Object> mPhotos = null;
    @SerializedName(value="publish_status")
    private String mPublishStatus = null;
    @SerializedName(value="published")
    private Boolean mPublished = null;
    @SerializedName(value="videos")
    private List<Object> mVideos = null;
    protected static Gson gson = null;

    InstantArticle() {
    }

    public InstantArticle(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public InstantArticle(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public InstantArticle fetch() throws APIException {
        InstantArticle newInstance = InstantArticle.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static InstantArticle fetchById(Long id, APIContext context) throws APIException {
        return InstantArticle.fetchById(id.toString(), context);
    }

    public static ListenableFuture<InstantArticle> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return InstantArticle.fetchByIdAsync(id.toString(), context);
    }

    public static InstantArticle fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<InstantArticle> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<InstantArticle> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<InstantArticle>(context, "", "/", "GET", InstantArticle.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<InstantArticle>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<InstantArticle>(context, "", "/", "GET", InstantArticle.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static InstantArticle loadJSON(String json, APIContext context, String header) {
        InstantArticle instantArticle = (InstantArticle)InstantArticle.getGson().fromJson(json, InstantArticle.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(instantArticle.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        instantArticle.context = context;
        instantArticle.rawValue = json;
        instantArticle.header = header;
        return instantArticle;
    }

    public static APINodeList<InstantArticle> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<InstantArticle> instantArticles = new APINodeList<InstantArticle>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        instantArticles.add(InstantArticle.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return instantArticles;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            instantArticles.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        instantArticles.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            instantArticles.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            instantArticles.add(InstantArticle.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                instantArticles.add(InstantArticle.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            instantArticles.add(InstantArticle.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return instantArticles;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        instantArticles.add(InstantArticle.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return instantArticles;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        instantArticles.add(InstantArticle.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return instantArticles;
                }
                instantArticles.clear();
                instantArticles.add(InstantArticle.loadJSON(json, context, header));
                return instantArticles;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return InstantArticle.getGson().toJson((Object)this);
    }

    public APIRequestGetInsights getInsights() {
        return new APIRequestGetInsights(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCanonicalUrl() {
        return this.mCanonicalUrl;
    }

    public Boolean getFieldDevelopmentMode() {
        return this.mDevelopmentMode;
    }

    public String getFieldHtmlSource() {
        return this.mHtmlSource;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Object getFieldMostRecentImportStatus() {
        return this.mMostRecentImportStatus;
    }

    public List<Object> getFieldPhotos() {
        return this.mPhotos;
    }

    public String getFieldPublishStatus() {
        return this.mPublishStatus;
    }

    public Boolean getFieldPublished() {
        return this.mPublished;
    }

    public List<Object> getFieldVideos() {
        return this.mVideos;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public InstantArticle copyFrom(InstantArticle instance) {
        this.mCanonicalUrl = instance.mCanonicalUrl;
        this.mDevelopmentMode = instance.mDevelopmentMode;
        this.mHtmlSource = instance.mHtmlSource;
        this.mId = instance.mId;
        this.mMostRecentImportStatus = instance.mMostRecentImportStatus;
        this.mPhotos = instance.mPhotos;
        this.mPublishStatus = instance.mPublishStatus;
        this.mPublished = instance.mPublished;
        this.mVideos = instance.mVideos;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<InstantArticle> getParser() {
        return new APIRequest.ResponseParser<InstantArticle>(){

            @Override
            public APINodeList<InstantArticle> parseResponse(String response, APIContext context, APIRequest<InstantArticle> request, String header) throws APIException.MalformedResponseException {
                return InstantArticle.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<InstantArticle> {
        InstantArticle lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"canonical_url", "development_mode", "html_source", "id", "most_recent_import_status", "photos", "publish_status", "published", "videos"};

        @Override
        public InstantArticle getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public InstantArticle parseResponse(String response, String header) throws APIException {
            return InstantArticle.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public InstantArticle execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public InstantArticle execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<InstantArticle> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<InstantArticle> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, InstantArticle>(){

                public InstantArticle apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCanonicalUrlField() {
            return this.requestCanonicalUrlField(true);
        }

        public APIRequestGet requestCanonicalUrlField(boolean value) {
            this.requestField("canonical_url", value);
            return this;
        }

        public APIRequestGet requestDevelopmentModeField() {
            return this.requestDevelopmentModeField(true);
        }

        public APIRequestGet requestDevelopmentModeField(boolean value) {
            this.requestField("development_mode", value);
            return this;
        }

        public APIRequestGet requestHtmlSourceField() {
            return this.requestHtmlSourceField(true);
        }

        public APIRequestGet requestHtmlSourceField(boolean value) {
            this.requestField("html_source", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestMostRecentImportStatusField() {
            return this.requestMostRecentImportStatusField(true);
        }

        public APIRequestGet requestMostRecentImportStatusField(boolean value) {
            this.requestField("most_recent_import_status", value);
            return this;
        }

        public APIRequestGet requestPhotosField() {
            return this.requestPhotosField(true);
        }

        public APIRequestGet requestPhotosField(boolean value) {
            this.requestField("photos", value);
            return this;
        }

        public APIRequestGet requestPublishStatusField() {
            return this.requestPublishStatusField(true);
        }

        public APIRequestGet requestPublishStatusField(boolean value) {
            this.requestField("publish_status", value);
            return this;
        }

        public APIRequestGet requestPublishedField() {
            return this.requestPublishedField(true);
        }

        public APIRequestGet requestPublishedField(boolean value) {
            this.requestField("published", value);
            return this;
        }

        public APIRequestGet requestVideosField() {
            return this.requestVideosField(true);
        }

        public APIRequestGet requestVideosField(boolean value) {
            this.requestField("videos", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetInsights
    extends APIRequest<InstantArticleInsightsQueryResult> {
        APINodeList<InstantArticleInsightsQueryResult> lastResponse = null;
        public static final String[] PARAMS = new String[]{"metric", "period", "since", "until", "breakdown"};
        public static final String[] FIELDS = new String[]{"breakdowns", "name", "time", "value"};

        @Override
        public APINodeList<InstantArticleInsightsQueryResult> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<InstantArticleInsightsQueryResult> parseResponse(String response, String header) throws APIException {
            return InstantArticleInsightsQueryResult.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<InstantArticleInsightsQueryResult> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<InstantArticleInsightsQueryResult> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<InstantArticleInsightsQueryResult>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<InstantArticleInsightsQueryResult>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<InstantArticleInsightsQueryResult>>(){

                public APINodeList<InstantArticleInsightsQueryResult> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetInsights.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetInsights(String nodeId, APIContext context) {
            super(context, nodeId, "/insights", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetInsights setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInsights setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInsights setMetric(List<Object> metric) {
            this.setParam("metric", metric);
            return this;
        }

        public APIRequestGetInsights setMetric(String metric) {
            this.setParam("metric", metric);
            return this;
        }

        public APIRequestGetInsights setPeriod(InstantArticleInsightsQueryResult.EnumPeriod period) {
            this.setParam("period", (Object)period);
            return this;
        }

        public APIRequestGetInsights setPeriod(String period) {
            this.setParam("period", period);
            return this;
        }

        public APIRequestGetInsights setSince(String since) {
            this.setParam("since", since);
            return this;
        }

        public APIRequestGetInsights setUntil(String until) {
            this.setParam("until", until);
            return this;
        }

        public APIRequestGetInsights setBreakdown(InstantArticleInsightsQueryResult.EnumBreakdown breakdown) {
            this.setParam("breakdown", (Object)breakdown);
            return this;
        }

        public APIRequestGetInsights setBreakdown(String breakdown) {
            this.setParam("breakdown", breakdown);
            return this;
        }

        public APIRequestGetInsights requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInsights requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetInsights requestBreakdownsField() {
            return this.requestBreakdownsField(true);
        }

        public APIRequestGetInsights requestBreakdownsField(boolean value) {
            this.requestField("breakdowns", value);
            return this;
        }

        public APIRequestGetInsights requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetInsights requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetInsights requestTimeField() {
            return this.requestTimeField(true);
        }

        public APIRequestGetInsights requestTimeField(boolean value) {
            this.requestField("time", value);
            return this;
        }

        public APIRequestGetInsights requestValueField() {
            return this.requestValueField(true);
        }

        public APIRequestGetInsights requestValueField(boolean value) {
            this.requestField("value", value);
            return this;
        }
    }
}

