/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.User;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductCatalogUserPermissions
extends APINode {
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="business_persona")
    private Object mBusinessPersona = null;
    @SerializedName(value="created_by")
    private User mCreatedBy = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="email")
    private String mEmail = null;
    @SerializedName(value="role")
    private String mRole = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="updated_by")
    private User mUpdatedBy = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="user")
    private User mUser = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProductCatalogUserPermissions loadJSON(String json, APIContext context) {
        ProductCatalogUserPermissions productCatalogUserPermissions = (ProductCatalogUserPermissions)ProductCatalogUserPermissions.getGson().fromJson(json, ProductCatalogUserPermissions.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productCatalogUserPermissions.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productCatalogUserPermissions.context = context;
        productCatalogUserPermissions.rawValue = json;
        return productCatalogUserPermissions;
    }

    public static APINodeList<ProductCatalogUserPermissions> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductCatalogUserPermissions> productCatalogUserPermissionss = new APINodeList<ProductCatalogUserPermissions>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productCatalogUserPermissionss.add(ProductCatalogUserPermissions.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return productCatalogUserPermissionss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productCatalogUserPermissionss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productCatalogUserPermissionss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productCatalogUserPermissionss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productCatalogUserPermissionss.add(ProductCatalogUserPermissions.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productCatalogUserPermissionss.add(ProductCatalogUserPermissions.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productCatalogUserPermissionss.add(ProductCatalogUserPermissions.loadJSON(obj.toString(), context));
                        }
                    }
                    return productCatalogUserPermissionss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productCatalogUserPermissionss.add(ProductCatalogUserPermissions.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return productCatalogUserPermissionss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productCatalogUserPermissionss.add(ProductCatalogUserPermissions.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productCatalogUserPermissionss;
                }
                productCatalogUserPermissionss.clear();
                productCatalogUserPermissionss.add(ProductCatalogUserPermissions.loadJSON(json, context));
                return productCatalogUserPermissionss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductCatalogUserPermissions.getGson().toJson((Object)this);
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public ProductCatalogUserPermissions setFieldBusiness(Business value) {
        this.mBusiness = value;
        return this;
    }

    public ProductCatalogUserPermissions setFieldBusiness(String value) {
        Type type = new TypeToken<Business>(){}.getType();
        this.mBusiness = (Business)Business.getGson().fromJson(value, type);
        return this;
    }

    public Object getFieldBusinessPersona() {
        return this.mBusinessPersona;
    }

    public ProductCatalogUserPermissions setFieldBusinessPersona(Object value) {
        this.mBusinessPersona = value;
        return this;
    }

    public User getFieldCreatedBy() {
        if (this.mCreatedBy != null) {
            this.mCreatedBy.context = this.getContext();
        }
        return this.mCreatedBy;
    }

    public ProductCatalogUserPermissions setFieldCreatedBy(User value) {
        this.mCreatedBy = value;
        return this;
    }

    public ProductCatalogUserPermissions setFieldCreatedBy(String value) {
        Type type = new TypeToken<User>(){}.getType();
        this.mCreatedBy = (User)User.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public ProductCatalogUserPermissions setFieldCreatedTime(String value) {
        this.mCreatedTime = value;
        return this;
    }

    public String getFieldEmail() {
        return this.mEmail;
    }

    public ProductCatalogUserPermissions setFieldEmail(String value) {
        this.mEmail = value;
        return this;
    }

    public String getFieldRole() {
        return this.mRole;
    }

    public ProductCatalogUserPermissions setFieldRole(String value) {
        this.mRole = value;
        return this;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public ProductCatalogUserPermissions setFieldStatus(String value) {
        this.mStatus = value;
        return this;
    }

    public User getFieldUpdatedBy() {
        if (this.mUpdatedBy != null) {
            this.mUpdatedBy.context = this.getContext();
        }
        return this.mUpdatedBy;
    }

    public ProductCatalogUserPermissions setFieldUpdatedBy(User value) {
        this.mUpdatedBy = value;
        return this;
    }

    public ProductCatalogUserPermissions setFieldUpdatedBy(String value) {
        Type type = new TypeToken<User>(){}.getType();
        this.mUpdatedBy = (User)User.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public ProductCatalogUserPermissions setFieldUpdatedTime(String value) {
        this.mUpdatedTime = value;
        return this;
    }

    public User getFieldUser() {
        if (this.mUser != null) {
            this.mUser.context = this.getContext();
        }
        return this.mUser;
    }

    public ProductCatalogUserPermissions setFieldUser(User value) {
        this.mUser = value;
        return this;
    }

    public ProductCatalogUserPermissions setFieldUser(String value) {
        Type type = new TypeToken<User>(){}.getType();
        this.mUser = (User)User.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public ProductCatalogUserPermissions setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductCatalogUserPermissions copyFrom(ProductCatalogUserPermissions instance) {
        this.mBusiness = instance.mBusiness;
        this.mBusinessPersona = instance.mBusinessPersona;
        this.mCreatedBy = instance.mCreatedBy;
        this.mCreatedTime = instance.mCreatedTime;
        this.mEmail = instance.mEmail;
        this.mRole = instance.mRole;
        this.mStatus = instance.mStatus;
        this.mUpdatedBy = instance.mUpdatedBy;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mUser = instance.mUser;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductCatalogUserPermissions> getParser() {
        return new APIRequest.ResponseParser<ProductCatalogUserPermissions>(){

            @Override
            public APINodeList<ProductCatalogUserPermissions> parseResponse(String response, APIContext context, APIRequest<ProductCatalogUserPermissions> request) throws APIException.MalformedResponseException {
                return ProductCatalogUserPermissions.parseResponse(response, context, request);
            }
        };
    }
}

