/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductCatalogFacets
extends APINode {
    @SerializedName(value="facets")
    private List<Object> mFacets = null;
    @SerializedName(value="item_count")
    private Long mItemCount = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProductCatalogFacets loadJSON(String json, APIContext context) {
        ProductCatalogFacets productCatalogFacets = (ProductCatalogFacets)ProductCatalogFacets.getGson().fromJson(json, ProductCatalogFacets.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productCatalogFacets.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productCatalogFacets.context = context;
        productCatalogFacets.rawValue = json;
        return productCatalogFacets;
    }

    public static APINodeList<ProductCatalogFacets> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductCatalogFacets> productCatalogFacetss = new APINodeList<ProductCatalogFacets>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productCatalogFacetss.add(ProductCatalogFacets.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return productCatalogFacetss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productCatalogFacetss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productCatalogFacetss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productCatalogFacetss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productCatalogFacetss.add(ProductCatalogFacets.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productCatalogFacetss.add(ProductCatalogFacets.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productCatalogFacetss.add(ProductCatalogFacets.loadJSON(obj.toString(), context));
                        }
                    }
                    return productCatalogFacetss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productCatalogFacetss.add(ProductCatalogFacets.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return productCatalogFacetss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productCatalogFacetss.add(ProductCatalogFacets.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productCatalogFacetss;
                }
                productCatalogFacetss.clear();
                productCatalogFacetss.add(ProductCatalogFacets.loadJSON(json, context));
                return productCatalogFacetss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductCatalogFacets.getGson().toJson((Object)this);
    }

    public List<Object> getFieldFacets() {
        return this.mFacets;
    }

    public ProductCatalogFacets setFieldFacets(List<Object> value) {
        this.mFacets = value;
        return this;
    }

    public Long getFieldItemCount() {
        return this.mItemCount;
    }

    public ProductCatalogFacets setFieldItemCount(Long value) {
        this.mItemCount = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public ProductCatalogFacets setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductCatalogFacets copyFrom(ProductCatalogFacets instance) {
        this.mFacets = instance.mFacets;
        this.mItemCount = instance.mItemCount;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductCatalogFacets> getParser() {
        return new APIRequest.ResponseParser<ProductCatalogFacets>(){

            @Override
            public APINodeList<ProductCatalogFacets> parseResponse(String response, APIContext context, APIRequest<ProductCatalogFacets> request) throws APIException.MalformedResponseException {
                return ProductCatalogFacets.parseResponse(response, context, request);
            }
        };
    }
}

