/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.NativeOfferDiscount;
import com.facebook.ads.sdk.NativeOfferView;
import com.facebook.ads.sdk.Page;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeOffer
extends APINode {
    @SerializedName(value="barcode_photo")
    private String mBarcodePhoto = null;
    @SerializedName(value="barcode_photo_uri")
    private String mBarcodePhotoUri = null;
    @SerializedName(value="barcode_type")
    private String mBarcodeType = null;
    @SerializedName(value="barcode_value")
    private String mBarcodeValue = null;
    @SerializedName(value="block_reshares")
    private Boolean mBlockReshares = null;
    @SerializedName(value="details")
    private String mDetails = null;
    @SerializedName(value="disable_location")
    private Boolean mDisableLocation = null;
    @SerializedName(value="discounts")
    private List<NativeOfferDiscount> mDiscounts = null;
    @SerializedName(value="expiration_time")
    private String mExpirationTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="instore_code")
    private String mInstoreCode = null;
    @SerializedName(value="location_type")
    private String mLocationType = null;
    @SerializedName(value="max_save_count")
    private Long mMaxSaveCount = null;
    @SerializedName(value="online_code")
    private String mOnlineCode = null;
    @SerializedName(value="page")
    private Page mPage = null;
    @SerializedName(value="page_set_id")
    private String mPageSetId = null;
    @SerializedName(value="redemption_code")
    private String mRedemptionCode = null;
    @SerializedName(value="redemption_link")
    private String mRedemptionLink = null;
    @SerializedName(value="save_count")
    private Long mSaveCount = null;
    @SerializedName(value="terms")
    private String mTerms = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="total_unique_codes")
    private String mTotalUniqueCodes = null;
    @SerializedName(value="unique_codes")
    private String mUniqueCodes = null;
    @SerializedName(value="unique_codes_file_code_type")
    private String mUniqueCodesFileCodeType = null;
    @SerializedName(value="unique_codes_file_name")
    private String mUniqueCodesFileName = null;
    @SerializedName(value="unique_codes_file_upload_status")
    private String mUniqueCodesFileUploadStatus = null;
    protected static Gson gson = null;

    NativeOffer() {
    }

    public NativeOffer(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public NativeOffer(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public NativeOffer fetch() throws APIException {
        NativeOffer newInstance = NativeOffer.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static NativeOffer fetchById(Long id, APIContext context) throws APIException {
        return NativeOffer.fetchById(id.toString(), context);
    }

    public static ListenableFuture<NativeOffer> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return NativeOffer.fetchByIdAsync(id.toString(), context);
    }

    public static NativeOffer fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<NativeOffer> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<NativeOffer> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<NativeOffer>(context, "", "/", "GET", NativeOffer.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<NativeOffer>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<NativeOffer>(context, "", "/", "GET", NativeOffer.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static NativeOffer loadJSON(String json, APIContext context) {
        NativeOffer nativeOffer = (NativeOffer)NativeOffer.getGson().fromJson(json, NativeOffer.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(nativeOffer.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        nativeOffer.context = context;
        nativeOffer.rawValue = json;
        return nativeOffer;
    }

    public static APINodeList<NativeOffer> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<NativeOffer> nativeOffers = new APINodeList<NativeOffer>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        nativeOffers.add(NativeOffer.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return nativeOffers;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            nativeOffers.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        nativeOffers.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            nativeOffers.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            nativeOffers.add(NativeOffer.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                nativeOffers.add(NativeOffer.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            nativeOffers.add(NativeOffer.loadJSON(obj.toString(), context));
                        }
                    }
                    return nativeOffers;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        nativeOffers.add(NativeOffer.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return nativeOffers;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        nativeOffers.add(NativeOffer.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return nativeOffers;
                }
                nativeOffers.clear();
                nativeOffers.add(NativeOffer.loadJSON(json, context));
                return nativeOffers;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return NativeOffer.getGson().toJson((Object)this);
    }

    public APIRequestCreateCode createCode() {
        return new APIRequestCreateCode(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateNativeOfferView createNativeOfferView() {
        return new APIRequestCreateNativeOfferView(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetViews getViews() {
        return new APIRequestGetViews(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldBarcodePhoto() {
        return this.mBarcodePhoto;
    }

    public String getFieldBarcodePhotoUri() {
        return this.mBarcodePhotoUri;
    }

    public String getFieldBarcodeType() {
        return this.mBarcodeType;
    }

    public String getFieldBarcodeValue() {
        return this.mBarcodeValue;
    }

    public Boolean getFieldBlockReshares() {
        return this.mBlockReshares;
    }

    public String getFieldDetails() {
        return this.mDetails;
    }

    public Boolean getFieldDisableLocation() {
        return this.mDisableLocation;
    }

    public List<NativeOfferDiscount> getFieldDiscounts() {
        return this.mDiscounts;
    }

    public String getFieldExpirationTime() {
        return this.mExpirationTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldInstoreCode() {
        return this.mInstoreCode;
    }

    public String getFieldLocationType() {
        return this.mLocationType;
    }

    public Long getFieldMaxSaveCount() {
        return this.mMaxSaveCount;
    }

    public String getFieldOnlineCode() {
        return this.mOnlineCode;
    }

    public Page getFieldPage() {
        if (this.mPage != null) {
            this.mPage.context = this.getContext();
        }
        return this.mPage;
    }

    public String getFieldPageSetId() {
        return this.mPageSetId;
    }

    public String getFieldRedemptionCode() {
        return this.mRedemptionCode;
    }

    public String getFieldRedemptionLink() {
        return this.mRedemptionLink;
    }

    public Long getFieldSaveCount() {
        return this.mSaveCount;
    }

    public String getFieldTerms() {
        return this.mTerms;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public String getFieldTotalUniqueCodes() {
        return this.mTotalUniqueCodes;
    }

    public String getFieldUniqueCodes() {
        return this.mUniqueCodes;
    }

    public String getFieldUniqueCodesFileCodeType() {
        return this.mUniqueCodesFileCodeType;
    }

    public String getFieldUniqueCodesFileName() {
        return this.mUniqueCodesFileName;
    }

    public String getFieldUniqueCodesFileUploadStatus() {
        return this.mUniqueCodesFileUploadStatus;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public NativeOffer copyFrom(NativeOffer instance) {
        this.mBarcodePhoto = instance.mBarcodePhoto;
        this.mBarcodePhotoUri = instance.mBarcodePhotoUri;
        this.mBarcodeType = instance.mBarcodeType;
        this.mBarcodeValue = instance.mBarcodeValue;
        this.mBlockReshares = instance.mBlockReshares;
        this.mDetails = instance.mDetails;
        this.mDisableLocation = instance.mDisableLocation;
        this.mDiscounts = instance.mDiscounts;
        this.mExpirationTime = instance.mExpirationTime;
        this.mId = instance.mId;
        this.mInstoreCode = instance.mInstoreCode;
        this.mLocationType = instance.mLocationType;
        this.mMaxSaveCount = instance.mMaxSaveCount;
        this.mOnlineCode = instance.mOnlineCode;
        this.mPage = instance.mPage;
        this.mPageSetId = instance.mPageSetId;
        this.mRedemptionCode = instance.mRedemptionCode;
        this.mRedemptionLink = instance.mRedemptionLink;
        this.mSaveCount = instance.mSaveCount;
        this.mTerms = instance.mTerms;
        this.mTitle = instance.mTitle;
        this.mTotalUniqueCodes = instance.mTotalUniqueCodes;
        this.mUniqueCodes = instance.mUniqueCodes;
        this.mUniqueCodesFileCodeType = instance.mUniqueCodesFileCodeType;
        this.mUniqueCodesFileName = instance.mUniqueCodesFileName;
        this.mUniqueCodesFileUploadStatus = instance.mUniqueCodesFileUploadStatus;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<NativeOffer> getParser() {
        return new APIRequest.ResponseParser<NativeOffer>(){

            @Override
            public APINodeList<NativeOffer> parseResponse(String response, APIContext context, APIRequest<NativeOffer> request) throws APIException.MalformedResponseException {
                return NativeOffer.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumLocationType {
        VALUE_ONLINE("online"),
        VALUE_OFFLINE("offline"),
        VALUE_BOTH("both"),
        NULL(null);

        private String value;

        private EnumLocationType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBarcodeType {
        VALUE_CODE128("CODE128"),
        VALUE_CODE128B("CODE128B"),
        VALUE_CODE93("CODE93"),
        VALUE_DATABAR("DATABAR"),
        VALUE_DATABAR_EXPANDED("DATABAR_EXPANDED"),
        VALUE_DATABAR_EXPANDED_STACKED("DATABAR_EXPANDED_STACKED"),
        VALUE_DATABAR_LIMITED("DATABAR_LIMITED"),
        VALUE_DATAMATRIX("DATAMATRIX"),
        VALUE_EAN("EAN"),
        VALUE_PDF417("PDF417"),
        VALUE_QR("QR"),
        VALUE_UPC_A("UPC_A"),
        VALUE_UPC_E("UPC_E"),
        NULL(null);

        private String value;

        private EnumBarcodeType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumUniqueCodesFileCodeType {
        VALUE_DISCOUNT_CODES("discount_codes"),
        VALUE_BARCODES("barcodes"),
        VALUE_ONLINE_DISCOUNT_CODES("online_discount_codes"),
        VALUE_INSTORE_DISCOUNT_CODES("instore_discount_codes"),
        VALUE_INSTORE_BARCODES("instore_barcodes"),
        VALUE_DISCOUNT_AND_BARCODES("discount_and_barcodes"),
        VALUE_DISCOUNT_AND_DISCOUNT("discount_and_discount"),
        NULL(null);

        private String value;

        private EnumUniqueCodesFileCodeType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<NativeOffer> {
        NativeOffer lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"barcode_photo", "barcode_photo_uri", "barcode_type", "barcode_value", "block_reshares", "details", "disable_location", "discounts", "expiration_time", "id", "instore_code", "location_type", "max_save_count", "online_code", "page", "page_set_id", "redemption_code", "redemption_link", "save_count", "terms", "title", "total_unique_codes", "unique_codes", "unique_codes_file_code_type", "unique_codes_file_name", "unique_codes_file_upload_status"};

        @Override
        public NativeOffer getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public NativeOffer parseResponse(String response) throws APIException {
            return NativeOffer.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public NativeOffer execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public NativeOffer execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<NativeOffer> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<NativeOffer> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, NativeOffer>(){

                public NativeOffer apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBarcodePhotoField() {
            return this.requestBarcodePhotoField(true);
        }

        public APIRequestGet requestBarcodePhotoField(boolean value) {
            this.requestField("barcode_photo", value);
            return this;
        }

        public APIRequestGet requestBarcodePhotoUriField() {
            return this.requestBarcodePhotoUriField(true);
        }

        public APIRequestGet requestBarcodePhotoUriField(boolean value) {
            this.requestField("barcode_photo_uri", value);
            return this;
        }

        public APIRequestGet requestBarcodeTypeField() {
            return this.requestBarcodeTypeField(true);
        }

        public APIRequestGet requestBarcodeTypeField(boolean value) {
            this.requestField("barcode_type", value);
            return this;
        }

        public APIRequestGet requestBarcodeValueField() {
            return this.requestBarcodeValueField(true);
        }

        public APIRequestGet requestBarcodeValueField(boolean value) {
            this.requestField("barcode_value", value);
            return this;
        }

        public APIRequestGet requestBlockResharesField() {
            return this.requestBlockResharesField(true);
        }

        public APIRequestGet requestBlockResharesField(boolean value) {
            this.requestField("block_reshares", value);
            return this;
        }

        public APIRequestGet requestDetailsField() {
            return this.requestDetailsField(true);
        }

        public APIRequestGet requestDetailsField(boolean value) {
            this.requestField("details", value);
            return this;
        }

        public APIRequestGet requestDisableLocationField() {
            return this.requestDisableLocationField(true);
        }

        public APIRequestGet requestDisableLocationField(boolean value) {
            this.requestField("disable_location", value);
            return this;
        }

        public APIRequestGet requestDiscountsField() {
            return this.requestDiscountsField(true);
        }

        public APIRequestGet requestDiscountsField(boolean value) {
            this.requestField("discounts", value);
            return this;
        }

        public APIRequestGet requestExpirationTimeField() {
            return this.requestExpirationTimeField(true);
        }

        public APIRequestGet requestExpirationTimeField(boolean value) {
            this.requestField("expiration_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInstoreCodeField() {
            return this.requestInstoreCodeField(true);
        }

        public APIRequestGet requestInstoreCodeField(boolean value) {
            this.requestField("instore_code", value);
            return this;
        }

        public APIRequestGet requestLocationTypeField() {
            return this.requestLocationTypeField(true);
        }

        public APIRequestGet requestLocationTypeField(boolean value) {
            this.requestField("location_type", value);
            return this;
        }

        public APIRequestGet requestMaxSaveCountField() {
            return this.requestMaxSaveCountField(true);
        }

        public APIRequestGet requestMaxSaveCountField(boolean value) {
            this.requestField("max_save_count", value);
            return this;
        }

        public APIRequestGet requestOnlineCodeField() {
            return this.requestOnlineCodeField(true);
        }

        public APIRequestGet requestOnlineCodeField(boolean value) {
            this.requestField("online_code", value);
            return this;
        }

        public APIRequestGet requestPageField() {
            return this.requestPageField(true);
        }

        public APIRequestGet requestPageField(boolean value) {
            this.requestField("page", value);
            return this;
        }

        public APIRequestGet requestPageSetIdField() {
            return this.requestPageSetIdField(true);
        }

        public APIRequestGet requestPageSetIdField(boolean value) {
            this.requestField("page_set_id", value);
            return this;
        }

        public APIRequestGet requestRedemptionCodeField() {
            return this.requestRedemptionCodeField(true);
        }

        public APIRequestGet requestRedemptionCodeField(boolean value) {
            this.requestField("redemption_code", value);
            return this;
        }

        public APIRequestGet requestRedemptionLinkField() {
            return this.requestRedemptionLinkField(true);
        }

        public APIRequestGet requestRedemptionLinkField(boolean value) {
            this.requestField("redemption_link", value);
            return this;
        }

        public APIRequestGet requestSaveCountField() {
            return this.requestSaveCountField(true);
        }

        public APIRequestGet requestSaveCountField(boolean value) {
            this.requestField("save_count", value);
            return this;
        }

        public APIRequestGet requestTermsField() {
            return this.requestTermsField(true);
        }

        public APIRequestGet requestTermsField(boolean value) {
            this.requestField("terms", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGet requestTotalUniqueCodesField() {
            return this.requestTotalUniqueCodesField(true);
        }

        public APIRequestGet requestTotalUniqueCodesField(boolean value) {
            this.requestField("total_unique_codes", value);
            return this;
        }

        public APIRequestGet requestUniqueCodesField() {
            return this.requestUniqueCodesField(true);
        }

        public APIRequestGet requestUniqueCodesField(boolean value) {
            this.requestField("unique_codes", value);
            return this;
        }

        public APIRequestGet requestUniqueCodesFileCodeTypeField() {
            return this.requestUniqueCodesFileCodeTypeField(true);
        }

        public APIRequestGet requestUniqueCodesFileCodeTypeField(boolean value) {
            this.requestField("unique_codes_file_code_type", value);
            return this;
        }

        public APIRequestGet requestUniqueCodesFileNameField() {
            return this.requestUniqueCodesFileNameField(true);
        }

        public APIRequestGet requestUniqueCodesFileNameField(boolean value) {
            this.requestField("unique_codes_file_name", value);
            return this;
        }

        public APIRequestGet requestUniqueCodesFileUploadStatusField() {
            return this.requestUniqueCodesFileUploadStatusField(true);
        }

        public APIRequestGet requestUniqueCodesFileUploadStatusField(boolean value) {
            this.requestField("unique_codes_file_upload_status", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetViews
    extends APIRequest<NativeOfferView> {
        APINodeList<NativeOfferView> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "offer", "save_count"};

        @Override
        public APINodeList<NativeOfferView> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<NativeOfferView> parseResponse(String response) throws APIException {
            return NativeOfferView.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<NativeOfferView> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<NativeOfferView> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<NativeOfferView>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<NativeOfferView>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<NativeOfferView>>(){

                public APINodeList<NativeOfferView> apply(String result) {
                    try {
                        return APIRequestGetViews.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetViews(String nodeId, APIContext context) {
            super(context, nodeId, "/views", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetViews setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetViews setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetViews requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetViews requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetViews requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetViews requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetViews requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetViews requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetViews requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetViews requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetViews requestOfferField() {
            return this.requestOfferField(true);
        }

        public APIRequestGetViews requestOfferField(boolean value) {
            this.requestField("offer", value);
            return this;
        }

        public APIRequestGetViews requestSaveCountField() {
            return this.requestSaveCountField(true);
        }

        public APIRequestGetViews requestSaveCountField(boolean value) {
            this.requestField("save_count", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateNativeOfferView
    extends APIRequest<NativeOffer> {
        NativeOffer lastResponse = null;
        public static final String[] PARAMS = new String[]{"urls", "photos", "ad_account", "ad_image_hashes", "image_crops", "published_ads", "published", "message", "place_data", "deeplinks", "carousel_captions", "carousel_links", "carousel_data", "videos"};
        public static final String[] FIELDS = new String[0];

        @Override
        public NativeOffer getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public NativeOffer parseResponse(String response) throws APIException {
            return NativeOffer.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public NativeOffer execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public NativeOffer execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<NativeOffer> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<NativeOffer> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, NativeOffer>(){

                public NativeOffer apply(String result) {
                    try {
                        return APIRequestCreateNativeOfferView.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateNativeOfferView(String nodeId, APIContext context) {
            super(context, nodeId, "/nativeofferviews", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateNativeOfferView setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateNativeOfferView setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateNativeOfferView setUrls(List<String> urls) {
            this.setParam("urls", urls);
            return this;
        }

        public APIRequestCreateNativeOfferView setUrls(String urls) {
            this.setParam("urls", urls);
            return this;
        }

        public APIRequestCreateNativeOfferView setPhotos(List<String> photos) {
            this.setParam("photos", photos);
            return this;
        }

        public APIRequestCreateNativeOfferView setPhotos(String photos) {
            this.setParam("photos", photos);
            return this;
        }

        public APIRequestCreateNativeOfferView setAdAccount(String adAccount) {
            this.setParam("ad_account", adAccount);
            return this;
        }

        public APIRequestCreateNativeOfferView setAdImageHashes(List<String> adImageHashes) {
            this.setParam("ad_image_hashes", adImageHashes);
            return this;
        }

        public APIRequestCreateNativeOfferView setAdImageHashes(String adImageHashes) {
            this.setParam("ad_image_hashes", adImageHashes);
            return this;
        }

        public APIRequestCreateNativeOfferView setImageCrops(List<Map<String, String>> imageCrops) {
            this.setParam("image_crops", imageCrops);
            return this;
        }

        public APIRequestCreateNativeOfferView setImageCrops(String imageCrops) {
            this.setParam("image_crops", imageCrops);
            return this;
        }

        public APIRequestCreateNativeOfferView setPublishedAds(Boolean publishedAds) {
            this.setParam("published_ads", publishedAds);
            return this;
        }

        public APIRequestCreateNativeOfferView setPublishedAds(String publishedAds) {
            this.setParam("published_ads", publishedAds);
            return this;
        }

        public APIRequestCreateNativeOfferView setPublished(Boolean published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreateNativeOfferView setPublished(String published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreateNativeOfferView setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateNativeOfferView setPlaceData(Object placeData) {
            this.setParam("place_data", placeData);
            return this;
        }

        public APIRequestCreateNativeOfferView setPlaceData(String placeData) {
            this.setParam("place_data", placeData);
            return this;
        }

        public APIRequestCreateNativeOfferView setDeeplinks(List<String> deeplinks) {
            this.setParam("deeplinks", deeplinks);
            return this;
        }

        public APIRequestCreateNativeOfferView setDeeplinks(String deeplinks) {
            this.setParam("deeplinks", deeplinks);
            return this;
        }

        public APIRequestCreateNativeOfferView setCarouselCaptions(List<String> carouselCaptions) {
            this.setParam("carousel_captions", carouselCaptions);
            return this;
        }

        public APIRequestCreateNativeOfferView setCarouselCaptions(String carouselCaptions) {
            this.setParam("carousel_captions", carouselCaptions);
            return this;
        }

        public APIRequestCreateNativeOfferView setCarouselLinks(List<String> carouselLinks) {
            this.setParam("carousel_links", carouselLinks);
            return this;
        }

        public APIRequestCreateNativeOfferView setCarouselLinks(String carouselLinks) {
            this.setParam("carousel_links", carouselLinks);
            return this;
        }

        public APIRequestCreateNativeOfferView setCarouselData(List<Object> carouselData) {
            this.setParam("carousel_data", carouselData);
            return this;
        }

        public APIRequestCreateNativeOfferView setCarouselData(String carouselData) {
            this.setParam("carousel_data", carouselData);
            return this;
        }

        public APIRequestCreateNativeOfferView setVideos(List<String> videos) {
            this.setParam("videos", videos);
            return this;
        }

        public APIRequestCreateNativeOfferView setVideos(String videos) {
            this.setParam("videos", videos);
            return this;
        }

        public APIRequestCreateNativeOfferView requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateNativeOfferView requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateNativeOfferView requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateNativeOfferView requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateNativeOfferView requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateNativeOfferView requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateCode
    extends APIRequest<NativeOffer> {
        NativeOffer lastResponse = null;
        public static final String[] PARAMS = new String[]{"unique_codes_file_code_type", "file"};
        public static final String[] FIELDS = new String[0];

        @Override
        public NativeOffer getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public NativeOffer parseResponse(String response) throws APIException {
            return NativeOffer.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public NativeOffer execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public NativeOffer execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<NativeOffer> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<NativeOffer> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, NativeOffer>(){

                public NativeOffer apply(String result) {
                    try {
                        return APIRequestCreateCode.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateCode(String nodeId, APIContext context) {
            super(context, nodeId, "/codes", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateCode setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateCode setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateCode addUploadFile(String uploadName, File file) {
            this.setParam(uploadName, file);
            return this;
        }

        @Override
        public APIRequestCreateCode setUseVideoEndpoint(boolean useVideoEndpoint) {
            this.useVideoEndpoint = useVideoEndpoint;
            return this;
        }

        public APIRequestCreateCode setUniqueCodesFileCodeType(EnumUniqueCodesFileCodeType uniqueCodesFileCodeType) {
            this.setParam("unique_codes_file_code_type", (Object)uniqueCodesFileCodeType);
            return this;
        }

        public APIRequestCreateCode setUniqueCodesFileCodeType(String uniqueCodesFileCodeType) {
            this.setParam("unique_codes_file_code_type", uniqueCodesFileCodeType);
            return this;
        }

        public APIRequestCreateCode requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateCode requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCode requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateCode requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCode requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateCode requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

