/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildEvent
extends APINode {
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="ticket_uri")
    private String mTicketUri = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ChildEvent loadJSON(String json, APIContext context) {
        ChildEvent childEvent = (ChildEvent)ChildEvent.getGson().fromJson(json, ChildEvent.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(childEvent.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        childEvent.context = context;
        childEvent.rawValue = json;
        return childEvent;
    }

    public static APINodeList<ChildEvent> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ChildEvent> childEvents = new APINodeList<ChildEvent>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        childEvents.add(ChildEvent.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return childEvents;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            childEvents.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        childEvents.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            childEvents.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            childEvents.add(ChildEvent.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                childEvents.add(ChildEvent.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            childEvents.add(ChildEvent.loadJSON(obj.toString(), context));
                        }
                    }
                    return childEvents;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        childEvents.add(ChildEvent.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return childEvents;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        childEvents.add(ChildEvent.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return childEvents;
                }
                childEvents.clear();
                childEvents.add(ChildEvent.loadJSON(json, context));
                return childEvents;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ChildEvent.getGson().toJson((Object)this);
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public ChildEvent setFieldEndTime(String value) {
        this.mEndTime = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public ChildEvent setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public ChildEvent setFieldStartTime(String value) {
        this.mStartTime = value;
        return this;
    }

    public String getFieldTicketUri() {
        return this.mTicketUri;
    }

    public ChildEvent setFieldTicketUri(String value) {
        this.mTicketUri = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ChildEvent copyFrom(ChildEvent instance) {
        this.mEndTime = instance.mEndTime;
        this.mId = instance.mId;
        this.mStartTime = instance.mStartTime;
        this.mTicketUri = instance.mTicketUri;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ChildEvent> getParser() {
        return new APIRequest.ResponseParser<ChildEvent>(){

            @Override
            public APINodeList<ChildEvent> parseResponse(String response, APIContext context, APIRequest<ChildEvent> request) throws APIException.MalformedResponseException {
                return ChildEvent.parseResponse(response, context, request);
            }
        };
    }
}

