/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAssetFeed
extends APINode {
    @SerializedName(value="account")
    private AdAccount mAccount = null;
    @SerializedName(value="ad_formats")
    private List<String> mAdFormats = null;
    @SerializedName(value="additional_data")
    private Object mAdditionalData = null;
    @SerializedName(value="autotranslate")
    private List<String> mAutotranslate = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="optimization_type")
    private String mOptimizationType = null;
    protected static Gson gson = null;

    AdAssetFeed() {
    }

    public AdAssetFeed(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdAssetFeed(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdAssetFeed fetch() throws APIException {
        AdAssetFeed newInstance = AdAssetFeed.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdAssetFeed fetchById(Long id, APIContext context) throws APIException {
        return AdAssetFeed.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdAssetFeed> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdAssetFeed.fetchByIdAsync(id.toString(), context);
    }

    public static AdAssetFeed fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdAssetFeed> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdAssetFeed> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdAssetFeed>(context, "", "/", "GET", AdAssetFeed.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdAssetFeed>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdAssetFeed>(context, "", "/", "GET", AdAssetFeed.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAssetFeed loadJSON(String json, APIContext context) {
        AdAssetFeed adAssetFeed = (AdAssetFeed)AdAssetFeed.getGson().fromJson(json, AdAssetFeed.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAssetFeed.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAssetFeed.context = context;
        adAssetFeed.rawValue = json;
        return adAssetFeed;
    }

    public static APINodeList<AdAssetFeed> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAssetFeed> adAssetFeeds = new APINodeList<AdAssetFeed>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAssetFeeds.add(AdAssetFeed.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adAssetFeeds;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAssetFeeds.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAssetFeeds.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAssetFeeds.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAssetFeeds.add(AdAssetFeed.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAssetFeeds.add(AdAssetFeed.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAssetFeeds.add(AdAssetFeed.loadJSON(obj.toString(), context));
                        }
                    }
                    return adAssetFeeds;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAssetFeeds.add(AdAssetFeed.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adAssetFeeds;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAssetFeeds.add(AdAssetFeed.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAssetFeeds;
                }
                adAssetFeeds.clear();
                adAssetFeeds.add(AdAssetFeed.loadJSON(json, context));
                return adAssetFeeds;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAssetFeed.getGson().toJson((Object)this);
    }

    public APIRequestGetAssetCustomizationRules getAssetCustomizationRules() {
        return new APIRequestGetAssetCustomizationRules(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetBodies getBodies() {
        return new APIRequestGetBodies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetCallToActionTypes getCallToActionTypes() {
        return new APIRequestGetCallToActionTypes(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetCaptions getCaptions() {
        return new APIRequestGetCaptions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetDescriptions getDescriptions() {
        return new APIRequestGetDescriptions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetGroups getGroups() {
        return new APIRequestGetGroups(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetImages getImages() {
        return new APIRequestGetImages(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetLinkUrls getLinkUrls() {
        return new APIRequestGetLinkUrls(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTitles getTitles() {
        return new APIRequestGetTitles(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetVideos getVideos() {
        return new APIRequestGetVideos(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public AdAccount getFieldAccount() {
        if (this.mAccount != null) {
            this.mAccount.context = this.getContext();
        }
        return this.mAccount;
    }

    public List<String> getFieldAdFormats() {
        return this.mAdFormats;
    }

    public Object getFieldAdditionalData() {
        return this.mAdditionalData;
    }

    public List<String> getFieldAutotranslate() {
        return this.mAutotranslate;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldOptimizationType() {
        return this.mOptimizationType;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAssetFeed copyFrom(AdAssetFeed instance) {
        this.mAccount = instance.mAccount;
        this.mAdFormats = instance.mAdFormats;
        this.mAdditionalData = instance.mAdditionalData;
        this.mAutotranslate = instance.mAutotranslate;
        this.mId = instance.mId;
        this.mOptimizationType = instance.mOptimizationType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAssetFeed> getParser() {
        return new APIRequest.ResponseParser<AdAssetFeed>(){

            @Override
            public APINodeList<AdAssetFeed> parseResponse(String response, APIContext context, APIRequest<AdAssetFeed> request) throws APIException.MalformedResponseException {
                return AdAssetFeed.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCallToActionType {
        VALUE_OPEN_LINK("OPEN_LINK"),
        VALUE_LIKE_PAGE("LIKE_PAGE"),
        VALUE_SHOP_NOW("SHOP_NOW"),
        VALUE_PLAY_GAME("PLAY_GAME"),
        VALUE_INSTALL_APP("INSTALL_APP"),
        VALUE_USE_APP("USE_APP"),
        VALUE_CALL("CALL"),
        VALUE_CALL_ME("CALL_ME"),
        VALUE_INSTALL_MOBILE_APP("INSTALL_MOBILE_APP"),
        VALUE_USE_MOBILE_APP("USE_MOBILE_APP"),
        VALUE_MOBILE_DOWNLOAD("MOBILE_DOWNLOAD"),
        VALUE_BOOK_TRAVEL("BOOK_TRAVEL"),
        VALUE_LISTEN_MUSIC("LISTEN_MUSIC"),
        VALUE_WATCH_VIDEO("WATCH_VIDEO"),
        VALUE_LEARN_MORE("LEARN_MORE"),
        VALUE_SIGN_UP("SIGN_UP"),
        VALUE_DOWNLOAD("DOWNLOAD"),
        VALUE_WATCH_MORE("WATCH_MORE"),
        VALUE_NO_BUTTON("NO_BUTTON"),
        VALUE_VISIT_PAGES_FEED("VISIT_PAGES_FEED"),
        VALUE_APPLY_NOW("APPLY_NOW"),
        VALUE_BUY_NOW("BUY_NOW"),
        VALUE_GET_OFFER("GET_OFFER"),
        VALUE_GET_OFFER_VIEW("GET_OFFER_VIEW"),
        VALUE_BUY_TICKETS("BUY_TICKETS"),
        VALUE_UPDATE_APP("UPDATE_APP"),
        VALUE_GET_DIRECTIONS("GET_DIRECTIONS"),
        VALUE_BUY("BUY"),
        VALUE_MESSAGE_PAGE("MESSAGE_PAGE"),
        VALUE_DONATE("DONATE"),
        VALUE_SUBSCRIBE("SUBSCRIBE"),
        VALUE_SAY_THANKS("SAY_THANKS"),
        VALUE_SELL_NOW("SELL_NOW"),
        VALUE_SHARE("SHARE"),
        VALUE_DONATE_NOW("DONATE_NOW"),
        VALUE_GET_QUOTE("GET_QUOTE"),
        VALUE_CONTACT_US("CONTACT_US"),
        VALUE_ORDER_NOW("ORDER_NOW"),
        VALUE_ADD_TO_CART("ADD_TO_CART"),
        VALUE_VIDEO_ANNOTATION("VIDEO_ANNOTATION"),
        VALUE_MOMENTS("MOMENTS"),
        VALUE_RECORD_NOW("RECORD_NOW"),
        VALUE_GET_SHOWTIMES("GET_SHOWTIMES"),
        VALUE_LISTEN_NOW("LISTEN_NOW"),
        VALUE_WOODHENGE_SUPPORT("WOODHENGE_SUPPORT"),
        VALUE_EVENT_RSVP("EVENT_RSVP"),
        VALUE_WHATSAPP_MESSAGE("WHATSAPP_MESSAGE"),
        VALUE_FOLLOW_NEWS_STORYLINE("FOLLOW_NEWS_STORYLINE"),
        NULL(null);

        private String value;

        private EnumCallToActionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOptimizationType {
        VALUE_REGULAR("REGULAR"),
        VALUE_LANGUAGE("LANGUAGE"),
        VALUE_PLACEMENT("PLACEMENT"),
        VALUE_VIDEO_BANDWIDTH("VIDEO_BANDWIDTH"),
        VALUE_BRAND("BRAND"),
        VALUE_ASSET_CUSTOMIZATION("ASSET_CUSTOMIZATION"),
        VALUE_DCO_PARITY("DCO_PARITY"),
        VALUE_PREVIEW_DYNAMIC_RENDERING("PREVIEW_DYNAMIC_RENDERING"),
        NULL(null);

        private String value;

        private EnumOptimizationType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCallToActionTypes {
        VALUE_OPEN_LINK("OPEN_LINK"),
        VALUE_LIKE_PAGE("LIKE_PAGE"),
        VALUE_SHOP_NOW("SHOP_NOW"),
        VALUE_PLAY_GAME("PLAY_GAME"),
        VALUE_INSTALL_APP("INSTALL_APP"),
        VALUE_USE_APP("USE_APP"),
        VALUE_CALL("CALL"),
        VALUE_CALL_ME("CALL_ME"),
        VALUE_INSTALL_MOBILE_APP("INSTALL_MOBILE_APP"),
        VALUE_USE_MOBILE_APP("USE_MOBILE_APP"),
        VALUE_MOBILE_DOWNLOAD("MOBILE_DOWNLOAD"),
        VALUE_BOOK_TRAVEL("BOOK_TRAVEL"),
        VALUE_LISTEN_MUSIC("LISTEN_MUSIC"),
        VALUE_WATCH_VIDEO("WATCH_VIDEO"),
        VALUE_LEARN_MORE("LEARN_MORE"),
        VALUE_SIGN_UP("SIGN_UP"),
        VALUE_DOWNLOAD("DOWNLOAD"),
        VALUE_WATCH_MORE("WATCH_MORE"),
        VALUE_NO_BUTTON("NO_BUTTON"),
        VALUE_VISIT_PAGES_FEED("VISIT_PAGES_FEED"),
        VALUE_APPLY_NOW("APPLY_NOW"),
        VALUE_BUY_NOW("BUY_NOW"),
        VALUE_GET_OFFER("GET_OFFER"),
        VALUE_GET_OFFER_VIEW("GET_OFFER_VIEW"),
        VALUE_BUY_TICKETS("BUY_TICKETS"),
        VALUE_UPDATE_APP("UPDATE_APP"),
        VALUE_GET_DIRECTIONS("GET_DIRECTIONS"),
        VALUE_BUY("BUY"),
        VALUE_MESSAGE_PAGE("MESSAGE_PAGE"),
        VALUE_DONATE("DONATE"),
        VALUE_SUBSCRIBE("SUBSCRIBE"),
        VALUE_SAY_THANKS("SAY_THANKS"),
        VALUE_SELL_NOW("SELL_NOW"),
        VALUE_SHARE("SHARE"),
        VALUE_DONATE_NOW("DONATE_NOW"),
        VALUE_GET_QUOTE("GET_QUOTE"),
        VALUE_CONTACT_US("CONTACT_US"),
        VALUE_ORDER_NOW("ORDER_NOW"),
        VALUE_ADD_TO_CART("ADD_TO_CART"),
        VALUE_VIDEO_ANNOTATION("VIDEO_ANNOTATION"),
        VALUE_MOMENTS("MOMENTS"),
        VALUE_RECORD_NOW("RECORD_NOW"),
        VALUE_GET_SHOWTIMES("GET_SHOWTIMES"),
        VALUE_LISTEN_NOW("LISTEN_NOW"),
        VALUE_WOODHENGE_SUPPORT("WOODHENGE_SUPPORT"),
        VALUE_EVENT_RSVP("EVENT_RSVP"),
        VALUE_WHATSAPP_MESSAGE("WHATSAPP_MESSAGE"),
        VALUE_FOLLOW_NEWS_STORYLINE("FOLLOW_NEWS_STORYLINE"),
        NULL(null);

        private String value;

        private EnumCallToActionTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumAdFormats {
        VALUE_AUTOMATIC_FORMAT("AUTOMATIC_FORMAT"),
        VALUE_CAROUSEL_IMAGE("CAROUSEL_IMAGE"),
        VALUE_CAROUSEL_VIDEO("CAROUSEL_VIDEO"),
        VALUE_SINGLE_IMAGE("SINGLE_IMAGE"),
        VALUE_SINGLE_VIDEO("SINGLE_VIDEO"),
        NULL(null);

        private String value;

        private EnumAdFormats(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdAssetFeed> {
        AdAssetFeed lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account", "ad_formats", "additional_data", "autotranslate", "id", "optimization_type"};

        @Override
        public AdAssetFeed getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAssetFeed parseResponse(String response) throws APIException {
            return AdAssetFeed.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAssetFeed execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAssetFeed execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAssetFeed> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAssetFeed> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAssetFeed>(){

                public AdAssetFeed apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountField() {
            return this.requestAccountField(true);
        }

        public APIRequestGet requestAccountField(boolean value) {
            this.requestField("account", value);
            return this;
        }

        public APIRequestGet requestAdFormatsField() {
            return this.requestAdFormatsField(true);
        }

        public APIRequestGet requestAdFormatsField(boolean value) {
            this.requestField("ad_formats", value);
            return this;
        }

        public APIRequestGet requestAdditionalDataField() {
            return this.requestAdditionalDataField(true);
        }

        public APIRequestGet requestAdditionalDataField(boolean value) {
            this.requestField("additional_data", value);
            return this;
        }

        public APIRequestGet requestAutotranslateField() {
            return this.requestAutotranslateField(true);
        }

        public APIRequestGet requestAutotranslateField(boolean value) {
            this.requestField("autotranslate", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestOptimizationTypeField() {
            return this.requestOptimizationTypeField(true);
        }

        public APIRequestGet requestOptimizationTypeField(boolean value) {
            this.requestField("optimization_type", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetVideos
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestGetVideos.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetVideos(String nodeId, APIContext context) {
            super(context, nodeId, "/videos", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetVideos setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetVideos setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetVideos requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetVideos requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideos requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetVideos requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideos requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetVideos requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetTitles
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestGetTitles.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetTitles(String nodeId, APIContext context) {
            super(context, nodeId, "/titles", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTitles setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTitles setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTitles requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTitles requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTitles requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTitles requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTitles requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTitles requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetLinkUrls
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestGetLinkUrls.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetLinkUrls(String nodeId, APIContext context) {
            super(context, nodeId, "/link_urls", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetLinkUrls setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetLinkUrls setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetLinkUrls requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetLinkUrls requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLinkUrls requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetLinkUrls requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLinkUrls requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetLinkUrls requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetImages
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestGetImages.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetImages(String nodeId, APIContext context) {
            super(context, nodeId, "/images", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetImages setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetImages setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetImages requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetImages requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetImages requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetImages requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetImages requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetImages requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetGroups
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestGetGroups.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetGroups(String nodeId, APIContext context) {
            super(context, nodeId, "/groups", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetGroups setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetGroups setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetGroups requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetGroups requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetGroups requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetGroups requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetGroups requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetGroups requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetDescriptions
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestGetDescriptions.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetDescriptions(String nodeId, APIContext context) {
            super(context, nodeId, "/descriptions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetDescriptions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetDescriptions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetDescriptions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetDescriptions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDescriptions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetDescriptions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDescriptions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetDescriptions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetCaptions
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestGetCaptions.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetCaptions(String nodeId, APIContext context) {
            super(context, nodeId, "/captions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCaptions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCaptions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCaptions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCaptions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCaptions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCaptions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCaptions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCaptions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetCallToActionTypes
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestGetCallToActionTypes.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetCallToActionTypes(String nodeId, APIContext context) {
            super(context, nodeId, "/call_to_action_types", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCallToActionTypes setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCallToActionTypes setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCallToActionTypes requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCallToActionTypes requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCallToActionTypes requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCallToActionTypes requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCallToActionTypes requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCallToActionTypes requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetBodies
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestGetBodies.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetBodies(String nodeId, APIContext context) {
            super(context, nodeId, "/bodies", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetBodies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetBodies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetBodies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetBodies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBodies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetBodies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBodies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetBodies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAssetCustomizationRules
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestGetAssetCustomizationRules.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAssetCustomizationRules(String nodeId, APIContext context) {
            super(context, nodeId, "/asset_customization_rules", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAssetCustomizationRules setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAssetCustomizationRules setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAssetCustomizationRules requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAssetCustomizationRules requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssetCustomizationRules requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAssetCustomizationRules requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssetCustomizationRules requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAssetCustomizationRules requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

