/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Ad;
import com.facebook.ads.sdk.AdAccountAdRulesHistory;
import com.facebook.ads.sdk.AdAccountContextualTargeting;
import com.facebook.ads.sdk.AdAccountCreationRequest;
import com.facebook.ads.sdk.AdAccountCustomAudienceLimits;
import com.facebook.ads.sdk.AdAccountDeliveryEstimate;
import com.facebook.ads.sdk.AdAccountMatchedSearchApplicationsEdgeData;
import com.facebook.ads.sdk.AdAccountMaxBid;
import com.facebook.ads.sdk.AdAccountPromotableObjects;
import com.facebook.ads.sdk.AdAccountRoas;
import com.facebook.ads.sdk.AdAccountTargetingUnified;
import com.facebook.ads.sdk.AdAccountTrackingData;
import com.facebook.ads.sdk.AdAccountUser;
import com.facebook.ads.sdk.AdAccountUserPermissions;
import com.facebook.ads.sdk.AdActivity;
import com.facebook.ads.sdk.AdAssetFeed;
import com.facebook.ads.sdk.AdAsyncRequestSet;
import com.facebook.ads.sdk.AdContract;
import com.facebook.ads.sdk.AdCreative;
import com.facebook.ads.sdk.AdCreativeObjectStorySpec;
import com.facebook.ads.sdk.AdImage;
import com.facebook.ads.sdk.AdLabel;
import com.facebook.ads.sdk.AdPreview;
import com.facebook.ads.sdk.AdReportRun;
import com.facebook.ads.sdk.AdReportSpec;
import com.facebook.ads.sdk.AdRule;
import com.facebook.ads.sdk.AdSet;
import com.facebook.ads.sdk.AdStudy;
import com.facebook.ads.sdk.AdTopline;
import com.facebook.ads.sdk.AdToplineDetail;
import com.facebook.ads.sdk.AdVideo;
import com.facebook.ads.sdk.AdsDataPartner;
import com.facebook.ads.sdk.AdsInsights;
import com.facebook.ads.sdk.AdsPixel;
import com.facebook.ads.sdk.AgencyClientDeclaration;
import com.facebook.ads.sdk.Application;
import com.facebook.ads.sdk.AssignedUser;
import com.facebook.ads.sdk.AsyncRequest;
import com.facebook.ads.sdk.AttributionSpec;
import com.facebook.ads.sdk.BrandAudience;
import com.facebook.ads.sdk.BroadTargetingCategories;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.BusinessActivityLogEvent;
import com.facebook.ads.sdk.BusinessProject;
import com.facebook.ads.sdk.Campaign;
import com.facebook.ads.sdk.CustomAudience;
import com.facebook.ads.sdk.CustomAudiencesTOS;
import com.facebook.ads.sdk.CustomConversion;
import com.facebook.ads.sdk.DeliveryCheck;
import com.facebook.ads.sdk.DirectDeal;
import com.facebook.ads.sdk.EmailImport;
import com.facebook.ads.sdk.ExtendedCreditInvoiceGroup;
import com.facebook.ads.sdk.FundingSourceDetails;
import com.facebook.ads.sdk.InstagramUser;
import com.facebook.ads.sdk.LeadgenForm;
import com.facebook.ads.sdk.MinimumBudget;
import com.facebook.ads.sdk.OfflineConversionDataSet;
import com.facebook.ads.sdk.OffsitePixel;
import com.facebook.ads.sdk.Page;
import com.facebook.ads.sdk.PartnerCategory;
import com.facebook.ads.sdk.PartnerIntegrationLinked;
import com.facebook.ads.sdk.PlayableContent;
import com.facebook.ads.sdk.PublisherBlockList;
import com.facebook.ads.sdk.ReachEstimate;
import com.facebook.ads.sdk.ReachFrequencyPrediction;
import com.facebook.ads.sdk.ReachFrequencySpec;
import com.facebook.ads.sdk.Referral;
import com.facebook.ads.sdk.SavedAudience;
import com.facebook.ads.sdk.Targeting;
import com.facebook.ads.sdk.TargetingSentenceLine;
import com.facebook.ads.sdk.TimezoneOffset;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAccount
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="account_status")
    private Long mAccountStatus = null;
    @SerializedName(value="ad_account_creation_request")
    private AdAccountCreationRequest mAdAccountCreationRequest = null;
    @SerializedName(value="ad_account_promotable_objects")
    private AdAccountPromotableObjects mAdAccountPromotableObjects = null;
    @SerializedName(value="age")
    private Double mAge = null;
    @SerializedName(value="agency_client_declaration")
    private AgencyClientDeclaration mAgencyClientDeclaration = null;
    @SerializedName(value="amount_spent")
    private String mAmountSpent = null;
    @SerializedName(value="attribution_spec")
    private List<AttributionSpec> mAttributionSpec = null;
    @SerializedName(value="balance")
    private String mBalance = null;
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="business_city")
    private String mBusinessCity = null;
    @SerializedName(value="business_country_code")
    private String mBusinessCountryCode = null;
    @SerializedName(value="business_name")
    private String mBusinessName = null;
    @SerializedName(value="business_state")
    private String mBusinessState = null;
    @SerializedName(value="business_street")
    private String mBusinessStreet = null;
    @SerializedName(value="business_street2")
    private String mBusinessStreet2 = null;
    @SerializedName(value="business_zip")
    private String mBusinessZip = null;
    @SerializedName(value="can_create_brand_lift_study")
    private Boolean mCanCreateBrandLiftStudy = null;
    @SerializedName(value="capabilities")
    private List<String> mCapabilities = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="daily_spend_limit")
    private String mDailySpendLimit = null;
    @SerializedName(value="direct_deals_tos_accepted")
    private Boolean mDirectDealsTosAccepted = null;
    @SerializedName(value="disable_reason")
    private Long mDisableReason = null;
    @SerializedName(value="end_advertiser")
    private String mEndAdvertiser = null;
    @SerializedName(value="end_advertiser_name")
    private String mEndAdvertiserName = null;
    @SerializedName(value="extended_credit_invoice_group")
    private ExtendedCreditInvoiceGroup mExtendedCreditInvoiceGroup = null;
    @SerializedName(value="failed_delivery_checks")
    private List<DeliveryCheck> mFailedDeliveryChecks = null;
    @SerializedName(value="funding_source")
    private String mFundingSource = null;
    @SerializedName(value="funding_source_details")
    private FundingSourceDetails mFundingSourceDetails = null;
    @SerializedName(value="has_migrated_permissions")
    private Boolean mHasMigratedPermissions = null;
    @SerializedName(value="has_page_authorized_adaccount")
    private Boolean mHasPageAuthorizedAdaccount = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="io_number")
    private String mIoNumber = null;
    @SerializedName(value="is_attribution_spec_system_default")
    private Boolean mIsAttributionSpecSystemDefault = null;
    @SerializedName(value="is_direct_deals_enabled")
    private Boolean mIsDirectDealsEnabled = null;
    @SerializedName(value="is_in_3ds_authorization_enabled_market")
    private Boolean mIsIn3dsAuthorizationEnabledMarket = null;
    @SerializedName(value="is_in_middle_of_local_entity_migration")
    private Boolean mIsInMiddleOfLocalEntityMigration = null;
    @SerializedName(value="is_notifications_enabled")
    private Boolean mIsNotificationsEnabled = null;
    @SerializedName(value="is_personal")
    private Long mIsPersonal = null;
    @SerializedName(value="is_prepay_account")
    private Boolean mIsPrepayAccount = null;
    @SerializedName(value="is_tax_id_required")
    private Boolean mIsTaxIdRequired = null;
    @SerializedName(value="line_numbers")
    private List<Long> mLineNumbers = null;
    @SerializedName(value="media_agency")
    private String mMediaAgency = null;
    @SerializedName(value="min_campaign_group_spend_cap")
    private String mMinCampaignGroupSpendCap = null;
    @SerializedName(value="min_daily_budget")
    private Long mMinDailyBudget = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="offsite_pixels_tos_accepted")
    private Boolean mOffsitePixelsTosAccepted = null;
    @SerializedName(value="owner")
    private String mOwner = null;
    @SerializedName(value="partner")
    private String mPartner = null;
    @SerializedName(value="rate_limit_reset_time")
    private String mRateLimitResetTime = null;
    @SerializedName(value="rf_spec")
    private ReachFrequencySpec mRfSpec = null;
    @SerializedName(value="show_checkout_experience")
    private Boolean mShowCheckoutExperience = null;
    @SerializedName(value="spend_cap")
    private String mSpendCap = null;
    @SerializedName(value="tax_id")
    private String mTaxId = null;
    @SerializedName(value="tax_id_status")
    private Long mTaxIdStatus = null;
    @SerializedName(value="tax_id_type")
    private String mTaxIdType = null;
    @SerializedName(value="timezone_id")
    private Long mTimezoneId = null;
    @SerializedName(value="timezone_name")
    private String mTimezoneName = null;
    @SerializedName(value="timezone_offset_hours_utc")
    private Double mTimezoneOffsetHoursUtc = null;
    @SerializedName(value="tos_accepted")
    private Map<String, Long> mTosAccepted = null;
    @SerializedName(value="user_role")
    private String mUserRole = null;
    @SerializedName(value="user_tos_accepted")
    private Map<String, Long> mUserTosAccepted = null;
    protected static Gson gson = null;

    AdAccount() {
    }

    public AdAccount(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdAccount(String id, APIContext context) {
        this.mId = id.replaceAll("act_", "");
        this.context = context;
    }

    public AdAccount fetch() throws APIException {
        AdAccount newInstance = AdAccount.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        this.mId = this.mId.replaceAll("act_", "");
        return this;
    }

    public static AdAccount fetchById(Long id, APIContext context) throws APIException {
        return AdAccount.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdAccount> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdAccount.fetchByIdAsync(id.toString(), context);
    }

    public static AdAccount fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdAccount> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdAccount> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdAccount>(context, "", "/", "GET", AdAccount.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdAccount>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdAccount>(context, "", "/", "GET", AdAccount.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return "act_" + this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAccount loadJSON(String json, APIContext context) {
        String accountId;
        JsonParser parser;
        AdAccount adAccount = (AdAccount)AdAccount.getGson().fromJson(json, AdAccount.class);
        if (context.isDebug()) {
            parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAccount.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAccount.context = context;
        adAccount.rawValue = json;
        parser = new JsonParser();
        JsonObject o = parser.parse(json).getAsJsonObject();
        if (o.has("account_id") && (accountId = o.get("account_id").getAsString()) != null) {
            adAccount.mId = accountId;
        }
        if (adAccount.mId != null) {
            adAccount.mId = adAccount.mId.replaceAll("act_", "");
        }
        return adAccount;
    }

    public static APINodeList<AdAccount> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAccount> adAccounts = new APINodeList<AdAccount>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAccounts.add(AdAccount.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adAccounts;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAccounts.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAccounts.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAccounts.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAccounts.add(AdAccount.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAccounts.add(AdAccount.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAccounts.add(AdAccount.loadJSON(obj.toString(), context));
                        }
                    }
                    return adAccounts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAccounts.add(AdAccount.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adAccounts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAccounts.add(AdAccount.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAccounts;
                }
                adAccounts.clear();
                adAccounts.add(AdAccount.loadJSON(json, context));
                return adAccounts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAccount.getGson().toJson((Object)this);
    }

    public APIRequestGetActivities getActivities() {
        return new APIRequestGetActivities(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdStudies getAdStudies() {
        return new APIRequestGetAdStudies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdAssetFeeds getAdAssetFeeds() {
        return new APIRequestGetAdAssetFeeds(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdAssetFeed createAdAssetFeed() {
        return new APIRequestCreateAdAssetFeed(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdContracts getAdContracts() {
        return new APIRequestGetAdContracts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdCreatives getAdCreatives() {
        return new APIRequestGetAdCreatives(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdCreative createAdCreative() {
        return new APIRequestCreateAdCreative(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdCreativesFromMockup createAdCreativesFromMockup() {
        return new APIRequestCreateAdCreativesFromMockup(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdCreativesByLabels getAdCreativesByLabels() {
        return new APIRequestGetAdCreativesByLabels(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteAdImages deleteAdImages() {
        return new APIRequestDeleteAdImages(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdImages getAdImages() {
        return new APIRequestGetAdImages(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdImage createAdImage() {
        return new APIRequestCreateAdImage(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdLabels getAdLabels() {
        return new APIRequestGetAdLabels(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdLabel createAdLabel() {
        return new APIRequestCreateAdLabel(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdLanguageAssets getAdLanguageAssets() {
        return new APIRequestGetAdLanguageAssets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdLanguageAsset createAdLanguageAsset() {
        return new APIRequestCreateAdLanguageAsset(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdPlayables getAdPlayables() {
        return new APIRequestGetAdPlayables(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdPlayable createAdPlayable() {
        return new APIRequestCreateAdPlayable(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteAdReportRuns deleteAdReportRuns() {
        return new APIRequestDeleteAdReportRuns(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdReportRuns getAdReportRuns() {
        return new APIRequestGetAdReportRuns(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdReportSchedules getAdReportSchedules() {
        return new APIRequestGetAdReportSchedules(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdReportSchedule createAdReportSchedule() {
        return new APIRequestCreateAdReportSchedule(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdReportSpec createAdReportSpec() {
        return new APIRequestCreateAdReportSpec(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdRulesHistory getAdRulesHistory() {
        return new APIRequestGetAdRulesHistory(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdRulesLibrary getAdRulesLibrary() {
        return new APIRequestGetAdRulesLibrary(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdRulesLibrary createAdRulesLibrary() {
        return new APIRequestCreateAdRulesLibrary(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteAds deleteAds() {
        return new APIRequestDeleteAds(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAds getAds() {
        return new APIRequestGetAds(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAd createAd() {
        return new APIRequestCreateAd(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdsByLabels getAdsByLabels() {
        return new APIRequestGetAdsByLabels(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteAdSets deleteAdSets() {
        return new APIRequestDeleteAdSets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdSets getAdSets() {
        return new APIRequestGetAdSets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdSet createAdSet() {
        return new APIRequestCreateAdSet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdSetsByLabels getAdSetsByLabels() {
        return new APIRequestGetAdSetsByLabels(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdsPixels getAdsPixels() {
        return new APIRequestGetAdsPixels(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdsPixel createAdsPixel() {
        return new APIRequestCreateAdsPixel(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdToplineDetails getAdToplineDetails() {
        return new APIRequestGetAdToplineDetails(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdTopLines getAdTopLines() {
        return new APIRequestGetAdTopLines(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdvertisableApplications getAdvertisableApplications() {
        return new APIRequestGetAdvertisableApplications(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdVideos getAdVideos() {
        return new APIRequestGetAdVideos(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdVideo createAdVideo() {
        return new APIRequestCreateAdVideo(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAffectedAdSets getAffectedAdSets() {
        return new APIRequestGetAffectedAdSets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteAgencies deleteAgencies() {
        return new APIRequestDeleteAgencies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAgencies getAgencies() {
        return new APIRequestGetAgencies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAgency createAgency() {
        return new APIRequestCreateAgency(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetApplications getApplications() {
        return new APIRequestGetApplications(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteAssignedUsers deleteAssignedUsers() {
        return new APIRequestDeleteAssignedUsers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAssignedUsers getAssignedUsers() {
        return new APIRequestGetAssignedUsers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAssignedUser createAssignedUser() {
        return new APIRequestCreateAssignedUser(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAsyncBatchRequest createAsyncBatchRequest() {
        return new APIRequestCreateAsyncBatchRequest(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAsyncRequests getAsyncRequests() {
        return new APIRequestGetAsyncRequests(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAsyncAdRequestSets getAsyncAdRequestSets() {
        return new APIRequestGetAsyncAdRequestSets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAsyncAdRequestSet createAsyncAdRequestSet() {
        return new APIRequestCreateAsyncAdRequestSet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAudienceReplace createAudienceReplace() {
        return new APIRequestCreateAudienceReplace(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateBatchReplace createBatchReplace() {
        return new APIRequestCreateBatchReplace(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateBatchUpload createBatchUpload() {
        return new APIRequestCreateBatchUpload(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateBlockListDraft createBlockListDraft() {
        return new APIRequestCreateBlockListDraft(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetBrandAudiences getBrandAudiences() {
        return new APIRequestGetBrandAudiences(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateBrandAudience createBrandAudience() {
        return new APIRequestCreateBrandAudience(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetBroadTargetingCategories getBroadTargetingCategories() {
        return new APIRequestGetBroadTargetingCategories(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetBusinessActivities getBusinessActivities() {
        return new APIRequestGetBusinessActivities(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetBusinessProjects getBusinessProjects() {
        return new APIRequestGetBusinessProjects(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteCampaigns deleteCampaigns() {
        return new APIRequestDeleteCampaigns(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetCampaigns getCampaigns() {
        return new APIRequestGetCampaigns(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateCampaign createCampaign() {
        return new APIRequestCreateCampaign(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetCampaignsByLabels getCampaignsByLabels() {
        return new APIRequestGetCampaignsByLabels(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetContextualTargetingBrowse getContextualTargetingBrowse() {
        return new APIRequestGetContextualTargetingBrowse(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateCoupon createCoupon() {
        return new APIRequestCreateCoupon(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetCustomAudienceLimits getCustomAudienceLimits() {
        return new APIRequestGetCustomAudienceLimits(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetCustomAudiences getCustomAudiences() {
        return new APIRequestGetCustomAudiences(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateCustomAudience createCustomAudience() {
        return new APIRequestCreateCustomAudience(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetCustomAudiencesTos getCustomAudiencesTos() {
        return new APIRequestGetCustomAudiencesTos(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetCustomConversions getCustomConversions() {
        return new APIRequestGetCustomConversions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateCustomConversion createCustomConversion() {
        return new APIRequestCreateCustomConversion(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateDeactivate createDeactivate() {
        return new APIRequestCreateDeactivate(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetDeliveryEstimate getDeliveryEstimate() {
        return new APIRequestGetDeliveryEstimate(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetDeprecatedTargetingAdSets getDeprecatedTargetingAdSets() {
        return new APIRequestGetDeprecatedTargetingAdSets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetDirectDeals getDirectDeals() {
        return new APIRequestGetDirectDeals(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateDirectDealsTo createDirectDealsTo() {
        return new APIRequestCreateDirectDealsTo(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateEmailImport createEmailImport() {
        return new APIRequestCreateEmailImport(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetGeneratePreviews getGeneratePreviews() {
        return new APIRequestGetGeneratePreviews(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetImpactingAdStudies getImpactingAdStudies() {
        return new APIRequestGetImpactingAdStudies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetInsights getInsights() {
        return new APIRequestGetInsights(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetInsightsAsync getInsightsAsync() {
        return new APIRequestGetInsightsAsync(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetInstagramAccounts getInstagramAccounts() {
        return new APIRequestGetInstagramAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetLeadGenForms getLeadGenForms() {
        return new APIRequestGetLeadGenForms(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateLocationCluster createLocationCluster() {
        return new APIRequestCreateLocationCluster(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetMatchedSearchApplications getMatchedSearchApplications() {
        return new APIRequestGetMatchedSearchApplications(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetMaxBid getMaxBid() {
        return new APIRequestGetMaxBid(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetMinimumBudgets getMinimumBudgets() {
        return new APIRequestGetMinimumBudgets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateMockup createMockup() {
        return new APIRequestCreateMockup(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetOfflineConversionDataSets getOfflineConversionDataSets() {
        return new APIRequestGetOfflineConversionDataSets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetOffsitePixels getOffsitePixels() {
        return new APIRequestGetOffsitePixels(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPartnerIntegrations getPartnerIntegrations() {
        return new APIRequestGetPartnerIntegrations(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreatePartnerIntegration createPartnerIntegration() {
        return new APIRequestCreatePartnerIntegration(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPartnerCategories getPartnerCategories() {
        return new APIRequestGetPartnerCategories(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreatePartnerDatum createPartnerDatum() {
        return new APIRequestCreatePartnerDatum(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreatePartnerRequest createPartnerRequest() {
        return new APIRequestCreatePartnerRequest(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPartners getPartners() {
        return new APIRequestGetPartners(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateProductAudience createProductAudience() {
        return new APIRequestCreateProductAudience(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPromotePages getPromotePages() {
        return new APIRequestGetPromotePages(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPublisherBlockLists getPublisherBlockLists() {
        return new APIRequestGetPublisherBlockLists(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreatePublisherBlockList createPublisherBlockList() {
        return new APIRequestCreatePublisherBlockList(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetReachEstimate getReachEstimate() {
        return new APIRequestGetReachEstimate(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetReachFrequencyPredictions getReachFrequencyPredictions() {
        return new APIRequestGetReachFrequencyPredictions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateReachFrequencyPrediction createReachFrequencyPrediction() {
        return new APIRequestCreateReachFrequencyPrediction(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetReferral getReferral() {
        return new APIRequestGetReferral(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateReferral createReferral() {
        return new APIRequestCreateReferral(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateReportStat createReportStat() {
        return new APIRequestCreateReportStat(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetRoas getRoas() {
        return new APIRequestGetRoas(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetSavedAudiences getSavedAudiences() {
        return new APIRequestGetSavedAudiences(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateSponsoredMessageAd createSponsoredMessageAd() {
        return new APIRequestCreateSponsoredMessageAd(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTargetingBrowse getTargetingBrowse() {
        return new APIRequestGetTargetingBrowse(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTargetingSearch getTargetingSearch() {
        return new APIRequestGetTargetingSearch(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTargetingSentenceLines getTargetingSentenceLines() {
        return new APIRequestGetTargetingSentenceLines(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTargetingSuggestions getTargetingSuggestions() {
        return new APIRequestGetTargetingSuggestions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTargetingValidation getTargetingValidation() {
        return new APIRequestGetTargetingValidation(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTimezoneOffsets getTimezoneOffsets() {
        return new APIRequestGetTimezoneOffsets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteTracking deleteTracking() {
        return new APIRequestDeleteTracking(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTracking getTracking() {
        return new APIRequestGetTracking(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateTracking createTracking() {
        return new APIRequestCreateTracking(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteUserMatch deleteUserMatch() {
        return new APIRequestDeleteUserMatch(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateUserMatch createUserMatch() {
        return new APIRequestCreateUserMatch(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteUserPermissions deleteUserPermissions() {
        return new APIRequestDeleteUserPermissions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetUserPermissions getUserPermissions() {
        return new APIRequestGetUserPermissions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateUserPermission createUserPermission() {
        return new APIRequestCreateUserPermission(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteUsers deleteUsers() {
        return new APIRequestDeleteUsers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetUsers getUsers() {
        return new APIRequestGetUsers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateUser createUser() {
        return new APIRequestCreateUser(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteUsersOfAnyAudience deleteUsersOfAnyAudience() {
        return new APIRequestDeleteUsersOfAnyAudience(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public Long getFieldAccountStatus() {
        return this.mAccountStatus;
    }

    public AdAccountCreationRequest getFieldAdAccountCreationRequest() {
        if (this.mAdAccountCreationRequest != null) {
            this.mAdAccountCreationRequest.context = this.getContext();
        }
        return this.mAdAccountCreationRequest;
    }

    public AdAccountPromotableObjects getFieldAdAccountPromotableObjects() {
        return this.mAdAccountPromotableObjects;
    }

    public Double getFieldAge() {
        return this.mAge;
    }

    public AgencyClientDeclaration getFieldAgencyClientDeclaration() {
        return this.mAgencyClientDeclaration;
    }

    public String getFieldAmountSpent() {
        return this.mAmountSpent;
    }

    public List<AttributionSpec> getFieldAttributionSpec() {
        return this.mAttributionSpec;
    }

    public String getFieldBalance() {
        return this.mBalance;
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public String getFieldBusinessCity() {
        return this.mBusinessCity;
    }

    public String getFieldBusinessCountryCode() {
        return this.mBusinessCountryCode;
    }

    public String getFieldBusinessName() {
        return this.mBusinessName;
    }

    public String getFieldBusinessState() {
        return this.mBusinessState;
    }

    public String getFieldBusinessStreet() {
        return this.mBusinessStreet;
    }

    public String getFieldBusinessStreet2() {
        return this.mBusinessStreet2;
    }

    public String getFieldBusinessZip() {
        return this.mBusinessZip;
    }

    public Boolean getFieldCanCreateBrandLiftStudy() {
        return this.mCanCreateBrandLiftStudy;
    }

    public List<String> getFieldCapabilities() {
        return this.mCapabilities;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldDailySpendLimit() {
        return this.mDailySpendLimit;
    }

    public Boolean getFieldDirectDealsTosAccepted() {
        return this.mDirectDealsTosAccepted;
    }

    public Long getFieldDisableReason() {
        return this.mDisableReason;
    }

    public String getFieldEndAdvertiser() {
        return this.mEndAdvertiser;
    }

    public String getFieldEndAdvertiserName() {
        return this.mEndAdvertiserName;
    }

    public ExtendedCreditInvoiceGroup getFieldExtendedCreditInvoiceGroup() {
        if (this.mExtendedCreditInvoiceGroup != null) {
            this.mExtendedCreditInvoiceGroup.context = this.getContext();
        }
        return this.mExtendedCreditInvoiceGroup;
    }

    public List<DeliveryCheck> getFieldFailedDeliveryChecks() {
        return this.mFailedDeliveryChecks;
    }

    public String getFieldFundingSource() {
        return this.mFundingSource;
    }

    public FundingSourceDetails getFieldFundingSourceDetails() {
        return this.mFundingSourceDetails;
    }

    public Boolean getFieldHasMigratedPermissions() {
        return this.mHasMigratedPermissions;
    }

    public Boolean getFieldHasPageAuthorizedAdaccount() {
        return this.mHasPageAuthorizedAdaccount;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldIoNumber() {
        return this.mIoNumber;
    }

    public Boolean getFieldIsAttributionSpecSystemDefault() {
        return this.mIsAttributionSpecSystemDefault;
    }

    public Boolean getFieldIsDirectDealsEnabled() {
        return this.mIsDirectDealsEnabled;
    }

    public Boolean getFieldIsIn3dsAuthorizationEnabledMarket() {
        return this.mIsIn3dsAuthorizationEnabledMarket;
    }

    public Boolean getFieldIsInMiddleOfLocalEntityMigration() {
        return this.mIsInMiddleOfLocalEntityMigration;
    }

    public Boolean getFieldIsNotificationsEnabled() {
        return this.mIsNotificationsEnabled;
    }

    public Long getFieldIsPersonal() {
        return this.mIsPersonal;
    }

    public Boolean getFieldIsPrepayAccount() {
        return this.mIsPrepayAccount;
    }

    public Boolean getFieldIsTaxIdRequired() {
        return this.mIsTaxIdRequired;
    }

    public List<Long> getFieldLineNumbers() {
        return this.mLineNumbers;
    }

    public String getFieldMediaAgency() {
        return this.mMediaAgency;
    }

    public String getFieldMinCampaignGroupSpendCap() {
        return this.mMinCampaignGroupSpendCap;
    }

    public Long getFieldMinDailyBudget() {
        return this.mMinDailyBudget;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Boolean getFieldOffsitePixelsTosAccepted() {
        return this.mOffsitePixelsTosAccepted;
    }

    public String getFieldOwner() {
        return this.mOwner;
    }

    public String getFieldPartner() {
        return this.mPartner;
    }

    public String getFieldRateLimitResetTime() {
        return this.mRateLimitResetTime;
    }

    public ReachFrequencySpec getFieldRfSpec() {
        return this.mRfSpec;
    }

    public Boolean getFieldShowCheckoutExperience() {
        return this.mShowCheckoutExperience;
    }

    public String getFieldSpendCap() {
        return this.mSpendCap;
    }

    public String getFieldTaxId() {
        return this.mTaxId;
    }

    public Long getFieldTaxIdStatus() {
        return this.mTaxIdStatus;
    }

    public String getFieldTaxIdType() {
        return this.mTaxIdType;
    }

    public Long getFieldTimezoneId() {
        return this.mTimezoneId;
    }

    public String getFieldTimezoneName() {
        return this.mTimezoneName;
    }

    public Double getFieldTimezoneOffsetHoursUtc() {
        return this.mTimezoneOffsetHoursUtc;
    }

    public Map<String, Long> getFieldTosAccepted() {
        return this.mTosAccepted;
    }

    public String getFieldUserRole() {
        return this.mUserRole;
    }

    public Map<String, Long> getFieldUserTosAccepted() {
        return this.mUserTosAccepted;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAccount copyFrom(AdAccount instance) {
        this.mAccountId = instance.mAccountId;
        this.mAccountStatus = instance.mAccountStatus;
        this.mAdAccountCreationRequest = instance.mAdAccountCreationRequest;
        this.mAdAccountPromotableObjects = instance.mAdAccountPromotableObjects;
        this.mAge = instance.mAge;
        this.mAgencyClientDeclaration = instance.mAgencyClientDeclaration;
        this.mAmountSpent = instance.mAmountSpent;
        this.mAttributionSpec = instance.mAttributionSpec;
        this.mBalance = instance.mBalance;
        this.mBusiness = instance.mBusiness;
        this.mBusinessCity = instance.mBusinessCity;
        this.mBusinessCountryCode = instance.mBusinessCountryCode;
        this.mBusinessName = instance.mBusinessName;
        this.mBusinessState = instance.mBusinessState;
        this.mBusinessStreet = instance.mBusinessStreet;
        this.mBusinessStreet2 = instance.mBusinessStreet2;
        this.mBusinessZip = instance.mBusinessZip;
        this.mCanCreateBrandLiftStudy = instance.mCanCreateBrandLiftStudy;
        this.mCapabilities = instance.mCapabilities;
        this.mCreatedTime = instance.mCreatedTime;
        this.mCurrency = instance.mCurrency;
        this.mDailySpendLimit = instance.mDailySpendLimit;
        this.mDirectDealsTosAccepted = instance.mDirectDealsTosAccepted;
        this.mDisableReason = instance.mDisableReason;
        this.mEndAdvertiser = instance.mEndAdvertiser;
        this.mEndAdvertiserName = instance.mEndAdvertiserName;
        this.mExtendedCreditInvoiceGroup = instance.mExtendedCreditInvoiceGroup;
        this.mFailedDeliveryChecks = instance.mFailedDeliveryChecks;
        this.mFundingSource = instance.mFundingSource;
        this.mFundingSourceDetails = instance.mFundingSourceDetails;
        this.mHasMigratedPermissions = instance.mHasMigratedPermissions;
        this.mHasPageAuthorizedAdaccount = instance.mHasPageAuthorizedAdaccount;
        this.mId = instance.mId;
        this.mIoNumber = instance.mIoNumber;
        this.mIsAttributionSpecSystemDefault = instance.mIsAttributionSpecSystemDefault;
        this.mIsDirectDealsEnabled = instance.mIsDirectDealsEnabled;
        this.mIsIn3dsAuthorizationEnabledMarket = instance.mIsIn3dsAuthorizationEnabledMarket;
        this.mIsInMiddleOfLocalEntityMigration = instance.mIsInMiddleOfLocalEntityMigration;
        this.mIsNotificationsEnabled = instance.mIsNotificationsEnabled;
        this.mIsPersonal = instance.mIsPersonal;
        this.mIsPrepayAccount = instance.mIsPrepayAccount;
        this.mIsTaxIdRequired = instance.mIsTaxIdRequired;
        this.mLineNumbers = instance.mLineNumbers;
        this.mMediaAgency = instance.mMediaAgency;
        this.mMinCampaignGroupSpendCap = instance.mMinCampaignGroupSpendCap;
        this.mMinDailyBudget = instance.mMinDailyBudget;
        this.mName = instance.mName;
        this.mOffsitePixelsTosAccepted = instance.mOffsitePixelsTosAccepted;
        this.mOwner = instance.mOwner;
        this.mPartner = instance.mPartner;
        this.mRateLimitResetTime = instance.mRateLimitResetTime;
        this.mRfSpec = instance.mRfSpec;
        this.mShowCheckoutExperience = instance.mShowCheckoutExperience;
        this.mSpendCap = instance.mSpendCap;
        this.mTaxId = instance.mTaxId;
        this.mTaxIdStatus = instance.mTaxIdStatus;
        this.mTaxIdType = instance.mTaxIdType;
        this.mTimezoneId = instance.mTimezoneId;
        this.mTimezoneName = instance.mTimezoneName;
        this.mTimezoneOffsetHoursUtc = instance.mTimezoneOffsetHoursUtc;
        this.mTosAccepted = instance.mTosAccepted;
        this.mUserRole = instance.mUserRole;
        this.mUserTosAccepted = instance.mUserTosAccepted;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAccount> getParser() {
        return new APIRequest.ResponseParser<AdAccount>(){

            @Override
            public APINodeList<AdAccount> parseResponse(String response, APIContext context, APIRequest<AdAccount> request) throws APIException.MalformedResponseException {
                return AdAccount.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumFormat {
        VALUE_JSON("JSON"),
        VALUE_CSV("CSV"),
        VALUE_XLS("XLS"),
        VALUE_XLSX("XLSX"),
        NULL(null);

        private String value;

        private EnumFormat(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_SHARE_PC("SHARE_PC"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumDeleteStrategy {
        VALUE_DELETE_ANY("DELETE_ANY"),
        VALUE_DELETE_OLDEST("DELETE_OLDEST"),
        VALUE_DELETE_ARCHIVED_BEFORE("DELETE_ARCHIVED_BEFORE"),
        NULL(null);

        private String value;

        private EnumDeleteStrategy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStatus {
        VALUE_ACTIVE("Active"),
        VALUE_PAUSED("Paused"),
        VALUE_DELETED("Deleted"),
        NULL(null);

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumScheduleFrequency {
        VALUE_DAILY("daily"),
        VALUE_WEEKLY("weekly"),
        VALUE_MONTHLY("monthly"),
        NULL(null);

        private String value;

        private EnumScheduleFrequency(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumActionsGroupBy {
        VALUE_ACTION_CANVAS_COMPONENT_ID("action_canvas_component_id"),
        VALUE_ACTION_CANVAS_COMPONENT_NAME("action_canvas_component_name"),
        VALUE_ACTION_CAROUSEL_CARD_ID("action_carousel_card_id"),
        VALUE_ACTION_CAROUSEL_CARD_NAME("action_carousel_card_name"),
        VALUE_ACTION_DESTINATION("action_destination"),
        VALUE_ACTION_DEVICE("action_device"),
        VALUE_ACTION_EVENT_CHANNEL("action_event_channel"),
        VALUE_ACTION_TARGET_ID("action_target_id"),
        VALUE_ACTION_TYPE("action_type"),
        VALUE_ACTION_VIDEO_SOUND("action_video_sound"),
        VALUE_ACTION_VIDEO_TYPE("action_video_type"),
        VALUE_ACTION_CONVERTED_PRODUCT_ID("action_converted_product_id"),
        NULL(null);

        private String value;

        private EnumActionsGroupBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCreationSource {
        VALUE_ADSMANAGERREPORTING("adsManagerReporting"),
        VALUE_NEWADSMANAGER("newAdsManager"),
        VALUE_ADSEXCELADDIN("adsExcelAddin"),
        NULL(null);

        private String value;

        private EnumCreationSource(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumDatePreset {
        VALUE_TODAY("today"),
        VALUE_YESTERDAY("yesterday"),
        VALUE_THIS_MONTH("this_month"),
        VALUE_LAST_MONTH("last_month"),
        VALUE_THIS_QUARTER("this_quarter"),
        VALUE_LIFETIME("lifetime"),
        VALUE_LAST_3D("last_3d"),
        VALUE_LAST_7D("last_7d"),
        VALUE_LAST_14D("last_14d"),
        VALUE_LAST_28D("last_28d"),
        VALUE_LAST_30D("last_30d"),
        VALUE_LAST_90D("last_90d"),
        VALUE_LAST_WEEK_MON_SUN("last_week_mon_sun"),
        VALUE_LAST_WEEK_SUN_SAT("last_week_sun_sat"),
        VALUE_LAST_QUARTER("last_quarter"),
        VALUE_LAST_YEAR("last_year"),
        VALUE_THIS_WEEK_MON_TODAY("this_week_mon_today"),
        VALUE_THIS_WEEK_SUN_TODAY("this_week_sun_today"),
        VALUE_THIS_YEAR("this_year"),
        NULL(null);

        private String value;

        private EnumDatePreset(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumLevel {
        VALUE_POLITICALAD("politicalad"),
        VALUE_AD("ad"),
        VALUE_ADGROUP("adgroup"),
        VALUE_CAMPAIGN("campaign"),
        VALUE_CAMPAIGN_GROUP("campaign_group"),
        VALUE_ACCOUNT("account"),
        NULL(null);

        private String value;

        private EnumLevel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBuiltinColumnSet {
        VALUE_APP_ENGAGEMENT("APP_ENGAGEMENT"),
        VALUE_AUDIENCE_DIRECT("AUDIENCE_DIRECT"),
        VALUE_BIDDING_AND_OPTIMIZATION("BIDDING_AND_OPTIMIZATION"),
        VALUE_CAROUSEL_ENGAGEMENT("CAROUSEL_ENGAGEMENT"),
        VALUE_CROSS_DEVICE("CROSS_DEVICE"),
        VALUE_DELIVERY("DELIVERY"),
        VALUE_ENGAGEMENT("ENGAGEMENT"),
        VALUE_HOUSEHOLD("HOUSEHOLD"),
        VALUE_MESSAGING_ENGAGEMENT("MESSAGING_ENGAGEMENT"),
        VALUE_MESSENGER("MESSENGER"),
        VALUE_OFFLINE_CONVERSIONS("OFFLINE_CONVERSIONS"),
        VALUE_PERFORMANCE("PERFORMANCE"),
        VALUE_PERFORMANCE_LEGACY("PERFORMANCE_LEGACY"),
        VALUE_TARGETING_AND_CREATIVE("TARGETING_AND_CREATIVE"),
        VALUE_VIDEO_ENGAGEMENT("VIDEO_ENGAGEMENT"),
        VALUE_VALIDATION_VIEW("VALIDATION_VIEW"),
        NULL(null);

        private String value;

        private EnumBuiltinColumnSet(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumSubtype {
        VALUE_CUSTOM("CUSTOM"),
        VALUE_WEBSITE("WEBSITE"),
        VALUE_APP("APP"),
        VALUE_OFFLINE_CONVERSION("OFFLINE_CONVERSION"),
        VALUE_CLAIM("CLAIM"),
        VALUE_PARTNER("PARTNER"),
        VALUE_MANAGED("MANAGED"),
        VALUE_VIDEO("VIDEO"),
        VALUE_LOOKALIKE("LOOKALIKE"),
        VALUE_ENGAGEMENT("ENGAGEMENT"),
        VALUE_BAG_OF_ACCOUNTS("BAG_OF_ACCOUNTS"),
        VALUE_STUDY_RULE_AUDIENCE("STUDY_RULE_AUDIENCE"),
        VALUE_FOX("FOX"),
        NULL(null);

        private String value;

        private EnumSubtype(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumContentType {
        VALUE_AUTOMOTIVE_MODEL("AUTOMOTIVE_MODEL"),
        VALUE_DESTINATION("DESTINATION"),
        VALUE_FLIGHT("FLIGHT"),
        VALUE_HOME_LISTING("HOME_LISTING"),
        VALUE_HOTEL("HOTEL"),
        VALUE_MEDIA_TITLE("MEDIA_TITLE"),
        VALUE_PRODUCT("PRODUCT"),
        VALUE_VEHICLE("VEHICLE"),
        VALUE_VEHICLE_OFFER("VEHICLE_OFFER"),
        NULL(null);

        private String value;

        private EnumContentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumClaimObjective {
        VALUE_AUTOMOTIVE_MODEL("AUTOMOTIVE_MODEL"),
        VALUE_HOME_LISTING("HOME_LISTING"),
        VALUE_MEDIA_TITLE("MEDIA_TITLE"),
        VALUE_PRODUCT("PRODUCT"),
        VALUE_TRAVEL("TRAVEL"),
        VALUE_VEHICLE("VEHICLE"),
        VALUE_VEHICLE_OFFER("VEHICLE_OFFER"),
        NULL(null);

        private String value;

        private EnumClaimObjective(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumTasks {
        VALUE_MANAGE("MANAGE"),
        VALUE_ADVERTISE("ADVERTISE"),
        VALUE_ANALYZE("ANALYZE"),
        NULL(null);

        private String value;

        private EnumTasks(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPermittedTasks {
        VALUE_MANAGE("MANAGE"),
        VALUE_ADVERTISE("ADVERTISE"),
        VALUE_ANALYZE("ANALYZE"),
        NULL(null);

        private String value;

        private EnumPermittedTasks(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCurrency {
        VALUE_AED("AED"),
        VALUE_ARS("ARS"),
        VALUE_AUD("AUD"),
        VALUE_BDT("BDT"),
        VALUE_BOB("BOB"),
        VALUE_BRL("BRL"),
        VALUE_CAD("CAD"),
        VALUE_CHF("CHF"),
        VALUE_CLP("CLP"),
        VALUE_CNY("CNY"),
        VALUE_COP("COP"),
        VALUE_CRC("CRC"),
        VALUE_CZK("CZK"),
        VALUE_DKK("DKK"),
        VALUE_DZD("DZD"),
        VALUE_EGP("EGP"),
        VALUE_EUR("EUR"),
        VALUE_GBP("GBP"),
        VALUE_GTQ("GTQ"),
        VALUE_HKD("HKD"),
        VALUE_HNL("HNL"),
        VALUE_HUF("HUF"),
        VALUE_IDR("IDR"),
        VALUE_ILS("ILS"),
        VALUE_INR("INR"),
        VALUE_ISK("ISK"),
        VALUE_JPY("JPY"),
        VALUE_KES("KES"),
        VALUE_KRW("KRW"),
        VALUE_MOP("MOP"),
        VALUE_MXN("MXN"),
        VALUE_MYR("MYR"),
        VALUE_NGN("NGN"),
        VALUE_NIO("NIO"),
        VALUE_NOK("NOK"),
        VALUE_NZD("NZD"),
        VALUE_PEN("PEN"),
        VALUE_PHP("PHP"),
        VALUE_PKR("PKR"),
        VALUE_PLN("PLN"),
        VALUE_PYG("PYG"),
        VALUE_QAR("QAR"),
        VALUE_RON("RON"),
        VALUE_RUB("RUB"),
        VALUE_SAR("SAR"),
        VALUE_SEK("SEK"),
        VALUE_SGD("SGD"),
        VALUE_THB("THB"),
        VALUE_TRY("TRY"),
        VALUE_TWD("TWD"),
        VALUE_USD("USD"),
        VALUE_UYU("UYU"),
        VALUE_VEF("VEF"),
        VALUE_VND("VND"),
        VALUE_ZAR("ZAR"),
        NULL(null);

        private String value;

        private EnumCurrency(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<AdAccount> {
        AdAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"name", "spend_cap_action", "spend_cap", "agency_client_declaration", "business_info", "tos_accepted", "currency", "timezone_id", "end_advertiser", "media_agency", "partner", "is_notifications_enabled", "attribution_spec"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccount parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccount execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccount>(){

                public AdAccount apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setSpendCapAction(String spendCapAction) {
            this.setParam("spend_cap_action", spendCapAction);
            return this;
        }

        public APIRequestUpdate setSpendCap(Double spendCap) {
            this.setParam("spend_cap", spendCap);
            return this;
        }

        public APIRequestUpdate setSpendCap(String spendCap) {
            this.setParam("spend_cap", spendCap);
            return this;
        }

        public APIRequestUpdate setAgencyClientDeclaration(Map<String, String> agencyClientDeclaration) {
            this.setParam("agency_client_declaration", agencyClientDeclaration);
            return this;
        }

        public APIRequestUpdate setAgencyClientDeclaration(String agencyClientDeclaration) {
            this.setParam("agency_client_declaration", agencyClientDeclaration);
            return this;
        }

        public APIRequestUpdate setBusinessInfo(Map<String, String> businessInfo) {
            this.setParam("business_info", businessInfo);
            return this;
        }

        public APIRequestUpdate setBusinessInfo(String businessInfo) {
            this.setParam("business_info", businessInfo);
            return this;
        }

        public APIRequestUpdate setTosAccepted(Map<String, String> tosAccepted) {
            this.setParam("tos_accepted", tosAccepted);
            return this;
        }

        public APIRequestUpdate setTosAccepted(String tosAccepted) {
            this.setParam("tos_accepted", tosAccepted);
            return this;
        }

        public APIRequestUpdate setCurrency(EnumCurrency currency) {
            this.setParam("currency", (Object)currency);
            return this;
        }

        public APIRequestUpdate setCurrency(String currency) {
            this.setParam("currency", currency);
            return this;
        }

        public APIRequestUpdate setTimezoneId(Long timezoneId) {
            this.setParam("timezone_id", timezoneId);
            return this;
        }

        public APIRequestUpdate setTimezoneId(String timezoneId) {
            this.setParam("timezone_id", timezoneId);
            return this;
        }

        public APIRequestUpdate setEndAdvertiser(String endAdvertiser) {
            this.setParam("end_advertiser", endAdvertiser);
            return this;
        }

        public APIRequestUpdate setMediaAgency(String mediaAgency) {
            this.setParam("media_agency", mediaAgency);
            return this;
        }

        public APIRequestUpdate setPartner(String partner) {
            this.setParam("partner", partner);
            return this;
        }

        public APIRequestUpdate setIsNotificationsEnabled(Boolean isNotificationsEnabled) {
            this.setParam("is_notifications_enabled", isNotificationsEnabled);
            return this;
        }

        public APIRequestUpdate setIsNotificationsEnabled(String isNotificationsEnabled) {
            this.setParam("is_notifications_enabled", isNotificationsEnabled);
            return this;
        }

        public APIRequestUpdate setAttributionSpec(List<Object> attributionSpec) {
            this.setParam("attribution_spec", attributionSpec);
            return this;
        }

        public APIRequestUpdate setAttributionSpec(String attributionSpec) {
            this.setParam("attribution_spec", attributionSpec);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdAccount> {
        AdAccount lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "account_status", "ad_account_creation_request", "ad_account_promotable_objects", "age", "agency_client_declaration", "amount_spent", "attribution_spec", "balance", "business", "business_city", "business_country_code", "business_name", "business_state", "business_street", "business_street2", "business_zip", "capabilities", "created_time", "currency", "daily_spend_limit", "direct_deals_tos_accepted", "disable_reason", "end_advertiser", "end_advertiser_name", "extended_credit_invoice_group", "failed_delivery_checks", "funding_source", "funding_source_details", "has_migrated_permissions", "has_page_authorized_adaccount", "id", "io_number", "is_attribution_spec_system_default", "is_direct_deals_enabled", "is_in_3ds_authorization_enabled_market", "is_in_middle_of_local_entity_migration", "is_notifications_enabled", "is_personal", "is_prepay_account", "is_tax_id_required", "line_numbers", "media_agency", "min_campaign_group_spend_cap", "min_daily_budget", "name", "offsite_pixels_tos_accepted", "owner", "partner", "rate_limit_reset_time", "rf_spec", "show_checkout_experience", "spend_cap", "tax_id", "tax_id_status", "tax_id_type", "timezone_id", "timezone_name", "timezone_offset_hours_utc", "tos_accepted", "user_role", "user_tos_accepted"};

        @Override
        public AdAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccount parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccount execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccount>(){

                public AdAccount apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestAccountStatusField() {
            return this.requestAccountStatusField(true);
        }

        public APIRequestGet requestAccountStatusField(boolean value) {
            this.requestField("account_status", value);
            return this;
        }

        public APIRequestGet requestAdAccountCreationRequestField() {
            return this.requestAdAccountCreationRequestField(true);
        }

        public APIRequestGet requestAdAccountCreationRequestField(boolean value) {
            this.requestField("ad_account_creation_request", value);
            return this;
        }

        public APIRequestGet requestAdAccountPromotableObjectsField() {
            return this.requestAdAccountPromotableObjectsField(true);
        }

        public APIRequestGet requestAdAccountPromotableObjectsField(boolean value) {
            this.requestField("ad_account_promotable_objects", value);
            return this;
        }

        public APIRequestGet requestAgeField() {
            return this.requestAgeField(true);
        }

        public APIRequestGet requestAgeField(boolean value) {
            this.requestField("age", value);
            return this;
        }

        public APIRequestGet requestAgencyClientDeclarationField() {
            return this.requestAgencyClientDeclarationField(true);
        }

        public APIRequestGet requestAgencyClientDeclarationField(boolean value) {
            this.requestField("agency_client_declaration", value);
            return this;
        }

        public APIRequestGet requestAmountSpentField() {
            return this.requestAmountSpentField(true);
        }

        public APIRequestGet requestAmountSpentField(boolean value) {
            this.requestField("amount_spent", value);
            return this;
        }

        public APIRequestGet requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGet requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGet requestBalanceField() {
            return this.requestBalanceField(true);
        }

        public APIRequestGet requestBalanceField(boolean value) {
            this.requestField("balance", value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestBusinessCityField() {
            return this.requestBusinessCityField(true);
        }

        public APIRequestGet requestBusinessCityField(boolean value) {
            this.requestField("business_city", value);
            return this;
        }

        public APIRequestGet requestBusinessCountryCodeField() {
            return this.requestBusinessCountryCodeField(true);
        }

        public APIRequestGet requestBusinessCountryCodeField(boolean value) {
            this.requestField("business_country_code", value);
            return this;
        }

        public APIRequestGet requestBusinessNameField() {
            return this.requestBusinessNameField(true);
        }

        public APIRequestGet requestBusinessNameField(boolean value) {
            this.requestField("business_name", value);
            return this;
        }

        public APIRequestGet requestBusinessStateField() {
            return this.requestBusinessStateField(true);
        }

        public APIRequestGet requestBusinessStateField(boolean value) {
            this.requestField("business_state", value);
            return this;
        }

        public APIRequestGet requestBusinessStreetField() {
            return this.requestBusinessStreetField(true);
        }

        public APIRequestGet requestBusinessStreetField(boolean value) {
            this.requestField("business_street", value);
            return this;
        }

        public APIRequestGet requestBusinessStreet2Field() {
            return this.requestBusinessStreet2Field(true);
        }

        public APIRequestGet requestBusinessStreet2Field(boolean value) {
            this.requestField("business_street2", value);
            return this;
        }

        public APIRequestGet requestBusinessZipField() {
            return this.requestBusinessZipField(true);
        }

        public APIRequestGet requestBusinessZipField(boolean value) {
            this.requestField("business_zip", value);
            return this;
        }

        public APIRequestGet requestCapabilitiesField() {
            return this.requestCapabilitiesField(true);
        }

        public APIRequestGet requestCapabilitiesField(boolean value) {
            this.requestField("capabilities", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestDailySpendLimitField() {
            return this.requestDailySpendLimitField(true);
        }

        public APIRequestGet requestDailySpendLimitField(boolean value) {
            this.requestField("daily_spend_limit", value);
            return this;
        }

        public APIRequestGet requestDirectDealsTosAcceptedField() {
            return this.requestDirectDealsTosAcceptedField(true);
        }

        public APIRequestGet requestDirectDealsTosAcceptedField(boolean value) {
            this.requestField("direct_deals_tos_accepted", value);
            return this;
        }

        public APIRequestGet requestDisableReasonField() {
            return this.requestDisableReasonField(true);
        }

        public APIRequestGet requestDisableReasonField(boolean value) {
            this.requestField("disable_reason", value);
            return this;
        }

        public APIRequestGet requestEndAdvertiserField() {
            return this.requestEndAdvertiserField(true);
        }

        public APIRequestGet requestEndAdvertiserField(boolean value) {
            this.requestField("end_advertiser", value);
            return this;
        }

        public APIRequestGet requestEndAdvertiserNameField() {
            return this.requestEndAdvertiserNameField(true);
        }

        public APIRequestGet requestEndAdvertiserNameField(boolean value) {
            this.requestField("end_advertiser_name", value);
            return this;
        }

        public APIRequestGet requestExtendedCreditInvoiceGroupField() {
            return this.requestExtendedCreditInvoiceGroupField(true);
        }

        public APIRequestGet requestExtendedCreditInvoiceGroupField(boolean value) {
            this.requestField("extended_credit_invoice_group", value);
            return this;
        }

        public APIRequestGet requestFailedDeliveryChecksField() {
            return this.requestFailedDeliveryChecksField(true);
        }

        public APIRequestGet requestFailedDeliveryChecksField(boolean value) {
            this.requestField("failed_delivery_checks", value);
            return this;
        }

        public APIRequestGet requestFundingSourceField() {
            return this.requestFundingSourceField(true);
        }

        public APIRequestGet requestFundingSourceField(boolean value) {
            this.requestField("funding_source", value);
            return this;
        }

        public APIRequestGet requestFundingSourceDetailsField() {
            return this.requestFundingSourceDetailsField(true);
        }

        public APIRequestGet requestFundingSourceDetailsField(boolean value) {
            this.requestField("funding_source_details", value);
            return this;
        }

        public APIRequestGet requestHasMigratedPermissionsField() {
            return this.requestHasMigratedPermissionsField(true);
        }

        public APIRequestGet requestHasMigratedPermissionsField(boolean value) {
            this.requestField("has_migrated_permissions", value);
            return this;
        }

        public APIRequestGet requestHasPageAuthorizedAdaccountField() {
            return this.requestHasPageAuthorizedAdaccountField(true);
        }

        public APIRequestGet requestHasPageAuthorizedAdaccountField(boolean value) {
            this.requestField("has_page_authorized_adaccount", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGet requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGet requestIsAttributionSpecSystemDefaultField() {
            return this.requestIsAttributionSpecSystemDefaultField(true);
        }

        public APIRequestGet requestIsAttributionSpecSystemDefaultField(boolean value) {
            this.requestField("is_attribution_spec_system_default", value);
            return this;
        }

        public APIRequestGet requestIsDirectDealsEnabledField() {
            return this.requestIsDirectDealsEnabledField(true);
        }

        public APIRequestGet requestIsDirectDealsEnabledField(boolean value) {
            this.requestField("is_direct_deals_enabled", value);
            return this;
        }

        public APIRequestGet requestIsIn3dsAuthorizationEnabledMarketField() {
            return this.requestIsIn3dsAuthorizationEnabledMarketField(true);
        }

        public APIRequestGet requestIsIn3dsAuthorizationEnabledMarketField(boolean value) {
            this.requestField("is_in_3ds_authorization_enabled_market", value);
            return this;
        }

        public APIRequestGet requestIsInMiddleOfLocalEntityMigrationField() {
            return this.requestIsInMiddleOfLocalEntityMigrationField(true);
        }

        public APIRequestGet requestIsInMiddleOfLocalEntityMigrationField(boolean value) {
            this.requestField("is_in_middle_of_local_entity_migration", value);
            return this;
        }

        public APIRequestGet requestIsNotificationsEnabledField() {
            return this.requestIsNotificationsEnabledField(true);
        }

        public APIRequestGet requestIsNotificationsEnabledField(boolean value) {
            this.requestField("is_notifications_enabled", value);
            return this;
        }

        public APIRequestGet requestIsPersonalField() {
            return this.requestIsPersonalField(true);
        }

        public APIRequestGet requestIsPersonalField(boolean value) {
            this.requestField("is_personal", value);
            return this;
        }

        public APIRequestGet requestIsPrepayAccountField() {
            return this.requestIsPrepayAccountField(true);
        }

        public APIRequestGet requestIsPrepayAccountField(boolean value) {
            this.requestField("is_prepay_account", value);
            return this;
        }

        public APIRequestGet requestIsTaxIdRequiredField() {
            return this.requestIsTaxIdRequiredField(true);
        }

        public APIRequestGet requestIsTaxIdRequiredField(boolean value) {
            this.requestField("is_tax_id_required", value);
            return this;
        }

        public APIRequestGet requestLineNumbersField() {
            return this.requestLineNumbersField(true);
        }

        public APIRequestGet requestLineNumbersField(boolean value) {
            this.requestField("line_numbers", value);
            return this;
        }

        public APIRequestGet requestMediaAgencyField() {
            return this.requestMediaAgencyField(true);
        }

        public APIRequestGet requestMediaAgencyField(boolean value) {
            this.requestField("media_agency", value);
            return this;
        }

        public APIRequestGet requestMinCampaignGroupSpendCapField() {
            return this.requestMinCampaignGroupSpendCapField(true);
        }

        public APIRequestGet requestMinCampaignGroupSpendCapField(boolean value) {
            this.requestField("min_campaign_group_spend_cap", value);
            return this;
        }

        public APIRequestGet requestMinDailyBudgetField() {
            return this.requestMinDailyBudgetField(true);
        }

        public APIRequestGet requestMinDailyBudgetField(boolean value) {
            this.requestField("min_daily_budget", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOffsitePixelsTosAcceptedField() {
            return this.requestOffsitePixelsTosAcceptedField(true);
        }

        public APIRequestGet requestOffsitePixelsTosAcceptedField(boolean value) {
            this.requestField("offsite_pixels_tos_accepted", value);
            return this;
        }

        public APIRequestGet requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGet requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGet requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGet requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGet requestRateLimitResetTimeField() {
            return this.requestRateLimitResetTimeField(true);
        }

        public APIRequestGet requestRateLimitResetTimeField(boolean value) {
            this.requestField("rate_limit_reset_time", value);
            return this;
        }

        public APIRequestGet requestRfSpecField() {
            return this.requestRfSpecField(true);
        }

        public APIRequestGet requestRfSpecField(boolean value) {
            this.requestField("rf_spec", value);
            return this;
        }

        public APIRequestGet requestShowCheckoutExperienceField() {
            return this.requestShowCheckoutExperienceField(true);
        }

        public APIRequestGet requestShowCheckoutExperienceField(boolean value) {
            this.requestField("show_checkout_experience", value);
            return this;
        }

        public APIRequestGet requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGet requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGet requestTaxIdField() {
            return this.requestTaxIdField(true);
        }

        public APIRequestGet requestTaxIdField(boolean value) {
            this.requestField("tax_id", value);
            return this;
        }

        public APIRequestGet requestTaxIdStatusField() {
            return this.requestTaxIdStatusField(true);
        }

        public APIRequestGet requestTaxIdStatusField(boolean value) {
            this.requestField("tax_id_status", value);
            return this;
        }

        public APIRequestGet requestTaxIdTypeField() {
            return this.requestTaxIdTypeField(true);
        }

        public APIRequestGet requestTaxIdTypeField(boolean value) {
            this.requestField("tax_id_type", value);
            return this;
        }

        public APIRequestGet requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGet requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGet requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGet requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGet requestTimezoneOffsetHoursUtcField() {
            return this.requestTimezoneOffsetHoursUtcField(true);
        }

        public APIRequestGet requestTimezoneOffsetHoursUtcField(boolean value) {
            this.requestField("timezone_offset_hours_utc", value);
            return this;
        }

        public APIRequestGet requestTosAcceptedField() {
            return this.requestTosAcceptedField(true);
        }

        public APIRequestGet requestTosAcceptedField(boolean value) {
            this.requestField("tos_accepted", value);
            return this;
        }

        public APIRequestGet requestUserRoleField() {
            return this.requestUserRoleField(true);
        }

        public APIRequestGet requestUserRoleField(boolean value) {
            this.requestField("user_role", value);
            return this;
        }

        public APIRequestGet requestUserTosAcceptedField() {
            return this.requestUserTosAcceptedField(true);
        }

        public APIRequestGet requestUserTosAcceptedField(boolean value) {
            this.requestField("user_tos_accepted", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteUsersOfAnyAudience
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"session", "payload", "namespace"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteUsersOfAnyAudience.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteUsersOfAnyAudience(String nodeId, APIContext context) {
            super(context, nodeId, "/usersofanyaudience", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteUsersOfAnyAudience setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteUsersOfAnyAudience setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteUsersOfAnyAudience setSession(Object session) {
            this.setParam("session", session);
            return this;
        }

        public APIRequestDeleteUsersOfAnyAudience setSession(String session) {
            this.setParam("session", session);
            return this;
        }

        public APIRequestDeleteUsersOfAnyAudience setPayload(Object payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestDeleteUsersOfAnyAudience setPayload(String payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestDeleteUsersOfAnyAudience setNamespace(String namespace) {
            this.setParam("namespace", namespace);
            return this;
        }

        public APIRequestDeleteUsersOfAnyAudience requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteUsersOfAnyAudience requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteUsersOfAnyAudience requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteUsersOfAnyAudience requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteUsersOfAnyAudience requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteUsersOfAnyAudience requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateUser
    extends APIRequest<AdAccount> {
        AdAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"uid", "tasks"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccount parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccount execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccount>(){

                public AdAccount apply(String result) {
                    try {
                        return APIRequestCreateUser.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateUser(String nodeId, APIContext context) {
            super(context, nodeId, "/users", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateUser setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateUser setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateUser setUid(Long uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestCreateUser setUid(String uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestCreateUser setTasks(List<EnumTasks> tasks) {
            this.setParam("tasks", tasks);
            return this;
        }

        public APIRequestCreateUser setTasks(String tasks) {
            this.setParam("tasks", tasks);
            return this;
        }

        public APIRequestCreateUser requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateUser requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateUser requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateUser requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateUser requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateUser requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetUsers
    extends APIRequest<AdAccountUser> {
        APINodeList<AdAccountUser> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "name", "tasks"};

        @Override
        public APINodeList<AdAccountUser> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccountUser> parseResponse(String response) throws APIException {
            return AdAccountUser.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccountUser> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccountUser> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccountUser>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccountUser>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAccountUser>>(){

                public APINodeList<AdAccountUser> apply(String result) {
                    try {
                        return APIRequestGetUsers.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetUsers(String nodeId, APIContext context) {
            super(context, nodeId, "/users", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetUsers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetUsers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetUsers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetUsers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetUsers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetUsers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetUsers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetUsers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetUsers requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetUsers requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetUsers requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetUsers requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetUsers requestTasksField() {
            return this.requestTasksField(true);
        }

        public APIRequestGetUsers requestTasksField(boolean value) {
            this.requestField("tasks", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteUsers
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"uid", "uids"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteUsers.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteUsers(String nodeId, APIContext context) {
            super(context, nodeId, "/users", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteUsers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteUsers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteUsers setUid(Long uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestDeleteUsers setUid(String uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestDeleteUsers setUids(List<String> uids) {
            this.setParam("uids", uids);
            return this;
        }

        public APIRequestDeleteUsers setUids(String uids) {
            this.setParam("uids", uids);
            return this;
        }

        public APIRequestDeleteUsers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteUsers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteUsers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteUsers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteUsers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteUsers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateUserPermission
    extends APIRequest<AdAccount> {
        AdAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"user", "email", "business", "tasks"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccount parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccount execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccount>(){

                public AdAccount apply(String result) {
                    try {
                        return APIRequestCreateUserPermission.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateUserPermission(String nodeId, APIContext context) {
            super(context, nodeId, "/userpermissions", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateUserPermission setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateUserPermission setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateUserPermission setUser(Long user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestCreateUserPermission setUser(String user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestCreateUserPermission setEmail(String email) {
            this.setParam("email", email);
            return this;
        }

        public APIRequestCreateUserPermission setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestCreateUserPermission setTasks(List<EnumTasks> tasks) {
            this.setParam("tasks", tasks);
            return this;
        }

        public APIRequestCreateUserPermission setTasks(String tasks) {
            this.setParam("tasks", tasks);
            return this;
        }

        public APIRequestCreateUserPermission requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateUserPermission requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateUserPermission requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateUserPermission requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateUserPermission requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateUserPermission requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetUserPermissions
    extends APIRequest<AdAccountUserPermissions> {
        APINodeList<AdAccountUserPermissions> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business", "user"};
        public static final String[] FIELDS = new String[]{"business", "business_persona", "created_by", "created_time", "email", "status", "tasks", "updated_by", "updated_time", "user", "id"};

        @Override
        public APINodeList<AdAccountUserPermissions> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccountUserPermissions> parseResponse(String response) throws APIException {
            return AdAccountUserPermissions.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccountUserPermissions> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccountUserPermissions> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccountUserPermissions>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccountUserPermissions>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAccountUserPermissions>>(){

                public APINodeList<AdAccountUserPermissions> apply(String result) {
                    try {
                        return APIRequestGetUserPermissions.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetUserPermissions(String nodeId, APIContext context) {
            super(context, nodeId, "/userpermissions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetUserPermissions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetUserPermissions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetUserPermissions setBusiness(Object business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestGetUserPermissions setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestGetUserPermissions setUser(Object user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestGetUserPermissions setUser(String user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestGetUserPermissions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetUserPermissions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetUserPermissions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetUserPermissions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetUserPermissions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetUserPermissions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetUserPermissions requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetUserPermissions requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetUserPermissions requestBusinessPersonaField() {
            return this.requestBusinessPersonaField(true);
        }

        public APIRequestGetUserPermissions requestBusinessPersonaField(boolean value) {
            this.requestField("business_persona", value);
            return this;
        }

        public APIRequestGetUserPermissions requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGetUserPermissions requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGetUserPermissions requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetUserPermissions requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetUserPermissions requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGetUserPermissions requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGetUserPermissions requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetUserPermissions requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetUserPermissions requestTasksField() {
            return this.requestTasksField(true);
        }

        public APIRequestGetUserPermissions requestTasksField(boolean value) {
            this.requestField("tasks", value);
            return this;
        }

        public APIRequestGetUserPermissions requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGetUserPermissions requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGetUserPermissions requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetUserPermissions requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetUserPermissions requestUserField() {
            return this.requestUserField(true);
        }

        public APIRequestGetUserPermissions requestUserField(boolean value) {
            this.requestField("user", value);
            return this;
        }

        public APIRequestGetUserPermissions requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetUserPermissions requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteUserPermissions
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"user", "email", "business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteUserPermissions.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteUserPermissions(String nodeId, APIContext context) {
            super(context, nodeId, "/userpermissions", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteUserPermissions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteUserPermissions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteUserPermissions setUser(Long user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestDeleteUserPermissions setUser(String user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestDeleteUserPermissions setEmail(String email) {
            this.setParam("email", email);
            return this;
        }

        public APIRequestDeleteUserPermissions setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestDeleteUserPermissions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteUserPermissions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteUserPermissions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteUserPermissions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteUserPermissions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteUserPermissions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateUserMatch
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"payload", "action", "namespace", "retention", "bidirectional"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateUserMatch.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateUserMatch(String nodeId, APIContext context) {
            super(context, nodeId, "/user_match", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateUserMatch setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateUserMatch setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateUserMatch setPayload(Object payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestCreateUserMatch setPayload(String payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestCreateUserMatch setAction(String action) {
            this.setParam("action", action);
            return this;
        }

        public APIRequestCreateUserMatch setNamespace(String namespace) {
            this.setParam("namespace", namespace);
            return this;
        }

        public APIRequestCreateUserMatch setRetention(String retention) {
            this.setParam("retention", retention);
            return this;
        }

        public APIRequestCreateUserMatch setBidirectional(Boolean bidirectional) {
            this.setParam("bidirectional", bidirectional);
            return this;
        }

        public APIRequestCreateUserMatch setBidirectional(String bidirectional) {
            this.setParam("bidirectional", bidirectional);
            return this;
        }

        public APIRequestCreateUserMatch requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateUserMatch requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateUserMatch requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateUserMatch requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateUserMatch requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateUserMatch requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteUserMatch
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"payload", "namespace", "bidirectional"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteUserMatch.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteUserMatch(String nodeId, APIContext context) {
            super(context, nodeId, "/user_match", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteUserMatch setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteUserMatch setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteUserMatch setPayload(Object payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestDeleteUserMatch setPayload(String payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestDeleteUserMatch setNamespace(String namespace) {
            this.setParam("namespace", namespace);
            return this;
        }

        public APIRequestDeleteUserMatch setBidirectional(Boolean bidirectional) {
            this.setParam("bidirectional", bidirectional);
            return this;
        }

        public APIRequestDeleteUserMatch setBidirectional(String bidirectional) {
            this.setParam("bidirectional", bidirectional);
            return this;
        }

        public APIRequestDeleteUserMatch requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteUserMatch requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteUserMatch requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteUserMatch requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteUserMatch requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteUserMatch requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateTracking
    extends APIRequest<AdAccount> {
        AdAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"tracking_specs"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccount parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccount execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccount>(){

                public AdAccount apply(String result) {
                    try {
                        return APIRequestCreateTracking.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateTracking(String nodeId, APIContext context) {
            super(context, nodeId, "/tracking", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateTracking setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateTracking setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateTracking setTrackingSpecs(Object trackingSpecs) {
            this.setParam("tracking_specs", trackingSpecs);
            return this;
        }

        public APIRequestCreateTracking setTrackingSpecs(String trackingSpecs) {
            this.setParam("tracking_specs", trackingSpecs);
            return this;
        }

        public APIRequestCreateTracking requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateTracking requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateTracking requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateTracking requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateTracking requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateTracking requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetTracking
    extends APIRequest<AdAccountTrackingData> {
        APINodeList<AdAccountTrackingData> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"tracking_specs", "id"};

        @Override
        public APINodeList<AdAccountTrackingData> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccountTrackingData> parseResponse(String response) throws APIException {
            return AdAccountTrackingData.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccountTrackingData> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccountTrackingData> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccountTrackingData>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccountTrackingData>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAccountTrackingData>>(){

                public APINodeList<AdAccountTrackingData> apply(String result) {
                    try {
                        return APIRequestGetTracking.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetTracking(String nodeId, APIContext context) {
            super(context, nodeId, "/tracking", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTracking setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTracking setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTracking requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTracking requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTracking requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTracking requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTracking requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTracking requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetTracking requestTrackingSpecsField() {
            return this.requestTrackingSpecsField(true);
        }

        public APIRequestGetTracking requestTrackingSpecsField(boolean value) {
            this.requestField("tracking_specs", value);
            return this;
        }

        public APIRequestGetTracking requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetTracking requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteTracking
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"tracking_specs"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteTracking.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteTracking(String nodeId, APIContext context) {
            super(context, nodeId, "/tracking", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteTracking setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteTracking setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteTracking setTrackingSpecs(Object trackingSpecs) {
            this.setParam("tracking_specs", trackingSpecs);
            return this;
        }

        public APIRequestDeleteTracking setTrackingSpecs(String trackingSpecs) {
            this.setParam("tracking_specs", trackingSpecs);
            return this;
        }

        public APIRequestDeleteTracking requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteTracking requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteTracking requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteTracking requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteTracking requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteTracking requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetTimezoneOffsets
    extends APIRequest<TimezoneOffset> {
        APINodeList<TimezoneOffset> lastResponse = null;
        public static final String[] PARAMS = new String[]{"start_year"};
        public static final String[] FIELDS = new String[]{"abbr", "isdst", "offset", "time", "ts", "id"};

        @Override
        public APINodeList<TimezoneOffset> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<TimezoneOffset> parseResponse(String response) throws APIException {
            return TimezoneOffset.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<TimezoneOffset> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<TimezoneOffset> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<TimezoneOffset>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<TimezoneOffset>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<TimezoneOffset>>(){

                public APINodeList<TimezoneOffset> apply(String result) {
                    try {
                        return APIRequestGetTimezoneOffsets.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetTimezoneOffsets(String nodeId, APIContext context) {
            super(context, nodeId, "/timezoneoffsets", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTimezoneOffsets setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTimezoneOffsets setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTimezoneOffsets setStartYear(Long startYear) {
            this.setParam("start_year", startYear);
            return this;
        }

        public APIRequestGetTimezoneOffsets setStartYear(String startYear) {
            this.setParam("start_year", startYear);
            return this;
        }

        public APIRequestGetTimezoneOffsets requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTimezoneOffsets requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTimezoneOffsets requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTimezoneOffsets requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTimezoneOffsets requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTimezoneOffsets requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetTimezoneOffsets requestAbbrField() {
            return this.requestAbbrField(true);
        }

        public APIRequestGetTimezoneOffsets requestAbbrField(boolean value) {
            this.requestField("abbr", value);
            return this;
        }

        public APIRequestGetTimezoneOffsets requestIsdstField() {
            return this.requestIsdstField(true);
        }

        public APIRequestGetTimezoneOffsets requestIsdstField(boolean value) {
            this.requestField("isdst", value);
            return this;
        }

        public APIRequestGetTimezoneOffsets requestOffsetField() {
            return this.requestOffsetField(true);
        }

        public APIRequestGetTimezoneOffsets requestOffsetField(boolean value) {
            this.requestField("offset", value);
            return this;
        }

        public APIRequestGetTimezoneOffsets requestTimeField() {
            return this.requestTimeField(true);
        }

        public APIRequestGetTimezoneOffsets requestTimeField(boolean value) {
            this.requestField("time", value);
            return this;
        }

        public APIRequestGetTimezoneOffsets requestTsField() {
            return this.requestTsField(true);
        }

        public APIRequestGetTimezoneOffsets requestTsField(boolean value) {
            this.requestField("ts", value);
            return this;
        }

        public APIRequestGetTimezoneOffsets requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetTimezoneOffsets requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetTargetingValidation
    extends APIRequest<AdAccountTargetingUnified> {
        APINodeList<AdAccountTargetingUnified> lastResponse = null;
        public static final String[] PARAMS = new String[]{"targeting_list", "id_list", "name_list", "is_exclusion"};
        public static final String[] FIELDS = new String[]{"audience_size", "conversion_lift", "description", "id", "img", "info", "info_title", "is_recommendation", "key", "link", "name", "parent", "partner", "path", "performance_rating", "raw_name", "recommendation_model", "search_interest_id", "source", "spend", "type", "valid"};

        @Override
        public APINodeList<AdAccountTargetingUnified> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccountTargetingUnified> parseResponse(String response) throws APIException {
            return AdAccountTargetingUnified.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccountTargetingUnified> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccountTargetingUnified> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccountTargetingUnified>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccountTargetingUnified>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAccountTargetingUnified>>(){

                public APINodeList<AdAccountTargetingUnified> apply(String result) {
                    try {
                        return APIRequestGetTargetingValidation.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetTargetingValidation(String nodeId, APIContext context) {
            super(context, nodeId, "/targetingvalidation", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTargetingValidation setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTargetingValidation setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTargetingValidation setTargetingList(List<Object> targetingList) {
            this.setParam("targeting_list", targetingList);
            return this;
        }

        public APIRequestGetTargetingValidation setTargetingList(String targetingList) {
            this.setParam("targeting_list", targetingList);
            return this;
        }

        public APIRequestGetTargetingValidation setIdList(List<Long> idList) {
            this.setParam("id_list", idList);
            return this;
        }

        public APIRequestGetTargetingValidation setIdList(String idList) {
            this.setParam("id_list", idList);
            return this;
        }

        public APIRequestGetTargetingValidation setNameList(List<String> nameList) {
            this.setParam("name_list", nameList);
            return this;
        }

        public APIRequestGetTargetingValidation setNameList(String nameList) {
            this.setParam("name_list", nameList);
            return this;
        }

        public APIRequestGetTargetingValidation setIsExclusion(Boolean isExclusion) {
            this.setParam("is_exclusion", isExclusion);
            return this;
        }

        public APIRequestGetTargetingValidation setIsExclusion(String isExclusion) {
            this.setParam("is_exclusion", isExclusion);
            return this;
        }

        public APIRequestGetTargetingValidation requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTargetingValidation requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTargetingValidation requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTargetingValidation requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTargetingValidation requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTargetingValidation requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetTargetingValidation requestAudienceSizeField() {
            return this.requestAudienceSizeField(true);
        }

        public APIRequestGetTargetingValidation requestAudienceSizeField(boolean value) {
            this.requestField("audience_size", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestConversionLiftField() {
            return this.requestConversionLiftField(true);
        }

        public APIRequestGetTargetingValidation requestConversionLiftField(boolean value) {
            this.requestField("conversion_lift", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetTargetingValidation requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetTargetingValidation requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestImgField() {
            return this.requestImgField(true);
        }

        public APIRequestGetTargetingValidation requestImgField(boolean value) {
            this.requestField("img", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestInfoField() {
            return this.requestInfoField(true);
        }

        public APIRequestGetTargetingValidation requestInfoField(boolean value) {
            this.requestField("info", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestInfoTitleField() {
            return this.requestInfoTitleField(true);
        }

        public APIRequestGetTargetingValidation requestInfoTitleField(boolean value) {
            this.requestField("info_title", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestIsRecommendationField() {
            return this.requestIsRecommendationField(true);
        }

        public APIRequestGetTargetingValidation requestIsRecommendationField(boolean value) {
            this.requestField("is_recommendation", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestKeyField() {
            return this.requestKeyField(true);
        }

        public APIRequestGetTargetingValidation requestKeyField(boolean value) {
            this.requestField("key", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetTargetingValidation requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetTargetingValidation requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestParentField() {
            return this.requestParentField(true);
        }

        public APIRequestGetTargetingValidation requestParentField(boolean value) {
            this.requestField("parent", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetTargetingValidation requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestPathField() {
            return this.requestPathField(true);
        }

        public APIRequestGetTargetingValidation requestPathField(boolean value) {
            this.requestField("path", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestPerformanceRatingField() {
            return this.requestPerformanceRatingField(true);
        }

        public APIRequestGetTargetingValidation requestPerformanceRatingField(boolean value) {
            this.requestField("performance_rating", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestRawNameField() {
            return this.requestRawNameField(true);
        }

        public APIRequestGetTargetingValidation requestRawNameField(boolean value) {
            this.requestField("raw_name", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestRecommendationModelField() {
            return this.requestRecommendationModelField(true);
        }

        public APIRequestGetTargetingValidation requestRecommendationModelField(boolean value) {
            this.requestField("recommendation_model", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestSearchInterestIdField() {
            return this.requestSearchInterestIdField(true);
        }

        public APIRequestGetTargetingValidation requestSearchInterestIdField(boolean value) {
            this.requestField("search_interest_id", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGetTargetingValidation requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestSpendField() {
            return this.requestSpendField(true);
        }

        public APIRequestGetTargetingValidation requestSpendField(boolean value) {
            this.requestField("spend", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetTargetingValidation requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetTargetingValidation requestValidField() {
            return this.requestValidField(true);
        }

        public APIRequestGetTargetingValidation requestValidField(boolean value) {
            this.requestField("valid", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetTargetingSuggestions
    extends APIRequest<AdAccountTargetingUnified> {
        APINodeList<AdAccountTargetingUnified> lastResponse = null;
        public static final String[] PARAMS = new String[]{"targeting_list", "objective", "objects", "limit_type", "mode", "session_id", "whitelisted_types", "countries"};
        public static final String[] FIELDS = new String[]{"audience_size", "conversion_lift", "description", "id", "img", "info", "info_title", "is_recommendation", "key", "link", "name", "parent", "partner", "path", "performance_rating", "raw_name", "recommendation_model", "search_interest_id", "source", "spend", "type", "valid"};

        @Override
        public APINodeList<AdAccountTargetingUnified> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccountTargetingUnified> parseResponse(String response) throws APIException {
            return AdAccountTargetingUnified.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccountTargetingUnified> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccountTargetingUnified> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccountTargetingUnified>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccountTargetingUnified>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAccountTargetingUnified>>(){

                public APINodeList<AdAccountTargetingUnified> apply(String result) {
                    try {
                        return APIRequestGetTargetingSuggestions.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetTargetingSuggestions(String nodeId, APIContext context) {
            super(context, nodeId, "/targetingsuggestions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTargetingSuggestions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTargetingSuggestions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTargetingSuggestions setTargetingList(List<Object> targetingList) {
            this.setParam("targeting_list", targetingList);
            return this;
        }

        public APIRequestGetTargetingSuggestions setTargetingList(String targetingList) {
            this.setParam("targeting_list", targetingList);
            return this;
        }

        public APIRequestGetTargetingSuggestions setObjective(AdAccountTargetingUnified.EnumObjective objective) {
            this.setParam("objective", (Object)objective);
            return this;
        }

        public APIRequestGetTargetingSuggestions setObjective(String objective) {
            this.setParam("objective", objective);
            return this;
        }

        public APIRequestGetTargetingSuggestions setObjects(Object objects) {
            this.setParam("objects", objects);
            return this;
        }

        public APIRequestGetTargetingSuggestions setObjects(String objects) {
            this.setParam("objects", objects);
            return this;
        }

        public APIRequestGetTargetingSuggestions setLimitType(AdAccountTargetingUnified.EnumLimitType limitType) {
            this.setParam("limit_type", (Object)limitType);
            return this;
        }

        public APIRequestGetTargetingSuggestions setLimitType(String limitType) {
            this.setParam("limit_type", limitType);
            return this;
        }

        public APIRequestGetTargetingSuggestions setMode(AdAccountTargetingUnified.EnumMode mode) {
            this.setParam("mode", (Object)mode);
            return this;
        }

        public APIRequestGetTargetingSuggestions setMode(String mode) {
            this.setParam("mode", mode);
            return this;
        }

        public APIRequestGetTargetingSuggestions setSessionId(Long sessionId) {
            this.setParam("session_id", sessionId);
            return this;
        }

        public APIRequestGetTargetingSuggestions setSessionId(String sessionId) {
            this.setParam("session_id", sessionId);
            return this;
        }

        public APIRequestGetTargetingSuggestions setWhitelistedTypes(List<AdAccountTargetingUnified.EnumWhitelistedTypes> whitelistedTypes) {
            this.setParam("whitelisted_types", whitelistedTypes);
            return this;
        }

        public APIRequestGetTargetingSuggestions setWhitelistedTypes(String whitelistedTypes) {
            this.setParam("whitelisted_types", whitelistedTypes);
            return this;
        }

        public APIRequestGetTargetingSuggestions setCountries(List<String> countries) {
            this.setParam("countries", countries);
            return this;
        }

        public APIRequestGetTargetingSuggestions setCountries(String countries) {
            this.setParam("countries", countries);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTargetingSuggestions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTargetingSuggestions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTargetingSuggestions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTargetingSuggestions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTargetingSuggestions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestAudienceSizeField() {
            return this.requestAudienceSizeField(true);
        }

        public APIRequestGetTargetingSuggestions requestAudienceSizeField(boolean value) {
            this.requestField("audience_size", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestConversionLiftField() {
            return this.requestConversionLiftField(true);
        }

        public APIRequestGetTargetingSuggestions requestConversionLiftField(boolean value) {
            this.requestField("conversion_lift", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetTargetingSuggestions requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetTargetingSuggestions requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestImgField() {
            return this.requestImgField(true);
        }

        public APIRequestGetTargetingSuggestions requestImgField(boolean value) {
            this.requestField("img", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestInfoField() {
            return this.requestInfoField(true);
        }

        public APIRequestGetTargetingSuggestions requestInfoField(boolean value) {
            this.requestField("info", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestInfoTitleField() {
            return this.requestInfoTitleField(true);
        }

        public APIRequestGetTargetingSuggestions requestInfoTitleField(boolean value) {
            this.requestField("info_title", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestIsRecommendationField() {
            return this.requestIsRecommendationField(true);
        }

        public APIRequestGetTargetingSuggestions requestIsRecommendationField(boolean value) {
            this.requestField("is_recommendation", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestKeyField() {
            return this.requestKeyField(true);
        }

        public APIRequestGetTargetingSuggestions requestKeyField(boolean value) {
            this.requestField("key", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetTargetingSuggestions requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetTargetingSuggestions requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestParentField() {
            return this.requestParentField(true);
        }

        public APIRequestGetTargetingSuggestions requestParentField(boolean value) {
            this.requestField("parent", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetTargetingSuggestions requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestPathField() {
            return this.requestPathField(true);
        }

        public APIRequestGetTargetingSuggestions requestPathField(boolean value) {
            this.requestField("path", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestPerformanceRatingField() {
            return this.requestPerformanceRatingField(true);
        }

        public APIRequestGetTargetingSuggestions requestPerformanceRatingField(boolean value) {
            this.requestField("performance_rating", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestRawNameField() {
            return this.requestRawNameField(true);
        }

        public APIRequestGetTargetingSuggestions requestRawNameField(boolean value) {
            this.requestField("raw_name", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestRecommendationModelField() {
            return this.requestRecommendationModelField(true);
        }

        public APIRequestGetTargetingSuggestions requestRecommendationModelField(boolean value) {
            this.requestField("recommendation_model", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestSearchInterestIdField() {
            return this.requestSearchInterestIdField(true);
        }

        public APIRequestGetTargetingSuggestions requestSearchInterestIdField(boolean value) {
            this.requestField("search_interest_id", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGetTargetingSuggestions requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestSpendField() {
            return this.requestSpendField(true);
        }

        public APIRequestGetTargetingSuggestions requestSpendField(boolean value) {
            this.requestField("spend", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetTargetingSuggestions requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetTargetingSuggestions requestValidField() {
            return this.requestValidField(true);
        }

        public APIRequestGetTargetingSuggestions requestValidField(boolean value) {
            this.requestField("valid", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetTargetingSentenceLines
    extends APIRequest<TargetingSentenceLine> {
        APINodeList<TargetingSentenceLine> lastResponse = null;
        public static final String[] PARAMS = new String[]{"targeting_spec", "discard_ages", "discard_placements", "hide_targeting_spec_from_return"};
        public static final String[] FIELDS = new String[]{"id", "params", "targetingsentencelines"};

        @Override
        public APINodeList<TargetingSentenceLine> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<TargetingSentenceLine> parseResponse(String response) throws APIException {
            return TargetingSentenceLine.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<TargetingSentenceLine> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<TargetingSentenceLine> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<TargetingSentenceLine>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<TargetingSentenceLine>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<TargetingSentenceLine>>(){

                public APINodeList<TargetingSentenceLine> apply(String result) {
                    try {
                        return APIRequestGetTargetingSentenceLines.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetTargetingSentenceLines(String nodeId, APIContext context) {
            super(context, nodeId, "/targetingsentencelines", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTargetingSentenceLines setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTargetingSentenceLines setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTargetingSentenceLines setTargetingSpec(Targeting targetingSpec) {
            this.setParam("targeting_spec", targetingSpec);
            return this;
        }

        public APIRequestGetTargetingSentenceLines setTargetingSpec(String targetingSpec) {
            this.setParam("targeting_spec", targetingSpec);
            return this;
        }

        public APIRequestGetTargetingSentenceLines setDiscardAges(Boolean discardAges) {
            this.setParam("discard_ages", discardAges);
            return this;
        }

        public APIRequestGetTargetingSentenceLines setDiscardAges(String discardAges) {
            this.setParam("discard_ages", discardAges);
            return this;
        }

        public APIRequestGetTargetingSentenceLines setDiscardPlacements(Boolean discardPlacements) {
            this.setParam("discard_placements", discardPlacements);
            return this;
        }

        public APIRequestGetTargetingSentenceLines setDiscardPlacements(String discardPlacements) {
            this.setParam("discard_placements", discardPlacements);
            return this;
        }

        public APIRequestGetTargetingSentenceLines setHideTargetingSpecFromReturn(Boolean hideTargetingSpecFromReturn) {
            this.setParam("hide_targeting_spec_from_return", hideTargetingSpecFromReturn);
            return this;
        }

        public APIRequestGetTargetingSentenceLines setHideTargetingSpecFromReturn(String hideTargetingSpecFromReturn) {
            this.setParam("hide_targeting_spec_from_return", hideTargetingSpecFromReturn);
            return this;
        }

        public APIRequestGetTargetingSentenceLines requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTargetingSentenceLines requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTargetingSentenceLines requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTargetingSentenceLines requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTargetingSentenceLines requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTargetingSentenceLines requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetTargetingSentenceLines requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetTargetingSentenceLines requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetTargetingSentenceLines requestParamsField() {
            return this.requestParamsField(true);
        }

        public APIRequestGetTargetingSentenceLines requestParamsField(boolean value) {
            this.requestField("params", value);
            return this;
        }

        public APIRequestGetTargetingSentenceLines requestTargetingsentencelinesField() {
            return this.requestTargetingsentencelinesField(true);
        }

        public APIRequestGetTargetingSentenceLines requestTargetingsentencelinesField(boolean value) {
            this.requestField("targetingsentencelines", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetTargetingSearch
    extends APIRequest<AdAccountTargetingUnified> {
        APINodeList<AdAccountTargetingUnified> lastResponse = null;
        public static final String[] PARAMS = new String[]{"q", "limit_type", "whitelisted_types", "is_exclusion", "session_id", "targeting_list", "countries"};
        public static final String[] FIELDS = new String[]{"audience_size", "conversion_lift", "description", "id", "img", "info", "info_title", "is_recommendation", "key", "link", "name", "parent", "partner", "path", "performance_rating", "raw_name", "recommendation_model", "search_interest_id", "source", "spend", "type", "valid"};

        @Override
        public APINodeList<AdAccountTargetingUnified> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccountTargetingUnified> parseResponse(String response) throws APIException {
            return AdAccountTargetingUnified.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccountTargetingUnified> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccountTargetingUnified> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccountTargetingUnified>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccountTargetingUnified>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAccountTargetingUnified>>(){

                public APINodeList<AdAccountTargetingUnified> apply(String result) {
                    try {
                        return APIRequestGetTargetingSearch.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetTargetingSearch(String nodeId, APIContext context) {
            super(context, nodeId, "/targetingsearch", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTargetingSearch setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTargetingSearch setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTargetingSearch setQ(String q) {
            this.setParam("q", q);
            return this;
        }

        public APIRequestGetTargetingSearch setLimitType(AdAccountTargetingUnified.EnumLimitType limitType) {
            this.setParam("limit_type", (Object)limitType);
            return this;
        }

        public APIRequestGetTargetingSearch setLimitType(String limitType) {
            this.setParam("limit_type", limitType);
            return this;
        }

        public APIRequestGetTargetingSearch setWhitelistedTypes(List<AdAccountTargetingUnified.EnumWhitelistedTypes> whitelistedTypes) {
            this.setParam("whitelisted_types", whitelistedTypes);
            return this;
        }

        public APIRequestGetTargetingSearch setWhitelistedTypes(String whitelistedTypes) {
            this.setParam("whitelisted_types", whitelistedTypes);
            return this;
        }

        public APIRequestGetTargetingSearch setIsExclusion(Boolean isExclusion) {
            this.setParam("is_exclusion", isExclusion);
            return this;
        }

        public APIRequestGetTargetingSearch setIsExclusion(String isExclusion) {
            this.setParam("is_exclusion", isExclusion);
            return this;
        }

        public APIRequestGetTargetingSearch setSessionId(Long sessionId) {
            this.setParam("session_id", sessionId);
            return this;
        }

        public APIRequestGetTargetingSearch setSessionId(String sessionId) {
            this.setParam("session_id", sessionId);
            return this;
        }

        public APIRequestGetTargetingSearch setTargetingList(List<Object> targetingList) {
            this.setParam("targeting_list", targetingList);
            return this;
        }

        public APIRequestGetTargetingSearch setTargetingList(String targetingList) {
            this.setParam("targeting_list", targetingList);
            return this;
        }

        public APIRequestGetTargetingSearch setCountries(List<String> countries) {
            this.setParam("countries", countries);
            return this;
        }

        public APIRequestGetTargetingSearch setCountries(String countries) {
            this.setParam("countries", countries);
            return this;
        }

        public APIRequestGetTargetingSearch requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTargetingSearch requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTargetingSearch requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTargetingSearch requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTargetingSearch requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTargetingSearch requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetTargetingSearch requestAudienceSizeField() {
            return this.requestAudienceSizeField(true);
        }

        public APIRequestGetTargetingSearch requestAudienceSizeField(boolean value) {
            this.requestField("audience_size", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestConversionLiftField() {
            return this.requestConversionLiftField(true);
        }

        public APIRequestGetTargetingSearch requestConversionLiftField(boolean value) {
            this.requestField("conversion_lift", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetTargetingSearch requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetTargetingSearch requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestImgField() {
            return this.requestImgField(true);
        }

        public APIRequestGetTargetingSearch requestImgField(boolean value) {
            this.requestField("img", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestInfoField() {
            return this.requestInfoField(true);
        }

        public APIRequestGetTargetingSearch requestInfoField(boolean value) {
            this.requestField("info", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestInfoTitleField() {
            return this.requestInfoTitleField(true);
        }

        public APIRequestGetTargetingSearch requestInfoTitleField(boolean value) {
            this.requestField("info_title", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestIsRecommendationField() {
            return this.requestIsRecommendationField(true);
        }

        public APIRequestGetTargetingSearch requestIsRecommendationField(boolean value) {
            this.requestField("is_recommendation", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestKeyField() {
            return this.requestKeyField(true);
        }

        public APIRequestGetTargetingSearch requestKeyField(boolean value) {
            this.requestField("key", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetTargetingSearch requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetTargetingSearch requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestParentField() {
            return this.requestParentField(true);
        }

        public APIRequestGetTargetingSearch requestParentField(boolean value) {
            this.requestField("parent", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetTargetingSearch requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestPathField() {
            return this.requestPathField(true);
        }

        public APIRequestGetTargetingSearch requestPathField(boolean value) {
            this.requestField("path", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestPerformanceRatingField() {
            return this.requestPerformanceRatingField(true);
        }

        public APIRequestGetTargetingSearch requestPerformanceRatingField(boolean value) {
            this.requestField("performance_rating", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestRawNameField() {
            return this.requestRawNameField(true);
        }

        public APIRequestGetTargetingSearch requestRawNameField(boolean value) {
            this.requestField("raw_name", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestRecommendationModelField() {
            return this.requestRecommendationModelField(true);
        }

        public APIRequestGetTargetingSearch requestRecommendationModelField(boolean value) {
            this.requestField("recommendation_model", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestSearchInterestIdField() {
            return this.requestSearchInterestIdField(true);
        }

        public APIRequestGetTargetingSearch requestSearchInterestIdField(boolean value) {
            this.requestField("search_interest_id", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGetTargetingSearch requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestSpendField() {
            return this.requestSpendField(true);
        }

        public APIRequestGetTargetingSearch requestSpendField(boolean value) {
            this.requestField("spend", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetTargetingSearch requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetTargetingSearch requestValidField() {
            return this.requestValidField(true);
        }

        public APIRequestGetTargetingSearch requestValidField(boolean value) {
            this.requestField("valid", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetTargetingBrowse
    extends APIRequest<AdAccountTargetingUnified> {
        APINodeList<AdAccountTargetingUnified> lastResponse = null;
        public static final String[] PARAMS = new String[]{"include_nodes", "excluded_category", "limit_type", "is_exclusion", "whitelisted_types"};
        public static final String[] FIELDS = new String[]{"audience_size", "conversion_lift", "description", "id", "img", "info", "info_title", "is_recommendation", "key", "link", "name", "parent", "partner", "path", "performance_rating", "raw_name", "recommendation_model", "search_interest_id", "source", "spend", "type", "valid"};

        @Override
        public APINodeList<AdAccountTargetingUnified> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccountTargetingUnified> parseResponse(String response) throws APIException {
            return AdAccountTargetingUnified.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccountTargetingUnified> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccountTargetingUnified> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccountTargetingUnified>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccountTargetingUnified>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAccountTargetingUnified>>(){

                public APINodeList<AdAccountTargetingUnified> apply(String result) {
                    try {
                        return APIRequestGetTargetingBrowse.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetTargetingBrowse(String nodeId, APIContext context) {
            super(context, nodeId, "/targetingbrowse", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTargetingBrowse setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTargetingBrowse setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTargetingBrowse setIncludeNodes(Boolean includeNodes) {
            this.setParam("include_nodes", includeNodes);
            return this;
        }

        public APIRequestGetTargetingBrowse setIncludeNodes(String includeNodes) {
            this.setParam("include_nodes", includeNodes);
            return this;
        }

        public APIRequestGetTargetingBrowse setExcludedCategory(String excludedCategory) {
            this.setParam("excluded_category", excludedCategory);
            return this;
        }

        public APIRequestGetTargetingBrowse setLimitType(AdAccountTargetingUnified.EnumLimitType limitType) {
            this.setParam("limit_type", (Object)limitType);
            return this;
        }

        public APIRequestGetTargetingBrowse setLimitType(String limitType) {
            this.setParam("limit_type", limitType);
            return this;
        }

        public APIRequestGetTargetingBrowse setIsExclusion(Boolean isExclusion) {
            this.setParam("is_exclusion", isExclusion);
            return this;
        }

        public APIRequestGetTargetingBrowse setIsExclusion(String isExclusion) {
            this.setParam("is_exclusion", isExclusion);
            return this;
        }

        public APIRequestGetTargetingBrowse setWhitelistedTypes(List<AdAccountTargetingUnified.EnumWhitelistedTypes> whitelistedTypes) {
            this.setParam("whitelisted_types", whitelistedTypes);
            return this;
        }

        public APIRequestGetTargetingBrowse setWhitelistedTypes(String whitelistedTypes) {
            this.setParam("whitelisted_types", whitelistedTypes);
            return this;
        }

        public APIRequestGetTargetingBrowse requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTargetingBrowse requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTargetingBrowse requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTargetingBrowse requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTargetingBrowse requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTargetingBrowse requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestAudienceSizeField() {
            return this.requestAudienceSizeField(true);
        }

        public APIRequestGetTargetingBrowse requestAudienceSizeField(boolean value) {
            this.requestField("audience_size", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestConversionLiftField() {
            return this.requestConversionLiftField(true);
        }

        public APIRequestGetTargetingBrowse requestConversionLiftField(boolean value) {
            this.requestField("conversion_lift", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetTargetingBrowse requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetTargetingBrowse requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestImgField() {
            return this.requestImgField(true);
        }

        public APIRequestGetTargetingBrowse requestImgField(boolean value) {
            this.requestField("img", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestInfoField() {
            return this.requestInfoField(true);
        }

        public APIRequestGetTargetingBrowse requestInfoField(boolean value) {
            this.requestField("info", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestInfoTitleField() {
            return this.requestInfoTitleField(true);
        }

        public APIRequestGetTargetingBrowse requestInfoTitleField(boolean value) {
            this.requestField("info_title", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestIsRecommendationField() {
            return this.requestIsRecommendationField(true);
        }

        public APIRequestGetTargetingBrowse requestIsRecommendationField(boolean value) {
            this.requestField("is_recommendation", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestKeyField() {
            return this.requestKeyField(true);
        }

        public APIRequestGetTargetingBrowse requestKeyField(boolean value) {
            this.requestField("key", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetTargetingBrowse requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetTargetingBrowse requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestParentField() {
            return this.requestParentField(true);
        }

        public APIRequestGetTargetingBrowse requestParentField(boolean value) {
            this.requestField("parent", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetTargetingBrowse requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestPathField() {
            return this.requestPathField(true);
        }

        public APIRequestGetTargetingBrowse requestPathField(boolean value) {
            this.requestField("path", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestPerformanceRatingField() {
            return this.requestPerformanceRatingField(true);
        }

        public APIRequestGetTargetingBrowse requestPerformanceRatingField(boolean value) {
            this.requestField("performance_rating", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestRawNameField() {
            return this.requestRawNameField(true);
        }

        public APIRequestGetTargetingBrowse requestRawNameField(boolean value) {
            this.requestField("raw_name", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestRecommendationModelField() {
            return this.requestRecommendationModelField(true);
        }

        public APIRequestGetTargetingBrowse requestRecommendationModelField(boolean value) {
            this.requestField("recommendation_model", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestSearchInterestIdField() {
            return this.requestSearchInterestIdField(true);
        }

        public APIRequestGetTargetingBrowse requestSearchInterestIdField(boolean value) {
            this.requestField("search_interest_id", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGetTargetingBrowse requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestSpendField() {
            return this.requestSpendField(true);
        }

        public APIRequestGetTargetingBrowse requestSpendField(boolean value) {
            this.requestField("spend", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetTargetingBrowse requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetTargetingBrowse requestValidField() {
            return this.requestValidField(true);
        }

        public APIRequestGetTargetingBrowse requestValidField(boolean value) {
            this.requestField("valid", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateSponsoredMessageAd
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"message_creative_id", "daily_budget", "bid_amount", "targeting"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateSponsoredMessageAd.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateSponsoredMessageAd(String nodeId, APIContext context) {
            super(context, nodeId, "/sponsored_message_ads", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateSponsoredMessageAd setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateSponsoredMessageAd setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateSponsoredMessageAd setMessageCreativeId(String messageCreativeId) {
            this.setParam("message_creative_id", messageCreativeId);
            return this;
        }

        public APIRequestCreateSponsoredMessageAd setDailyBudget(Long dailyBudget) {
            this.setParam("daily_budget", dailyBudget);
            return this;
        }

        public APIRequestCreateSponsoredMessageAd setDailyBudget(String dailyBudget) {
            this.setParam("daily_budget", dailyBudget);
            return this;
        }

        public APIRequestCreateSponsoredMessageAd setBidAmount(Long bidAmount) {
            this.setParam("bid_amount", bidAmount);
            return this;
        }

        public APIRequestCreateSponsoredMessageAd setBidAmount(String bidAmount) {
            this.setParam("bid_amount", bidAmount);
            return this;
        }

        public APIRequestCreateSponsoredMessageAd setTargeting(Targeting targeting) {
            this.setParam("targeting", targeting);
            return this;
        }

        public APIRequestCreateSponsoredMessageAd setTargeting(String targeting) {
            this.setParam("targeting", targeting);
            return this;
        }

        public APIRequestCreateSponsoredMessageAd requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateSponsoredMessageAd requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSponsoredMessageAd requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateSponsoredMessageAd requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSponsoredMessageAd requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateSponsoredMessageAd requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetSavedAudiences
    extends APIRequest<SavedAudience> {
        APINodeList<SavedAudience> lastResponse = null;
        public static final String[] PARAMS = new String[]{"fields", "filtering", "business_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<SavedAudience> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<SavedAudience> parseResponse(String response) throws APIException {
            return SavedAudience.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<SavedAudience> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<SavedAudience> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<SavedAudience>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<SavedAudience>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<SavedAudience>>(){

                public APINodeList<SavedAudience> apply(String result) {
                    try {
                        return APIRequestGetSavedAudiences.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetSavedAudiences(String nodeId, APIContext context) {
            super(context, nodeId, "/saved_audiences", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetSavedAudiences setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetSavedAudiences setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetSavedAudiences setFields(List<String> fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetSavedAudiences setFields(String fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetSavedAudiences setFiltering(List<Object> filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetSavedAudiences setFiltering(String filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetSavedAudiences setBusinessId(String businessId) {
            this.setParam("business_id", businessId);
            return this;
        }

        public APIRequestGetSavedAudiences requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetSavedAudiences requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSavedAudiences requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetSavedAudiences requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSavedAudiences requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetSavedAudiences requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetRoas
    extends APIRequest<AdAccountRoas> {
        APINodeList<AdAccountRoas> lastResponse = null;
        public static final String[] PARAMS = new String[]{"time_increment", "time_range", "fields", "filtering"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<AdAccountRoas> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccountRoas> parseResponse(String response) throws APIException {
            return AdAccountRoas.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccountRoas> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccountRoas> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccountRoas>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccountRoas>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAccountRoas>>(){

                public APINodeList<AdAccountRoas> apply(String result) {
                    try {
                        return APIRequestGetRoas.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetRoas(String nodeId, APIContext context) {
            super(context, nodeId, "/roas", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetRoas setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetRoas setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetRoas setTimeIncrement(String timeIncrement) {
            this.setParam("time_increment", timeIncrement);
            return this;
        }

        public APIRequestGetRoas setTimeRange(Object timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetRoas setTimeRange(String timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetRoas setFields(List<String> fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetRoas setFields(String fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetRoas setFiltering(List<Object> filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetRoas setFiltering(String filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetRoas requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetRoas requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetRoas requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetRoas requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetRoas requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetRoas requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateReportStat
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"time_ranges", "data_columns", "actions_group_by", "filters", "sort_by", "sort_dir", "time_increment", "time_interval", "date_preset", "format", "export_columns", "report_run_id", "name", "user_report", "business_id", "limit", "bypass_async", "summary"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateReportStat.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateReportStat(String nodeId, APIContext context) {
            super(context, nodeId, "/reportstats", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateReportStat setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateReportStat setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateReportStat setTimeRanges(Object timeRanges) {
            this.setParam("time_ranges", timeRanges);
            return this;
        }

        public APIRequestCreateReportStat setTimeRanges(String timeRanges) {
            this.setParam("time_ranges", timeRanges);
            return this;
        }

        public APIRequestCreateReportStat setDataColumns(List<String> dataColumns) {
            this.setParam("data_columns", dataColumns);
            return this;
        }

        public APIRequestCreateReportStat setDataColumns(String dataColumns) {
            this.setParam("data_columns", dataColumns);
            return this;
        }

        public APIRequestCreateReportStat setActionsGroupBy(List<EnumActionsGroupBy> actionsGroupBy) {
            this.setParam("actions_group_by", actionsGroupBy);
            return this;
        }

        public APIRequestCreateReportStat setActionsGroupBy(String actionsGroupBy) {
            this.setParam("actions_group_by", actionsGroupBy);
            return this;
        }

        public APIRequestCreateReportStat setFilters(List<Object> filters) {
            this.setParam("filters", filters);
            return this;
        }

        public APIRequestCreateReportStat setFilters(String filters) {
            this.setParam("filters", filters);
            return this;
        }

        public APIRequestCreateReportStat setSortBy(String sortBy) {
            this.setParam("sort_by", sortBy);
            return this;
        }

        public APIRequestCreateReportStat setSortDir(String sortDir) {
            this.setParam("sort_dir", sortDir);
            return this;
        }

        public APIRequestCreateReportStat setTimeIncrement(String timeIncrement) {
            this.setParam("time_increment", timeIncrement);
            return this;
        }

        public APIRequestCreateReportStat setTimeInterval(Object timeInterval) {
            this.setParam("time_interval", timeInterval);
            return this;
        }

        public APIRequestCreateReportStat setTimeInterval(String timeInterval) {
            this.setParam("time_interval", timeInterval);
            return this;
        }

        public APIRequestCreateReportStat setDatePreset(EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestCreateReportStat setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestCreateReportStat setFormat(EnumFormat format) {
            this.setParam("format", (Object)format);
            return this;
        }

        public APIRequestCreateReportStat setFormat(String format) {
            this.setParam("format", format);
            return this;
        }

        public APIRequestCreateReportStat setExportColumns(Object exportColumns) {
            this.setParam("export_columns", exportColumns);
            return this;
        }

        public APIRequestCreateReportStat setExportColumns(String exportColumns) {
            this.setParam("export_columns", exportColumns);
            return this;
        }

        public APIRequestCreateReportStat setReportRunId(String reportRunId) {
            this.setParam("report_run_id", reportRunId);
            return this;
        }

        public APIRequestCreateReportStat setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateReportStat setUserReport(Boolean userReport) {
            this.setParam("user_report", userReport);
            return this;
        }

        public APIRequestCreateReportStat setUserReport(String userReport) {
            this.setParam("user_report", userReport);
            return this;
        }

        public APIRequestCreateReportStat setBusinessId(String businessId) {
            this.setParam("business_id", businessId);
            return this;
        }

        public APIRequestCreateReportStat setLimit(Long limit) {
            this.setParam("limit", limit);
            return this;
        }

        public APIRequestCreateReportStat setLimit(String limit) {
            this.setParam("limit", limit);
            return this;
        }

        public APIRequestCreateReportStat setBypassAsync(Boolean bypassAsync) {
            this.setParam("bypass_async", bypassAsync);
            return this;
        }

        public APIRequestCreateReportStat setBypassAsync(String bypassAsync) {
            this.setParam("bypass_async", bypassAsync);
            return this;
        }

        public APIRequestCreateReportStat setSummary(Boolean summary) {
            this.setParam("summary", summary);
            return this;
        }

        public APIRequestCreateReportStat setSummary(String summary) {
            this.setParam("summary", summary);
            return this;
        }

        public APIRequestCreateReportStat requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateReportStat requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateReportStat requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateReportStat requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateReportStat requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateReportStat requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateReferral
    extends APIRequest<Referral> {
        Referral lastResponse = null;
        public static final String[] PARAMS = new String[]{"invite_limit", "messenger_cta", "messenger_promotion_text", "namespace", "need_promo_code", "offer_origin", "promotion_text", "receiver_benefits_text", "referral_link_uri", "sender_benefits_text"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Referral getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Referral parseResponse(String response) throws APIException {
            return Referral.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Referral execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Referral execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<Referral> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Referral> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Referral>(){

                public Referral apply(String result) {
                    try {
                        return APIRequestCreateReferral.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateReferral(String nodeId, APIContext context) {
            super(context, nodeId, "/referral", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateReferral setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateReferral setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateReferral setInviteLimit(Long inviteLimit) {
            this.setParam("invite_limit", inviteLimit);
            return this;
        }

        public APIRequestCreateReferral setInviteLimit(String inviteLimit) {
            this.setParam("invite_limit", inviteLimit);
            return this;
        }

        public APIRequestCreateReferral setMessengerCta(String messengerCta) {
            this.setParam("messenger_cta", messengerCta);
            return this;
        }

        public APIRequestCreateReferral setMessengerPromotionText(String messengerPromotionText) {
            this.setParam("messenger_promotion_text", messengerPromotionText);
            return this;
        }

        public APIRequestCreateReferral setNamespace(Long namespace) {
            this.setParam("namespace", namespace);
            return this;
        }

        public APIRequestCreateReferral setNamespace(String namespace) {
            this.setParam("namespace", namespace);
            return this;
        }

        public APIRequestCreateReferral setNeedPromoCode(Boolean needPromoCode) {
            this.setParam("need_promo_code", needPromoCode);
            return this;
        }

        public APIRequestCreateReferral setNeedPromoCode(String needPromoCode) {
            this.setParam("need_promo_code", needPromoCode);
            return this;
        }

        public APIRequestCreateReferral setOfferOrigin(String offerOrigin) {
            this.setParam("offer_origin", offerOrigin);
            return this;
        }

        public APIRequestCreateReferral setPromotionText(String promotionText) {
            this.setParam("promotion_text", promotionText);
            return this;
        }

        public APIRequestCreateReferral setReceiverBenefitsText(String receiverBenefitsText) {
            this.setParam("receiver_benefits_text", receiverBenefitsText);
            return this;
        }

        public APIRequestCreateReferral setReferralLinkUri(Object referralLinkUri) {
            this.setParam("referral_link_uri", referralLinkUri);
            return this;
        }

        public APIRequestCreateReferral setReferralLinkUri(String referralLinkUri) {
            this.setParam("referral_link_uri", referralLinkUri);
            return this;
        }

        public APIRequestCreateReferral setSenderBenefitsText(String senderBenefitsText) {
            this.setParam("sender_benefits_text", senderBenefitsText);
            return this;
        }

        public APIRequestCreateReferral requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateReferral requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateReferral requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateReferral requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateReferral requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateReferral requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetReferral
    extends APIRequest<Referral> {
        APINodeList<Referral> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "invite_limit", "messenger_cta", "messenger_promotion_text", "namespace", "need_promo_code", "offer_origin", "promotion_text", "receiver_benefits_text", "referral_link_uri", "sender_benefits_text"};

        @Override
        public APINodeList<Referral> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Referral> parseResponse(String response) throws APIException {
            return Referral.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Referral> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Referral> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Referral>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Referral>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Referral>>(){

                public APINodeList<Referral> apply(String result) {
                    try {
                        return APIRequestGetReferral.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetReferral(String nodeId, APIContext context) {
            super(context, nodeId, "/referral", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetReferral setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetReferral setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetReferral requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetReferral requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetReferral requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetReferral requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetReferral requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetReferral requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetReferral requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetReferral requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetReferral requestInviteLimitField() {
            return this.requestInviteLimitField(true);
        }

        public APIRequestGetReferral requestInviteLimitField(boolean value) {
            this.requestField("invite_limit", value);
            return this;
        }

        public APIRequestGetReferral requestMessengerCtaField() {
            return this.requestMessengerCtaField(true);
        }

        public APIRequestGetReferral requestMessengerCtaField(boolean value) {
            this.requestField("messenger_cta", value);
            return this;
        }

        public APIRequestGetReferral requestMessengerPromotionTextField() {
            return this.requestMessengerPromotionTextField(true);
        }

        public APIRequestGetReferral requestMessengerPromotionTextField(boolean value) {
            this.requestField("messenger_promotion_text", value);
            return this;
        }

        public APIRequestGetReferral requestNamespaceField() {
            return this.requestNamespaceField(true);
        }

        public APIRequestGetReferral requestNamespaceField(boolean value) {
            this.requestField("namespace", value);
            return this;
        }

        public APIRequestGetReferral requestNeedPromoCodeField() {
            return this.requestNeedPromoCodeField(true);
        }

        public APIRequestGetReferral requestNeedPromoCodeField(boolean value) {
            this.requestField("need_promo_code", value);
            return this;
        }

        public APIRequestGetReferral requestOfferOriginField() {
            return this.requestOfferOriginField(true);
        }

        public APIRequestGetReferral requestOfferOriginField(boolean value) {
            this.requestField("offer_origin", value);
            return this;
        }

        public APIRequestGetReferral requestPromotionTextField() {
            return this.requestPromotionTextField(true);
        }

        public APIRequestGetReferral requestPromotionTextField(boolean value) {
            this.requestField("promotion_text", value);
            return this;
        }

        public APIRequestGetReferral requestReceiverBenefitsTextField() {
            return this.requestReceiverBenefitsTextField(true);
        }

        public APIRequestGetReferral requestReceiverBenefitsTextField(boolean value) {
            this.requestField("receiver_benefits_text", value);
            return this;
        }

        public APIRequestGetReferral requestReferralLinkUriField() {
            return this.requestReferralLinkUriField(true);
        }

        public APIRequestGetReferral requestReferralLinkUriField(boolean value) {
            this.requestField("referral_link_uri", value);
            return this;
        }

        public APIRequestGetReferral requestSenderBenefitsTextField() {
            return this.requestSenderBenefitsTextField(true);
        }

        public APIRequestGetReferral requestSenderBenefitsTextField(boolean value) {
            this.requestField("sender_benefits_text", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateReachFrequencyPrediction
    extends APIRequest<ReachFrequencyPrediction> {
        ReachFrequencyPrediction lastResponse = null;
        public static final String[] PARAMS = new String[]{"action", "ad_formats", "target_spec", "start_time", "stop_time", "end_time", "reach", "impression", "frequency_cap", "budget", "prediction_mode", "destination_id", "destination_ids", "story_event_type", "day_parting_schedule", "target_cpm", "buying_type", "objective", "rf_prediction_id", "rf_prediction_id_to_release", "rf_prediction_id_to_share", "num_curve_points", "interval_frequency_cap_reset_period", "campaign_group_id", "grp_buying", "instream_packages", "is_bonus_media", "is_conversion_goal", "is_full_view", "is_reach_and_frequency_io_buying", "is_reserved_buying", "expiration_time", "existing_campaign_id", "video_view_length_constraint", "auction_entry_option_index", "exceptions"};
        public static final String[] FIELDS = new String[0];

        @Override
        public ReachFrequencyPrediction getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ReachFrequencyPrediction parseResponse(String response) throws APIException {
            return ReachFrequencyPrediction.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ReachFrequencyPrediction execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ReachFrequencyPrediction execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ReachFrequencyPrediction> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ReachFrequencyPrediction> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ReachFrequencyPrediction>(){

                public ReachFrequencyPrediction apply(String result) {
                    try {
                        return APIRequestCreateReachFrequencyPrediction.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateReachFrequencyPrediction(String nodeId, APIContext context) {
            super(context, nodeId, "/reachfrequencypredictions", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateReachFrequencyPrediction setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateReachFrequencyPrediction setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setAction(ReachFrequencyPrediction.EnumAction action) {
            this.setParam("action", (Object)action);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setAction(String action) {
            this.setParam("action", action);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setAdFormats(List<Map<String, String>> adFormats) {
            this.setParam("ad_formats", adFormats);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setAdFormats(String adFormats) {
            this.setParam("ad_formats", adFormats);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setTargetSpec(Targeting targetSpec) {
            this.setParam("target_spec", targetSpec);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setTargetSpec(String targetSpec) {
            this.setParam("target_spec", targetSpec);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setStartTime(Long startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setStopTime(Long stopTime) {
            this.setParam("stop_time", stopTime);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setStopTime(String stopTime) {
            this.setParam("stop_time", stopTime);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setEndTime(Long endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setReach(Long reach) {
            this.setParam("reach", reach);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setReach(String reach) {
            this.setParam("reach", reach);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setImpression(Long impression) {
            this.setParam("impression", impression);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setImpression(String impression) {
            this.setParam("impression", impression);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setFrequencyCap(Long frequencyCap) {
            this.setParam("frequency_cap", frequencyCap);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setFrequencyCap(String frequencyCap) {
            this.setParam("frequency_cap", frequencyCap);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setBudget(Long budget) {
            this.setParam("budget", budget);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setBudget(String budget) {
            this.setParam("budget", budget);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setPredictionMode(Long predictionMode) {
            this.setParam("prediction_mode", predictionMode);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setPredictionMode(String predictionMode) {
            this.setParam("prediction_mode", predictionMode);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setDestinationId(Long destinationId) {
            this.setParam("destination_id", destinationId);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setDestinationId(String destinationId) {
            this.setParam("destination_id", destinationId);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setDestinationIds(List<String> destinationIds) {
            this.setParam("destination_ids", destinationIds);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setDestinationIds(String destinationIds) {
            this.setParam("destination_ids", destinationIds);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setStoryEventType(Long storyEventType) {
            this.setParam("story_event_type", storyEventType);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setStoryEventType(String storyEventType) {
            this.setParam("story_event_type", storyEventType);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setDayPartingSchedule(List<Object> dayPartingSchedule) {
            this.setParam("day_parting_schedule", dayPartingSchedule);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setDayPartingSchedule(String dayPartingSchedule) {
            this.setParam("day_parting_schedule", dayPartingSchedule);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setTargetCpm(Long targetCpm) {
            this.setParam("target_cpm", targetCpm);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setTargetCpm(String targetCpm) {
            this.setParam("target_cpm", targetCpm);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setBuyingType(ReachFrequencyPrediction.EnumBuyingType buyingType) {
            this.setParam("buying_type", (Object)buyingType);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setBuyingType(String buyingType) {
            this.setParam("buying_type", buyingType);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setObjective(String objective) {
            this.setParam("objective", objective);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setRfPredictionId(String rfPredictionId) {
            this.setParam("rf_prediction_id", rfPredictionId);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setRfPredictionIdToRelease(String rfPredictionIdToRelease) {
            this.setParam("rf_prediction_id_to_release", rfPredictionIdToRelease);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setRfPredictionIdToShare(String rfPredictionIdToShare) {
            this.setParam("rf_prediction_id_to_share", rfPredictionIdToShare);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setNumCurvePoints(Long numCurvePoints) {
            this.setParam("num_curve_points", numCurvePoints);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setNumCurvePoints(String numCurvePoints) {
            this.setParam("num_curve_points", numCurvePoints);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setIntervalFrequencyCapResetPeriod(Long intervalFrequencyCapResetPeriod) {
            this.setParam("interval_frequency_cap_reset_period", intervalFrequencyCapResetPeriod);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setIntervalFrequencyCapResetPeriod(String intervalFrequencyCapResetPeriod) {
            this.setParam("interval_frequency_cap_reset_period", intervalFrequencyCapResetPeriod);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setCampaignGroupId(String campaignGroupId) {
            this.setParam("campaign_group_id", campaignGroupId);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setGrpBuying(Boolean grpBuying) {
            this.setParam("grp_buying", grpBuying);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setGrpBuying(String grpBuying) {
            this.setParam("grp_buying", grpBuying);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setInstreamPackages(List<ReachFrequencyPrediction.EnumInstreamPackages> instreamPackages) {
            this.setParam("instream_packages", instreamPackages);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setInstreamPackages(String instreamPackages) {
            this.setParam("instream_packages", instreamPackages);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setIsBonusMedia(Boolean isBonusMedia) {
            this.setParam("is_bonus_media", isBonusMedia);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setIsBonusMedia(String isBonusMedia) {
            this.setParam("is_bonus_media", isBonusMedia);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setIsConversionGoal(Boolean isConversionGoal) {
            this.setParam("is_conversion_goal", isConversionGoal);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setIsConversionGoal(String isConversionGoal) {
            this.setParam("is_conversion_goal", isConversionGoal);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setIsFullView(Boolean isFullView) {
            this.setParam("is_full_view", isFullView);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setIsFullView(String isFullView) {
            this.setParam("is_full_view", isFullView);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setIsReachAndFrequencyIoBuying(Boolean isReachAndFrequencyIoBuying) {
            this.setParam("is_reach_and_frequency_io_buying", isReachAndFrequencyIoBuying);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setIsReachAndFrequencyIoBuying(String isReachAndFrequencyIoBuying) {
            this.setParam("is_reach_and_frequency_io_buying", isReachAndFrequencyIoBuying);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setIsReservedBuying(Boolean isReservedBuying) {
            this.setParam("is_reserved_buying", isReservedBuying);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setIsReservedBuying(String isReservedBuying) {
            this.setParam("is_reserved_buying", isReservedBuying);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setExpirationTime(Long expirationTime) {
            this.setParam("expiration_time", expirationTime);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setExpirationTime(String expirationTime) {
            this.setParam("expiration_time", expirationTime);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setExistingCampaignId(String existingCampaignId) {
            this.setParam("existing_campaign_id", existingCampaignId);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setVideoViewLengthConstraint(Long videoViewLengthConstraint) {
            this.setParam("video_view_length_constraint", videoViewLengthConstraint);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setVideoViewLengthConstraint(String videoViewLengthConstraint) {
            this.setParam("video_view_length_constraint", videoViewLengthConstraint);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setAuctionEntryOptionIndex(Long auctionEntryOptionIndex) {
            this.setParam("auction_entry_option_index", auctionEntryOptionIndex);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setAuctionEntryOptionIndex(String auctionEntryOptionIndex) {
            this.setParam("auction_entry_option_index", auctionEntryOptionIndex);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setExceptions(Boolean exceptions) {
            this.setParam("exceptions", exceptions);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction setExceptions(String exceptions) {
            this.setParam("exceptions", exceptions);
            return this;
        }

        public APIRequestCreateReachFrequencyPrediction requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateReachFrequencyPrediction requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateReachFrequencyPrediction requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateReachFrequencyPrediction requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateReachFrequencyPrediction requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateReachFrequencyPrediction requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetReachFrequencyPredictions
    extends APIRequest<ReachFrequencyPrediction> {
        APINodeList<ReachFrequencyPrediction> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "activity_status", "ad_formats", "auction_entry_option_index", "business_id", "buying_type", "campaign_group_id", "campaign_id", "campaign_time_start", "campaign_time_stop", "currency", "curve_budget_reach", "curve_reach", "daily_grp_curve", "daily_impression_curve", "daily_impression_curve_map", "day_parting_schedule", "demo_breakdown", "destination_id", "end_time", "expiration_time", "external_budget", "external_impression", "external_maximum_budget", "external_maximum_impression", "external_maximum_reach", "external_minimum_budget", "external_minimum_impression", "external_minimum_reach", "external_reach", "external_values_breakdown", "feed_ratio_0000", "frequency_cap", "frequency_distribution", "frequency_distribution_map", "frequency_distribution_map_agg", "full_view_ratio_00", "grp_audience_size", "grp_avg_probability_map", "grp_country_audience_size", "grp_curve", "grp_dmas_audience_size", "grp_filtering_threshold_00", "grp_points", "grp_ratio", "grp_reach_ratio", "grp_status", "holdout_percentage", "id", "impression_curve", "instagram_destination_id", "instream_packages", "interval_frequency_cap", "interval_frequency_cap_reset_period", "is_bonus_media", "is_conversion_goal", "is_higher_average_frequency", "is_io", "is_reserved_buying", "is_trp", "name", "objective", "objective_name", "pause_periods", "placement_breakdown", "placement_breakdown_map", "plan_name", "plan_type", "prediction_mode", "prediction_progress", "reference_id", "reservation_status", "start_time", "status", "story_event_type", "target_audience_size", "target_cpm", "target_spec", "time_created", "time_updated", "timezone_id", "timezone_name", "topline_id", "tv_viewer_cluster_map", "video_view_benchmark_map", "video_view_length_constraint", "viewtag"};

        @Override
        public APINodeList<ReachFrequencyPrediction> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ReachFrequencyPrediction> parseResponse(String response) throws APIException {
            return ReachFrequencyPrediction.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<ReachFrequencyPrediction> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ReachFrequencyPrediction> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ReachFrequencyPrediction>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ReachFrequencyPrediction>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<ReachFrequencyPrediction>>(){

                public APINodeList<ReachFrequencyPrediction> apply(String result) {
                    try {
                        return APIRequestGetReachFrequencyPredictions.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetReachFrequencyPredictions(String nodeId, APIContext context) {
            super(context, nodeId, "/reachfrequencypredictions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetReachFrequencyPredictions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetReachFrequencyPredictions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetReachFrequencyPredictions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetReachFrequencyPredictions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetReachFrequencyPredictions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetReachFrequencyPredictions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetReachFrequencyPredictions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestActivityStatusField() {
            return this.requestActivityStatusField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestActivityStatusField(boolean value) {
            this.requestField("activity_status", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestAdFormatsField() {
            return this.requestAdFormatsField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestAdFormatsField(boolean value) {
            this.requestField("ad_formats", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestAuctionEntryOptionIndexField() {
            return this.requestAuctionEntryOptionIndexField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestAuctionEntryOptionIndexField(boolean value) {
            this.requestField("auction_entry_option_index", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestBusinessIdField() {
            return this.requestBusinessIdField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestBusinessIdField(boolean value) {
            this.requestField("business_id", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestBuyingTypeField() {
            return this.requestBuyingTypeField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestBuyingTypeField(boolean value) {
            this.requestField("buying_type", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestCampaignGroupIdField() {
            return this.requestCampaignGroupIdField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestCampaignGroupIdField(boolean value) {
            this.requestField("campaign_group_id", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestCampaignTimeStartField() {
            return this.requestCampaignTimeStartField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestCampaignTimeStartField(boolean value) {
            this.requestField("campaign_time_start", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestCampaignTimeStopField() {
            return this.requestCampaignTimeStopField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestCampaignTimeStopField(boolean value) {
            this.requestField("campaign_time_stop", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestCurveBudgetReachField() {
            return this.requestCurveBudgetReachField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestCurveBudgetReachField(boolean value) {
            this.requestField("curve_budget_reach", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestCurveReachField() {
            return this.requestCurveReachField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestCurveReachField(boolean value) {
            this.requestField("curve_reach", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestDailyGrpCurveField() {
            return this.requestDailyGrpCurveField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestDailyGrpCurveField(boolean value) {
            this.requestField("daily_grp_curve", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestDailyImpressionCurveField() {
            return this.requestDailyImpressionCurveField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestDailyImpressionCurveField(boolean value) {
            this.requestField("daily_impression_curve", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestDailyImpressionCurveMapField() {
            return this.requestDailyImpressionCurveMapField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestDailyImpressionCurveMapField(boolean value) {
            this.requestField("daily_impression_curve_map", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestDayPartingScheduleField() {
            return this.requestDayPartingScheduleField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestDayPartingScheduleField(boolean value) {
            this.requestField("day_parting_schedule", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestDemoBreakdownField() {
            return this.requestDemoBreakdownField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestDemoBreakdownField(boolean value) {
            this.requestField("demo_breakdown", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestDestinationIdField() {
            return this.requestDestinationIdField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestDestinationIdField(boolean value) {
            this.requestField("destination_id", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestExpirationTimeField() {
            return this.requestExpirationTimeField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestExpirationTimeField(boolean value) {
            this.requestField("expiration_time", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestExternalBudgetField() {
            return this.requestExternalBudgetField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestExternalBudgetField(boolean value) {
            this.requestField("external_budget", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestExternalImpressionField() {
            return this.requestExternalImpressionField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestExternalImpressionField(boolean value) {
            this.requestField("external_impression", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestExternalMaximumBudgetField() {
            return this.requestExternalMaximumBudgetField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestExternalMaximumBudgetField(boolean value) {
            this.requestField("external_maximum_budget", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestExternalMaximumImpressionField() {
            return this.requestExternalMaximumImpressionField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestExternalMaximumImpressionField(boolean value) {
            this.requestField("external_maximum_impression", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestExternalMaximumReachField() {
            return this.requestExternalMaximumReachField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestExternalMaximumReachField(boolean value) {
            this.requestField("external_maximum_reach", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestExternalMinimumBudgetField() {
            return this.requestExternalMinimumBudgetField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestExternalMinimumBudgetField(boolean value) {
            this.requestField("external_minimum_budget", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestExternalMinimumImpressionField() {
            return this.requestExternalMinimumImpressionField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestExternalMinimumImpressionField(boolean value) {
            this.requestField("external_minimum_impression", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestExternalMinimumReachField() {
            return this.requestExternalMinimumReachField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestExternalMinimumReachField(boolean value) {
            this.requestField("external_minimum_reach", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestExternalReachField() {
            return this.requestExternalReachField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestExternalReachField(boolean value) {
            this.requestField("external_reach", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestExternalValuesBreakdownField() {
            return this.requestExternalValuesBreakdownField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestExternalValuesBreakdownField(boolean value) {
            this.requestField("external_values_breakdown", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestFeedRatio0000Field() {
            return this.requestFeedRatio0000Field(true);
        }

        public APIRequestGetReachFrequencyPredictions requestFeedRatio0000Field(boolean value) {
            this.requestField("feed_ratio_0000", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestFrequencyCapField() {
            return this.requestFrequencyCapField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestFrequencyCapField(boolean value) {
            this.requestField("frequency_cap", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestFrequencyDistributionField() {
            return this.requestFrequencyDistributionField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestFrequencyDistributionField(boolean value) {
            this.requestField("frequency_distribution", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestFrequencyDistributionMapField() {
            return this.requestFrequencyDistributionMapField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestFrequencyDistributionMapField(boolean value) {
            this.requestField("frequency_distribution_map", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestFrequencyDistributionMapAggField() {
            return this.requestFrequencyDistributionMapAggField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestFrequencyDistributionMapAggField(boolean value) {
            this.requestField("frequency_distribution_map_agg", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestFullViewRatio00Field() {
            return this.requestFullViewRatio00Field(true);
        }

        public APIRequestGetReachFrequencyPredictions requestFullViewRatio00Field(boolean value) {
            this.requestField("full_view_ratio_00", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestGrpAudienceSizeField() {
            return this.requestGrpAudienceSizeField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestGrpAudienceSizeField(boolean value) {
            this.requestField("grp_audience_size", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestGrpAvgProbabilityMapField() {
            return this.requestGrpAvgProbabilityMapField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestGrpAvgProbabilityMapField(boolean value) {
            this.requestField("grp_avg_probability_map", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestGrpCountryAudienceSizeField() {
            return this.requestGrpCountryAudienceSizeField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestGrpCountryAudienceSizeField(boolean value) {
            this.requestField("grp_country_audience_size", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestGrpCurveField() {
            return this.requestGrpCurveField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestGrpCurveField(boolean value) {
            this.requestField("grp_curve", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestGrpDmasAudienceSizeField() {
            return this.requestGrpDmasAudienceSizeField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestGrpDmasAudienceSizeField(boolean value) {
            this.requestField("grp_dmas_audience_size", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestGrpFilteringThreshold00Field() {
            return this.requestGrpFilteringThreshold00Field(true);
        }

        public APIRequestGetReachFrequencyPredictions requestGrpFilteringThreshold00Field(boolean value) {
            this.requestField("grp_filtering_threshold_00", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestGrpPointsField() {
            return this.requestGrpPointsField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestGrpPointsField(boolean value) {
            this.requestField("grp_points", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestGrpRatioField() {
            return this.requestGrpRatioField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestGrpRatioField(boolean value) {
            this.requestField("grp_ratio", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestGrpReachRatioField() {
            return this.requestGrpReachRatioField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestGrpReachRatioField(boolean value) {
            this.requestField("grp_reach_ratio", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestGrpStatusField() {
            return this.requestGrpStatusField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestGrpStatusField(boolean value) {
            this.requestField("grp_status", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestHoldoutPercentageField() {
            return this.requestHoldoutPercentageField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestHoldoutPercentageField(boolean value) {
            this.requestField("holdout_percentage", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestImpressionCurveField() {
            return this.requestImpressionCurveField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestImpressionCurveField(boolean value) {
            this.requestField("impression_curve", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestInstagramDestinationIdField() {
            return this.requestInstagramDestinationIdField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestInstagramDestinationIdField(boolean value) {
            this.requestField("instagram_destination_id", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestInstreamPackagesField() {
            return this.requestInstreamPackagesField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestInstreamPackagesField(boolean value) {
            this.requestField("instream_packages", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestIntervalFrequencyCapField() {
            return this.requestIntervalFrequencyCapField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestIntervalFrequencyCapField(boolean value) {
            this.requestField("interval_frequency_cap", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestIntervalFrequencyCapResetPeriodField() {
            return this.requestIntervalFrequencyCapResetPeriodField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestIntervalFrequencyCapResetPeriodField(boolean value) {
            this.requestField("interval_frequency_cap_reset_period", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestIsBonusMediaField() {
            return this.requestIsBonusMediaField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestIsBonusMediaField(boolean value) {
            this.requestField("is_bonus_media", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestIsConversionGoalField() {
            return this.requestIsConversionGoalField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestIsConversionGoalField(boolean value) {
            this.requestField("is_conversion_goal", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestIsHigherAverageFrequencyField() {
            return this.requestIsHigherAverageFrequencyField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestIsHigherAverageFrequencyField(boolean value) {
            this.requestField("is_higher_average_frequency", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestIsIoField() {
            return this.requestIsIoField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestIsIoField(boolean value) {
            this.requestField("is_io", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestIsReservedBuyingField() {
            return this.requestIsReservedBuyingField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestIsReservedBuyingField(boolean value) {
            this.requestField("is_reserved_buying", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestIsTrpField() {
            return this.requestIsTrpField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestIsTrpField(boolean value) {
            this.requestField("is_trp", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestObjectiveField() {
            return this.requestObjectiveField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestObjectiveField(boolean value) {
            this.requestField("objective", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestObjectiveNameField() {
            return this.requestObjectiveNameField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestObjectiveNameField(boolean value) {
            this.requestField("objective_name", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestPausePeriodsField() {
            return this.requestPausePeriodsField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestPausePeriodsField(boolean value) {
            this.requestField("pause_periods", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestPlacementBreakdownField() {
            return this.requestPlacementBreakdownField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestPlacementBreakdownField(boolean value) {
            this.requestField("placement_breakdown", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestPlacementBreakdownMapField() {
            return this.requestPlacementBreakdownMapField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestPlacementBreakdownMapField(boolean value) {
            this.requestField("placement_breakdown_map", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestPlanNameField() {
            return this.requestPlanNameField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestPlanNameField(boolean value) {
            this.requestField("plan_name", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestPlanTypeField() {
            return this.requestPlanTypeField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestPlanTypeField(boolean value) {
            this.requestField("plan_type", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestPredictionModeField() {
            return this.requestPredictionModeField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestPredictionModeField(boolean value) {
            this.requestField("prediction_mode", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestPredictionProgressField() {
            return this.requestPredictionProgressField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestPredictionProgressField(boolean value) {
            this.requestField("prediction_progress", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestReferenceIdField() {
            return this.requestReferenceIdField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestReferenceIdField(boolean value) {
            this.requestField("reference_id", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestReservationStatusField() {
            return this.requestReservationStatusField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestReservationStatusField(boolean value) {
            this.requestField("reservation_status", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestStoryEventTypeField() {
            return this.requestStoryEventTypeField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestStoryEventTypeField(boolean value) {
            this.requestField("story_event_type", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestTargetAudienceSizeField() {
            return this.requestTargetAudienceSizeField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestTargetAudienceSizeField(boolean value) {
            this.requestField("target_audience_size", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestTargetCpmField() {
            return this.requestTargetCpmField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestTargetCpmField(boolean value) {
            this.requestField("target_cpm", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestTargetSpecField() {
            return this.requestTargetSpecField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestTargetSpecField(boolean value) {
            this.requestField("target_spec", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestTimeUpdatedField() {
            return this.requestTimeUpdatedField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestTimeUpdatedField(boolean value) {
            this.requestField("time_updated", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestToplineIdField() {
            return this.requestToplineIdField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestToplineIdField(boolean value) {
            this.requestField("topline_id", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestTvViewerClusterMapField() {
            return this.requestTvViewerClusterMapField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestTvViewerClusterMapField(boolean value) {
            this.requestField("tv_viewer_cluster_map", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestVideoViewBenchmarkMapField() {
            return this.requestVideoViewBenchmarkMapField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestVideoViewBenchmarkMapField(boolean value) {
            this.requestField("video_view_benchmark_map", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestVideoViewLengthConstraintField() {
            return this.requestVideoViewLengthConstraintField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestVideoViewLengthConstraintField(boolean value) {
            this.requestField("video_view_length_constraint", value);
            return this;
        }

        public APIRequestGetReachFrequencyPredictions requestViewtagField() {
            return this.requestViewtagField(true);
        }

        public APIRequestGetReachFrequencyPredictions requestViewtagField(boolean value) {
            this.requestField("viewtag", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetReachEstimate
    extends APIRequest<ReachEstimate> {
        APINodeList<ReachEstimate> lastResponse = null;
        public static final String[] PARAMS = new String[]{"targeting_spec", "currency", "is_debug", "optimize_for", "daily_budget", "creative_action_spec", "adgroup_ids", "concepts", "caller_id", "object_store_url"};
        public static final String[] FIELDS = new String[]{"estimate_ready", "unsupported", "users", "id"};

        @Override
        public APINodeList<ReachEstimate> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ReachEstimate> parseResponse(String response) throws APIException {
            return ReachEstimate.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<ReachEstimate> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ReachEstimate> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ReachEstimate>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ReachEstimate>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<ReachEstimate>>(){

                public APINodeList<ReachEstimate> apply(String result) {
                    try {
                        return APIRequestGetReachEstimate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetReachEstimate(String nodeId, APIContext context) {
            super(context, nodeId, "/reachestimate", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetReachEstimate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetReachEstimate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetReachEstimate setTargetingSpec(Targeting targetingSpec) {
            this.setParam("targeting_spec", targetingSpec);
            return this;
        }

        public APIRequestGetReachEstimate setTargetingSpec(String targetingSpec) {
            this.setParam("targeting_spec", targetingSpec);
            return this;
        }

        public APIRequestGetReachEstimate setCurrency(String currency) {
            this.setParam("currency", currency);
            return this;
        }

        public APIRequestGetReachEstimate setIsDebug(Boolean isDebug) {
            this.setParam("is_debug", isDebug);
            return this;
        }

        public APIRequestGetReachEstimate setIsDebug(String isDebug) {
            this.setParam("is_debug", isDebug);
            return this;
        }

        public APIRequestGetReachEstimate setOptimizeFor(ReachEstimate.EnumOptimizeFor optimizeFor) {
            this.setParam("optimize_for", (Object)optimizeFor);
            return this;
        }

        public APIRequestGetReachEstimate setOptimizeFor(String optimizeFor) {
            this.setParam("optimize_for", optimizeFor);
            return this;
        }

        public APIRequestGetReachEstimate setDailyBudget(Double dailyBudget) {
            this.setParam("daily_budget", dailyBudget);
            return this;
        }

        public APIRequestGetReachEstimate setDailyBudget(String dailyBudget) {
            this.setParam("daily_budget", dailyBudget);
            return this;
        }

        public APIRequestGetReachEstimate setCreativeActionSpec(String creativeActionSpec) {
            this.setParam("creative_action_spec", creativeActionSpec);
            return this;
        }

        public APIRequestGetReachEstimate setAdgroupIds(List<String> adgroupIds) {
            this.setParam("adgroup_ids", adgroupIds);
            return this;
        }

        public APIRequestGetReachEstimate setAdgroupIds(String adgroupIds) {
            this.setParam("adgroup_ids", adgroupIds);
            return this;
        }

        public APIRequestGetReachEstimate setConcepts(String concepts) {
            this.setParam("concepts", concepts);
            return this;
        }

        public APIRequestGetReachEstimate setCallerId(String callerId) {
            this.setParam("caller_id", callerId);
            return this;
        }

        public APIRequestGetReachEstimate setObjectStoreUrl(String objectStoreUrl) {
            this.setParam("object_store_url", objectStoreUrl);
            return this;
        }

        public APIRequestGetReachEstimate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetReachEstimate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetReachEstimate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetReachEstimate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetReachEstimate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetReachEstimate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetReachEstimate requestEstimateReadyField() {
            return this.requestEstimateReadyField(true);
        }

        public APIRequestGetReachEstimate requestEstimateReadyField(boolean value) {
            this.requestField("estimate_ready", value);
            return this;
        }

        public APIRequestGetReachEstimate requestUnsupportedField() {
            return this.requestUnsupportedField(true);
        }

        public APIRequestGetReachEstimate requestUnsupportedField(boolean value) {
            this.requestField("unsupported", value);
            return this;
        }

        public APIRequestGetReachEstimate requestUsersField() {
            return this.requestUsersField(true);
        }

        public APIRequestGetReachEstimate requestUsersField(boolean value) {
            this.requestField("users", value);
            return this;
        }

        public APIRequestGetReachEstimate requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetReachEstimate requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreatePublisherBlockList
    extends APIRequest<PublisherBlockList> {
        PublisherBlockList lastResponse = null;
        public static final String[] PARAMS = new String[]{"name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public PublisherBlockList getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PublisherBlockList parseResponse(String response) throws APIException {
            return PublisherBlockList.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public PublisherBlockList execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PublisherBlockList execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<PublisherBlockList> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PublisherBlockList> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PublisherBlockList>(){

                public PublisherBlockList apply(String result) {
                    try {
                        return APIRequestCreatePublisherBlockList.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreatePublisherBlockList(String nodeId, APIContext context) {
            super(context, nodeId, "/publisher_block_lists", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreatePublisherBlockList setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreatePublisherBlockList setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreatePublisherBlockList setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreatePublisherBlockList requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreatePublisherBlockList requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePublisherBlockList requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreatePublisherBlockList requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePublisherBlockList requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreatePublisherBlockList requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPublisherBlockLists
    extends APIRequest<PublisherBlockList> {
        APINodeList<PublisherBlockList> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"app_publishers", "business_owner_id", "id", "is_auto_blocking_on", "is_eligible_at_campaign_level", "last_update_time", "last_update_user", "name", "owner_ad_account_id", "web_publishers"};

        @Override
        public APINodeList<PublisherBlockList> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<PublisherBlockList> parseResponse(String response) throws APIException {
            return PublisherBlockList.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<PublisherBlockList> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<PublisherBlockList> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<PublisherBlockList>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<PublisherBlockList>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<PublisherBlockList>>(){

                public APINodeList<PublisherBlockList> apply(String result) {
                    try {
                        return APIRequestGetPublisherBlockLists.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPublisherBlockLists(String nodeId, APIContext context) {
            super(context, nodeId, "/publisher_block_lists", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPublisherBlockLists setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPublisherBlockLists setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPublisherBlockLists requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPublisherBlockLists requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPublisherBlockLists requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPublisherBlockLists requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPublisherBlockLists requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPublisherBlockLists requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPublisherBlockLists requestAppPublishersField() {
            return this.requestAppPublishersField(true);
        }

        public APIRequestGetPublisherBlockLists requestAppPublishersField(boolean value) {
            this.requestField("app_publishers", value);
            return this;
        }

        public APIRequestGetPublisherBlockLists requestBusinessOwnerIdField() {
            return this.requestBusinessOwnerIdField(true);
        }

        public APIRequestGetPublisherBlockLists requestBusinessOwnerIdField(boolean value) {
            this.requestField("business_owner_id", value);
            return this;
        }

        public APIRequestGetPublisherBlockLists requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPublisherBlockLists requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetPublisherBlockLists requestIsAutoBlockingOnField() {
            return this.requestIsAutoBlockingOnField(true);
        }

        public APIRequestGetPublisherBlockLists requestIsAutoBlockingOnField(boolean value) {
            this.requestField("is_auto_blocking_on", value);
            return this;
        }

        public APIRequestGetPublisherBlockLists requestIsEligibleAtCampaignLevelField() {
            return this.requestIsEligibleAtCampaignLevelField(true);
        }

        public APIRequestGetPublisherBlockLists requestIsEligibleAtCampaignLevelField(boolean value) {
            this.requestField("is_eligible_at_campaign_level", value);
            return this;
        }

        public APIRequestGetPublisherBlockLists requestLastUpdateTimeField() {
            return this.requestLastUpdateTimeField(true);
        }

        public APIRequestGetPublisherBlockLists requestLastUpdateTimeField(boolean value) {
            this.requestField("last_update_time", value);
            return this;
        }

        public APIRequestGetPublisherBlockLists requestLastUpdateUserField() {
            return this.requestLastUpdateUserField(true);
        }

        public APIRequestGetPublisherBlockLists requestLastUpdateUserField(boolean value) {
            this.requestField("last_update_user", value);
            return this;
        }

        public APIRequestGetPublisherBlockLists requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetPublisherBlockLists requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetPublisherBlockLists requestOwnerAdAccountIdField() {
            return this.requestOwnerAdAccountIdField(true);
        }

        public APIRequestGetPublisherBlockLists requestOwnerAdAccountIdField(boolean value) {
            this.requestField("owner_ad_account_id", value);
            return this;
        }

        public APIRequestGetPublisherBlockLists requestWebPublishersField() {
            return this.requestWebPublishersField(true);
        }

        public APIRequestGetPublisherBlockLists requestWebPublishersField(boolean value) {
            this.requestField("web_publishers", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPromotePages
    extends APIRequest<Page> {
        APINodeList<Page> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"about", "access_token", "ad_campaign", "affiliation", "app_id", "app_links", "artists_we_like", "attire", "awards", "band_interests", "band_members", "best_page", "bio", "birthday", "booking_agent", "built", "business", "can_checkin", "can_post", "category", "category_list", "checkins", "company_overview", "connected_instagram_account", "contact_address", "context", "copyright_attribution_insights", "copyright_whitelisted_ig_partners", "country_page_likes", "cover", "culinary_team", "current_location", "description", "description_html", "directed_by", "display_subtext", "displayed_message_response_time", "emails", "engagement", "fan_count", "featured_video", "features", "food_styles", "founded", "general_info", "general_manager", "genre", "global_brand_page_name", "global_brand_parent_page", "global_brand_root_id", "has_added_app", "has_whatsapp_business_number", "has_whatsapp_number", "hometown", "hours", "id", "impressum", "influences", "instagram_business_account", "instant_articles_review_status", "is_always_open", "is_chain", "is_community_page", "is_eligible_for_branded_content", "is_messenger_bot_get_started_enabled", "is_messenger_platform_bot", "is_owned", "is_permanently_closed", "is_published", "is_unclaimed", "is_verified", "is_webhooks_subscribed", "keywords", "leadgen_form_preview_details", "leadgen_has_crm_integration", "leadgen_has_fat_ping_crm_integration", "leadgen_tos_acceptance_time", "leadgen_tos_accepted", "leadgen_tos_accepting_user", "link", "location", "members", "merchant_id", "merchant_review_status", "messenger_ads_default_icebreakers", "messenger_ads_default_page_welcome_message", "messenger_ads_default_quick_replies", "messenger_ads_quick_replies_type", "mission", "mpg", "name", "name_with_location_descriptor", "network", "new_like_count", "offer_eligible", "overall_star_rating", "page_token", "parent_page", "parking", "payment_options", "personal_info", "personal_interests", "pharma_safety_info", "phone", "place_type", "plot_outline", "preferred_audience", "press_contact", "price_range", "privacy_info_url", "produced_by", "products", "promotion_eligible", "promotion_ineligible_reason", "public_transit", "publisher_space", "rating_count", "recipient", "record_label", "release_date", "restaurant_services", "restaurant_specialties", "schedule", "screenplay_by", "season", "single_line_address", "starring", "start_info", "store_code", "store_location_descriptor", "store_number", "studio", "supports_instant_articles", "talking_about_count", "unread_message_count", "unread_notif_count", "unseen_message_count", "username", "verification_status", "voip_info", "website", "were_here_count", "whatsapp_number", "written_by"};

        @Override
        public APINodeList<Page> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Page> parseResponse(String response) throws APIException {
            return Page.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Page> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Page>>(){

                public APINodeList<Page> apply(String result) {
                    try {
                        return APIRequestGetPromotePages.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPromotePages(String nodeId, APIContext context) {
            super(context, nodeId, "/promote_pages", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPromotePages setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPromotePages setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPromotePages requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPromotePages requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPromotePages requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPromotePages requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPromotePages requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPromotePages requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPromotePages requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetPromotePages requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetPromotePages requestAccessTokenField() {
            return this.requestAccessTokenField(true);
        }

        public APIRequestGetPromotePages requestAccessTokenField(boolean value) {
            this.requestField("access_token", value);
            return this;
        }

        public APIRequestGetPromotePages requestAdCampaignField() {
            return this.requestAdCampaignField(true);
        }

        public APIRequestGetPromotePages requestAdCampaignField(boolean value) {
            this.requestField("ad_campaign", value);
            return this;
        }

        public APIRequestGetPromotePages requestAffiliationField() {
            return this.requestAffiliationField(true);
        }

        public APIRequestGetPromotePages requestAffiliationField(boolean value) {
            this.requestField("affiliation", value);
            return this;
        }

        public APIRequestGetPromotePages requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGetPromotePages requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGetPromotePages requestAppLinksField() {
            return this.requestAppLinksField(true);
        }

        public APIRequestGetPromotePages requestAppLinksField(boolean value) {
            this.requestField("app_links", value);
            return this;
        }

        public APIRequestGetPromotePages requestArtistsWeLikeField() {
            return this.requestArtistsWeLikeField(true);
        }

        public APIRequestGetPromotePages requestArtistsWeLikeField(boolean value) {
            this.requestField("artists_we_like", value);
            return this;
        }

        public APIRequestGetPromotePages requestAttireField() {
            return this.requestAttireField(true);
        }

        public APIRequestGetPromotePages requestAttireField(boolean value) {
            this.requestField("attire", value);
            return this;
        }

        public APIRequestGetPromotePages requestAwardsField() {
            return this.requestAwardsField(true);
        }

        public APIRequestGetPromotePages requestAwardsField(boolean value) {
            this.requestField("awards", value);
            return this;
        }

        public APIRequestGetPromotePages requestBandInterestsField() {
            return this.requestBandInterestsField(true);
        }

        public APIRequestGetPromotePages requestBandInterestsField(boolean value) {
            this.requestField("band_interests", value);
            return this;
        }

        public APIRequestGetPromotePages requestBandMembersField() {
            return this.requestBandMembersField(true);
        }

        public APIRequestGetPromotePages requestBandMembersField(boolean value) {
            this.requestField("band_members", value);
            return this;
        }

        public APIRequestGetPromotePages requestBestPageField() {
            return this.requestBestPageField(true);
        }

        public APIRequestGetPromotePages requestBestPageField(boolean value) {
            this.requestField("best_page", value);
            return this;
        }

        public APIRequestGetPromotePages requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGetPromotePages requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGetPromotePages requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetPromotePages requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetPromotePages requestBookingAgentField() {
            return this.requestBookingAgentField(true);
        }

        public APIRequestGetPromotePages requestBookingAgentField(boolean value) {
            this.requestField("booking_agent", value);
            return this;
        }

        public APIRequestGetPromotePages requestBuiltField() {
            return this.requestBuiltField(true);
        }

        public APIRequestGetPromotePages requestBuiltField(boolean value) {
            this.requestField("built", value);
            return this;
        }

        public APIRequestGetPromotePages requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetPromotePages requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetPromotePages requestCanCheckinField() {
            return this.requestCanCheckinField(true);
        }

        public APIRequestGetPromotePages requestCanCheckinField(boolean value) {
            this.requestField("can_checkin", value);
            return this;
        }

        public APIRequestGetPromotePages requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetPromotePages requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetPromotePages requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetPromotePages requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetPromotePages requestCategoryListField() {
            return this.requestCategoryListField(true);
        }

        public APIRequestGetPromotePages requestCategoryListField(boolean value) {
            this.requestField("category_list", value);
            return this;
        }

        public APIRequestGetPromotePages requestCheckinsField() {
            return this.requestCheckinsField(true);
        }

        public APIRequestGetPromotePages requestCheckinsField(boolean value) {
            this.requestField("checkins", value);
            return this;
        }

        public APIRequestGetPromotePages requestCompanyOverviewField() {
            return this.requestCompanyOverviewField(true);
        }

        public APIRequestGetPromotePages requestCompanyOverviewField(boolean value) {
            this.requestField("company_overview", value);
            return this;
        }

        public APIRequestGetPromotePages requestConnectedInstagramAccountField() {
            return this.requestConnectedInstagramAccountField(true);
        }

        public APIRequestGetPromotePages requestConnectedInstagramAccountField(boolean value) {
            this.requestField("connected_instagram_account", value);
            return this;
        }

        public APIRequestGetPromotePages requestContactAddressField() {
            return this.requestContactAddressField(true);
        }

        public APIRequestGetPromotePages requestContactAddressField(boolean value) {
            this.requestField("contact_address", value);
            return this;
        }

        public APIRequestGetPromotePages requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetPromotePages requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetPromotePages requestCopyrightAttributionInsightsField() {
            return this.requestCopyrightAttributionInsightsField(true);
        }

        public APIRequestGetPromotePages requestCopyrightAttributionInsightsField(boolean value) {
            this.requestField("copyright_attribution_insights", value);
            return this;
        }

        public APIRequestGetPromotePages requestCopyrightWhitelistedIgPartnersField() {
            return this.requestCopyrightWhitelistedIgPartnersField(true);
        }

        public APIRequestGetPromotePages requestCopyrightWhitelistedIgPartnersField(boolean value) {
            this.requestField("copyright_whitelisted_ig_partners", value);
            return this;
        }

        public APIRequestGetPromotePages requestCountryPageLikesField() {
            return this.requestCountryPageLikesField(true);
        }

        public APIRequestGetPromotePages requestCountryPageLikesField(boolean value) {
            this.requestField("country_page_likes", value);
            return this;
        }

        public APIRequestGetPromotePages requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetPromotePages requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetPromotePages requestCulinaryTeamField() {
            return this.requestCulinaryTeamField(true);
        }

        public APIRequestGetPromotePages requestCulinaryTeamField(boolean value) {
            this.requestField("culinary_team", value);
            return this;
        }

        public APIRequestGetPromotePages requestCurrentLocationField() {
            return this.requestCurrentLocationField(true);
        }

        public APIRequestGetPromotePages requestCurrentLocationField(boolean value) {
            this.requestField("current_location", value);
            return this;
        }

        public APIRequestGetPromotePages requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetPromotePages requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetPromotePages requestDescriptionHtmlField() {
            return this.requestDescriptionHtmlField(true);
        }

        public APIRequestGetPromotePages requestDescriptionHtmlField(boolean value) {
            this.requestField("description_html", value);
            return this;
        }

        public APIRequestGetPromotePages requestDirectedByField() {
            return this.requestDirectedByField(true);
        }

        public APIRequestGetPromotePages requestDirectedByField(boolean value) {
            this.requestField("directed_by", value);
            return this;
        }

        public APIRequestGetPromotePages requestDisplaySubtextField() {
            return this.requestDisplaySubtextField(true);
        }

        public APIRequestGetPromotePages requestDisplaySubtextField(boolean value) {
            this.requestField("display_subtext", value);
            return this;
        }

        public APIRequestGetPromotePages requestDisplayedMessageResponseTimeField() {
            return this.requestDisplayedMessageResponseTimeField(true);
        }

        public APIRequestGetPromotePages requestDisplayedMessageResponseTimeField(boolean value) {
            this.requestField("displayed_message_response_time", value);
            return this;
        }

        public APIRequestGetPromotePages requestEmailsField() {
            return this.requestEmailsField(true);
        }

        public APIRequestGetPromotePages requestEmailsField(boolean value) {
            this.requestField("emails", value);
            return this;
        }

        public APIRequestGetPromotePages requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGetPromotePages requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGetPromotePages requestFanCountField() {
            return this.requestFanCountField(true);
        }

        public APIRequestGetPromotePages requestFanCountField(boolean value) {
            this.requestField("fan_count", value);
            return this;
        }

        public APIRequestGetPromotePages requestFeaturedVideoField() {
            return this.requestFeaturedVideoField(true);
        }

        public APIRequestGetPromotePages requestFeaturedVideoField(boolean value) {
            this.requestField("featured_video", value);
            return this;
        }

        public APIRequestGetPromotePages requestFeaturesField() {
            return this.requestFeaturesField(true);
        }

        public APIRequestGetPromotePages requestFeaturesField(boolean value) {
            this.requestField("features", value);
            return this;
        }

        public APIRequestGetPromotePages requestFoodStylesField() {
            return this.requestFoodStylesField(true);
        }

        public APIRequestGetPromotePages requestFoodStylesField(boolean value) {
            this.requestField("food_styles", value);
            return this;
        }

        public APIRequestGetPromotePages requestFoundedField() {
            return this.requestFoundedField(true);
        }

        public APIRequestGetPromotePages requestFoundedField(boolean value) {
            this.requestField("founded", value);
            return this;
        }

        public APIRequestGetPromotePages requestGeneralInfoField() {
            return this.requestGeneralInfoField(true);
        }

        public APIRequestGetPromotePages requestGeneralInfoField(boolean value) {
            this.requestField("general_info", value);
            return this;
        }

        public APIRequestGetPromotePages requestGeneralManagerField() {
            return this.requestGeneralManagerField(true);
        }

        public APIRequestGetPromotePages requestGeneralManagerField(boolean value) {
            this.requestField("general_manager", value);
            return this;
        }

        public APIRequestGetPromotePages requestGenreField() {
            return this.requestGenreField(true);
        }

        public APIRequestGetPromotePages requestGenreField(boolean value) {
            this.requestField("genre", value);
            return this;
        }

        public APIRequestGetPromotePages requestGlobalBrandPageNameField() {
            return this.requestGlobalBrandPageNameField(true);
        }

        public APIRequestGetPromotePages requestGlobalBrandPageNameField(boolean value) {
            this.requestField("global_brand_page_name", value);
            return this;
        }

        public APIRequestGetPromotePages requestGlobalBrandParentPageField() {
            return this.requestGlobalBrandParentPageField(true);
        }

        public APIRequestGetPromotePages requestGlobalBrandParentPageField(boolean value) {
            this.requestField("global_brand_parent_page", value);
            return this;
        }

        public APIRequestGetPromotePages requestGlobalBrandRootIdField() {
            return this.requestGlobalBrandRootIdField(true);
        }

        public APIRequestGetPromotePages requestGlobalBrandRootIdField(boolean value) {
            this.requestField("global_brand_root_id", value);
            return this;
        }

        public APIRequestGetPromotePages requestHasAddedAppField() {
            return this.requestHasAddedAppField(true);
        }

        public APIRequestGetPromotePages requestHasAddedAppField(boolean value) {
            this.requestField("has_added_app", value);
            return this;
        }

        public APIRequestGetPromotePages requestHasWhatsappBusinessNumberField() {
            return this.requestHasWhatsappBusinessNumberField(true);
        }

        public APIRequestGetPromotePages requestHasWhatsappBusinessNumberField(boolean value) {
            this.requestField("has_whatsapp_business_number", value);
            return this;
        }

        public APIRequestGetPromotePages requestHasWhatsappNumberField() {
            return this.requestHasWhatsappNumberField(true);
        }

        public APIRequestGetPromotePages requestHasWhatsappNumberField(boolean value) {
            this.requestField("has_whatsapp_number", value);
            return this;
        }

        public APIRequestGetPromotePages requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetPromotePages requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetPromotePages requestHoursField() {
            return this.requestHoursField(true);
        }

        public APIRequestGetPromotePages requestHoursField(boolean value) {
            this.requestField("hours", value);
            return this;
        }

        public APIRequestGetPromotePages requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPromotePages requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetPromotePages requestImpressumField() {
            return this.requestImpressumField(true);
        }

        public APIRequestGetPromotePages requestImpressumField(boolean value) {
            this.requestField("impressum", value);
            return this;
        }

        public APIRequestGetPromotePages requestInfluencesField() {
            return this.requestInfluencesField(true);
        }

        public APIRequestGetPromotePages requestInfluencesField(boolean value) {
            this.requestField("influences", value);
            return this;
        }

        public APIRequestGetPromotePages requestInstagramBusinessAccountField() {
            return this.requestInstagramBusinessAccountField(true);
        }

        public APIRequestGetPromotePages requestInstagramBusinessAccountField(boolean value) {
            this.requestField("instagram_business_account", value);
            return this;
        }

        public APIRequestGetPromotePages requestInstantArticlesReviewStatusField() {
            return this.requestInstantArticlesReviewStatusField(true);
        }

        public APIRequestGetPromotePages requestInstantArticlesReviewStatusField(boolean value) {
            this.requestField("instant_articles_review_status", value);
            return this;
        }

        public APIRequestGetPromotePages requestIsAlwaysOpenField() {
            return this.requestIsAlwaysOpenField(true);
        }

        public APIRequestGetPromotePages requestIsAlwaysOpenField(boolean value) {
            this.requestField("is_always_open", value);
            return this;
        }

        public APIRequestGetPromotePages requestIsChainField() {
            return this.requestIsChainField(true);
        }

        public APIRequestGetPromotePages requestIsChainField(boolean value) {
            this.requestField("is_chain", value);
            return this;
        }

        public APIRequestGetPromotePages requestIsCommunityPageField() {
            return this.requestIsCommunityPageField(true);
        }

        public APIRequestGetPromotePages requestIsCommunityPageField(boolean value) {
            this.requestField("is_community_page", value);
            return this;
        }

        public APIRequestGetPromotePages requestIsEligibleForBrandedContentField() {
            return this.requestIsEligibleForBrandedContentField(true);
        }

        public APIRequestGetPromotePages requestIsEligibleForBrandedContentField(boolean value) {
            this.requestField("is_eligible_for_branded_content", value);
            return this;
        }

        public APIRequestGetPromotePages requestIsMessengerBotGetStartedEnabledField() {
            return this.requestIsMessengerBotGetStartedEnabledField(true);
        }

        public APIRequestGetPromotePages requestIsMessengerBotGetStartedEnabledField(boolean value) {
            this.requestField("is_messenger_bot_get_started_enabled", value);
            return this;
        }

        public APIRequestGetPromotePages requestIsMessengerPlatformBotField() {
            return this.requestIsMessengerPlatformBotField(true);
        }

        public APIRequestGetPromotePages requestIsMessengerPlatformBotField(boolean value) {
            this.requestField("is_messenger_platform_bot", value);
            return this;
        }

        public APIRequestGetPromotePages requestIsOwnedField() {
            return this.requestIsOwnedField(true);
        }

        public APIRequestGetPromotePages requestIsOwnedField(boolean value) {
            this.requestField("is_owned", value);
            return this;
        }

        public APIRequestGetPromotePages requestIsPermanentlyClosedField() {
            return this.requestIsPermanentlyClosedField(true);
        }

        public APIRequestGetPromotePages requestIsPermanentlyClosedField(boolean value) {
            this.requestField("is_permanently_closed", value);
            return this;
        }

        public APIRequestGetPromotePages requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetPromotePages requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetPromotePages requestIsUnclaimedField() {
            return this.requestIsUnclaimedField(true);
        }

        public APIRequestGetPromotePages requestIsUnclaimedField(boolean value) {
            this.requestField("is_unclaimed", value);
            return this;
        }

        public APIRequestGetPromotePages requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGetPromotePages requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGetPromotePages requestIsWebhooksSubscribedField() {
            return this.requestIsWebhooksSubscribedField(true);
        }

        public APIRequestGetPromotePages requestIsWebhooksSubscribedField(boolean value) {
            this.requestField("is_webhooks_subscribed", value);
            return this;
        }

        public APIRequestGetPromotePages requestKeywordsField() {
            return this.requestKeywordsField(true);
        }

        public APIRequestGetPromotePages requestKeywordsField(boolean value) {
            this.requestField("keywords", value);
            return this;
        }

        public APIRequestGetPromotePages requestLeadgenFormPreviewDetailsField() {
            return this.requestLeadgenFormPreviewDetailsField(true);
        }

        public APIRequestGetPromotePages requestLeadgenFormPreviewDetailsField(boolean value) {
            this.requestField("leadgen_form_preview_details", value);
            return this;
        }

        public APIRequestGetPromotePages requestLeadgenHasCrmIntegrationField() {
            return this.requestLeadgenHasCrmIntegrationField(true);
        }

        public APIRequestGetPromotePages requestLeadgenHasCrmIntegrationField(boolean value) {
            this.requestField("leadgen_has_crm_integration", value);
            return this;
        }

        public APIRequestGetPromotePages requestLeadgenHasFatPingCrmIntegrationField() {
            return this.requestLeadgenHasFatPingCrmIntegrationField(true);
        }

        public APIRequestGetPromotePages requestLeadgenHasFatPingCrmIntegrationField(boolean value) {
            this.requestField("leadgen_has_fat_ping_crm_integration", value);
            return this;
        }

        public APIRequestGetPromotePages requestLeadgenTosAcceptanceTimeField() {
            return this.requestLeadgenTosAcceptanceTimeField(true);
        }

        public APIRequestGetPromotePages requestLeadgenTosAcceptanceTimeField(boolean value) {
            this.requestField("leadgen_tos_acceptance_time", value);
            return this;
        }

        public APIRequestGetPromotePages requestLeadgenTosAcceptedField() {
            return this.requestLeadgenTosAcceptedField(true);
        }

        public APIRequestGetPromotePages requestLeadgenTosAcceptedField(boolean value) {
            this.requestField("leadgen_tos_accepted", value);
            return this;
        }

        public APIRequestGetPromotePages requestLeadgenTosAcceptingUserField() {
            return this.requestLeadgenTosAcceptingUserField(true);
        }

        public APIRequestGetPromotePages requestLeadgenTosAcceptingUserField(boolean value) {
            this.requestField("leadgen_tos_accepting_user", value);
            return this;
        }

        public APIRequestGetPromotePages requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetPromotePages requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetPromotePages requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetPromotePages requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetPromotePages requestMembersField() {
            return this.requestMembersField(true);
        }

        public APIRequestGetPromotePages requestMembersField(boolean value) {
            this.requestField("members", value);
            return this;
        }

        public APIRequestGetPromotePages requestMerchantIdField() {
            return this.requestMerchantIdField(true);
        }

        public APIRequestGetPromotePages requestMerchantIdField(boolean value) {
            this.requestField("merchant_id", value);
            return this;
        }

        public APIRequestGetPromotePages requestMerchantReviewStatusField() {
            return this.requestMerchantReviewStatusField(true);
        }

        public APIRequestGetPromotePages requestMerchantReviewStatusField(boolean value) {
            this.requestField("merchant_review_status", value);
            return this;
        }

        public APIRequestGetPromotePages requestMessengerAdsDefaultIcebreakersField() {
            return this.requestMessengerAdsDefaultIcebreakersField(true);
        }

        public APIRequestGetPromotePages requestMessengerAdsDefaultIcebreakersField(boolean value) {
            this.requestField("messenger_ads_default_icebreakers", value);
            return this;
        }

        public APIRequestGetPromotePages requestMessengerAdsDefaultPageWelcomeMessageField() {
            return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
        }

        public APIRequestGetPromotePages requestMessengerAdsDefaultPageWelcomeMessageField(boolean value) {
            this.requestField("messenger_ads_default_page_welcome_message", value);
            return this;
        }

        public APIRequestGetPromotePages requestMessengerAdsDefaultQuickRepliesField() {
            return this.requestMessengerAdsDefaultQuickRepliesField(true);
        }

        public APIRequestGetPromotePages requestMessengerAdsDefaultQuickRepliesField(boolean value) {
            this.requestField("messenger_ads_default_quick_replies", value);
            return this;
        }

        public APIRequestGetPromotePages requestMessengerAdsQuickRepliesTypeField() {
            return this.requestMessengerAdsQuickRepliesTypeField(true);
        }

        public APIRequestGetPromotePages requestMessengerAdsQuickRepliesTypeField(boolean value) {
            this.requestField("messenger_ads_quick_replies_type", value);
            return this;
        }

        public APIRequestGetPromotePages requestMissionField() {
            return this.requestMissionField(true);
        }

        public APIRequestGetPromotePages requestMissionField(boolean value) {
            this.requestField("mission", value);
            return this;
        }

        public APIRequestGetPromotePages requestMpgField() {
            return this.requestMpgField(true);
        }

        public APIRequestGetPromotePages requestMpgField(boolean value) {
            this.requestField("mpg", value);
            return this;
        }

        public APIRequestGetPromotePages requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetPromotePages requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetPromotePages requestNameWithLocationDescriptorField() {
            return this.requestNameWithLocationDescriptorField(true);
        }

        public APIRequestGetPromotePages requestNameWithLocationDescriptorField(boolean value) {
            this.requestField("name_with_location_descriptor", value);
            return this;
        }

        public APIRequestGetPromotePages requestNetworkField() {
            return this.requestNetworkField(true);
        }

        public APIRequestGetPromotePages requestNetworkField(boolean value) {
            this.requestField("network", value);
            return this;
        }

        public APIRequestGetPromotePages requestNewLikeCountField() {
            return this.requestNewLikeCountField(true);
        }

        public APIRequestGetPromotePages requestNewLikeCountField(boolean value) {
            this.requestField("new_like_count", value);
            return this;
        }

        public APIRequestGetPromotePages requestOfferEligibleField() {
            return this.requestOfferEligibleField(true);
        }

        public APIRequestGetPromotePages requestOfferEligibleField(boolean value) {
            this.requestField("offer_eligible", value);
            return this;
        }

        public APIRequestGetPromotePages requestOverallStarRatingField() {
            return this.requestOverallStarRatingField(true);
        }

        public APIRequestGetPromotePages requestOverallStarRatingField(boolean value) {
            this.requestField("overall_star_rating", value);
            return this;
        }

        public APIRequestGetPromotePages requestPageTokenField() {
            return this.requestPageTokenField(true);
        }

        public APIRequestGetPromotePages requestPageTokenField(boolean value) {
            this.requestField("page_token", value);
            return this;
        }

        public APIRequestGetPromotePages requestParentPageField() {
            return this.requestParentPageField(true);
        }

        public APIRequestGetPromotePages requestParentPageField(boolean value) {
            this.requestField("parent_page", value);
            return this;
        }

        public APIRequestGetPromotePages requestParkingField() {
            return this.requestParkingField(true);
        }

        public APIRequestGetPromotePages requestParkingField(boolean value) {
            this.requestField("parking", value);
            return this;
        }

        public APIRequestGetPromotePages requestPaymentOptionsField() {
            return this.requestPaymentOptionsField(true);
        }

        public APIRequestGetPromotePages requestPaymentOptionsField(boolean value) {
            this.requestField("payment_options", value);
            return this;
        }

        public APIRequestGetPromotePages requestPersonalInfoField() {
            return this.requestPersonalInfoField(true);
        }

        public APIRequestGetPromotePages requestPersonalInfoField(boolean value) {
            this.requestField("personal_info", value);
            return this;
        }

        public APIRequestGetPromotePages requestPersonalInterestsField() {
            return this.requestPersonalInterestsField(true);
        }

        public APIRequestGetPromotePages requestPersonalInterestsField(boolean value) {
            this.requestField("personal_interests", value);
            return this;
        }

        public APIRequestGetPromotePages requestPharmaSafetyInfoField() {
            return this.requestPharmaSafetyInfoField(true);
        }

        public APIRequestGetPromotePages requestPharmaSafetyInfoField(boolean value) {
            this.requestField("pharma_safety_info", value);
            return this;
        }

        public APIRequestGetPromotePages requestPhoneField() {
            return this.requestPhoneField(true);
        }

        public APIRequestGetPromotePages requestPhoneField(boolean value) {
            this.requestField("phone", value);
            return this;
        }

        public APIRequestGetPromotePages requestPlaceTypeField() {
            return this.requestPlaceTypeField(true);
        }

        public APIRequestGetPromotePages requestPlaceTypeField(boolean value) {
            this.requestField("place_type", value);
            return this;
        }

        public APIRequestGetPromotePages requestPlotOutlineField() {
            return this.requestPlotOutlineField(true);
        }

        public APIRequestGetPromotePages requestPlotOutlineField(boolean value) {
            this.requestField("plot_outline", value);
            return this;
        }

        public APIRequestGetPromotePages requestPreferredAudienceField() {
            return this.requestPreferredAudienceField(true);
        }

        public APIRequestGetPromotePages requestPreferredAudienceField(boolean value) {
            this.requestField("preferred_audience", value);
            return this;
        }

        public APIRequestGetPromotePages requestPressContactField() {
            return this.requestPressContactField(true);
        }

        public APIRequestGetPromotePages requestPressContactField(boolean value) {
            this.requestField("press_contact", value);
            return this;
        }

        public APIRequestGetPromotePages requestPriceRangeField() {
            return this.requestPriceRangeField(true);
        }

        public APIRequestGetPromotePages requestPriceRangeField(boolean value) {
            this.requestField("price_range", value);
            return this;
        }

        public APIRequestGetPromotePages requestPrivacyInfoUrlField() {
            return this.requestPrivacyInfoUrlField(true);
        }

        public APIRequestGetPromotePages requestPrivacyInfoUrlField(boolean value) {
            this.requestField("privacy_info_url", value);
            return this;
        }

        public APIRequestGetPromotePages requestProducedByField() {
            return this.requestProducedByField(true);
        }

        public APIRequestGetPromotePages requestProducedByField(boolean value) {
            this.requestField("produced_by", value);
            return this;
        }

        public APIRequestGetPromotePages requestProductsField() {
            return this.requestProductsField(true);
        }

        public APIRequestGetPromotePages requestProductsField(boolean value) {
            this.requestField("products", value);
            return this;
        }

        public APIRequestGetPromotePages requestPromotionEligibleField() {
            return this.requestPromotionEligibleField(true);
        }

        public APIRequestGetPromotePages requestPromotionEligibleField(boolean value) {
            this.requestField("promotion_eligible", value);
            return this;
        }

        public APIRequestGetPromotePages requestPromotionIneligibleReasonField() {
            return this.requestPromotionIneligibleReasonField(true);
        }

        public APIRequestGetPromotePages requestPromotionIneligibleReasonField(boolean value) {
            this.requestField("promotion_ineligible_reason", value);
            return this;
        }

        public APIRequestGetPromotePages requestPublicTransitField() {
            return this.requestPublicTransitField(true);
        }

        public APIRequestGetPromotePages requestPublicTransitField(boolean value) {
            this.requestField("public_transit", value);
            return this;
        }

        public APIRequestGetPromotePages requestPublisherSpaceField() {
            return this.requestPublisherSpaceField(true);
        }

        public APIRequestGetPromotePages requestPublisherSpaceField(boolean value) {
            this.requestField("publisher_space", value);
            return this;
        }

        public APIRequestGetPromotePages requestRatingCountField() {
            return this.requestRatingCountField(true);
        }

        public APIRequestGetPromotePages requestRatingCountField(boolean value) {
            this.requestField("rating_count", value);
            return this;
        }

        public APIRequestGetPromotePages requestRecipientField() {
            return this.requestRecipientField(true);
        }

        public APIRequestGetPromotePages requestRecipientField(boolean value) {
            this.requestField("recipient", value);
            return this;
        }

        public APIRequestGetPromotePages requestRecordLabelField() {
            return this.requestRecordLabelField(true);
        }

        public APIRequestGetPromotePages requestRecordLabelField(boolean value) {
            this.requestField("record_label", value);
            return this;
        }

        public APIRequestGetPromotePages requestReleaseDateField() {
            return this.requestReleaseDateField(true);
        }

        public APIRequestGetPromotePages requestReleaseDateField(boolean value) {
            this.requestField("release_date", value);
            return this;
        }

        public APIRequestGetPromotePages requestRestaurantServicesField() {
            return this.requestRestaurantServicesField(true);
        }

        public APIRequestGetPromotePages requestRestaurantServicesField(boolean value) {
            this.requestField("restaurant_services", value);
            return this;
        }

        public APIRequestGetPromotePages requestRestaurantSpecialtiesField() {
            return this.requestRestaurantSpecialtiesField(true);
        }

        public APIRequestGetPromotePages requestRestaurantSpecialtiesField(boolean value) {
            this.requestField("restaurant_specialties", value);
            return this;
        }

        public APIRequestGetPromotePages requestScheduleField() {
            return this.requestScheduleField(true);
        }

        public APIRequestGetPromotePages requestScheduleField(boolean value) {
            this.requestField("schedule", value);
            return this;
        }

        public APIRequestGetPromotePages requestScreenplayByField() {
            return this.requestScreenplayByField(true);
        }

        public APIRequestGetPromotePages requestScreenplayByField(boolean value) {
            this.requestField("screenplay_by", value);
            return this;
        }

        public APIRequestGetPromotePages requestSeasonField() {
            return this.requestSeasonField(true);
        }

        public APIRequestGetPromotePages requestSeasonField(boolean value) {
            this.requestField("season", value);
            return this;
        }

        public APIRequestGetPromotePages requestSingleLineAddressField() {
            return this.requestSingleLineAddressField(true);
        }

        public APIRequestGetPromotePages requestSingleLineAddressField(boolean value) {
            this.requestField("single_line_address", value);
            return this;
        }

        public APIRequestGetPromotePages requestStarringField() {
            return this.requestStarringField(true);
        }

        public APIRequestGetPromotePages requestStarringField(boolean value) {
            this.requestField("starring", value);
            return this;
        }

        public APIRequestGetPromotePages requestStartInfoField() {
            return this.requestStartInfoField(true);
        }

        public APIRequestGetPromotePages requestStartInfoField(boolean value) {
            this.requestField("start_info", value);
            return this;
        }

        public APIRequestGetPromotePages requestStoreCodeField() {
            return this.requestStoreCodeField(true);
        }

        public APIRequestGetPromotePages requestStoreCodeField(boolean value) {
            this.requestField("store_code", value);
            return this;
        }

        public APIRequestGetPromotePages requestStoreLocationDescriptorField() {
            return this.requestStoreLocationDescriptorField(true);
        }

        public APIRequestGetPromotePages requestStoreLocationDescriptorField(boolean value) {
            this.requestField("store_location_descriptor", value);
            return this;
        }

        public APIRequestGetPromotePages requestStoreNumberField() {
            return this.requestStoreNumberField(true);
        }

        public APIRequestGetPromotePages requestStoreNumberField(boolean value) {
            this.requestField("store_number", value);
            return this;
        }

        public APIRequestGetPromotePages requestStudioField() {
            return this.requestStudioField(true);
        }

        public APIRequestGetPromotePages requestStudioField(boolean value) {
            this.requestField("studio", value);
            return this;
        }

        public APIRequestGetPromotePages requestSupportsInstantArticlesField() {
            return this.requestSupportsInstantArticlesField(true);
        }

        public APIRequestGetPromotePages requestSupportsInstantArticlesField(boolean value) {
            this.requestField("supports_instant_articles", value);
            return this;
        }

        public APIRequestGetPromotePages requestTalkingAboutCountField() {
            return this.requestTalkingAboutCountField(true);
        }

        public APIRequestGetPromotePages requestTalkingAboutCountField(boolean value) {
            this.requestField("talking_about_count", value);
            return this;
        }

        public APIRequestGetPromotePages requestUnreadMessageCountField() {
            return this.requestUnreadMessageCountField(true);
        }

        public APIRequestGetPromotePages requestUnreadMessageCountField(boolean value) {
            this.requestField("unread_message_count", value);
            return this;
        }

        public APIRequestGetPromotePages requestUnreadNotifCountField() {
            return this.requestUnreadNotifCountField(true);
        }

        public APIRequestGetPromotePages requestUnreadNotifCountField(boolean value) {
            this.requestField("unread_notif_count", value);
            return this;
        }

        public APIRequestGetPromotePages requestUnseenMessageCountField() {
            return this.requestUnseenMessageCountField(true);
        }

        public APIRequestGetPromotePages requestUnseenMessageCountField(boolean value) {
            this.requestField("unseen_message_count", value);
            return this;
        }

        public APIRequestGetPromotePages requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetPromotePages requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGetPromotePages requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetPromotePages requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetPromotePages requestVoipInfoField() {
            return this.requestVoipInfoField(true);
        }

        public APIRequestGetPromotePages requestVoipInfoField(boolean value) {
            this.requestField("voip_info", value);
            return this;
        }

        public APIRequestGetPromotePages requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetPromotePages requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGetPromotePages requestWereHereCountField() {
            return this.requestWereHereCountField(true);
        }

        public APIRequestGetPromotePages requestWereHereCountField(boolean value) {
            this.requestField("were_here_count", value);
            return this;
        }

        public APIRequestGetPromotePages requestWhatsappNumberField() {
            return this.requestWhatsappNumberField(true);
        }

        public APIRequestGetPromotePages requestWhatsappNumberField(boolean value) {
            this.requestField("whatsapp_number", value);
            return this;
        }

        public APIRequestGetPromotePages requestWrittenByField() {
            return this.requestWrittenByField(true);
        }

        public APIRequestGetPromotePages requestWrittenByField(boolean value) {
            this.requestField("written_by", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateProductAudience
    extends APIRequest<CustomAudience> {
        CustomAudience lastResponse = null;
        public static final String[] PARAMS = new String[]{"creation_params", "description", "name", "opt_out_link", "parent_audience_id", "subtype", "seed_audience", "tags", "associated_audience_id", "is_household", "is_household_exclusion", "is_value_based", "allowed_domains", "is_snapshot", "claim_objective", "content_type", "event_source_group", "product_set_id", "rev_share_policy_id", "event_sources", "inclusions", "exclusions"};
        public static final String[] FIELDS = new String[0];

        @Override
        public CustomAudience getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CustomAudience parseResponse(String response) throws APIException {
            return CustomAudience.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public CustomAudience execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CustomAudience execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<CustomAudience> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CustomAudience> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CustomAudience>(){

                public CustomAudience apply(String result) {
                    try {
                        return APIRequestCreateProductAudience.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateProductAudience(String nodeId, APIContext context) {
            super(context, nodeId, "/product_audiences", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateProductAudience setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateProductAudience setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateProductAudience setCreationParams(Map<String, String> creationParams) {
            this.setParam("creation_params", creationParams);
            return this;
        }

        public APIRequestCreateProductAudience setCreationParams(String creationParams) {
            this.setParam("creation_params", creationParams);
            return this;
        }

        public APIRequestCreateProductAudience setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateProductAudience setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateProductAudience setOptOutLink(String optOutLink) {
            this.setParam("opt_out_link", optOutLink);
            return this;
        }

        public APIRequestCreateProductAudience setParentAudienceId(Long parentAudienceId) {
            this.setParam("parent_audience_id", parentAudienceId);
            return this;
        }

        public APIRequestCreateProductAudience setParentAudienceId(String parentAudienceId) {
            this.setParam("parent_audience_id", parentAudienceId);
            return this;
        }

        public APIRequestCreateProductAudience setSubtype(EnumSubtype subtype) {
            this.setParam("subtype", (Object)subtype);
            return this;
        }

        public APIRequestCreateProductAudience setSubtype(String subtype) {
            this.setParam("subtype", subtype);
            return this;
        }

        public APIRequestCreateProductAudience setSeedAudience(Long seedAudience) {
            this.setParam("seed_audience", seedAudience);
            return this;
        }

        public APIRequestCreateProductAudience setSeedAudience(String seedAudience) {
            this.setParam("seed_audience", seedAudience);
            return this;
        }

        public APIRequestCreateProductAudience setTags(List<String> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateProductAudience setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateProductAudience setAssociatedAudienceId(Long associatedAudienceId) {
            this.setParam("associated_audience_id", associatedAudienceId);
            return this;
        }

        public APIRequestCreateProductAudience setAssociatedAudienceId(String associatedAudienceId) {
            this.setParam("associated_audience_id", associatedAudienceId);
            return this;
        }

        public APIRequestCreateProductAudience setIsHousehold(Boolean isHousehold) {
            this.setParam("is_household", isHousehold);
            return this;
        }

        public APIRequestCreateProductAudience setIsHousehold(String isHousehold) {
            this.setParam("is_household", isHousehold);
            return this;
        }

        public APIRequestCreateProductAudience setIsHouseholdExclusion(Boolean isHouseholdExclusion) {
            this.setParam("is_household_exclusion", isHouseholdExclusion);
            return this;
        }

        public APIRequestCreateProductAudience setIsHouseholdExclusion(String isHouseholdExclusion) {
            this.setParam("is_household_exclusion", isHouseholdExclusion);
            return this;
        }

        public APIRequestCreateProductAudience setIsValueBased(Boolean isValueBased) {
            this.setParam("is_value_based", isValueBased);
            return this;
        }

        public APIRequestCreateProductAudience setIsValueBased(String isValueBased) {
            this.setParam("is_value_based", isValueBased);
            return this;
        }

        public APIRequestCreateProductAudience setAllowedDomains(List<String> allowedDomains) {
            this.setParam("allowed_domains", allowedDomains);
            return this;
        }

        public APIRequestCreateProductAudience setAllowedDomains(String allowedDomains) {
            this.setParam("allowed_domains", allowedDomains);
            return this;
        }

        public APIRequestCreateProductAudience setIsSnapshot(Boolean isSnapshot) {
            this.setParam("is_snapshot", isSnapshot);
            return this;
        }

        public APIRequestCreateProductAudience setIsSnapshot(String isSnapshot) {
            this.setParam("is_snapshot", isSnapshot);
            return this;
        }

        public APIRequestCreateProductAudience setClaimObjective(EnumClaimObjective claimObjective) {
            this.setParam("claim_objective", (Object)claimObjective);
            return this;
        }

        public APIRequestCreateProductAudience setClaimObjective(String claimObjective) {
            this.setParam("claim_objective", claimObjective);
            return this;
        }

        public APIRequestCreateProductAudience setContentType(EnumContentType contentType) {
            this.setParam("content_type", (Object)contentType);
            return this;
        }

        public APIRequestCreateProductAudience setContentType(String contentType) {
            this.setParam("content_type", contentType);
            return this;
        }

        public APIRequestCreateProductAudience setEventSourceGroup(String eventSourceGroup) {
            this.setParam("event_source_group", eventSourceGroup);
            return this;
        }

        public APIRequestCreateProductAudience setProductSetId(String productSetId) {
            this.setParam("product_set_id", productSetId);
            return this;
        }

        public APIRequestCreateProductAudience setRevSharePolicyId(Long revSharePolicyId) {
            this.setParam("rev_share_policy_id", revSharePolicyId);
            return this;
        }

        public APIRequestCreateProductAudience setRevSharePolicyId(String revSharePolicyId) {
            this.setParam("rev_share_policy_id", revSharePolicyId);
            return this;
        }

        public APIRequestCreateProductAudience setEventSources(List<Map<String, String>> eventSources) {
            this.setParam("event_sources", eventSources);
            return this;
        }

        public APIRequestCreateProductAudience setEventSources(String eventSources) {
            this.setParam("event_sources", eventSources);
            return this;
        }

        public APIRequestCreateProductAudience setInclusions(List<Object> inclusions) {
            this.setParam("inclusions", inclusions);
            return this;
        }

        public APIRequestCreateProductAudience setInclusions(String inclusions) {
            this.setParam("inclusions", inclusions);
            return this;
        }

        public APIRequestCreateProductAudience setExclusions(List<Object> exclusions) {
            this.setParam("exclusions", exclusions);
            return this;
        }

        public APIRequestCreateProductAudience setExclusions(String exclusions) {
            this.setParam("exclusions", exclusions);
            return this;
        }

        public APIRequestCreateProductAudience requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateProductAudience requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateProductAudience requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateProductAudience requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateProductAudience requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateProductAudience requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPartners
    extends APIRequest<AdsDataPartner> {
        APINodeList<AdsDataPartner> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "name", "rev_share_policies"};

        @Override
        public APINodeList<AdsDataPartner> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdsDataPartner> parseResponse(String response) throws APIException {
            return AdsDataPartner.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdsDataPartner> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdsDataPartner> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdsDataPartner>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdsDataPartner>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdsDataPartner>>(){

                public APINodeList<AdsDataPartner> apply(String result) {
                    try {
                        return APIRequestGetPartners.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPartners(String nodeId, APIContext context) {
            super(context, nodeId, "/partners", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPartners setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPartners setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPartners requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPartners requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPartners requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPartners requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPartners requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPartners requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPartners requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPartners requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetPartners requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetPartners requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetPartners requestRevSharePoliciesField() {
            return this.requestRevSharePoliciesField(true);
        }

        public APIRequestGetPartners requestRevSharePoliciesField(boolean value) {
            this.requestField("rev_share_policies", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreatePartnerRequest
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"category_ids", "account_ids", "type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreatePartnerRequest.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreatePartnerRequest(String nodeId, APIContext context) {
            super(context, nodeId, "/partnerrequests", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreatePartnerRequest setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreatePartnerRequest setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreatePartnerRequest setCategoryIds(List<String> categoryIds) {
            this.setParam("category_ids", categoryIds);
            return this;
        }

        public APIRequestCreatePartnerRequest setCategoryIds(String categoryIds) {
            this.setParam("category_ids", categoryIds);
            return this;
        }

        public APIRequestCreatePartnerRequest setAccountIds(List<Long> accountIds) {
            this.setParam("account_ids", accountIds);
            return this;
        }

        public APIRequestCreatePartnerRequest setAccountIds(String accountIds) {
            this.setParam("account_ids", accountIds);
            return this;
        }

        public APIRequestCreatePartnerRequest setType(EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestCreatePartnerRequest setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestCreatePartnerRequest requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreatePartnerRequest requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePartnerRequest requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreatePartnerRequest requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePartnerRequest requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreatePartnerRequest requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreatePartnerDatum
    extends APIRequest<AdAccount> {
        AdAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"upload_id", "type", "start_new_upload", "total_expected", "upload_metadata", "upload_complete", "ignore_count_check", "abandon_upload", "payload", "payload_type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccount parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccount execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccount>(){

                public AdAccount apply(String result) {
                    try {
                        return APIRequestCreatePartnerDatum.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreatePartnerDatum(String nodeId, APIContext context) {
            super(context, nodeId, "/partnerdata", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreatePartnerDatum setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreatePartnerDatum setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreatePartnerDatum setUploadId(Long uploadId) {
            this.setParam("upload_id", uploadId);
            return this;
        }

        public APIRequestCreatePartnerDatum setUploadId(String uploadId) {
            this.setParam("upload_id", uploadId);
            return this;
        }

        public APIRequestCreatePartnerDatum setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestCreatePartnerDatum setStartNewUpload(Boolean startNewUpload) {
            this.setParam("start_new_upload", startNewUpload);
            return this;
        }

        public APIRequestCreatePartnerDatum setStartNewUpload(String startNewUpload) {
            this.setParam("start_new_upload", startNewUpload);
            return this;
        }

        public APIRequestCreatePartnerDatum setTotalExpected(Long totalExpected) {
            this.setParam("total_expected", totalExpected);
            return this;
        }

        public APIRequestCreatePartnerDatum setTotalExpected(String totalExpected) {
            this.setParam("total_expected", totalExpected);
            return this;
        }

        public APIRequestCreatePartnerDatum setUploadMetadata(String uploadMetadata) {
            this.setParam("upload_metadata", uploadMetadata);
            return this;
        }

        public APIRequestCreatePartnerDatum setUploadComplete(Boolean uploadComplete) {
            this.setParam("upload_complete", uploadComplete);
            return this;
        }

        public APIRequestCreatePartnerDatum setUploadComplete(String uploadComplete) {
            this.setParam("upload_complete", uploadComplete);
            return this;
        }

        public APIRequestCreatePartnerDatum setIgnoreCountCheck(Boolean ignoreCountCheck) {
            this.setParam("ignore_count_check", ignoreCountCheck);
            return this;
        }

        public APIRequestCreatePartnerDatum setIgnoreCountCheck(String ignoreCountCheck) {
            this.setParam("ignore_count_check", ignoreCountCheck);
            return this;
        }

        public APIRequestCreatePartnerDatum setAbandonUpload(Boolean abandonUpload) {
            this.setParam("abandon_upload", abandonUpload);
            return this;
        }

        public APIRequestCreatePartnerDatum setAbandonUpload(String abandonUpload) {
            this.setParam("abandon_upload", abandonUpload);
            return this;
        }

        public APIRequestCreatePartnerDatum setPayload(List<String> payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestCreatePartnerDatum setPayload(String payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestCreatePartnerDatum setPayloadType(String payloadType) {
            this.setParam("payload_type", payloadType);
            return this;
        }

        public APIRequestCreatePartnerDatum requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreatePartnerDatum requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePartnerDatum requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreatePartnerDatum requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePartnerDatum requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreatePartnerDatum requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPartnerCategories
    extends APIRequest<PartnerCategory> {
        APINodeList<PartnerCategory> lastResponse = null;
        public static final String[] PARAMS = new String[]{"targeting_type", "private_or_public", "hide_pc", "limit", "is_exclusion"};
        public static final String[] FIELDS = new String[]{"approximate_count", "country", "description", "details", "id", "is_private", "name", "parent_category", "source", "status", "targeting_type"};

        @Override
        public APINodeList<PartnerCategory> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<PartnerCategory> parseResponse(String response) throws APIException {
            return PartnerCategory.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<PartnerCategory> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<PartnerCategory> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<PartnerCategory>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<PartnerCategory>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<PartnerCategory>>(){

                public APINodeList<PartnerCategory> apply(String result) {
                    try {
                        return APIRequestGetPartnerCategories.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPartnerCategories(String nodeId, APIContext context) {
            super(context, nodeId, "/partnercategories", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPartnerCategories setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPartnerCategories setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPartnerCategories setTargetingType(String targetingType) {
            this.setParam("targeting_type", targetingType);
            return this;
        }

        public APIRequestGetPartnerCategories setPrivateOrPublic(PartnerCategory.EnumPrivateOrPublic privateOrPublic) {
            this.setParam("private_or_public", (Object)privateOrPublic);
            return this;
        }

        public APIRequestGetPartnerCategories setPrivateOrPublic(String privateOrPublic) {
            this.setParam("private_or_public", privateOrPublic);
            return this;
        }

        public APIRequestGetPartnerCategories setHidePc(Boolean hidePc) {
            this.setParam("hide_pc", hidePc);
            return this;
        }

        public APIRequestGetPartnerCategories setHidePc(String hidePc) {
            this.setParam("hide_pc", hidePc);
            return this;
        }

        public APIRequestGetPartnerCategories setLimit(Long limit) {
            this.setParam("limit", limit);
            return this;
        }

        public APIRequestGetPartnerCategories setLimit(String limit) {
            this.setParam("limit", limit);
            return this;
        }

        public APIRequestGetPartnerCategories setIsExclusion(Boolean isExclusion) {
            this.setParam("is_exclusion", isExclusion);
            return this;
        }

        public APIRequestGetPartnerCategories setIsExclusion(String isExclusion) {
            this.setParam("is_exclusion", isExclusion);
            return this;
        }

        public APIRequestGetPartnerCategories requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPartnerCategories requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPartnerCategories requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPartnerCategories requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPartnerCategories requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPartnerCategories requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPartnerCategories requestApproximateCountField() {
            return this.requestApproximateCountField(true);
        }

        public APIRequestGetPartnerCategories requestApproximateCountField(boolean value) {
            this.requestField("approximate_count", value);
            return this;
        }

        public APIRequestGetPartnerCategories requestCountryField() {
            return this.requestCountryField(true);
        }

        public APIRequestGetPartnerCategories requestCountryField(boolean value) {
            this.requestField("country", value);
            return this;
        }

        public APIRequestGetPartnerCategories requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetPartnerCategories requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetPartnerCategories requestDetailsField() {
            return this.requestDetailsField(true);
        }

        public APIRequestGetPartnerCategories requestDetailsField(boolean value) {
            this.requestField("details", value);
            return this;
        }

        public APIRequestGetPartnerCategories requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPartnerCategories requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetPartnerCategories requestIsPrivateField() {
            return this.requestIsPrivateField(true);
        }

        public APIRequestGetPartnerCategories requestIsPrivateField(boolean value) {
            this.requestField("is_private", value);
            return this;
        }

        public APIRequestGetPartnerCategories requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetPartnerCategories requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetPartnerCategories requestParentCategoryField() {
            return this.requestParentCategoryField(true);
        }

        public APIRequestGetPartnerCategories requestParentCategoryField(boolean value) {
            this.requestField("parent_category", value);
            return this;
        }

        public APIRequestGetPartnerCategories requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGetPartnerCategories requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGetPartnerCategories requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetPartnerCategories requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetPartnerCategories requestTargetingTypeField() {
            return this.requestTargetingTypeField(true);
        }

        public APIRequestGetPartnerCategories requestTargetingTypeField(boolean value) {
            this.requestField("targeting_type", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreatePartnerIntegration
    extends APIRequest<PartnerIntegrationLinked> {
        PartnerIntegrationLinked lastResponse = null;
        public static final String[] PARAMS = new String[]{"external_id", "gtm_account_id", "gtm_container_id", "name", "partner"};
        public static final String[] FIELDS = new String[0];

        @Override
        public PartnerIntegrationLinked getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PartnerIntegrationLinked parseResponse(String response) throws APIException {
            return PartnerIntegrationLinked.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public PartnerIntegrationLinked execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PartnerIntegrationLinked execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<PartnerIntegrationLinked> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PartnerIntegrationLinked> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PartnerIntegrationLinked>(){

                public PartnerIntegrationLinked apply(String result) {
                    try {
                        return APIRequestCreatePartnerIntegration.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreatePartnerIntegration(String nodeId, APIContext context) {
            super(context, nodeId, "/partner_integrations", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreatePartnerIntegration setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreatePartnerIntegration setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreatePartnerIntegration setExternalId(String externalId) {
            this.setParam("external_id", externalId);
            return this;
        }

        public APIRequestCreatePartnerIntegration setGtmAccountId(String gtmAccountId) {
            this.setParam("gtm_account_id", gtmAccountId);
            return this;
        }

        public APIRequestCreatePartnerIntegration setGtmContainerId(String gtmContainerId) {
            this.setParam("gtm_container_id", gtmContainerId);
            return this;
        }

        public APIRequestCreatePartnerIntegration setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreatePartnerIntegration setPartner(PartnerIntegrationLinked.EnumPartner partner) {
            this.setParam("partner", (Object)partner);
            return this;
        }

        public APIRequestCreatePartnerIntegration setPartner(String partner) {
            this.setParam("partner", partner);
            return this;
        }

        public APIRequestCreatePartnerIntegration requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreatePartnerIntegration requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePartnerIntegration requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreatePartnerIntegration requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePartnerIntegration requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreatePartnerIntegration requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPartnerIntegrations
    extends APIRequest<PartnerIntegrationLinked> {
        APINodeList<PartnerIntegrationLinked> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ads_pixel", "application", "completed_integration_types", "external_id", "has_oauth_token", "id", "name", "offline_conversion_data_set", "partner", "partner_profile", "product_catalog", "setup_status"};

        @Override
        public APINodeList<PartnerIntegrationLinked> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<PartnerIntegrationLinked> parseResponse(String response) throws APIException {
            return PartnerIntegrationLinked.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<PartnerIntegrationLinked> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<PartnerIntegrationLinked> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<PartnerIntegrationLinked>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<PartnerIntegrationLinked>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<PartnerIntegrationLinked>>(){

                public APINodeList<PartnerIntegrationLinked> apply(String result) {
                    try {
                        return APIRequestGetPartnerIntegrations.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPartnerIntegrations(String nodeId, APIContext context) {
            super(context, nodeId, "/partner_integrations", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPartnerIntegrations setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPartnerIntegrations setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPartnerIntegrations requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPartnerIntegrations requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPartnerIntegrations requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPartnerIntegrations requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPartnerIntegrations requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPartnerIntegrations requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPartnerIntegrations requestAdsPixelField() {
            return this.requestAdsPixelField(true);
        }

        public APIRequestGetPartnerIntegrations requestAdsPixelField(boolean value) {
            this.requestField("ads_pixel", value);
            return this;
        }

        public APIRequestGetPartnerIntegrations requestApplicationField() {
            return this.requestApplicationField(true);
        }

        public APIRequestGetPartnerIntegrations requestApplicationField(boolean value) {
            this.requestField("application", value);
            return this;
        }

        public APIRequestGetPartnerIntegrations requestCompletedIntegrationTypesField() {
            return this.requestCompletedIntegrationTypesField(true);
        }

        public APIRequestGetPartnerIntegrations requestCompletedIntegrationTypesField(boolean value) {
            this.requestField("completed_integration_types", value);
            return this;
        }

        public APIRequestGetPartnerIntegrations requestExternalIdField() {
            return this.requestExternalIdField(true);
        }

        public APIRequestGetPartnerIntegrations requestExternalIdField(boolean value) {
            this.requestField("external_id", value);
            return this;
        }

        public APIRequestGetPartnerIntegrations requestHasOauthTokenField() {
            return this.requestHasOauthTokenField(true);
        }

        public APIRequestGetPartnerIntegrations requestHasOauthTokenField(boolean value) {
            this.requestField("has_oauth_token", value);
            return this;
        }

        public APIRequestGetPartnerIntegrations requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPartnerIntegrations requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetPartnerIntegrations requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetPartnerIntegrations requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetPartnerIntegrations requestOfflineConversionDataSetField() {
            return this.requestOfflineConversionDataSetField(true);
        }

        public APIRequestGetPartnerIntegrations requestOfflineConversionDataSetField(boolean value) {
            this.requestField("offline_conversion_data_set", value);
            return this;
        }

        public APIRequestGetPartnerIntegrations requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetPartnerIntegrations requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetPartnerIntegrations requestPartnerProfileField() {
            return this.requestPartnerProfileField(true);
        }

        public APIRequestGetPartnerIntegrations requestPartnerProfileField(boolean value) {
            this.requestField("partner_profile", value);
            return this;
        }

        public APIRequestGetPartnerIntegrations requestProductCatalogField() {
            return this.requestProductCatalogField(true);
        }

        public APIRequestGetPartnerIntegrations requestProductCatalogField(boolean value) {
            this.requestField("product_catalog", value);
            return this;
        }

        public APIRequestGetPartnerIntegrations requestSetupStatusField() {
            return this.requestSetupStatusField(true);
        }

        public APIRequestGetPartnerIntegrations requestSetupStatusField(boolean value) {
            this.requestField("setup_status", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetOffsitePixels
    extends APIRequest<OffsitePixel> {
        APINodeList<OffsitePixel> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"creator", "id", "js_pixel", "last_firing_time", "name", "status", "tag"};

        @Override
        public APINodeList<OffsitePixel> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<OffsitePixel> parseResponse(String response) throws APIException {
            return OffsitePixel.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<OffsitePixel> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<OffsitePixel> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<OffsitePixel>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<OffsitePixel>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<OffsitePixel>>(){

                public APINodeList<OffsitePixel> apply(String result) {
                    try {
                        return APIRequestGetOffsitePixels.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetOffsitePixels(String nodeId, APIContext context) {
            super(context, nodeId, "/offsitepixels", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetOffsitePixels setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetOffsitePixels setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetOffsitePixels requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetOffsitePixels requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOffsitePixels requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetOffsitePixels requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOffsitePixels requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetOffsitePixels requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetOffsitePixels requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGetOffsitePixels requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGetOffsitePixels requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetOffsitePixels requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetOffsitePixels requestJsPixelField() {
            return this.requestJsPixelField(true);
        }

        public APIRequestGetOffsitePixels requestJsPixelField(boolean value) {
            this.requestField("js_pixel", value);
            return this;
        }

        public APIRequestGetOffsitePixels requestLastFiringTimeField() {
            return this.requestLastFiringTimeField(true);
        }

        public APIRequestGetOffsitePixels requestLastFiringTimeField(boolean value) {
            this.requestField("last_firing_time", value);
            return this;
        }

        public APIRequestGetOffsitePixels requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetOffsitePixels requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetOffsitePixels requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetOffsitePixels requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetOffsitePixels requestTagField() {
            return this.requestTagField(true);
        }

        public APIRequestGetOffsitePixels requestTagField(boolean value) {
            this.requestField("tag", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetOfflineConversionDataSets
    extends APIRequest<OfflineConversionDataSet> {
        APINodeList<OfflineConversionDataSet> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"attribute_stats", "business", "config", "creation_time", "data_origin", "description", "duplicate_entries", "enable_auto_assign_to_accounts", "event_stats", "event_time_max", "event_time_min", "id", "is_mta_use", "is_restricted_use", "last_upload_app", "last_upload_app_changed_time", "match_rate_approx", "matched_entries", "matched_unique_users", "name", "usage", "valid_entries"};

        @Override
        public APINodeList<OfflineConversionDataSet> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<OfflineConversionDataSet> parseResponse(String response) throws APIException {
            return OfflineConversionDataSet.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<OfflineConversionDataSet> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<OfflineConversionDataSet> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<OfflineConversionDataSet>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<OfflineConversionDataSet>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<OfflineConversionDataSet>>(){

                public APINodeList<OfflineConversionDataSet> apply(String result) {
                    try {
                        return APIRequestGetOfflineConversionDataSets.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetOfflineConversionDataSets(String nodeId, APIContext context) {
            super(context, nodeId, "/offline_conversion_data_sets", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetOfflineConversionDataSets setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetOfflineConversionDataSets setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetOfflineConversionDataSets requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOfflineConversionDataSets requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetOfflineConversionDataSets requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOfflineConversionDataSets requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetOfflineConversionDataSets requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestAttributeStatsField() {
            return this.requestAttributeStatsField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestAttributeStatsField(boolean value) {
            this.requestField("attribute_stats", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestConfigField() {
            return this.requestConfigField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestConfigField(boolean value) {
            this.requestField("config", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestDataOriginField() {
            return this.requestDataOriginField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestDataOriginField(boolean value) {
            this.requestField("data_origin", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestDuplicateEntriesField() {
            return this.requestDuplicateEntriesField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestDuplicateEntriesField(boolean value) {
            this.requestField("duplicate_entries", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestEnableAutoAssignToAccountsField() {
            return this.requestEnableAutoAssignToAccountsField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestEnableAutoAssignToAccountsField(boolean value) {
            this.requestField("enable_auto_assign_to_accounts", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestEventStatsField() {
            return this.requestEventStatsField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestEventStatsField(boolean value) {
            this.requestField("event_stats", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestEventTimeMaxField() {
            return this.requestEventTimeMaxField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestEventTimeMaxField(boolean value) {
            this.requestField("event_time_max", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestEventTimeMinField() {
            return this.requestEventTimeMinField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestEventTimeMinField(boolean value) {
            this.requestField("event_time_min", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestIsMtaUseField() {
            return this.requestIsMtaUseField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestIsMtaUseField(boolean value) {
            this.requestField("is_mta_use", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestIsRestrictedUseField() {
            return this.requestIsRestrictedUseField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestIsRestrictedUseField(boolean value) {
            this.requestField("is_restricted_use", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestLastUploadAppField() {
            return this.requestLastUploadAppField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestLastUploadAppField(boolean value) {
            this.requestField("last_upload_app", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestLastUploadAppChangedTimeField() {
            return this.requestLastUploadAppChangedTimeField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestLastUploadAppChangedTimeField(boolean value) {
            this.requestField("last_upload_app_changed_time", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestMatchRateApproxField() {
            return this.requestMatchRateApproxField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestMatchRateApproxField(boolean value) {
            this.requestField("match_rate_approx", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestMatchedEntriesField() {
            return this.requestMatchedEntriesField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestMatchedEntriesField(boolean value) {
            this.requestField("matched_entries", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestMatchedUniqueUsersField() {
            return this.requestMatchedUniqueUsersField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestMatchedUniqueUsersField(boolean value) {
            this.requestField("matched_unique_users", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestUsageField() {
            return this.requestUsageField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestUsageField(boolean value) {
            this.requestField("usage", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestValidEntriesField() {
            return this.requestValidEntriesField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestValidEntriesField(boolean value) {
            this.requestField("valid_entries", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateMockup
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"mockup_access_token", "source_mockup_id", "page_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateMockup.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateMockup(String nodeId, APIContext context) {
            super(context, nodeId, "/mockups", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateMockup setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateMockup setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateMockup setMockupAccessToken(String mockupAccessToken) {
            this.setParam("mockup_access_token", mockupAccessToken);
            return this;
        }

        public APIRequestCreateMockup setSourceMockupId(String sourceMockupId) {
            this.setParam("source_mockup_id", sourceMockupId);
            return this;
        }

        public APIRequestCreateMockup setPageId(String pageId) {
            this.setParam("page_id", pageId);
            return this;
        }

        public APIRequestCreateMockup requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateMockup requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMockup requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateMockup requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMockup requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateMockup requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetMinimumBudgets
    extends APIRequest<MinimumBudget> {
        APINodeList<MinimumBudget> lastResponse = null;
        public static final String[] PARAMS = new String[]{"bid_amount"};
        public static final String[] FIELDS = new String[]{"currency", "min_daily_budget_high_freq", "min_daily_budget_imp", "min_daily_budget_low_freq", "min_daily_budget_video_views", "id"};

        @Override
        public APINodeList<MinimumBudget> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<MinimumBudget> parseResponse(String response) throws APIException {
            return MinimumBudget.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<MinimumBudget> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<MinimumBudget> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<MinimumBudget>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<MinimumBudget>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<MinimumBudget>>(){

                public APINodeList<MinimumBudget> apply(String result) {
                    try {
                        return APIRequestGetMinimumBudgets.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetMinimumBudgets(String nodeId, APIContext context) {
            super(context, nodeId, "/minimum_budgets", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetMinimumBudgets setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetMinimumBudgets setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetMinimumBudgets setBidAmount(Long bidAmount) {
            this.setParam("bid_amount", bidAmount);
            return this;
        }

        public APIRequestGetMinimumBudgets setBidAmount(String bidAmount) {
            this.setParam("bid_amount", bidAmount);
            return this;
        }

        public APIRequestGetMinimumBudgets requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetMinimumBudgets requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMinimumBudgets requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetMinimumBudgets requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMinimumBudgets requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetMinimumBudgets requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetMinimumBudgets requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetMinimumBudgets requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetMinimumBudgets requestMinDailyBudgetHighFreqField() {
            return this.requestMinDailyBudgetHighFreqField(true);
        }

        public APIRequestGetMinimumBudgets requestMinDailyBudgetHighFreqField(boolean value) {
            this.requestField("min_daily_budget_high_freq", value);
            return this;
        }

        public APIRequestGetMinimumBudgets requestMinDailyBudgetImpField() {
            return this.requestMinDailyBudgetImpField(true);
        }

        public APIRequestGetMinimumBudgets requestMinDailyBudgetImpField(boolean value) {
            this.requestField("min_daily_budget_imp", value);
            return this;
        }

        public APIRequestGetMinimumBudgets requestMinDailyBudgetLowFreqField() {
            return this.requestMinDailyBudgetLowFreqField(true);
        }

        public APIRequestGetMinimumBudgets requestMinDailyBudgetLowFreqField(boolean value) {
            this.requestField("min_daily_budget_low_freq", value);
            return this;
        }

        public APIRequestGetMinimumBudgets requestMinDailyBudgetVideoViewsField() {
            return this.requestMinDailyBudgetVideoViewsField(true);
        }

        public APIRequestGetMinimumBudgets requestMinDailyBudgetVideoViewsField(boolean value) {
            this.requestField("min_daily_budget_video_views", value);
            return this;
        }

        public APIRequestGetMinimumBudgets requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetMinimumBudgets requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetMaxBid
    extends APIRequest<AdAccountMaxBid> {
        APINodeList<AdAccountMaxBid> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"max_bid", "id"};

        @Override
        public APINodeList<AdAccountMaxBid> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccountMaxBid> parseResponse(String response) throws APIException {
            return AdAccountMaxBid.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccountMaxBid> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccountMaxBid> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccountMaxBid>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccountMaxBid>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAccountMaxBid>>(){

                public APINodeList<AdAccountMaxBid> apply(String result) {
                    try {
                        return APIRequestGetMaxBid.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetMaxBid(String nodeId, APIContext context) {
            super(context, nodeId, "/max_bid", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetMaxBid setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetMaxBid setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetMaxBid requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetMaxBid requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMaxBid requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetMaxBid requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMaxBid requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetMaxBid requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetMaxBid requestMaxBidField() {
            return this.requestMaxBidField(true);
        }

        public APIRequestGetMaxBid requestMaxBidField(boolean value) {
            this.requestField("max_bid", value);
            return this;
        }

        public APIRequestGetMaxBid requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetMaxBid requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetMatchedSearchApplications
    extends APIRequest<AdAccountMatchedSearchApplicationsEdgeData> {
        APINodeList<AdAccountMatchedSearchApplicationsEdgeData> lastResponse = null;
        public static final String[] PARAMS = new String[]{"app_store", "app_store_country", "business_id", "query_term", "allow_incomplete_app"};
        public static final String[] FIELDS = new String[]{"app_id", "icon_url", "name", "search_source_store", "store", "unique_id", "url", "id"};

        @Override
        public APINodeList<AdAccountMatchedSearchApplicationsEdgeData> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccountMatchedSearchApplicationsEdgeData> parseResponse(String response) throws APIException {
            return AdAccountMatchedSearchApplicationsEdgeData.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccountMatchedSearchApplicationsEdgeData> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccountMatchedSearchApplicationsEdgeData> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccountMatchedSearchApplicationsEdgeData>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccountMatchedSearchApplicationsEdgeData>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAccountMatchedSearchApplicationsEdgeData>>(){

                public APINodeList<AdAccountMatchedSearchApplicationsEdgeData> apply(String result) {
                    try {
                        return APIRequestGetMatchedSearchApplications.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetMatchedSearchApplications(String nodeId, APIContext context) {
            super(context, nodeId, "/matched_search_applications", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetMatchedSearchApplications setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetMatchedSearchApplications setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetMatchedSearchApplications setAppStore(AdAccountMatchedSearchApplicationsEdgeData.EnumAppStore appStore) {
            this.setParam("app_store", (Object)appStore);
            return this;
        }

        public APIRequestGetMatchedSearchApplications setAppStore(String appStore) {
            this.setParam("app_store", appStore);
            return this;
        }

        public APIRequestGetMatchedSearchApplications setAppStoreCountry(String appStoreCountry) {
            this.setParam("app_store_country", appStoreCountry);
            return this;
        }

        public APIRequestGetMatchedSearchApplications setBusinessId(Object businessId) {
            this.setParam("business_id", businessId);
            return this;
        }

        public APIRequestGetMatchedSearchApplications setBusinessId(String businessId) {
            this.setParam("business_id", businessId);
            return this;
        }

        public APIRequestGetMatchedSearchApplications setQueryTerm(String queryTerm) {
            this.setParam("query_term", queryTerm);
            return this;
        }

        public APIRequestGetMatchedSearchApplications setAllowIncompleteApp(Boolean allowIncompleteApp) {
            this.setParam("allow_incomplete_app", allowIncompleteApp);
            return this;
        }

        public APIRequestGetMatchedSearchApplications setAllowIncompleteApp(String allowIncompleteApp) {
            this.setParam("allow_incomplete_app", allowIncompleteApp);
            return this;
        }

        public APIRequestGetMatchedSearchApplications requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetMatchedSearchApplications requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMatchedSearchApplications requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetMatchedSearchApplications requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMatchedSearchApplications requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetMatchedSearchApplications requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetMatchedSearchApplications requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGetMatchedSearchApplications requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGetMatchedSearchApplications requestIconUrlField() {
            return this.requestIconUrlField(true);
        }

        public APIRequestGetMatchedSearchApplications requestIconUrlField(boolean value) {
            this.requestField("icon_url", value);
            return this;
        }

        public APIRequestGetMatchedSearchApplications requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetMatchedSearchApplications requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetMatchedSearchApplications requestSearchSourceStoreField() {
            return this.requestSearchSourceStoreField(true);
        }

        public APIRequestGetMatchedSearchApplications requestSearchSourceStoreField(boolean value) {
            this.requestField("search_source_store", value);
            return this;
        }

        public APIRequestGetMatchedSearchApplications requestStoreField() {
            return this.requestStoreField(true);
        }

        public APIRequestGetMatchedSearchApplications requestStoreField(boolean value) {
            this.requestField("store", value);
            return this;
        }

        public APIRequestGetMatchedSearchApplications requestUniqueIdField() {
            return this.requestUniqueIdField(true);
        }

        public APIRequestGetMatchedSearchApplications requestUniqueIdField(boolean value) {
            this.requestField("unique_id", value);
            return this;
        }

        public APIRequestGetMatchedSearchApplications requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGetMatchedSearchApplications requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGetMatchedSearchApplications requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetMatchedSearchApplications requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateLocationCluster
    extends APIRequest<AdAccount> {
        AdAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"locations"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccount parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccount execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccount>(){

                public AdAccount apply(String result) {
                    try {
                        return APIRequestCreateLocationCluster.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateLocationCluster(String nodeId, APIContext context) {
            super(context, nodeId, "/locationclusters", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateLocationCluster setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateLocationCluster setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateLocationCluster setLocations(List<String> locations) {
            this.setParam("locations", locations);
            return this;
        }

        public APIRequestCreateLocationCluster setLocations(String locations) {
            this.setParam("locations", locations);
            return this;
        }

        public APIRequestCreateLocationCluster requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateLocationCluster requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLocationCluster requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateLocationCluster requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLocationCluster requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateLocationCluster requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetLeadGenForms
    extends APIRequest<LeadgenForm> {
        APINodeList<LeadgenForm> lastResponse = null;
        public static final String[] PARAMS = new String[]{"query"};
        public static final String[] FIELDS = new String[]{"allow_organic_lead", "block_display_for_non_targeted_viewer", "context_card", "created_time", "creator", "creator_id", "cusomized_tcpa_content", "expired_leads_count", "extra_details", "follow_up_action_text", "follow_up_action_url", "id", "is_optimized_for_quality", "leadgen_export_csv_url", "leads_count", "legal_content", "locale", "messenger_welcome_message", "name", "organic_leads_count", "page", "page_id", "privacy_policy_url", "qualifiers", "question_page_custom_headline", "questions", "status", "tcpa_compliance", "thank_you_page", "tracking_parameters"};

        @Override
        public APINodeList<LeadgenForm> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<LeadgenForm> parseResponse(String response) throws APIException {
            return LeadgenForm.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<LeadgenForm> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<LeadgenForm> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<LeadgenForm>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<LeadgenForm>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<LeadgenForm>>(){

                public APINodeList<LeadgenForm> apply(String result) {
                    try {
                        return APIRequestGetLeadGenForms.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetLeadGenForms(String nodeId, APIContext context) {
            super(context, nodeId, "/leadgen_forms", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetLeadGenForms setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetLeadGenForms setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetLeadGenForms setQuery(String query) {
            this.setParam("query", query);
            return this;
        }

        public APIRequestGetLeadGenForms requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetLeadGenForms requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLeadGenForms requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetLeadGenForms requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLeadGenForms requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetLeadGenForms requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetLeadGenForms requestAllowOrganicLeadField() {
            return this.requestAllowOrganicLeadField(true);
        }

        public APIRequestGetLeadGenForms requestAllowOrganicLeadField(boolean value) {
            this.requestField("allow_organic_lead", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestBlockDisplayForNonTargetedViewerField() {
            return this.requestBlockDisplayForNonTargetedViewerField(true);
        }

        public APIRequestGetLeadGenForms requestBlockDisplayForNonTargetedViewerField(boolean value) {
            this.requestField("block_display_for_non_targeted_viewer", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestContextCardField() {
            return this.requestContextCardField(true);
        }

        public APIRequestGetLeadGenForms requestContextCardField(boolean value) {
            this.requestField("context_card", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetLeadGenForms requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGetLeadGenForms requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestCreatorIdField() {
            return this.requestCreatorIdField(true);
        }

        public APIRequestGetLeadGenForms requestCreatorIdField(boolean value) {
            this.requestField("creator_id", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestCusomizedTcpaContentField() {
            return this.requestCusomizedTcpaContentField(true);
        }

        public APIRequestGetLeadGenForms requestCusomizedTcpaContentField(boolean value) {
            this.requestField("cusomized_tcpa_content", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestExpiredLeadsCountField() {
            return this.requestExpiredLeadsCountField(true);
        }

        public APIRequestGetLeadGenForms requestExpiredLeadsCountField(boolean value) {
            this.requestField("expired_leads_count", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestExtraDetailsField() {
            return this.requestExtraDetailsField(true);
        }

        public APIRequestGetLeadGenForms requestExtraDetailsField(boolean value) {
            this.requestField("extra_details", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestFollowUpActionTextField() {
            return this.requestFollowUpActionTextField(true);
        }

        public APIRequestGetLeadGenForms requestFollowUpActionTextField(boolean value) {
            this.requestField("follow_up_action_text", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestFollowUpActionUrlField() {
            return this.requestFollowUpActionUrlField(true);
        }

        public APIRequestGetLeadGenForms requestFollowUpActionUrlField(boolean value) {
            this.requestField("follow_up_action_url", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetLeadGenForms requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestIsOptimizedForQualityField() {
            return this.requestIsOptimizedForQualityField(true);
        }

        public APIRequestGetLeadGenForms requestIsOptimizedForQualityField(boolean value) {
            this.requestField("is_optimized_for_quality", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestLeadgenExportCsvUrlField() {
            return this.requestLeadgenExportCsvUrlField(true);
        }

        public APIRequestGetLeadGenForms requestLeadgenExportCsvUrlField(boolean value) {
            this.requestField("leadgen_export_csv_url", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestLeadsCountField() {
            return this.requestLeadsCountField(true);
        }

        public APIRequestGetLeadGenForms requestLeadsCountField(boolean value) {
            this.requestField("leads_count", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestLegalContentField() {
            return this.requestLegalContentField(true);
        }

        public APIRequestGetLeadGenForms requestLegalContentField(boolean value) {
            this.requestField("legal_content", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestLocaleField() {
            return this.requestLocaleField(true);
        }

        public APIRequestGetLeadGenForms requestLocaleField(boolean value) {
            this.requestField("locale", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestMessengerWelcomeMessageField() {
            return this.requestMessengerWelcomeMessageField(true);
        }

        public APIRequestGetLeadGenForms requestMessengerWelcomeMessageField(boolean value) {
            this.requestField("messenger_welcome_message", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetLeadGenForms requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestOrganicLeadsCountField() {
            return this.requestOrganicLeadsCountField(true);
        }

        public APIRequestGetLeadGenForms requestOrganicLeadsCountField(boolean value) {
            this.requestField("organic_leads_count", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestPageField() {
            return this.requestPageField(true);
        }

        public APIRequestGetLeadGenForms requestPageField(boolean value) {
            this.requestField("page", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestPageIdField() {
            return this.requestPageIdField(true);
        }

        public APIRequestGetLeadGenForms requestPageIdField(boolean value) {
            this.requestField("page_id", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestPrivacyPolicyUrlField() {
            return this.requestPrivacyPolicyUrlField(true);
        }

        public APIRequestGetLeadGenForms requestPrivacyPolicyUrlField(boolean value) {
            this.requestField("privacy_policy_url", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestQualifiersField() {
            return this.requestQualifiersField(true);
        }

        public APIRequestGetLeadGenForms requestQualifiersField(boolean value) {
            this.requestField("qualifiers", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestQuestionPageCustomHeadlineField() {
            return this.requestQuestionPageCustomHeadlineField(true);
        }

        public APIRequestGetLeadGenForms requestQuestionPageCustomHeadlineField(boolean value) {
            this.requestField("question_page_custom_headline", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestQuestionsField() {
            return this.requestQuestionsField(true);
        }

        public APIRequestGetLeadGenForms requestQuestionsField(boolean value) {
            this.requestField("questions", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetLeadGenForms requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestTcpaComplianceField() {
            return this.requestTcpaComplianceField(true);
        }

        public APIRequestGetLeadGenForms requestTcpaComplianceField(boolean value) {
            this.requestField("tcpa_compliance", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestThankYouPageField() {
            return this.requestThankYouPageField(true);
        }

        public APIRequestGetLeadGenForms requestThankYouPageField(boolean value) {
            this.requestField("thank_you_page", value);
            return this;
        }

        public APIRequestGetLeadGenForms requestTrackingParametersField() {
            return this.requestTrackingParametersField(true);
        }

        public APIRequestGetLeadGenForms requestTrackingParametersField(boolean value) {
            this.requestField("tracking_parameters", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetInstagramAccounts
    extends APIRequest<InstagramUser> {
        APINodeList<InstagramUser> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"follow_count", "followed_by_count", "has_profile_picture", "id", "is_private", "is_published", "media_count", "profile_pic", "username"};

        @Override
        public APINodeList<InstagramUser> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<InstagramUser> parseResponse(String response) throws APIException {
            return InstagramUser.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<InstagramUser> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<InstagramUser> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<InstagramUser>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<InstagramUser>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<InstagramUser>>(){

                public APINodeList<InstagramUser> apply(String result) {
                    try {
                        return APIRequestGetInstagramAccounts.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetInstagramAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/instagram_accounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetInstagramAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInstagramAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInstagramAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInstagramAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInstagramAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInstagramAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInstagramAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInstagramAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetInstagramAccounts requestFollowCountField() {
            return this.requestFollowCountField(true);
        }

        public APIRequestGetInstagramAccounts requestFollowCountField(boolean value) {
            this.requestField("follow_count", value);
            return this;
        }

        public APIRequestGetInstagramAccounts requestFollowedByCountField() {
            return this.requestFollowedByCountField(true);
        }

        public APIRequestGetInstagramAccounts requestFollowedByCountField(boolean value) {
            this.requestField("followed_by_count", value);
            return this;
        }

        public APIRequestGetInstagramAccounts requestHasProfilePictureField() {
            return this.requestHasProfilePictureField(true);
        }

        public APIRequestGetInstagramAccounts requestHasProfilePictureField(boolean value) {
            this.requestField("has_profile_picture", value);
            return this;
        }

        public APIRequestGetInstagramAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetInstagramAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetInstagramAccounts requestIsPrivateField() {
            return this.requestIsPrivateField(true);
        }

        public APIRequestGetInstagramAccounts requestIsPrivateField(boolean value) {
            this.requestField("is_private", value);
            return this;
        }

        public APIRequestGetInstagramAccounts requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetInstagramAccounts requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetInstagramAccounts requestMediaCountField() {
            return this.requestMediaCountField(true);
        }

        public APIRequestGetInstagramAccounts requestMediaCountField(boolean value) {
            this.requestField("media_count", value);
            return this;
        }

        public APIRequestGetInstagramAccounts requestProfilePicField() {
            return this.requestProfilePicField(true);
        }

        public APIRequestGetInstagramAccounts requestProfilePicField(boolean value) {
            this.requestField("profile_pic", value);
            return this;
        }

        public APIRequestGetInstagramAccounts requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetInstagramAccounts requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetInsightsAsync
    extends APIRequest<AdReportRun> {
        AdReportRun lastResponse = null;
        public static final String[] PARAMS = new String[]{"default_summary", "fields", "filtering", "summary", "sort", "action_attribution_windows", "action_breakdowns", "action_report_time", "breakdowns", "date_preset", "export_columns", "export_format", "export_name", "level", "product_id_limit", "summary_action_breakdowns", "time_increment", "time_range", "time_ranges", "use_account_attribution_setting"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdReportRun getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdReportRun parseResponse(String response) throws APIException {
            return AdReportRun.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdReportRun execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdReportRun execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdReportRun> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdReportRun> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdReportRun>(){

                public AdReportRun apply(String result) {
                    try {
                        return APIRequestGetInsightsAsync.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetInsightsAsync(String nodeId, APIContext context) {
            super(context, nodeId, "/insights", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestGetInsightsAsync setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInsightsAsync setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInsightsAsync setDefaultSummary(Boolean defaultSummary) {
            this.setParam("default_summary", defaultSummary);
            return this;
        }

        public APIRequestGetInsightsAsync setDefaultSummary(String defaultSummary) {
            this.setParam("default_summary", defaultSummary);
            return this;
        }

        public APIRequestGetInsightsAsync setFields(List<String> fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetInsightsAsync setFields(String fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetInsightsAsync setFiltering(List<Object> filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetInsightsAsync setFiltering(String filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetInsightsAsync setSummary(List<String> summary) {
            this.setParam("summary", summary);
            return this;
        }

        public APIRequestGetInsightsAsync setSummary(String summary) {
            this.setParam("summary", summary);
            return this;
        }

        public APIRequestGetInsightsAsync setSort(List<String> sort) {
            this.setParam("sort", sort);
            return this;
        }

        public APIRequestGetInsightsAsync setSort(String sort) {
            this.setParam("sort", sort);
            return this;
        }

        public APIRequestGetInsightsAsync setActionAttributionWindows(List<AdsInsights.EnumActionAttributionWindows> actionAttributionWindows) {
            this.setParam("action_attribution_windows", actionAttributionWindows);
            return this;
        }

        public APIRequestGetInsightsAsync setActionAttributionWindows(String actionAttributionWindows) {
            this.setParam("action_attribution_windows", actionAttributionWindows);
            return this;
        }

        public APIRequestGetInsightsAsync setActionBreakdowns(List<AdsInsights.EnumActionBreakdowns> actionBreakdowns) {
            this.setParam("action_breakdowns", actionBreakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setActionBreakdowns(String actionBreakdowns) {
            this.setParam("action_breakdowns", actionBreakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setActionReportTime(AdsInsights.EnumActionReportTime actionReportTime) {
            this.setParam("action_report_time", (Object)actionReportTime);
            return this;
        }

        public APIRequestGetInsightsAsync setActionReportTime(String actionReportTime) {
            this.setParam("action_report_time", actionReportTime);
            return this;
        }

        public APIRequestGetInsightsAsync setBreakdowns(List<AdsInsights.EnumBreakdowns> breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setBreakdowns(String breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setDatePreset(AdsInsights.EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestGetInsightsAsync setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestGetInsightsAsync setExportColumns(List<String> exportColumns) {
            this.setParam("export_columns", exportColumns);
            return this;
        }

        public APIRequestGetInsightsAsync setExportColumns(String exportColumns) {
            this.setParam("export_columns", exportColumns);
            return this;
        }

        public APIRequestGetInsightsAsync setExportFormat(String exportFormat) {
            this.setParam("export_format", exportFormat);
            return this;
        }

        public APIRequestGetInsightsAsync setExportName(String exportName) {
            this.setParam("export_name", exportName);
            return this;
        }

        public APIRequestGetInsightsAsync setLevel(AdsInsights.EnumLevel level) {
            this.setParam("level", (Object)level);
            return this;
        }

        public APIRequestGetInsightsAsync setLevel(String level) {
            this.setParam("level", level);
            return this;
        }

        public APIRequestGetInsightsAsync setProductIdLimit(Long productIdLimit) {
            this.setParam("product_id_limit", productIdLimit);
            return this;
        }

        public APIRequestGetInsightsAsync setProductIdLimit(String productIdLimit) {
            this.setParam("product_id_limit", productIdLimit);
            return this;
        }

        public APIRequestGetInsightsAsync setSummaryActionBreakdowns(List<AdsInsights.EnumSummaryActionBreakdowns> summaryActionBreakdowns) {
            this.setParam("summary_action_breakdowns", summaryActionBreakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setSummaryActionBreakdowns(String summaryActionBreakdowns) {
            this.setParam("summary_action_breakdowns", summaryActionBreakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setTimeIncrement(String timeIncrement) {
            this.setParam("time_increment", timeIncrement);
            return this;
        }

        public APIRequestGetInsightsAsync setTimeRange(Object timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetInsightsAsync setTimeRange(String timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetInsightsAsync setTimeRanges(List<Object> timeRanges) {
            this.setParam("time_ranges", timeRanges);
            return this;
        }

        public APIRequestGetInsightsAsync setTimeRanges(String timeRanges) {
            this.setParam("time_ranges", timeRanges);
            return this;
        }

        public APIRequestGetInsightsAsync setUseAccountAttributionSetting(Boolean useAccountAttributionSetting) {
            this.setParam("use_account_attribution_setting", useAccountAttributionSetting);
            return this;
        }

        public APIRequestGetInsightsAsync setUseAccountAttributionSetting(String useAccountAttributionSetting) {
            this.setParam("use_account_attribution_setting", useAccountAttributionSetting);
            return this;
        }

        public APIRequestGetInsightsAsync requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInsightsAsync requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsightsAsync requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInsightsAsync requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsightsAsync requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInsightsAsync requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetInsights
    extends APIRequest<AdsInsights> {
        APINodeList<AdsInsights> lastResponse = null;
        public static final String[] PARAMS = new String[]{"default_summary", "fields", "filtering", "summary", "sort", "action_attribution_windows", "action_breakdowns", "action_report_time", "breakdowns", "date_preset", "export_columns", "export_format", "export_name", "level", "product_id_limit", "summary_action_breakdowns", "time_increment", "time_range", "time_ranges", "use_account_attribution_setting"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<AdsInsights> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdsInsights> parseResponse(String response) throws APIException {
            return AdsInsights.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdsInsights> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdsInsights> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdsInsights>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdsInsights>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdsInsights>>(){

                public APINodeList<AdsInsights> apply(String result) {
                    try {
                        return APIRequestGetInsights.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetInsights(String nodeId, APIContext context) {
            super(context, nodeId, "/insights", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetInsights setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInsights setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInsights setDefaultSummary(Boolean defaultSummary) {
            this.setParam("default_summary", defaultSummary);
            return this;
        }

        public APIRequestGetInsights setDefaultSummary(String defaultSummary) {
            this.setParam("default_summary", defaultSummary);
            return this;
        }

        public APIRequestGetInsights setFields(List<String> fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetInsights setFields(String fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetInsights setFiltering(List<Object> filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetInsights setFiltering(String filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetInsights setSummary(List<String> summary) {
            this.setParam("summary", summary);
            return this;
        }

        public APIRequestGetInsights setSummary(String summary) {
            this.setParam("summary", summary);
            return this;
        }

        public APIRequestGetInsights setSort(List<String> sort) {
            this.setParam("sort", sort);
            return this;
        }

        public APIRequestGetInsights setSort(String sort) {
            this.setParam("sort", sort);
            return this;
        }

        public APIRequestGetInsights setActionAttributionWindows(List<AdsInsights.EnumActionAttributionWindows> actionAttributionWindows) {
            this.setParam("action_attribution_windows", actionAttributionWindows);
            return this;
        }

        public APIRequestGetInsights setActionAttributionWindows(String actionAttributionWindows) {
            this.setParam("action_attribution_windows", actionAttributionWindows);
            return this;
        }

        public APIRequestGetInsights setActionBreakdowns(List<AdsInsights.EnumActionBreakdowns> actionBreakdowns) {
            this.setParam("action_breakdowns", actionBreakdowns);
            return this;
        }

        public APIRequestGetInsights setActionBreakdowns(String actionBreakdowns) {
            this.setParam("action_breakdowns", actionBreakdowns);
            return this;
        }

        public APIRequestGetInsights setActionReportTime(AdsInsights.EnumActionReportTime actionReportTime) {
            this.setParam("action_report_time", (Object)actionReportTime);
            return this;
        }

        public APIRequestGetInsights setActionReportTime(String actionReportTime) {
            this.setParam("action_report_time", actionReportTime);
            return this;
        }

        public APIRequestGetInsights setBreakdowns(List<AdsInsights.EnumBreakdowns> breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGetInsights setBreakdowns(String breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGetInsights setDatePreset(AdsInsights.EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestGetInsights setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestGetInsights setExportColumns(List<String> exportColumns) {
            this.setParam("export_columns", exportColumns);
            return this;
        }

        public APIRequestGetInsights setExportColumns(String exportColumns) {
            this.setParam("export_columns", exportColumns);
            return this;
        }

        public APIRequestGetInsights setExportFormat(String exportFormat) {
            this.setParam("export_format", exportFormat);
            return this;
        }

        public APIRequestGetInsights setExportName(String exportName) {
            this.setParam("export_name", exportName);
            return this;
        }

        public APIRequestGetInsights setLevel(AdsInsights.EnumLevel level) {
            this.setParam("level", (Object)level);
            return this;
        }

        public APIRequestGetInsights setLevel(String level) {
            this.setParam("level", level);
            return this;
        }

        public APIRequestGetInsights setProductIdLimit(Long productIdLimit) {
            this.setParam("product_id_limit", productIdLimit);
            return this;
        }

        public APIRequestGetInsights setProductIdLimit(String productIdLimit) {
            this.setParam("product_id_limit", productIdLimit);
            return this;
        }

        public APIRequestGetInsights setSummaryActionBreakdowns(List<AdsInsights.EnumSummaryActionBreakdowns> summaryActionBreakdowns) {
            this.setParam("summary_action_breakdowns", summaryActionBreakdowns);
            return this;
        }

        public APIRequestGetInsights setSummaryActionBreakdowns(String summaryActionBreakdowns) {
            this.setParam("summary_action_breakdowns", summaryActionBreakdowns);
            return this;
        }

        public APIRequestGetInsights setTimeIncrement(String timeIncrement) {
            this.setParam("time_increment", timeIncrement);
            return this;
        }

        public APIRequestGetInsights setTimeRange(Object timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetInsights setTimeRange(String timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetInsights setTimeRanges(List<Object> timeRanges) {
            this.setParam("time_ranges", timeRanges);
            return this;
        }

        public APIRequestGetInsights setTimeRanges(String timeRanges) {
            this.setParam("time_ranges", timeRanges);
            return this;
        }

        public APIRequestGetInsights setUseAccountAttributionSetting(Boolean useAccountAttributionSetting) {
            this.setParam("use_account_attribution_setting", useAccountAttributionSetting);
            return this;
        }

        public APIRequestGetInsights setUseAccountAttributionSetting(String useAccountAttributionSetting) {
            this.setParam("use_account_attribution_setting", useAccountAttributionSetting);
            return this;
        }

        public APIRequestGetInsights requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInsights requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetImpactingAdStudies
    extends APIRequest<AdStudy> {
        APINodeList<AdStudy> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "canceled_time", "cooldown_start_time", "created_by", "created_time", "description", "end_time", "id", "name", "observation_end_time", "results_first_available_date", "start_time", "type", "updated_by", "updated_time"};

        @Override
        public APINodeList<AdStudy> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdStudy> parseResponse(String response) throws APIException {
            return AdStudy.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdStudy> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdStudy> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdStudy>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdStudy>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdStudy>>(){

                public APINodeList<AdStudy> apply(String result) {
                    try {
                        return APIRequestGetImpactingAdStudies.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetImpactingAdStudies(String nodeId, APIContext context) {
            super(context, nodeId, "/impacting_ad_studies", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetImpactingAdStudies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetImpactingAdStudies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetImpactingAdStudies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetImpactingAdStudies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetImpactingAdStudies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetImpactingAdStudies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetImpactingAdStudies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetImpactingAdStudies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetImpactingAdStudies requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetImpactingAdStudies requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetImpactingAdStudies requestCanceledTimeField() {
            return this.requestCanceledTimeField(true);
        }

        public APIRequestGetImpactingAdStudies requestCanceledTimeField(boolean value) {
            this.requestField("canceled_time", value);
            return this;
        }

        public APIRequestGetImpactingAdStudies requestCooldownStartTimeField() {
            return this.requestCooldownStartTimeField(true);
        }

        public APIRequestGetImpactingAdStudies requestCooldownStartTimeField(boolean value) {
            this.requestField("cooldown_start_time", value);
            return this;
        }

        public APIRequestGetImpactingAdStudies requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGetImpactingAdStudies requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGetImpactingAdStudies requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetImpactingAdStudies requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetImpactingAdStudies requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetImpactingAdStudies requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetImpactingAdStudies requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGetImpactingAdStudies requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGetImpactingAdStudies requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetImpactingAdStudies requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetImpactingAdStudies requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetImpactingAdStudies requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetImpactingAdStudies requestObservationEndTimeField() {
            return this.requestObservationEndTimeField(true);
        }

        public APIRequestGetImpactingAdStudies requestObservationEndTimeField(boolean value) {
            this.requestField("observation_end_time", value);
            return this;
        }

        public APIRequestGetImpactingAdStudies requestResultsFirstAvailableDateField() {
            return this.requestResultsFirstAvailableDateField(true);
        }

        public APIRequestGetImpactingAdStudies requestResultsFirstAvailableDateField(boolean value) {
            this.requestField("results_first_available_date", value);
            return this;
        }

        public APIRequestGetImpactingAdStudies requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetImpactingAdStudies requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetImpactingAdStudies requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetImpactingAdStudies requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetImpactingAdStudies requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGetImpactingAdStudies requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGetImpactingAdStudies requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetImpactingAdStudies requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetGeneratePreviews
    extends APIRequest<AdPreview> {
        APINodeList<AdPreview> lastResponse = null;
        public static final String[] PARAMS = new String[]{"ad_format", "dynamic_creative_spec", "interactive", "post", "height", "width", "place_page_id", "product_item_ids", "start_date", "end_date", "locale", "render_type", "creative"};
        public static final String[] FIELDS = new String[]{"body", "id"};

        @Override
        public APINodeList<AdPreview> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdPreview> parseResponse(String response) throws APIException {
            return AdPreview.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdPreview> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdPreview> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdPreview>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdPreview>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdPreview>>(){

                public APINodeList<AdPreview> apply(String result) {
                    try {
                        return APIRequestGetGeneratePreviews.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetGeneratePreviews(String nodeId, APIContext context) {
            super(context, nodeId, "/generatepreviews", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetGeneratePreviews setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetGeneratePreviews setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetGeneratePreviews setAdFormat(AdPreview.EnumAdFormat adFormat) {
            this.setParam("ad_format", (Object)adFormat);
            return this;
        }

        public APIRequestGetGeneratePreviews setAdFormat(String adFormat) {
            this.setParam("ad_format", adFormat);
            return this;
        }

        public APIRequestGetGeneratePreviews setDynamicCreativeSpec(Object dynamicCreativeSpec) {
            this.setParam("dynamic_creative_spec", dynamicCreativeSpec);
            return this;
        }

        public APIRequestGetGeneratePreviews setDynamicCreativeSpec(String dynamicCreativeSpec) {
            this.setParam("dynamic_creative_spec", dynamicCreativeSpec);
            return this;
        }

        public APIRequestGetGeneratePreviews setInteractive(Boolean interactive) {
            this.setParam("interactive", interactive);
            return this;
        }

        public APIRequestGetGeneratePreviews setInteractive(String interactive) {
            this.setParam("interactive", interactive);
            return this;
        }

        public APIRequestGetGeneratePreviews setPost(Object post) {
            this.setParam("post", post);
            return this;
        }

        public APIRequestGetGeneratePreviews setPost(String post) {
            this.setParam("post", post);
            return this;
        }

        public APIRequestGetGeneratePreviews setHeight(Long height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestGetGeneratePreviews setHeight(String height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestGetGeneratePreviews setWidth(Long width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestGetGeneratePreviews setWidth(String width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestGetGeneratePreviews setPlacePageId(Long placePageId) {
            this.setParam("place_page_id", placePageId);
            return this;
        }

        public APIRequestGetGeneratePreviews setPlacePageId(String placePageId) {
            this.setParam("place_page_id", placePageId);
            return this;
        }

        public APIRequestGetGeneratePreviews setProductItemIds(List<String> productItemIds) {
            this.setParam("product_item_ids", productItemIds);
            return this;
        }

        public APIRequestGetGeneratePreviews setProductItemIds(String productItemIds) {
            this.setParam("product_item_ids", productItemIds);
            return this;
        }

        public APIRequestGetGeneratePreviews setStartDate(String startDate) {
            this.setParam("start_date", startDate);
            return this;
        }

        public APIRequestGetGeneratePreviews setEndDate(String endDate) {
            this.setParam("end_date", endDate);
            return this;
        }

        public APIRequestGetGeneratePreviews setLocale(String locale) {
            this.setParam("locale", locale);
            return this;
        }

        public APIRequestGetGeneratePreviews setRenderType(AdPreview.EnumRenderType renderType) {
            this.setParam("render_type", (Object)renderType);
            return this;
        }

        public APIRequestGetGeneratePreviews setRenderType(String renderType) {
            this.setParam("render_type", renderType);
            return this;
        }

        public APIRequestGetGeneratePreviews setCreative(AdCreative creative) {
            this.setParam("creative", creative);
            return this;
        }

        public APIRequestGetGeneratePreviews setCreative(String creative) {
            this.setParam("creative", creative);
            return this;
        }

        public APIRequestGetGeneratePreviews requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetGeneratePreviews requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetGeneratePreviews requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetGeneratePreviews requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetGeneratePreviews requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetGeneratePreviews requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetGeneratePreviews requestBodyField() {
            return this.requestBodyField(true);
        }

        public APIRequestGetGeneratePreviews requestBodyField(boolean value) {
            this.requestField("body", value);
            return this;
        }

        public APIRequestGetGeneratePreviews requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetGeneratePreviews requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateEmailImport
    extends APIRequest<EmailImport> {
        EmailImport lastResponse = null;
        public static final String[] PARAMS = new String[]{"name", "third_party_data"};
        public static final String[] FIELDS = new String[0];

        @Override
        public EmailImport getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public EmailImport parseResponse(String response) throws APIException {
            return EmailImport.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public EmailImport execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public EmailImport execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<EmailImport> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<EmailImport> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, EmailImport>(){

                public EmailImport apply(String result) {
                    try {
                        return APIRequestCreateEmailImport.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateEmailImport(String nodeId, APIContext context) {
            super(context, nodeId, "/emailimport", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateEmailImport setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateEmailImport setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateEmailImport setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateEmailImport setThirdPartyData(String thirdPartyData) {
            this.setParam("third_party_data", thirdPartyData);
            return this;
        }

        public APIRequestCreateEmailImport requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateEmailImport requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateEmailImport requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateEmailImport requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateEmailImport requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateEmailImport requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateDirectDealsTo
    extends APIRequest<AdAccount> {
        AdAccount lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public AdAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccount parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccount execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccount>(){

                public AdAccount apply(String result) {
                    try {
                        return APIRequestCreateDirectDealsTo.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateDirectDealsTo(String nodeId, APIContext context) {
            super(context, nodeId, "/direct_deals_tos", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateDirectDealsTo setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateDirectDealsTo setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateDirectDealsTo requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateDirectDealsTo requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateDirectDealsTo requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateDirectDealsTo requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateDirectDealsTo requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateDirectDealsTo requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetDirectDeals
    extends APIRequest<DirectDeal> {
        APINodeList<DirectDeal> lastResponse = null;
        public static final String[] PARAMS = new String[]{"status"};
        public static final String[] FIELDS = new String[]{"adbreaks_enabled", "adset", "advertiser", "advertiser_lead_email", "advertiser_page", "cpe_amount", "cpe_currency", "end_time", "id", "lifetime_budget_amount", "lifetime_budget_currency", "lifetime_impressions", "name", "pages", "placements", "priced_by", "publisher_name", "review_requirement", "sales_lead_email", "start_time", "status", "targeting", "third_party_ids", "third_party_integrated_deal"};

        @Override
        public APINodeList<DirectDeal> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<DirectDeal> parseResponse(String response) throws APIException {
            return DirectDeal.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<DirectDeal> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<DirectDeal> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<DirectDeal>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<DirectDeal>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<DirectDeal>>(){

                public APINodeList<DirectDeal> apply(String result) {
                    try {
                        return APIRequestGetDirectDeals.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetDirectDeals(String nodeId, APIContext context) {
            super(context, nodeId, "/direct_deals", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetDirectDeals setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetDirectDeals setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetDirectDeals setStatus(DirectDeal.EnumStatus status) {
            this.setParam("status", (Object)status);
            return this;
        }

        public APIRequestGetDirectDeals setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestGetDirectDeals requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetDirectDeals requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDirectDeals requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetDirectDeals requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDirectDeals requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetDirectDeals requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetDirectDeals requestAdbreaksEnabledField() {
            return this.requestAdbreaksEnabledField(true);
        }

        public APIRequestGetDirectDeals requestAdbreaksEnabledField(boolean value) {
            this.requestField("adbreaks_enabled", value);
            return this;
        }

        public APIRequestGetDirectDeals requestAdsetField() {
            return this.requestAdsetField(true);
        }

        public APIRequestGetDirectDeals requestAdsetField(boolean value) {
            this.requestField("adset", value);
            return this;
        }

        public APIRequestGetDirectDeals requestAdvertiserField() {
            return this.requestAdvertiserField(true);
        }

        public APIRequestGetDirectDeals requestAdvertiserField(boolean value) {
            this.requestField("advertiser", value);
            return this;
        }

        public APIRequestGetDirectDeals requestAdvertiserLeadEmailField() {
            return this.requestAdvertiserLeadEmailField(true);
        }

        public APIRequestGetDirectDeals requestAdvertiserLeadEmailField(boolean value) {
            this.requestField("advertiser_lead_email", value);
            return this;
        }

        public APIRequestGetDirectDeals requestAdvertiserPageField() {
            return this.requestAdvertiserPageField(true);
        }

        public APIRequestGetDirectDeals requestAdvertiserPageField(boolean value) {
            this.requestField("advertiser_page", value);
            return this;
        }

        public APIRequestGetDirectDeals requestCpeAmountField() {
            return this.requestCpeAmountField(true);
        }

        public APIRequestGetDirectDeals requestCpeAmountField(boolean value) {
            this.requestField("cpe_amount", value);
            return this;
        }

        public APIRequestGetDirectDeals requestCpeCurrencyField() {
            return this.requestCpeCurrencyField(true);
        }

        public APIRequestGetDirectDeals requestCpeCurrencyField(boolean value) {
            this.requestField("cpe_currency", value);
            return this;
        }

        public APIRequestGetDirectDeals requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGetDirectDeals requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGetDirectDeals requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetDirectDeals requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetDirectDeals requestLifetimeBudgetAmountField() {
            return this.requestLifetimeBudgetAmountField(true);
        }

        public APIRequestGetDirectDeals requestLifetimeBudgetAmountField(boolean value) {
            this.requestField("lifetime_budget_amount", value);
            return this;
        }

        public APIRequestGetDirectDeals requestLifetimeBudgetCurrencyField() {
            return this.requestLifetimeBudgetCurrencyField(true);
        }

        public APIRequestGetDirectDeals requestLifetimeBudgetCurrencyField(boolean value) {
            this.requestField("lifetime_budget_currency", value);
            return this;
        }

        public APIRequestGetDirectDeals requestLifetimeImpressionsField() {
            return this.requestLifetimeImpressionsField(true);
        }

        public APIRequestGetDirectDeals requestLifetimeImpressionsField(boolean value) {
            this.requestField("lifetime_impressions", value);
            return this;
        }

        public APIRequestGetDirectDeals requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetDirectDeals requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetDirectDeals requestPagesField() {
            return this.requestPagesField(true);
        }

        public APIRequestGetDirectDeals requestPagesField(boolean value) {
            this.requestField("pages", value);
            return this;
        }

        public APIRequestGetDirectDeals requestPlacementsField() {
            return this.requestPlacementsField(true);
        }

        public APIRequestGetDirectDeals requestPlacementsField(boolean value) {
            this.requestField("placements", value);
            return this;
        }

        public APIRequestGetDirectDeals requestPricedByField() {
            return this.requestPricedByField(true);
        }

        public APIRequestGetDirectDeals requestPricedByField(boolean value) {
            this.requestField("priced_by", value);
            return this;
        }

        public APIRequestGetDirectDeals requestPublisherNameField() {
            return this.requestPublisherNameField(true);
        }

        public APIRequestGetDirectDeals requestPublisherNameField(boolean value) {
            this.requestField("publisher_name", value);
            return this;
        }

        public APIRequestGetDirectDeals requestReviewRequirementField() {
            return this.requestReviewRequirementField(true);
        }

        public APIRequestGetDirectDeals requestReviewRequirementField(boolean value) {
            this.requestField("review_requirement", value);
            return this;
        }

        public APIRequestGetDirectDeals requestSalesLeadEmailField() {
            return this.requestSalesLeadEmailField(true);
        }

        public APIRequestGetDirectDeals requestSalesLeadEmailField(boolean value) {
            this.requestField("sales_lead_email", value);
            return this;
        }

        public APIRequestGetDirectDeals requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetDirectDeals requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetDirectDeals requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetDirectDeals requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetDirectDeals requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGetDirectDeals requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGetDirectDeals requestThirdPartyIdsField() {
            return this.requestThirdPartyIdsField(true);
        }

        public APIRequestGetDirectDeals requestThirdPartyIdsField(boolean value) {
            this.requestField("third_party_ids", value);
            return this;
        }

        public APIRequestGetDirectDeals requestThirdPartyIntegratedDealField() {
            return this.requestThirdPartyIntegratedDealField(true);
        }

        public APIRequestGetDirectDeals requestThirdPartyIntegratedDealField(boolean value) {
            this.requestField("third_party_integrated_deal", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetDeprecatedTargetingAdSets
    extends APIRequest<AdSet> {
        APINodeList<AdSet> lastResponse = null;
        public static final String[] PARAMS = new String[]{"type"};
        public static final String[] FIELDS = new String[]{"account_id", "ad_keywords", "adasset_feed", "adlabels", "adset_schedule", "asset_feed_id", "attribution_spec", "best_creative", "bid_adjustments", "bid_amount", "bid_constraints", "bid_info", "bid_strategy", "billing_event", "budget_remaining", "campaign", "campaign_id", "configured_status", "created_time", "creative_sequence", "daily_budget", "daily_min_spend_target", "daily_spend_cap", "destination_type", "effective_status", "end_time", "frequency_cap", "frequency_cap_reset_period", "frequency_control_specs", "full_funnel_exploration_mode", "id", "instagram_actor_id", "is_autobid", "is_average_price_pacing", "is_dynamic_creative", "is_dynamic_creative_optimization", "issues_info", "lifetime_budget", "lifetime_frequency_cap", "lifetime_imps", "lifetime_min_spend_target", "lifetime_spend_cap", "name", "optimization_goal", "pacing_type", "promoted_object", "recommendations", "recurring_budget_semantics", "review_feedback", "rf_prediction_id", "rtb_flag", "source_adset", "source_adset_id", "start_time", "status", "targeting", "time_based_ad_rotation_id_blocks", "time_based_ad_rotation_intervals", "tracking_specs", "updated_time", "use_new_app_click"};

        @Override
        public APINodeList<AdSet> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdSet> parseResponse(String response) throws APIException {
            return AdSet.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdSet> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdSet> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdSet>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdSet>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdSet>>(){

                public APINodeList<AdSet> apply(String result) {
                    try {
                        return APIRequestGetDeprecatedTargetingAdSets.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetDeprecatedTargetingAdSets(String nodeId, APIContext context) {
            super(context, nodeId, "/deprecatedtargetingadsets", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetDeprecatedTargetingAdSets setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetDeprecatedTargetingAdSets setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDeprecatedTargetingAdSets requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetDeprecatedTargetingAdSets requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDeprecatedTargetingAdSets requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetDeprecatedTargetingAdSets requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestAdKeywordsField() {
            return this.requestAdKeywordsField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestAdKeywordsField(boolean value) {
            this.requestField("ad_keywords", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestAdassetFeedField() {
            return this.requestAdassetFeedField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestAdassetFeedField(boolean value) {
            this.requestField("adasset_feed", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestAdsetScheduleField() {
            return this.requestAdsetScheduleField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestAdsetScheduleField(boolean value) {
            this.requestField("adset_schedule", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestAssetFeedIdField() {
            return this.requestAssetFeedIdField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestAssetFeedIdField(boolean value) {
            this.requestField("asset_feed_id", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestBestCreativeField() {
            return this.requestBestCreativeField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestBestCreativeField(boolean value) {
            this.requestField("best_creative", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestBidAdjustmentsField() {
            return this.requestBidAdjustmentsField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestBidAdjustmentsField(boolean value) {
            this.requestField("bid_adjustments", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestBidAmountField() {
            return this.requestBidAmountField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestBidAmountField(boolean value) {
            this.requestField("bid_amount", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestBidConstraintsField() {
            return this.requestBidConstraintsField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestBidConstraintsField(boolean value) {
            this.requestField("bid_constraints", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestBidInfoField() {
            return this.requestBidInfoField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestBidInfoField(boolean value) {
            this.requestField("bid_info", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestBidStrategyField() {
            return this.requestBidStrategyField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestBidStrategyField(boolean value) {
            this.requestField("bid_strategy", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestBillingEventField() {
            return this.requestBillingEventField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestBillingEventField(boolean value) {
            this.requestField("billing_event", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestBudgetRemainingField() {
            return this.requestBudgetRemainingField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestBudgetRemainingField(boolean value) {
            this.requestField("budget_remaining", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestCampaignField() {
            return this.requestCampaignField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestCampaignField(boolean value) {
            this.requestField("campaign", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestConfiguredStatusField() {
            return this.requestConfiguredStatusField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestConfiguredStatusField(boolean value) {
            this.requestField("configured_status", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestCreativeSequenceField() {
            return this.requestCreativeSequenceField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestCreativeSequenceField(boolean value) {
            this.requestField("creative_sequence", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestDailyBudgetField() {
            return this.requestDailyBudgetField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestDailyBudgetField(boolean value) {
            this.requestField("daily_budget", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestDailyMinSpendTargetField() {
            return this.requestDailyMinSpendTargetField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestDailyMinSpendTargetField(boolean value) {
            this.requestField("daily_min_spend_target", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestDailySpendCapField() {
            return this.requestDailySpendCapField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestDailySpendCapField(boolean value) {
            this.requestField("daily_spend_cap", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestDestinationTypeField() {
            return this.requestDestinationTypeField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestDestinationTypeField(boolean value) {
            this.requestField("destination_type", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestEffectiveStatusField() {
            return this.requestEffectiveStatusField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestEffectiveStatusField(boolean value) {
            this.requestField("effective_status", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestFrequencyCapField() {
            return this.requestFrequencyCapField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestFrequencyCapField(boolean value) {
            this.requestField("frequency_cap", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestFrequencyCapResetPeriodField() {
            return this.requestFrequencyCapResetPeriodField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestFrequencyCapResetPeriodField(boolean value) {
            this.requestField("frequency_cap_reset_period", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestFrequencyControlSpecsField() {
            return this.requestFrequencyControlSpecsField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestFrequencyControlSpecsField(boolean value) {
            this.requestField("frequency_control_specs", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestFullFunnelExplorationModeField() {
            return this.requestFullFunnelExplorationModeField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestFullFunnelExplorationModeField(boolean value) {
            this.requestField("full_funnel_exploration_mode", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestInstagramActorIdField() {
            return this.requestInstagramActorIdField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestInstagramActorIdField(boolean value) {
            this.requestField("instagram_actor_id", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestIsAutobidField() {
            return this.requestIsAutobidField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestIsAutobidField(boolean value) {
            this.requestField("is_autobid", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestIsAveragePricePacingField() {
            return this.requestIsAveragePricePacingField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestIsAveragePricePacingField(boolean value) {
            this.requestField("is_average_price_pacing", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestIsDynamicCreativeField() {
            return this.requestIsDynamicCreativeField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestIsDynamicCreativeField(boolean value) {
            this.requestField("is_dynamic_creative", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestIsDynamicCreativeOptimizationField() {
            return this.requestIsDynamicCreativeOptimizationField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestIsDynamicCreativeOptimizationField(boolean value) {
            this.requestField("is_dynamic_creative_optimization", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestIssuesInfoField() {
            return this.requestIssuesInfoField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestIssuesInfoField(boolean value) {
            this.requestField("issues_info", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestLifetimeBudgetField() {
            return this.requestLifetimeBudgetField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestLifetimeBudgetField(boolean value) {
            this.requestField("lifetime_budget", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestLifetimeFrequencyCapField() {
            return this.requestLifetimeFrequencyCapField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestLifetimeFrequencyCapField(boolean value) {
            this.requestField("lifetime_frequency_cap", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestLifetimeImpsField() {
            return this.requestLifetimeImpsField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestLifetimeImpsField(boolean value) {
            this.requestField("lifetime_imps", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestLifetimeMinSpendTargetField() {
            return this.requestLifetimeMinSpendTargetField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestLifetimeMinSpendTargetField(boolean value) {
            this.requestField("lifetime_min_spend_target", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestLifetimeSpendCapField() {
            return this.requestLifetimeSpendCapField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestLifetimeSpendCapField(boolean value) {
            this.requestField("lifetime_spend_cap", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestOptimizationGoalField() {
            return this.requestOptimizationGoalField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestOptimizationGoalField(boolean value) {
            this.requestField("optimization_goal", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestPacingTypeField() {
            return this.requestPacingTypeField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestPacingTypeField(boolean value) {
            this.requestField("pacing_type", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestPromotedObjectField() {
            return this.requestPromotedObjectField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestPromotedObjectField(boolean value) {
            this.requestField("promoted_object", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestRecommendationsField() {
            return this.requestRecommendationsField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestRecommendationsField(boolean value) {
            this.requestField("recommendations", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestRecurringBudgetSemanticsField() {
            return this.requestRecurringBudgetSemanticsField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestRecurringBudgetSemanticsField(boolean value) {
            this.requestField("recurring_budget_semantics", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestReviewFeedbackField() {
            return this.requestReviewFeedbackField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestReviewFeedbackField(boolean value) {
            this.requestField("review_feedback", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestRfPredictionIdField() {
            return this.requestRfPredictionIdField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestRfPredictionIdField(boolean value) {
            this.requestField("rf_prediction_id", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestRtbFlagField() {
            return this.requestRtbFlagField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestRtbFlagField(boolean value) {
            this.requestField("rtb_flag", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestSourceAdsetField() {
            return this.requestSourceAdsetField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestSourceAdsetField(boolean value) {
            this.requestField("source_adset", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestSourceAdsetIdField() {
            return this.requestSourceAdsetIdField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestSourceAdsetIdField(boolean value) {
            this.requestField("source_adset_id", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestTimeBasedAdRotationIdBlocksField() {
            return this.requestTimeBasedAdRotationIdBlocksField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestTimeBasedAdRotationIdBlocksField(boolean value) {
            this.requestField("time_based_ad_rotation_id_blocks", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestTimeBasedAdRotationIntervalsField() {
            return this.requestTimeBasedAdRotationIntervalsField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestTimeBasedAdRotationIntervalsField(boolean value) {
            this.requestField("time_based_ad_rotation_intervals", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestTrackingSpecsField() {
            return this.requestTrackingSpecsField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestTrackingSpecsField(boolean value) {
            this.requestField("tracking_specs", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetDeprecatedTargetingAdSets requestUseNewAppClickField() {
            return this.requestUseNewAppClickField(true);
        }

        public APIRequestGetDeprecatedTargetingAdSets requestUseNewAppClickField(boolean value) {
            this.requestField("use_new_app_click", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetDeliveryEstimate
    extends APIRequest<AdAccountDeliveryEstimate> {
        APINodeList<AdAccountDeliveryEstimate> lastResponse = null;
        public static final String[] PARAMS = new String[]{"targeting_spec", "optimization_goal", "promoted_object"};
        public static final String[] FIELDS = new String[]{"bid_estimate", "daily_outcomes_curve", "estimate_dau", "estimate_mau", "estimate_ready", "id"};

        @Override
        public APINodeList<AdAccountDeliveryEstimate> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccountDeliveryEstimate> parseResponse(String response) throws APIException {
            return AdAccountDeliveryEstimate.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccountDeliveryEstimate> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccountDeliveryEstimate> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccountDeliveryEstimate>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccountDeliveryEstimate>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAccountDeliveryEstimate>>(){

                public APINodeList<AdAccountDeliveryEstimate> apply(String result) {
                    try {
                        return APIRequestGetDeliveryEstimate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetDeliveryEstimate(String nodeId, APIContext context) {
            super(context, nodeId, "/delivery_estimate", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetDeliveryEstimate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetDeliveryEstimate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetDeliveryEstimate setTargetingSpec(Targeting targetingSpec) {
            this.setParam("targeting_spec", targetingSpec);
            return this;
        }

        public APIRequestGetDeliveryEstimate setTargetingSpec(String targetingSpec) {
            this.setParam("targeting_spec", targetingSpec);
            return this;
        }

        public APIRequestGetDeliveryEstimate setOptimizationGoal(AdAccountDeliveryEstimate.EnumOptimizationGoal optimizationGoal) {
            this.setParam("optimization_goal", (Object)optimizationGoal);
            return this;
        }

        public APIRequestGetDeliveryEstimate setOptimizationGoal(String optimizationGoal) {
            this.setParam("optimization_goal", optimizationGoal);
            return this;
        }

        public APIRequestGetDeliveryEstimate setPromotedObject(Object promotedObject) {
            this.setParam("promoted_object", promotedObject);
            return this;
        }

        public APIRequestGetDeliveryEstimate setPromotedObject(String promotedObject) {
            this.setParam("promoted_object", promotedObject);
            return this;
        }

        public APIRequestGetDeliveryEstimate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetDeliveryEstimate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDeliveryEstimate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetDeliveryEstimate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDeliveryEstimate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetDeliveryEstimate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetDeliveryEstimate requestBidEstimateField() {
            return this.requestBidEstimateField(true);
        }

        public APIRequestGetDeliveryEstimate requestBidEstimateField(boolean value) {
            this.requestField("bid_estimate", value);
            return this;
        }

        public APIRequestGetDeliveryEstimate requestDailyOutcomesCurveField() {
            return this.requestDailyOutcomesCurveField(true);
        }

        public APIRequestGetDeliveryEstimate requestDailyOutcomesCurveField(boolean value) {
            this.requestField("daily_outcomes_curve", value);
            return this;
        }

        public APIRequestGetDeliveryEstimate requestEstimateDauField() {
            return this.requestEstimateDauField(true);
        }

        public APIRequestGetDeliveryEstimate requestEstimateDauField(boolean value) {
            this.requestField("estimate_dau", value);
            return this;
        }

        public APIRequestGetDeliveryEstimate requestEstimateMauField() {
            return this.requestEstimateMauField(true);
        }

        public APIRequestGetDeliveryEstimate requestEstimateMauField(boolean value) {
            this.requestField("estimate_mau", value);
            return this;
        }

        public APIRequestGetDeliveryEstimate requestEstimateReadyField() {
            return this.requestEstimateReadyField(true);
        }

        public APIRequestGetDeliveryEstimate requestEstimateReadyField(boolean value) {
            this.requestField("estimate_ready", value);
            return this;
        }

        public APIRequestGetDeliveryEstimate requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetDeliveryEstimate requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateDeactivate
    extends APIRequest<AdAccount> {
        AdAccount lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public AdAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccount parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccount execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccount>(){

                public AdAccount apply(String result) {
                    try {
                        return APIRequestCreateDeactivate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateDeactivate(String nodeId, APIContext context) {
            super(context, nodeId, "/deactivate", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateDeactivate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateDeactivate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateDeactivate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateDeactivate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateDeactivate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateDeactivate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateDeactivate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateDeactivate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateCustomConversion
    extends APIRequest<CustomConversion> {
        CustomConversion lastResponse = null;
        public static final String[] PARAMS = new String[]{"name", "description", "event_source_id", "rule", "default_conversion_value", "custom_event_type", "advanced_rule"};
        public static final String[] FIELDS = new String[0];

        @Override
        public CustomConversion getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CustomConversion parseResponse(String response) throws APIException {
            return CustomConversion.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public CustomConversion execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CustomConversion execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<CustomConversion> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CustomConversion> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CustomConversion>(){

                public CustomConversion apply(String result) {
                    try {
                        return APIRequestCreateCustomConversion.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateCustomConversion(String nodeId, APIContext context) {
            super(context, nodeId, "/customconversions", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateCustomConversion setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateCustomConversion setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateCustomConversion setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateCustomConversion setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateCustomConversion setEventSourceId(String eventSourceId) {
            this.setParam("event_source_id", eventSourceId);
            return this;
        }

        public APIRequestCreateCustomConversion setRule(String rule) {
            this.setParam("rule", rule);
            return this;
        }

        public APIRequestCreateCustomConversion setDefaultConversionValue(Double defaultConversionValue) {
            this.setParam("default_conversion_value", defaultConversionValue);
            return this;
        }

        public APIRequestCreateCustomConversion setDefaultConversionValue(String defaultConversionValue) {
            this.setParam("default_conversion_value", defaultConversionValue);
            return this;
        }

        public APIRequestCreateCustomConversion setCustomEventType(CustomConversion.EnumCustomEventType customEventType) {
            this.setParam("custom_event_type", (Object)customEventType);
            return this;
        }

        public APIRequestCreateCustomConversion setCustomEventType(String customEventType) {
            this.setParam("custom_event_type", customEventType);
            return this;
        }

        public APIRequestCreateCustomConversion setAdvancedRule(String advancedRule) {
            this.setParam("advanced_rule", advancedRule);
            return this;
        }

        public APIRequestCreateCustomConversion requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateCustomConversion requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCustomConversion requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateCustomConversion requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCustomConversion requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateCustomConversion requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetCustomConversions
    extends APIRequest<CustomConversion> {
        APINodeList<CustomConversion> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "aggregation_rule", "business", "creation_time", "custom_event_type", "data_sources", "default_conversion_value", "description", "event_source_type", "first_fired_time", "id", "is_archived", "last_fired_time", "name", "offline_conversion_data_set", "pixel", "retention_days", "rule"};

        @Override
        public APINodeList<CustomConversion> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CustomConversion> parseResponse(String response) throws APIException {
            return CustomConversion.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<CustomConversion> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CustomConversion> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CustomConversion>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CustomConversion>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<CustomConversion>>(){

                public APINodeList<CustomConversion> apply(String result) {
                    try {
                        return APIRequestGetCustomConversions.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetCustomConversions(String nodeId, APIContext context) {
            super(context, nodeId, "/customconversions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCustomConversions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCustomConversions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCustomConversions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCustomConversions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCustomConversions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCustomConversions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCustomConversions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCustomConversions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetCustomConversions requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetCustomConversions requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetCustomConversions requestAggregationRuleField() {
            return this.requestAggregationRuleField(true);
        }

        public APIRequestGetCustomConversions requestAggregationRuleField(boolean value) {
            this.requestField("aggregation_rule", value);
            return this;
        }

        public APIRequestGetCustomConversions requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetCustomConversions requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetCustomConversions requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGetCustomConversions requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGetCustomConversions requestCustomEventTypeField() {
            return this.requestCustomEventTypeField(true);
        }

        public APIRequestGetCustomConversions requestCustomEventTypeField(boolean value) {
            this.requestField("custom_event_type", value);
            return this;
        }

        public APIRequestGetCustomConversions requestDataSourcesField() {
            return this.requestDataSourcesField(true);
        }

        public APIRequestGetCustomConversions requestDataSourcesField(boolean value) {
            this.requestField("data_sources", value);
            return this;
        }

        public APIRequestGetCustomConversions requestDefaultConversionValueField() {
            return this.requestDefaultConversionValueField(true);
        }

        public APIRequestGetCustomConversions requestDefaultConversionValueField(boolean value) {
            this.requestField("default_conversion_value", value);
            return this;
        }

        public APIRequestGetCustomConversions requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetCustomConversions requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetCustomConversions requestEventSourceTypeField() {
            return this.requestEventSourceTypeField(true);
        }

        public APIRequestGetCustomConversions requestEventSourceTypeField(boolean value) {
            this.requestField("event_source_type", value);
            return this;
        }

        public APIRequestGetCustomConversions requestFirstFiredTimeField() {
            return this.requestFirstFiredTimeField(true);
        }

        public APIRequestGetCustomConversions requestFirstFiredTimeField(boolean value) {
            this.requestField("first_fired_time", value);
            return this;
        }

        public APIRequestGetCustomConversions requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetCustomConversions requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetCustomConversions requestIsArchivedField() {
            return this.requestIsArchivedField(true);
        }

        public APIRequestGetCustomConversions requestIsArchivedField(boolean value) {
            this.requestField("is_archived", value);
            return this;
        }

        public APIRequestGetCustomConversions requestLastFiredTimeField() {
            return this.requestLastFiredTimeField(true);
        }

        public APIRequestGetCustomConversions requestLastFiredTimeField(boolean value) {
            this.requestField("last_fired_time", value);
            return this;
        }

        public APIRequestGetCustomConversions requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetCustomConversions requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetCustomConversions requestOfflineConversionDataSetField() {
            return this.requestOfflineConversionDataSetField(true);
        }

        public APIRequestGetCustomConversions requestOfflineConversionDataSetField(boolean value) {
            this.requestField("offline_conversion_data_set", value);
            return this;
        }

        public APIRequestGetCustomConversions requestPixelField() {
            return this.requestPixelField(true);
        }

        public APIRequestGetCustomConversions requestPixelField(boolean value) {
            this.requestField("pixel", value);
            return this;
        }

        public APIRequestGetCustomConversions requestRetentionDaysField() {
            return this.requestRetentionDaysField(true);
        }

        public APIRequestGetCustomConversions requestRetentionDaysField(boolean value) {
            this.requestField("retention_days", value);
            return this;
        }

        public APIRequestGetCustomConversions requestRuleField() {
            return this.requestRuleField(true);
        }

        public APIRequestGetCustomConversions requestRuleField(boolean value) {
            this.requestField("rule", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetCustomAudiencesTos
    extends APIRequest<CustomAudiencesTOS> {
        APINodeList<CustomAudiencesTOS> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"content", "id", "type"};

        @Override
        public APINodeList<CustomAudiencesTOS> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CustomAudiencesTOS> parseResponse(String response) throws APIException {
            return CustomAudiencesTOS.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<CustomAudiencesTOS> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CustomAudiencesTOS> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CustomAudiencesTOS>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CustomAudiencesTOS>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<CustomAudiencesTOS>>(){

                public APINodeList<CustomAudiencesTOS> apply(String result) {
                    try {
                        return APIRequestGetCustomAudiencesTos.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetCustomAudiencesTos(String nodeId, APIContext context) {
            super(context, nodeId, "/customaudiencestos", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCustomAudiencesTos setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCustomAudiencesTos setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCustomAudiencesTos requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCustomAudiencesTos requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCustomAudiencesTos requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCustomAudiencesTos requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCustomAudiencesTos requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCustomAudiencesTos requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetCustomAudiencesTos requestContentField() {
            return this.requestContentField(true);
        }

        public APIRequestGetCustomAudiencesTos requestContentField(boolean value) {
            this.requestField("content", value);
            return this;
        }

        public APIRequestGetCustomAudiencesTos requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetCustomAudiencesTos requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetCustomAudiencesTos requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetCustomAudiencesTos requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateCustomAudience
    extends APIRequest<CustomAudience> {
        CustomAudience lastResponse = null;
        public static final String[] PARAMS = new String[]{"creation_params", "description", "name", "opt_out_link", "parent_audience_id", "subtype", "seed_audience", "tags", "associated_audience_id", "is_household", "is_household_exclusion", "is_value_based", "allowed_domains", "is_snapshot", "lookalike_spec", "retention_days", "customer_file_source", "rev_share_policy_id", "partner_reference_key", "rule", "prefill", "pixel_id", "rule_aggregation", "inclusions", "exclusions", "countries", "origin_audience_id", "details", "source", "isPrivate", "additionalMetadata", "minAge", "maxAge", "expectedSize", "gender", "partnerID", "accountID", "claim_objective", "content_type", "event_source_group", "product_set_id", "event_sources", "video_group_ids", "study_spec", "list_of_accounts", "dataset_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public CustomAudience getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CustomAudience parseResponse(String response) throws APIException {
            return CustomAudience.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public CustomAudience execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CustomAudience execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<CustomAudience> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CustomAudience> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CustomAudience>(){

                public CustomAudience apply(String result) {
                    try {
                        return APIRequestCreateCustomAudience.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateCustomAudience(String nodeId, APIContext context) {
            super(context, nodeId, "/customaudiences", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateCustomAudience setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateCustomAudience setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateCustomAudience setCreationParams(Map<String, String> creationParams) {
            this.setParam("creation_params", creationParams);
            return this;
        }

        public APIRequestCreateCustomAudience setCreationParams(String creationParams) {
            this.setParam("creation_params", creationParams);
            return this;
        }

        public APIRequestCreateCustomAudience setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateCustomAudience setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateCustomAudience setOptOutLink(String optOutLink) {
            this.setParam("opt_out_link", optOutLink);
            return this;
        }

        public APIRequestCreateCustomAudience setParentAudienceId(Long parentAudienceId) {
            this.setParam("parent_audience_id", parentAudienceId);
            return this;
        }

        public APIRequestCreateCustomAudience setParentAudienceId(String parentAudienceId) {
            this.setParam("parent_audience_id", parentAudienceId);
            return this;
        }

        public APIRequestCreateCustomAudience setSubtype(CustomAudience.EnumSubtype subtype) {
            this.setParam("subtype", (Object)subtype);
            return this;
        }

        public APIRequestCreateCustomAudience setSubtype(String subtype) {
            this.setParam("subtype", subtype);
            return this;
        }

        public APIRequestCreateCustomAudience setSeedAudience(Long seedAudience) {
            this.setParam("seed_audience", seedAudience);
            return this;
        }

        public APIRequestCreateCustomAudience setSeedAudience(String seedAudience) {
            this.setParam("seed_audience", seedAudience);
            return this;
        }

        public APIRequestCreateCustomAudience setTags(List<String> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateCustomAudience setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateCustomAudience setAssociatedAudienceId(Long associatedAudienceId) {
            this.setParam("associated_audience_id", associatedAudienceId);
            return this;
        }

        public APIRequestCreateCustomAudience setAssociatedAudienceId(String associatedAudienceId) {
            this.setParam("associated_audience_id", associatedAudienceId);
            return this;
        }

        public APIRequestCreateCustomAudience setIsHousehold(Boolean isHousehold) {
            this.setParam("is_household", isHousehold);
            return this;
        }

        public APIRequestCreateCustomAudience setIsHousehold(String isHousehold) {
            this.setParam("is_household", isHousehold);
            return this;
        }

        public APIRequestCreateCustomAudience setIsHouseholdExclusion(Boolean isHouseholdExclusion) {
            this.setParam("is_household_exclusion", isHouseholdExclusion);
            return this;
        }

        public APIRequestCreateCustomAudience setIsHouseholdExclusion(String isHouseholdExclusion) {
            this.setParam("is_household_exclusion", isHouseholdExclusion);
            return this;
        }

        public APIRequestCreateCustomAudience setIsValueBased(Boolean isValueBased) {
            this.setParam("is_value_based", isValueBased);
            return this;
        }

        public APIRequestCreateCustomAudience setIsValueBased(String isValueBased) {
            this.setParam("is_value_based", isValueBased);
            return this;
        }

        public APIRequestCreateCustomAudience setAllowedDomains(List<String> allowedDomains) {
            this.setParam("allowed_domains", allowedDomains);
            return this;
        }

        public APIRequestCreateCustomAudience setAllowedDomains(String allowedDomains) {
            this.setParam("allowed_domains", allowedDomains);
            return this;
        }

        public APIRequestCreateCustomAudience setIsSnapshot(Boolean isSnapshot) {
            this.setParam("is_snapshot", isSnapshot);
            return this;
        }

        public APIRequestCreateCustomAudience setIsSnapshot(String isSnapshot) {
            this.setParam("is_snapshot", isSnapshot);
            return this;
        }

        public APIRequestCreateCustomAudience setLookalikeSpec(String lookalikeSpec) {
            this.setParam("lookalike_spec", lookalikeSpec);
            return this;
        }

        public APIRequestCreateCustomAudience setRetentionDays(Long retentionDays) {
            this.setParam("retention_days", retentionDays);
            return this;
        }

        public APIRequestCreateCustomAudience setRetentionDays(String retentionDays) {
            this.setParam("retention_days", retentionDays);
            return this;
        }

        public APIRequestCreateCustomAudience setCustomerFileSource(CustomAudience.EnumCustomerFileSource customerFileSource) {
            this.setParam("customer_file_source", (Object)customerFileSource);
            return this;
        }

        public APIRequestCreateCustomAudience setCustomerFileSource(String customerFileSource) {
            this.setParam("customer_file_source", customerFileSource);
            return this;
        }

        public APIRequestCreateCustomAudience setRevSharePolicyId(Long revSharePolicyId) {
            this.setParam("rev_share_policy_id", revSharePolicyId);
            return this;
        }

        public APIRequestCreateCustomAudience setRevSharePolicyId(String revSharePolicyId) {
            this.setParam("rev_share_policy_id", revSharePolicyId);
            return this;
        }

        public APIRequestCreateCustomAudience setPartnerReferenceKey(String partnerReferenceKey) {
            this.setParam("partner_reference_key", partnerReferenceKey);
            return this;
        }

        public APIRequestCreateCustomAudience setRule(String rule) {
            this.setParam("rule", rule);
            return this;
        }

        public APIRequestCreateCustomAudience setPrefill(Boolean prefill) {
            this.setParam("prefill", prefill);
            return this;
        }

        public APIRequestCreateCustomAudience setPrefill(String prefill) {
            this.setParam("prefill", prefill);
            return this;
        }

        public APIRequestCreateCustomAudience setPixelId(String pixelId) {
            this.setParam("pixel_id", pixelId);
            return this;
        }

        public APIRequestCreateCustomAudience setRuleAggregation(String ruleAggregation) {
            this.setParam("rule_aggregation", ruleAggregation);
            return this;
        }

        public APIRequestCreateCustomAudience setInclusions(List<Object> inclusions) {
            this.setParam("inclusions", inclusions);
            return this;
        }

        public APIRequestCreateCustomAudience setInclusions(String inclusions) {
            this.setParam("inclusions", inclusions);
            return this;
        }

        public APIRequestCreateCustomAudience setExclusions(List<Object> exclusions) {
            this.setParam("exclusions", exclusions);
            return this;
        }

        public APIRequestCreateCustomAudience setExclusions(String exclusions) {
            this.setParam("exclusions", exclusions);
            return this;
        }

        public APIRequestCreateCustomAudience setCountries(String countries) {
            this.setParam("countries", countries);
            return this;
        }

        public APIRequestCreateCustomAudience setOriginAudienceId(String originAudienceId) {
            this.setParam("origin_audience_id", originAudienceId);
            return this;
        }

        public APIRequestCreateCustomAudience setDetails(String details) {
            this.setParam("details", details);
            return this;
        }

        public APIRequestCreateCustomAudience setSource(String source) {
            this.setParam("source", source);
            return this;
        }

        public APIRequestCreateCustomAudience setIsprivate(Boolean isprivate) {
            this.setParam("isPrivate", isprivate);
            return this;
        }

        public APIRequestCreateCustomAudience setIsprivate(String isprivate) {
            this.setParam("isPrivate", isprivate);
            return this;
        }

        public APIRequestCreateCustomAudience setAdditionalmetadata(String additionalmetadata) {
            this.setParam("additionalMetadata", additionalmetadata);
            return this;
        }

        public APIRequestCreateCustomAudience setMinage(Long minage) {
            this.setParam("minAge", minage);
            return this;
        }

        public APIRequestCreateCustomAudience setMinage(String minage) {
            this.setParam("minAge", minage);
            return this;
        }

        public APIRequestCreateCustomAudience setMaxage(Long maxage) {
            this.setParam("maxAge", maxage);
            return this;
        }

        public APIRequestCreateCustomAudience setMaxage(String maxage) {
            this.setParam("maxAge", maxage);
            return this;
        }

        public APIRequestCreateCustomAudience setExpectedsize(Long expectedsize) {
            this.setParam("expectedSize", expectedsize);
            return this;
        }

        public APIRequestCreateCustomAudience setExpectedsize(String expectedsize) {
            this.setParam("expectedSize", expectedsize);
            return this;
        }

        public APIRequestCreateCustomAudience setGender(String gender) {
            this.setParam("gender", gender);
            return this;
        }

        public APIRequestCreateCustomAudience setPartnerid(String partnerid) {
            this.setParam("partnerID", partnerid);
            return this;
        }

        public APIRequestCreateCustomAudience setAccountid(String accountid) {
            this.setParam("accountID", accountid);
            return this;
        }

        public APIRequestCreateCustomAudience setClaimObjective(CustomAudience.EnumClaimObjective claimObjective) {
            this.setParam("claim_objective", (Object)claimObjective);
            return this;
        }

        public APIRequestCreateCustomAudience setClaimObjective(String claimObjective) {
            this.setParam("claim_objective", claimObjective);
            return this;
        }

        public APIRequestCreateCustomAudience setContentType(CustomAudience.EnumContentType contentType) {
            this.setParam("content_type", (Object)contentType);
            return this;
        }

        public APIRequestCreateCustomAudience setContentType(String contentType) {
            this.setParam("content_type", contentType);
            return this;
        }

        public APIRequestCreateCustomAudience setEventSourceGroup(String eventSourceGroup) {
            this.setParam("event_source_group", eventSourceGroup);
            return this;
        }

        public APIRequestCreateCustomAudience setProductSetId(String productSetId) {
            this.setParam("product_set_id", productSetId);
            return this;
        }

        public APIRequestCreateCustomAudience setEventSources(List<Map<String, String>> eventSources) {
            this.setParam("event_sources", eventSources);
            return this;
        }

        public APIRequestCreateCustomAudience setEventSources(String eventSources) {
            this.setParam("event_sources", eventSources);
            return this;
        }

        public APIRequestCreateCustomAudience setVideoGroupIds(List<String> videoGroupIds) {
            this.setParam("video_group_ids", videoGroupIds);
            return this;
        }

        public APIRequestCreateCustomAudience setVideoGroupIds(String videoGroupIds) {
            this.setParam("video_group_ids", videoGroupIds);
            return this;
        }

        public APIRequestCreateCustomAudience setStudySpec(Object studySpec) {
            this.setParam("study_spec", studySpec);
            return this;
        }

        public APIRequestCreateCustomAudience setStudySpec(String studySpec) {
            this.setParam("study_spec", studySpec);
            return this;
        }

        public APIRequestCreateCustomAudience setListOfAccounts(List<Long> listOfAccounts) {
            this.setParam("list_of_accounts", listOfAccounts);
            return this;
        }

        public APIRequestCreateCustomAudience setListOfAccounts(String listOfAccounts) {
            this.setParam("list_of_accounts", listOfAccounts);
            return this;
        }

        public APIRequestCreateCustomAudience setDatasetId(String datasetId) {
            this.setParam("dataset_id", datasetId);
            return this;
        }

        public APIRequestCreateCustomAudience requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateCustomAudience requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCustomAudience requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateCustomAudience requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCustomAudience requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateCustomAudience requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetCustomAudiences
    extends APIRequest<CustomAudience> {
        APINodeList<CustomAudience> lastResponse = null;
        public static final String[] PARAMS = new String[]{"pixel_id", "fields", "filtering", "business_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<CustomAudience> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CustomAudience> parseResponse(String response) throws APIException {
            return CustomAudience.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<CustomAudience> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CustomAudience> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CustomAudience>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CustomAudience>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<CustomAudience>>(){

                public APINodeList<CustomAudience> apply(String result) {
                    try {
                        return APIRequestGetCustomAudiences.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetCustomAudiences(String nodeId, APIContext context) {
            super(context, nodeId, "/customaudiences", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCustomAudiences setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCustomAudiences setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCustomAudiences setPixelId(String pixelId) {
            this.setParam("pixel_id", pixelId);
            return this;
        }

        public APIRequestGetCustomAudiences setFields(List<String> fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetCustomAudiences setFields(String fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetCustomAudiences setFiltering(List<Object> filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetCustomAudiences setFiltering(String filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetCustomAudiences setBusinessId(String businessId) {
            this.setParam("business_id", businessId);
            return this;
        }

        public APIRequestGetCustomAudiences requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCustomAudiences requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCustomAudiences requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCustomAudiences requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCustomAudiences requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCustomAudiences requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetCustomAudienceLimits
    extends APIRequest<AdAccountCustomAudienceLimits> {
        APINodeList<AdAccountCustomAudienceLimits> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"audience_update_quota_in_total", "audience_update_quota_left", "has_hit_audience_update_limit", "next_audience_update_available_time", "rate_limit_reset_time", "id"};

        @Override
        public APINodeList<AdAccountCustomAudienceLimits> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccountCustomAudienceLimits> parseResponse(String response) throws APIException {
            return AdAccountCustomAudienceLimits.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccountCustomAudienceLimits> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccountCustomAudienceLimits> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccountCustomAudienceLimits>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccountCustomAudienceLimits>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAccountCustomAudienceLimits>>(){

                public APINodeList<AdAccountCustomAudienceLimits> apply(String result) {
                    try {
                        return APIRequestGetCustomAudienceLimits.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetCustomAudienceLimits(String nodeId, APIContext context) {
            super(context, nodeId, "/custom_audience_limits", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCustomAudienceLimits setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCustomAudienceLimits setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCustomAudienceLimits requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCustomAudienceLimits requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCustomAudienceLimits requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCustomAudienceLimits requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCustomAudienceLimits requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCustomAudienceLimits requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetCustomAudienceLimits requestAudienceUpdateQuotaInTotalField() {
            return this.requestAudienceUpdateQuotaInTotalField(true);
        }

        public APIRequestGetCustomAudienceLimits requestAudienceUpdateQuotaInTotalField(boolean value) {
            this.requestField("audience_update_quota_in_total", value);
            return this;
        }

        public APIRequestGetCustomAudienceLimits requestAudienceUpdateQuotaLeftField() {
            return this.requestAudienceUpdateQuotaLeftField(true);
        }

        public APIRequestGetCustomAudienceLimits requestAudienceUpdateQuotaLeftField(boolean value) {
            this.requestField("audience_update_quota_left", value);
            return this;
        }

        public APIRequestGetCustomAudienceLimits requestHasHitAudienceUpdateLimitField() {
            return this.requestHasHitAudienceUpdateLimitField(true);
        }

        public APIRequestGetCustomAudienceLimits requestHasHitAudienceUpdateLimitField(boolean value) {
            this.requestField("has_hit_audience_update_limit", value);
            return this;
        }

        public APIRequestGetCustomAudienceLimits requestNextAudienceUpdateAvailableTimeField() {
            return this.requestNextAudienceUpdateAvailableTimeField(true);
        }

        public APIRequestGetCustomAudienceLimits requestNextAudienceUpdateAvailableTimeField(boolean value) {
            this.requestField("next_audience_update_available_time", value);
            return this;
        }

        public APIRequestGetCustomAudienceLimits requestRateLimitResetTimeField() {
            return this.requestRateLimitResetTimeField(true);
        }

        public APIRequestGetCustomAudienceLimits requestRateLimitResetTimeField(boolean value) {
            this.requestField("rate_limit_reset_time", value);
            return this;
        }

        public APIRequestGetCustomAudienceLimits requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetCustomAudienceLimits requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateCoupon
    extends APIRequest<AdAccount> {
        AdAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"coupon_code"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccount parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccount execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccount>(){

                public AdAccount apply(String result) {
                    try {
                        return APIRequestCreateCoupon.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateCoupon(String nodeId, APIContext context) {
            super(context, nodeId, "/coupons", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateCoupon setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateCoupon setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateCoupon setCouponCode(String couponCode) {
            this.setParam("coupon_code", couponCode);
            return this;
        }

        public APIRequestCreateCoupon requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateCoupon requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCoupon requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateCoupon requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCoupon requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateCoupon requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetContextualTargetingBrowse
    extends APIRequest<AdAccountContextualTargeting> {
        APINodeList<AdAccountContextualTargeting> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"description", "enabled_in_ui", "id", "key", "name", "parent", "path", "type"};

        @Override
        public APINodeList<AdAccountContextualTargeting> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccountContextualTargeting> parseResponse(String response) throws APIException {
            return AdAccountContextualTargeting.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccountContextualTargeting> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccountContextualTargeting> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccountContextualTargeting>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccountContextualTargeting>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAccountContextualTargeting>>(){

                public APINodeList<AdAccountContextualTargeting> apply(String result) {
                    try {
                        return APIRequestGetContextualTargetingBrowse.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetContextualTargetingBrowse(String nodeId, APIContext context) {
            super(context, nodeId, "/contextual_targeting_browse", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetContextualTargetingBrowse setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetContextualTargetingBrowse setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetContextualTargetingBrowse requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetContextualTargetingBrowse requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetContextualTargetingBrowse requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetContextualTargetingBrowse requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetContextualTargetingBrowse requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetContextualTargetingBrowse requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetContextualTargetingBrowse requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetContextualTargetingBrowse requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetContextualTargetingBrowse requestEnabledInUiField() {
            return this.requestEnabledInUiField(true);
        }

        public APIRequestGetContextualTargetingBrowse requestEnabledInUiField(boolean value) {
            this.requestField("enabled_in_ui", value);
            return this;
        }

        public APIRequestGetContextualTargetingBrowse requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetContextualTargetingBrowse requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetContextualTargetingBrowse requestKeyField() {
            return this.requestKeyField(true);
        }

        public APIRequestGetContextualTargetingBrowse requestKeyField(boolean value) {
            this.requestField("key", value);
            return this;
        }

        public APIRequestGetContextualTargetingBrowse requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetContextualTargetingBrowse requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetContextualTargetingBrowse requestParentField() {
            return this.requestParentField(true);
        }

        public APIRequestGetContextualTargetingBrowse requestParentField(boolean value) {
            this.requestField("parent", value);
            return this;
        }

        public APIRequestGetContextualTargetingBrowse requestPathField() {
            return this.requestPathField(true);
        }

        public APIRequestGetContextualTargetingBrowse requestPathField(boolean value) {
            this.requestField("path", value);
            return this;
        }

        public APIRequestGetContextualTargetingBrowse requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetContextualTargetingBrowse requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetCampaignsByLabels
    extends APIRequest<Campaign> {
        APINodeList<Campaign> lastResponse = null;
        public static final String[] PARAMS = new String[]{"ad_label_ids", "operator"};
        public static final String[] FIELDS = new String[]{"account_id", "adlabels", "bid_strategy", "boosted_object_id", "brand_lift_studies", "budget_rebalance_flag", "budget_remaining", "buying_type", "can_create_brand_lift_study", "can_use_spend_cap", "configured_status", "created_time", "daily_budget", "effective_status", "id", "is_autobid", "is_average_price_pacing", "kpi_custom_conversion_id", "kpi_type", "last_budget_toggling_time", "lifetime_budget", "metrics_metadata", "name", "objective", "pacing_type", "promoted_object", "recommendations", "source_campaign", "source_campaign_id", "spend_cap", "start_time", "status", "stop_time", "topline_id", "updated_time"};

        @Override
        public APINodeList<Campaign> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Campaign> parseResponse(String response) throws APIException {
            return Campaign.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Campaign> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Campaign> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Campaign>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Campaign>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Campaign>>(){

                public APINodeList<Campaign> apply(String result) {
                    try {
                        return APIRequestGetCampaignsByLabels.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetCampaignsByLabels(String nodeId, APIContext context) {
            super(context, nodeId, "/campaignsbylabels", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCampaignsByLabels setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCampaignsByLabels setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCampaignsByLabels setAdLabelIds(List<String> adLabelIds) {
            this.setParam("ad_label_ids", adLabelIds);
            return this;
        }

        public APIRequestGetCampaignsByLabels setAdLabelIds(String adLabelIds) {
            this.setParam("ad_label_ids", adLabelIds);
            return this;
        }

        public APIRequestGetCampaignsByLabels setOperator(Campaign.EnumOperator operator) {
            this.setParam("operator", (Object)operator);
            return this;
        }

        public APIRequestGetCampaignsByLabels setOperator(String operator) {
            this.setParam("operator", operator);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCampaignsByLabels requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCampaignsByLabels requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCampaignsByLabels requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCampaignsByLabels requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCampaignsByLabels requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetCampaignsByLabels requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGetCampaignsByLabels requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestBidStrategyField() {
            return this.requestBidStrategyField(true);
        }

        public APIRequestGetCampaignsByLabels requestBidStrategyField(boolean value) {
            this.requestField("bid_strategy", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestBoostedObjectIdField() {
            return this.requestBoostedObjectIdField(true);
        }

        public APIRequestGetCampaignsByLabels requestBoostedObjectIdField(boolean value) {
            this.requestField("boosted_object_id", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestBrandLiftStudiesField() {
            return this.requestBrandLiftStudiesField(true);
        }

        public APIRequestGetCampaignsByLabels requestBrandLiftStudiesField(boolean value) {
            this.requestField("brand_lift_studies", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestBudgetRebalanceFlagField() {
            return this.requestBudgetRebalanceFlagField(true);
        }

        public APIRequestGetCampaignsByLabels requestBudgetRebalanceFlagField(boolean value) {
            this.requestField("budget_rebalance_flag", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestBudgetRemainingField() {
            return this.requestBudgetRemainingField(true);
        }

        public APIRequestGetCampaignsByLabels requestBudgetRemainingField(boolean value) {
            this.requestField("budget_remaining", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestBuyingTypeField() {
            return this.requestBuyingTypeField(true);
        }

        public APIRequestGetCampaignsByLabels requestBuyingTypeField(boolean value) {
            this.requestField("buying_type", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestCanCreateBrandLiftStudyField() {
            return this.requestCanCreateBrandLiftStudyField(true);
        }

        public APIRequestGetCampaignsByLabels requestCanCreateBrandLiftStudyField(boolean value) {
            this.requestField("can_create_brand_lift_study", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestCanUseSpendCapField() {
            return this.requestCanUseSpendCapField(true);
        }

        public APIRequestGetCampaignsByLabels requestCanUseSpendCapField(boolean value) {
            this.requestField("can_use_spend_cap", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestConfiguredStatusField() {
            return this.requestConfiguredStatusField(true);
        }

        public APIRequestGetCampaignsByLabels requestConfiguredStatusField(boolean value) {
            this.requestField("configured_status", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetCampaignsByLabels requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestDailyBudgetField() {
            return this.requestDailyBudgetField(true);
        }

        public APIRequestGetCampaignsByLabels requestDailyBudgetField(boolean value) {
            this.requestField("daily_budget", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestEffectiveStatusField() {
            return this.requestEffectiveStatusField(true);
        }

        public APIRequestGetCampaignsByLabels requestEffectiveStatusField(boolean value) {
            this.requestField("effective_status", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetCampaignsByLabels requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestIsAutobidField() {
            return this.requestIsAutobidField(true);
        }

        public APIRequestGetCampaignsByLabels requestIsAutobidField(boolean value) {
            this.requestField("is_autobid", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestIsAveragePricePacingField() {
            return this.requestIsAveragePricePacingField(true);
        }

        public APIRequestGetCampaignsByLabels requestIsAveragePricePacingField(boolean value) {
            this.requestField("is_average_price_pacing", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestKpiCustomConversionIdField() {
            return this.requestKpiCustomConversionIdField(true);
        }

        public APIRequestGetCampaignsByLabels requestKpiCustomConversionIdField(boolean value) {
            this.requestField("kpi_custom_conversion_id", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestKpiTypeField() {
            return this.requestKpiTypeField(true);
        }

        public APIRequestGetCampaignsByLabels requestKpiTypeField(boolean value) {
            this.requestField("kpi_type", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestLastBudgetTogglingTimeField() {
            return this.requestLastBudgetTogglingTimeField(true);
        }

        public APIRequestGetCampaignsByLabels requestLastBudgetTogglingTimeField(boolean value) {
            this.requestField("last_budget_toggling_time", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestLifetimeBudgetField() {
            return this.requestLifetimeBudgetField(true);
        }

        public APIRequestGetCampaignsByLabels requestLifetimeBudgetField(boolean value) {
            this.requestField("lifetime_budget", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestMetricsMetadataField() {
            return this.requestMetricsMetadataField(true);
        }

        public APIRequestGetCampaignsByLabels requestMetricsMetadataField(boolean value) {
            this.requestField("metrics_metadata", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetCampaignsByLabels requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestObjectiveField() {
            return this.requestObjectiveField(true);
        }

        public APIRequestGetCampaignsByLabels requestObjectiveField(boolean value) {
            this.requestField("objective", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestPacingTypeField() {
            return this.requestPacingTypeField(true);
        }

        public APIRequestGetCampaignsByLabels requestPacingTypeField(boolean value) {
            this.requestField("pacing_type", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestPromotedObjectField() {
            return this.requestPromotedObjectField(true);
        }

        public APIRequestGetCampaignsByLabels requestPromotedObjectField(boolean value) {
            this.requestField("promoted_object", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestRecommendationsField() {
            return this.requestRecommendationsField(true);
        }

        public APIRequestGetCampaignsByLabels requestRecommendationsField(boolean value) {
            this.requestField("recommendations", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestSourceCampaignField() {
            return this.requestSourceCampaignField(true);
        }

        public APIRequestGetCampaignsByLabels requestSourceCampaignField(boolean value) {
            this.requestField("source_campaign", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestSourceCampaignIdField() {
            return this.requestSourceCampaignIdField(true);
        }

        public APIRequestGetCampaignsByLabels requestSourceCampaignIdField(boolean value) {
            this.requestField("source_campaign_id", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetCampaignsByLabels requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetCampaignsByLabels requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetCampaignsByLabels requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestStopTimeField() {
            return this.requestStopTimeField(true);
        }

        public APIRequestGetCampaignsByLabels requestStopTimeField(boolean value) {
            this.requestField("stop_time", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestToplineIdField() {
            return this.requestToplineIdField(true);
        }

        public APIRequestGetCampaignsByLabels requestToplineIdField(boolean value) {
            this.requestField("topline_id", value);
            return this;
        }

        public APIRequestGetCampaignsByLabels requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetCampaignsByLabels requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateCampaign
    extends APIRequest<Campaign> {
        Campaign lastResponse = null;
        public static final String[] PARAMS = new String[]{"name", "objective", "status", "bid_strategy", "budget_rebalance_flag", "buying_type", "daily_budget", "lifetime_budget", "pacing_type", "promoted_object", "topline_id", "spend_cap", "execution_options", "upstream_events", "adlabels", "source_campaign_id", "iterative_split_test_configs", "kpi_custom_conversion_id", "kpi_type", "is_autobid", "is_average_price_pacing"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Campaign getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Campaign parseResponse(String response) throws APIException {
            return Campaign.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Campaign execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Campaign execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<Campaign> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Campaign> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Campaign>(){

                public Campaign apply(String result) {
                    try {
                        return APIRequestCreateCampaign.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateCampaign(String nodeId, APIContext context) {
            super(context, nodeId, "/campaigns", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateCampaign setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateCampaign setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateCampaign setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateCampaign setObjective(Campaign.EnumObjective objective) {
            this.setParam("objective", (Object)objective);
            return this;
        }

        public APIRequestCreateCampaign setObjective(String objective) {
            this.setParam("objective", objective);
            return this;
        }

        public APIRequestCreateCampaign setStatus(Campaign.EnumStatus status) {
            this.setParam("status", (Object)status);
            return this;
        }

        public APIRequestCreateCampaign setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestCreateCampaign setBidStrategy(Campaign.EnumBidStrategy bidStrategy) {
            this.setParam("bid_strategy", (Object)bidStrategy);
            return this;
        }

        public APIRequestCreateCampaign setBidStrategy(String bidStrategy) {
            this.setParam("bid_strategy", bidStrategy);
            return this;
        }

        public APIRequestCreateCampaign setBudgetRebalanceFlag(Boolean budgetRebalanceFlag) {
            this.setParam("budget_rebalance_flag", budgetRebalanceFlag);
            return this;
        }

        public APIRequestCreateCampaign setBudgetRebalanceFlag(String budgetRebalanceFlag) {
            this.setParam("budget_rebalance_flag", budgetRebalanceFlag);
            return this;
        }

        public APIRequestCreateCampaign setBuyingType(String buyingType) {
            this.setParam("buying_type", buyingType);
            return this;
        }

        public APIRequestCreateCampaign setDailyBudget(Long dailyBudget) {
            this.setParam("daily_budget", dailyBudget);
            return this;
        }

        public APIRequestCreateCampaign setDailyBudget(String dailyBudget) {
            this.setParam("daily_budget", dailyBudget);
            return this;
        }

        public APIRequestCreateCampaign setLifetimeBudget(Long lifetimeBudget) {
            this.setParam("lifetime_budget", lifetimeBudget);
            return this;
        }

        public APIRequestCreateCampaign setLifetimeBudget(String lifetimeBudget) {
            this.setParam("lifetime_budget", lifetimeBudget);
            return this;
        }

        public APIRequestCreateCampaign setPacingType(List<String> pacingType) {
            this.setParam("pacing_type", pacingType);
            return this;
        }

        public APIRequestCreateCampaign setPacingType(String pacingType) {
            this.setParam("pacing_type", pacingType);
            return this;
        }

        public APIRequestCreateCampaign setPromotedObject(Object promotedObject) {
            this.setParam("promoted_object", promotedObject);
            return this;
        }

        public APIRequestCreateCampaign setPromotedObject(String promotedObject) {
            this.setParam("promoted_object", promotedObject);
            return this;
        }

        public APIRequestCreateCampaign setToplineId(String toplineId) {
            this.setParam("topline_id", toplineId);
            return this;
        }

        public APIRequestCreateCampaign setSpendCap(Long spendCap) {
            this.setParam("spend_cap", spendCap);
            return this;
        }

        public APIRequestCreateCampaign setSpendCap(String spendCap) {
            this.setParam("spend_cap", spendCap);
            return this;
        }

        public APIRequestCreateCampaign setExecutionOptions(List<Campaign.EnumExecutionOptions> executionOptions) {
            this.setParam("execution_options", executionOptions);
            return this;
        }

        public APIRequestCreateCampaign setExecutionOptions(String executionOptions) {
            this.setParam("execution_options", executionOptions);
            return this;
        }

        public APIRequestCreateCampaign setUpstreamEvents(Map<String, String> upstreamEvents) {
            this.setParam("upstream_events", upstreamEvents);
            return this;
        }

        public APIRequestCreateCampaign setUpstreamEvents(String upstreamEvents) {
            this.setParam("upstream_events", upstreamEvents);
            return this;
        }

        public APIRequestCreateCampaign setAdlabels(List<Object> adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestCreateCampaign setAdlabels(String adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestCreateCampaign setSourceCampaignId(String sourceCampaignId) {
            this.setParam("source_campaign_id", sourceCampaignId);
            return this;
        }

        public APIRequestCreateCampaign setIterativeSplitTestConfigs(List<Object> iterativeSplitTestConfigs) {
            this.setParam("iterative_split_test_configs", iterativeSplitTestConfigs);
            return this;
        }

        public APIRequestCreateCampaign setIterativeSplitTestConfigs(String iterativeSplitTestConfigs) {
            this.setParam("iterative_split_test_configs", iterativeSplitTestConfigs);
            return this;
        }

        public APIRequestCreateCampaign setKpiCustomConversionId(String kpiCustomConversionId) {
            this.setParam("kpi_custom_conversion_id", kpiCustomConversionId);
            return this;
        }

        public APIRequestCreateCampaign setKpiType(Object kpiType) {
            this.setParam("kpi_type", kpiType);
            return this;
        }

        public APIRequestCreateCampaign setKpiType(String kpiType) {
            this.setParam("kpi_type", kpiType);
            return this;
        }

        public APIRequestCreateCampaign setIsAutobid(Boolean isAutobid) {
            this.setParam("is_autobid", isAutobid);
            return this;
        }

        public APIRequestCreateCampaign setIsAutobid(String isAutobid) {
            this.setParam("is_autobid", isAutobid);
            return this;
        }

        public APIRequestCreateCampaign setIsAveragePricePacing(Boolean isAveragePricePacing) {
            this.setParam("is_average_price_pacing", isAveragePricePacing);
            return this;
        }

        public APIRequestCreateCampaign setIsAveragePricePacing(String isAveragePricePacing) {
            this.setParam("is_average_price_pacing", isAveragePricePacing);
            return this;
        }

        public APIRequestCreateCampaign requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateCampaign requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCampaign requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateCampaign requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCampaign requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateCampaign requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetCampaigns
    extends APIRequest<Campaign> {
        APINodeList<Campaign> lastResponse = null;
        public static final String[] PARAMS = new String[]{"effective_status", "date_preset", "is_completed"};
        public static final String[] FIELDS = new String[]{"account_id", "adlabels", "bid_strategy", "boosted_object_id", "brand_lift_studies", "budget_rebalance_flag", "budget_remaining", "buying_type", "can_create_brand_lift_study", "can_use_spend_cap", "configured_status", "created_time", "daily_budget", "effective_status", "id", "is_autobid", "is_average_price_pacing", "kpi_custom_conversion_id", "kpi_type", "last_budget_toggling_time", "lifetime_budget", "metrics_metadata", "name", "objective", "pacing_type", "promoted_object", "recommendations", "source_campaign", "source_campaign_id", "spend_cap", "start_time", "status", "stop_time", "topline_id", "updated_time"};

        @Override
        public APINodeList<Campaign> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Campaign> parseResponse(String response) throws APIException {
            return Campaign.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Campaign> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Campaign> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Campaign>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Campaign>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Campaign>>(){

                public APINodeList<Campaign> apply(String result) {
                    try {
                        return APIRequestGetCampaigns.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetCampaigns(String nodeId, APIContext context) {
            super(context, nodeId, "/campaigns", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCampaigns setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCampaigns setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCampaigns setEffectiveStatus(List<Campaign.EnumEffectiveStatus> effectiveStatus) {
            this.setParam("effective_status", effectiveStatus);
            return this;
        }

        public APIRequestGetCampaigns setEffectiveStatus(String effectiveStatus) {
            this.setParam("effective_status", effectiveStatus);
            return this;
        }

        public APIRequestGetCampaigns setDatePreset(Campaign.EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestGetCampaigns setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestGetCampaigns setIsCompleted(Boolean isCompleted) {
            this.setParam("is_completed", isCompleted);
            return this;
        }

        public APIRequestGetCampaigns setIsCompleted(String isCompleted) {
            this.setParam("is_completed", isCompleted);
            return this;
        }

        public APIRequestGetCampaigns requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCampaigns requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCampaigns requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCampaigns requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCampaigns requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCampaigns requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetCampaigns requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetCampaigns requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetCampaigns requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGetCampaigns requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGetCampaigns requestBidStrategyField() {
            return this.requestBidStrategyField(true);
        }

        public APIRequestGetCampaigns requestBidStrategyField(boolean value) {
            this.requestField("bid_strategy", value);
            return this;
        }

        public APIRequestGetCampaigns requestBoostedObjectIdField() {
            return this.requestBoostedObjectIdField(true);
        }

        public APIRequestGetCampaigns requestBoostedObjectIdField(boolean value) {
            this.requestField("boosted_object_id", value);
            return this;
        }

        public APIRequestGetCampaigns requestBrandLiftStudiesField() {
            return this.requestBrandLiftStudiesField(true);
        }

        public APIRequestGetCampaigns requestBrandLiftStudiesField(boolean value) {
            this.requestField("brand_lift_studies", value);
            return this;
        }

        public APIRequestGetCampaigns requestBudgetRebalanceFlagField() {
            return this.requestBudgetRebalanceFlagField(true);
        }

        public APIRequestGetCampaigns requestBudgetRebalanceFlagField(boolean value) {
            this.requestField("budget_rebalance_flag", value);
            return this;
        }

        public APIRequestGetCampaigns requestBudgetRemainingField() {
            return this.requestBudgetRemainingField(true);
        }

        public APIRequestGetCampaigns requestBudgetRemainingField(boolean value) {
            this.requestField("budget_remaining", value);
            return this;
        }

        public APIRequestGetCampaigns requestBuyingTypeField() {
            return this.requestBuyingTypeField(true);
        }

        public APIRequestGetCampaigns requestBuyingTypeField(boolean value) {
            this.requestField("buying_type", value);
            return this;
        }

        public APIRequestGetCampaigns requestCanCreateBrandLiftStudyField() {
            return this.requestCanCreateBrandLiftStudyField(true);
        }

        public APIRequestGetCampaigns requestCanCreateBrandLiftStudyField(boolean value) {
            this.requestField("can_create_brand_lift_study", value);
            return this;
        }

        public APIRequestGetCampaigns requestCanUseSpendCapField() {
            return this.requestCanUseSpendCapField(true);
        }

        public APIRequestGetCampaigns requestCanUseSpendCapField(boolean value) {
            this.requestField("can_use_spend_cap", value);
            return this;
        }

        public APIRequestGetCampaigns requestConfiguredStatusField() {
            return this.requestConfiguredStatusField(true);
        }

        public APIRequestGetCampaigns requestConfiguredStatusField(boolean value) {
            this.requestField("configured_status", value);
            return this;
        }

        public APIRequestGetCampaigns requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetCampaigns requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetCampaigns requestDailyBudgetField() {
            return this.requestDailyBudgetField(true);
        }

        public APIRequestGetCampaigns requestDailyBudgetField(boolean value) {
            this.requestField("daily_budget", value);
            return this;
        }

        public APIRequestGetCampaigns requestEffectiveStatusField() {
            return this.requestEffectiveStatusField(true);
        }

        public APIRequestGetCampaigns requestEffectiveStatusField(boolean value) {
            this.requestField("effective_status", value);
            return this;
        }

        public APIRequestGetCampaigns requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetCampaigns requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetCampaigns requestIsAutobidField() {
            return this.requestIsAutobidField(true);
        }

        public APIRequestGetCampaigns requestIsAutobidField(boolean value) {
            this.requestField("is_autobid", value);
            return this;
        }

        public APIRequestGetCampaigns requestIsAveragePricePacingField() {
            return this.requestIsAveragePricePacingField(true);
        }

        public APIRequestGetCampaigns requestIsAveragePricePacingField(boolean value) {
            this.requestField("is_average_price_pacing", value);
            return this;
        }

        public APIRequestGetCampaigns requestKpiCustomConversionIdField() {
            return this.requestKpiCustomConversionIdField(true);
        }

        public APIRequestGetCampaigns requestKpiCustomConversionIdField(boolean value) {
            this.requestField("kpi_custom_conversion_id", value);
            return this;
        }

        public APIRequestGetCampaigns requestKpiTypeField() {
            return this.requestKpiTypeField(true);
        }

        public APIRequestGetCampaigns requestKpiTypeField(boolean value) {
            this.requestField("kpi_type", value);
            return this;
        }

        public APIRequestGetCampaigns requestLastBudgetTogglingTimeField() {
            return this.requestLastBudgetTogglingTimeField(true);
        }

        public APIRequestGetCampaigns requestLastBudgetTogglingTimeField(boolean value) {
            this.requestField("last_budget_toggling_time", value);
            return this;
        }

        public APIRequestGetCampaigns requestLifetimeBudgetField() {
            return this.requestLifetimeBudgetField(true);
        }

        public APIRequestGetCampaigns requestLifetimeBudgetField(boolean value) {
            this.requestField("lifetime_budget", value);
            return this;
        }

        public APIRequestGetCampaigns requestMetricsMetadataField() {
            return this.requestMetricsMetadataField(true);
        }

        public APIRequestGetCampaigns requestMetricsMetadataField(boolean value) {
            this.requestField("metrics_metadata", value);
            return this;
        }

        public APIRequestGetCampaigns requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetCampaigns requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetCampaigns requestObjectiveField() {
            return this.requestObjectiveField(true);
        }

        public APIRequestGetCampaigns requestObjectiveField(boolean value) {
            this.requestField("objective", value);
            return this;
        }

        public APIRequestGetCampaigns requestPacingTypeField() {
            return this.requestPacingTypeField(true);
        }

        public APIRequestGetCampaigns requestPacingTypeField(boolean value) {
            this.requestField("pacing_type", value);
            return this;
        }

        public APIRequestGetCampaigns requestPromotedObjectField() {
            return this.requestPromotedObjectField(true);
        }

        public APIRequestGetCampaigns requestPromotedObjectField(boolean value) {
            this.requestField("promoted_object", value);
            return this;
        }

        public APIRequestGetCampaigns requestRecommendationsField() {
            return this.requestRecommendationsField(true);
        }

        public APIRequestGetCampaigns requestRecommendationsField(boolean value) {
            this.requestField("recommendations", value);
            return this;
        }

        public APIRequestGetCampaigns requestSourceCampaignField() {
            return this.requestSourceCampaignField(true);
        }

        public APIRequestGetCampaigns requestSourceCampaignField(boolean value) {
            this.requestField("source_campaign", value);
            return this;
        }

        public APIRequestGetCampaigns requestSourceCampaignIdField() {
            return this.requestSourceCampaignIdField(true);
        }

        public APIRequestGetCampaigns requestSourceCampaignIdField(boolean value) {
            this.requestField("source_campaign_id", value);
            return this;
        }

        public APIRequestGetCampaigns requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetCampaigns requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetCampaigns requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetCampaigns requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetCampaigns requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetCampaigns requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetCampaigns requestStopTimeField() {
            return this.requestStopTimeField(true);
        }

        public APIRequestGetCampaigns requestStopTimeField(boolean value) {
            this.requestField("stop_time", value);
            return this;
        }

        public APIRequestGetCampaigns requestToplineIdField() {
            return this.requestToplineIdField(true);
        }

        public APIRequestGetCampaigns requestToplineIdField(boolean value) {
            this.requestField("topline_id", value);
            return this;
        }

        public APIRequestGetCampaigns requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetCampaigns requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteCampaigns
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"delete_strategy", "object_count", "before_date", "delete_offset"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteCampaigns.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteCampaigns(String nodeId, APIContext context) {
            super(context, nodeId, "/campaigns", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteCampaigns setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteCampaigns setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteCampaigns setDeleteStrategy(EnumDeleteStrategy deleteStrategy) {
            this.setParam("delete_strategy", (Object)deleteStrategy);
            return this;
        }

        public APIRequestDeleteCampaigns setDeleteStrategy(String deleteStrategy) {
            this.setParam("delete_strategy", deleteStrategy);
            return this;
        }

        public APIRequestDeleteCampaigns setObjectCount(Long objectCount) {
            this.setParam("object_count", objectCount);
            return this;
        }

        public APIRequestDeleteCampaigns setObjectCount(String objectCount) {
            this.setParam("object_count", objectCount);
            return this;
        }

        public APIRequestDeleteCampaigns setBeforeDate(String beforeDate) {
            this.setParam("before_date", beforeDate);
            return this;
        }

        public APIRequestDeleteCampaigns setDeleteOffset(Long deleteOffset) {
            this.setParam("delete_offset", deleteOffset);
            return this;
        }

        public APIRequestDeleteCampaigns setDeleteOffset(String deleteOffset) {
            this.setParam("delete_offset", deleteOffset);
            return this;
        }

        public APIRequestDeleteCampaigns requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteCampaigns requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteCampaigns requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteCampaigns requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteCampaigns requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteCampaigns requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetBusinessProjects
    extends APIRequest<BusinessProject> {
        APINodeList<BusinessProject> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[]{"business", "created_time", "creator", "id", "name"};

        @Override
        public APINodeList<BusinessProject> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<BusinessProject> parseResponse(String response) throws APIException {
            return BusinessProject.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<BusinessProject> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<BusinessProject> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<BusinessProject>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<BusinessProject>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<BusinessProject>>(){

                public APINodeList<BusinessProject> apply(String result) {
                    try {
                        return APIRequestGetBusinessProjects.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetBusinessProjects(String nodeId, APIContext context) {
            super(context, nodeId, "/businessprojects", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetBusinessProjects setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetBusinessProjects setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetBusinessProjects setBusiness(Object business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestGetBusinessProjects setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestGetBusinessProjects requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetBusinessProjects requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBusinessProjects requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetBusinessProjects requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBusinessProjects requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetBusinessProjects requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetBusinessProjects requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetBusinessProjects requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetBusinessProjects requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetBusinessProjects requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetBusinessProjects requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGetBusinessProjects requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGetBusinessProjects requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetBusinessProjects requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetBusinessProjects requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetBusinessProjects requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetBusinessActivities
    extends APIRequest<BusinessActivityLogEvent> {
        APINodeList<BusinessActivityLogEvent> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[]{"acted_upon_business_id", "acted_upon_business_name", "acted_upon_business_object_id", "acted_upon_business_object_name", "acted_upon_business_object_type", "acted_upon_user_id", "acted_upon_user_name", "acting_business_id", "acting_business_name", "acting_user_id", "acting_user_name", "event_time", "event_type", "extra_data", "target_business_id", "target_business_name", "target_business_object_id", "target_business_object_name", "target_business_object_type", "id"};

        @Override
        public APINodeList<BusinessActivityLogEvent> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<BusinessActivityLogEvent> parseResponse(String response) throws APIException {
            return BusinessActivityLogEvent.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<BusinessActivityLogEvent> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<BusinessActivityLogEvent> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<BusinessActivityLogEvent>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<BusinessActivityLogEvent>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<BusinessActivityLogEvent>>(){

                public APINodeList<BusinessActivityLogEvent> apply(String result) {
                    try {
                        return APIRequestGetBusinessActivities.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetBusinessActivities(String nodeId, APIContext context) {
            super(context, nodeId, "/business_activities", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetBusinessActivities setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetBusinessActivities setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetBusinessActivities setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestGetBusinessActivities requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetBusinessActivities requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBusinessActivities requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetBusinessActivities requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBusinessActivities requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetBusinessActivities requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessIdField() {
            return this.requestActedUponBusinessIdField(true);
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessIdField(boolean value) {
            this.requestField("acted_upon_business_id", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessNameField() {
            return this.requestActedUponBusinessNameField(true);
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessNameField(boolean value) {
            this.requestField("acted_upon_business_name", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessObjectIdField() {
            return this.requestActedUponBusinessObjectIdField(true);
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessObjectIdField(boolean value) {
            this.requestField("acted_upon_business_object_id", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessObjectNameField() {
            return this.requestActedUponBusinessObjectNameField(true);
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessObjectNameField(boolean value) {
            this.requestField("acted_upon_business_object_name", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessObjectTypeField() {
            return this.requestActedUponBusinessObjectTypeField(true);
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessObjectTypeField(boolean value) {
            this.requestField("acted_upon_business_object_type", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActedUponUserIdField() {
            return this.requestActedUponUserIdField(true);
        }

        public APIRequestGetBusinessActivities requestActedUponUserIdField(boolean value) {
            this.requestField("acted_upon_user_id", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActedUponUserNameField() {
            return this.requestActedUponUserNameField(true);
        }

        public APIRequestGetBusinessActivities requestActedUponUserNameField(boolean value) {
            this.requestField("acted_upon_user_name", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActingBusinessIdField() {
            return this.requestActingBusinessIdField(true);
        }

        public APIRequestGetBusinessActivities requestActingBusinessIdField(boolean value) {
            this.requestField("acting_business_id", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActingBusinessNameField() {
            return this.requestActingBusinessNameField(true);
        }

        public APIRequestGetBusinessActivities requestActingBusinessNameField(boolean value) {
            this.requestField("acting_business_name", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActingUserIdField() {
            return this.requestActingUserIdField(true);
        }

        public APIRequestGetBusinessActivities requestActingUserIdField(boolean value) {
            this.requestField("acting_user_id", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActingUserNameField() {
            return this.requestActingUserNameField(true);
        }

        public APIRequestGetBusinessActivities requestActingUserNameField(boolean value) {
            this.requestField("acting_user_name", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestEventTimeField() {
            return this.requestEventTimeField(true);
        }

        public APIRequestGetBusinessActivities requestEventTimeField(boolean value) {
            this.requestField("event_time", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestEventTypeField() {
            return this.requestEventTypeField(true);
        }

        public APIRequestGetBusinessActivities requestEventTypeField(boolean value) {
            this.requestField("event_type", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestExtraDataField() {
            return this.requestExtraDataField(true);
        }

        public APIRequestGetBusinessActivities requestExtraDataField(boolean value) {
            this.requestField("extra_data", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestTargetBusinessIdField() {
            return this.requestTargetBusinessIdField(true);
        }

        public APIRequestGetBusinessActivities requestTargetBusinessIdField(boolean value) {
            this.requestField("target_business_id", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestTargetBusinessNameField() {
            return this.requestTargetBusinessNameField(true);
        }

        public APIRequestGetBusinessActivities requestTargetBusinessNameField(boolean value) {
            this.requestField("target_business_name", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestTargetBusinessObjectIdField() {
            return this.requestTargetBusinessObjectIdField(true);
        }

        public APIRequestGetBusinessActivities requestTargetBusinessObjectIdField(boolean value) {
            this.requestField("target_business_object_id", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestTargetBusinessObjectNameField() {
            return this.requestTargetBusinessObjectNameField(true);
        }

        public APIRequestGetBusinessActivities requestTargetBusinessObjectNameField(boolean value) {
            this.requestField("target_business_object_name", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestTargetBusinessObjectTypeField() {
            return this.requestTargetBusinessObjectTypeField(true);
        }

        public APIRequestGetBusinessActivities requestTargetBusinessObjectTypeField(boolean value) {
            this.requestField("target_business_object_type", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetBusinessActivities requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetBroadTargetingCategories
    extends APIRequest<BroadTargetingCategories> {
        APINodeList<BroadTargetingCategories> lastResponse = null;
        public static final String[] PARAMS = new String[]{"custom_categories_only"};
        public static final String[] FIELDS = new String[]{"category_description", "id", "name", "parent_category", "path", "size", "source", "type", "type_name", "untranslated_name", "untranslated_parent_name"};

        @Override
        public APINodeList<BroadTargetingCategories> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<BroadTargetingCategories> parseResponse(String response) throws APIException {
            return BroadTargetingCategories.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<BroadTargetingCategories> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<BroadTargetingCategories> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<BroadTargetingCategories>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<BroadTargetingCategories>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<BroadTargetingCategories>>(){

                public APINodeList<BroadTargetingCategories> apply(String result) {
                    try {
                        return APIRequestGetBroadTargetingCategories.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetBroadTargetingCategories(String nodeId, APIContext context) {
            super(context, nodeId, "/broadtargetingcategories", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetBroadTargetingCategories setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetBroadTargetingCategories setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetBroadTargetingCategories setCustomCategoriesOnly(Boolean customCategoriesOnly) {
            this.setParam("custom_categories_only", customCategoriesOnly);
            return this;
        }

        public APIRequestGetBroadTargetingCategories setCustomCategoriesOnly(String customCategoriesOnly) {
            this.setParam("custom_categories_only", customCategoriesOnly);
            return this;
        }

        public APIRequestGetBroadTargetingCategories requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetBroadTargetingCategories requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBroadTargetingCategories requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetBroadTargetingCategories requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBroadTargetingCategories requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetBroadTargetingCategories requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetBroadTargetingCategories requestCategoryDescriptionField() {
            return this.requestCategoryDescriptionField(true);
        }

        public APIRequestGetBroadTargetingCategories requestCategoryDescriptionField(boolean value) {
            this.requestField("category_description", value);
            return this;
        }

        public APIRequestGetBroadTargetingCategories requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetBroadTargetingCategories requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetBroadTargetingCategories requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetBroadTargetingCategories requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetBroadTargetingCategories requestParentCategoryField() {
            return this.requestParentCategoryField(true);
        }

        public APIRequestGetBroadTargetingCategories requestParentCategoryField(boolean value) {
            this.requestField("parent_category", value);
            return this;
        }

        public APIRequestGetBroadTargetingCategories requestPathField() {
            return this.requestPathField(true);
        }

        public APIRequestGetBroadTargetingCategories requestPathField(boolean value) {
            this.requestField("path", value);
            return this;
        }

        public APIRequestGetBroadTargetingCategories requestSizeField() {
            return this.requestSizeField(true);
        }

        public APIRequestGetBroadTargetingCategories requestSizeField(boolean value) {
            this.requestField("size", value);
            return this;
        }

        public APIRequestGetBroadTargetingCategories requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGetBroadTargetingCategories requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGetBroadTargetingCategories requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetBroadTargetingCategories requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetBroadTargetingCategories requestTypeNameField() {
            return this.requestTypeNameField(true);
        }

        public APIRequestGetBroadTargetingCategories requestTypeNameField(boolean value) {
            this.requestField("type_name", value);
            return this;
        }

        public APIRequestGetBroadTargetingCategories requestUntranslatedNameField() {
            return this.requestUntranslatedNameField(true);
        }

        public APIRequestGetBroadTargetingCategories requestUntranslatedNameField(boolean value) {
            this.requestField("untranslated_name", value);
            return this;
        }

        public APIRequestGetBroadTargetingCategories requestUntranslatedParentNameField() {
            return this.requestUntranslatedParentNameField(true);
        }

        public APIRequestGetBroadTargetingCategories requestUntranslatedParentNameField(boolean value) {
            this.requestField("untranslated_parent_name", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateBrandAudience
    extends APIRequest<BrandAudience> {
        BrandAudience lastResponse = null;
        public static final String[] PARAMS = new String[]{"name", "targeting", "target_size", "description"};
        public static final String[] FIELDS = new String[0];

        @Override
        public BrandAudience getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BrandAudience parseResponse(String response) throws APIException {
            return BrandAudience.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public BrandAudience execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BrandAudience execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<BrandAudience> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BrandAudience> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, BrandAudience>(){

                public BrandAudience apply(String result) {
                    try {
                        return APIRequestCreateBrandAudience.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateBrandAudience(String nodeId, APIContext context) {
            super(context, nodeId, "/brand_audiences", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateBrandAudience setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateBrandAudience setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateBrandAudience setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateBrandAudience setTargeting(Object targeting) {
            this.setParam("targeting", targeting);
            return this;
        }

        public APIRequestCreateBrandAudience setTargeting(String targeting) {
            this.setParam("targeting", targeting);
            return this;
        }

        public APIRequestCreateBrandAudience setTargetSize(Long targetSize) {
            this.setParam("target_size", targetSize);
            return this;
        }

        public APIRequestCreateBrandAudience setTargetSize(String targetSize) {
            this.setParam("target_size", targetSize);
            return this;
        }

        public APIRequestCreateBrandAudience setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateBrandAudience requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateBrandAudience requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateBrandAudience requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateBrandAudience requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateBrandAudience requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateBrandAudience requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetBrandAudiences
    extends APIRequest<BrandAudience> {
        APINodeList<BrandAudience> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account", "delivery_targeting", "description", "id", "name", "sentence_lines", "status", "targeting", "time_created", "time_updated"};

        @Override
        public APINodeList<BrandAudience> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<BrandAudience> parseResponse(String response) throws APIException {
            return BrandAudience.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<BrandAudience> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<BrandAudience> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<BrandAudience>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<BrandAudience>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<BrandAudience>>(){

                public APINodeList<BrandAudience> apply(String result) {
                    try {
                        return APIRequestGetBrandAudiences.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetBrandAudiences(String nodeId, APIContext context) {
            super(context, nodeId, "/brand_audiences", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetBrandAudiences setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetBrandAudiences setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetBrandAudiences requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetBrandAudiences requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBrandAudiences requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetBrandAudiences requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBrandAudiences requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetBrandAudiences requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetBrandAudiences requestAccountField() {
            return this.requestAccountField(true);
        }

        public APIRequestGetBrandAudiences requestAccountField(boolean value) {
            this.requestField("account", value);
            return this;
        }

        public APIRequestGetBrandAudiences requestDeliveryTargetingField() {
            return this.requestDeliveryTargetingField(true);
        }

        public APIRequestGetBrandAudiences requestDeliveryTargetingField(boolean value) {
            this.requestField("delivery_targeting", value);
            return this;
        }

        public APIRequestGetBrandAudiences requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetBrandAudiences requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetBrandAudiences requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetBrandAudiences requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetBrandAudiences requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetBrandAudiences requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetBrandAudiences requestSentenceLinesField() {
            return this.requestSentenceLinesField(true);
        }

        public APIRequestGetBrandAudiences requestSentenceLinesField(boolean value) {
            this.requestField("sentence_lines", value);
            return this;
        }

        public APIRequestGetBrandAudiences requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetBrandAudiences requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetBrandAudiences requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGetBrandAudiences requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGetBrandAudiences requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGetBrandAudiences requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGetBrandAudiences requestTimeUpdatedField() {
            return this.requestTimeUpdatedField(true);
        }

        public APIRequestGetBrandAudiences requestTimeUpdatedField(boolean value) {
            this.requestField("time_updated", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateBlockListDraft
    extends APIRequest<AdAccount> {
        AdAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"publisher_urls_file"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccount parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccount execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccount>(){

                public AdAccount apply(String result) {
                    try {
                        return APIRequestCreateBlockListDraft.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateBlockListDraft(String nodeId, APIContext context) {
            super(context, nodeId, "/block_list_drafts", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateBlockListDraft setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateBlockListDraft setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateBlockListDraft setPublisherUrlsFile(File publisherUrlsFile) {
            this.setParam("publisher_urls_file", publisherUrlsFile);
            return this;
        }

        public APIRequestCreateBlockListDraft setPublisherUrlsFile(String publisherUrlsFile) {
            this.setParam("publisher_urls_file", publisherUrlsFile);
            return this;
        }

        public APIRequestCreateBlockListDraft requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateBlockListDraft requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateBlockListDraft requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateBlockListDraft requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateBlockListDraft requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateBlockListDraft requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateBatchUpload
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"payload"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateBatchUpload.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateBatchUpload(String nodeId, APIContext context) {
            super(context, nodeId, "/batchupload", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateBatchUpload setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateBatchUpload setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateBatchUpload setPayload(List<String> payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestCreateBatchUpload setPayload(String payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestCreateBatchUpload requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateBatchUpload requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateBatchUpload requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateBatchUpload requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateBatchUpload requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateBatchUpload requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateBatchReplace
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"payload"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateBatchReplace.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateBatchReplace(String nodeId, APIContext context) {
            super(context, nodeId, "/batchreplace", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateBatchReplace setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateBatchReplace setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateBatchReplace setPayload(List<String> payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestCreateBatchReplace setPayload(String payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestCreateBatchReplace requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateBatchReplace requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateBatchReplace requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateBatchReplace requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateBatchReplace requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateBatchReplace requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAudienceReplace
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"session", "payload"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateAudienceReplace.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAudienceReplace(String nodeId, APIContext context) {
            super(context, nodeId, "/audiencereplace", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAudienceReplace setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAudienceReplace setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAudienceReplace setSession(Object session) {
            this.setParam("session", session);
            return this;
        }

        public APIRequestCreateAudienceReplace setSession(String session) {
            this.setParam("session", session);
            return this;
        }

        public APIRequestCreateAudienceReplace setPayload(Object payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestCreateAudienceReplace setPayload(String payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestCreateAudienceReplace requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAudienceReplace requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAudienceReplace requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAudienceReplace requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAudienceReplace requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAudienceReplace requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAsyncAdRequestSet
    extends APIRequest<AdAsyncRequestSet> {
        AdAsyncRequestSet lastResponse = null;
        public static final String[] PARAMS = new String[]{"ad_specs", "name", "notification_uri", "notification_mode"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdAsyncRequestSet getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAsyncRequestSet parseResponse(String response) throws APIException {
            return AdAsyncRequestSet.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAsyncRequestSet execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAsyncRequestSet execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAsyncRequestSet> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAsyncRequestSet> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAsyncRequestSet>(){

                public AdAsyncRequestSet apply(String result) {
                    try {
                        return APIRequestCreateAsyncAdRequestSet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAsyncAdRequestSet(String nodeId, APIContext context) {
            super(context, nodeId, "/asyncadrequestsets", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAsyncAdRequestSet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAsyncAdRequestSet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAsyncAdRequestSet setAdSpecs(List<Map<String, String>> adSpecs) {
            this.setParam("ad_specs", adSpecs);
            return this;
        }

        public APIRequestCreateAsyncAdRequestSet setAdSpecs(String adSpecs) {
            this.setParam("ad_specs", adSpecs);
            return this;
        }

        public APIRequestCreateAsyncAdRequestSet setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateAsyncAdRequestSet setNotificationUri(String notificationUri) {
            this.setParam("notification_uri", notificationUri);
            return this;
        }

        public APIRequestCreateAsyncAdRequestSet setNotificationMode(AdAsyncRequestSet.EnumNotificationMode notificationMode) {
            this.setParam("notification_mode", (Object)notificationMode);
            return this;
        }

        public APIRequestCreateAsyncAdRequestSet setNotificationMode(String notificationMode) {
            this.setParam("notification_mode", notificationMode);
            return this;
        }

        public APIRequestCreateAsyncAdRequestSet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAsyncAdRequestSet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAsyncAdRequestSet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAsyncAdRequestSet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAsyncAdRequestSet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAsyncAdRequestSet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAsyncAdRequestSets
    extends APIRequest<AdAsyncRequestSet> {
        APINodeList<AdAsyncRequestSet> lastResponse = null;
        public static final String[] PARAMS = new String[]{"is_completed"};
        public static final String[] FIELDS = new String[]{"canceled_count", "created_time", "error_count", "id", "in_progress_count", "initial_count", "is_completed", "name", "notification_mode", "notification_result", "notification_status", "notification_uri", "owner_id", "success_count", "total_count", "updated_time"};

        @Override
        public APINodeList<AdAsyncRequestSet> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAsyncRequestSet> parseResponse(String response) throws APIException {
            return AdAsyncRequestSet.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAsyncRequestSet> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAsyncRequestSet> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAsyncRequestSet>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAsyncRequestSet>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAsyncRequestSet>>(){

                public APINodeList<AdAsyncRequestSet> apply(String result) {
                    try {
                        return APIRequestGetAsyncAdRequestSets.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAsyncAdRequestSets(String nodeId, APIContext context) {
            super(context, nodeId, "/asyncadrequestsets", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAsyncAdRequestSets setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAsyncAdRequestSets setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets setIsCompleted(Boolean isCompleted) {
            this.setParam("is_completed", isCompleted);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets setIsCompleted(String isCompleted) {
            this.setParam("is_completed", isCompleted);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAsyncAdRequestSets requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAsyncAdRequestSets requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAsyncAdRequestSets requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAsyncAdRequestSets requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAsyncAdRequestSets requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestCanceledCountField() {
            return this.requestCanceledCountField(true);
        }

        public APIRequestGetAsyncAdRequestSets requestCanceledCountField(boolean value) {
            this.requestField("canceled_count", value);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAsyncAdRequestSets requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestErrorCountField() {
            return this.requestErrorCountField(true);
        }

        public APIRequestGetAsyncAdRequestSets requestErrorCountField(boolean value) {
            this.requestField("error_count", value);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAsyncAdRequestSets requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestInProgressCountField() {
            return this.requestInProgressCountField(true);
        }

        public APIRequestGetAsyncAdRequestSets requestInProgressCountField(boolean value) {
            this.requestField("in_progress_count", value);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestInitialCountField() {
            return this.requestInitialCountField(true);
        }

        public APIRequestGetAsyncAdRequestSets requestInitialCountField(boolean value) {
            this.requestField("initial_count", value);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestIsCompletedField() {
            return this.requestIsCompletedField(true);
        }

        public APIRequestGetAsyncAdRequestSets requestIsCompletedField(boolean value) {
            this.requestField("is_completed", value);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAsyncAdRequestSets requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestNotificationModeField() {
            return this.requestNotificationModeField(true);
        }

        public APIRequestGetAsyncAdRequestSets requestNotificationModeField(boolean value) {
            this.requestField("notification_mode", value);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestNotificationResultField() {
            return this.requestNotificationResultField(true);
        }

        public APIRequestGetAsyncAdRequestSets requestNotificationResultField(boolean value) {
            this.requestField("notification_result", value);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestNotificationStatusField() {
            return this.requestNotificationStatusField(true);
        }

        public APIRequestGetAsyncAdRequestSets requestNotificationStatusField(boolean value) {
            this.requestField("notification_status", value);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestNotificationUriField() {
            return this.requestNotificationUriField(true);
        }

        public APIRequestGetAsyncAdRequestSets requestNotificationUriField(boolean value) {
            this.requestField("notification_uri", value);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestOwnerIdField() {
            return this.requestOwnerIdField(true);
        }

        public APIRequestGetAsyncAdRequestSets requestOwnerIdField(boolean value) {
            this.requestField("owner_id", value);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestSuccessCountField() {
            return this.requestSuccessCountField(true);
        }

        public APIRequestGetAsyncAdRequestSets requestSuccessCountField(boolean value) {
            this.requestField("success_count", value);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestTotalCountField() {
            return this.requestTotalCountField(true);
        }

        public APIRequestGetAsyncAdRequestSets requestTotalCountField(boolean value) {
            this.requestField("total_count", value);
            return this;
        }

        public APIRequestGetAsyncAdRequestSets requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAsyncAdRequestSets requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAsyncRequests
    extends APIRequest<AsyncRequest> {
        APINodeList<AsyncRequest> lastResponse = null;
        public static final String[] PARAMS = new String[]{"status", "type"};
        public static final String[] FIELDS = new String[]{"id", "result", "status", "type"};

        @Override
        public APINodeList<AsyncRequest> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AsyncRequest> parseResponse(String response) throws APIException {
            return AsyncRequest.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AsyncRequest> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AsyncRequest> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AsyncRequest>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AsyncRequest>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AsyncRequest>>(){

                public APINodeList<AsyncRequest> apply(String result) {
                    try {
                        return APIRequestGetAsyncRequests.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAsyncRequests(String nodeId, APIContext context) {
            super(context, nodeId, "/async_requests", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAsyncRequests setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAsyncRequests setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAsyncRequests setStatus(AsyncRequest.EnumStatus status) {
            this.setParam("status", (Object)status);
            return this;
        }

        public APIRequestGetAsyncRequests setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestGetAsyncRequests setType(AsyncRequest.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetAsyncRequests setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetAsyncRequests requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAsyncRequests requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAsyncRequests requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAsyncRequests requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAsyncRequests requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAsyncRequests requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAsyncRequests requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAsyncRequests requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAsyncRequests requestResultField() {
            return this.requestResultField(true);
        }

        public APIRequestGetAsyncRequests requestResultField(boolean value) {
            this.requestField("result", value);
            return this;
        }

        public APIRequestGetAsyncRequests requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetAsyncRequests requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetAsyncRequests requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetAsyncRequests requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAsyncBatchRequest
    extends APIRequest<Campaign> {
        Campaign lastResponse = null;
        public static final String[] PARAMS = new String[]{"name", "adbatch"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Campaign getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Campaign parseResponse(String response) throws APIException {
            return Campaign.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Campaign execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Campaign execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<Campaign> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Campaign> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Campaign>(){

                public Campaign apply(String result) {
                    try {
                        return APIRequestCreateAsyncBatchRequest.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAsyncBatchRequest(String nodeId, APIContext context) {
            super(context, nodeId, "/async_batch_requests", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAsyncBatchRequest setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAsyncBatchRequest setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAsyncBatchRequest setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateAsyncBatchRequest setAdbatch(List<Object> adbatch) {
            this.setParam("adbatch", adbatch);
            return this;
        }

        public APIRequestCreateAsyncBatchRequest setAdbatch(String adbatch) {
            this.setParam("adbatch", adbatch);
            return this;
        }

        public APIRequestCreateAsyncBatchRequest requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAsyncBatchRequest requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAsyncBatchRequest requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAsyncBatchRequest requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAsyncBatchRequest requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAsyncBatchRequest requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAssignedUser
    extends APIRequest<AdAccount> {
        AdAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"user", "tasks"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccount parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccount execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccount>(){

                public AdAccount apply(String result) {
                    try {
                        return APIRequestCreateAssignedUser.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAssignedUser(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_users", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAssignedUser setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAssignedUser setUser(Long user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestCreateAssignedUser setUser(String user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestCreateAssignedUser setTasks(List<EnumTasks> tasks) {
            this.setParam("tasks", tasks);
            return this;
        }

        public APIRequestCreateAssignedUser setTasks(String tasks) {
            this.setParam("tasks", tasks);
            return this;
        }

        public APIRequestCreateAssignedUser requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAssignedUser requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAssignedUser requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAssignedUsers
    extends APIRequest<AssignedUser> {
        APINodeList<AssignedUser> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[]{"business", "id", "name", "user_type"};

        @Override
        public APINodeList<AssignedUser> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AssignedUser> parseResponse(String response) throws APIException {
            return AssignedUser.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AssignedUser> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AssignedUser> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AssignedUser>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AssignedUser>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AssignedUser>>(){

                public APINodeList<AssignedUser> apply(String result) {
                    try {
                        return APIRequestGetAssignedUsers.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAssignedUsers(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_users", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAssignedUsers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAssignedUsers setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestGetAssignedUsers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAssignedUsers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAssignedUsers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAssignedUsers requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAssignedUsers requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAssignedUsers requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAssignedUsers requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAssignedUsers requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAssignedUsers requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAssignedUsers requestUserTypeField() {
            return this.requestUserTypeField(true);
        }

        public APIRequestGetAssignedUsers requestUserTypeField(boolean value) {
            this.requestField("user_type", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteAssignedUsers
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"user"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteAssignedUsers.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteAssignedUsers(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_users", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteAssignedUsers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteAssignedUsers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteAssignedUsers setUser(Long user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestDeleteAssignedUsers setUser(String user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestDeleteAssignedUsers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteAssignedUsers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAssignedUsers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteAssignedUsers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAssignedUsers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteAssignedUsers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetApplications
    extends APIRequest<Application> {
        APINodeList<Application> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"an_ad_space_limit", "an_platforms", "android_key_hash", "android_sdk_error_categories", "app_domains", "app_events_feature_bitmask", "app_events_session_timeout", "app_install_tracked", "app_name", "app_signals_binding_ios", "app_type", "auth_dialog_data_help_url", "auth_dialog_headline", "auth_dialog_perms_explanation", "auth_referral_default_activity_privacy", "auth_referral_enabled", "auth_referral_extended_perms", "auth_referral_friend_perms", "auth_referral_response_type", "auth_referral_user_perms", "auto_event_mapping_android", "auto_event_mapping_ios", "auto_event_setup_enabled", "business", "canvas_fluid_height", "canvas_fluid_width", "canvas_url", "category", "client_config", "company", "configured_ios_sso", "contact_email", "context", "created_time", "creator_uid", "daily_active_users", "daily_active_users_rank", "deauth_callback_url", "default_share_mode", "description", "financial_id", "gdpv4_chrome_custom_tabs_enabled", "gdpv4_enabled", "gdpv4_nux_content", "gdpv4_nux_enabled", "has_messenger_product", "hosting_url", "icon_url", "id", "ios_bundle_id", "ios_sdk_dialog_flows", "ios_sdk_error_categories", "ios_sfvc_attr", "ios_supports_native_proxy_auth_flow", "ios_supports_system_auth", "ipad_app_store_id", "iphone_app_store_id", "is_viewer_admin", "latest_sdk_version", "link", "logging_token", "login_secret", "logo_url", "migrations", "mobile_profile_section_url", "mobile_web_url", "monthly_active_users", "monthly_active_users_rank", "name", "namespace", "object_store_urls", "page_tab_default_name", "page_tab_url", "photo_url", "privacy_policy_url", "profile_section_url", "property_id", "real_time_mode_devices", "restrictions", "sdk_update_message", "seamless_login", "secure_canvas_url", "secure_page_tab_url", "server_ip_whitelist", "smart_login_bookmark_icon_url", "smart_login_menu_icon_url", "social_discovery", "subcategory", "supported_platforms", "supports_apprequests_fast_app_switch", "supports_attribution", "supports_implicit_sdk_logging", "suppress_native_ios_gdp", "terms_of_service_url", "url_scheme_suffix", "user_support_email", "user_support_url", "website_url", "weekly_active_users"};

        @Override
        public APINodeList<Application> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Application> parseResponse(String response) throws APIException {
            return Application.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Application> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Application> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Application>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Application>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Application>>(){

                public APINodeList<Application> apply(String result) {
                    try {
                        return APIRequestGetApplications.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetApplications(String nodeId, APIContext context) {
            super(context, nodeId, "/applications", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetApplications setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetApplications setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetApplications requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetApplications requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetApplications requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetApplications requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetApplications requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetApplications requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetApplications requestAnAdSpaceLimitField() {
            return this.requestAnAdSpaceLimitField(true);
        }

        public APIRequestGetApplications requestAnAdSpaceLimitField(boolean value) {
            this.requestField("an_ad_space_limit", value);
            return this;
        }

        public APIRequestGetApplications requestAnPlatformsField() {
            return this.requestAnPlatformsField(true);
        }

        public APIRequestGetApplications requestAnPlatformsField(boolean value) {
            this.requestField("an_platforms", value);
            return this;
        }

        public APIRequestGetApplications requestAndroidKeyHashField() {
            return this.requestAndroidKeyHashField(true);
        }

        public APIRequestGetApplications requestAndroidKeyHashField(boolean value) {
            this.requestField("android_key_hash", value);
            return this;
        }

        public APIRequestGetApplications requestAndroidSdkErrorCategoriesField() {
            return this.requestAndroidSdkErrorCategoriesField(true);
        }

        public APIRequestGetApplications requestAndroidSdkErrorCategoriesField(boolean value) {
            this.requestField("android_sdk_error_categories", value);
            return this;
        }

        public APIRequestGetApplications requestAppDomainsField() {
            return this.requestAppDomainsField(true);
        }

        public APIRequestGetApplications requestAppDomainsField(boolean value) {
            this.requestField("app_domains", value);
            return this;
        }

        public APIRequestGetApplications requestAppEventsFeatureBitmaskField() {
            return this.requestAppEventsFeatureBitmaskField(true);
        }

        public APIRequestGetApplications requestAppEventsFeatureBitmaskField(boolean value) {
            this.requestField("app_events_feature_bitmask", value);
            return this;
        }

        public APIRequestGetApplications requestAppEventsSessionTimeoutField() {
            return this.requestAppEventsSessionTimeoutField(true);
        }

        public APIRequestGetApplications requestAppEventsSessionTimeoutField(boolean value) {
            this.requestField("app_events_session_timeout", value);
            return this;
        }

        public APIRequestGetApplications requestAppInstallTrackedField() {
            return this.requestAppInstallTrackedField(true);
        }

        public APIRequestGetApplications requestAppInstallTrackedField(boolean value) {
            this.requestField("app_install_tracked", value);
            return this;
        }

        public APIRequestGetApplications requestAppNameField() {
            return this.requestAppNameField(true);
        }

        public APIRequestGetApplications requestAppNameField(boolean value) {
            this.requestField("app_name", value);
            return this;
        }

        public APIRequestGetApplications requestAppSignalsBindingIosField() {
            return this.requestAppSignalsBindingIosField(true);
        }

        public APIRequestGetApplications requestAppSignalsBindingIosField(boolean value) {
            this.requestField("app_signals_binding_ios", value);
            return this;
        }

        public APIRequestGetApplications requestAppTypeField() {
            return this.requestAppTypeField(true);
        }

        public APIRequestGetApplications requestAppTypeField(boolean value) {
            this.requestField("app_type", value);
            return this;
        }

        public APIRequestGetApplications requestAuthDialogDataHelpUrlField() {
            return this.requestAuthDialogDataHelpUrlField(true);
        }

        public APIRequestGetApplications requestAuthDialogDataHelpUrlField(boolean value) {
            this.requestField("auth_dialog_data_help_url", value);
            return this;
        }

        public APIRequestGetApplications requestAuthDialogHeadlineField() {
            return this.requestAuthDialogHeadlineField(true);
        }

        public APIRequestGetApplications requestAuthDialogHeadlineField(boolean value) {
            this.requestField("auth_dialog_headline", value);
            return this;
        }

        public APIRequestGetApplications requestAuthDialogPermsExplanationField() {
            return this.requestAuthDialogPermsExplanationField(true);
        }

        public APIRequestGetApplications requestAuthDialogPermsExplanationField(boolean value) {
            this.requestField("auth_dialog_perms_explanation", value);
            return this;
        }

        public APIRequestGetApplications requestAuthReferralDefaultActivityPrivacyField() {
            return this.requestAuthReferralDefaultActivityPrivacyField(true);
        }

        public APIRequestGetApplications requestAuthReferralDefaultActivityPrivacyField(boolean value) {
            this.requestField("auth_referral_default_activity_privacy", value);
            return this;
        }

        public APIRequestGetApplications requestAuthReferralEnabledField() {
            return this.requestAuthReferralEnabledField(true);
        }

        public APIRequestGetApplications requestAuthReferralEnabledField(boolean value) {
            this.requestField("auth_referral_enabled", value);
            return this;
        }

        public APIRequestGetApplications requestAuthReferralExtendedPermsField() {
            return this.requestAuthReferralExtendedPermsField(true);
        }

        public APIRequestGetApplications requestAuthReferralExtendedPermsField(boolean value) {
            this.requestField("auth_referral_extended_perms", value);
            return this;
        }

        public APIRequestGetApplications requestAuthReferralFriendPermsField() {
            return this.requestAuthReferralFriendPermsField(true);
        }

        public APIRequestGetApplications requestAuthReferralFriendPermsField(boolean value) {
            this.requestField("auth_referral_friend_perms", value);
            return this;
        }

        public APIRequestGetApplications requestAuthReferralResponseTypeField() {
            return this.requestAuthReferralResponseTypeField(true);
        }

        public APIRequestGetApplications requestAuthReferralResponseTypeField(boolean value) {
            this.requestField("auth_referral_response_type", value);
            return this;
        }

        public APIRequestGetApplications requestAuthReferralUserPermsField() {
            return this.requestAuthReferralUserPermsField(true);
        }

        public APIRequestGetApplications requestAuthReferralUserPermsField(boolean value) {
            this.requestField("auth_referral_user_perms", value);
            return this;
        }

        public APIRequestGetApplications requestAutoEventMappingAndroidField() {
            return this.requestAutoEventMappingAndroidField(true);
        }

        public APIRequestGetApplications requestAutoEventMappingAndroidField(boolean value) {
            this.requestField("auto_event_mapping_android", value);
            return this;
        }

        public APIRequestGetApplications requestAutoEventMappingIosField() {
            return this.requestAutoEventMappingIosField(true);
        }

        public APIRequestGetApplications requestAutoEventMappingIosField(boolean value) {
            this.requestField("auto_event_mapping_ios", value);
            return this;
        }

        public APIRequestGetApplications requestAutoEventSetupEnabledField() {
            return this.requestAutoEventSetupEnabledField(true);
        }

        public APIRequestGetApplications requestAutoEventSetupEnabledField(boolean value) {
            this.requestField("auto_event_setup_enabled", value);
            return this;
        }

        public APIRequestGetApplications requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetApplications requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetApplications requestCanvasFluidHeightField() {
            return this.requestCanvasFluidHeightField(true);
        }

        public APIRequestGetApplications requestCanvasFluidHeightField(boolean value) {
            this.requestField("canvas_fluid_height", value);
            return this;
        }

        public APIRequestGetApplications requestCanvasFluidWidthField() {
            return this.requestCanvasFluidWidthField(true);
        }

        public APIRequestGetApplications requestCanvasFluidWidthField(boolean value) {
            this.requestField("canvas_fluid_width", value);
            return this;
        }

        public APIRequestGetApplications requestCanvasUrlField() {
            return this.requestCanvasUrlField(true);
        }

        public APIRequestGetApplications requestCanvasUrlField(boolean value) {
            this.requestField("canvas_url", value);
            return this;
        }

        public APIRequestGetApplications requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetApplications requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetApplications requestClientConfigField() {
            return this.requestClientConfigField(true);
        }

        public APIRequestGetApplications requestClientConfigField(boolean value) {
            this.requestField("client_config", value);
            return this;
        }

        public APIRequestGetApplications requestCompanyField() {
            return this.requestCompanyField(true);
        }

        public APIRequestGetApplications requestCompanyField(boolean value) {
            this.requestField("company", value);
            return this;
        }

        public APIRequestGetApplications requestConfiguredIosSsoField() {
            return this.requestConfiguredIosSsoField(true);
        }

        public APIRequestGetApplications requestConfiguredIosSsoField(boolean value) {
            this.requestField("configured_ios_sso", value);
            return this;
        }

        public APIRequestGetApplications requestContactEmailField() {
            return this.requestContactEmailField(true);
        }

        public APIRequestGetApplications requestContactEmailField(boolean value) {
            this.requestField("contact_email", value);
            return this;
        }

        public APIRequestGetApplications requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetApplications requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetApplications requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetApplications requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetApplications requestCreatorUidField() {
            return this.requestCreatorUidField(true);
        }

        public APIRequestGetApplications requestCreatorUidField(boolean value) {
            this.requestField("creator_uid", value);
            return this;
        }

        public APIRequestGetApplications requestDailyActiveUsersField() {
            return this.requestDailyActiveUsersField(true);
        }

        public APIRequestGetApplications requestDailyActiveUsersField(boolean value) {
            this.requestField("daily_active_users", value);
            return this;
        }

        public APIRequestGetApplications requestDailyActiveUsersRankField() {
            return this.requestDailyActiveUsersRankField(true);
        }

        public APIRequestGetApplications requestDailyActiveUsersRankField(boolean value) {
            this.requestField("daily_active_users_rank", value);
            return this;
        }

        public APIRequestGetApplications requestDeauthCallbackUrlField() {
            return this.requestDeauthCallbackUrlField(true);
        }

        public APIRequestGetApplications requestDeauthCallbackUrlField(boolean value) {
            this.requestField("deauth_callback_url", value);
            return this;
        }

        public APIRequestGetApplications requestDefaultShareModeField() {
            return this.requestDefaultShareModeField(true);
        }

        public APIRequestGetApplications requestDefaultShareModeField(boolean value) {
            this.requestField("default_share_mode", value);
            return this;
        }

        public APIRequestGetApplications requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetApplications requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetApplications requestFinancialIdField() {
            return this.requestFinancialIdField(true);
        }

        public APIRequestGetApplications requestFinancialIdField(boolean value) {
            this.requestField("financial_id", value);
            return this;
        }

        public APIRequestGetApplications requestGdpv4ChromeCustomTabsEnabledField() {
            return this.requestGdpv4ChromeCustomTabsEnabledField(true);
        }

        public APIRequestGetApplications requestGdpv4ChromeCustomTabsEnabledField(boolean value) {
            this.requestField("gdpv4_chrome_custom_tabs_enabled", value);
            return this;
        }

        public APIRequestGetApplications requestGdpv4EnabledField() {
            return this.requestGdpv4EnabledField(true);
        }

        public APIRequestGetApplications requestGdpv4EnabledField(boolean value) {
            this.requestField("gdpv4_enabled", value);
            return this;
        }

        public APIRequestGetApplications requestGdpv4NuxContentField() {
            return this.requestGdpv4NuxContentField(true);
        }

        public APIRequestGetApplications requestGdpv4NuxContentField(boolean value) {
            this.requestField("gdpv4_nux_content", value);
            return this;
        }

        public APIRequestGetApplications requestGdpv4NuxEnabledField() {
            return this.requestGdpv4NuxEnabledField(true);
        }

        public APIRequestGetApplications requestGdpv4NuxEnabledField(boolean value) {
            this.requestField("gdpv4_nux_enabled", value);
            return this;
        }

        public APIRequestGetApplications requestHasMessengerProductField() {
            return this.requestHasMessengerProductField(true);
        }

        public APIRequestGetApplications requestHasMessengerProductField(boolean value) {
            this.requestField("has_messenger_product", value);
            return this;
        }

        public APIRequestGetApplications requestHostingUrlField() {
            return this.requestHostingUrlField(true);
        }

        public APIRequestGetApplications requestHostingUrlField(boolean value) {
            this.requestField("hosting_url", value);
            return this;
        }

        public APIRequestGetApplications requestIconUrlField() {
            return this.requestIconUrlField(true);
        }

        public APIRequestGetApplications requestIconUrlField(boolean value) {
            this.requestField("icon_url", value);
            return this;
        }

        public APIRequestGetApplications requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetApplications requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetApplications requestIosBundleIdField() {
            return this.requestIosBundleIdField(true);
        }

        public APIRequestGetApplications requestIosBundleIdField(boolean value) {
            this.requestField("ios_bundle_id", value);
            return this;
        }

        public APIRequestGetApplications requestIosSdkDialogFlowsField() {
            return this.requestIosSdkDialogFlowsField(true);
        }

        public APIRequestGetApplications requestIosSdkDialogFlowsField(boolean value) {
            this.requestField("ios_sdk_dialog_flows", value);
            return this;
        }

        public APIRequestGetApplications requestIosSdkErrorCategoriesField() {
            return this.requestIosSdkErrorCategoriesField(true);
        }

        public APIRequestGetApplications requestIosSdkErrorCategoriesField(boolean value) {
            this.requestField("ios_sdk_error_categories", value);
            return this;
        }

        public APIRequestGetApplications requestIosSfvcAttrField() {
            return this.requestIosSfvcAttrField(true);
        }

        public APIRequestGetApplications requestIosSfvcAttrField(boolean value) {
            this.requestField("ios_sfvc_attr", value);
            return this;
        }

        public APIRequestGetApplications requestIosSupportsNativeProxyAuthFlowField() {
            return this.requestIosSupportsNativeProxyAuthFlowField(true);
        }

        public APIRequestGetApplications requestIosSupportsNativeProxyAuthFlowField(boolean value) {
            this.requestField("ios_supports_native_proxy_auth_flow", value);
            return this;
        }

        public APIRequestGetApplications requestIosSupportsSystemAuthField() {
            return this.requestIosSupportsSystemAuthField(true);
        }

        public APIRequestGetApplications requestIosSupportsSystemAuthField(boolean value) {
            this.requestField("ios_supports_system_auth", value);
            return this;
        }

        public APIRequestGetApplications requestIpadAppStoreIdField() {
            return this.requestIpadAppStoreIdField(true);
        }

        public APIRequestGetApplications requestIpadAppStoreIdField(boolean value) {
            this.requestField("ipad_app_store_id", value);
            return this;
        }

        public APIRequestGetApplications requestIphoneAppStoreIdField() {
            return this.requestIphoneAppStoreIdField(true);
        }

        public APIRequestGetApplications requestIphoneAppStoreIdField(boolean value) {
            this.requestField("iphone_app_store_id", value);
            return this;
        }

        public APIRequestGetApplications requestIsViewerAdminField() {
            return this.requestIsViewerAdminField(true);
        }

        public APIRequestGetApplications requestIsViewerAdminField(boolean value) {
            this.requestField("is_viewer_admin", value);
            return this;
        }

        public APIRequestGetApplications requestLatestSdkVersionField() {
            return this.requestLatestSdkVersionField(true);
        }

        public APIRequestGetApplications requestLatestSdkVersionField(boolean value) {
            this.requestField("latest_sdk_version", value);
            return this;
        }

        public APIRequestGetApplications requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetApplications requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetApplications requestLoggingTokenField() {
            return this.requestLoggingTokenField(true);
        }

        public APIRequestGetApplications requestLoggingTokenField(boolean value) {
            this.requestField("logging_token", value);
            return this;
        }

        public APIRequestGetApplications requestLoginSecretField() {
            return this.requestLoginSecretField(true);
        }

        public APIRequestGetApplications requestLoginSecretField(boolean value) {
            this.requestField("login_secret", value);
            return this;
        }

        public APIRequestGetApplications requestLogoUrlField() {
            return this.requestLogoUrlField(true);
        }

        public APIRequestGetApplications requestLogoUrlField(boolean value) {
            this.requestField("logo_url", value);
            return this;
        }

        public APIRequestGetApplications requestMigrationsField() {
            return this.requestMigrationsField(true);
        }

        public APIRequestGetApplications requestMigrationsField(boolean value) {
            this.requestField("migrations", value);
            return this;
        }

        public APIRequestGetApplications requestMobileProfileSectionUrlField() {
            return this.requestMobileProfileSectionUrlField(true);
        }

        public APIRequestGetApplications requestMobileProfileSectionUrlField(boolean value) {
            this.requestField("mobile_profile_section_url", value);
            return this;
        }

        public APIRequestGetApplications requestMobileWebUrlField() {
            return this.requestMobileWebUrlField(true);
        }

        public APIRequestGetApplications requestMobileWebUrlField(boolean value) {
            this.requestField("mobile_web_url", value);
            return this;
        }

        public APIRequestGetApplications requestMonthlyActiveUsersField() {
            return this.requestMonthlyActiveUsersField(true);
        }

        public APIRequestGetApplications requestMonthlyActiveUsersField(boolean value) {
            this.requestField("monthly_active_users", value);
            return this;
        }

        public APIRequestGetApplications requestMonthlyActiveUsersRankField() {
            return this.requestMonthlyActiveUsersRankField(true);
        }

        public APIRequestGetApplications requestMonthlyActiveUsersRankField(boolean value) {
            this.requestField("monthly_active_users_rank", value);
            return this;
        }

        public APIRequestGetApplications requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetApplications requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetApplications requestNamespaceField() {
            return this.requestNamespaceField(true);
        }

        public APIRequestGetApplications requestNamespaceField(boolean value) {
            this.requestField("namespace", value);
            return this;
        }

        public APIRequestGetApplications requestObjectStoreUrlsField() {
            return this.requestObjectStoreUrlsField(true);
        }

        public APIRequestGetApplications requestObjectStoreUrlsField(boolean value) {
            this.requestField("object_store_urls", value);
            return this;
        }

        public APIRequestGetApplications requestPageTabDefaultNameField() {
            return this.requestPageTabDefaultNameField(true);
        }

        public APIRequestGetApplications requestPageTabDefaultNameField(boolean value) {
            this.requestField("page_tab_default_name", value);
            return this;
        }

        public APIRequestGetApplications requestPageTabUrlField() {
            return this.requestPageTabUrlField(true);
        }

        public APIRequestGetApplications requestPageTabUrlField(boolean value) {
            this.requestField("page_tab_url", value);
            return this;
        }

        public APIRequestGetApplications requestPhotoUrlField() {
            return this.requestPhotoUrlField(true);
        }

        public APIRequestGetApplications requestPhotoUrlField(boolean value) {
            this.requestField("photo_url", value);
            return this;
        }

        public APIRequestGetApplications requestPrivacyPolicyUrlField() {
            return this.requestPrivacyPolicyUrlField(true);
        }

        public APIRequestGetApplications requestPrivacyPolicyUrlField(boolean value) {
            this.requestField("privacy_policy_url", value);
            return this;
        }

        public APIRequestGetApplications requestProfileSectionUrlField() {
            return this.requestProfileSectionUrlField(true);
        }

        public APIRequestGetApplications requestProfileSectionUrlField(boolean value) {
            this.requestField("profile_section_url", value);
            return this;
        }

        public APIRequestGetApplications requestPropertyIdField() {
            return this.requestPropertyIdField(true);
        }

        public APIRequestGetApplications requestPropertyIdField(boolean value) {
            this.requestField("property_id", value);
            return this;
        }

        public APIRequestGetApplications requestRealTimeModeDevicesField() {
            return this.requestRealTimeModeDevicesField(true);
        }

        public APIRequestGetApplications requestRealTimeModeDevicesField(boolean value) {
            this.requestField("real_time_mode_devices", value);
            return this;
        }

        public APIRequestGetApplications requestRestrictionsField() {
            return this.requestRestrictionsField(true);
        }

        public APIRequestGetApplications requestRestrictionsField(boolean value) {
            this.requestField("restrictions", value);
            return this;
        }

        public APIRequestGetApplications requestSdkUpdateMessageField() {
            return this.requestSdkUpdateMessageField(true);
        }

        public APIRequestGetApplications requestSdkUpdateMessageField(boolean value) {
            this.requestField("sdk_update_message", value);
            return this;
        }

        public APIRequestGetApplications requestSeamlessLoginField() {
            return this.requestSeamlessLoginField(true);
        }

        public APIRequestGetApplications requestSeamlessLoginField(boolean value) {
            this.requestField("seamless_login", value);
            return this;
        }

        public APIRequestGetApplications requestSecureCanvasUrlField() {
            return this.requestSecureCanvasUrlField(true);
        }

        public APIRequestGetApplications requestSecureCanvasUrlField(boolean value) {
            this.requestField("secure_canvas_url", value);
            return this;
        }

        public APIRequestGetApplications requestSecurePageTabUrlField() {
            return this.requestSecurePageTabUrlField(true);
        }

        public APIRequestGetApplications requestSecurePageTabUrlField(boolean value) {
            this.requestField("secure_page_tab_url", value);
            return this;
        }

        public APIRequestGetApplications requestServerIpWhitelistField() {
            return this.requestServerIpWhitelistField(true);
        }

        public APIRequestGetApplications requestServerIpWhitelistField(boolean value) {
            this.requestField("server_ip_whitelist", value);
            return this;
        }

        public APIRequestGetApplications requestSmartLoginBookmarkIconUrlField() {
            return this.requestSmartLoginBookmarkIconUrlField(true);
        }

        public APIRequestGetApplications requestSmartLoginBookmarkIconUrlField(boolean value) {
            this.requestField("smart_login_bookmark_icon_url", value);
            return this;
        }

        public APIRequestGetApplications requestSmartLoginMenuIconUrlField() {
            return this.requestSmartLoginMenuIconUrlField(true);
        }

        public APIRequestGetApplications requestSmartLoginMenuIconUrlField(boolean value) {
            this.requestField("smart_login_menu_icon_url", value);
            return this;
        }

        public APIRequestGetApplications requestSocialDiscoveryField() {
            return this.requestSocialDiscoveryField(true);
        }

        public APIRequestGetApplications requestSocialDiscoveryField(boolean value) {
            this.requestField("social_discovery", value);
            return this;
        }

        public APIRequestGetApplications requestSubcategoryField() {
            return this.requestSubcategoryField(true);
        }

        public APIRequestGetApplications requestSubcategoryField(boolean value) {
            this.requestField("subcategory", value);
            return this;
        }

        public APIRequestGetApplications requestSupportedPlatformsField() {
            return this.requestSupportedPlatformsField(true);
        }

        public APIRequestGetApplications requestSupportedPlatformsField(boolean value) {
            this.requestField("supported_platforms", value);
            return this;
        }

        public APIRequestGetApplications requestSupportsApprequestsFastAppSwitchField() {
            return this.requestSupportsApprequestsFastAppSwitchField(true);
        }

        public APIRequestGetApplications requestSupportsApprequestsFastAppSwitchField(boolean value) {
            this.requestField("supports_apprequests_fast_app_switch", value);
            return this;
        }

        public APIRequestGetApplications requestSupportsAttributionField() {
            return this.requestSupportsAttributionField(true);
        }

        public APIRequestGetApplications requestSupportsAttributionField(boolean value) {
            this.requestField("supports_attribution", value);
            return this;
        }

        public APIRequestGetApplications requestSupportsImplicitSdkLoggingField() {
            return this.requestSupportsImplicitSdkLoggingField(true);
        }

        public APIRequestGetApplications requestSupportsImplicitSdkLoggingField(boolean value) {
            this.requestField("supports_implicit_sdk_logging", value);
            return this;
        }

        public APIRequestGetApplications requestSuppressNativeIosGdpField() {
            return this.requestSuppressNativeIosGdpField(true);
        }

        public APIRequestGetApplications requestSuppressNativeIosGdpField(boolean value) {
            this.requestField("suppress_native_ios_gdp", value);
            return this;
        }

        public APIRequestGetApplications requestTermsOfServiceUrlField() {
            return this.requestTermsOfServiceUrlField(true);
        }

        public APIRequestGetApplications requestTermsOfServiceUrlField(boolean value) {
            this.requestField("terms_of_service_url", value);
            return this;
        }

        public APIRequestGetApplications requestUrlSchemeSuffixField() {
            return this.requestUrlSchemeSuffixField(true);
        }

        public APIRequestGetApplications requestUrlSchemeSuffixField(boolean value) {
            this.requestField("url_scheme_suffix", value);
            return this;
        }

        public APIRequestGetApplications requestUserSupportEmailField() {
            return this.requestUserSupportEmailField(true);
        }

        public APIRequestGetApplications requestUserSupportEmailField(boolean value) {
            this.requestField("user_support_email", value);
            return this;
        }

        public APIRequestGetApplications requestUserSupportUrlField() {
            return this.requestUserSupportUrlField(true);
        }

        public APIRequestGetApplications requestUserSupportUrlField(boolean value) {
            this.requestField("user_support_url", value);
            return this;
        }

        public APIRequestGetApplications requestWebsiteUrlField() {
            return this.requestWebsiteUrlField(true);
        }

        public APIRequestGetApplications requestWebsiteUrlField(boolean value) {
            this.requestField("website_url", value);
            return this;
        }

        public APIRequestGetApplications requestWeeklyActiveUsersField() {
            return this.requestWeeklyActiveUsersField(true);
        }

        public APIRequestGetApplications requestWeeklyActiveUsersField(boolean value) {
            this.requestField("weekly_active_users", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAgency
    extends APIRequest<AdAccount> {
        AdAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"business", "permitted_tasks"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccount parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccount execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccount>(){

                public AdAccount apply(String result) {
                    try {
                        return APIRequestCreateAgency.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAgency(String nodeId, APIContext context) {
            super(context, nodeId, "/agencies", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAgency setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAgency setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAgency setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestCreateAgency setPermittedTasks(List<EnumPermittedTasks> permittedTasks) {
            this.setParam("permitted_tasks", permittedTasks);
            return this;
        }

        public APIRequestCreateAgency setPermittedTasks(String permittedTasks) {
            this.setParam("permitted_tasks", permittedTasks);
            return this;
        }

        public APIRequestCreateAgency requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAgency requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAgency requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAgency requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAgency requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAgency requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAgencies
    extends APIRequest<Business> {
        APINodeList<Business> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"block_offline_analytics", "created_by", "created_time", "extended_updated_time", "id", "is_hidden", "is_instagram_enabled_in_fb_analytics", "link", "name", "primary_page", "profile_picture_uri", "timezone_id", "two_factor_type", "updated_by", "updated_time", "verification_status", "vertical", "vertical_id"};

        @Override
        public APINodeList<Business> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Business> parseResponse(String response) throws APIException {
            return Business.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Business> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Business> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Business>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Business>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Business>>(){

                public APINodeList<Business> apply(String result) {
                    try {
                        return APIRequestGetAgencies.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAgencies(String nodeId, APIContext context) {
            super(context, nodeId, "/agencies", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAgencies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAgencies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAgencies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAgencies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAgencies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAgencies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAgencies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAgencies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAgencies requestBlockOfflineAnalyticsField() {
            return this.requestBlockOfflineAnalyticsField(true);
        }

        public APIRequestGetAgencies requestBlockOfflineAnalyticsField(boolean value) {
            this.requestField("block_offline_analytics", value);
            return this;
        }

        public APIRequestGetAgencies requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGetAgencies requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGetAgencies requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAgencies requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAgencies requestExtendedUpdatedTimeField() {
            return this.requestExtendedUpdatedTimeField(true);
        }

        public APIRequestGetAgencies requestExtendedUpdatedTimeField(boolean value) {
            this.requestField("extended_updated_time", value);
            return this;
        }

        public APIRequestGetAgencies requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAgencies requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAgencies requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetAgencies requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetAgencies requestIsInstagramEnabledInFbAnalyticsField() {
            return this.requestIsInstagramEnabledInFbAnalyticsField(true);
        }

        public APIRequestGetAgencies requestIsInstagramEnabledInFbAnalyticsField(boolean value) {
            this.requestField("is_instagram_enabled_in_fb_analytics", value);
            return this;
        }

        public APIRequestGetAgencies requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetAgencies requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetAgencies requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAgencies requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAgencies requestPrimaryPageField() {
            return this.requestPrimaryPageField(true);
        }

        public APIRequestGetAgencies requestPrimaryPageField(boolean value) {
            this.requestField("primary_page", value);
            return this;
        }

        public APIRequestGetAgencies requestProfilePictureUriField() {
            return this.requestProfilePictureUriField(true);
        }

        public APIRequestGetAgencies requestProfilePictureUriField(boolean value) {
            this.requestField("profile_picture_uri", value);
            return this;
        }

        public APIRequestGetAgencies requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetAgencies requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetAgencies requestTwoFactorTypeField() {
            return this.requestTwoFactorTypeField(true);
        }

        public APIRequestGetAgencies requestTwoFactorTypeField(boolean value) {
            this.requestField("two_factor_type", value);
            return this;
        }

        public APIRequestGetAgencies requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGetAgencies requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGetAgencies requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAgencies requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetAgencies requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetAgencies requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetAgencies requestVerticalField() {
            return this.requestVerticalField(true);
        }

        public APIRequestGetAgencies requestVerticalField(boolean value) {
            this.requestField("vertical", value);
            return this;
        }

        public APIRequestGetAgencies requestVerticalIdField() {
            return this.requestVerticalIdField(true);
        }

        public APIRequestGetAgencies requestVerticalIdField(boolean value) {
            this.requestField("vertical_id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteAgencies
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteAgencies.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteAgencies(String nodeId, APIContext context) {
            super(context, nodeId, "/agencies", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteAgencies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteAgencies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteAgencies setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestDeleteAgencies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteAgencies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAgencies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteAgencies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAgencies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteAgencies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAffectedAdSets
    extends APIRequest<AdSet> {
        APINodeList<AdSet> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "ad_keywords", "adasset_feed", "adlabels", "adset_schedule", "asset_feed_id", "attribution_spec", "best_creative", "bid_adjustments", "bid_amount", "bid_constraints", "bid_info", "bid_strategy", "billing_event", "budget_remaining", "campaign", "campaign_id", "configured_status", "created_time", "creative_sequence", "daily_budget", "daily_min_spend_target", "daily_spend_cap", "destination_type", "effective_status", "end_time", "frequency_cap", "frequency_cap_reset_period", "frequency_control_specs", "full_funnel_exploration_mode", "id", "instagram_actor_id", "is_autobid", "is_average_price_pacing", "is_dynamic_creative", "is_dynamic_creative_optimization", "issues_info", "lifetime_budget", "lifetime_frequency_cap", "lifetime_imps", "lifetime_min_spend_target", "lifetime_spend_cap", "name", "optimization_goal", "pacing_type", "promoted_object", "recommendations", "recurring_budget_semantics", "review_feedback", "rf_prediction_id", "rtb_flag", "source_adset", "source_adset_id", "start_time", "status", "targeting", "time_based_ad_rotation_id_blocks", "time_based_ad_rotation_intervals", "tracking_specs", "updated_time", "use_new_app_click"};

        @Override
        public APINodeList<AdSet> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdSet> parseResponse(String response) throws APIException {
            return AdSet.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdSet> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdSet> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdSet>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdSet>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdSet>>(){

                public APINodeList<AdSet> apply(String result) {
                    try {
                        return APIRequestGetAffectedAdSets.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAffectedAdSets(String nodeId, APIContext context) {
            super(context, nodeId, "/affectedadsets", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAffectedAdSets setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAffectedAdSets setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAffectedAdSets requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAffectedAdSets requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAffectedAdSets requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAffectedAdSets requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAffectedAdSets requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAffectedAdSets requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAffectedAdSets requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestAdKeywordsField() {
            return this.requestAdKeywordsField(true);
        }

        public APIRequestGetAffectedAdSets requestAdKeywordsField(boolean value) {
            this.requestField("ad_keywords", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestAdassetFeedField() {
            return this.requestAdassetFeedField(true);
        }

        public APIRequestGetAffectedAdSets requestAdassetFeedField(boolean value) {
            this.requestField("adasset_feed", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGetAffectedAdSets requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestAdsetScheduleField() {
            return this.requestAdsetScheduleField(true);
        }

        public APIRequestGetAffectedAdSets requestAdsetScheduleField(boolean value) {
            this.requestField("adset_schedule", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestAssetFeedIdField() {
            return this.requestAssetFeedIdField(true);
        }

        public APIRequestGetAffectedAdSets requestAssetFeedIdField(boolean value) {
            this.requestField("asset_feed_id", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetAffectedAdSets requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestBestCreativeField() {
            return this.requestBestCreativeField(true);
        }

        public APIRequestGetAffectedAdSets requestBestCreativeField(boolean value) {
            this.requestField("best_creative", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestBidAdjustmentsField() {
            return this.requestBidAdjustmentsField(true);
        }

        public APIRequestGetAffectedAdSets requestBidAdjustmentsField(boolean value) {
            this.requestField("bid_adjustments", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestBidAmountField() {
            return this.requestBidAmountField(true);
        }

        public APIRequestGetAffectedAdSets requestBidAmountField(boolean value) {
            this.requestField("bid_amount", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestBidConstraintsField() {
            return this.requestBidConstraintsField(true);
        }

        public APIRequestGetAffectedAdSets requestBidConstraintsField(boolean value) {
            this.requestField("bid_constraints", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestBidInfoField() {
            return this.requestBidInfoField(true);
        }

        public APIRequestGetAffectedAdSets requestBidInfoField(boolean value) {
            this.requestField("bid_info", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestBidStrategyField() {
            return this.requestBidStrategyField(true);
        }

        public APIRequestGetAffectedAdSets requestBidStrategyField(boolean value) {
            this.requestField("bid_strategy", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestBillingEventField() {
            return this.requestBillingEventField(true);
        }

        public APIRequestGetAffectedAdSets requestBillingEventField(boolean value) {
            this.requestField("billing_event", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestBudgetRemainingField() {
            return this.requestBudgetRemainingField(true);
        }

        public APIRequestGetAffectedAdSets requestBudgetRemainingField(boolean value) {
            this.requestField("budget_remaining", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestCampaignField() {
            return this.requestCampaignField(true);
        }

        public APIRequestGetAffectedAdSets requestCampaignField(boolean value) {
            this.requestField("campaign", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGetAffectedAdSets requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestConfiguredStatusField() {
            return this.requestConfiguredStatusField(true);
        }

        public APIRequestGetAffectedAdSets requestConfiguredStatusField(boolean value) {
            this.requestField("configured_status", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAffectedAdSets requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestCreativeSequenceField() {
            return this.requestCreativeSequenceField(true);
        }

        public APIRequestGetAffectedAdSets requestCreativeSequenceField(boolean value) {
            this.requestField("creative_sequence", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestDailyBudgetField() {
            return this.requestDailyBudgetField(true);
        }

        public APIRequestGetAffectedAdSets requestDailyBudgetField(boolean value) {
            this.requestField("daily_budget", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestDailyMinSpendTargetField() {
            return this.requestDailyMinSpendTargetField(true);
        }

        public APIRequestGetAffectedAdSets requestDailyMinSpendTargetField(boolean value) {
            this.requestField("daily_min_spend_target", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestDailySpendCapField() {
            return this.requestDailySpendCapField(true);
        }

        public APIRequestGetAffectedAdSets requestDailySpendCapField(boolean value) {
            this.requestField("daily_spend_cap", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestDestinationTypeField() {
            return this.requestDestinationTypeField(true);
        }

        public APIRequestGetAffectedAdSets requestDestinationTypeField(boolean value) {
            this.requestField("destination_type", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestEffectiveStatusField() {
            return this.requestEffectiveStatusField(true);
        }

        public APIRequestGetAffectedAdSets requestEffectiveStatusField(boolean value) {
            this.requestField("effective_status", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGetAffectedAdSets requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestFrequencyCapField() {
            return this.requestFrequencyCapField(true);
        }

        public APIRequestGetAffectedAdSets requestFrequencyCapField(boolean value) {
            this.requestField("frequency_cap", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestFrequencyCapResetPeriodField() {
            return this.requestFrequencyCapResetPeriodField(true);
        }

        public APIRequestGetAffectedAdSets requestFrequencyCapResetPeriodField(boolean value) {
            this.requestField("frequency_cap_reset_period", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestFrequencyControlSpecsField() {
            return this.requestFrequencyControlSpecsField(true);
        }

        public APIRequestGetAffectedAdSets requestFrequencyControlSpecsField(boolean value) {
            this.requestField("frequency_control_specs", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestFullFunnelExplorationModeField() {
            return this.requestFullFunnelExplorationModeField(true);
        }

        public APIRequestGetAffectedAdSets requestFullFunnelExplorationModeField(boolean value) {
            this.requestField("full_funnel_exploration_mode", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAffectedAdSets requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestInstagramActorIdField() {
            return this.requestInstagramActorIdField(true);
        }

        public APIRequestGetAffectedAdSets requestInstagramActorIdField(boolean value) {
            this.requestField("instagram_actor_id", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestIsAutobidField() {
            return this.requestIsAutobidField(true);
        }

        public APIRequestGetAffectedAdSets requestIsAutobidField(boolean value) {
            this.requestField("is_autobid", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestIsAveragePricePacingField() {
            return this.requestIsAveragePricePacingField(true);
        }

        public APIRequestGetAffectedAdSets requestIsAveragePricePacingField(boolean value) {
            this.requestField("is_average_price_pacing", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestIsDynamicCreativeField() {
            return this.requestIsDynamicCreativeField(true);
        }

        public APIRequestGetAffectedAdSets requestIsDynamicCreativeField(boolean value) {
            this.requestField("is_dynamic_creative", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestIsDynamicCreativeOptimizationField() {
            return this.requestIsDynamicCreativeOptimizationField(true);
        }

        public APIRequestGetAffectedAdSets requestIsDynamicCreativeOptimizationField(boolean value) {
            this.requestField("is_dynamic_creative_optimization", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestIssuesInfoField() {
            return this.requestIssuesInfoField(true);
        }

        public APIRequestGetAffectedAdSets requestIssuesInfoField(boolean value) {
            this.requestField("issues_info", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestLifetimeBudgetField() {
            return this.requestLifetimeBudgetField(true);
        }

        public APIRequestGetAffectedAdSets requestLifetimeBudgetField(boolean value) {
            this.requestField("lifetime_budget", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestLifetimeFrequencyCapField() {
            return this.requestLifetimeFrequencyCapField(true);
        }

        public APIRequestGetAffectedAdSets requestLifetimeFrequencyCapField(boolean value) {
            this.requestField("lifetime_frequency_cap", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestLifetimeImpsField() {
            return this.requestLifetimeImpsField(true);
        }

        public APIRequestGetAffectedAdSets requestLifetimeImpsField(boolean value) {
            this.requestField("lifetime_imps", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestLifetimeMinSpendTargetField() {
            return this.requestLifetimeMinSpendTargetField(true);
        }

        public APIRequestGetAffectedAdSets requestLifetimeMinSpendTargetField(boolean value) {
            this.requestField("lifetime_min_spend_target", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestLifetimeSpendCapField() {
            return this.requestLifetimeSpendCapField(true);
        }

        public APIRequestGetAffectedAdSets requestLifetimeSpendCapField(boolean value) {
            this.requestField("lifetime_spend_cap", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAffectedAdSets requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestOptimizationGoalField() {
            return this.requestOptimizationGoalField(true);
        }

        public APIRequestGetAffectedAdSets requestOptimizationGoalField(boolean value) {
            this.requestField("optimization_goal", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestPacingTypeField() {
            return this.requestPacingTypeField(true);
        }

        public APIRequestGetAffectedAdSets requestPacingTypeField(boolean value) {
            this.requestField("pacing_type", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestPromotedObjectField() {
            return this.requestPromotedObjectField(true);
        }

        public APIRequestGetAffectedAdSets requestPromotedObjectField(boolean value) {
            this.requestField("promoted_object", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestRecommendationsField() {
            return this.requestRecommendationsField(true);
        }

        public APIRequestGetAffectedAdSets requestRecommendationsField(boolean value) {
            this.requestField("recommendations", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestRecurringBudgetSemanticsField() {
            return this.requestRecurringBudgetSemanticsField(true);
        }

        public APIRequestGetAffectedAdSets requestRecurringBudgetSemanticsField(boolean value) {
            this.requestField("recurring_budget_semantics", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestReviewFeedbackField() {
            return this.requestReviewFeedbackField(true);
        }

        public APIRequestGetAffectedAdSets requestReviewFeedbackField(boolean value) {
            this.requestField("review_feedback", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestRfPredictionIdField() {
            return this.requestRfPredictionIdField(true);
        }

        public APIRequestGetAffectedAdSets requestRfPredictionIdField(boolean value) {
            this.requestField("rf_prediction_id", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestRtbFlagField() {
            return this.requestRtbFlagField(true);
        }

        public APIRequestGetAffectedAdSets requestRtbFlagField(boolean value) {
            this.requestField("rtb_flag", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestSourceAdsetField() {
            return this.requestSourceAdsetField(true);
        }

        public APIRequestGetAffectedAdSets requestSourceAdsetField(boolean value) {
            this.requestField("source_adset", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestSourceAdsetIdField() {
            return this.requestSourceAdsetIdField(true);
        }

        public APIRequestGetAffectedAdSets requestSourceAdsetIdField(boolean value) {
            this.requestField("source_adset_id", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetAffectedAdSets requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetAffectedAdSets requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGetAffectedAdSets requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestTimeBasedAdRotationIdBlocksField() {
            return this.requestTimeBasedAdRotationIdBlocksField(true);
        }

        public APIRequestGetAffectedAdSets requestTimeBasedAdRotationIdBlocksField(boolean value) {
            this.requestField("time_based_ad_rotation_id_blocks", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestTimeBasedAdRotationIntervalsField() {
            return this.requestTimeBasedAdRotationIntervalsField(true);
        }

        public APIRequestGetAffectedAdSets requestTimeBasedAdRotationIntervalsField(boolean value) {
            this.requestField("time_based_ad_rotation_intervals", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestTrackingSpecsField() {
            return this.requestTrackingSpecsField(true);
        }

        public APIRequestGetAffectedAdSets requestTrackingSpecsField(boolean value) {
            this.requestField("tracking_specs", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAffectedAdSets requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetAffectedAdSets requestUseNewAppClickField() {
            return this.requestUseNewAppClickField(true);
        }

        public APIRequestGetAffectedAdSets requestUseNewAppClickField(boolean value) {
            this.requestField("use_new_app_click", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAdVideo
    extends APIRequest<AdVideo> {
        AdVideo lastResponse = null;
        public static final String[] PARAMS = new String[]{"title", "unpublished_content_type", "time_since_original_post", "file_url", "composer_session_id", "waterfall_id", "og_action_type_id", "og_object_id", "og_phrase", "og_icon_id", "og_suggestion_mechanism", "manual_privacy", "is_explicit_share", "thumb", "spherical", "original_projection_type", "initial_heading", "initial_pitch", "fov", "original_fov", "fisheye_video_cropped", "front_z_rotation", "guide_enabled", "guide", "audio_story_wave_animation_handle", "adaptive_type", "animated_effect_id", "asked_fun_fact_prompt_id", "composer_entry_picker", "composer_entry_point", "composer_entry_time", "composer_session_events_log", "composer_source_surface", "composer_type", "formatting", "fun_fact_prompt_id", "fun_fact_toastee_id", "is_group_linking_post", "has_nickname", "holiday_card", "instant_game_entry_point_data", "is_boost_intended", "location_source_id", "description", "offer_like_post_id", "publish_event_id", "react_mode_metadata", "sales_promo_id", "text_format_metadata", "throwback_camera_roll_media", "video_start_time_ms", "application_id", "upload_phase", "file_size", "start_offset", "end_offset", "video_file_chunk", "fbuploader_video_file_chunk", "upload_session_id", "is_voice_clip", "attribution_app_id", "content_category", "embeddable", "slideshow_spec", "upload_setting_properties", "transcode_setting_properties", "container_type", "referenced_sticker_id", "replace_video_id", "swap_mode", "name", "chunk_session_id", "file"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdVideo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdVideo parseResponse(String response) throws APIException {
            return AdVideo.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdVideo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdVideo execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdVideo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdVideo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdVideo>(){

                public AdVideo apply(String result) {
                    try {
                        return APIRequestCreateAdVideo.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAdVideo(String nodeId, APIContext context) {
            super(context, nodeId, "/advideos", "POST", Arrays.asList(PARAMS));
            this.setUseVideoEndpoint(true);
        }

        public APIRequestCreateAdVideo setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAdVideo setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAdVideo addUploadFile(String uploadName, File file) {
            this.setParam(uploadName, file);
            return this;
        }

        @Override
        public APIRequestCreateAdVideo setUseVideoEndpoint(boolean useVideoEndpoint) {
            this.useVideoEndpoint = useVideoEndpoint;
            return this;
        }

        public APIRequestCreateAdVideo setTitle(String title) {
            this.setParam("title", title);
            return this;
        }

        public APIRequestCreateAdVideo setUnpublishedContentType(AdVideo.EnumUnpublishedContentType unpublishedContentType) {
            this.setParam("unpublished_content_type", (Object)unpublishedContentType);
            return this;
        }

        public APIRequestCreateAdVideo setUnpublishedContentType(String unpublishedContentType) {
            this.setParam("unpublished_content_type", unpublishedContentType);
            return this;
        }

        public APIRequestCreateAdVideo setTimeSinceOriginalPost(Long timeSinceOriginalPost) {
            this.setParam("time_since_original_post", timeSinceOriginalPost);
            return this;
        }

        public APIRequestCreateAdVideo setTimeSinceOriginalPost(String timeSinceOriginalPost) {
            this.setParam("time_since_original_post", timeSinceOriginalPost);
            return this;
        }

        public APIRequestCreateAdVideo setFileUrl(String fileUrl) {
            this.setParam("file_url", fileUrl);
            return this;
        }

        public APIRequestCreateAdVideo setComposerSessionId(String composerSessionId) {
            this.setParam("composer_session_id", composerSessionId);
            return this;
        }

        public APIRequestCreateAdVideo setWaterfallId(String waterfallId) {
            this.setParam("waterfall_id", waterfallId);
            return this;
        }

        public APIRequestCreateAdVideo setOgActionTypeId(String ogActionTypeId) {
            this.setParam("og_action_type_id", ogActionTypeId);
            return this;
        }

        public APIRequestCreateAdVideo setOgObjectId(String ogObjectId) {
            this.setParam("og_object_id", ogObjectId);
            return this;
        }

        public APIRequestCreateAdVideo setOgPhrase(String ogPhrase) {
            this.setParam("og_phrase", ogPhrase);
            return this;
        }

        public APIRequestCreateAdVideo setOgIconId(String ogIconId) {
            this.setParam("og_icon_id", ogIconId);
            return this;
        }

        public APIRequestCreateAdVideo setOgSuggestionMechanism(String ogSuggestionMechanism) {
            this.setParam("og_suggestion_mechanism", ogSuggestionMechanism);
            return this;
        }

        public APIRequestCreateAdVideo setManualPrivacy(Boolean manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreateAdVideo setManualPrivacy(String manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreateAdVideo setIsExplicitShare(Boolean isExplicitShare) {
            this.setParam("is_explicit_share", isExplicitShare);
            return this;
        }

        public APIRequestCreateAdVideo setIsExplicitShare(String isExplicitShare) {
            this.setParam("is_explicit_share", isExplicitShare);
            return this;
        }

        public APIRequestCreateAdVideo setThumb(File thumb) {
            this.setParam("thumb", thumb);
            return this;
        }

        public APIRequestCreateAdVideo setThumb(String thumb) {
            this.setParam("thumb", thumb);
            return this;
        }

        public APIRequestCreateAdVideo setSpherical(Boolean spherical) {
            this.setParam("spherical", spherical);
            return this;
        }

        public APIRequestCreateAdVideo setSpherical(String spherical) {
            this.setParam("spherical", spherical);
            return this;
        }

        public APIRequestCreateAdVideo setOriginalProjectionType(AdVideo.EnumOriginalProjectionType originalProjectionType) {
            this.setParam("original_projection_type", (Object)originalProjectionType);
            return this;
        }

        public APIRequestCreateAdVideo setOriginalProjectionType(String originalProjectionType) {
            this.setParam("original_projection_type", originalProjectionType);
            return this;
        }

        public APIRequestCreateAdVideo setInitialHeading(Long initialHeading) {
            this.setParam("initial_heading", initialHeading);
            return this;
        }

        public APIRequestCreateAdVideo setInitialHeading(String initialHeading) {
            this.setParam("initial_heading", initialHeading);
            return this;
        }

        public APIRequestCreateAdVideo setInitialPitch(Long initialPitch) {
            this.setParam("initial_pitch", initialPitch);
            return this;
        }

        public APIRequestCreateAdVideo setInitialPitch(String initialPitch) {
            this.setParam("initial_pitch", initialPitch);
            return this;
        }

        public APIRequestCreateAdVideo setFov(Long fov) {
            this.setParam("fov", fov);
            return this;
        }

        public APIRequestCreateAdVideo setFov(String fov) {
            this.setParam("fov", fov);
            return this;
        }

        public APIRequestCreateAdVideo setOriginalFov(Long originalFov) {
            this.setParam("original_fov", originalFov);
            return this;
        }

        public APIRequestCreateAdVideo setOriginalFov(String originalFov) {
            this.setParam("original_fov", originalFov);
            return this;
        }

        public APIRequestCreateAdVideo setFisheyeVideoCropped(Boolean fisheyeVideoCropped) {
            this.setParam("fisheye_video_cropped", fisheyeVideoCropped);
            return this;
        }

        public APIRequestCreateAdVideo setFisheyeVideoCropped(String fisheyeVideoCropped) {
            this.setParam("fisheye_video_cropped", fisheyeVideoCropped);
            return this;
        }

        public APIRequestCreateAdVideo setFrontZRotation(Double frontZRotation) {
            this.setParam("front_z_rotation", frontZRotation);
            return this;
        }

        public APIRequestCreateAdVideo setFrontZRotation(String frontZRotation) {
            this.setParam("front_z_rotation", frontZRotation);
            return this;
        }

        public APIRequestCreateAdVideo setGuideEnabled(Boolean guideEnabled) {
            this.setParam("guide_enabled", guideEnabled);
            return this;
        }

        public APIRequestCreateAdVideo setGuideEnabled(String guideEnabled) {
            this.setParam("guide_enabled", guideEnabled);
            return this;
        }

        public APIRequestCreateAdVideo setGuide(List<List<Long>> guide) {
            this.setParam("guide", guide);
            return this;
        }

        public APIRequestCreateAdVideo setGuide(String guide) {
            this.setParam("guide", guide);
            return this;
        }

        public APIRequestCreateAdVideo setAudioStoryWaveAnimationHandle(String audioStoryWaveAnimationHandle) {
            this.setParam("audio_story_wave_animation_handle", audioStoryWaveAnimationHandle);
            return this;
        }

        public APIRequestCreateAdVideo setAdaptiveType(String adaptiveType) {
            this.setParam("adaptive_type", adaptiveType);
            return this;
        }

        public APIRequestCreateAdVideo setAnimatedEffectId(Long animatedEffectId) {
            this.setParam("animated_effect_id", animatedEffectId);
            return this;
        }

        public APIRequestCreateAdVideo setAnimatedEffectId(String animatedEffectId) {
            this.setParam("animated_effect_id", animatedEffectId);
            return this;
        }

        public APIRequestCreateAdVideo setAskedFunFactPromptId(Long askedFunFactPromptId) {
            this.setParam("asked_fun_fact_prompt_id", askedFunFactPromptId);
            return this;
        }

        public APIRequestCreateAdVideo setAskedFunFactPromptId(String askedFunFactPromptId) {
            this.setParam("asked_fun_fact_prompt_id", askedFunFactPromptId);
            return this;
        }

        public APIRequestCreateAdVideo setComposerEntryPicker(String composerEntryPicker) {
            this.setParam("composer_entry_picker", composerEntryPicker);
            return this;
        }

        public APIRequestCreateAdVideo setComposerEntryPoint(String composerEntryPoint) {
            this.setParam("composer_entry_point", composerEntryPoint);
            return this;
        }

        public APIRequestCreateAdVideo setComposerEntryTime(Long composerEntryTime) {
            this.setParam("composer_entry_time", composerEntryTime);
            return this;
        }

        public APIRequestCreateAdVideo setComposerEntryTime(String composerEntryTime) {
            this.setParam("composer_entry_time", composerEntryTime);
            return this;
        }

        public APIRequestCreateAdVideo setComposerSessionEventsLog(String composerSessionEventsLog) {
            this.setParam("composer_session_events_log", composerSessionEventsLog);
            return this;
        }

        public APIRequestCreateAdVideo setComposerSourceSurface(String composerSourceSurface) {
            this.setParam("composer_source_surface", composerSourceSurface);
            return this;
        }

        public APIRequestCreateAdVideo setComposerType(String composerType) {
            this.setParam("composer_type", composerType);
            return this;
        }

        public APIRequestCreateAdVideo setFormatting(AdVideo.EnumFormatting formatting) {
            this.setParam("formatting", (Object)formatting);
            return this;
        }

        public APIRequestCreateAdVideo setFormatting(String formatting) {
            this.setParam("formatting", formatting);
            return this;
        }

        public APIRequestCreateAdVideo setFunFactPromptId(String funFactPromptId) {
            this.setParam("fun_fact_prompt_id", funFactPromptId);
            return this;
        }

        public APIRequestCreateAdVideo setFunFactToasteeId(Long funFactToasteeId) {
            this.setParam("fun_fact_toastee_id", funFactToasteeId);
            return this;
        }

        public APIRequestCreateAdVideo setFunFactToasteeId(String funFactToasteeId) {
            this.setParam("fun_fact_toastee_id", funFactToasteeId);
            return this;
        }

        public APIRequestCreateAdVideo setIsGroupLinkingPost(Boolean isGroupLinkingPost) {
            this.setParam("is_group_linking_post", isGroupLinkingPost);
            return this;
        }

        public APIRequestCreateAdVideo setIsGroupLinkingPost(String isGroupLinkingPost) {
            this.setParam("is_group_linking_post", isGroupLinkingPost);
            return this;
        }

        public APIRequestCreateAdVideo setHasNickname(Boolean hasNickname) {
            this.setParam("has_nickname", hasNickname);
            return this;
        }

        public APIRequestCreateAdVideo setHasNickname(String hasNickname) {
            this.setParam("has_nickname", hasNickname);
            return this;
        }

        public APIRequestCreateAdVideo setHolidayCard(String holidayCard) {
            this.setParam("holiday_card", holidayCard);
            return this;
        }

        public APIRequestCreateAdVideo setInstantGameEntryPointData(String instantGameEntryPointData) {
            this.setParam("instant_game_entry_point_data", instantGameEntryPointData);
            return this;
        }

        public APIRequestCreateAdVideo setIsBoostIntended(Boolean isBoostIntended) {
            this.setParam("is_boost_intended", isBoostIntended);
            return this;
        }

        public APIRequestCreateAdVideo setIsBoostIntended(String isBoostIntended) {
            this.setParam("is_boost_intended", isBoostIntended);
            return this;
        }

        public APIRequestCreateAdVideo setLocationSourceId(String locationSourceId) {
            this.setParam("location_source_id", locationSourceId);
            return this;
        }

        public APIRequestCreateAdVideo setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateAdVideo setOfferLikePostId(String offerLikePostId) {
            this.setParam("offer_like_post_id", offerLikePostId);
            return this;
        }

        public APIRequestCreateAdVideo setPublishEventId(Long publishEventId) {
            this.setParam("publish_event_id", publishEventId);
            return this;
        }

        public APIRequestCreateAdVideo setPublishEventId(String publishEventId) {
            this.setParam("publish_event_id", publishEventId);
            return this;
        }

        public APIRequestCreateAdVideo setReactModeMetadata(String reactModeMetadata) {
            this.setParam("react_mode_metadata", reactModeMetadata);
            return this;
        }

        public APIRequestCreateAdVideo setSalesPromoId(Long salesPromoId) {
            this.setParam("sales_promo_id", salesPromoId);
            return this;
        }

        public APIRequestCreateAdVideo setSalesPromoId(String salesPromoId) {
            this.setParam("sales_promo_id", salesPromoId);
            return this;
        }

        public APIRequestCreateAdVideo setTextFormatMetadata(String textFormatMetadata) {
            this.setParam("text_format_metadata", textFormatMetadata);
            return this;
        }

        public APIRequestCreateAdVideo setThrowbackCameraRollMedia(String throwbackCameraRollMedia) {
            this.setParam("throwback_camera_roll_media", throwbackCameraRollMedia);
            return this;
        }

        public APIRequestCreateAdVideo setVideoStartTimeMs(Long videoStartTimeMs) {
            this.setParam("video_start_time_ms", videoStartTimeMs);
            return this;
        }

        public APIRequestCreateAdVideo setVideoStartTimeMs(String videoStartTimeMs) {
            this.setParam("video_start_time_ms", videoStartTimeMs);
            return this;
        }

        public APIRequestCreateAdVideo setApplicationId(String applicationId) {
            this.setParam("application_id", applicationId);
            return this;
        }

        public APIRequestCreateAdVideo setUploadPhase(AdVideo.EnumUploadPhase uploadPhase) {
            this.setParam("upload_phase", (Object)uploadPhase);
            return this;
        }

        public APIRequestCreateAdVideo setUploadPhase(String uploadPhase) {
            this.setParam("upload_phase", uploadPhase);
            return this;
        }

        public APIRequestCreateAdVideo setFileSize(Long fileSize) {
            this.setParam("file_size", fileSize);
            return this;
        }

        public APIRequestCreateAdVideo setFileSize(String fileSize) {
            this.setParam("file_size", fileSize);
            return this;
        }

        public APIRequestCreateAdVideo setStartOffset(Long startOffset) {
            this.setParam("start_offset", startOffset);
            return this;
        }

        public APIRequestCreateAdVideo setStartOffset(String startOffset) {
            this.setParam("start_offset", startOffset);
            return this;
        }

        public APIRequestCreateAdVideo setEndOffset(Long endOffset) {
            this.setParam("end_offset", endOffset);
            return this;
        }

        public APIRequestCreateAdVideo setEndOffset(String endOffset) {
            this.setParam("end_offset", endOffset);
            return this;
        }

        public APIRequestCreateAdVideo setVideoFileChunk(String videoFileChunk) {
            this.setParam("video_file_chunk", videoFileChunk);
            return this;
        }

        public APIRequestCreateAdVideo setVideoFileChunk(File videoFileChunk) {
            this.setParam("video_file_chunk", videoFileChunk);
            return this;
        }

        public APIRequestCreateAdVideo setVideoFileChunk(byte[] videoFileChunk) {
            this.setParam("video_file_chunk", videoFileChunk);
            return this;
        }

        public APIRequestCreateAdVideo setFbuploaderVideoFileChunk(String fbuploaderVideoFileChunk) {
            this.setParam("fbuploader_video_file_chunk", fbuploaderVideoFileChunk);
            return this;
        }

        public APIRequestCreateAdVideo setUploadSessionId(String uploadSessionId) {
            this.setParam("upload_session_id", uploadSessionId);
            return this;
        }

        public APIRequestCreateAdVideo setIsVoiceClip(Boolean isVoiceClip) {
            this.setParam("is_voice_clip", isVoiceClip);
            return this;
        }

        public APIRequestCreateAdVideo setIsVoiceClip(String isVoiceClip) {
            this.setParam("is_voice_clip", isVoiceClip);
            return this;
        }

        public APIRequestCreateAdVideo setAttributionAppId(String attributionAppId) {
            this.setParam("attribution_app_id", attributionAppId);
            return this;
        }

        public APIRequestCreateAdVideo setContentCategory(AdVideo.EnumContentCategory contentCategory) {
            this.setParam("content_category", (Object)contentCategory);
            return this;
        }

        public APIRequestCreateAdVideo setContentCategory(String contentCategory) {
            this.setParam("content_category", contentCategory);
            return this;
        }

        public APIRequestCreateAdVideo setEmbeddable(Boolean embeddable) {
            this.setParam("embeddable", embeddable);
            return this;
        }

        public APIRequestCreateAdVideo setEmbeddable(String embeddable) {
            this.setParam("embeddable", embeddable);
            return this;
        }

        public APIRequestCreateAdVideo setSlideshowSpec(Map<String, String> slideshowSpec) {
            this.setParam("slideshow_spec", slideshowSpec);
            return this;
        }

        public APIRequestCreateAdVideo setSlideshowSpec(String slideshowSpec) {
            this.setParam("slideshow_spec", slideshowSpec);
            return this;
        }

        public APIRequestCreateAdVideo setUploadSettingProperties(String uploadSettingProperties) {
            this.setParam("upload_setting_properties", uploadSettingProperties);
            return this;
        }

        public APIRequestCreateAdVideo setTranscodeSettingProperties(String transcodeSettingProperties) {
            this.setParam("transcode_setting_properties", transcodeSettingProperties);
            return this;
        }

        public APIRequestCreateAdVideo setContainerType(AdVideo.EnumContainerType containerType) {
            this.setParam("container_type", (Object)containerType);
            return this;
        }

        public APIRequestCreateAdVideo setContainerType(String containerType) {
            this.setParam("container_type", containerType);
            return this;
        }

        public APIRequestCreateAdVideo setReferencedStickerId(String referencedStickerId) {
            this.setParam("referenced_sticker_id", referencedStickerId);
            return this;
        }

        public APIRequestCreateAdVideo setReplaceVideoId(String replaceVideoId) {
            this.setParam("replace_video_id", replaceVideoId);
            return this;
        }

        public APIRequestCreateAdVideo setSwapMode(AdVideo.EnumSwapMode swapMode) {
            this.setParam("swap_mode", (Object)swapMode);
            return this;
        }

        public APIRequestCreateAdVideo setSwapMode(String swapMode) {
            this.setParam("swap_mode", swapMode);
            return this;
        }

        public APIRequestCreateAdVideo setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateAdVideo setChunkSessionId(String chunkSessionId) {
            this.setParam("chunk_session_id", chunkSessionId);
            return this;
        }

        public APIRequestCreateAdVideo requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAdVideo requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdVideo requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAdVideo requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdVideo requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAdVideo requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdVideos
    extends APIRequest<AdVideo> {
        APINodeList<AdVideo> lastResponse = null;
        public static final String[] PARAMS = new String[]{"title", "minlength", "maxlength", "minheight", "maxheight", "minwidth", "maxwidth", "min_aspect_ratio", "max_aspect_ratio"};
        public static final String[] FIELDS = new String[]{"ad_breaks", "backdated_time", "backdated_time_granularity", "content_category", "content_tags", "created_time", "custom_labels", "description", "embed_html", "embeddable", "event", "expiration", "format", "from", "icon", "id", "is_crosspost_video", "is_crossposting_eligible", "is_episode", "is_instagram_eligible", "length", "live_audience_count", "live_status", "name", "permalink_url", "picture", "place", "privacy", "published", "scheduled_publish_time", "source", "spherical", "status", "title", "tv_banner_ad", "universal_video_id", "updated_time"};

        @Override
        public APINodeList<AdVideo> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdVideo> parseResponse(String response) throws APIException {
            return AdVideo.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdVideo> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdVideo> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdVideo>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdVideo>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdVideo>>(){

                public APINodeList<AdVideo> apply(String result) {
                    try {
                        return APIRequestGetAdVideos.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdVideos(String nodeId, APIContext context) {
            super(context, nodeId, "/advideos", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdVideos setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdVideos setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdVideos setTitle(String title) {
            this.setParam("title", title);
            return this;
        }

        public APIRequestGetAdVideos setMinlength(Long minlength) {
            this.setParam("minlength", minlength);
            return this;
        }

        public APIRequestGetAdVideos setMinlength(String minlength) {
            this.setParam("minlength", minlength);
            return this;
        }

        public APIRequestGetAdVideos setMaxlength(Long maxlength) {
            this.setParam("maxlength", maxlength);
            return this;
        }

        public APIRequestGetAdVideos setMaxlength(String maxlength) {
            this.setParam("maxlength", maxlength);
            return this;
        }

        public APIRequestGetAdVideos setMinheight(Long minheight) {
            this.setParam("minheight", minheight);
            return this;
        }

        public APIRequestGetAdVideos setMinheight(String minheight) {
            this.setParam("minheight", minheight);
            return this;
        }

        public APIRequestGetAdVideos setMaxheight(Long maxheight) {
            this.setParam("maxheight", maxheight);
            return this;
        }

        public APIRequestGetAdVideos setMaxheight(String maxheight) {
            this.setParam("maxheight", maxheight);
            return this;
        }

        public APIRequestGetAdVideos setMinwidth(Long minwidth) {
            this.setParam("minwidth", minwidth);
            return this;
        }

        public APIRequestGetAdVideos setMinwidth(String minwidth) {
            this.setParam("minwidth", minwidth);
            return this;
        }

        public APIRequestGetAdVideos setMaxwidth(Long maxwidth) {
            this.setParam("maxwidth", maxwidth);
            return this;
        }

        public APIRequestGetAdVideos setMaxwidth(String maxwidth) {
            this.setParam("maxwidth", maxwidth);
            return this;
        }

        public APIRequestGetAdVideos setMinAspectRatio(Double minAspectRatio) {
            this.setParam("min_aspect_ratio", minAspectRatio);
            return this;
        }

        public APIRequestGetAdVideos setMinAspectRatio(String minAspectRatio) {
            this.setParam("min_aspect_ratio", minAspectRatio);
            return this;
        }

        public APIRequestGetAdVideos setMaxAspectRatio(Double maxAspectRatio) {
            this.setParam("max_aspect_ratio", maxAspectRatio);
            return this;
        }

        public APIRequestGetAdVideos setMaxAspectRatio(String maxAspectRatio) {
            this.setParam("max_aspect_ratio", maxAspectRatio);
            return this;
        }

        public APIRequestGetAdVideos requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdVideos requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdVideos requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdVideos requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdVideos requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdVideos requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdVideos requestAdBreaksField() {
            return this.requestAdBreaksField(true);
        }

        public APIRequestGetAdVideos requestAdBreaksField(boolean value) {
            this.requestField("ad_breaks", value);
            return this;
        }

        public APIRequestGetAdVideos requestBackdatedTimeField() {
            return this.requestBackdatedTimeField(true);
        }

        public APIRequestGetAdVideos requestBackdatedTimeField(boolean value) {
            this.requestField("backdated_time", value);
            return this;
        }

        public APIRequestGetAdVideos requestBackdatedTimeGranularityField() {
            return this.requestBackdatedTimeGranularityField(true);
        }

        public APIRequestGetAdVideos requestBackdatedTimeGranularityField(boolean value) {
            this.requestField("backdated_time_granularity", value);
            return this;
        }

        public APIRequestGetAdVideos requestContentCategoryField() {
            return this.requestContentCategoryField(true);
        }

        public APIRequestGetAdVideos requestContentCategoryField(boolean value) {
            this.requestField("content_category", value);
            return this;
        }

        public APIRequestGetAdVideos requestContentTagsField() {
            return this.requestContentTagsField(true);
        }

        public APIRequestGetAdVideos requestContentTagsField(boolean value) {
            this.requestField("content_tags", value);
            return this;
        }

        public APIRequestGetAdVideos requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAdVideos requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAdVideos requestCustomLabelsField() {
            return this.requestCustomLabelsField(true);
        }

        public APIRequestGetAdVideos requestCustomLabelsField(boolean value) {
            this.requestField("custom_labels", value);
            return this;
        }

        public APIRequestGetAdVideos requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetAdVideos requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetAdVideos requestEmbedHtmlField() {
            return this.requestEmbedHtmlField(true);
        }

        public APIRequestGetAdVideos requestEmbedHtmlField(boolean value) {
            this.requestField("embed_html", value);
            return this;
        }

        public APIRequestGetAdVideos requestEmbeddableField() {
            return this.requestEmbeddableField(true);
        }

        public APIRequestGetAdVideos requestEmbeddableField(boolean value) {
            this.requestField("embeddable", value);
            return this;
        }

        public APIRequestGetAdVideos requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGetAdVideos requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGetAdVideos requestExpirationField() {
            return this.requestExpirationField(true);
        }

        public APIRequestGetAdVideos requestExpirationField(boolean value) {
            this.requestField("expiration", value);
            return this;
        }

        public APIRequestGetAdVideos requestFormatField() {
            return this.requestFormatField(true);
        }

        public APIRequestGetAdVideos requestFormatField(boolean value) {
            this.requestField("format", value);
            return this;
        }

        public APIRequestGetAdVideos requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetAdVideos requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetAdVideos requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGetAdVideos requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGetAdVideos requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdVideos requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdVideos requestIsCrosspostVideoField() {
            return this.requestIsCrosspostVideoField(true);
        }

        public APIRequestGetAdVideos requestIsCrosspostVideoField(boolean value) {
            this.requestField("is_crosspost_video", value);
            return this;
        }

        public APIRequestGetAdVideos requestIsCrosspostingEligibleField() {
            return this.requestIsCrosspostingEligibleField(true);
        }

        public APIRequestGetAdVideos requestIsCrosspostingEligibleField(boolean value) {
            this.requestField("is_crossposting_eligible", value);
            return this;
        }

        public APIRequestGetAdVideos requestIsEpisodeField() {
            return this.requestIsEpisodeField(true);
        }

        public APIRequestGetAdVideos requestIsEpisodeField(boolean value) {
            this.requestField("is_episode", value);
            return this;
        }

        public APIRequestGetAdVideos requestIsInstagramEligibleField() {
            return this.requestIsInstagramEligibleField(true);
        }

        public APIRequestGetAdVideos requestIsInstagramEligibleField(boolean value) {
            this.requestField("is_instagram_eligible", value);
            return this;
        }

        public APIRequestGetAdVideos requestLengthField() {
            return this.requestLengthField(true);
        }

        public APIRequestGetAdVideos requestLengthField(boolean value) {
            this.requestField("length", value);
            return this;
        }

        public APIRequestGetAdVideos requestLiveAudienceCountField() {
            return this.requestLiveAudienceCountField(true);
        }

        public APIRequestGetAdVideos requestLiveAudienceCountField(boolean value) {
            this.requestField("live_audience_count", value);
            return this;
        }

        public APIRequestGetAdVideos requestLiveStatusField() {
            return this.requestLiveStatusField(true);
        }

        public APIRequestGetAdVideos requestLiveStatusField(boolean value) {
            this.requestField("live_status", value);
            return this;
        }

        public APIRequestGetAdVideos requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdVideos requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdVideos requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGetAdVideos requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGetAdVideos requestPictureField() {
            return this.requestPictureField(true);
        }

        public APIRequestGetAdVideos requestPictureField(boolean value) {
            this.requestField("picture", value);
            return this;
        }

        public APIRequestGetAdVideos requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGetAdVideos requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGetAdVideos requestPrivacyField() {
            return this.requestPrivacyField(true);
        }

        public APIRequestGetAdVideos requestPrivacyField(boolean value) {
            this.requestField("privacy", value);
            return this;
        }

        public APIRequestGetAdVideos requestPublishedField() {
            return this.requestPublishedField(true);
        }

        public APIRequestGetAdVideos requestPublishedField(boolean value) {
            this.requestField("published", value);
            return this;
        }

        public APIRequestGetAdVideos requestScheduledPublishTimeField() {
            return this.requestScheduledPublishTimeField(true);
        }

        public APIRequestGetAdVideos requestScheduledPublishTimeField(boolean value) {
            this.requestField("scheduled_publish_time", value);
            return this;
        }

        public APIRequestGetAdVideos requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGetAdVideos requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGetAdVideos requestSphericalField() {
            return this.requestSphericalField(true);
        }

        public APIRequestGetAdVideos requestSphericalField(boolean value) {
            this.requestField("spherical", value);
            return this;
        }

        public APIRequestGetAdVideos requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetAdVideos requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetAdVideos requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetAdVideos requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetAdVideos requestTvBannerAdField() {
            return this.requestTvBannerAdField(true);
        }

        public APIRequestGetAdVideos requestTvBannerAdField(boolean value) {
            this.requestField("tv_banner_ad", value);
            return this;
        }

        public APIRequestGetAdVideos requestUniversalVideoIdField() {
            return this.requestUniversalVideoIdField(true);
        }

        public APIRequestGetAdVideos requestUniversalVideoIdField(boolean value) {
            this.requestField("universal_video_id", value);
            return this;
        }

        public APIRequestGetAdVideos requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAdVideos requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdvertisableApplications
    extends APIRequest<Application> {
        APINodeList<Application> lastResponse = null;
        public static final String[] PARAMS = new String[]{"app_id", "business_id"};
        public static final String[] FIELDS = new String[]{"an_ad_space_limit", "an_platforms", "android_key_hash", "android_sdk_error_categories", "app_domains", "app_events_feature_bitmask", "app_events_session_timeout", "app_install_tracked", "app_name", "app_signals_binding_ios", "app_type", "auth_dialog_data_help_url", "auth_dialog_headline", "auth_dialog_perms_explanation", "auth_referral_default_activity_privacy", "auth_referral_enabled", "auth_referral_extended_perms", "auth_referral_friend_perms", "auth_referral_response_type", "auth_referral_user_perms", "auto_event_mapping_android", "auto_event_mapping_ios", "auto_event_setup_enabled", "business", "canvas_fluid_height", "canvas_fluid_width", "canvas_url", "category", "client_config", "company", "configured_ios_sso", "contact_email", "context", "created_time", "creator_uid", "daily_active_users", "daily_active_users_rank", "deauth_callback_url", "default_share_mode", "description", "financial_id", "gdpv4_chrome_custom_tabs_enabled", "gdpv4_enabled", "gdpv4_nux_content", "gdpv4_nux_enabled", "has_messenger_product", "hosting_url", "icon_url", "id", "ios_bundle_id", "ios_sdk_dialog_flows", "ios_sdk_error_categories", "ios_sfvc_attr", "ios_supports_native_proxy_auth_flow", "ios_supports_system_auth", "ipad_app_store_id", "iphone_app_store_id", "is_viewer_admin", "latest_sdk_version", "link", "logging_token", "login_secret", "logo_url", "migrations", "mobile_profile_section_url", "mobile_web_url", "monthly_active_users", "monthly_active_users_rank", "name", "namespace", "object_store_urls", "page_tab_default_name", "page_tab_url", "photo_url", "privacy_policy_url", "profile_section_url", "property_id", "real_time_mode_devices", "restrictions", "sdk_update_message", "seamless_login", "secure_canvas_url", "secure_page_tab_url", "server_ip_whitelist", "smart_login_bookmark_icon_url", "smart_login_menu_icon_url", "social_discovery", "subcategory", "supported_platforms", "supports_apprequests_fast_app_switch", "supports_attribution", "supports_implicit_sdk_logging", "suppress_native_ios_gdp", "terms_of_service_url", "url_scheme_suffix", "user_support_email", "user_support_url", "website_url", "weekly_active_users"};

        @Override
        public APINodeList<Application> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Application> parseResponse(String response) throws APIException {
            return Application.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Application> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Application> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Application>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Application>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Application>>(){

                public APINodeList<Application> apply(String result) {
                    try {
                        return APIRequestGetAdvertisableApplications.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdvertisableApplications(String nodeId, APIContext context) {
            super(context, nodeId, "/advertisable_applications", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdvertisableApplications setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdvertisableApplications setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdvertisableApplications setAppId(String appId) {
            this.setParam("app_id", appId);
            return this;
        }

        public APIRequestGetAdvertisableApplications setBusinessId(String businessId) {
            this.setParam("business_id", businessId);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdvertisableApplications requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdvertisableApplications requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdvertisableApplications requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdvertisableApplications requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdvertisableApplications requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAnAdSpaceLimitField() {
            return this.requestAnAdSpaceLimitField(true);
        }

        public APIRequestGetAdvertisableApplications requestAnAdSpaceLimitField(boolean value) {
            this.requestField("an_ad_space_limit", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAnPlatformsField() {
            return this.requestAnPlatformsField(true);
        }

        public APIRequestGetAdvertisableApplications requestAnPlatformsField(boolean value) {
            this.requestField("an_platforms", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAndroidKeyHashField() {
            return this.requestAndroidKeyHashField(true);
        }

        public APIRequestGetAdvertisableApplications requestAndroidKeyHashField(boolean value) {
            this.requestField("android_key_hash", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAndroidSdkErrorCategoriesField() {
            return this.requestAndroidSdkErrorCategoriesField(true);
        }

        public APIRequestGetAdvertisableApplications requestAndroidSdkErrorCategoriesField(boolean value) {
            this.requestField("android_sdk_error_categories", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAppDomainsField() {
            return this.requestAppDomainsField(true);
        }

        public APIRequestGetAdvertisableApplications requestAppDomainsField(boolean value) {
            this.requestField("app_domains", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAppEventsFeatureBitmaskField() {
            return this.requestAppEventsFeatureBitmaskField(true);
        }

        public APIRequestGetAdvertisableApplications requestAppEventsFeatureBitmaskField(boolean value) {
            this.requestField("app_events_feature_bitmask", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAppEventsSessionTimeoutField() {
            return this.requestAppEventsSessionTimeoutField(true);
        }

        public APIRequestGetAdvertisableApplications requestAppEventsSessionTimeoutField(boolean value) {
            this.requestField("app_events_session_timeout", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAppInstallTrackedField() {
            return this.requestAppInstallTrackedField(true);
        }

        public APIRequestGetAdvertisableApplications requestAppInstallTrackedField(boolean value) {
            this.requestField("app_install_tracked", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAppNameField() {
            return this.requestAppNameField(true);
        }

        public APIRequestGetAdvertisableApplications requestAppNameField(boolean value) {
            this.requestField("app_name", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAppSignalsBindingIosField() {
            return this.requestAppSignalsBindingIosField(true);
        }

        public APIRequestGetAdvertisableApplications requestAppSignalsBindingIosField(boolean value) {
            this.requestField("app_signals_binding_ios", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAppTypeField() {
            return this.requestAppTypeField(true);
        }

        public APIRequestGetAdvertisableApplications requestAppTypeField(boolean value) {
            this.requestField("app_type", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAuthDialogDataHelpUrlField() {
            return this.requestAuthDialogDataHelpUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestAuthDialogDataHelpUrlField(boolean value) {
            this.requestField("auth_dialog_data_help_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAuthDialogHeadlineField() {
            return this.requestAuthDialogHeadlineField(true);
        }

        public APIRequestGetAdvertisableApplications requestAuthDialogHeadlineField(boolean value) {
            this.requestField("auth_dialog_headline", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAuthDialogPermsExplanationField() {
            return this.requestAuthDialogPermsExplanationField(true);
        }

        public APIRequestGetAdvertisableApplications requestAuthDialogPermsExplanationField(boolean value) {
            this.requestField("auth_dialog_perms_explanation", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAuthReferralDefaultActivityPrivacyField() {
            return this.requestAuthReferralDefaultActivityPrivacyField(true);
        }

        public APIRequestGetAdvertisableApplications requestAuthReferralDefaultActivityPrivacyField(boolean value) {
            this.requestField("auth_referral_default_activity_privacy", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAuthReferralEnabledField() {
            return this.requestAuthReferralEnabledField(true);
        }

        public APIRequestGetAdvertisableApplications requestAuthReferralEnabledField(boolean value) {
            this.requestField("auth_referral_enabled", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAuthReferralExtendedPermsField() {
            return this.requestAuthReferralExtendedPermsField(true);
        }

        public APIRequestGetAdvertisableApplications requestAuthReferralExtendedPermsField(boolean value) {
            this.requestField("auth_referral_extended_perms", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAuthReferralFriendPermsField() {
            return this.requestAuthReferralFriendPermsField(true);
        }

        public APIRequestGetAdvertisableApplications requestAuthReferralFriendPermsField(boolean value) {
            this.requestField("auth_referral_friend_perms", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAuthReferralResponseTypeField() {
            return this.requestAuthReferralResponseTypeField(true);
        }

        public APIRequestGetAdvertisableApplications requestAuthReferralResponseTypeField(boolean value) {
            this.requestField("auth_referral_response_type", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAuthReferralUserPermsField() {
            return this.requestAuthReferralUserPermsField(true);
        }

        public APIRequestGetAdvertisableApplications requestAuthReferralUserPermsField(boolean value) {
            this.requestField("auth_referral_user_perms", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAutoEventMappingAndroidField() {
            return this.requestAutoEventMappingAndroidField(true);
        }

        public APIRequestGetAdvertisableApplications requestAutoEventMappingAndroidField(boolean value) {
            this.requestField("auto_event_mapping_android", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAutoEventMappingIosField() {
            return this.requestAutoEventMappingIosField(true);
        }

        public APIRequestGetAdvertisableApplications requestAutoEventMappingIosField(boolean value) {
            this.requestField("auto_event_mapping_ios", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestAutoEventSetupEnabledField() {
            return this.requestAutoEventSetupEnabledField(true);
        }

        public APIRequestGetAdvertisableApplications requestAutoEventSetupEnabledField(boolean value) {
            this.requestField("auto_event_setup_enabled", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAdvertisableApplications requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestCanvasFluidHeightField() {
            return this.requestCanvasFluidHeightField(true);
        }

        public APIRequestGetAdvertisableApplications requestCanvasFluidHeightField(boolean value) {
            this.requestField("canvas_fluid_height", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestCanvasFluidWidthField() {
            return this.requestCanvasFluidWidthField(true);
        }

        public APIRequestGetAdvertisableApplications requestCanvasFluidWidthField(boolean value) {
            this.requestField("canvas_fluid_width", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestCanvasUrlField() {
            return this.requestCanvasUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestCanvasUrlField(boolean value) {
            this.requestField("canvas_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetAdvertisableApplications requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestClientConfigField() {
            return this.requestClientConfigField(true);
        }

        public APIRequestGetAdvertisableApplications requestClientConfigField(boolean value) {
            this.requestField("client_config", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestCompanyField() {
            return this.requestCompanyField(true);
        }

        public APIRequestGetAdvertisableApplications requestCompanyField(boolean value) {
            this.requestField("company", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestConfiguredIosSsoField() {
            return this.requestConfiguredIosSsoField(true);
        }

        public APIRequestGetAdvertisableApplications requestConfiguredIosSsoField(boolean value) {
            this.requestField("configured_ios_sso", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestContactEmailField() {
            return this.requestContactEmailField(true);
        }

        public APIRequestGetAdvertisableApplications requestContactEmailField(boolean value) {
            this.requestField("contact_email", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetAdvertisableApplications requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAdvertisableApplications requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestCreatorUidField() {
            return this.requestCreatorUidField(true);
        }

        public APIRequestGetAdvertisableApplications requestCreatorUidField(boolean value) {
            this.requestField("creator_uid", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestDailyActiveUsersField() {
            return this.requestDailyActiveUsersField(true);
        }

        public APIRequestGetAdvertisableApplications requestDailyActiveUsersField(boolean value) {
            this.requestField("daily_active_users", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestDailyActiveUsersRankField() {
            return this.requestDailyActiveUsersRankField(true);
        }

        public APIRequestGetAdvertisableApplications requestDailyActiveUsersRankField(boolean value) {
            this.requestField("daily_active_users_rank", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestDeauthCallbackUrlField() {
            return this.requestDeauthCallbackUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestDeauthCallbackUrlField(boolean value) {
            this.requestField("deauth_callback_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestDefaultShareModeField() {
            return this.requestDefaultShareModeField(true);
        }

        public APIRequestGetAdvertisableApplications requestDefaultShareModeField(boolean value) {
            this.requestField("default_share_mode", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetAdvertisableApplications requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestFinancialIdField() {
            return this.requestFinancialIdField(true);
        }

        public APIRequestGetAdvertisableApplications requestFinancialIdField(boolean value) {
            this.requestField("financial_id", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestGdpv4ChromeCustomTabsEnabledField() {
            return this.requestGdpv4ChromeCustomTabsEnabledField(true);
        }

        public APIRequestGetAdvertisableApplications requestGdpv4ChromeCustomTabsEnabledField(boolean value) {
            this.requestField("gdpv4_chrome_custom_tabs_enabled", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestGdpv4EnabledField() {
            return this.requestGdpv4EnabledField(true);
        }

        public APIRequestGetAdvertisableApplications requestGdpv4EnabledField(boolean value) {
            this.requestField("gdpv4_enabled", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestGdpv4NuxContentField() {
            return this.requestGdpv4NuxContentField(true);
        }

        public APIRequestGetAdvertisableApplications requestGdpv4NuxContentField(boolean value) {
            this.requestField("gdpv4_nux_content", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestGdpv4NuxEnabledField() {
            return this.requestGdpv4NuxEnabledField(true);
        }

        public APIRequestGetAdvertisableApplications requestGdpv4NuxEnabledField(boolean value) {
            this.requestField("gdpv4_nux_enabled", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestHasMessengerProductField() {
            return this.requestHasMessengerProductField(true);
        }

        public APIRequestGetAdvertisableApplications requestHasMessengerProductField(boolean value) {
            this.requestField("has_messenger_product", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestHostingUrlField() {
            return this.requestHostingUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestHostingUrlField(boolean value) {
            this.requestField("hosting_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestIconUrlField() {
            return this.requestIconUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestIconUrlField(boolean value) {
            this.requestField("icon_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdvertisableApplications requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestIosBundleIdField() {
            return this.requestIosBundleIdField(true);
        }

        public APIRequestGetAdvertisableApplications requestIosBundleIdField(boolean value) {
            this.requestField("ios_bundle_id", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestIosSdkDialogFlowsField() {
            return this.requestIosSdkDialogFlowsField(true);
        }

        public APIRequestGetAdvertisableApplications requestIosSdkDialogFlowsField(boolean value) {
            this.requestField("ios_sdk_dialog_flows", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestIosSdkErrorCategoriesField() {
            return this.requestIosSdkErrorCategoriesField(true);
        }

        public APIRequestGetAdvertisableApplications requestIosSdkErrorCategoriesField(boolean value) {
            this.requestField("ios_sdk_error_categories", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestIosSfvcAttrField() {
            return this.requestIosSfvcAttrField(true);
        }

        public APIRequestGetAdvertisableApplications requestIosSfvcAttrField(boolean value) {
            this.requestField("ios_sfvc_attr", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestIosSupportsNativeProxyAuthFlowField() {
            return this.requestIosSupportsNativeProxyAuthFlowField(true);
        }

        public APIRequestGetAdvertisableApplications requestIosSupportsNativeProxyAuthFlowField(boolean value) {
            this.requestField("ios_supports_native_proxy_auth_flow", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestIosSupportsSystemAuthField() {
            return this.requestIosSupportsSystemAuthField(true);
        }

        public APIRequestGetAdvertisableApplications requestIosSupportsSystemAuthField(boolean value) {
            this.requestField("ios_supports_system_auth", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestIpadAppStoreIdField() {
            return this.requestIpadAppStoreIdField(true);
        }

        public APIRequestGetAdvertisableApplications requestIpadAppStoreIdField(boolean value) {
            this.requestField("ipad_app_store_id", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestIphoneAppStoreIdField() {
            return this.requestIphoneAppStoreIdField(true);
        }

        public APIRequestGetAdvertisableApplications requestIphoneAppStoreIdField(boolean value) {
            this.requestField("iphone_app_store_id", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestIsViewerAdminField() {
            return this.requestIsViewerAdminField(true);
        }

        public APIRequestGetAdvertisableApplications requestIsViewerAdminField(boolean value) {
            this.requestField("is_viewer_admin", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestLatestSdkVersionField() {
            return this.requestLatestSdkVersionField(true);
        }

        public APIRequestGetAdvertisableApplications requestLatestSdkVersionField(boolean value) {
            this.requestField("latest_sdk_version", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetAdvertisableApplications requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestLoggingTokenField() {
            return this.requestLoggingTokenField(true);
        }

        public APIRequestGetAdvertisableApplications requestLoggingTokenField(boolean value) {
            this.requestField("logging_token", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestLoginSecretField() {
            return this.requestLoginSecretField(true);
        }

        public APIRequestGetAdvertisableApplications requestLoginSecretField(boolean value) {
            this.requestField("login_secret", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestLogoUrlField() {
            return this.requestLogoUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestLogoUrlField(boolean value) {
            this.requestField("logo_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestMigrationsField() {
            return this.requestMigrationsField(true);
        }

        public APIRequestGetAdvertisableApplications requestMigrationsField(boolean value) {
            this.requestField("migrations", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestMobileProfileSectionUrlField() {
            return this.requestMobileProfileSectionUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestMobileProfileSectionUrlField(boolean value) {
            this.requestField("mobile_profile_section_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestMobileWebUrlField() {
            return this.requestMobileWebUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestMobileWebUrlField(boolean value) {
            this.requestField("mobile_web_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestMonthlyActiveUsersField() {
            return this.requestMonthlyActiveUsersField(true);
        }

        public APIRequestGetAdvertisableApplications requestMonthlyActiveUsersField(boolean value) {
            this.requestField("monthly_active_users", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestMonthlyActiveUsersRankField() {
            return this.requestMonthlyActiveUsersRankField(true);
        }

        public APIRequestGetAdvertisableApplications requestMonthlyActiveUsersRankField(boolean value) {
            this.requestField("monthly_active_users_rank", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdvertisableApplications requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestNamespaceField() {
            return this.requestNamespaceField(true);
        }

        public APIRequestGetAdvertisableApplications requestNamespaceField(boolean value) {
            this.requestField("namespace", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestObjectStoreUrlsField() {
            return this.requestObjectStoreUrlsField(true);
        }

        public APIRequestGetAdvertisableApplications requestObjectStoreUrlsField(boolean value) {
            this.requestField("object_store_urls", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestPageTabDefaultNameField() {
            return this.requestPageTabDefaultNameField(true);
        }

        public APIRequestGetAdvertisableApplications requestPageTabDefaultNameField(boolean value) {
            this.requestField("page_tab_default_name", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestPageTabUrlField() {
            return this.requestPageTabUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestPageTabUrlField(boolean value) {
            this.requestField("page_tab_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestPhotoUrlField() {
            return this.requestPhotoUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestPhotoUrlField(boolean value) {
            this.requestField("photo_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestPrivacyPolicyUrlField() {
            return this.requestPrivacyPolicyUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestPrivacyPolicyUrlField(boolean value) {
            this.requestField("privacy_policy_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestProfileSectionUrlField() {
            return this.requestProfileSectionUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestProfileSectionUrlField(boolean value) {
            this.requestField("profile_section_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestPropertyIdField() {
            return this.requestPropertyIdField(true);
        }

        public APIRequestGetAdvertisableApplications requestPropertyIdField(boolean value) {
            this.requestField("property_id", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestRealTimeModeDevicesField() {
            return this.requestRealTimeModeDevicesField(true);
        }

        public APIRequestGetAdvertisableApplications requestRealTimeModeDevicesField(boolean value) {
            this.requestField("real_time_mode_devices", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestRestrictionsField() {
            return this.requestRestrictionsField(true);
        }

        public APIRequestGetAdvertisableApplications requestRestrictionsField(boolean value) {
            this.requestField("restrictions", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestSdkUpdateMessageField() {
            return this.requestSdkUpdateMessageField(true);
        }

        public APIRequestGetAdvertisableApplications requestSdkUpdateMessageField(boolean value) {
            this.requestField("sdk_update_message", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestSeamlessLoginField() {
            return this.requestSeamlessLoginField(true);
        }

        public APIRequestGetAdvertisableApplications requestSeamlessLoginField(boolean value) {
            this.requestField("seamless_login", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestSecureCanvasUrlField() {
            return this.requestSecureCanvasUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestSecureCanvasUrlField(boolean value) {
            this.requestField("secure_canvas_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestSecurePageTabUrlField() {
            return this.requestSecurePageTabUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestSecurePageTabUrlField(boolean value) {
            this.requestField("secure_page_tab_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestServerIpWhitelistField() {
            return this.requestServerIpWhitelistField(true);
        }

        public APIRequestGetAdvertisableApplications requestServerIpWhitelistField(boolean value) {
            this.requestField("server_ip_whitelist", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestSmartLoginBookmarkIconUrlField() {
            return this.requestSmartLoginBookmarkIconUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestSmartLoginBookmarkIconUrlField(boolean value) {
            this.requestField("smart_login_bookmark_icon_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestSmartLoginMenuIconUrlField() {
            return this.requestSmartLoginMenuIconUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestSmartLoginMenuIconUrlField(boolean value) {
            this.requestField("smart_login_menu_icon_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestSocialDiscoveryField() {
            return this.requestSocialDiscoveryField(true);
        }

        public APIRequestGetAdvertisableApplications requestSocialDiscoveryField(boolean value) {
            this.requestField("social_discovery", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestSubcategoryField() {
            return this.requestSubcategoryField(true);
        }

        public APIRequestGetAdvertisableApplications requestSubcategoryField(boolean value) {
            this.requestField("subcategory", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestSupportedPlatformsField() {
            return this.requestSupportedPlatformsField(true);
        }

        public APIRequestGetAdvertisableApplications requestSupportedPlatformsField(boolean value) {
            this.requestField("supported_platforms", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestSupportsApprequestsFastAppSwitchField() {
            return this.requestSupportsApprequestsFastAppSwitchField(true);
        }

        public APIRequestGetAdvertisableApplications requestSupportsApprequestsFastAppSwitchField(boolean value) {
            this.requestField("supports_apprequests_fast_app_switch", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestSupportsAttributionField() {
            return this.requestSupportsAttributionField(true);
        }

        public APIRequestGetAdvertisableApplications requestSupportsAttributionField(boolean value) {
            this.requestField("supports_attribution", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestSupportsImplicitSdkLoggingField() {
            return this.requestSupportsImplicitSdkLoggingField(true);
        }

        public APIRequestGetAdvertisableApplications requestSupportsImplicitSdkLoggingField(boolean value) {
            this.requestField("supports_implicit_sdk_logging", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestSuppressNativeIosGdpField() {
            return this.requestSuppressNativeIosGdpField(true);
        }

        public APIRequestGetAdvertisableApplications requestSuppressNativeIosGdpField(boolean value) {
            this.requestField("suppress_native_ios_gdp", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestTermsOfServiceUrlField() {
            return this.requestTermsOfServiceUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestTermsOfServiceUrlField(boolean value) {
            this.requestField("terms_of_service_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestUrlSchemeSuffixField() {
            return this.requestUrlSchemeSuffixField(true);
        }

        public APIRequestGetAdvertisableApplications requestUrlSchemeSuffixField(boolean value) {
            this.requestField("url_scheme_suffix", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestUserSupportEmailField() {
            return this.requestUserSupportEmailField(true);
        }

        public APIRequestGetAdvertisableApplications requestUserSupportEmailField(boolean value) {
            this.requestField("user_support_email", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestUserSupportUrlField() {
            return this.requestUserSupportUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestUserSupportUrlField(boolean value) {
            this.requestField("user_support_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestWebsiteUrlField() {
            return this.requestWebsiteUrlField(true);
        }

        public APIRequestGetAdvertisableApplications requestWebsiteUrlField(boolean value) {
            this.requestField("website_url", value);
            return this;
        }

        public APIRequestGetAdvertisableApplications requestWeeklyActiveUsersField() {
            return this.requestWeeklyActiveUsersField(true);
        }

        public APIRequestGetAdvertisableApplications requestWeeklyActiveUsersField(boolean value) {
            this.requestField("weekly_active_users", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdTopLines
    extends APIRequest<AdTopline> {
        APINodeList<AdTopline> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "client_approval_date", "created_by", "created_date", "description", "flight_end_date", "flight_start_date", "func_cap_amount", "func_cap_amount_with_offset", "func_line_amount", "func_line_amount_with_offset", "func_price", "func_price_with_offset", "gender", "id", "impressions", "io_number", "is_bonus_line", "keywords", "last_updated_by", "last_updated_date", "line_number", "line_position", "line_type", "location", "max_age", "max_budget", "min_age", "price_per_trp", "product_type", "rev_assurance_approval_date", "targets", "trp_updated_time", "trp_value", "uom"};

        @Override
        public APINodeList<AdTopline> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdTopline> parseResponse(String response) throws APIException {
            return AdTopline.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdTopline> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdTopline> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdTopline>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdTopline>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdTopline>>(){

                public APINodeList<AdTopline> apply(String result) {
                    try {
                        return APIRequestGetAdTopLines.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdTopLines(String nodeId, APIContext context) {
            super(context, nodeId, "/adtoplines", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdTopLines setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdTopLines setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdTopLines requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdTopLines requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdTopLines requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdTopLines requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdTopLines requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdTopLines requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdTopLines requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAdTopLines requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAdTopLines requestClientApprovalDateField() {
            return this.requestClientApprovalDateField(true);
        }

        public APIRequestGetAdTopLines requestClientApprovalDateField(boolean value) {
            this.requestField("client_approval_date", value);
            return this;
        }

        public APIRequestGetAdTopLines requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGetAdTopLines requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGetAdTopLines requestCreatedDateField() {
            return this.requestCreatedDateField(true);
        }

        public APIRequestGetAdTopLines requestCreatedDateField(boolean value) {
            this.requestField("created_date", value);
            return this;
        }

        public APIRequestGetAdTopLines requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetAdTopLines requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetAdTopLines requestFlightEndDateField() {
            return this.requestFlightEndDateField(true);
        }

        public APIRequestGetAdTopLines requestFlightEndDateField(boolean value) {
            this.requestField("flight_end_date", value);
            return this;
        }

        public APIRequestGetAdTopLines requestFlightStartDateField() {
            return this.requestFlightStartDateField(true);
        }

        public APIRequestGetAdTopLines requestFlightStartDateField(boolean value) {
            this.requestField("flight_start_date", value);
            return this;
        }

        public APIRequestGetAdTopLines requestFuncCapAmountField() {
            return this.requestFuncCapAmountField(true);
        }

        public APIRequestGetAdTopLines requestFuncCapAmountField(boolean value) {
            this.requestField("func_cap_amount", value);
            return this;
        }

        public APIRequestGetAdTopLines requestFuncCapAmountWithOffsetField() {
            return this.requestFuncCapAmountWithOffsetField(true);
        }

        public APIRequestGetAdTopLines requestFuncCapAmountWithOffsetField(boolean value) {
            this.requestField("func_cap_amount_with_offset", value);
            return this;
        }

        public APIRequestGetAdTopLines requestFuncLineAmountField() {
            return this.requestFuncLineAmountField(true);
        }

        public APIRequestGetAdTopLines requestFuncLineAmountField(boolean value) {
            this.requestField("func_line_amount", value);
            return this;
        }

        public APIRequestGetAdTopLines requestFuncLineAmountWithOffsetField() {
            return this.requestFuncLineAmountWithOffsetField(true);
        }

        public APIRequestGetAdTopLines requestFuncLineAmountWithOffsetField(boolean value) {
            this.requestField("func_line_amount_with_offset", value);
            return this;
        }

        public APIRequestGetAdTopLines requestFuncPriceField() {
            return this.requestFuncPriceField(true);
        }

        public APIRequestGetAdTopLines requestFuncPriceField(boolean value) {
            this.requestField("func_price", value);
            return this;
        }

        public APIRequestGetAdTopLines requestFuncPriceWithOffsetField() {
            return this.requestFuncPriceWithOffsetField(true);
        }

        public APIRequestGetAdTopLines requestFuncPriceWithOffsetField(boolean value) {
            this.requestField("func_price_with_offset", value);
            return this;
        }

        public APIRequestGetAdTopLines requestGenderField() {
            return this.requestGenderField(true);
        }

        public APIRequestGetAdTopLines requestGenderField(boolean value) {
            this.requestField("gender", value);
            return this;
        }

        public APIRequestGetAdTopLines requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdTopLines requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdTopLines requestImpressionsField() {
            return this.requestImpressionsField(true);
        }

        public APIRequestGetAdTopLines requestImpressionsField(boolean value) {
            this.requestField("impressions", value);
            return this;
        }

        public APIRequestGetAdTopLines requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGetAdTopLines requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGetAdTopLines requestIsBonusLineField() {
            return this.requestIsBonusLineField(true);
        }

        public APIRequestGetAdTopLines requestIsBonusLineField(boolean value) {
            this.requestField("is_bonus_line", value);
            return this;
        }

        public APIRequestGetAdTopLines requestKeywordsField() {
            return this.requestKeywordsField(true);
        }

        public APIRequestGetAdTopLines requestKeywordsField(boolean value) {
            this.requestField("keywords", value);
            return this;
        }

        public APIRequestGetAdTopLines requestLastUpdatedByField() {
            return this.requestLastUpdatedByField(true);
        }

        public APIRequestGetAdTopLines requestLastUpdatedByField(boolean value) {
            this.requestField("last_updated_by", value);
            return this;
        }

        public APIRequestGetAdTopLines requestLastUpdatedDateField() {
            return this.requestLastUpdatedDateField(true);
        }

        public APIRequestGetAdTopLines requestLastUpdatedDateField(boolean value) {
            this.requestField("last_updated_date", value);
            return this;
        }

        public APIRequestGetAdTopLines requestLineNumberField() {
            return this.requestLineNumberField(true);
        }

        public APIRequestGetAdTopLines requestLineNumberField(boolean value) {
            this.requestField("line_number", value);
            return this;
        }

        public APIRequestGetAdTopLines requestLinePositionField() {
            return this.requestLinePositionField(true);
        }

        public APIRequestGetAdTopLines requestLinePositionField(boolean value) {
            this.requestField("line_position", value);
            return this;
        }

        public APIRequestGetAdTopLines requestLineTypeField() {
            return this.requestLineTypeField(true);
        }

        public APIRequestGetAdTopLines requestLineTypeField(boolean value) {
            this.requestField("line_type", value);
            return this;
        }

        public APIRequestGetAdTopLines requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetAdTopLines requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetAdTopLines requestMaxAgeField() {
            return this.requestMaxAgeField(true);
        }

        public APIRequestGetAdTopLines requestMaxAgeField(boolean value) {
            this.requestField("max_age", value);
            return this;
        }

        public APIRequestGetAdTopLines requestMaxBudgetField() {
            return this.requestMaxBudgetField(true);
        }

        public APIRequestGetAdTopLines requestMaxBudgetField(boolean value) {
            this.requestField("max_budget", value);
            return this;
        }

        public APIRequestGetAdTopLines requestMinAgeField() {
            return this.requestMinAgeField(true);
        }

        public APIRequestGetAdTopLines requestMinAgeField(boolean value) {
            this.requestField("min_age", value);
            return this;
        }

        public APIRequestGetAdTopLines requestPricePerTrpField() {
            return this.requestPricePerTrpField(true);
        }

        public APIRequestGetAdTopLines requestPricePerTrpField(boolean value) {
            this.requestField("price_per_trp", value);
            return this;
        }

        public APIRequestGetAdTopLines requestProductTypeField() {
            return this.requestProductTypeField(true);
        }

        public APIRequestGetAdTopLines requestProductTypeField(boolean value) {
            this.requestField("product_type", value);
            return this;
        }

        public APIRequestGetAdTopLines requestRevAssuranceApprovalDateField() {
            return this.requestRevAssuranceApprovalDateField(true);
        }

        public APIRequestGetAdTopLines requestRevAssuranceApprovalDateField(boolean value) {
            this.requestField("rev_assurance_approval_date", value);
            return this;
        }

        public APIRequestGetAdTopLines requestTargetsField() {
            return this.requestTargetsField(true);
        }

        public APIRequestGetAdTopLines requestTargetsField(boolean value) {
            this.requestField("targets", value);
            return this;
        }

        public APIRequestGetAdTopLines requestTrpUpdatedTimeField() {
            return this.requestTrpUpdatedTimeField(true);
        }

        public APIRequestGetAdTopLines requestTrpUpdatedTimeField(boolean value) {
            this.requestField("trp_updated_time", value);
            return this;
        }

        public APIRequestGetAdTopLines requestTrpValueField() {
            return this.requestTrpValueField(true);
        }

        public APIRequestGetAdTopLines requestTrpValueField(boolean value) {
            this.requestField("trp_value", value);
            return this;
        }

        public APIRequestGetAdTopLines requestUomField() {
            return this.requestUomField(true);
        }

        public APIRequestGetAdTopLines requestUomField(boolean value) {
            this.requestField("uom", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdToplineDetails
    extends APIRequest<AdToplineDetail> {
        APINodeList<AdToplineDetail> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"active_status", "ad_account_id", "flight_end_date", "flight_start_date", "id", "io_number", "line_number", "price", "quantity", "sf_detail_line_id", "subline_id", "targets", "time_created", "time_updated", "topline_id"};

        @Override
        public APINodeList<AdToplineDetail> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdToplineDetail> parseResponse(String response) throws APIException {
            return AdToplineDetail.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdToplineDetail> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdToplineDetail> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdToplineDetail>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdToplineDetail>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdToplineDetail>>(){

                public APINodeList<AdToplineDetail> apply(String result) {
                    try {
                        return APIRequestGetAdToplineDetails.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdToplineDetails(String nodeId, APIContext context) {
            super(context, nodeId, "/adtoplinedetails", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdToplineDetails setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdToplineDetails setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdToplineDetails requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdToplineDetails requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdToplineDetails requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdToplineDetails requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdToplineDetails requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdToplineDetails requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdToplineDetails requestActiveStatusField() {
            return this.requestActiveStatusField(true);
        }

        public APIRequestGetAdToplineDetails requestActiveStatusField(boolean value) {
            this.requestField("active_status", value);
            return this;
        }

        public APIRequestGetAdToplineDetails requestAdAccountIdField() {
            return this.requestAdAccountIdField(true);
        }

        public APIRequestGetAdToplineDetails requestAdAccountIdField(boolean value) {
            this.requestField("ad_account_id", value);
            return this;
        }

        public APIRequestGetAdToplineDetails requestFlightEndDateField() {
            return this.requestFlightEndDateField(true);
        }

        public APIRequestGetAdToplineDetails requestFlightEndDateField(boolean value) {
            this.requestField("flight_end_date", value);
            return this;
        }

        public APIRequestGetAdToplineDetails requestFlightStartDateField() {
            return this.requestFlightStartDateField(true);
        }

        public APIRequestGetAdToplineDetails requestFlightStartDateField(boolean value) {
            this.requestField("flight_start_date", value);
            return this;
        }

        public APIRequestGetAdToplineDetails requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdToplineDetails requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdToplineDetails requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGetAdToplineDetails requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGetAdToplineDetails requestLineNumberField() {
            return this.requestLineNumberField(true);
        }

        public APIRequestGetAdToplineDetails requestLineNumberField(boolean value) {
            this.requestField("line_number", value);
            return this;
        }

        public APIRequestGetAdToplineDetails requestPriceField() {
            return this.requestPriceField(true);
        }

        public APIRequestGetAdToplineDetails requestPriceField(boolean value) {
            this.requestField("price", value);
            return this;
        }

        public APIRequestGetAdToplineDetails requestQuantityField() {
            return this.requestQuantityField(true);
        }

        public APIRequestGetAdToplineDetails requestQuantityField(boolean value) {
            this.requestField("quantity", value);
            return this;
        }

        public APIRequestGetAdToplineDetails requestSfDetailLineIdField() {
            return this.requestSfDetailLineIdField(true);
        }

        public APIRequestGetAdToplineDetails requestSfDetailLineIdField(boolean value) {
            this.requestField("sf_detail_line_id", value);
            return this;
        }

        public APIRequestGetAdToplineDetails requestSublineIdField() {
            return this.requestSublineIdField(true);
        }

        public APIRequestGetAdToplineDetails requestSublineIdField(boolean value) {
            this.requestField("subline_id", value);
            return this;
        }

        public APIRequestGetAdToplineDetails requestTargetsField() {
            return this.requestTargetsField(true);
        }

        public APIRequestGetAdToplineDetails requestTargetsField(boolean value) {
            this.requestField("targets", value);
            return this;
        }

        public APIRequestGetAdToplineDetails requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGetAdToplineDetails requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGetAdToplineDetails requestTimeUpdatedField() {
            return this.requestTimeUpdatedField(true);
        }

        public APIRequestGetAdToplineDetails requestTimeUpdatedField(boolean value) {
            this.requestField("time_updated", value);
            return this;
        }

        public APIRequestGetAdToplineDetails requestToplineIdField() {
            return this.requestToplineIdField(true);
        }

        public APIRequestGetAdToplineDetails requestToplineIdField(boolean value) {
            this.requestField("topline_id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAdsPixel
    extends APIRequest<AdsPixel> {
        AdsPixel lastResponse = null;
        public static final String[] PARAMS = new String[]{"name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdsPixel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsPixel parseResponse(String response) throws APIException {
            return AdsPixel.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdsPixel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsPixel execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdsPixel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsPixel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdsPixel>(){

                public AdsPixel apply(String result) {
                    try {
                        return APIRequestCreateAdsPixel.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAdsPixel(String nodeId, APIContext context) {
            super(context, nodeId, "/adspixels", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAdsPixel setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAdsPixel setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAdsPixel setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateAdsPixel requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAdsPixel requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdsPixel requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAdsPixel requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdsPixel requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAdsPixel requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdsPixels
    extends APIRequest<AdsPixel> {
        APINodeList<AdsPixel> lastResponse = null;
        public static final String[] PARAMS = new String[]{"sort_by"};
        public static final String[] FIELDS = new String[]{"automatic_matching_fields", "can_proxy", "code", "creation_time", "creator", "data_use_setting", "enable_automatic_matching", "first_party_cookie_status", "id", "is_created_by_business", "last_fired_time", "name", "owner_ad_account", "owner_business"};

        @Override
        public APINodeList<AdsPixel> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdsPixel> parseResponse(String response) throws APIException {
            return AdsPixel.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdsPixel> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdsPixel> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdsPixel>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdsPixel>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdsPixel>>(){

                public APINodeList<AdsPixel> apply(String result) {
                    try {
                        return APIRequestGetAdsPixels.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdsPixels(String nodeId, APIContext context) {
            super(context, nodeId, "/adspixels", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdsPixels setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdsPixels setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdsPixels setSortBy(AdsPixel.EnumSortBy sortBy) {
            this.setParam("sort_by", (Object)sortBy);
            return this;
        }

        public APIRequestGetAdsPixels setSortBy(String sortBy) {
            this.setParam("sort_by", sortBy);
            return this;
        }

        public APIRequestGetAdsPixels requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdsPixels requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdsPixels requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdsPixels requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdsPixels requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdsPixels requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdsPixels requestAutomaticMatchingFieldsField() {
            return this.requestAutomaticMatchingFieldsField(true);
        }

        public APIRequestGetAdsPixels requestAutomaticMatchingFieldsField(boolean value) {
            this.requestField("automatic_matching_fields", value);
            return this;
        }

        public APIRequestGetAdsPixels requestCanProxyField() {
            return this.requestCanProxyField(true);
        }

        public APIRequestGetAdsPixels requestCanProxyField(boolean value) {
            this.requestField("can_proxy", value);
            return this;
        }

        public APIRequestGetAdsPixels requestCodeField() {
            return this.requestCodeField(true);
        }

        public APIRequestGetAdsPixels requestCodeField(boolean value) {
            this.requestField("code", value);
            return this;
        }

        public APIRequestGetAdsPixels requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGetAdsPixels requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGetAdsPixels requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGetAdsPixels requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGetAdsPixels requestDataUseSettingField() {
            return this.requestDataUseSettingField(true);
        }

        public APIRequestGetAdsPixels requestDataUseSettingField(boolean value) {
            this.requestField("data_use_setting", value);
            return this;
        }

        public APIRequestGetAdsPixels requestEnableAutomaticMatchingField() {
            return this.requestEnableAutomaticMatchingField(true);
        }

        public APIRequestGetAdsPixels requestEnableAutomaticMatchingField(boolean value) {
            this.requestField("enable_automatic_matching", value);
            return this;
        }

        public APIRequestGetAdsPixels requestFirstPartyCookieStatusField() {
            return this.requestFirstPartyCookieStatusField(true);
        }

        public APIRequestGetAdsPixels requestFirstPartyCookieStatusField(boolean value) {
            this.requestField("first_party_cookie_status", value);
            return this;
        }

        public APIRequestGetAdsPixels requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdsPixels requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdsPixels requestIsCreatedByBusinessField() {
            return this.requestIsCreatedByBusinessField(true);
        }

        public APIRequestGetAdsPixels requestIsCreatedByBusinessField(boolean value) {
            this.requestField("is_created_by_business", value);
            return this;
        }

        public APIRequestGetAdsPixels requestLastFiredTimeField() {
            return this.requestLastFiredTimeField(true);
        }

        public APIRequestGetAdsPixels requestLastFiredTimeField(boolean value) {
            this.requestField("last_fired_time", value);
            return this;
        }

        public APIRequestGetAdsPixels requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdsPixels requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdsPixels requestOwnerAdAccountField() {
            return this.requestOwnerAdAccountField(true);
        }

        public APIRequestGetAdsPixels requestOwnerAdAccountField(boolean value) {
            this.requestField("owner_ad_account", value);
            return this;
        }

        public APIRequestGetAdsPixels requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetAdsPixels requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdSetsByLabels
    extends APIRequest<AdSet> {
        APINodeList<AdSet> lastResponse = null;
        public static final String[] PARAMS = new String[]{"ad_label_ids", "operator"};
        public static final String[] FIELDS = new String[]{"account_id", "ad_keywords", "adasset_feed", "adlabels", "adset_schedule", "asset_feed_id", "attribution_spec", "best_creative", "bid_adjustments", "bid_amount", "bid_constraints", "bid_info", "bid_strategy", "billing_event", "budget_remaining", "campaign", "campaign_id", "configured_status", "created_time", "creative_sequence", "daily_budget", "daily_min_spend_target", "daily_spend_cap", "destination_type", "effective_status", "end_time", "frequency_cap", "frequency_cap_reset_period", "frequency_control_specs", "full_funnel_exploration_mode", "id", "instagram_actor_id", "is_autobid", "is_average_price_pacing", "is_dynamic_creative", "is_dynamic_creative_optimization", "issues_info", "lifetime_budget", "lifetime_frequency_cap", "lifetime_imps", "lifetime_min_spend_target", "lifetime_spend_cap", "name", "optimization_goal", "pacing_type", "promoted_object", "recommendations", "recurring_budget_semantics", "review_feedback", "rf_prediction_id", "rtb_flag", "source_adset", "source_adset_id", "start_time", "status", "targeting", "time_based_ad_rotation_id_blocks", "time_based_ad_rotation_intervals", "tracking_specs", "updated_time", "use_new_app_click"};

        @Override
        public APINodeList<AdSet> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdSet> parseResponse(String response) throws APIException {
            return AdSet.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdSet> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdSet> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdSet>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdSet>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdSet>>(){

                public APINodeList<AdSet> apply(String result) {
                    try {
                        return APIRequestGetAdSetsByLabels.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdSetsByLabels(String nodeId, APIContext context) {
            super(context, nodeId, "/adsetsbylabels", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdSetsByLabels setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdSetsByLabels setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdSetsByLabels setAdLabelIds(List<String> adLabelIds) {
            this.setParam("ad_label_ids", adLabelIds);
            return this;
        }

        public APIRequestGetAdSetsByLabels setAdLabelIds(String adLabelIds) {
            this.setParam("ad_label_ids", adLabelIds);
            return this;
        }

        public APIRequestGetAdSetsByLabels setOperator(AdSet.EnumOperator operator) {
            this.setParam("operator", (Object)operator);
            return this;
        }

        public APIRequestGetAdSetsByLabels setOperator(String operator) {
            this.setParam("operator", operator);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdSetsByLabels requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdSetsByLabels requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdSetsByLabels requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdSetsByLabels requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdSetsByLabels requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAdSetsByLabels requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestAdKeywordsField() {
            return this.requestAdKeywordsField(true);
        }

        public APIRequestGetAdSetsByLabels requestAdKeywordsField(boolean value) {
            this.requestField("ad_keywords", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestAdassetFeedField() {
            return this.requestAdassetFeedField(true);
        }

        public APIRequestGetAdSetsByLabels requestAdassetFeedField(boolean value) {
            this.requestField("adasset_feed", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGetAdSetsByLabels requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestAdsetScheduleField() {
            return this.requestAdsetScheduleField(true);
        }

        public APIRequestGetAdSetsByLabels requestAdsetScheduleField(boolean value) {
            this.requestField("adset_schedule", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestAssetFeedIdField() {
            return this.requestAssetFeedIdField(true);
        }

        public APIRequestGetAdSetsByLabels requestAssetFeedIdField(boolean value) {
            this.requestField("asset_feed_id", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetAdSetsByLabels requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestBestCreativeField() {
            return this.requestBestCreativeField(true);
        }

        public APIRequestGetAdSetsByLabels requestBestCreativeField(boolean value) {
            this.requestField("best_creative", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestBidAdjustmentsField() {
            return this.requestBidAdjustmentsField(true);
        }

        public APIRequestGetAdSetsByLabels requestBidAdjustmentsField(boolean value) {
            this.requestField("bid_adjustments", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestBidAmountField() {
            return this.requestBidAmountField(true);
        }

        public APIRequestGetAdSetsByLabels requestBidAmountField(boolean value) {
            this.requestField("bid_amount", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestBidConstraintsField() {
            return this.requestBidConstraintsField(true);
        }

        public APIRequestGetAdSetsByLabels requestBidConstraintsField(boolean value) {
            this.requestField("bid_constraints", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestBidInfoField() {
            return this.requestBidInfoField(true);
        }

        public APIRequestGetAdSetsByLabels requestBidInfoField(boolean value) {
            this.requestField("bid_info", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestBidStrategyField() {
            return this.requestBidStrategyField(true);
        }

        public APIRequestGetAdSetsByLabels requestBidStrategyField(boolean value) {
            this.requestField("bid_strategy", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestBillingEventField() {
            return this.requestBillingEventField(true);
        }

        public APIRequestGetAdSetsByLabels requestBillingEventField(boolean value) {
            this.requestField("billing_event", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestBudgetRemainingField() {
            return this.requestBudgetRemainingField(true);
        }

        public APIRequestGetAdSetsByLabels requestBudgetRemainingField(boolean value) {
            this.requestField("budget_remaining", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestCampaignField() {
            return this.requestCampaignField(true);
        }

        public APIRequestGetAdSetsByLabels requestCampaignField(boolean value) {
            this.requestField("campaign", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGetAdSetsByLabels requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestConfiguredStatusField() {
            return this.requestConfiguredStatusField(true);
        }

        public APIRequestGetAdSetsByLabels requestConfiguredStatusField(boolean value) {
            this.requestField("configured_status", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAdSetsByLabels requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestCreativeSequenceField() {
            return this.requestCreativeSequenceField(true);
        }

        public APIRequestGetAdSetsByLabels requestCreativeSequenceField(boolean value) {
            this.requestField("creative_sequence", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestDailyBudgetField() {
            return this.requestDailyBudgetField(true);
        }

        public APIRequestGetAdSetsByLabels requestDailyBudgetField(boolean value) {
            this.requestField("daily_budget", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestDailyMinSpendTargetField() {
            return this.requestDailyMinSpendTargetField(true);
        }

        public APIRequestGetAdSetsByLabels requestDailyMinSpendTargetField(boolean value) {
            this.requestField("daily_min_spend_target", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestDailySpendCapField() {
            return this.requestDailySpendCapField(true);
        }

        public APIRequestGetAdSetsByLabels requestDailySpendCapField(boolean value) {
            this.requestField("daily_spend_cap", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestDestinationTypeField() {
            return this.requestDestinationTypeField(true);
        }

        public APIRequestGetAdSetsByLabels requestDestinationTypeField(boolean value) {
            this.requestField("destination_type", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestEffectiveStatusField() {
            return this.requestEffectiveStatusField(true);
        }

        public APIRequestGetAdSetsByLabels requestEffectiveStatusField(boolean value) {
            this.requestField("effective_status", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGetAdSetsByLabels requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestFrequencyCapField() {
            return this.requestFrequencyCapField(true);
        }

        public APIRequestGetAdSetsByLabels requestFrequencyCapField(boolean value) {
            this.requestField("frequency_cap", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestFrequencyCapResetPeriodField() {
            return this.requestFrequencyCapResetPeriodField(true);
        }

        public APIRequestGetAdSetsByLabels requestFrequencyCapResetPeriodField(boolean value) {
            this.requestField("frequency_cap_reset_period", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestFrequencyControlSpecsField() {
            return this.requestFrequencyControlSpecsField(true);
        }

        public APIRequestGetAdSetsByLabels requestFrequencyControlSpecsField(boolean value) {
            this.requestField("frequency_control_specs", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestFullFunnelExplorationModeField() {
            return this.requestFullFunnelExplorationModeField(true);
        }

        public APIRequestGetAdSetsByLabels requestFullFunnelExplorationModeField(boolean value) {
            this.requestField("full_funnel_exploration_mode", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdSetsByLabels requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestInstagramActorIdField() {
            return this.requestInstagramActorIdField(true);
        }

        public APIRequestGetAdSetsByLabels requestInstagramActorIdField(boolean value) {
            this.requestField("instagram_actor_id", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestIsAutobidField() {
            return this.requestIsAutobidField(true);
        }

        public APIRequestGetAdSetsByLabels requestIsAutobidField(boolean value) {
            this.requestField("is_autobid", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestIsAveragePricePacingField() {
            return this.requestIsAveragePricePacingField(true);
        }

        public APIRequestGetAdSetsByLabels requestIsAveragePricePacingField(boolean value) {
            this.requestField("is_average_price_pacing", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestIsDynamicCreativeField() {
            return this.requestIsDynamicCreativeField(true);
        }

        public APIRequestGetAdSetsByLabels requestIsDynamicCreativeField(boolean value) {
            this.requestField("is_dynamic_creative", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestIsDynamicCreativeOptimizationField() {
            return this.requestIsDynamicCreativeOptimizationField(true);
        }

        public APIRequestGetAdSetsByLabels requestIsDynamicCreativeOptimizationField(boolean value) {
            this.requestField("is_dynamic_creative_optimization", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestIssuesInfoField() {
            return this.requestIssuesInfoField(true);
        }

        public APIRequestGetAdSetsByLabels requestIssuesInfoField(boolean value) {
            this.requestField("issues_info", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestLifetimeBudgetField() {
            return this.requestLifetimeBudgetField(true);
        }

        public APIRequestGetAdSetsByLabels requestLifetimeBudgetField(boolean value) {
            this.requestField("lifetime_budget", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestLifetimeFrequencyCapField() {
            return this.requestLifetimeFrequencyCapField(true);
        }

        public APIRequestGetAdSetsByLabels requestLifetimeFrequencyCapField(boolean value) {
            this.requestField("lifetime_frequency_cap", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestLifetimeImpsField() {
            return this.requestLifetimeImpsField(true);
        }

        public APIRequestGetAdSetsByLabels requestLifetimeImpsField(boolean value) {
            this.requestField("lifetime_imps", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestLifetimeMinSpendTargetField() {
            return this.requestLifetimeMinSpendTargetField(true);
        }

        public APIRequestGetAdSetsByLabels requestLifetimeMinSpendTargetField(boolean value) {
            this.requestField("lifetime_min_spend_target", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestLifetimeSpendCapField() {
            return this.requestLifetimeSpendCapField(true);
        }

        public APIRequestGetAdSetsByLabels requestLifetimeSpendCapField(boolean value) {
            this.requestField("lifetime_spend_cap", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdSetsByLabels requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestOptimizationGoalField() {
            return this.requestOptimizationGoalField(true);
        }

        public APIRequestGetAdSetsByLabels requestOptimizationGoalField(boolean value) {
            this.requestField("optimization_goal", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestPacingTypeField() {
            return this.requestPacingTypeField(true);
        }

        public APIRequestGetAdSetsByLabels requestPacingTypeField(boolean value) {
            this.requestField("pacing_type", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestPromotedObjectField() {
            return this.requestPromotedObjectField(true);
        }

        public APIRequestGetAdSetsByLabels requestPromotedObjectField(boolean value) {
            this.requestField("promoted_object", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestRecommendationsField() {
            return this.requestRecommendationsField(true);
        }

        public APIRequestGetAdSetsByLabels requestRecommendationsField(boolean value) {
            this.requestField("recommendations", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestRecurringBudgetSemanticsField() {
            return this.requestRecurringBudgetSemanticsField(true);
        }

        public APIRequestGetAdSetsByLabels requestRecurringBudgetSemanticsField(boolean value) {
            this.requestField("recurring_budget_semantics", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestReviewFeedbackField() {
            return this.requestReviewFeedbackField(true);
        }

        public APIRequestGetAdSetsByLabels requestReviewFeedbackField(boolean value) {
            this.requestField("review_feedback", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestRfPredictionIdField() {
            return this.requestRfPredictionIdField(true);
        }

        public APIRequestGetAdSetsByLabels requestRfPredictionIdField(boolean value) {
            this.requestField("rf_prediction_id", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestRtbFlagField() {
            return this.requestRtbFlagField(true);
        }

        public APIRequestGetAdSetsByLabels requestRtbFlagField(boolean value) {
            this.requestField("rtb_flag", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestSourceAdsetField() {
            return this.requestSourceAdsetField(true);
        }

        public APIRequestGetAdSetsByLabels requestSourceAdsetField(boolean value) {
            this.requestField("source_adset", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestSourceAdsetIdField() {
            return this.requestSourceAdsetIdField(true);
        }

        public APIRequestGetAdSetsByLabels requestSourceAdsetIdField(boolean value) {
            this.requestField("source_adset_id", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetAdSetsByLabels requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetAdSetsByLabels requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGetAdSetsByLabels requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestTimeBasedAdRotationIdBlocksField() {
            return this.requestTimeBasedAdRotationIdBlocksField(true);
        }

        public APIRequestGetAdSetsByLabels requestTimeBasedAdRotationIdBlocksField(boolean value) {
            this.requestField("time_based_ad_rotation_id_blocks", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestTimeBasedAdRotationIntervalsField() {
            return this.requestTimeBasedAdRotationIntervalsField(true);
        }

        public APIRequestGetAdSetsByLabels requestTimeBasedAdRotationIntervalsField(boolean value) {
            this.requestField("time_based_ad_rotation_intervals", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestTrackingSpecsField() {
            return this.requestTrackingSpecsField(true);
        }

        public APIRequestGetAdSetsByLabels requestTrackingSpecsField(boolean value) {
            this.requestField("tracking_specs", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAdSetsByLabels requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetAdSetsByLabels requestUseNewAppClickField() {
            return this.requestUseNewAppClickField(true);
        }

        public APIRequestGetAdSetsByLabels requestUseNewAppClickField(boolean value) {
            this.requestField("use_new_app_click", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAdSet
    extends APIRequest<AdSet> {
        AdSet lastResponse = null;
        public static final String[] PARAMS = new String[]{"ad_keywords", "adlabels", "bid_amount", "bid_adjustments", "bid_strategy", "billing_event", "campaign_id", "campaign_spec", "adset_schedule", "status", "creative_sequence", "daily_budget", "daily_imps", "daily_min_spend_target", "daily_spend_cap", "date_format", "destination_type", "end_time", "execution_options", "frequency_cap", "frequency_cap_reset_period", "frequency_control_specs", "is_autobid", "is_average_price_pacing", "is_dynamic_creative", "is_dynamic_creative_optimization", "lifetime_budget", "lifetime_frequency_cap", "lifetime_imps", "lifetime_min_spend_target", "lifetime_spend_cap", "line_number", "name", "optimization_goal", "pacing_type", "promoted_object", "rb_prediction_id", "rf_prediction_id", "source_adset_id", "start_time", "targeting", "time_based_ad_rotation_id_blocks", "time_based_ad_rotation_intervals", "time_start", "time_stop", "topline_id", "upstream_events", "full_funnel_exploration_mode", "attribution_spec"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdSet getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdSet parseResponse(String response) throws APIException {
            return AdSet.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdSet execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdSet execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdSet> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdSet> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdSet>(){

                public AdSet apply(String result) {
                    try {
                        return APIRequestCreateAdSet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAdSet(String nodeId, APIContext context) {
            super(context, nodeId, "/adsets", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAdSet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAdSet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAdSet setAdKeywords(Object adKeywords) {
            this.setParam("ad_keywords", adKeywords);
            return this;
        }

        public APIRequestCreateAdSet setAdKeywords(String adKeywords) {
            this.setParam("ad_keywords", adKeywords);
            return this;
        }

        public APIRequestCreateAdSet setAdlabels(List<Object> adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestCreateAdSet setAdlabels(String adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestCreateAdSet setBidAmount(Long bidAmount) {
            this.setParam("bid_amount", bidAmount);
            return this;
        }

        public APIRequestCreateAdSet setBidAmount(String bidAmount) {
            this.setParam("bid_amount", bidAmount);
            return this;
        }

        public APIRequestCreateAdSet setBidAdjustments(Object bidAdjustments) {
            this.setParam("bid_adjustments", bidAdjustments);
            return this;
        }

        public APIRequestCreateAdSet setBidAdjustments(String bidAdjustments) {
            this.setParam("bid_adjustments", bidAdjustments);
            return this;
        }

        public APIRequestCreateAdSet setBidStrategy(AdSet.EnumBidStrategy bidStrategy) {
            this.setParam("bid_strategy", (Object)bidStrategy);
            return this;
        }

        public APIRequestCreateAdSet setBidStrategy(String bidStrategy) {
            this.setParam("bid_strategy", bidStrategy);
            return this;
        }

        public APIRequestCreateAdSet setBillingEvent(AdSet.EnumBillingEvent billingEvent) {
            this.setParam("billing_event", (Object)billingEvent);
           