/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetingGeoLocationElectoralDistrict
extends APINode {
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="electoral_district")
    private String mElectoralDistrict = null;
    @SerializedName(value="key")
    private String mKey = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    TargetingGeoLocationElectoralDistrict() {
    }

    public TargetingGeoLocationElectoralDistrict(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public TargetingGeoLocationElectoralDistrict(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public TargetingGeoLocationElectoralDistrict fetch() throws APIException {
        TargetingGeoLocationElectoralDistrict newInstance = TargetingGeoLocationElectoralDistrict.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static TargetingGeoLocationElectoralDistrict fetchById(Long id, APIContext context) throws APIException {
        return TargetingGeoLocationElectoralDistrict.fetchById(id.toString(), context);
    }

    public static ListenableFuture<TargetingGeoLocationElectoralDistrict> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return TargetingGeoLocationElectoralDistrict.fetchByIdAsync(id.toString(), context);
    }

    public static TargetingGeoLocationElectoralDistrict fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<TargetingGeoLocationElectoralDistrict> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<TargetingGeoLocationElectoralDistrict> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<TargetingGeoLocationElectoralDistrict>(context, "", "/", "GET", TargetingGeoLocationElectoralDistrict.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<TargetingGeoLocationElectoralDistrict>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<TargetingGeoLocationElectoralDistrict>(context, "", "/", "GET", TargetingGeoLocationElectoralDistrict.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static TargetingGeoLocationElectoralDistrict loadJSON(String json, APIContext context) {
        TargetingGeoLocationElectoralDistrict targetingGeoLocationElectoralDistrict = (TargetingGeoLocationElectoralDistrict)TargetingGeoLocationElectoralDistrict.getGson().fromJson(json, TargetingGeoLocationElectoralDistrict.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(targetingGeoLocationElectoralDistrict.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        targetingGeoLocationElectoralDistrict.context = context;
        targetingGeoLocationElectoralDistrict.rawValue = json;
        return targetingGeoLocationElectoralDistrict;
    }

    public static APINodeList<TargetingGeoLocationElectoralDistrict> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<TargetingGeoLocationElectoralDistrict> targetingGeoLocationElectoralDistricts = new APINodeList<TargetingGeoLocationElectoralDistrict>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        targetingGeoLocationElectoralDistricts.add(TargetingGeoLocationElectoralDistrict.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return targetingGeoLocationElectoralDistricts;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            targetingGeoLocationElectoralDistricts.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        targetingGeoLocationElectoralDistricts.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            targetingGeoLocationElectoralDistricts.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            targetingGeoLocationElectoralDistricts.add(TargetingGeoLocationElectoralDistrict.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                targetingGeoLocationElectoralDistricts.add(TargetingGeoLocationElectoralDistrict.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            targetingGeoLocationElectoralDistricts.add(TargetingGeoLocationElectoralDistrict.loadJSON(obj.toString(), context));
                        }
                    }
                    return targetingGeoLocationElectoralDistricts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        targetingGeoLocationElectoralDistricts.add(TargetingGeoLocationElectoralDistrict.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return targetingGeoLocationElectoralDistricts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        targetingGeoLocationElectoralDistricts.add(TargetingGeoLocationElectoralDistrict.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return targetingGeoLocationElectoralDistricts;
                }
                targetingGeoLocationElectoralDistricts.clear();
                targetingGeoLocationElectoralDistricts.add(TargetingGeoLocationElectoralDistrict.loadJSON(json, context));
                return targetingGeoLocationElectoralDistricts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return TargetingGeoLocationElectoralDistrict.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public String getFieldElectoralDistrict() {
        return this.mElectoralDistrict;
    }

    public String getFieldKey() {
        return this.mKey;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public TargetingGeoLocationElectoralDistrict copyFrom(TargetingGeoLocationElectoralDistrict instance) {
        this.mCountry = instance.mCountry;
        this.mElectoralDistrict = instance.mElectoralDistrict;
        this.mKey = instance.mKey;
        this.mName = instance.mName;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<TargetingGeoLocationElectoralDistrict> getParser() {
        return new APIRequest.ResponseParser<TargetingGeoLocationElectoralDistrict>(){

            @Override
            public APINodeList<TargetingGeoLocationElectoralDistrict> parseResponse(String response, APIContext context, APIRequest<TargetingGeoLocationElectoralDistrict> request) throws APIException.MalformedResponseException {
                return TargetingGeoLocationElectoralDistrict.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<TargetingGeoLocationElectoralDistrict> {
        TargetingGeoLocationElectoralDistrict lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"country", "electoral_district", "key", "name", "id"};

        @Override
        public TargetingGeoLocationElectoralDistrict getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public TargetingGeoLocationElectoralDistrict parseResponse(String response) throws APIException {
            return TargetingGeoLocationElectoralDistrict.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public TargetingGeoLocationElectoralDistrict execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public TargetingGeoLocationElectoralDistrict execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<TargetingGeoLocationElectoralDistrict> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<TargetingGeoLocationElectoralDistrict> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, TargetingGeoLocationElectoralDistrict>(){

                public TargetingGeoLocationElectoralDistrict apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCountryField() {
            return this.requestCountryField(true);
        }

        public APIRequestGet requestCountryField(boolean value) {
            this.requestField("country", value);
            return this;
        }

        public APIRequestGet requestElectoralDistrictField() {
            return this.requestElectoralDistrictField(true);
        }

        public APIRequestGet requestElectoralDistrictField(boolean value) {
            this.requestField("electoral_district", value);
            return this;
        }

        public APIRequestGet requestKeyField() {
            return this.requestKeyField(true);
        }

        public APIRequestGet requestKeyField(boolean value) {
            this.requestField("key", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

