/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.ProductItem;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductsQualityIssue
extends APINode {
    @SerializedName(value="count")
    private Long mCount = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="issue_type")
    private String mIssueType = null;
    @SerializedName(value="property_names")
    private List<String> mPropertyNames = null;
    @SerializedName(value="samples")
    private List<ProductItem> mSamples = null;
    @SerializedName(value="summary")
    private String mSummary = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    ProductsQualityIssue() {
    }

    public ProductsQualityIssue(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ProductsQualityIssue(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ProductsQualityIssue fetch() throws APIException {
        ProductsQualityIssue newInstance = ProductsQualityIssue.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ProductsQualityIssue fetchById(Long id, APIContext context) throws APIException {
        return ProductsQualityIssue.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ProductsQualityIssue> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ProductsQualityIssue.fetchByIdAsync(id.toString(), context);
    }

    public static ProductsQualityIssue fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ProductsQualityIssue> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ProductsQualityIssue> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ProductsQualityIssue>(context, "", "/", "GET", ProductsQualityIssue.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ProductsQualityIssue>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ProductsQualityIssue>(context, "", "/", "GET", ProductsQualityIssue.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProductsQualityIssue loadJSON(String json, APIContext context) {
        ProductsQualityIssue productsQualityIssue = (ProductsQualityIssue)ProductsQualityIssue.getGson().fromJson(json, ProductsQualityIssue.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productsQualityIssue.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productsQualityIssue.context = context;
        productsQualityIssue.rawValue = json;
        return productsQualityIssue;
    }

    public static APINodeList<ProductsQualityIssue> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductsQualityIssue> productsQualityIssues = new APINodeList<ProductsQualityIssue>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productsQualityIssues.add(ProductsQualityIssue.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return productsQualityIssues;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productsQualityIssues.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productsQualityIssues.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productsQualityIssues.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productsQualityIssues.add(ProductsQualityIssue.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productsQualityIssues.add(ProductsQualityIssue.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productsQualityIssues.add(ProductsQualityIssue.loadJSON(obj.toString(), context));
                        }
                    }
                    return productsQualityIssues;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productsQualityIssues.add(ProductsQualityIssue.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return productsQualityIssues;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productsQualityIssues.add(ProductsQualityIssue.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productsQualityIssues;
                }
                productsQualityIssues.clear();
                productsQualityIssues.add(ProductsQualityIssue.loadJSON(json, context));
                return productsQualityIssues;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductsQualityIssue.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldCount() {
        return this.mCount;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldIssueType() {
        return this.mIssueType;
    }

    public List<String> getFieldPropertyNames() {
        return this.mPropertyNames;
    }

    public List<ProductItem> getFieldSamples() {
        return this.mSamples;
    }

    public String getFieldSummary() {
        return this.mSummary;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductsQualityIssue copyFrom(ProductsQualityIssue instance) {
        this.mCount = instance.mCount;
        this.mDescription = instance.mDescription;
        this.mIssueType = instance.mIssueType;
        this.mPropertyNames = instance.mPropertyNames;
        this.mSamples = instance.mSamples;
        this.mSummary = instance.mSummary;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductsQualityIssue> getParser() {
        return new APIRequest.ResponseParser<ProductsQualityIssue>(){

            @Override
            public APINodeList<ProductsQualityIssue> parseResponse(String response, APIContext context, APIRequest<ProductsQualityIssue> request) throws APIException.MalformedResponseException {
                return ProductsQualityIssue.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ProductsQualityIssue> {
        ProductsQualityIssue lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"count", "description", "issue_type", "property_names", "samples", "summary", "id"};

        @Override
        public ProductsQualityIssue getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ProductsQualityIssue parseResponse(String response) throws APIException {
            return ProductsQualityIssue.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ProductsQualityIssue execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ProductsQualityIssue execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ProductsQualityIssue> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ProductsQualityIssue> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ProductsQualityIssue>(){

                public ProductsQualityIssue apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCountField() {
            return this.requestCountField(true);
        }

        public APIRequestGet requestCountField(boolean value) {
            this.requestField("count", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestIssueTypeField() {
            return this.requestIssueTypeField(true);
        }

        public APIRequestGet requestIssueTypeField(boolean value) {
            this.requestField("issue_type", value);
            return this;
        }

        public APIRequestGet requestPropertyNamesField() {
            return this.requestPropertyNamesField(true);
        }

        public APIRequestGet requestPropertyNamesField(boolean value) {
            this.requestField("property_names", value);
            return this;
        }

        public APIRequestGet requestSamplesField() {
            return this.requestSamplesField(true);
        }

        public APIRequestGet requestSamplesField(boolean value) {
            this.requestField("samples", value);
            return this;
        }

        public APIRequestGet requestSummaryField() {
            return this.requestSummaryField(true);
        }

        public APIRequestGet requestSummaryField(boolean value) {
            this.requestField("summary", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

