/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticsCohortQueryResult
extends APINode {
    @SerializedName(value="data")
    private Object mData = null;
    @SerializedName(value="error")
    private Object mError = null;
    @SerializedName(value="query_id")
    private String mQueryId = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AnalyticsCohortQueryResult() {
    }

    public AnalyticsCohortQueryResult(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AnalyticsCohortQueryResult(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AnalyticsCohortQueryResult fetch() throws APIException {
        AnalyticsCohortQueryResult newInstance = AnalyticsCohortQueryResult.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AnalyticsCohortQueryResult fetchById(Long id, APIContext context) throws APIException {
        return AnalyticsCohortQueryResult.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AnalyticsCohortQueryResult> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AnalyticsCohortQueryResult.fetchByIdAsync(id.toString(), context);
    }

    public static AnalyticsCohortQueryResult fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AnalyticsCohortQueryResult> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AnalyticsCohortQueryResult> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AnalyticsCohortQueryResult>(context, "", "/", "GET", AnalyticsCohortQueryResult.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AnalyticsCohortQueryResult>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AnalyticsCohortQueryResult>(context, "", "/", "GET", AnalyticsCohortQueryResult.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AnalyticsCohortQueryResult loadJSON(String json, APIContext context) {
        AnalyticsCohortQueryResult analyticsCohortQueryResult = (AnalyticsCohortQueryResult)AnalyticsCohortQueryResult.getGson().fromJson(json, AnalyticsCohortQueryResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(analyticsCohortQueryResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        analyticsCohortQueryResult.context = context;
        analyticsCohortQueryResult.rawValue = json;
        return analyticsCohortQueryResult;
    }

    public static APINodeList<AnalyticsCohortQueryResult> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AnalyticsCohortQueryResult> analyticsCohortQueryResults = new APINodeList<AnalyticsCohortQueryResult>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        analyticsCohortQueryResults.add(AnalyticsCohortQueryResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return analyticsCohortQueryResults;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            analyticsCohortQueryResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        analyticsCohortQueryResults.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            analyticsCohortQueryResults.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            analyticsCohortQueryResults.add(AnalyticsCohortQueryResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                analyticsCohortQueryResults.add(AnalyticsCohortQueryResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            analyticsCohortQueryResults.add(AnalyticsCohortQueryResult.loadJSON(obj.toString(), context));
                        }
                    }
                    return analyticsCohortQueryResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        analyticsCohortQueryResults.add(AnalyticsCohortQueryResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return analyticsCohortQueryResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        analyticsCohortQueryResults.add(AnalyticsCohortQueryResult.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return analyticsCohortQueryResults;
                }
                analyticsCohortQueryResults.clear();
                analyticsCohortQueryResults.add(AnalyticsCohortQueryResult.loadJSON(json, context));
                return analyticsCohortQueryResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AnalyticsCohortQueryResult.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Object getFieldData() {
        return this.mData;
    }

    public Object getFieldError() {
        return this.mError;
    }

    public String getFieldQueryId() {
        return this.mQueryId;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AnalyticsCohortQueryResult copyFrom(AnalyticsCohortQueryResult instance) {
        this.mData = instance.mData;
        this.mError = instance.mError;
        this.mQueryId = instance.mQueryId;
        this.mStatus = instance.mStatus;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AnalyticsCohortQueryResult> getParser() {
        return new APIRequest.ResponseParser<AnalyticsCohortQueryResult>(){

            @Override
            public APINodeList<AnalyticsCohortQueryResult> parseResponse(String response, APIContext context, APIRequest<AnalyticsCohortQueryResult> request) throws APIException.MalformedResponseException {
                return AnalyticsCohortQueryResult.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AnalyticsCohortQueryResult> {
        AnalyticsCohortQueryResult lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"data", "error", "query_id", "status", "id"};

        @Override
        public AnalyticsCohortQueryResult getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AnalyticsCohortQueryResult parseResponse(String response) throws APIException {
            return AnalyticsCohortQueryResult.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AnalyticsCohortQueryResult execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AnalyticsCohortQueryResult execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AnalyticsCohortQueryResult> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AnalyticsCohortQueryResult> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AnalyticsCohortQueryResult>(){

                public AnalyticsCohortQueryResult apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDataField() {
            return this.requestDataField(true);
        }

        public APIRequestGet requestDataField(boolean value) {
            this.requestField("data", value);
            return this;
        }

        public APIRequestGet requestErrorField() {
            return this.requestErrorField(true);
        }

        public APIRequestGet requestErrorField(boolean value) {
            this.requestField("error", value);
            return this;
        }

        public APIRequestGet requestQueryIdField() {
            return this.requestQueryIdField(true);
        }

        public APIRequestGet requestQueryIdField(boolean value) {
            this.requestField("query_id", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

