/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserPaymentModulesOptions
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="available_payment_options")
    private List<Object> mAvailablePaymentOptions = null;
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    UserPaymentModulesOptions() {
    }

    public UserPaymentModulesOptions(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public UserPaymentModulesOptions(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public UserPaymentModulesOptions fetch() throws APIException {
        UserPaymentModulesOptions newInstance = UserPaymentModulesOptions.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static UserPaymentModulesOptions fetchById(Long id, APIContext context) throws APIException {
        return UserPaymentModulesOptions.fetchById(id.toString(), context);
    }

    public static ListenableFuture<UserPaymentModulesOptions> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return UserPaymentModulesOptions.fetchByIdAsync(id.toString(), context);
    }

    public static UserPaymentModulesOptions fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<UserPaymentModulesOptions> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<UserPaymentModulesOptions> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<UserPaymentModulesOptions>(context, "", "/", "GET", UserPaymentModulesOptions.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<UserPaymentModulesOptions>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<UserPaymentModulesOptions>(context, "", "/", "GET", UserPaymentModulesOptions.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static UserPaymentModulesOptions loadJSON(String json, APIContext context) {
        UserPaymentModulesOptions userPaymentModulesOptions = (UserPaymentModulesOptions)UserPaymentModulesOptions.getGson().fromJson(json, UserPaymentModulesOptions.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(userPaymentModulesOptions.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        userPaymentModulesOptions.context = context;
        userPaymentModulesOptions.rawValue = json;
        return userPaymentModulesOptions;
    }

    public static APINodeList<UserPaymentModulesOptions> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<UserPaymentModulesOptions> userPaymentModulesOptionss = new APINodeList<UserPaymentModulesOptions>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        userPaymentModulesOptionss.add(UserPaymentModulesOptions.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return userPaymentModulesOptionss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            userPaymentModulesOptionss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        userPaymentModulesOptionss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            userPaymentModulesOptionss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            userPaymentModulesOptionss.add(UserPaymentModulesOptions.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                userPaymentModulesOptionss.add(UserPaymentModulesOptions.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            userPaymentModulesOptionss.add(UserPaymentModulesOptions.loadJSON(obj.toString(), context));
                        }
                    }
                    return userPaymentModulesOptionss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        userPaymentModulesOptionss.add(UserPaymentModulesOptions.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return userPaymentModulesOptionss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        userPaymentModulesOptionss.add(UserPaymentModulesOptions.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return userPaymentModulesOptionss;
                }
                userPaymentModulesOptionss.clear();
                userPaymentModulesOptionss.add(UserPaymentModulesOptions.loadJSON(json, context));
                return userPaymentModulesOptionss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return UserPaymentModulesOptions.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public List<Object> getFieldAvailablePaymentOptions() {
        return this.mAvailablePaymentOptions;
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public UserPaymentModulesOptions copyFrom(UserPaymentModulesOptions instance) {
        this.mAccountId = instance.mAccountId;
        this.mAvailablePaymentOptions = instance.mAvailablePaymentOptions;
        this.mCountry = instance.mCountry;
        this.mCurrency = instance.mCurrency;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<UserPaymentModulesOptions> getParser() {
        return new APIRequest.ResponseParser<UserPaymentModulesOptions>(){

            @Override
            public APINodeList<UserPaymentModulesOptions> parseResponse(String response, APIContext context, APIRequest<UserPaymentModulesOptions> request) throws APIException.MalformedResponseException {
                return UserPaymentModulesOptions.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPaymentType {
        VALUE_PAYMENT_SETTINGS("PAYMENT_SETTINGS"),
        VALUE_IG_PAYMENT_SETTINGS("IG_PAYMENT_SETTINGS"),
        VALUE_UNKNOWN("UNKNOWN"),
        VALUE_MP_PAYMENT_SETTINGS("MP_PAYMENT_SETTINGS"),
        VALUE_IAP_INSTANT_GAME("IAP_INSTANT_GAME"),
        VALUE_IAP_FAN_FUNDING("IAP_FAN_FUNDING"),
        VALUE_IAP_GROUP_SUBSCRIPTION("IAP_GROUP_SUBSCRIPTION"),
        VALUE_MOR_NONE("MOR_NONE"),
        VALUE_MOR_ADS_INVOICE("MOR_ADS_INVOICE"),
        VALUE_MOR_DONATIONS("MOR_DONATIONS"),
        VALUE_MOR_DONATIONS_MATCHING_CONFIRMATION("MOR_DONATIONS_MATCHING_CONFIRMATION"),
        VALUE_MOR_DONATIONS_MATCHING_PLEDGE("MOR_DONATIONS_MATCHING_PLEDGE"),
        VALUE_MOR_OCULUS_CV1("MOR_OCULUS_CV1"),
        VALUE_MOR_OCULUS_LAUNCH_V1("MOR_OCULUS_LAUNCH_V1"),
        VALUE_MOR_OCULUS_LAUNCH_V2("MOR_OCULUS_LAUNCH_V2"),
        VALUE_MOR_OZONE("MOR_OZONE"),
        VALUE_MOR_OPEN_GRAPH_PRODUCT("MOR_OPEN_GRAPH_PRODUCT"),
        VALUE_MOR_MESSENGER_COMMERCE("MOR_MESSENGER_COMMERCE"),
        VALUE_MOR_P2P_TRANSFER("MOR_P2P_TRANSFER"),
        VALUE_MOR_DUMMY_FIRST_PARTY("MOR_DUMMY_FIRST_PARTY"),
        VALUE_MOR_DUMMY_THIRD_PARTY("MOR_DUMMY_THIRD_PARTY"),
        VALUE_MOR_GIFTS("MOR_GIFTS"),
        VALUE_MOR_BILL("MOR_BILL"),
        VALUE_MOR_AIRMAIL("MOR_AIRMAIL"),
        VALUE_MOR_EVENT_TICKETING("MOR_EVENT_TICKETING"),
        VALUE_MOR_PAYMENT_LITE("MOR_PAYMENT_LITE"),
        VALUE_MOR_MESSENGER_API_FEE("MOR_MESSENGER_API_FEE"),
        VALUE_MOR_WORKPLACE_USAGE("MOR_WORKPLACE_USAGE"),
        VALUE_MOR_FACEBOOK_SHOP("MOR_FACEBOOK_SHOP"),
        VALUE_MOR_FAN_FUNDING("MOR_FAN_FUNDING"),
        VALUE_MOR_GAME_TIPPING_TOKEN("MOR_GAME_TIPPING_TOKEN"),
        VALUE_MOR_INSTANT_GAMES("MOR_INSTANT_GAMES"),
        VALUE_MOR_BLUEBIRD("MOR_BLUEBIRD"),
        VALUE_MOR_GROUP_SUBSCRIPTION("MOR_GROUP_SUBSCRIPTION"),
        VALUE_NMOR_UNKNOWN("NMOR_UNKNOWN"),
        VALUE_NMOR_NONE("NMOR_NONE"),
        VALUE_NMOR_PAGES_COMMERCE("NMOR_PAGES_COMMERCE"),
        VALUE_NMOR_COMPONENT_FLOW("NMOR_COMPONENT_FLOW"),
        VALUE_NMOR_BUSINESS_PLATFORM_COMMERCE("NMOR_BUSINESS_PLATFORM_COMMERCE"),
        VALUE_NMOR_SYNCHRONOUS_COMPONENT_FLOW("NMOR_SYNCHRONOUS_COMPONENT_FLOW"),
        VALUE_NMOR_EVENT_TICKETING("NMOR_EVENT_TICKETING"),
        VALUE_NMOR_PLATFORM_SELF_SERVE("NMOR_PLATFORM_SELF_SERVE"),
        VALUE_NMOR_MESSENGER_PLATFORM("NMOR_MESSENGER_PLATFORM"),
        VALUE_NMOR_MESSENGER_OMNIM("NMOR_MESSENGER_OMNIM"),
        VALUE_NMOR_BILLING_ENGINE("NMOR_BILLING_ENGINE"),
        VALUE_NMOR_TIP_JAR("NMOR_TIP_JAR"),
        VALUE_NMOR_INSTANT_EXPERIENCES("NMOR_INSTANT_EXPERIENCES"),
        VALUE_NMOR_CHECKOUT_EXPERIENCES("NMOR_CHECKOUT_EXPERIENCES"),
        VALUE_NMOR_BUY_ON_FACEBOOK("NMOR_BUY_ON_FACEBOOK"),
        VALUE_NMOR_PAYMENT_APP("NMOR_PAYMENT_APP"),
        VALUE_NMOR_DONATION_P4P("NMOR_DONATION_P4P"),
        VALUE_NMOR_WHATSAPP_P2P("NMOR_WHATSAPP_P2P"),
        VALUE_NMOR_P2P("NMOR_P2P"),
        VALUE_NMOR_MOBILE_TOP_UP("NMOR_MOBILE_TOP_UP"),
        VALUE_NMOR_MFS("NMOR_MFS"),
        VALUE_NMOR_SHIPPING_LABEL("NMOR_SHIPPING_LABEL"),
        VALUE_NMOR_MARKETPLACE_DROPOFF("NMOR_MARKETPLACE_DROPOFF"),
        VALUE_NMOR_PAGES_SOLUTION("NMOR_PAGES_SOLUTION"),
        VALUE_NMOR_BLACKBAUD_RWR_DONATION("NMOR_BLACKBAUD_RWR_DONATION"),
        VALUE_NMOR_MARKETPLACE_SHIPPING("NMOR_MARKETPLACE_SHIPPING"),
        VALUE_NMOR_DUMMY("NMOR_DUMMY"),
        VALUE_NMOR_PPGF_DONATION("NMOR_PPGF_DONATION"),
        VALUE_NMOR_ADVERTISER_SUBSCRIPTION("NMOR_ADVERTISER_SUBSCRIPTION"),
        VALUE_NMOR_WHATSAPP_P2M("NMOR_WHATSAPP_P2M"),
        VALUE_NMOR_MOVIE_TICKETING("NMOR_MOVIE_TICKETING"),
        VALUE_IG_NMOR_P2B("IG_NMOR_P2B"),
        VALUE_NMOR_INSTAGRAM_P2B("NMOR_INSTAGRAM_P2B"),
        NULL(null);

        private String value;

        private EnumPaymentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<UserPaymentModulesOptions> {
        UserPaymentModulesOptions lastResponse = null;
        public static final String[] PARAMS = new String[]{"country_code", "extra_data", "order_id", "payment_type", "receiver_id", "session_id"};
        public static final String[] FIELDS = new String[]{"account_id", "available_payment_options", "country", "currency", "id"};

        @Override
        public UserPaymentModulesOptions getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public UserPaymentModulesOptions parseResponse(String response) throws APIException {
            return UserPaymentModulesOptions.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public UserPaymentModulesOptions execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public UserPaymentModulesOptions execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<UserPaymentModulesOptions> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<UserPaymentModulesOptions> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, UserPaymentModulesOptions>(){

                public UserPaymentModulesOptions apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet setCountryCode(String countryCode) {
            this.setParam("country_code", countryCode);
            return this;
        }

        public APIRequestGet setExtraData(String extraData) {
            this.setParam("extra_data", extraData);
            return this;
        }

        public APIRequestGet setOrderId(String orderId) {
            this.setParam("order_id", orderId);
            return this;
        }

        public APIRequestGet setPaymentType(EnumPaymentType paymentType) {
            this.setParam("payment_type", (Object)paymentType);
            return this;
        }

        public APIRequestGet setPaymentType(String paymentType) {
            this.setParam("payment_type", paymentType);
            return this;
        }

        public APIRequestGet setReceiverId(Object receiverId) {
            this.setParam("receiver_id", receiverId);
            return this;
        }

        public APIRequestGet setReceiverId(String receiverId) {
            this.setParam("receiver_id", receiverId);
            return this;
        }

        public APIRequestGet setSessionId(String sessionId) {
            this.setParam("session_id", sessionId);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestAvailablePaymentOptionsField() {
            return this.requestAvailablePaymentOptionsField(true);
        }

        public APIRequestGet requestAvailablePaymentOptionsField(boolean value) {
            this.requestField("available_payment_options", value);
            return this;
        }

        public APIRequestGet requestCountryField() {
            return this.requestCountryField(true);
        }

        public APIRequestGet requestCountryField(boolean value) {
            this.requestField("country", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

