/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackingAndConversionWithDefaults
extends APINode {
    @SerializedName(value="custom_conversion")
    private List<Object> mCustomConversion = null;
    @SerializedName(value="custom_tracking")
    private List<Object> mCustomTracking = null;
    @SerializedName(value="default_conversion")
    private List<Object> mDefaultConversion = null;
    @SerializedName(value="default_tracking")
    private List<Object> mDefaultTracking = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    TrackingAndConversionWithDefaults() {
    }

    public TrackingAndConversionWithDefaults(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public TrackingAndConversionWithDefaults(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public TrackingAndConversionWithDefaults fetch() throws APIException {
        TrackingAndConversionWithDefaults newInstance = TrackingAndConversionWithDefaults.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static TrackingAndConversionWithDefaults fetchById(Long id, APIContext context) throws APIException {
        return TrackingAndConversionWithDefaults.fetchById(id.toString(), context);
    }

    public static ListenableFuture<TrackingAndConversionWithDefaults> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return TrackingAndConversionWithDefaults.fetchByIdAsync(id.toString(), context);
    }

    public static TrackingAndConversionWithDefaults fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<TrackingAndConversionWithDefaults> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<TrackingAndConversionWithDefaults> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<TrackingAndConversionWithDefaults>(context, "", "/", "GET", TrackingAndConversionWithDefaults.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<TrackingAndConversionWithDefaults>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<TrackingAndConversionWithDefaults>(context, "", "/", "GET", TrackingAndConversionWithDefaults.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static TrackingAndConversionWithDefaults loadJSON(String json, APIContext context) {
        TrackingAndConversionWithDefaults trackingAndConversionWithDefaults = (TrackingAndConversionWithDefaults)TrackingAndConversionWithDefaults.getGson().fromJson(json, TrackingAndConversionWithDefaults.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(trackingAndConversionWithDefaults.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        trackingAndConversionWithDefaults.context = context;
        trackingAndConversionWithDefaults.rawValue = json;
        return trackingAndConversionWithDefaults;
    }

    public static APINodeList<TrackingAndConversionWithDefaults> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<TrackingAndConversionWithDefaults> trackingAndConversionWithDefaultss = new APINodeList<TrackingAndConversionWithDefaults>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        trackingAndConversionWithDefaultss.add(TrackingAndConversionWithDefaults.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return trackingAndConversionWithDefaultss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            trackingAndConversionWithDefaultss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        trackingAndConversionWithDefaultss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            trackingAndConversionWithDefaultss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            trackingAndConversionWithDefaultss.add(TrackingAndConversionWithDefaults.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                trackingAndConversionWithDefaultss.add(TrackingAndConversionWithDefaults.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            trackingAndConversionWithDefaultss.add(TrackingAndConversionWithDefaults.loadJSON(obj.toString(), context));
                        }
                    }
                    return trackingAndConversionWithDefaultss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        trackingAndConversionWithDefaultss.add(TrackingAndConversionWithDefaults.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return trackingAndConversionWithDefaultss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        trackingAndConversionWithDefaultss.add(TrackingAndConversionWithDefaults.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return trackingAndConversionWithDefaultss;
                }
                trackingAndConversionWithDefaultss.clear();
                trackingAndConversionWithDefaultss.add(TrackingAndConversionWithDefaults.loadJSON(json, context));
                return trackingAndConversionWithDefaultss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return TrackingAndConversionWithDefaults.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<Object> getFieldCustomConversion() {
        return this.mCustomConversion;
    }

    public List<Object> getFieldCustomTracking() {
        return this.mCustomTracking;
    }

    public List<Object> getFieldDefaultConversion() {
        return this.mDefaultConversion;
    }

    public List<Object> getFieldDefaultTracking() {
        return this.mDefaultTracking;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public TrackingAndConversionWithDefaults copyFrom(TrackingAndConversionWithDefaults instance) {
        this.mCustomConversion = instance.mCustomConversion;
        this.mCustomTracking = instance.mCustomTracking;
        this.mDefaultConversion = instance.mDefaultConversion;
        this.mDefaultTracking = instance.mDefaultTracking;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<TrackingAndConversionWithDefaults> getParser() {
        return new APIRequest.ResponseParser<TrackingAndConversionWithDefaults>(){

            @Override
            public APINodeList<TrackingAndConversionWithDefaults> parseResponse(String response, APIContext context, APIRequest<TrackingAndConversionWithDefaults> request) throws APIException.MalformedResponseException {
                return TrackingAndConversionWithDefaults.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<TrackingAndConversionWithDefaults> {
        TrackingAndConversionWithDefaults lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"custom_conversion", "custom_tracking", "default_conversion", "default_tracking", "id"};

        @Override
        public TrackingAndConversionWithDefaults getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public TrackingAndConversionWithDefaults parseResponse(String response) throws APIException {
            return TrackingAndConversionWithDefaults.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public TrackingAndConversionWithDefaults execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public TrackingAndConversionWithDefaults execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<TrackingAndConversionWithDefaults> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<TrackingAndConversionWithDefaults> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, TrackingAndConversionWithDefaults>(){

                public TrackingAndConversionWithDefaults apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCustomConversionField() {
            return this.requestCustomConversionField(true);
        }

        public APIRequestGet requestCustomConversionField(boolean value) {
            this.requestField("custom_conversion", value);
            return this;
        }

        public APIRequestGet requestCustomTrackingField() {
            return this.requestCustomTrackingField(true);
        }

        public APIRequestGet requestCustomTrackingField(boolean value) {
            this.requestField("custom_tracking", value);
            return this;
        }

        public APIRequestGet requestDefaultConversionField() {
            return this.requestDefaultConversionField(true);
        }

        public APIRequestGet requestDefaultConversionField(boolean value) {
            this.requestField("default_conversion", value);
            return this;
        }

        public APIRequestGet requestDefaultTrackingField() {
            return this.requestDefaultTrackingField(true);
        }

        public APIRequestGet requestDefaultTrackingField(boolean value) {
            this.requestField("default_tracking", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

