/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MerchantReport
extends APINode {
    @SerializedName(value="add_to_cart")
    private Long mAddToCart = null;
    @SerializedName(value="brand")
    private String mBrand = null;
    @SerializedName(value="catalog_segment_id")
    private String mCatalogSegmentId = null;
    @SerializedName(value="catalog_segment_purchase_value")
    private Double mCatalogSegmentPurchaseValue = null;
    @SerializedName(value="category")
    private String mCategory = null;
    @SerializedName(value="date")
    private String mDate = null;
    @SerializedName(value="link_clicks")
    private Long mLinkClicks = null;
    @SerializedName(value="page_id")
    private String mPageId = null;
    @SerializedName(value="product_id")
    private String mProductId = null;
    @SerializedName(value="product_quantity")
    private Long mProductQuantity = null;
    @SerializedName(value="product_total_value")
    private Double mProductTotalValue = null;
    @SerializedName(value="purchase")
    private Long mPurchase = null;
    @SerializedName(value="purchase_value")
    private Double mPurchaseValue = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    MerchantReport() {
    }

    public MerchantReport(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public MerchantReport(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public MerchantReport fetch() throws APIException {
        MerchantReport newInstance = MerchantReport.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static MerchantReport fetchById(Long id, APIContext context) throws APIException {
        return MerchantReport.fetchById(id.toString(), context);
    }

    public static ListenableFuture<MerchantReport> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return MerchantReport.fetchByIdAsync(id.toString(), context);
    }

    public static MerchantReport fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<MerchantReport> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<MerchantReport> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<MerchantReport>(context, "", "/", "GET", MerchantReport.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<MerchantReport>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<MerchantReport>(context, "", "/", "GET", MerchantReport.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static MerchantReport loadJSON(String json, APIContext context) {
        MerchantReport merchantReport = (MerchantReport)MerchantReport.getGson().fromJson(json, MerchantReport.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(merchantReport.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        merchantReport.context = context;
        merchantReport.rawValue = json;
        return merchantReport;
    }

    public static APINodeList<MerchantReport> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<MerchantReport> merchantReports = new APINodeList<MerchantReport>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        merchantReports.add(MerchantReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return merchantReports;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            merchantReports.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        merchantReports.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            merchantReports.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            merchantReports.add(MerchantReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                merchantReports.add(MerchantReport.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            merchantReports.add(MerchantReport.loadJSON(obj.toString(), context));
                        }
                    }
                    return merchantReports;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        merchantReports.add(MerchantReport.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return merchantReports;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        merchantReports.add(MerchantReport.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return merchantReports;
                }
                merchantReports.clear();
                merchantReports.add(MerchantReport.loadJSON(json, context));
                return merchantReports;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MerchantReport.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldAddToCart() {
        return this.mAddToCart;
    }

    public String getFieldBrand() {
        return this.mBrand;
    }

    public String getFieldCatalogSegmentId() {
        return this.mCatalogSegmentId;
    }

    public Double getFieldCatalogSegmentPurchaseValue() {
        return this.mCatalogSegmentPurchaseValue;
    }

    public String getFieldCategory() {
        return this.mCategory;
    }

    public String getFieldDate() {
        return this.mDate;
    }

    public Long getFieldLinkClicks() {
        return this.mLinkClicks;
    }

    public String getFieldPageId() {
        return this.mPageId;
    }

    public String getFieldProductId() {
        return this.mProductId;
    }

    public Long getFieldProductQuantity() {
        return this.mProductQuantity;
    }

    public Double getFieldProductTotalValue() {
        return this.mProductTotalValue;
    }

    public Long getFieldPurchase() {
        return this.mPurchase;
    }

    public Double getFieldPurchaseValue() {
        return this.mPurchaseValue;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MerchantReport copyFrom(MerchantReport instance) {
        this.mAddToCart = instance.mAddToCart;
        this.mBrand = instance.mBrand;
        this.mCatalogSegmentId = instance.mCatalogSegmentId;
        this.mCatalogSegmentPurchaseValue = instance.mCatalogSegmentPurchaseValue;
        this.mCategory = instance.mCategory;
        this.mDate = instance.mDate;
        this.mLinkClicks = instance.mLinkClicks;
        this.mPageId = instance.mPageId;
        this.mProductId = instance.mProductId;
        this.mProductQuantity = instance.mProductQuantity;
        this.mProductTotalValue = instance.mProductTotalValue;
        this.mPurchase = instance.mPurchase;
        this.mPurchaseValue = instance.mPurchaseValue;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MerchantReport> getParser() {
        return new APIRequest.ResponseParser<MerchantReport>(){

            @Override
            public APINodeList<MerchantReport> parseResponse(String response, APIContext context, APIRequest<MerchantReport> request) throws APIException.MalformedResponseException {
                return MerchantReport.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<MerchantReport> {
        MerchantReport lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"add_to_cart", "brand", "catalog_segment_id", "catalog_segment_purchase_value", "category", "date", "link_clicks", "page_id", "product_id", "product_quantity", "product_total_value", "purchase", "purchase_value", "id"};

        @Override
        public MerchantReport getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public MerchantReport parseResponse(String response) throws APIException {
            return MerchantReport.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public MerchantReport execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public MerchantReport execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<MerchantReport> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<MerchantReport> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, MerchantReport>(){

                public MerchantReport apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAddToCartField() {
            return this.requestAddToCartField(true);
        }

        public APIRequestGet requestAddToCartField(boolean value) {
            this.requestField("add_to_cart", value);
            return this;
        }

        public APIRequestGet requestBrandField() {
            return this.requestBrandField(true);
        }

        public APIRequestGet requestBrandField(boolean value) {
            this.requestField("brand", value);
            return this;
        }

        public APIRequestGet requestCatalogSegmentIdField() {
            return this.requestCatalogSegmentIdField(true);
        }

        public APIRequestGet requestCatalogSegmentIdField(boolean value) {
            this.requestField("catalog_segment_id", value);
            return this;
        }

        public APIRequestGet requestCatalogSegmentPurchaseValueField() {
            return this.requestCatalogSegmentPurchaseValueField(true);
        }

        public APIRequestGet requestCatalogSegmentPurchaseValueField(boolean value) {
            this.requestField("catalog_segment_purchase_value", value);
            return this;
        }

        public APIRequestGet requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGet requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGet requestDateField() {
            return this.requestDateField(true);
        }

        public APIRequestGet requestDateField(boolean value) {
            this.requestField("date", value);
            return this;
        }

        public APIRequestGet requestLinkClicksField() {
            return this.requestLinkClicksField(true);
        }

        public APIRequestGet requestLinkClicksField(boolean value) {
            this.requestField("link_clicks", value);
            return this;
        }

        public APIRequestGet requestPageIdField() {
            return this.requestPageIdField(true);
        }

        public APIRequestGet requestPageIdField(boolean value) {
            this.requestField("page_id", value);
            return this;
        }

        public APIRequestGet requestProductIdField() {
            return this.requestProductIdField(true);
        }

        public APIRequestGet requestProductIdField(boolean value) {
            this.requestField("product_id", value);
            return this;
        }

        public APIRequestGet requestProductQuantityField() {
            return this.requestProductQuantityField(true);
        }

        public APIRequestGet requestProductQuantityField(boolean value) {
            this.requestField("product_quantity", value);
            return this;
        }

        public APIRequestGet requestProductTotalValueField() {
            return this.requestProductTotalValueField(true);
        }

        public APIRequestGet requestProductTotalValueField(boolean value) {
            this.requestField("product_total_value", value);
            return this;
        }

        public APIRequestGet requestPurchaseField() {
            return this.requestPurchaseField(true);
        }

        public APIRequestGet requestPurchaseField(boolean value) {
            this.requestField("purchase", value);
            return this;
        }

        public APIRequestGet requestPurchaseValueField() {
            return this.requestPurchaseValueField(true);
        }

        public APIRequestGet requestPurchaseValueField(boolean value) {
            this.requestField("purchase_value", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

