/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppPublisher
extends APINode {
    @SerializedName(value="content_id")
    private String mContentId = null;
    @SerializedName(value="icon_url")
    private String mIconUrl = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="platform")
    private String mPlatform = null;
    @SerializedName(value="store_name")
    private String mStoreName = null;
    @SerializedName(value="store_url")
    private String mStoreUrl = null;
    protected static Gson gson = null;

    AppPublisher() {
    }

    public AppPublisher(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AppPublisher(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AppPublisher fetch() throws APIException {
        AppPublisher newInstance = AppPublisher.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AppPublisher fetchById(Long id, APIContext context) throws APIException {
        return AppPublisher.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AppPublisher> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AppPublisher.fetchByIdAsync(id.toString(), context);
    }

    public static AppPublisher fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AppPublisher> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AppPublisher> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AppPublisher>(context, "", "/", "GET", AppPublisher.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AppPublisher>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AppPublisher>(context, "", "/", "GET", AppPublisher.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AppPublisher loadJSON(String json, APIContext context) {
        AppPublisher appPublisher = (AppPublisher)AppPublisher.getGson().fromJson(json, AppPublisher.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(appPublisher.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        appPublisher.context = context;
        appPublisher.rawValue = json;
        return appPublisher;
    }

    public static APINodeList<AppPublisher> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AppPublisher> appPublishers = new APINodeList<AppPublisher>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        appPublishers.add(AppPublisher.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return appPublishers;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            appPublishers.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        appPublishers.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            appPublishers.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            appPublishers.add(AppPublisher.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                appPublishers.add(AppPublisher.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            appPublishers.add(AppPublisher.loadJSON(obj.toString(), context));
                        }
                    }
                    return appPublishers;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        appPublishers.add(AppPublisher.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return appPublishers;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        appPublishers.add(AppPublisher.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return appPublishers;
                }
                appPublishers.clear();
                appPublishers.add(AppPublisher.loadJSON(json, context));
                return appPublishers;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AppPublisher.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldContentId() {
        return this.mContentId;
    }

    public String getFieldIconUrl() {
        return this.mIconUrl;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldPlatform() {
        return this.mPlatform;
    }

    public String getFieldStoreName() {
        return this.mStoreName;
    }

    public String getFieldStoreUrl() {
        return this.mStoreUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AppPublisher copyFrom(AppPublisher instance) {
        this.mContentId = instance.mContentId;
        this.mIconUrl = instance.mIconUrl;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mPlatform = instance.mPlatform;
        this.mStoreName = instance.mStoreName;
        this.mStoreUrl = instance.mStoreUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AppPublisher> getParser() {
        return new APIRequest.ResponseParser<AppPublisher>(){

            @Override
            public APINodeList<AppPublisher> parseResponse(String response, APIContext context, APIRequest<AppPublisher> request) throws APIException.MalformedResponseException {
                return AppPublisher.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AppPublisher> {
        AppPublisher lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"content_id", "icon_url", "id", "name", "platform", "store_name", "store_url"};

        @Override
        public AppPublisher getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AppPublisher parseResponse(String response) throws APIException {
            return AppPublisher.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AppPublisher execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AppPublisher execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AppPublisher> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AppPublisher> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AppPublisher>(){

                public AppPublisher apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestContentIdField() {
            return this.requestContentIdField(true);
        }

        public APIRequestGet requestContentIdField(boolean value) {
            this.requestField("content_id", value);
            return this;
        }

        public APIRequestGet requestIconUrlField() {
            return this.requestIconUrlField(true);
        }

        public APIRequestGet requestIconUrlField(boolean value) {
            this.requestField("icon_url", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPlatformField() {
            return this.requestPlatformField(true);
        }

        public APIRequestGet requestPlatformField(boolean value) {
            this.requestField("platform", value);
            return this;
        }

        public APIRequestGet requestStoreNameField() {
            return this.requestStoreNameField(true);
        }

        public APIRequestGet requestStoreNameField(boolean value) {
            this.requestField("store_name", value);
            return this;
        }

        public APIRequestGet requestStoreUrlField() {
            return this.requestStoreUrlField(true);
        }

        public APIRequestGet requestStoreUrlField(boolean value) {
            this.requestField("store_url", value);
            return this;
        }
    }
}

