/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdsPixelServerToServerKey
extends APINode {
    @SerializedName(value="key")
    private String mKey = null;
    @SerializedName(value="type")
    private String mType = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdsPixelServerToServerKey() {
    }

    public AdsPixelServerToServerKey(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdsPixelServerToServerKey(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdsPixelServerToServerKey fetch() throws APIException {
        AdsPixelServerToServerKey newInstance = AdsPixelServerToServerKey.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdsPixelServerToServerKey fetchById(Long id, APIContext context) throws APIException {
        return AdsPixelServerToServerKey.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdsPixelServerToServerKey> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdsPixelServerToServerKey.fetchByIdAsync(id.toString(), context);
    }

    public static AdsPixelServerToServerKey fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdsPixelServerToServerKey> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdsPixelServerToServerKey> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdsPixelServerToServerKey>(context, "", "/", "GET", AdsPixelServerToServerKey.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdsPixelServerToServerKey>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdsPixelServerToServerKey>(context, "", "/", "GET", AdsPixelServerToServerKey.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdsPixelServerToServerKey loadJSON(String json, APIContext context) {
        AdsPixelServerToServerKey adsPixelServerToServerKey = (AdsPixelServerToServerKey)AdsPixelServerToServerKey.getGson().fromJson(json, AdsPixelServerToServerKey.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsPixelServerToServerKey.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsPixelServerToServerKey.context = context;
        adsPixelServerToServerKey.rawValue = json;
        return adsPixelServerToServerKey;
    }

    public static APINodeList<AdsPixelServerToServerKey> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsPixelServerToServerKey> adsPixelServerToServerKeys = new APINodeList<AdsPixelServerToServerKey>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsPixelServerToServerKeys.add(AdsPixelServerToServerKey.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adsPixelServerToServerKeys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsPixelServerToServerKeys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsPixelServerToServerKeys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsPixelServerToServerKeys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsPixelServerToServerKeys.add(AdsPixelServerToServerKey.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsPixelServerToServerKeys.add(AdsPixelServerToServerKey.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsPixelServerToServerKeys.add(AdsPixelServerToServerKey.loadJSON(obj.toString(), context));
                        }
                    }
                    return adsPixelServerToServerKeys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsPixelServerToServerKeys.add(AdsPixelServerToServerKey.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adsPixelServerToServerKeys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsPixelServerToServerKeys.add(AdsPixelServerToServerKey.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsPixelServerToServerKeys;
                }
                adsPixelServerToServerKeys.clear();
                adsPixelServerToServerKeys.add(AdsPixelServerToServerKey.loadJSON(json, context));
                return adsPixelServerToServerKeys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsPixelServerToServerKey.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldKey() {
        return this.mKey;
    }

    public String getFieldType() {
        return this.mType;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsPixelServerToServerKey copyFrom(AdsPixelServerToServerKey instance) {
        this.mKey = instance.mKey;
        this.mType = instance.mType;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsPixelServerToServerKey> getParser() {
        return new APIRequest.ResponseParser<AdsPixelServerToServerKey>(){

            @Override
            public APINodeList<AdsPixelServerToServerKey> parseResponse(String response, APIContext context, APIRequest<AdsPixelServerToServerKey> request) throws APIException.MalformedResponseException {
                return AdsPixelServerToServerKey.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdsPixelServerToServerKey> {
        AdsPixelServerToServerKey lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"key", "type", "id"};

        @Override
        public AdsPixelServerToServerKey getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsPixelServerToServerKey parseResponse(String response) throws APIException {
            return AdsPixelServerToServerKey.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdsPixelServerToServerKey execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsPixelServerToServerKey execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdsPixelServerToServerKey> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsPixelServerToServerKey> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdsPixelServerToServerKey>(){

                public AdsPixelServerToServerKey apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestKeyField() {
            return this.requestKeyField(true);
        }

        public APIRequestGet requestKeyField(boolean value) {
            this.requestField("key", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

